/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.exportacao.thread;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.exportacao.integracao.IntegracaoUtil;
import jalis.laboratorio.exportacao.thread.BeanCriaHtmlWeb;
import jalis.laboratorio.exportacao.thread.CamposWeb;
import jalis.laboratorio.exportacao.thread.ComandoLog;
import jalis.laboratorio.exportacao.thread.ExportaWeb;
import jalis.laboratorio.exportacao.thread.ExportaWebException;
import jalis.laboratorio.exportacao.thread.ListaComandosLog;
import jalis.laboratorio.exportacao.thread.MensagemRetornoWs;
import jalis.laboratorio.exportacao.thread.ThreadCriaHtmlWeb;
import jalis.laboratorio.exportacao.util.ExportacaoMonitor;
import jalis.laboratorio.exportacao.util.ExportacaoMonitorListener;
import jalis.laboratorio.resultados.ImpressaoResultados;
import jalis.laboratorio.resultados.RetornoImpressaoResultados;
import jalis.mensagens.VerificaMensagens;
import jalis.model.enums.EnumTipoPDF;
import jalis.model.vo.cadastro.auxiliares.FilialVOAux;
import jalis.service.cadastro.FilialService;
import jalis.service.exportadores.ExportaWebService;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.StringUtil;
import jalis.util.ThreadListener;
import jalis.util.logger.ErrorLogger;
import jalis.util.sql.SalvaDados;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.io.IOException;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;
import javax.swing.event.EventListenerList;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.apache.commons.codec.binary.Base64;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ExportaWeb2
extends Thread
implements ExportacaoMonitorListener {
    public static final String SITUACAO_EXAME_REQUISICAO = "situacaoExameRequisicao";
    public static final String CODIGO_REQUISICAO = "codigoRequisicao";
    public static final String MATERIAL_EXAME_REQUISICAO = "materialExameRequisicao";
    public static final String CODIGO_EXAME_REQUISICAO = "codigoExameRequisicao";
    private static final String COMANDO_WEBSERVICE_PODE_ENVIAR = "podeEnviar";
    private static final String COMANDO_WEBSERVICE_EXECUTAR = "executar";
    private static final String TAG_EXPORTA_WEB = "exportaweb";
    private static final String ATT_IP = "ip";
    private static final String ATT_CODIGO_CLIENTE = "codigoCliente";
    private static final String ATT_QTDE_LOGS = "qtdeLogs";
    private static final String TAG_COMANDO = "comando";
    private static final String TAG_CODIGO = "codigo";
    private static final String TAG_OPERACAO = "operacao";
    private static final String TAG_SELECT = "select";
    private static final String TAG_UPDATE = "update";
    private static final String PHP_SESSION_ID = "phpsessionid";
    private static final String TAG_MENSAGEM = "mensagem";
    private static final String TAG_ERRO_EXPORTA_WEB = "erroexportaweb";
    private static final String TAG_SUCESSO_EXPORTA_WEB = "sucessoexportaweb";
    public static Hashtable CAMPOS;
    public static List<String> camposIgnorar;
    private static final int QUANTIDADE_LOGS_WEB = 350;
    private static final int QUANTIDADE_LOGS_ARQUIVO = 100;
    private boolean parar = false;
    private boolean exportandoDados = false;
    private boolean ignorarFilial = false;
    private boolean automatico = true;
    private boolean mostrarIcones = true;
    private Date ultimaExportacaoValida = new Date();
    private EventListenerList listenerList = new EventListenerList();
    private JProgressBar progresso;
    private JTextArea txtMensagens;
    private static final int TEMPO_ESPERA_DEFAULT = 5000;
    public ExportacaoMonitor exportacaoMonitor = new ExportacaoMonitor();
    private long tempoEspera = 0L;
    private int totalParaEnviar = 0;
    private Date tempoIteracaoAnterior = null;
    private long mediaTempoIteracoes = 0L;
    private static final int TIMEOUT_CONEXAO = 5000;
    private static final int TIMEOUT_LEITURA = 120000;
    private static final String IP_WEBSERVICE = "www.resultadosonline.com.br";
    private static final String PORTA_WEBSERVICE = "80";
    private static final String CAMINHO_PAGINA_WEBSERVICE = "soap/server2.php?wsdl";
    private static final int TAMANHO_MAXIMO_MENSAGEM;
    private static boolean debug;
    private static boolean ignorarDelete;
    private static final String CONTROLE_EXPORTA_WEB = "phpSessionId";
    public static final String CHAVE_REQUISICAOEXAMERESULTADO = "requisicaoexameresultado";
    public static final String CHAVE_REQUISICAOEXAMERESULTADOPAGINA = "requisicaoexameresultadopagina";
    public static final String CHAVE_REQUISICAOPDF = "requisicaopdf";
    public static final String GRUPO_EXAMES_PACIENTE = "paciente";
    public static final String GRUPO_EXAMES_MEDICO = "medico";
    public static final String GRUPO_EXAMES_CONVENIO = "convenio";
    public static final String PDF_PACIENTE = "pdfPaciente";
    public static final String PDF_MEDICO = "pdfMedico";
    public static final String PDF_CONVENIO = "pdfConvenio";
    public static final String PDF_DESTINO = "pdfDestino";
    public static final String PDF_EXAME = "pdfExame";
    public static final String PDF_FISCAL = "pdfFiscal";
    public static final String PDF_RESPONSAVEL = "pdfResponsavel";
    public static final String PDF_TODOS_IGUAIS = "todosIguais";
    public static final String TAG_FILIAL = "filial";
    private int qtdeEnviadaAnterior = 0;
    HashMap<Integer, String> listaBasesWeb = new HashMap();
    String filialBaseWeb = null;

    public void setFilialBaseWeb(int filialBaseWeb) {
        this.filialBaseWeb = filialBaseWeb + "";
    }

    public ExportaWeb2() {
        super("Thread - ExportaWeb");
        this.setPriority(1);
        if (debug) {
            System.out.println("Nova exporta web");
        }
        this.setIgnorarFiliais(true);
        if (!ignorarDelete) {
            this.apagaLogsAntigos();
        }
        this.tempoEspera = this.getTempoEsperaExportaWeb();
        this.exportacaoMonitor.addExportacaoListener(Laboratorio.getJanelaMonitoramentoExpoWeb());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void apagaLogsAntigos() {
        Statement st = Conexao.getStatement();
        StringBuilder del = new StringBuilder();
        del.append(" delete from exportaweb ");
        del.append("  where ewe_datahora < current_date - 1 ");
        del.append("    and ewe_exportado ");
        try {
            Conexao.execute(this.filialBaseWeb == null ? Variaveis.filialPadrao : this.filialBaseWeb, st, del);
            Conexao.arquivaSQL();
        }
        catch (Exception ex) {
            try {
                try {
                    Conexao.anulaSQL();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.fireIniciouExecucao();
        int registros = 0;
        while (!this.parar) {
            block29: {
                Statement st = null;
                try {
                    if (this.totalParaEnviar == 0) {
                        this.limpaVariaveis();
                    }
                    if (st == null) {
                        st = Conexao.getStatement();
                    }
                    this.mostraMensagem("Buscando dados para exportar...");
                    this.totalParaEnviar = this.buscaTotalParaExportar(st, this.ignorarFilial);
                    ResultSet rs = this.getLogsEnviar(st);
                    registros = DBUtil.qtdeRegistros(rs);
                    boolean contador = true;
                    if (registros > 0) {
                        this.atualizaMonitorExportacao("H\u00e1 logs para exportar.", null, registros);
                        this.atualizaTempoEntreIteracoes(this.qtdeEnviadaAnterior);
                        if (this.mostrarIcones) {
                            Laboratorio.setIconeEstacao(ImagemUtils.carregaImagemJalis("enviando_internet_on.gif"));
                        }
                        if (ParametrosGerais.getWebArquivo() && registros > 0) {
                            this.exportaWebArquivos(rs, registros);
                        } else {
                            this.exportaWebBaseWeb(rs, registros);
                        }
                    } else {
                        if (this.mostrarIcones) {
                            Laboratorio.setIconeEstacao(ImagemUtils.carregaImagemJalis("enviando_internet_off.gif"));
                        }
                        this.atualizaMonitorExportacao("N\u00e3o h\u00e1 logs para exportar.", null, registros);
                        this.atualizaTempoEntreIteracoes(this.qtdeEnviadaAnterior);
                    }
                    this.validaTempoSemExportacao();
                    this.exportandoDados = false;
                }
                catch (ExportaWebException e) {
                    try {
                        if (this.mostrarIcones) {
                            Laboratorio.setIconeEstacao(ImagemUtils.carregaImagemJalis("enviando_internet_erro.gif"));
                            VerificaMensagens.mostraErro(Laboratorio.getInstancia(), "Um erro ocorreu ao tentar exportar para web.\n" + e.getMessage());
                        } else {
                            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
                        }
                        this.mostraMensagem("Um erro ocorreu ao tentar exportar para web.\n" + e.getMessage());
                        this.exportandoDados = false;
                    }
                    catch (Throwable throwable) {
                        block30: {
                            this.exportandoDados = false;
                            Conexao.fecharStatement(st);
                            if (!this.automatico) {
                                this.parar();
                            } else {
                                this.exportacaoMonitor.setTempoProximaIteracao(this.getTempoEsperaExportaWeb());
                                try {
                                    ExportaWeb2.sleep(this.tempoEspera);
                                }
                                catch (InterruptedException e2) {
                                    if (this.mostrarIcones) {
                                        Laboratorio.setIconeEstacao(ImagemUtils.carregaImagemJalis("enviando_internet_erro.gif"));
                                        VerificaMensagens.mostraErro(Laboratorio.getInstancia(), "Um erro ocorreu ao manipular a thread de envio para web.\n" + e2.getMessage());
                                        break block30;
                                    }
                                    ErrorLogger.mostraMensagem(null, e2.getMessage(), e2.getStackTrace());
                                }
                            }
                        }
                        throw throwable;
                    }
                    Conexao.fecharStatement(st);
                    if (!this.automatico) {
                        this.parar();
                    }
                    this.exportacaoMonitor.setTempoProximaIteracao(this.getTempoEsperaExportaWeb());
                    try {
                        ExportaWeb2.sleep(this.tempoEspera);
                    }
                    catch (InterruptedException e3) {
                        if (this.mostrarIcones) {
                            Laboratorio.setIconeEstacao(ImagemUtils.carregaImagemJalis("enviando_internet_erro.gif"));
                            VerificaMensagens.mostraErro(Laboratorio.getInstancia(), "Um erro ocorreu ao manipular a thread de envio para web.\n" + e3.getMessage());
                            break block29;
                        }
                        ErrorLogger.mostraMensagem(null, e3.getMessage(), e3.getStackTrace());
                    }
                }
                Conexao.fecharStatement(st);
                if (!this.automatico) {
                    this.parar();
                } else {
                    this.exportacaoMonitor.setTempoProximaIteracao(this.getTempoEsperaExportaWeb());
                    try {
                        ExportaWeb2.sleep(this.tempoEspera);
                    }
                    catch (InterruptedException e) {
                        if (this.mostrarIcones) {
                            Laboratorio.setIconeEstacao(ImagemUtils.carregaImagemJalis("enviando_internet_erro.gif"));
                            VerificaMensagens.mostraErro(Laboratorio.getInstancia(), "Um erro ocorreu ao manipular a thread de envio para web.\n" + e.getMessage());
                            break block29;
                        }
                        ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
                    }
                }
            }
            if (this.txtMensagens == null) continue;
            this.txtMensagens.setText(null);
        }
        this.limpaVariaveis();
        this.mostraMensagem("Finalizando conex\u00f5es");
        this.fireTerminouExecucao();
    }

    private ResultSet getLogsEnviar(Statement st) throws ExportaWebException {
        try {
            return st.executeQuery(this.getSelect(ParametrosGerais.getWebArquivo()));
        }
        catch (Exception e) {
            throw new ExportaWebException(e, "N\u00e3o foi poss\u00edvel buscar os logs a serem enviados.", null);
        }
    }

    private long getTempoEsperaExportaWeb() {
        String tempo = ParametrosLocais.getParametro("tempoExportacaoWeb");
        if (Funcoes.isNumeric(tempo) && Integer.parseInt(tempo) > 0) {
            return Integer.parseInt(tempo) * 1000;
        }
        return 5000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportaWebBaseWeb(ResultSet rs, int registros) throws ExportaWebException {
        this.mostraMensagem("Iniciando processo de envio de dados para web...");
        this.mostraMensagem("Enviando pedido de conex\u00e3o para o webservice...");
        Map<String, Boolean> podeConectar = this.podeConectarWS(ParametrosGerais.getCodigoCliente());
        if (!podeConectar.get("conecta").booleanValue()) {
            if (this.mostrarIcones && podeConectar.get("imgErro").booleanValue()) {
                Laboratorio.setIconeEstacao(ImagemUtils.carregaImagemJalis("enviando_internet_erro.gif"));
            }
            this.mostraMensagem("O webservice recusou o pedido de conex\u00e3o.");
            return;
        }
        try {
            ArrayList<ComandoLog> listaComandos;
            this.exportandoDados = true;
            if (this.progresso != null) {
                this.progresso.setMaximum(registros);
            }
            this.atualizaMonitorExportacao("Carregando informa\u00e7\u00f5es...", null, registros);
            ListaComandosLog comandosEnviados = new ListaComandosLog();
            String mensagemLogsWs = this.montaMensagemLogsWs(rs, comandosEnviados, registros);
            this.atualizaMonitorExportacao("Enviando dados. Aguarde...", comandosEnviados == null || comandosEnviados.getListaComandos() == null ? 0 : comandosEnviados.getListaComandos().size(), registros);
            this.qtdeEnviadaAnterior = comandosEnviados == null || comandosEnviados.getListaComandos() == null ? 0 : comandosEnviados.getListaComandos().size();
            MensagemRetornoWs retornoWsOK = this.getRetornoMensagemLogsWs(ExportaWeb2.enviaMensagemRecebeRetornoSOAP(IP_WEBSERVICE, PORTA_WEBSERVICE, COMANDO_WEBSERVICE_EXECUTAR, mensagemLogsWs, false), comandosEnviados);
            if (!retornoWsOK.isErro()) {
                this.atualizaMonitorExportacao("Marcando logs como exportados.", null, null);
                Statement st = Conexao.getStatement();
                listaComandos = comandosEnviados.getListaComandos();
                if (!this.verificaUltimoComandoLog(listaComandos, retornoWsOK.getComandoLog())) {
                    throw new ExportaWebException(null, "O \u00faltimo comando processado pelo webservice (Filial: \"" + retornoWsOK.getComandoLog().getCodigoFilial() + "\", c\u00f3digo: \"" + retornoWsOK.getComandoLog().getCodigoLog() + "\") n\u00e3o coincide com o \u00faltimo comando enviado.", null);
                }
                this.mostraMensagem("Dados enviados confirmados com sucesso.");
                for (ComandoLog comando : listaComandos) {
                    this.marcaExportado(st, comando);
                }
                try {
                    if (this.mostrarIcones) {
                        Laboratorio.setIconeEstacao(ImagemUtils.carregaImagemJalis("enviando_internet_off.gif"));
                    }
                    Conexao.arquivaSQL();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    if (this.mostrarIcones) {
                        Laboratorio.setIconeEstacao(ImagemUtils.carregaImagemJalis("enviando_internet_erro.gif"));
                    }
                    throw new ExportaWebException(e, "N\u00e3o foi poss\u00edvel commitar as altera\u00e7\u00f5es.", null);
                }
                if (this.progresso != null) {
                    this.progresso.setValue(this.progresso.getValue() + listaComandos.size());
                }
            } else {
                throw new ExportaWebException(null, retornoWsOK.toString(), retornoWsOK.getComandoLog() != null ? retornoWsOK.getComandoLog().getOperacao() : null);
            }
            Laboratorio.setHintEstacao("Enviando: " + String.valueOf(listaComandos.size()) + " de " + String.valueOf(registros) + " de um total de " + String.valueOf(this.totalParaEnviar));
            this.atualizaMonitorExportacao("Logs marcados como exportados com sucesso.", listaComandos.size(), registros);
            this.mostraMensagem("Arquivando dados.");
            this.ultimaExportacaoValida = new Date();
            if (this.progresso != null) {
                this.progresso.setValue(0);
            }
            if (this.mostrarIcones) {
                Laboratorio.setIconeEstacao(ImagemUtils.carregaImagemJalis("enviando_internet_off.gif"));
            }
        }
        catch (ExportaWebException ex) {
            ex.printStackTrace();
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            if (this.mostrarIcones) {
                Laboratorio.setIconeEstacao(ImagemUtils.carregaImagemJalis("enviando_internet_erro.gif"));
                VerificaMensagens.mostraErro(Laboratorio.getInstancia(), ex.getMessage());
            } else {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            }
            this.mostraMensagem("N\u00e3o foi poss\u00edvel enviar os dados para web." + ex.getMessage());
        }
        finally {
            this.exportandoDados = false;
            this.mostraMensagem("Processo de envio de dados para web finalizado.");
        }
    }

    private boolean verificaUltimoComandoLog(ArrayList<ComandoLog> listaComandos, ComandoLog comandoLog) {
        ComandoLog ultimoEnviado = listaComandos.get(listaComandos.size() - 1);
        return ultimoEnviado.equals(comandoLog);
    }

    private MensagemRetornoWs getRetornoMensagemLogsWs(String retornoWs, ListaComandosLog listaComandos) throws ExportaWebException {
        if (Funcoes.textoVazio(retornoWs)) {
            throw new ExportaWebException(null, "O webservice retornou uma mensagem VAZIA.", null);
        }
        String tagErroExportaWeb = StringUtil.getValor(retornoWs, TAG_ERRO_EXPORTA_WEB);
        String tagSucessoExportaWeb = StringUtil.getValor(retornoWs, TAG_SUCESSO_EXPORTA_WEB);
        if (!Funcoes.textoVazio(tagErroExportaWeb)) {
            String filial = StringUtil.getValor(tagErroExportaWeb, TAG_FILIAL);
            String codigo = StringUtil.getValor(tagErroExportaWeb, TAG_CODIGO);
            String mensagem = StringUtil.getValor(tagErroExportaWeb, TAG_MENSAGEM);
            if (Funcoes.textoVazio(mensagem)) {
                mensagem = "O webservice retornou uma mensagem de erro VAZIA.";
            }
            return new MensagemRetornoWs(true, listaComandos.getComandoLog(filial, codigo), mensagem);
        }
        if (!Funcoes.textoVazio(tagSucessoExportaWeb)) {
            String filial = StringUtil.getValor(tagSucessoExportaWeb, TAG_FILIAL);
            String codigo = StringUtil.getValor(tagSucessoExportaWeb, TAG_CODIGO);
            return new MensagemRetornoWs(false, listaComandos.getComandoLog(filial, codigo), null);
        }
        if (!"4".equals(retornoWs.trim())) {
            throw new ExportaWebException(null, "O webservice retornou erro, mas, n\u00e3o foi poss\u00edvel obter as informa\u00e7\u00f5es do log. Mensagem recebida: \"" + retornoWs + "\".", null);
        }
        String tagErroExportaWeb2 = StringUtil.getValor(retornoWs, TAG_ERRO_EXPORTA_WEB);
        String filial = StringUtil.getValor(tagErroExportaWeb, TAG_FILIAL);
        String codigo = StringUtil.getValor(tagErroExportaWeb, TAG_CODIGO);
        String mensagem = "Aguardando Fila do Servidor";
        return new MensagemRetornoWs(true, listaComandos.getComandoLog(filial, codigo), mensagem);
    }

    private String montaMensagemLogsWs(ResultSet rs, ListaComandosLog comandosLog, int qtdeLogs) throws ExportaWebException {
        XMLStringBuilder xmlMensagem = new XMLStringBuilder();
        XMLStringBuilder xmlComandos = new XMLStringBuilder();
        try {
            int i = 1;
            while (rs.next()) {
                String filial = rs.getString("fil_codigo");
                String codigo = rs.getString("ewe_codigo");
                String xmlExportaWeb = this.getOperacao(filial, codigo);
                List<ComandoLog> comando = this.criaComando(filial, codigo, xmlExportaWeb = StringUtil.tratarUnicode(xmlExportaWeb, true), rs.getString("ewe_tipooperacao"));
                if (comando != null) {
                    for (ComandoLog comandoLog : comando) {
                        if (comandoLog == null || Funcoes.textoVazio(comandoLog.getOperacao()) && Funcoes.textoVazio(comandoLog.getSelect()) && Funcoes.textoVazio(comandoLog.getUpdate())) continue;
                        xmlComandos.abrir(TAG_COMANDO);
                        xmlComandos.escrever(TAG_FILIAL, filial);
                        xmlComandos.escrever(TAG_CODIGO, codigo);
                        xmlComandos.escreverCData(TAG_OPERACAO, comandoLog.getOperacao());
                        xmlComandos.escreverCData(TAG_SELECT, comandoLog.getSelect());
                        xmlComandos.escreverCData(TAG_UPDATE, comandoLog.getUpdate());
                        comandosLog.addComandoLog(comandoLog);
                        try {
                            xmlComandos.fechar(TAG_COMANDO);
                        }
                        catch (XMLStringBuilderException e) {
                            e.printStackTrace();
                            throw new ExportaWebException(e, "N\u00e3o foi poss\u00edvel fechar o XML da opera\u00e7\u00e3o.", null);
                        }
                    }
                }
                this.atualizaMonitorExportacao(null, i++, null);
                if (xmlComandos.getXML().length() <= TAMANHO_MAXIMO_MENSAGEM) continue;
                break;
            }
            HashMap<String, String> mapaAtributosExportaWeb = new HashMap<String, String>();
            mapaAtributosExportaWeb.put(ATT_CODIGO_CLIENTE, ParametrosGerais.getCodigoCliente() + "");
            mapaAtributosExportaWeb.put(ATT_QTDE_LOGS, comandosLog.getListaComandos().size() + "");
            mapaAtributosExportaWeb.put(PHP_SESSION_ID, ParametrosLocais.getParametro(CONTROLE_EXPORTA_WEB));
            try {
                mapaAtributosExportaWeb.put(ATT_IP, InetAddress.getLocalHost().getHostAddress());
            }
            catch (UnknownHostException e) {
                throw new ExportaWebException(e, "N\u00e3o foi poss\u00edvel obter o IP da esta\u00e7\u00e3o.", null);
            }
            xmlMensagem.abrir(TAG_EXPORTA_WEB, mapaAtributosExportaWeb);
        }
        catch (SQLException e) {
            throw new ExportaWebException(e, "N\u00e3o foi poss\u00edvel montar o XML das opera\u00e7\u00f5es.", null);
        }
        return xmlMensagem.getXML() + xmlComandos.getXML() + "</" + TAG_EXPORTA_WEB + ">";
    }

    private void atualizaMonitorExportacao(String xmlExportaWeb, Integer contador, Integer qtdeRegistros) {
        this.exportacaoMonitor.setQuantidadeParaEnviar(this.totalParaEnviar);
        this.exportacaoMonitor.setOperacaoAtual(xmlExportaWeb);
        if (contador != null) {
            this.exportacaoMonitor.setLogAtual(contador);
        }
        if (qtdeRegistros != null) {
            this.exportacaoMonitor.setQuantidadeLogEnvio(qtdeRegistros);
        }
    }

    private Map<String, Boolean> podeConectarWS(long codigoCliente) throws ExportaWebException {
        String resposta = ExportaWeb2.enviaMensagemRecebeRetornoSOAP(IP_WEBSERVICE, PORTA_WEBSERVICE, COMANDO_WEBSERVICE_PODE_ENVIAR, this.montaMensagemConectarWs(String.valueOf(codigoCliente)), true);
        HashMap<String, Boolean> maps = new HashMap<String, Boolean>();
        boolean conecta = false;
        boolean imgErro = true;
        Object logInicial = null;
        Object logFinal = null;
        if (!Funcoes.textoVazio(resposta) && Funcoes.isNumeric(resposta)) {
            Integer respostaAux = Integer.parseInt(resposta);
            boolean retorno = false;
            if (respostaAux.equals(RetornoPedidoEnvioWebservice.NAO_PERMITIDO.codigo)) {
                this.mostraMensagem("Envio n\u00e3o permitido.");
                conecta = false;
                imgErro = true;
            } else if (respostaAux.equals(RetornoPedidoEnvioWebservice.CODIGO_CLIENTE_INVALIDO.codigo)) {
                this.mostraMensagem("Cliente Inv\u00e1lido.");
                conecta = false;
                imgErro = true;
            } else if (respostaAux.equals(RetornoPedidoEnvioWebservice.PARAMETRO_INCORRETO.codigo)) {
                this.mostraMensagem("Par\u00e2metro incorreto.");
                conecta = false;
                imgErro = true;
            } else if (respostaAux.equals(RetornoPedidoEnvioWebservice.PERMITIDO.codigo)) {
                this.mostraMensagem("Envio permitido.");
                conecta = true;
                imgErro = false;
            } else if (respostaAux.equals(RetornoPedidoEnvioWebservice.PARAMETRO_SESSION_PROCESSANDO.codigo)) {
                this.mostraMensagem("Cliente est\u00e1 processando, aguadando na fila.");
                conecta = false;
                imgErro = false;
            } else {
                this.mostraMensagem("Retorno do webservice incorreto.");
                conecta = false;
                imgErro = true;
            }
        } else if (!Funcoes.textoVazio(resposta) && resposta.length() == 26) {
            ParametrosLocais.setParametro(CONTROLE_EXPORTA_WEB, resposta);
            ParametrosLocais.salvaParametros();
            this.mostraMensagem("Conex\u00e3o estabelecida.");
            conecta = true;
            imgErro = false;
        } else {
            this.mostraMensagem("O retorno do webservice \u00e9 inv\u00e1lido.");
            conecta = false;
            imgErro = true;
        }
        maps.put("conecta", conecta);
        maps.put("imgErro", imgErro);
        return maps;
    }

    private void atualizaLogFinalizado(String logInicial, String logFinal, String filial) throws ExportaWebException {
        Statement st = null;
        try {
            st = Conexao.getStatement();
            StringBuilder buf = new StringBuilder();
            buf.append(" update exportaweb ");
            buf.append("    set ewe_exportado = true ");
            if (filial != null) {
                buf.append("  where fil_codigo = ").append(filial);
                buf.append("    and ewe_codigo >= ").append(logInicial);
                buf.append("    and ewe_codigo <= ").append(logFinal);
            } else {
                buf.append("  where ");
                buf.append("    ewe_codigo >= ").append(logInicial);
                buf.append("    and ewe_codigo <= ").append(logFinal);
            }
            buf.append("    and ewe_exportado = false ");
            Conexao.executeUpdate(filial, st, buf.toString(), true);
            Conexao.arquivaSQL();
        }
        catch (SQLException e) {
            throw new ExportaWebException(e, "N\u00e3o foi poss\u00edvel marcar o log como exportado. Filial: \"" + filial + "\", c\u00f3digo: \"" + logInicial + " -> " + logFinal + "\".", null);
        }
        finally {
            try {
                st.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    private String montaMensagemConectarWs(String codigoCliente) throws ExportaWebException {
        return this.embaralhaCodigoCliente(codigoCliente);
    }

    private String embaralhaCodigoCliente(String codigoCliente) throws ExportaWebException {
        if (Funcoes.textoVazio(codigoCliente)) {
            throw new ExportaWebException(null, "O c\u00f3digo do cliente n\u00e3o foi informado.", null);
        }
        if (codigoCliente.length() != 4) {
            throw new ExportaWebException(null, "C\u00f3digo do cliente inv\u00e1lido. C\u00f3digo = " + codigoCliente + ".", null);
        }
        String retorno = "";
        for (int i = 0; i < 4; ++i) {
            String digito = codigoCliente.substring(i, i + 1);
            if (retorno.length() > 0) {
                retorno = retorno + ".";
            }
            if (i == 0 || i == 3) {
                retorno = retorno + "000" + digito;
                continue;
            }
            if (i == 1) {
                retorno = retorno + digito + "000";
                continue;
            }
            if (i != 2) continue;
            retorno = retorno + "00" + digito + "0";
        }
        return retorno;
    }

    private void limpaVariaveis() {
        this.ultimaExportacaoValida = new Date();
        this.atualizaMonitorExportacao(null, 0, 0);
        this.mediaTempoIteracoes = 0L;
        this.tempoIteracaoAnterior = null;
    }

    private void exportaWebArquivos(ResultSet rs, int registros) {
        if (Funcoes.textoVazio(ParametrosLocais.getParametro("webArquivo")) || Funcoes.diretorioExiste(ParametrosLocais.getParametro("webArquivo"))) {
            if (this.mostrarIcones) {
                Laboratorio.setIconeEstacao(ImagemUtils.carregaImagemJalis("enviando_internet_on.gif"));
            }
            this.mostraMensagem("Criando arquivos para exporta\u00e7\u00e3o para Internet.");
            Statement stUpdate = Conexao.getStatement();
            String operacao = null;
            try {
                int contador = 0;
                while (rs.next()) {
                    this.atualizaTempoEntreIteracoes(null);
                    operacao = this.getOperacao(rs.getString("fil_codigo"), rs.getString("ewe_codigo"));
                    String tipoOperacao = rs.getString("ewe_tipooperacao");
                    if (!Funcoes.textoVazio(operacao)) {
                        String path = ParametrosLocais.getParametro("webArquivo");
                        if (!path.endsWith("/")) {
                            path = path + "/";
                        }
                        String arquivo = "w" + tipoOperacao + Funcoes.preencheZero(rs.getString("ewe_codigo"), 10) + ".xml";
                        while (Funcoes.arquivoExiste(path + arquivo)) {
                            arquivo = "w" + tipoOperacao + Funcoes.preencheZero(rs.getString("ewe_codigo"), 10) + "_.xml";
                        }
                        this.mostraMensagem("Criando arquivo " + arquivo);
                        StringUtil.escreverArquivoTexto(path + arquivo, operacao);
                        this.marcaExportado(stUpdate, new ComandoLog(rs.getString("fil_codigo"), rs.getString("ewe_codigo"), null, null, null, null, null));
                        Laboratorio.setHintEstacao("Enviando: " + String.valueOf(contador++) + " de " + String.valueOf(registros) + " de um total de " + String.valueOf(this.totalParaEnviar));
                        this.exportacaoMonitor.setQuantidadeParaEnviar(this.totalParaEnviar);
                        this.exportacaoMonitor.setOperacaoAtual(operacao);
                        this.exportacaoMonitor.setLogAtual(contador - 1);
                        this.exportacaoMonitor.setQuantidadeLogEnvio(registros);
                    }
                    try {
                        ExportaWeb2.sleep(10L);
                    }
                    catch (Exception exception) {}
                }
                this.mostraMensagem("Arquivando dados");
                Conexao.arquivaSQL();
                this.ultimaExportacaoValida = new Date();
                if (this.progresso != null) {
                    this.progresso.setValue(0);
                }
                if (this.mostrarIcones) {
                    Laboratorio.setIconeEstacao(ImagemUtils.carregaImagemJalis("enviando_internet_off.gif"));
                }
            }
            catch (Exception ex) {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                if (this.mostrarIcones) {
                    Laboratorio.setIconeEstacao(ImagemUtils.carregaImagemJalis("enviando_internet_erro.gif"));
                    VerificaMensagens.mostraErro(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel enviar resultados para internet");
                }
                Laboratorio.setHintEstacao(ex.getMessage());
                ErrorLogger.mostraMensagem(null, ex.getMessage() + "\n(" + operacao + ")", ex.getStackTrace());
            }
            if (this.mostrarIcones) {
                Laboratorio.setIconeEstacao(ImagemUtils.carregaImagemJalis("enviando_internet_off.gif"));
            }
        } else if (this.mostrarIcones) {
            Laboratorio.setIconeEstacao(ImagemUtils.carregaImagemJalis("enviando_internet_erro.gif"));
            Laboratorio.setHintEstacao("Diret\u00f3rio n\u00e3o localizado");
            VerificaMensagens.mostraErro(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel enviar resultados para internet. Diret\u00f3rio n\u00e3o localizado");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validaTempoSemExportacao() {
        if (Funcoes.diferencaEmHoras(this.ultimaExportacaoValida, new Date()) > 0) {
            Statement st = Conexao.getStatement();
            Statement st2 = Conexao.getStatement();
            try {
                String sql = " select usr_codigo from usuario where usr_inativo = false and usr_mensagemweb = true ";
                ResultSet rs = st.executeQuery(sql);
                while (rs.next()) {
                    this.enviarMensagemErroUsuario(st2, Funcoes.textoVazio(Variaveis.login) ? rs.getString(1) : Variaveis.login, rs.getString(1));
                }
                VerificaMensagens.mostraErro(Laboratorio.getInstancia(), "Verifique a exporta\u00e7\u00e3o para web, o sistema esta a muito tempo sem exportar dados.");
            }
            catch (Exception e) {
                try {
                    ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    Conexao.fecharStatement(st2);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
                Conexao.fecharStatement(st2);
            }
            Conexao.fecharStatement(st);
            Conexao.fecharStatement(st2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enviarMensagemErroUsuario(Statement st, String usuarioOrigem, String usuarioDestino) {
        try {
            SalvaDados salvar = new SalvaDados("usuariomensagem", 0);
            salvar.adicionaCampo("usr_codorigem", 0, false, false, usuarioOrigem);
            salvar.adicionaCampo("usr_coddestino", 0, false, false, usuarioDestino);
            salvar.adicionaCampo("ume_assunto", 0, false, false, "Erro de exporta\u00e7\u00e3o para web");
            salvar.adicionaCampo("ume_mensagem", 0, false, false, "Verifique a exporta\u00e7\u00e3o para web, pois a mesma esta sem enviar resultados a muito tempo");
            salvar.adicionaCampo("ume_confirmarleitura", 4, false, false, false);
            String comando = salvar.getComando();
            Conexao.execute(st, comando);
            Conexao.arquivaSQL();
        }
        catch (Exception e) {
            try {
                try {
                    Conexao.anulaSQL();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
    }

    public void parar() {
        this.parar = true;
    }

    public boolean exportando() {
        return this.exportandoDados;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private List<ComandoLog> criaComando(String codigoFilial, String codigoLog, String xmlExportaWeb, String tipo) throws ExportaWebException {
        Statement st;
        block41: {
            String tmp;
            ArrayList<ComandoLog> retorno;
            block40: {
                block39: {
                    block38: {
                        block37: {
                            block36: {
                                block35: {
                                    block34: {
                                        block33: {
                                            block32: {
                                                block31: {
                                                    block42: {
                                                        Object stPdf;
                                                        block29: {
                                                            ArrayList<ComandoLog> arrayList;
                                                            block30: {
                                                                block28: {
                                                                    block27: {
                                                                        block26: {
                                                                            block25: {
                                                                                block24: {
                                                                                    ArrayList<ComandoLog> arrayList2;
                                                                                    st = Conexao.getStatement();
                                                                                    retorno = new ArrayList<ComandoLog>();
                                                                                    try {
                                                                                        tmp = StringUtil.getValor(xmlExportaWeb, "configuracao");
                                                                                        if (Funcoes.textoVazio(tmp)) break block24;
                                                                                        retorno.add(this.montaComando(codigoFilial, codigoLog, st, xmlExportaWeb, "A", "configuracao"));
                                                                                        arrayList2 = retorno;
                                                                                    }
                                                                                    catch (Throwable throwable) {
                                                                                        Conexao.fecharStatement(st);
                                                                                        throw throwable;
                                                                                    }
                                                                                    Conexao.fecharStatement(st);
                                                                                    return arrayList2;
                                                                                }
                                                                                tmp = StringUtil.getValor(xmlExportaWeb, "convenios");
                                                                                if (Funcoes.textoVazio(tmp)) break block25;
                                                                                retorno.add(this.montaComando(codigoFilial, codigoLog, st, xmlExportaWeb, tipo, "convenios"));
                                                                                ArrayList<ComandoLog> arrayList3 = retorno;
                                                                                Conexao.fecharStatement(st);
                                                                                return arrayList3;
                                                                            }
                                                                            tmp = StringUtil.getValor(xmlExportaWeb, "medicos");
                                                                            if (Funcoes.textoVazio(tmp)) break block26;
                                                                            retorno.add(this.montaComando(codigoFilial, codigoLog, st, xmlExportaWeb, tipo, "medicos"));
                                                                            ArrayList<ComandoLog> arrayList4 = retorno;
                                                                            Conexao.fecharStatement(st);
                                                                            return arrayList4;
                                                                        }
                                                                        tmp = StringUtil.getValor(xmlExportaWeb, "exames");
                                                                        if (Funcoes.textoVazio(tmp)) break block27;
                                                                        retorno.add(this.montaComando(codigoFilial, codigoLog, st, xmlExportaWeb, tipo, "exames"));
                                                                        ArrayList<ComandoLog> arrayList5 = retorno;
                                                                        Conexao.fecharStatement(st);
                                                                        return arrayList5;
                                                                    }
                                                                    tmp = StringUtil.getValor(xmlExportaWeb, "requisicao");
                                                                    if (Funcoes.textoVazio(tmp)) break block28;
                                                                    retorno.add(this.montaComando(codigoFilial, codigoLog, st, xmlExportaWeb, tipo, "requisicao"));
                                                                    ArrayList<ComandoLog> arrayList6 = retorno;
                                                                    Conexao.fecharStatement(st);
                                                                    return arrayList6;
                                                                }
                                                                stPdf = null;
                                                                tmp = StringUtil.getValor(xmlExportaWeb, "requisicaoexame");
                                                                if (Funcoes.textoVazio(tmp)) break block29;
                                                                retorno.add(this.montaComando(codigoFilial, codigoLog, st, xmlExportaWeb, tipo, "requisicaoexame"));
                                                                arrayList = retorno;
                                                                if (stPdf == null) break block30;
                                                                Conexao.fecharStatement(new Statement[]{stPdf});
                                                            }
                                                            Conexao.fecharStatement(st);
                                                            return arrayList;
                                                        }
                                                        if (stPdf != null) {
                                                            Conexao.fecharStatement(new Statement[]{stPdf});
                                                        }
                                                        break block42;
                                                        {
                                                            catch (Exception ex) {
                                                                try {
                                                                    throw new ExportaWebException(ex, ex.getMessage(), xmlExportaWeb);
                                                                }
                                                                catch (Throwable throwable) {
                                                                    if (stPdf != null) {
                                                                        Conexao.fecharStatement(new Statement[]{stPdf});
                                                                    }
                                                                    throw throwable;
                                                                }
                                                            }
                                                        }
                                                    }
                                                    tmp = StringUtil.getValor(xmlExportaWeb, CHAVE_REQUISICAOEXAMERESULTADOPAGINA);
                                                    if (Funcoes.textoVazio(tmp)) break block31;
                                                    xmlExportaWeb = xmlExportaWeb.replace("<codigoMaterialExameRequisicaoResultadoPagina></codigoMaterialExameRequisicaoResultadoPagina>", "");
                                                    retorno.add(this.montaComando(codigoFilial, codigoLog, st, xmlExportaWeb, tipo, CHAVE_REQUISICAOEXAMERESULTADOPAGINA));
                                                    ArrayList<ComandoLog> arrayList = retorno;
                                                    Conexao.fecharStatement(st);
                                                    return arrayList;
                                                }
                                                tmp = StringUtil.getValor(xmlExportaWeb, "requisicaoexameimagem");
                                                if (Funcoes.textoVazio(tmp)) break block32;
                                                retorno.add(this.montaComando(codigoFilial, codigoLog, st, xmlExportaWeb, tipo, "requisicaoexameimagem"));
                                                ArrayList<ComandoLog> arrayList = retorno;
                                                Conexao.fecharStatement(st);
                                                return arrayList;
                                            }
                                            tmp = StringUtil.getValor(xmlExportaWeb, GRUPO_EXAMES_PACIENTE);
                                            if (Funcoes.textoVazio(tmp)) break block33;
                                            retorno.add(this.montaComando(codigoFilial, codigoLog, st, xmlExportaWeb, tipo, GRUPO_EXAMES_PACIENTE));
                                            ArrayList<ComandoLog> arrayList = retorno;
                                            Conexao.fecharStatement(st);
                                            return arrayList;
                                        }
                                        tmp = StringUtil.getValor(xmlExportaWeb, "entidade");
                                        if (Funcoes.textoVazio(tmp)) break block34;
                                        retorno.add(this.montaComando(codigoFilial, codigoLog, st, xmlExportaWeb, tipo, "entidade"));
                                        ArrayList<ComandoLog> arrayList = retorno;
                                        Conexao.fecharStatement(st);
                                        return arrayList;
                                    }
                                    tmp = StringUtil.getValor(xmlExportaWeb, "pacienteentidade");
                                    if (Funcoes.textoVazio(tmp)) break block35;
                                    retorno.add(this.montaComando(codigoFilial, codigoLog, st, xmlExportaWeb, tipo, "pacienteentidade"));
                                    ArrayList<ComandoLog> arrayList = retorno;
                                    Conexao.fecharStatement(st);
                                    return arrayList;
                                }
                                tmp = StringUtil.getValor(xmlExportaWeb, "mensagensconvenio");
                                if (Funcoes.textoVazio(tmp)) break block36;
                                retorno.add(this.montaComando(codigoFilial, codigoLog, st, xmlExportaWeb, tipo, "mensagensconvenio"));
                                ArrayList<ComandoLog> arrayList = retorno;
                                Conexao.fecharStatement(st);
                                return arrayList;
                            }
                            tmp = StringUtil.getValor(xmlExportaWeb, "destinos");
                            if (Funcoes.textoVazio(tmp)) break block37;
                            retorno.add(this.montaComando(codigoFilial, codigoLog, st, xmlExportaWeb, tipo, "destinos"));
                            ArrayList<ComandoLog> arrayList = retorno;
                            Conexao.fecharStatement(st);
                            return arrayList;
                        }
                        tmp = StringUtil.getValor(xmlExportaWeb, "medicosexames");
                        if (Funcoes.textoVazio(tmp)) break block38;
                        retorno.add(this.montaComando(codigoFilial, codigoLog, st, xmlExportaWeb, tipo, "medicosexames"));
                        ArrayList<ComandoLog> arrayList = retorno;
                        Conexao.fecharStatement(st);
                        return arrayList;
                    }
                    tmp = StringUtil.getValor(xmlExportaWeb, "usuario");
                    if (Funcoes.textoVazio(tmp)) break block39;
                    retorno.add(this.montaComando(codigoFilial, codigoLog, st, xmlExportaWeb, tipo, "usuario"));
                    ArrayList<ComandoLog> arrayList = retorno;
                    Conexao.fecharStatement(st);
                    return arrayList;
                }
                tmp = StringUtil.getValor(xmlExportaWeb, CHAVE_REQUISICAOPDF);
                if (Funcoes.textoVazio(tmp)) break block40;
                retorno.add(this.montaComando(codigoFilial, codigoLog, st, xmlExportaWeb, tipo, CHAVE_REQUISICAOPDF));
                ArrayList<ComandoLog> arrayList = retorno;
                Conexao.fecharStatement(st);
                return arrayList;
            }
            tmp = StringUtil.getValor(xmlExportaWeb, CHAVE_REQUISICAOEXAMERESULTADO);
            if (Funcoes.textoVazio(tmp)) break block41;
            retorno.add(this.montaComando(codigoFilial, codigoLog, st, xmlExportaWeb, tipo, CHAVE_REQUISICAOEXAMERESULTADO));
            ArrayList<ComandoLog> arrayList = retorno;
            Conexao.fecharStatement(st);
            return arrayList;
        }
        Conexao.fecharStatement(st);
        throw new ExportaWebException(null, "O log \u00e9 inv\u00e1lido. Filial: " + codigoFilial + ", log: " + codigoLog, null);
    }

    public static List<ComandoLog> geraPdfExportaWeb2(String codigoFilial, String codigoLog, String xmlExportaWeb, String tipo) throws SQLException {
        ArrayList<ComandoLog> retorno = new ArrayList<ComandoLog>();
        String requisicaoPdf = "";
        String requisicaoExameResultado = "";
        String requisicaoexameresultadopagina = "";
        Statement stPdf = Conexao.getStatement();
        String codigoRequisicaoCompleto = StringUtil.getValor(xmlExportaWeb, CODIGO_REQUISICAO);
        if (Funcoes.textoVazio(codigoRequisicaoCompleto)) {
            return retorno;
        }
        String codigoRequisicao = codigoRequisicaoCompleto;
        if (codigoRequisicao.length() > ParametrosGerais.getDigitosTuboRequisicao()) {
            codigoRequisicao = codigoRequisicao.substring(ParametrosGerais.getDigitosTuboFilial());
        }
        Statement st = Conexao.getStatement();
        StringBuilder buf = new StringBuilder();
        buf.append("select des_enviarweb from destino a ");
        buf.append("left join requisicao b on a.fil_codigo = b.fil_codigo and a.des_codigo = b.des_codigo ");
        buf.append("where a.fil_codigo = ");
        buf.append(codigoFilial);
        buf.append(" and b.req_codigo = ");
        buf.append(codigoRequisicao);
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        boolean destinoEnviaWeb = true;
        if (rs.next()) {
            destinoEnviaWeb = rs.getBoolean("des_enviarweb");
        }
        if (destinoEnviaWeb) {
            Map<String, String> listaPdfs = new ExportaWebService().gerarDadosWeb(xmlExportaWeb, codigoFilial, codigoRequisicao, stPdf);
            String codigoBase = StringUtil.getValor(xmlExportaWeb, "codigoBase");
            if (tipo.equals("A") && ExportaWeb2.todosPdfSaoIguais(listaPdfs)) {
                retorno.add(ExportaWeb2.montaRequisicaoPdf(stPdf, xmlExportaWeb, "A", listaPdfs, codigoFilial, codigoRequisicaoCompleto, codigoLog, PDF_DESTINO, true, null));
                retorno.add(ExportaWeb2.montaRequisicaoPdf(stPdf, xmlExportaWeb, "A", listaPdfs, codigoFilial, codigoRequisicaoCompleto, codigoLog, PDF_DESTINO, true, new String[]{PDF_CONVENIO, PDF_MEDICO, PDF_PACIENTE, PDF_FISCAL, PDF_RESPONSAVEL}, true));
            } else {
                retorno.add(ExportaWeb2.montaRequisicaoPdf(stPdf, xmlExportaWeb, tipo, listaPdfs, codigoFilial, codigoRequisicaoCompleto, codigoLog, PDF_DESTINO, false, null));
                retorno.add(ExportaWeb2.montaRequisicaoPdf(stPdf, xmlExportaWeb, "A", listaPdfs, codigoFilial, codigoRequisicaoCompleto, codigoLog, PDF_CONVENIO, true, null));
                retorno.add(ExportaWeb2.montaRequisicaoPdf(stPdf, xmlExportaWeb, "A", listaPdfs, codigoFilial, codigoRequisicaoCompleto, codigoLog, PDF_MEDICO, true, null));
                retorno.add(ExportaWeb2.montaRequisicaoPdf(stPdf, xmlExportaWeb, "A", listaPdfs, codigoFilial, codigoRequisicaoCompleto, codigoLog, PDF_PACIENTE, true, null));
                retorno.add(ExportaWeb2.montaRequisicaoPdf(stPdf, xmlExportaWeb, "A", listaPdfs, codigoFilial, codigoRequisicaoCompleto, codigoLog, PDF_FISCAL, true, null));
                retorno.add(ExportaWeb2.montaRequisicaoPdf(stPdf, xmlExportaWeb, "A", listaPdfs, codigoFilial, codigoRequisicaoCompleto, codigoLog, PDF_RESPONSAVEL, true, null));
            }
            String codigoExame = StringUtil.getValor(xmlExportaWeb, CODIGO_EXAME_REQUISICAO);
            String codigoMaterial = StringUtil.getValor(xmlExportaWeb, MATERIAL_EXAME_REQUISICAO);
            retorno.addAll(ExportaWeb2.montaRequisicaoExameResultado(stPdf, xmlExportaWeb, tipo, listaPdfs, codigoFilial, codigoRequisicao, codigoExame, codigoMaterial, codigoLog));
            ExportaWeb2.enviarResultadoPDF(stPdf, codigoFilial, codigoRequisicao, codigoBase);
        }
        Conexao.fecharStatement(st);
        return retorno;
    }

    private static boolean todosPdfSaoIguais(Map<String, String> listaPdfs) {
        boolean retorno = false;
        String anterior = null;
        for (String key : listaPdfs.keySet()) {
            if (!ExportaWeb2.isEqualsPDF(key)) continue;
            if (ExportaWeb2.isNull(anterior)) {
                anterior = listaPdfs.get(key);
            }
            if (!ExportaWeb2.isNull(anterior) && !ExportaWeb2.isMesmoPDF(listaPdfs, anterior, key)) {
                retorno = false;
                break;
            }
            retorno = true;
        }
        return retorno;
    }

    private static boolean isEqualsPDF(String key) {
        return key.equalsIgnoreCase(PDF_PACIENTE) || key.equalsIgnoreCase(PDF_MEDICO) || key.equalsIgnoreCase(PDF_DESTINO) || key.equalsIgnoreCase(PDF_CONVENIO) || key.equalsIgnoreCase(PDF_FISCAL) || key.equalsIgnoreCase(PDF_RESPONSAVEL);
    }

    private static boolean isMesmoPDF(Map<String, String> listaPdfs, String anterior, String key) {
        return anterior.equals(listaPdfs.get(key));
    }

    private static boolean isNull(String anterior) {
        return anterior == null;
    }

    private static List<ComandoLog> montaRequisicaoExameResultado(Statement st, String op, String tipo, Map<String, String> listaPdfs, String codigoFilial, String codigoRequisicao, String codigoExame, String codigoMaterial, String codigoLog) throws SQLException {
        ArrayList<ComandoLog> retorno = new ArrayList<ComandoLog>();
        if (Funcoes.textoVazio(codigoExame)) {
            return retorno;
        }
        if (Funcoes.textoVazio(codigoMaterial)) {
            return retorno;
        }
        ArrayList<String> a = new ArrayList<String>();
        a.add("codigoBase");
        a.add(ExportaWeb2.getCodigoBaseWeb(st, codigoFilial));
        a.add(CODIGO_REQUISICAO);
        a.add(IntegracaoUtil.formataCodigoRequisicao(codigoFilial, codigoRequisicao, st));
        a.add("codigoExame");
        a.add(codigoExame);
        a.add("codigoMaterialExame");
        a.add(codigoMaterial);
        a.add("resultadoPdf");
        a.add(listaPdfs.get(PDF_EXAME));
        a.add("codigoHash");
        a.add(listaPdfs.get("codigoHash"));
        a.add("dataConferencia");
        a.add(listaPdfs.get("dataConferencia"));
        a.add("codigoUsuarioConferenciaExameRequisicaoResultado");
        a.add(listaPdfs.get("codigoUsuarioAssinatura"));
        a.add("resultadoTexto");
        a.add(listaPdfs.get("resultadoTexto"));
        String comando = "";
        if (tipo.equals("I") || tipo.equals("A")) {
            String auxComando = "";
            if (tipo.equals("A")) {
                if (!Funcoes.textoVazio(listaPdfs.get("codigoHash"))) {
                    ArrayList<String> aUp = new ArrayList<String>();
                    aUp.add("codigoBase");
                    aUp.add(ExportaWeb2.getCodigoBaseWeb(st, codigoFilial));
                    aUp.add(CODIGO_REQUISICAO);
                    aUp.add(IntegracaoUtil.formataCodigoRequisicao(codigoFilial, codigoRequisicao, st));
                    aUp.add("codigoExame");
                    aUp.add(codigoExame);
                    aUp.add("codigoMaterialExame");
                    aUp.add(codigoMaterial);
                    aUp.add("desatualizado");
                    aUp.add("true");
                    auxComando = ExportaWeb2.montaUpdate(CHAVE_REQUISICAOEXAMERESULTADO, aUp);
                    if (!Funcoes.textoVazio(auxComando)) {
                        retorno.add(new ComandoLog(codigoFilial, codigoLog, auxComando, null, null, aUp, CHAVE_REQUISICAOEXAMERESULTADO, "A"));
                    }
                    a.add("desatualizado");
                    a.add("false");
                    a.add("codigoRequisicaoResultado");
                    a.add("nextval('requisicaoexameresultado_rer_id_seq')");
                    auxComando = ExportaWeb2.montaInsert(CHAVE_REQUISICAOEXAMERESULTADO, a);
                    if (!Funcoes.textoVazio(auxComando)) {
                        retorno.add(new ComandoLog(codigoFilial, codigoLog, auxComando, null, null, a, CHAVE_REQUISICAOEXAMERESULTADO, "I"));
                    }
                } else {
                    ArrayList<String> aUp = new ArrayList<String>();
                    aUp.add("codigoBase");
                    aUp.add(ExportaWeb2.getCodigoBaseWeb(st, codigoFilial));
                    aUp.add(CODIGO_REQUISICAO);
                    aUp.add(IntegracaoUtil.formataCodigoRequisicao(codigoFilial, codigoRequisicao, st));
                    aUp.add("codigoExame");
                    aUp.add(codigoExame);
                    aUp.add("codigoMaterialExame");
                    aUp.add(codigoMaterial);
                    aUp.add("desatualizado");
                    aUp.add("true");
                    auxComando = ExportaWeb2.montaUpdate(CHAVE_REQUISICAOEXAMERESULTADO, aUp);
                    if (!Funcoes.textoVazio(auxComando)) {
                        retorno.add(new ComandoLog(codigoFilial, codigoLog, auxComando, null, null, aUp, CHAVE_REQUISICAOEXAMERESULTADO, "A"));
                    }
                }
            } else {
                a.add("desatualizado");
                a.add("false");
                a.add("codigoRequisicaoResultado");
                a.add("nextval('requisicaoexameresultado_rer_id_seq')");
                auxComando = ExportaWeb2.montaInsert(CHAVE_REQUISICAOEXAMERESULTADO, a);
                if (!Funcoes.textoVazio(auxComando)) {
                    retorno.add(new ComandoLog(codigoFilial, codigoLog, auxComando, null, null, a, CHAVE_REQUISICAOEXAMERESULTADO, "I"));
                }
            }
        } else {
            a = new ArrayList();
            a.add("codigoBase");
            a.add(ExportaWeb2.getCodigoBaseWeb(st, codigoFilial));
            a.add(CODIGO_REQUISICAO);
            a.add(IntegracaoUtil.formataCodigoRequisicao(codigoFilial, codigoRequisicao, st));
            a.add("codigoExame");
            a.add(codigoExame);
            a.add("codigoMaterialExame");
            a.add(codigoMaterial);
            a.add("desatualizado");
            a.add("true");
            retorno.add(new ComandoLog(codigoFilial, codigoLog, ExportaWeb2.montaUpdate(CHAVE_REQUISICAOEXAMERESULTADO, a), null, null, a, CHAVE_REQUISICAOEXAMERESULTADO, "A"));
        }
        return retorno;
    }

    private static ComandoLog montaRequisicaoPdf(Statement st, String op, String tipo, Map<String, String> listaPdfs, String codigoFilial, String codigoRequisicao, String codigoLog, String tipoPdf, boolean apenasUpdate, String[] duplicarParaCampos) throws SQLException {
        return ExportaWeb2.montaRequisicaoPdf(st, op, tipo, listaPdfs, codigoFilial, codigoRequisicao, codigoLog, tipoPdf, apenasUpdate, duplicarParaCampos, false);
    }

    private static ComandoLog montaRequisicaoPdf(Statement st, String op, String tipo, Map<String, String> listaPdfs, String codigoFilial, String codigoRequisicao, String codigoLog, String tipoPdf, boolean apenasUpdate, String[] duplicarParaCampos, boolean ignorarValorParaTipoPdfPrincipal) throws SQLException {
        ArrayList<String> a = new ArrayList<String>();
        a.add("codigoBase");
        a.add(ExportaWeb2.getCodigoBaseWeb(st, codigoFilial));
        a.add(CODIGO_REQUISICAO);
        a.add(codigoRequisicao);
        String campoPrincipal = EnumTipoPDF.getCampoRequisicaoPdf(tipoPdf);
        if (!ignorarValorParaTipoPdfPrincipal) {
            a.add(EnumTipoPDF.getCampoRequisicaoPdf(tipoPdf));
            a.add(listaPdfs.get(EnumTipoPDF.getPdfCampo(tipoPdf)));
        }
        if (duplicarParaCampos != null && campoPrincipal != null) {
            for (String campo : duplicarParaCampos) {
                a.add(EnumTipoPDF.getCampoRequisicaoPdf(campo));
                a.add("@" + campoPrincipal + "@");
            }
        }
        StringBuilder buf = new StringBuilder();
        if (!apenasUpdate) {
            buf.append(ExportaWeb2.montaSelect(CHAVE_REQUISICAOPDF, a));
            if (tipo.equals("I")) {
                return new ComandoLog(codigoFilial, codigoLog, ExportaWeb2.montaInsert(CHAVE_REQUISICAOPDF, a), ExportaWeb2.montaSelect(CHAVE_REQUISICAOPDF, a), ExportaWeb2.montaUpdate(CHAVE_REQUISICAOPDF, a), a, CHAVE_REQUISICAOPDF, tipo);
            }
            if (tipo.equals("A")) {
                return new ComandoLog(codigoFilial, codigoLog, ExportaWeb2.montaUpdate(CHAVE_REQUISICAOPDF, a), null, null, a, CHAVE_REQUISICAOPDF, tipo);
            }
        } else {
            return new ComandoLog(codigoFilial, codigoLog, ExportaWeb2.montaUpdate(CHAVE_REQUISICAOPDF, a), null, null, a, CHAVE_REQUISICAOPDF, tipo);
        }
        return null;
    }

    private ComandoLog montaComando(String codigoFilial, String codigoLog, Statement st, String c, String tipo, String tabela) throws ExportaWebException {
        ArrayList a = null;
        try {
            a = this.parseXml(c);
        }
        catch (Exception e) {
            throw new ExportaWebException(e, "\nN\u00e3o foi poss\u00edvel processar o log. Filial = " + codigoFilial + ", log = " + codigoLog + ". ", tipo.equals("I") ? "Inser\u00e7\u00e3o" : (tipo.equals("A") ? "Altera\u00e7\u00e3o" : "Remo\u00e7\u00e3o"));
        }
        if (tipo.equals("I")) {
            String auxComando = ExportaWeb2.montaInsert(tabela, a);
            if (Funcoes.textoVazio(auxComando)) {
                return null;
            }
            return new ComandoLog(codigoFilial, codigoLog, auxComando, ExportaWeb2.montaSelect(tabela, a), ExportaWeb2.montaUpdate(tabela, a), a, tabela);
        }
        if (tipo.equals("A")) {
            String auxComando = ExportaWeb2.montaUpdate(tabela, a);
            if (Funcoes.textoVazio(auxComando)) {
                return null;
            }
            return new ComandoLog(codigoFilial, codigoLog, auxComando, null, null, a, tabela);
        }
        String auxComando = ExportaWeb2.montaDelete(tabela, a);
        if (Funcoes.textoVazio(auxComando)) {
            return null;
        }
        return new ComandoLog(codigoFilial, codigoLog, auxComando, null, null, a, tabela);
    }

    private static String montaInsert(String tabela, ArrayList<String> a) {
        StringBuilder campos = new StringBuilder();
        StringBuilder valores = new StringBuilder("");
        if (!a.contains("codigoImagemExame") && tabela.equalsIgnoreCase("requisicaoexameimagem")) {
            return "";
        }
        ArrayList<Integer> remover = new ArrayList<Integer>();
        HashMap<String, Integer> repetido = new HashMap<String, Integer>();
        for (int i = a.size() - 2; i >= 0; i -= 2) {
            CamposWeb c;
            if (camposIgnorar.contains(a.get(i)) || (c = (CamposWeb)CAMPOS.get(a.get(i))) == null) continue;
            if (repetido.containsKey(c.getNomeCampo().toLowerCase())) {
                remover.add(i);
                continue;
            }
            repetido.put(c.getNomeCampo().toLowerCase(), i);
        }
        if (remover != null && remover.size() > 0) {
            for (Integer i : remover) {
                a.remove(i);
                a.remove(i);
            }
        }
        int pulo = ExportaWeb2.pularCampos(a);
        for (int i = a.size() - 2; i >= 0; i -= 2) {
            CamposWeb campo;
            if (camposIgnorar.contains(a.get(i)) || (campo = (CamposWeb)CAMPOS.get(a.get(i))) == null || campo == null || Funcoes.textoVazio(campo.getNomeCampo()) || campo.getNomeCampo().equalsIgnoreCase("null")) continue;
            campos.append(campo.getNomeCampo());
            if (i > 0) {
                campos.append(",");
            }
            if (a.get(i + 1) != null && campo.getTipoCampo() == 2) {
                valores.append(a.get(i + 1).toString());
            } else if (campo.getTipoCampo() == 3) {
                if (a.get(i + 1) == null || Funcoes.textoVazio(a.get(i + 1).toString())) {
                    valores.append("null");
                } else {
                    valores.append(Funcoes.limpaDecimal(a.get(i + 1).toString()));
                }
            } else if (campo.getTipoCampo() == 1) {
                if (a.get(i + 1) != null && campo.getNomeCampo().equalsIgnoreCase("usr_assinatura") && a.get(i + 1).toString().length() > 20) {
                    valores.append(StringUtil.textoDBEscape(a.get(i + 1).toString().substring(0, 20)));
                } else if (a.get(i + 1) != null) {
                    valores.append(StringUtil.textoDBEscape(a.get(i + 1).toString()));
                } else {
                    valores.append("null");
                }
            } else if (campo.getTipoCampo() == 4) {
                if (a.get(i + 1) != null && Funcoes.verificaData(a.get(i + 1).toString())) {
                    valores.append("'");
                    valores.append(Funcoes.formataData("MM/dd/yyyy", a.get(i + 1).toString()));
                    valores.append("'");
                } else {
                    valores.append("null");
                }
            } else if (campo.getTipoCampo() == 7) {
                if (a.get(i + 1) != null && !Funcoes.textoVazio(a.get(i + 1).toString())) {
                    valores.append("'");
                    valores.append(a.get(i + 1).toString());
                    valores.append("'");
                } else {
                    valores.append("null");
                }
            } else if (campo.getTipoCampo() == 5) {
                if (a.get(i + 1) != null && Funcoes.verificaHora(a.get(i + 1).toString())) {
                    valores.append("'");
                    valores.append(a.get(i + 1).toString());
                    valores.append("'");
                } else {
                    valores.append("null");
                }
            } else if (campo.getTipoCampo() == 6) {
                if (a.get(i + 1) != null && !Funcoes.textoVazio(a.get(i + 1).toString()) && (a.get(i + 1).toString().equalsIgnoreCase("S") || a.get(i + 1).toString().equalsIgnoreCase("TRUE") || a.get(i + 1).toString().equalsIgnoreCase("SIM"))) {
                    valores.append("true");
                } else {
                    valores.append("false");
                }
            }
            if (i <= 0) continue;
            valores.append(",");
        }
        if (Funcoes.textoVazio(valores.toString())) {
            return null;
        }
        StringBuilder retorno = new StringBuilder("insert into ");
        retorno.append(tabela);
        retorno.append(" (");
        retorno.append((CharSequence)ExportaWeb2.arrumaComando(campos));
        retorno.append(") values (");
        retorno.append((CharSequence)ExportaWeb2.arrumaComando(valores));
        retorno.append(")");
        return retorno.toString();
    }

    private static StringBuilder arrumaComando(StringBuilder comando) {
        int tamanho = comando.length() - 1;
        if (tamanho > 0 && comando.charAt(tamanho) == ',') {
            comando.replace(tamanho, comando.length(), "");
        }
        return comando;
    }

    private static int pularCampos(ArrayList<String> a) {
        boolean pula = a.containsAll(camposIgnorar);
        int pulo = 2;
        if (pula) {
            pulo = 2;
        }
        return pulo;
    }

    private static String montaUpdate(String tabela, ArrayList a) {
        int i;
        StringBuilder pk = new StringBuilder();
        StringBuilder valores = new StringBuilder("");
        ArrayList<Integer> remover = new ArrayList<Integer>();
        HashMap<String, Integer> repetido = new HashMap<String, Integer>();
        for (i = a.size() - 2; i >= 0; i -= 2) {
            CamposWeb c;
            if (camposIgnorar.contains(a.get(i)) || (c = (CamposWeb)CAMPOS.get(a.get(i))) == null) continue;
            if (repetido.containsKey(c.getNomeCampo().toLowerCase())) {
                remover.add(i);
                continue;
            }
            repetido.put(c.getNomeCampo().toLowerCase(), i);
        }
        if (remover != null && remover.size() > 0) {
            for (Integer i2 : remover) {
                a.remove(i2);
                a.remove(i2);
            }
        }
        for (i = a.size() - 2; i >= 0; i -= 2) {
            CamposWeb campo = (CamposWeb)CAMPOS.get(a.get(i));
            if (campo == null || campo == null || Funcoes.textoVazio(campo.getNomeCampo()) || campo.getNomeCampo().equalsIgnoreCase("null")) continue;
            if (campo.getPK() && !campo.getForcarUpdate()) {
                if (pk.length() > 0) {
                    pk.append(" and ");
                }
                pk.append(ExportaWeb2.montaCampoUpdate(campo, a.get(i + 1).toString()));
                continue;
            }
            if (valores.length() > 0) {
                valores.append(", ");
            }
            if (tabela.equalsIgnoreCase(CHAVE_REQUISICAOPDF) && null != a.get(i + 1) && !a.isEmpty() && a.get(i + 1).toString().startsWith("@") && a.get(i + 1).toString().endsWith("@") && a.get(i + 1).toString().length() > 3) {
                CamposWeb tmp = (CamposWeb)CAMPOS.get(a.get(i + 1).toString().replaceAll("@", ""));
                valores.append(campo.getNomeCampo()).append(" = ").append(tmp.getNomeCampo());
                continue;
            }
            if (campo.getNomeCampo().equalsIgnoreCase("usr_assinatura") && a.get(i + 1).toString().length() > 20) {
                valores.append(ExportaWeb2.montaCampoUpdate(campo, a.get(i + 1).toString().substring(0, 20)));
                continue;
            }
            if (a.get(i + 1) == null) continue;
            valores.append(ExportaWeb2.montaCampoUpdate(campo, a.get(i + 1).toString()));
        }
        if (Funcoes.textoVazio(valores.toString())) {
            return null;
        }
        StringBuilder retorno = new StringBuilder("update ");
        retorno.append(tabela);
        retorno.append(" set ");
        retorno.append((CharSequence)valores);
        retorno.append(" where ");
        retorno.append((CharSequence)pk);
        return retorno.toString();
    }

    private static String montaDelete(String tabela, ArrayList a) {
        StringBuilder pk = new StringBuilder();
        for (int i = a.size() - 2; i >= 0; i -= 2) {
            CamposWeb campo;
            if (camposIgnorar.contains(a.get(i)) || (campo = (CamposWeb)CAMPOS.get(a.get(i))) == null || campo == null || Funcoes.textoVazio(campo.getNomeCampo()) || campo.getNomeCampo().equalsIgnoreCase("null") || !campo.getPK()) continue;
            if (pk.length() > 0) {
                pk.append(" and ");
            }
            pk.append(ExportaWeb2.montaCampoUpdate(campo, a.get(i + 1).toString()));
        }
        if (Funcoes.textoVazio(pk.toString())) {
            return null;
        }
        StringBuilder retorno = new StringBuilder("delete from ");
        retorno.append(tabela);
        retorno.append(" where ");
        retorno.append((CharSequence)pk);
        return retorno.toString();
    }

    private static String montaSelect(String tabela, ArrayList a) {
        StringBuilder pk = new StringBuilder();
        for (int i = 0; i < a.size(); i += 2) {
            CamposWeb campo;
            if (camposIgnorar.contains(a.get(i)) || (campo = (CamposWeb)CAMPOS.get(a.get(i))) == null || campo == null || Funcoes.textoVazio(campo.getNomeCampo()) || campo.getNomeCampo().equalsIgnoreCase("null") || !campo.getPK()) continue;
            if (tabela.equals("requisicao") && campo.getNomeCampo().equals("pac_codigo")) {
                pk.append("");
                continue;
            }
            if (pk.length() > 0) {
                pk.append(" and ");
            }
            pk.append(ExportaWeb2.montaCampoUpdate(campo, a.get(i + 1).toString()));
        }
        StringBuilder retorno = new StringBuilder("select 1 from ");
        retorno.append(tabela);
        retorno.append(" where ");
        retorno.append((CharSequence)pk);
        return retorno.toString();
    }

    private static String montaCampoUpdate(CamposWeb campo, String valor) {
        StringBuilder tmp = new StringBuilder();
        tmp.append(campo.getNomeCampo());
        if (!(valor.equalsIgnoreCase("is not null") || valor.equalsIgnoreCase("is null") || valor.trim().startsWith(">"))) {
            tmp.append(" = ");
        } else {
            tmp.append(" ");
        }
        if (campo.getTipoCampo() == 2) {
            tmp.append(Funcoes.textoVazio(valor) ? "null" : valor);
        } else if (campo.getTipoCampo() == 3) {
            tmp.append(Funcoes.textoVazio(valor) ? "null" : Funcoes.limpaDecimal(valor));
        } else if (campo.getTipoCampo() == 1) {
            tmp.append(StringUtil.textoDBEscape(valor));
        } else if (campo.getTipoCampo() == 4) {
            if (Funcoes.verificaData(valor)) {
                tmp.append("'");
                tmp.append(Funcoes.formataData("MM/dd/yyyy", valor));
                tmp.append("'");
            } else {
                tmp.append("null");
            }
        } else if (campo.getTipoCampo() == 7) {
            if (!Funcoes.textoVazio(valor)) {
                tmp.append("'");
                tmp.append(valor);
                tmp.append("'");
            } else {
                tmp.append("null");
            }
        } else if (campo.getTipoCampo() == 5) {
            if (Funcoes.verificaHora(valor)) {
                tmp.append("'");
                tmp.append(valor);
                tmp.append("'");
            } else {
                tmp.append("null");
            }
        } else if (campo.getTipoCampo() == 6) {
            if (!Funcoes.textoVazio(valor) && (valor.equalsIgnoreCase("S") || valor.equalsIgnoreCase("TRUE") || valor.equalsIgnoreCase("SIM"))) {
                tmp.append("true");
            } else {
                tmp.append("false");
            }
        }
        return tmp.toString();
    }

    private void marcaExportado(Statement st, ComandoLog comandoLog) throws ExportaWebException {
        try {
            StringBuilder buf = new StringBuilder();
            buf.append("delete from exportaweb ");
            if (comandoLog != null) {
                buf.append(" where fil_codigo = ").append(comandoLog.getCodigoFilial());
                buf.append(" and ewe_codigo = ").append(comandoLog.getCodigoLog());
                Conexao.executeUpdatePerformance(comandoLog.getCodigoFilial(), st, buf.toString(), true);
            }
            if (!(comandoLog == null || Funcoes.textoVazio(comandoLog.getOperacao()) || Funcoes.textoVazio(comandoLog.getCodigoFilial()) || Funcoes.textoVazio(StringUtil.getValor(comandoLog.getOperacao(), CODIGO_REQUISICAO)) || Funcoes.textoVazio(StringUtil.getValor(comandoLog.getOperacao(), MATERIAL_EXAME_REQUISICAO)) || Funcoes.textoVazio(StringUtil.getValor(comandoLog.getOperacao(), CODIGO_EXAME_REQUISICAO)))) {
                StringBuilder sqlRemoveLogExportacao = new StringBuilder();
                sqlRemoveLogExportacao.append("delete from exportapdf where est_codigo = ").append(Variaveis.codigoEstacao);
                sqlRemoveLogExportacao.append(" and fil_codigo = ").append(comandoLog.getCodigoFilial());
                sqlRemoveLogExportacao.append(" and req_codigo = ").append(StringUtil.getValor(comandoLog.getOperacao(), CODIGO_REQUISICAO));
                sqlRemoveLogExportacao.append(" and exa_codigo = '").append(StringUtil.getValor(comandoLog.getOperacao(), CODIGO_EXAME_REQUISICAO)).append("'");
                sqlRemoveLogExportacao.append(" and mco_codigo = ").append(StringUtil.getValor(comandoLog.getOperacao(), MATERIAL_EXAME_REQUISICAO));
                st.execute(sqlRemoveLogExportacao.toString());
            }
        }
        catch (SQLException e) {
            throw new ExportaWebException(e, "N\u00e3o foi poss\u00edvel marcar o log como exportado. Filial: \"" + comandoLog.getCodigoFilial() + "\", c\u00f3digo: \"" + comandoLog.getCodigoLog() + "\".", null);
        }
    }

    private ArrayList parseXml(String xml) throws ParserConfigurationException, SAXException, IOException {
        ArrayList a = new ArrayList();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        DocumentBuilder db = factory.newDocumentBuilder();
        Document doc = db.parse(new InputSource(new StringReader(ExportaWeb2.geraEscapesXML(xml, "UTF-8"))));
        NodeList list = doc.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            this.trataNodeChild(node, a);
        }
        return a;
    }

    private static String geraEscapesXML(String xml, String charset) {
        StringBuilder buf = new StringBuilder();
        buf.append("<?xml version=\"1.0\" encoding=\"").append(charset).append("\" standalone=\"no\"?>");
        buf.append("<!--DTD-->");
        buf.append("<!DOCTYPE my_file [");
        buf.append("<!ELEMENT my_file (text)>");
        buf.append("<!ELEMENT text (#PCDATA)>");
        buf.append("<!--Entity declarations-->");
        buf.append("<!ENTITY exm \"&amp;exm\">");
        buf.append("<!ENTITY mat \"&amp;mat\">");
        buf.append("<!ENTITY img \"&amp;img\">");
        buf.append("<!ENTITY iexcl \"\u00a1\">");
        buf.append("<!ENTITY cent \"\u00a2\">");
        buf.append("<!ENTITY pound \"\u00a3\">");
        buf.append("<!ENTITY curren \"\u00a4\">");
        buf.append("<!ENTITY yen \"\u00a5\">");
        buf.append("<!ENTITY brvbar \"\u00a6\">");
        buf.append("<!ENTITY sect \"\u00a7\">");
        buf.append("<!ENTITY uml \"\u00a8\">");
        buf.append("<!ENTITY copy \"\u00a9\">");
        buf.append("<!ENTITY ordf \"\u00aa\">");
        buf.append("<!ENTITY laquo \"\u00ab\">");
        buf.append("<!ENTITY not \"\u00ac\">");
        buf.append("<!ENTITY shy \"\u00ad\">");
        buf.append("<!ENTITY reg \"\u00ae\">");
        buf.append("<!ENTITY macr \"\u00af\">");
        buf.append("<!ENTITY deg \"\u00b0\">");
        buf.append("<!ENTITY plusmn \"\u00b1\">");
        buf.append("<!ENTITY sup2 \"\u00b2\">");
        buf.append("<!ENTITY sup3 \"\u00b3\">");
        buf.append("<!ENTITY acute \"\u00b4\">");
        buf.append("<!ENTITY micro \"\u00b5\">");
        buf.append("<!ENTITY para \"\u00b6\">");
        buf.append("<!ENTITY middot \"\u00b7\">");
        buf.append("<!ENTITY cedil \"\u00b8\">");
        buf.append("<!ENTITY sup1 \"\u00b9\">");
        buf.append("<!ENTITY ordm \"\u00ba\">");
        buf.append("<!ENTITY raquo \"\u00bb\">");
        buf.append("<!ENTITY frac14 \"\u00bc\">");
        buf.append("<!ENTITY frac12 \"\u00bd\">");
        buf.append("<!ENTITY frac34 \"\u00be\">");
        buf.append("<!ENTITY iquest \"\u00bf\">");
        buf.append("<!ENTITY Agrave \"\u00c0\">");
        buf.append("<!ENTITY Aacute \"\u00c1\">");
        buf.append("<!ENTITY Acirc \"\u00c2\">");
        buf.append("<!ENTITY Atilde \"\u00c3\">");
        buf.append("<!ENTITY Auml \"\u00c4\">");
        buf.append("<!ENTITY Aring \"\u00c5\">");
        buf.append("<!ENTITY AElig \"\u00c6\">");
        buf.append("<!ENTITY Ccedil \"\u00c7\">");
        buf.append("<!ENTITY Egrave \"\u00c8\">");
        buf.append("<!ENTITY Eacute \"\u00c9\">");
        buf.append("<!ENTITY Ecirc \"\u00ca\">");
        buf.append("<!ENTITY Euml \"\u00cb\">");
        buf.append("<!ENTITY Igrave \"\u00cc\">");
        buf.append("<!ENTITY Iacute \"\u00cd\">");
        buf.append("<!ENTITY Icirc \"\u00ce\">");
        buf.append("<!ENTITY Iuml \"\u00cf\">");
        buf.append("<!ENTITY ETH \"\u00d0\">");
        buf.append("<!ENTITY Ntilde \"\u00d1\">");
        buf.append("<!ENTITY Ograve \"\u00d2\">");
        buf.append("<!ENTITY Oacute \"\u00d3\">");
        buf.append("<!ENTITY Ocirc \"\u00d4\">");
        buf.append("<!ENTITY Otilde \"\u00d5\">");
        buf.append("<!ENTITY Ouml \"\u00d6\">");
        buf.append("<!ENTITY times \"\u00d7\">");
        buf.append("<!ENTITY Oslash \"\u00d8\">");
        buf.append("<!ENTITY Ugrave \"\u00d9\">");
        buf.append("<!ENTITY Uacute \"\u00da\">");
        buf.append("<!ENTITY Ucirc \"\u00db\">");
        buf.append("<!ENTITY Uuml \"\u00dc\">");
        buf.append("<!ENTITY Yacute \"\u00dd\">");
        buf.append("<!ENTITY THORN \"\u00de\">");
        buf.append("<!ENTITY szlig \"\u00df\">");
        buf.append("<!ENTITY agrave \"\u00e0\">");
        buf.append("<!ENTITY aacute \"\u00e1\">");
        buf.append("<!ENTITY acirc \"\u00e2\">");
        buf.append("<!ENTITY atilde \"\u00e3\">");
        buf.append("<!ENTITY auml \"\u00e4\">");
        buf.append("<!ENTITY aring \"\u00e5\">");
        buf.append("<!ENTITY aelig \"\u00e6\">");
        buf.append("<!ENTITY ccedil \"\u00e7\">");
        buf.append("<!ENTITY egrave \"\u00e8\">");
        buf.append("<!ENTITY eacute \"\u00e9\">");
        buf.append("<!ENTITY ecirc \"\u00ea\">");
        buf.append("<!ENTITY euml \"\u00eb\">");
        buf.append("<!ENTITY igrave \"\u00ec\">");
        buf.append("<!ENTITY iacute \"\u00ed\">");
        buf.append("<!ENTITY icirc \"\u00ee\">");
        buf.append("<!ENTITY iuml \"\u00ef\">");
        buf.append("<!ENTITY eth \"\u00f0\">");
        buf.append("<!ENTITY ntilde \"\u00f1\">");
        buf.append("<!ENTITY ograve \"\u00f2\">");
        buf.append("<!ENTITY oacute \"\u00f3\">");
        buf.append("<!ENTITY ocirc \"\u00f4\">");
        buf.append("<!ENTITY otilde \"\u00f5\">");
        buf.append("<!ENTITY ouml \"\u00f6\">");
        buf.append("<!ENTITY divide \"\u00f7\">");
        buf.append("<!ENTITY oslash \"\u00f8\">");
        buf.append("<!ENTITY ugrave \"\u00f9\">");
        buf.append("<!ENTITY uacute \"\u00fa\">");
        buf.append("<!ENTITY ucirc \"\u00fb\">");
        buf.append("<!ENTITY uuml \"\u00fc\">");
        buf.append("<!ENTITY yacute \"\u00fd\">");
        buf.append("<!ENTITY thorn \"\u00fe\">");
        buf.append("<!ENTITY yuml \"\u00ff\">");
        buf.append("]>");
        buf.append(xml.replaceAll("&exm=", "&exm;=").replaceAll("&mat=", "&mat;=").replaceAll("&img=", "&img;="));
        return buf.toString();
    }

    private void trataNodeChild(Node node, ArrayList a) {
        if (!node.hasChildNodes()) {
            return;
        }
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node no = list.item(i);
            a.add(no.getNodeName());
            if (no.getNodeName().equalsIgnoreCase("codigoBase") && this.filialBaseWeb != null) {
                a.add(this.listaBasesWeb.get(Integer.parseInt(this.filialBaseWeb)));
                continue;
            }
            a.add(no.getTextContent());
        }
    }

    public void setProgressBar(JProgressBar progresso) {
        if (progresso != null) {
            this.progresso = progresso;
        }
    }

    public void setTextMensagens(JTextArea txt) {
        if (txt != null) {
            this.txtMensagens = txt;
        }
    }

    private void mostraMensagem(String mensagem) {
        if (this.txtMensagens != null) {
            this.txtMensagens.append("\n" + mensagem);
            this.txtMensagens.setCaretPosition(this.txtMensagens.getText().length());
        }
        if (this.exportacaoMonitor != null) {
            this.exportacaoMonitor.setOperacaoAtual(mensagem);
        }
    }

    public void setAutomatico(boolean b) {
        this.automatico = b;
    }

    public void setIgnorarFiliais(boolean b) {
        this.ignorarFilial = b;
    }

    public void setMostrarIcones(boolean b) {
        this.mostrarIcones = b;
    }

    public void addThreadListener(ThreadListener l) {
        this.listenerList.add(ThreadListener.class, l);
    }

    public void removeThreadListener(ThreadListener l) {
        this.listenerList.remove(ThreadListener.class, l);
    }

    private void fireIniciouExecucao() {
        ThreadListener[] lis = (ThreadListener[])this.listenerList.getListeners(ThreadListener.class);
        for (int i = 0; i < lis.length; ++i) {
            lis[i].iniciouExecucao(new EventObject(this));
        }
    }

    private void fireTerminouExecucao() {
        ThreadListener[] lis = (ThreadListener[])this.listenerList.getListeners(ThreadListener.class);
        for (int i = 0; i < lis.length; ++i) {
            lis[i].terminouExecucao(new EventObject(this));
        }
    }

    private int buscaTotalParaExportar(Statement st, boolean ignorarFilial) throws ExportaWebException {
        StringBuilder tmp = new StringBuilder();
        tmp.append(" select count(ewe_codigo) as qtde ");
        tmp.append("   from exportaweb ");
        tmp.append("  where (ewe_exportado = false or ewe_exportado is null) ");
        if (!ignorarFilial) {
            tmp.append(" and fil_codigo = ").append(this.filialBaseWeb == null ? Variaveis.filialPadrao : this.filialBaseWeb);
        }
        try {
            ResultSet rs = st.executeQuery(tmp.toString());
            return rs.next() ? rs.getInt("qtde") : 0;
        }
        catch (Exception e) {
            throw new ExportaWebException(e, "N\u00e3o foi poss\u00edvel buscar a quantidade total de logs a enviar.", null);
        }
    }

    private String getSelect(boolean isGerandoArquivo) {
        StringBuilder tmp = new StringBuilder();
        tmp.append(" select fil_codigo ");
        tmp.append("       ,ewe_codigo ");
        tmp.append("       ,ewe_datahora ");
        tmp.append("       ,ewe_tipooperacao ");
        tmp.append("   from exportaweb ");
        tmp.append("  where (ewe_exportado = false or ewe_exportado is null) ");
        if (!this.ignorarFilial) {
            tmp.append("  and fil_codigo = ").append(this.filialBaseWeb == null ? Variaveis.filialPadrao : this.filialBaseWeb);
        }
        tmp.append("  order by " + (isGerandoArquivo ? "ewe_codigo" : "ewe_datahora, ewe_codigo"));
        tmp.append("  limit ").append(isGerandoArquivo ? 100 : 350);
        return tmp.toString();
    }

    private String getOperacao(String filial, String codigo) throws ExportaWebException {
        Statement st;
        block5: {
            StringBuilder tmp = new StringBuilder();
            tmp.append(" select ewe_operacao as operacao ");
            tmp.append("   from exportaweb ");
            tmp.append("  where fil_codigo = ").append(filial);
            tmp.append("    and ewe_codigo = ").append(codigo);
            st = Conexao.getStatement();
            ResultSet rs = Conexao.executeQueryPerformance(st, tmp.toString());
            if (!rs.next()) break block5;
            String string = rs.getString(TAG_OPERACAO);
            Conexao.fecharStatement(st);
            return string;
        }
        try {
            try {
                throw new Exception("O log n\u00e3o foi localizado. Filial = " + filial + ", c\u00f3digo = " + codigo + ".");
            }
            catch (Exception e) {
                throw new ExportaWebException(e, "N\u00e3o foi poss\u00edvel buscar o log de exporta\u00e7\u00e3o.", null);
            }
        }
        catch (Throwable throwable) {
            Conexao.fecharStatement(st);
            throw throwable;
        }
    }

    public static String getOperacaoConexaoJalis(Statement st, String filial, String codigo) {
        StringBuilder tmp = new StringBuilder();
        tmp.append(" select ewe_operacao as operacao ");
        tmp.append("   from exportaweb ");
        tmp.append("  where fil_codigo = ").append(filial);
        tmp.append("    and ewe_codigo = ").append(codigo);
        try {
            ResultSet rs = Conexao.executeQueryPerformance(st, tmp.toString());
            if (rs.next()) {
                return rs.getString(TAG_OPERACAO);
            }
            throw new Exception("O log n\u00e3o foi localizado. Filial = " + filial + ", c\u00f3digo = " + codigo + ".");
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel buscar o log de exporta\u00e7\u00e3o", e.getStackTrace());
            return "";
        }
    }

    public static void atualizaPaginaOrdemExameWeb(Statement st, String filial, String requisicao, String codigoBase) throws Exception {
        ExportaWeb2.atualizaPaginaOrdemExameWeb(st, filial, requisicao, "", "", codigoBase);
    }

    public static void atualizaPaginaOrdemExameWeb(Statement st, String filial, String requisicao, String codigoExame, String codigoMaterial, String codigoBase) throws Exception {
        if (Laboratorio.getFilialExportaHtmlWeb()) {
            BeanCriaHtmlWeb beanCriaHtmlWeb = new BeanCriaHtmlWeb(filial, requisicao, codigoExame, codigoMaterial, codigoBase);
            ThreadCriaHtmlWeb.addLog(beanCriaHtmlWeb);
        }
    }

    public static void deletarExameRequisicaoWeb(Statement st, String filial, String requisicao, String exame, String material) throws Exception {
        ArrayList<String> tmp = new ArrayList<String>();
        tmp.add(CODIGO_REQUISICAO);
        tmp.add(IntegracaoUtil.formataCodigoRequisicao(filial, requisicao, st));
        tmp.add("codigoBase");
        tmp.add(ExportaWeb.getCodigoBaseWeb(st, filial));
        tmp.add(CODIGO_EXAME_REQUISICAO);
        tmp.add(exame);
        tmp.add(MATERIAL_EXAME_REQUISICAO);
        tmp.add(material);
        DBUtil.insereExportaWeb(filial, st, "requisicaoexame", "D", true, tmp.toArray(new String[tmp.size()]));
    }

    public static String getCodigoBaseWeb(Statement st, String filial) throws SQLException {
        String codigoBase = "";
        FilialService filService = new FilialService();
        FilialVOAux filVO = filService.getDadosExportaBaseWeb(st, filial);
        if (Funcoes.carregouVO(filVO)) {
            codigoBase = filVO.getTipoBase();
        }
        if (Funcoes.textoVazio(codigoBase) && Funcoes.carregouVO(filVO = filService.contemAgrupamento(st, filial)) && Funcoes.isExportarBaseWeb(filVO)) {
            codigoBase = filVO.getTipoBase();
        }
        return codigoBase;
    }

    public static boolean isGerarPdfResultado(Statement st, String filial) throws SQLException {
        FilialService filService = new FilialService();
        return filService.isGerarPdfResultado(st, filial);
    }

    public static boolean isBaseWebAgrupada(Statement st, String filial) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.delete(0, buf.length());
        buf.append("select fil_codigo from filiaisweb where fil_kodigo = ").append(filial);
        ResultSet rs = Conexao.executeQueryPerformance(st, buf.toString());
        boolean retorno = rs.next();
        rs.close();
        return retorno;
    }

    public static boolean isEnviarExamesParaWeb(Statement st, String filial) throws SQLException {
        FilialService filService = new FilialService();
        FilialVOAux filialVO = filService.getDadosExportaBaseWeb(st, filial);
        boolean retorno = false;
        if (Funcoes.carregouVO(filialVO)) {
            retorno = !Funcoes.textoVazio(filialVO.getTipoBase()) && filialVO.isWebStandAlone() == false;
        }
        return retorno;
    }

    public static void enviarResultadoPDF(Statement st, String filial, String requisicao, String codigoBaseWeb) throws SQLException {
        ArrayList<String> tmp = new ArrayList<String>();
        tmp.add(CODIGO_REQUISICAO);
        tmp.add(IntegracaoUtil.formataCodigoRequisicao(filial, requisicao, st));
        tmp.add("codigoBase");
        tmp.add(codigoBaseWeb);
        tmp.add("resultadoPdfRequisicao");
        RetornoImpressaoResultados retorno = ImpressaoResultados.imprimirExamesPdfWeb(filial, requisicao, false);
        String resultado = retorno.getResultadoPdfWeb() != null ? new Base64().encodeAsString(retorno.getResultadoPdfWeb()) : "";
        tmp.add(resultado);
        DBUtil.insereExportaWeb(filial, st, "requisicao", "A", tmp.toArray(new String[tmp.size()]));
    }

    @Override
    public ExportacaoMonitor getMonitorExportacao() {
        return this.exportacaoMonitor;
    }

    @Override
    public boolean podeApresentarJanelaMonitoramento() {
        try {
            return ExportaWeb2.isEnviarExamesParaWeb(Conexao.getStatement(), this.filialBaseWeb == null ? Variaveis.filialPadrao : this.filialBaseWeb);
        }
        catch (Exception e) {
            return false;
        }
    }

    private void atualizaTempoEntreIteracoes(Integer qtdeLogsAnteriores) {
        if (this.tempoIteracaoAnterior != null) {
            Calendar calAnterior = Calendar.getInstance();
            calAnterior.setTime(this.tempoIteracaoAnterior);
            Calendar calAtual = Calendar.getInstance();
            calAtual.setTime(new Date());
            long qtde = calAtual.getTimeInMillis() - calAnterior.getTimeInMillis();
            if (qtdeLogsAnteriores != null && qtdeLogsAnteriores > 0) {
                qtde /= (long)qtdeLogsAnteriores.intValue();
            }
            this.mediaTempoIteracoes = (this.mediaTempoIteracoes + qtde * 3L) / 4L;
            this.exportacaoMonitor.setTempoEntreIteracoes(this.mediaTempoIteracoes);
            this.tempoIteracaoAnterior = calAtual.getTime();
        } else {
            this.tempoIteracaoAnterior = new Date();
        }
    }

    private static String enviaMensagemRecebeRetornoSOAP(String ip, String porta, String nomeMetodo, String conteudoMensagem, boolean isPedidoConexao) throws ExportaWebException {
        String erroRetorno = "N\u00e3o foi poss\u00edvel receber o retorno do webservice - ";
        try {
            conteudoMensagem = ExportaWeb2.trataConteudoMensagem(conteudoMensagem, isPedidoConexao);
            SOAPFactory soapFactory = SOAPFactory.newInstance();
            MessageFactory messageFactory = MessageFactory.newInstance();
            SOAPMessage soapMessage = messageFactory.createMessage();
            SOAPPart soapPart = soapMessage.getSOAPPart();
            SOAPEnvelope envelope = soapPart.getEnvelope();
            envelope.setEncodingStyle("http://schemas.xmlsoap.org/soap/encoding/");
            envelope.getHeader().detachNode();
            SOAPBody body = envelope.getBody();
            Name nameMetodo = soapFactory.createName(nomeMetodo, "", "");
            SOAPBodyElement metodo = body.addBodyElement(nameMetodo);
            QName name = new QName(TAG_COMANDO);
            SOAPElement aux = metodo.addChildElement(name);
            aux.addTextNode(conteudoMensagem);
            if (nomeMetodo.equalsIgnoreCase(COMANDO_WEBSERVICE_PODE_ENVIAR)) {
                QName phpsessionidName = new QName(PHP_SESSION_ID);
                SOAPElement auxphpsessionid = metodo.addChildElement(phpsessionidName);
                String conteudoSessonId = ExportaWeb2.trataConteudoMensagem(ParametrosLocais.getParametro(CONTROLE_EXPORTA_WEB), isPedidoConexao);
                auxphpsessionid.addTextNode(conteudoSessonId);
            }
            soapMessage.saveChanges();
            HttpURLConnection urlConnection = (HttpURLConnection)ExportaWeb2.getURLWebService(ip, porta).openConnection();
            urlConnection.setConnectTimeout(5000);
            urlConnection.setReadTimeout(120000);
            urlConnection.setDoOutput(true);
            urlConnection.setDoInput(true);
            urlConnection.setRequestMethod("POST");
            urlConnection.setRequestProperty("Content-type", "text/xml; charset=utf-8");
            soapMessage.writeTo(urlConnection.getOutputStream());
            SOAPMessage teste = messageFactory.createMessage(null, urlConnection.getInputStream());
            SOAPBody corpo = teste.getSOAPBody();
            Iterator it = corpo.getChildElements();
            while (it.hasNext()) {
                Iterator it2 = ((SOAPElement)it.next()).getChildElements();
                if (!it2.hasNext()) continue;
                return ((SOAPElement)it2.next()).getValue();
            }
            throw new Exception("O retorno do webservice n\u00e3o est\u00e1 no formato esperado.");
        }
        catch (IOException e) {
            throw new ExportaWebException(e, "N\u00e3o foi poss\u00edvel comunicar-se com a web. Verifique sua conex\u00e3o com a internet.", null);
        }
        catch (Exception e) {
            throw new ExportaWebException(e, "Um erro ocorreu ao comunicar-se com webservice.", null);
        }
    }

    private static String trataConteudoMensagem(String conteudoMensagem, boolean isPedidoConexao) throws IOException {
        if (!Funcoes.textoVazio(conteudoMensagem)) {
            if (!isPedidoConexao) {
                conteudoMensagem = ExportaWeb2.geraEscapesXML(conteudoMensagem, "ISO-8859-1");
            }
            return StringUtil.compactar(conteudoMensagem);
        }
        return "";
    }

    private static URL getURLWebService(String ip, String porta) throws MalformedURLException {
        return new URL("http://" + ip + ":" + porta + "/" + CAMINHO_PAGINA_WEBSERVICE);
    }

    static {
        camposIgnorar = new ArrayList<String>();
        TAMANHO_MAXIMO_MENSAGEM = new Double(1024 * Variaveis.tamanhoMensagemWeb).intValue();
        debug = Funcoes.arquivoExiste(System.getProperty("user.home") + System.getProperty("file.separator") + "debug.jalis");
        ignorarDelete = Funcoes.arquivoExiste(System.getProperty("user.home") + System.getProperty("file.separator") + "ignorardelete.jalis");
        CAMPOS = new Hashtable();
        CAMPOS.put("codigoBase", new CamposWeb(1, "cfg_codigo", true));
        CAMPOS.put("laboratorioFilial", new CamposWeb(1, "cfg_laboratorio", false));
        CAMPOS.put("fraseProibido", new CamposWeb(1, "cfg_fraseproibido", false));
        CAMPOS.put("fraseIncompleto", new CamposWeb(1, "cfg_fraseandamento", false));
        CAMPOS.put("fraseResponsavel", new CamposWeb(1, "cfg_fraseassinatura", false));
        CAMPOS.put("enderecoFilial", new CamposWeb(1, "cfg_endereco", false));
        CAMPOS.put("bairroFilial", new CamposWeb(1, "cfg_bairro", false));
        CAMPOS.put("cidadeFilial", new CamposWeb(1, "cfg_cidade", false));
        CAMPOS.put("cepFilial", new CamposWeb(1, "cfg_cep", false));
        CAMPOS.put("foneFilial", new CamposWeb(1, "cfg_fone", false));
        CAMPOS.put("faxFilial", new CamposWeb(1, "cfg_fax", false));
        CAMPOS.put("responsavelFilial", new CamposWeb(1, "cfg_responsavel", false));
        CAMPOS.put("ufFilial", new CamposWeb(1, "cfg_uf", false));
        CAMPOS.put("emailFilial", new CamposWeb(1, "cfg_email", false));
        CAMPOS.put("siteFilial", new CamposWeb(1, "cfg_site", false));
        CAMPOS.put("fraseDevedor", new CamposWeb(1, "cfg_frasedevedor", false));
        CAMPOS.put("complementoFilial", new CamposWeb(1, "cfg_complemento", false));
        CAMPOS.put("razaoSocialFilial", new CamposWeb(1, "cfg_razaosocial", false));
        CAMPOS.put("cnpjFilial", new CamposWeb(1, "cfg_cnpj", false));
        CAMPOS.put("mostraDevedoraFilial", new CamposWeb(2, "cfg_verdevedora", false));
        CAMPOS.put("mostraNaoAssinadoFilial", new CamposWeb(2, "cfg_vernaoassinado", false));
        CAMPOS.put("campoBuscaPacienteFilial", new CamposWeb(1, "cfg_buscapaciente", false));
        CAMPOS.put("mostrarBotaoImprimir", new CamposWeb(2, "cfg_mostrarimprimir", false));
        CAMPOS.put("mostrarAssinatura", new CamposWeb(2, "cfg_mostrarassinatura", false));
        CAMPOS.put("imagemAssinatura", new CamposWeb(1, "cfg_imagemassinatura", false));
        CAMPOS.put("apresentarResultadoEmJanela", new CamposWeb(6, "cfg_rstemjanela", false));
        CAMPOS.put("apresentarMensagemPopup", new CamposWeb(6, "cfg_mensagempopup", false));
        CAMPOS.put("apresentarCabecalhoCliente", new CamposWeb(6, "cfg_iscabeccliente", false));
        CAMPOS.put("enviarResultadoTexto", new CamposWeb(6, "cfg_resultadotexto", false));
        CAMPOS.put("enviarResultadoPdf", new CamposWeb(6, "cfg_resultadopdf", false));
        CAMPOS.put("assinaturaExame", new CamposWeb(6, "cfg_assinaturaexame", false));
        CAMPOS.put("tipoFilial", new CamposWeb(1, "cfg_tipofilial", false));
        CAMPOS.put("mostraDevedoraPacienteFilial", new CamposWeb(2, "cfg_verdevedorapaciente", false));
        CAMPOS.put("mostraDevedoraMedicoFilial", new CamposWeb(2, "cfg_verdevedoramedico", false));
        CAMPOS.put("mostraDevedoraConvenioFilial", new CamposWeb(2, "cfg_verdevedoraconvenio", false));
        CAMPOS.put("mostraDevedoraEntidadeFilial", new CamposWeb(2, "cfg_verdevedoraentidade", false));
        CAMPOS.put("mostraDevedoraDestinoFilial", new CamposWeb(2, "cfg_verdevedoradestino", false));
        CAMPOS.put("requisicoesPorPaginaFilial", new CamposWeb(2, "cfg_webreqpagina", false));
        CAMPOS.put("trocarImagemConvenioFilial", new CamposWeb(6, "cfg_webimgconvenio", false));
        CAMPOS.put("trocarImagemDestinoFilial", new CamposWeb(6, "cfg_webimgdestino", false));
        CAMPOS.put("enviarEmailConvenioFilial", new CamposWeb(6, "cfg_webemailconvenio", false));
        CAMPOS.put("enviarEmailDestinoFilial", new CamposWeb(6, "cfg_webemaildestino", false));
        CAMPOS.put("enviarEmailEntidadeFilial", new CamposWeb(6, "cfg_webemailentidade", false));
        CAMPOS.put("enviarEmailMedicoFilial", new CamposWeb(6, "cfg_webemailmedico", false));
        CAMPOS.put("enviarEmailPacienteFilial", new CamposWeb(6, "cfg_webemailpaciente", false));
        CAMPOS.put("codigoConvenio", new CamposWeb(2, "con_codigo", true));
        CAMPOS.put("descricaoConvenio", new CamposWeb(1, "con_descricao", false));
        CAMPOS.put("senhaConvenio", new CamposWeb(1, "con_senha", false));
        CAMPOS.put("bloqueadoConvenio", new CamposWeb(2, "con_bloqueado", false));
        CAMPOS.put("mensagemPopupConvenio", new CamposWeb(6, "con_msgpopup", false));
        CAMPOS.put("conselhoMedico", new CamposWeb(1, "med_conselho", true));
        CAMPOS.put("crmMedico", new CamposWeb(1, "med_codigo", true));
        CAMPOS.put("ufMedico", new CamposWeb(1, "med_uf", true));
        CAMPOS.put("senhaMedico", new CamposWeb(1, "med_senha", false));
        CAMPOS.put("nomeMedico", new CamposWeb(1, "med_nome", false));
        CAMPOS.put("codigoExame", new CamposWeb(1, "exm_codigo", true));
        CAMPOS.put("codigoMaterialExame", new CamposWeb(2, "exm_codmaterial", true));
        CAMPOS.put("descricaoExame", new CamposWeb(1, "exm_descricao", false));
        CAMPOS.put("modoColetaExame", new CamposWeb(1, "exm_modocoleta", false));
        CAMPOS.put("sinonimoExame", new CamposWeb(1, "exm_sinonimo", false));
        CAMPOS.put("metodoExame", new CamposWeb(1, "exm_metodo", false));
        CAMPOS.put("ambExame", new CamposWeb(1, "exm_amb", false));
        CAMPOS.put("cbhpmExame", new CamposWeb(1, "exm_cbhpm", false));
        CAMPOS.put("prazoExame", new CamposWeb(1, "exm_prazo", false));
        CAMPOS.put("valorReferenciaExame", new CamposWeb(1, "exm_referencia", false));
        CAMPOS.put("interferenciaExame", new CamposWeb(1, "exm_interferencia", false));
        CAMPOS.put("diagnosticoExame", new CamposWeb(1, "exm_diagnostico", false));
        CAMPOS.put("modoPreparoExame", new CamposWeb(1, "exm_modopreparo", false));
        CAMPOS.put("materialExame", new CamposWeb(1, "exm_material", false));
        CAMPOS.put("preparoAmostraExame", new CamposWeb(1, "exm_prepamostra", false));
        CAMPOS.put("amostraInadequadaExame", new CamposWeb(1, "exm_inadequada", false));
        CAMPOS.put("conservacaoExame", new CamposWeb(1, "exm_conservacao", false));
        CAMPOS.put("procedimentoExame", new CamposWeb(1, "exm_procedimento", false));
        CAMPOS.put("bloqueadoExame", new CamposWeb(6, "exm_bloqueado", false));
        CAMPOS.put("assinaturaPadraoExame", new CamposWeb(1, "exm_assinaturapadrao", false));
        CAMPOS.put("proibidoPaciente", new CamposWeb(6, "exm_proibidopaciente", false));
        CAMPOS.put("proibidoConvenio", new CamposWeb(6, "exm_proibidoconvenio", false));
        CAMPOS.put("proibidoMedico", new CamposWeb(6, "exm_proibidomedico", false));
        CAMPOS.put("proibidoDestino", new CamposWeb(6, "exm_proibidodestino", false));
        CAMPOS.put("proibidoFiscal", new CamposWeb(6, "exm_proibidofiscal", false));
        CAMPOS.put("proibidoResponsavel", new CamposWeb(6, "exm_proibidoresponsavel", false));
        CAMPOS.put(CODIGO_REQUISICAO, new CamposWeb(2, "req_codigo", true));
        CAMPOS.put("dataRequisicao", new CamposWeb(4, "req_data", false));
        CAMPOS.put("horaRequisicao", new CamposWeb(5, "req_hora", false));
        CAMPOS.put("destinoRequisicao", new CamposWeb(1, "des_descricao", false));
        CAMPOS.put("coletaRequisicao", new CamposWeb(1, "col_descricao", false));
        CAMPOS.put("codigoConvenioRequisicao", new CamposWeb(2, "con_codigo", false));
        CAMPOS.put("conselhoMedicoRequisicao", new CamposWeb(1, "med_conselho", false));
        CAMPOS.put("crmMedicoRequisicao", new CamposWeb(1, "med_codigo", false));
        CAMPOS.put("ufMedicoRequisicao", new CamposWeb(1, "med_uf", false));
        CAMPOS.put("idadeRequisicao", new CamposWeb(1, "req_idade", false));
        CAMPOS.put("dataNascimentoRequisicao", new CamposWeb(4, "req_dtnascimento", false));
        CAMPOS.put("senhaRequisicao", new CamposWeb(1, "req_senha", false));
        CAMPOS.put("valorRequisicao", new CamposWeb(3, "req_total", false));
        CAMPOS.put("valorPagoRequisicao", new CamposWeb(3, "req_valorpago", false));
        CAMPOS.put("codigoPacienteRequisicao", new CamposWeb(2, "pac_codigo", false));
        CAMPOS.put("dadosCabecalhoRequisicao", new CamposWeb(1, "req_dadoscabec", false));
        CAMPOS.put("codigoDestinoRequisicao", new CamposWeb(1, "des_codigo", false));
        CAMPOS.put("entidadeRequisicao", new CamposWeb(2, "ent_codigo", false));
        CAMPOS.put("resultadoPdfRequisicao", new CamposWeb(1, "req_resultadopdf", false));
        CAMPOS.put("dataRecebimentoProdutoRequisicao", new CamposWeb(4, "req_datarecebimentoproduto", false));
        CAMPOS.put("dataColetaProdutoRequisicao", new CamposWeb(4, "req_datacoletaproduto", false));
        CAMPOS.put("horaRecebimentoProdutoRequisicao", new CamposWeb(1, "req_horarecebimentoproduto", false));
        CAMPOS.put("horaColetaProdutoRequisicao", new CamposWeb(1, "req_horacoletaproduto", false));
        CAMPOS.put("descricaoProdutoRequisicao", new CamposWeb(1, "req_descricaoproduto", false));
        CAMPOS.put("numeroLoteProdutoRequisicao", new CamposWeb(1, "req_numeroloteproduto", false));
        CAMPOS.put("lacreProdutoRequisicao", new CamposWeb(1, "req_lacreproduto", false));
        CAMPOS.put("situacaoRequisicao", new CamposWeb(1, "req_situacao", false));
        CAMPOS.put("numeroSolicitacao", new CamposWeb(1, "req_nrsolicitacaoproduto", false));
        CAMPOS.put("prontuarioRequisicao", new CamposWeb(1, "req_prontuario", false));
        CAMPOS.put(CODIGO_EXAME_REQUISICAO, new CamposWeb(1, "exm_codigo", true));
        CAMPOS.put(MATERIAL_EXAME_REQUISICAO, new CamposWeb(2, "exm_codmaterial", true));
        CAMPOS.put(CODIGO_EXAME_REQUISICAO, new CamposWeb(1, "exm_codigo", true));
        CAMPOS.put(MATERIAL_EXAME_REQUISICAO, new CamposWeb(2, "exm_codmaterial", true));
        CAMPOS.put("descricaoMaterialExameRequisicao", new CamposWeb(1, "rex_descricaomaterial", false));
        CAMPOS.put("dataColetaExameRequisicao", new CamposWeb(4, "rex_datacoleta", false));
        CAMPOS.put("horaColetaExameRequisicao", new CamposWeb(5, "rex_horacoleta", false));
        CAMPOS.put("paginaExameRequisicao", new CamposWeb(2, "rex_pagina", false));
        CAMPOS.put("ordemExameRequisicao", new CamposWeb(2, "rex_ordem", false));
        CAMPOS.put(SITUACAO_EXAME_REQUISICAO, new CamposWeb(1, "rex_situacao", false));
        CAMPOS.put("assinaturaExameRequisicao", new CamposWeb(1, "usr_assinatura", false));
        CAMPOS.put("nomeAssinaturaExameRequisicao", new CamposWeb(1, "rex_nomeassinatura", false));
        CAMPOS.put("resultadoExameRequisicao", new CamposWeb(1, "rex_resultado", false));
        CAMPOS.put("dataEnvioExameRequisicao", new CamposWeb(2, "rex_dataenvio", false));
        CAMPOS.put("resultadoTextoExameRequisicao", new CamposWeb(1, "rex_resultadotexto", false));
        CAMPOS.put("contadorPaginaExameRequisicao", new CamposWeb(2, "rex_contadorpagina", true, true));
        CAMPOS.put("codigoUsuarioConferenciaExameRequisicao", new CamposWeb(1, "usr_codigoconferencia", false));
        CAMPOS.put("codigoImagemExame", new CamposWeb(2, "rei_codigo", true));
        CAMPOS.put("imagemExame", new CamposWeb(1, "rei_imagem", false));
        CAMPOS.put("codigoPaciente", new CamposWeb(2, "pac_codigo", true));
        CAMPOS.put("nomePaciente", new CamposWeb(1, "pac_nome", false));
        CAMPOS.put("senhaPaciente", new CamposWeb(1, "pac_senha", false));
        CAMPOS.put("cpfPaciente", new CamposWeb(1, "pac_cpf", false));
        CAMPOS.put("sifPaciente", new CamposWeb(1, "pac_sif", false));
        CAMPOS.put("proprietarioPaciente", new CamposWeb(1, "pac_proprietario", false));
        CAMPOS.put("bloqueadoWebPaciente", new CamposWeb(1, "pac_proibidoweb", false));
        CAMPOS.put("codigoMensagem", new CamposWeb(2, "mec_codigo", true));
        CAMPOS.put("textoMensagem", new CamposWeb(1, "mec_mensagem", false));
        CAMPOS.put("dataMensagem", new CamposWeb(2, "mec_data", false));
        CAMPOS.put("tituloMensagem", new CamposWeb(1, "mec_titulo", false));
        CAMPOS.put("codigoDestino", new CamposWeb(1, "des_codigo", true));
        CAMPOS.put("descricaoDestino", new CamposWeb(1, "des_descricao", false));
        CAMPOS.put("senhaDestino", new CamposWeb(1, "des_senha", false));
        CAMPOS.put("ativadoDestino", new CamposWeb(6, "des_ativado", false));
        CAMPOS.put("conselhoMedicoExame", new CamposWeb(1, "med_conselho", true));
        CAMPOS.put("crmMedicoExame", new CamposWeb(1, "med_codigo", true));
        CAMPOS.put("ufMedicoExame", new CamposWeb(1, "med_uf", true));
        CAMPOS.put("codigoExameMedicoExame", new CamposWeb(1, "exm_codigo", true));
        CAMPOS.put("proibidoMedicoExame", new CamposWeb(1, "mee_proibido", false));
        CAMPOS.put("codigoEntidade", new CamposWeb(2, "ent_codigo", true));
        CAMPOS.put("tipoEntidade", new CamposWeb(1, "ent_tipo", true));
        CAMPOS.put("nomeEntidade", new CamposWeb(1, "ent_nome", false));
        CAMPOS.put("senhaEntidade", new CamposWeb(1, "ent_senha", false));
        CAMPOS.put("cpfEntidade", new CamposWeb(1, "ent_cpf", false));
        CAMPOS.put("codigoUsuario", new CamposWeb(1, "usr_codigo", true));
        CAMPOS.put("nomeUsuario", new CamposWeb(1, "usr_nome", false));
        CAMPOS.put("assinaturaUsuario", new CamposWeb(1, "usr_imagemassinatura", false));
        CAMPOS.put("codigoRequisicaoResultado", new CamposWeb(2, "rer_id", true));
        CAMPOS.put("codigoHash", new CamposWeb(1, "rer_hash", false));
        CAMPOS.put("dataConferencia", new CamposWeb(7, "rer_dataconferencia", false));
        CAMPOS.put("codigoUsuarioConferenciaExameRequisicaoResultado", new CamposWeb(1, "usr_codconferencia", false));
        CAMPOS.put("resultadoPdf", new CamposWeb(1, "rer_resultadopdf", false));
        CAMPOS.put("resultadoTexto", new CamposWeb(1, "rer_resultadotexto", false));
        CAMPOS.put("desatualizado", new CamposWeb(6, "rer_desatualizado", false));
        CAMPOS.put("codigoExameRequisicaoResultadoPagina", new CamposWeb(1, "exm_codigo", true));
        CAMPOS.put("codigoMaterialExameRequisicaoResultadoPagina", new CamposWeb(2, "exm_codmaterial", true));
        CAMPOS.put("contadorPaginaRequisicaoExameResultadoPagina", new CamposWeb(2, "rep_contadorpagina", true));
        CAMPOS.put("resultadoHtmlRequisicaoExameResultadoPagina", new CamposWeb(1, "rep_resultadohtml", false));
        CAMPOS.put("pacienteRequisicaoPdf", new CamposWeb(1, "pdf_paciente", false));
        CAMPOS.put("convenioRequisicaoPdf", new CamposWeb(1, "pdf_convenio", false));
        CAMPOS.put("destinoRequisicaoPdf", new CamposWeb(1, "pdf_destino", false));
        CAMPOS.put("medicoRequisicaoPdf", new CamposWeb(1, "pdf_medico", false));
        CAMPOS.put("fiscalRequisicaoPdf", new CamposWeb(1, "pdf_fiscal", false));
        CAMPOS.put("responsavelRequisicaoPdf", new CamposWeb(1, "pdf_responsavel", false));
    }

    private static enum RetornoPedidoEnvioWebservice {
        NAO_PERMITIDO(0),
        PERMITIDO(1),
        CODIGO_CLIENTE_INVALIDO(2),
        PARAMETRO_INCORRETO(3),
        PARAMETRO_SESSION_PROCESSANDO(4),
        MARCAR_EXPORTADO(5);

        int codigo = -1;

        private RetornoPedidoEnvioWebservice(int codigo) {
            this.codigo = codigo;
        }
    }
}

