/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.exportacao.thread;

import jalis.comum.Conexao;
import jalis.comum.ConexaoTemporaria;
import jalis.comum.ConexaoWeb;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.exportacao.integracao.IntegracaoUtil;
import jalis.laboratorio.exportacao.thread.CamposWeb;
import jalis.laboratorio.exportacao.thread.ComandoLog;
import jalis.laboratorio.exportacao.thread.ExportaWeb2;
import jalis.laboratorio.exportacao.util.ExportacaoMonitor;
import jalis.laboratorio.exportacao.util.ExportacaoMonitorListener;
import jalis.laboratorio.resultados.ImpressaoResultados;
import jalis.laboratorio.resultados.RetornoImpressaoResultados;
import jalis.mensagens.VerificaMensagens;
import jalis.model.vo.cadastro.auxiliares.FilialVOAux;
import jalis.service.cadastro.FilialService;
import jalis.service.exportadores.ExportaWebService;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.StringUtil;
import jalis.util.ThreadListener;
import jalis.util.logger.ErrorLogger;
import jalis.util.sql.SalvaDados;
import java.io.File;
import java.io.StringReader;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;
import javax.swing.event.EventListenerList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.codec.binary.Base64;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ExportaWeb
extends Thread
implements ExportacaoMonitorListener {
    private static final String SITUACAO_EXAME_REQUISICAO = "situacaoExameRequisicao";
    public static final String CODIGO_REQUISICAO = "codigoRequisicao";
    public static final String MATERIAL_EXAME_REQUISICAO = "materialExameRequisicao";
    public static final String CODIGO_EXAME_REQUISICAO = "codigoExameRequisicao";
    private boolean parar = false;
    private boolean exportandoDados = false;
    public static Hashtable CAMPOS;
    public static List<String> camposIgnorar;
    private EventListenerList listenerList = new EventListenerList();
    private JProgressBar progresso;
    private JTextArea txtMensagens;
    private boolean automatico = true;
    private boolean ignorarFilial = false;
    private boolean mostrarIcones = true;
    private Date ultimaExportacaoValida = new Date();
    public static final String CHAVE_CONFIGURACAO = "configuracao";
    public static final String CHAVE_CONVENIO = "convenios";
    public static final String CHAVE_MEDICO = "medicos";
    public static final String CHAVE_REQUISICAO = "requisicao";
    public static final String CHAVE_REQUISICAOEXAME = "requisicaoexame";
    public static final String CHAVE_REQUISICAOEXAMEIMAGEM = "requisicaoexameimagem";
    public static final String CHAVE_EXAMES = "exames";
    public static final String CHAVE_PACIENTES = "paciente";
    public static final String CHAVE_ENTIDADES = "entidade";
    public static final String CHAVE_PACIENTE_ENTIDADE = "pacienteentidade";
    public static final String CHAVE_MENSAGENS = "mensagensconvenio";
    public static final String CHAVE_DESTINO = "destinos";
    public static final String CHAVE_MEDICOEXAME = "medicosexames";
    public static final String CHAVE_USUARIO = "usuario";
    public static final String CHAVE_REQUISICAOEXAMERESULTADO = "requisicaoexameresultado";
    public static final String CHAVE_REQUISICAOEXAMERESULTADOPAGINA = "requisicaoexameresultadopagina";
    public static final String CHAVE_REQUISICAOPDF = "requisicaopdf";
    public static final String GRUPO_EXAMES_PACIENTE = "paciente";
    public static final String GRUPO_EXAMES_MEDICO = "medico";
    public static final String GRUPO_EXAMES_CONVENIO = "convenio";
    public static final String GRUPO_EXAMES_DESTINO = "destino";
    public static final String GRUPO_EXAMES_FISCAL = "fiscal";
    public static final String GRUPO_EXAMES_RESPONSAVEL = "responsavel";
    public static final String PDF_PACIENTE = "pdfPaciente";
    public static final String PDF_MEDICO = "pdfMedico";
    public static final String PDF_CONVENIO = "pdfConvenio";
    public static final String PDF_EXAME = "pdfExame";
    public static final String PDF_DESTINO = "pdfDestino";
    public static final String PDF_FISCAL = "pdfFiscal";
    public static final String PDF_RESPONSAVEL = "pdfResponsavel";
    public static final String TAG_FILIAL = "filial";
    public static final String OPERACAO_INSERIR = "I";
    public static final String OPERACAO_ALTERAR = "A";
    public static final String OPERACAO_DELETAR = "D";
    public ExportacaoMonitor exportacaoMonitor = new ExportacaoMonitor();
    private long tempoEspera = 0L;
    private int totalParaEnviar = 0;
    private Date tempoIteracaoAnterior = null;
    private long mediaTempoIteracoes = 0L;
    private static ConexaoWeb conexaoWeb;
    private static boolean debug;

    public ExportaWeb() {
        super("Thread - ExportaWeb");
        conexaoWeb = new ConexaoWeb();
        this.setPriority(1);
        if (debug) {
            System.out.println("ANTIGA exporta web");
        }
        this.setIgnorarFiliais(true);
        Statement st = ConexaoTemporaria.getStatement();
        StringBuilder del = new StringBuilder("delete from exportaweb where ewe_datahora < current_date - 5");
        try {
            ConexaoTemporaria.execute(Variaveis.filialPadrao, st, del);
            ConexaoTemporaria.arquivaSQL();
        }
        catch (Exception ex) {
            try {
                ConexaoTemporaria.anulaSQL();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.exportacaoMonitor.addExportacaoListener(Laboratorio.getJanelaMonitoramentoExpoWeb());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        this.fireIniciouExecucao();
        Statement st = ConexaoTemporaria.getStatement();
        Statement stUpdate = ConexaoTemporaria.getStatement();
        this.mostraMensagem("Buscando dados a serem exportados");
        int registros = 0;
        while (true) {
            block57: {
                int contador;
                ResultSet rs;
                String operacao;
                block56: {
                    if (!this.parar) {
                        operacao = "";
                        String codigo = "";
                        try {
                            if (this.totalParaEnviar == 0) {
                                this.ultimaExportacaoValida = new Date();
                                this.exportacaoMonitor.setQuantidadeLogEnvio(0);
                                this.exportacaoMonitor.setQuantidadeParaEnviar(0);
                                this.exportacaoMonitor.setLogAtual(0);
                                this.mediaTempoIteracoes = 0L;
                                this.tempoIteracaoAnterior = null;
                            }
                            this.totalParaEnviar = this.getTotalParaExportar(st);
                            rs = st.executeQuery(this.getSelect(ParametrosGerais.getWebArquivo()));
                            this.mostraMensagem(ParametrosGerais.getWebArquivo() ? "Criando arquivos para exporta\u00e7\u00e3o para Internet" : "Enviando dados");
                            registros = DBUtil.qtdeRegistros(rs);
                            contador = 1;
                            if (registros > 0) {
                                conexaoWeb = new ConexaoWeb();
                            }
                            if (ParametrosGerais.getWebArquivo() && registros > 0) {
                                if (Funcoes.textoVazio(ParametrosLocais.getParametro("webArquivo")) || Funcoes.diretorioExiste(ParametrosLocais.getParametro("webArquivo"))) {
                                    if (this.mostrarIcones) {
                                        Laboratorio.setIconeEstacao(ImagemUtils.carregaImagemJalis("enviando_internet_on.gif"));
                                    }
                                    break block56;
                                }
                                if (this.mostrarIcones) {
                                    Laboratorio.setIconeEstacao(ImagemUtils.carregaImagemJalis("enviando_internet_erro.gif"));
                                    Laboratorio.setHintEstacao("Diret\u00f3rio n\u00e3o localizado");
                                    VerificaMensagens.mostraErro(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel enviar resultados para internet. Diret\u00f3rio n\u00e3o localizado");
                                }
                                break block57;
                            }
                            if (registros <= 0) break block57;
                            this.mostraMensagem("Conectando na base web");
                            if (!conexaoWeb.getConnected()) {
                                Laboratorio.setIconeEstacao(ImagemUtils.carregaImagemJalis("enviando_internet_erro.gif"));
                                Laboratorio.setHintEstacao("N\u00e3o foi poss\u00edvel conectar na base web");
                                VerificaMensagens.mostraErro(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel enviar resultados para internet. N\u00e3o foi poss\u00edvel conectar na base web");
                                break block57;
                            }
                            if (this.mostrarIcones) {
                                Laboratorio.setIconeEstacao(ImagemUtils.carregaImagemJalis("enviando_internet_on.gif"));
                            }
                            Statement stWeb = conexaoWeb.getStatement();
                            stWeb.execute("set statement_timeout=240000");
                            try {
                                if (this.progresso != null) {
                                    this.progresso.setMaximum(registros);
                                    if (this.progresso.getMaximum() > 0) {
                                        this.mostraMensagem("Enviando dados");
                                    }
                                }
                                Calendar calendar = Calendar.getInstance();
                                long timeTemp = calendar.getTime().getTime();
                                while (rs.next() && !this.parar) {
                                    this.exportandoDados = true;
                                    codigo = rs.getString("ewe_codigo");
                                    String xmlExportaWeb = this.getOperacao(stUpdate, rs.getString("fil_codigo"), rs.getString("ewe_codigo"));
                                    String[] operacoes = this.criaComando(stWeb, xmlExportaWeb, rs.getString("ewe_tipooperacao"));
                                    int qtdeAlterada = 0;
                                    for (String aux : operacoes) {
                                        if (Funcoes.textoVazio(aux)) continue;
                                        qtdeAlterada += conexaoWeb.executeUpdate(stWeb, aux);
                                        String diretorioUsuario = System.getProperty("user.home");
                                        if (!diretorioUsuario.endsWith("/")) {
                                            diretorioUsuario = diretorioUsuario + "/";
                                        }
                                        File f = new File(diretorioUsuario + "logswebjalis.debug");
                                        if (qtdeAlterada != 0 || !f.exists()) continue;
                                        File diretorio = new File(diretorioUsuario + "logswebjalis");
                                        if (!diretorio.exists()) {
                                            diretorio.mkdir();
                                        }
                                        StringUtil.escreverArquivoTexto(diretorioUsuario + "logswebjalis/log" + rs.getString("ewe_codigo") + ".comandojalis", aux);
                                    }
                                    this.marcaExportado(stUpdate, rs.getString("fil_codigo"), rs.getString("ewe_codigo"));
                                    this.exportandoDados = false;
                                    if (this.progresso != null) {
                                        this.progresso.setValue(rs.getRow());
                                    }
                                    Laboratorio.setHintEstacao("Enviando: " + String.valueOf(contador++) + " de " + String.valueOf(registros) + " de um total de " + String.valueOf(this.totalParaEnviar));
                                    this.exportacaoMonitor.setQuantidadeParaEnviar(this.totalParaEnviar);
                                    this.exportacaoMonitor.setOperacaoAtual(xmlExportaWeb);
                                    this.exportacaoMonitor.setLogAtual(contador - 1);
                                    this.exportacaoMonitor.setQuantidadeLogEnvio(registros);
                                    this.atualizaTempoEntreIteracoes();
                                    try {
                                        ExportaWeb.sleep(10L);
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    timeTemp = Calendar.getInstance().getTimeInMillis();
                                }
                                this.mostraMensagem("Arquivando dados");
                                conexaoWeb.arquivaSQL();
                                ConexaoTemporaria.arquivaSQL();
                                conexaoWeb.shutdown();
                                this.ultimaExportacaoValida = new Date();
                                if (this.progresso != null) {
                                    this.progresso.setValue(0);
                                }
                                if (this.mostrarIcones) {
                                    Laboratorio.setIconeEstacao(ImagemUtils.carregaImagemJalis("enviando_internet_off.gif"));
                                }
                                break block57;
                            }
                            catch (Exception ex) {
                                try {
                                    conexaoWeb.anulaSQL();
                                    ConexaoTemporaria.anulaSQL();
                                    if (this.mostrarIcones) {
                                        Laboratorio.setIconeEstacao(ImagemUtils.carregaImagemJalis("enviando_internet_erro.gif"));
                                        VerificaMensagens.mostraErro(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel gravar os resultados para internet");
                                    }
                                }
                                catch (SQLException sQLException) {
                                    // empty catch block
                                }
                                ErrorLogger.mostraMensagem(null, ex.getMessage() + "\n(" + codigo + ")", ex.getStackTrace(), "ExportaWeb (332) \n" + codigo);
                                break block57;
                            }
                            finally {
                                this.exportandoDados = false;
                                this.mostraMensagem("Finalizando conex\u00e3o com web");
                                conexaoWeb.fecharStatement(stWeb);
                                conexaoWeb.shutdown();
                            }
                        }
                        catch (InterruptedException ex) {
                            if (!this.mostrarIcones) continue;
                            Laboratorio.setIconeEstacao(ImagemUtils.carregaImagemJalis("enviando_internet_erro.gif"));
                            VerificaMensagens.mostraErro(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel enviar resultados para internet");
                            continue;
                        }
                        catch (Exception ex) {
                            if (this.mostrarIcones) {
                                Laboratorio.setIconeEstacao(ImagemUtils.carregaImagemJalis("enviando_internet_erro.gif"));
                                VerificaMensagens.mostraErro(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel processar os resultados para internet");
                            }
                            this.parar = true;
                            this.exportandoDados = false;
                            ErrorLogger.mostraMensagem(null, ex.getMessage() + "\n\n (" + codigo + ") \n" + operacao, ex.getStackTrace(), "ExportaWeb");
                            continue;
                        }
                    }
                    if (conexaoWeb != null) {
                        conexaoWeb.shutdown();
                    }
                    this.exportacaoMonitor.setQuantidadeLogEnvio(0);
                    this.exportacaoMonitor.setQuantidadeParaEnviar(0);
                    this.exportacaoMonitor.setLogAtual(0);
                    this.mediaTempoIteracoes = 0L;
                    this.tempoIteracaoAnterior = null;
                    this.mostraMensagem("Finalizando conex\u00f5es");
                    ConexaoTemporaria.fecharStatement(st);
                    this.fireTerminouExecucao();
                    return;
                }
                try {
                    while (rs.next()) {
                        this.atualizaTempoEntreIteracoes();
                        operacao = this.getOperacao(stUpdate, rs.getString("fil_codigo"), rs.getString("ewe_codigo"));
                        String tipoOperacao = rs.getString("ewe_tipooperacao");
                        if (operacao != null && !Funcoes.textoVazio(operacao)) {
                            String path = ParametrosLocais.getParametro("webArquivo");
                            if (!path.endsWith("/")) {
                                path = path + "/";
                            }
                            String arquivo = "w" + tipoOperacao + Funcoes.preencheZero(rs.getString("ewe_codigo"), 10) + ".xml";
                            while (Funcoes.arquivoExiste(path + arquivo)) {
                                arquivo = "w" + tipoOperacao + Funcoes.preencheZero(rs.getString("ewe_codigo"), 10) + "_.xml";
                            }
                            this.mostraMensagem("Criando arquivo " + arquivo);
                            StringUtil.escreverArquivoTexto(path + arquivo, operacao);
                            this.marcaExportado(stUpdate, rs.getString("fil_codigo"), rs.getString("ewe_codigo"));
                            if (!(Funcoes.textoVazio(StringUtil.getValor(operacao, CODIGO_REQUISICAO)) || Funcoes.textoVazio(StringUtil.getValor(operacao, MATERIAL_EXAME_REQUISICAO)) || Funcoes.textoVazio(StringUtil.getValor(operacao, CODIGO_EXAME_REQUISICAO)))) {
                                StringBuilder sqlRemoveLogExportacao = new StringBuilder();
                                sqlRemoveLogExportacao.append("delete from exportapdf where est_codigo = ").append(Variaveis.codigoEstacao);
                                sqlRemoveLogExportacao.append(" and fil_codigo = ").append(rs.getString("fil_codigo"));
                                sqlRemoveLogExportacao.append(" and req_codigo = ").append(StringUtil.getValor(operacao, CODIGO_REQUISICAO));
                                sqlRemoveLogExportacao.append(" and exa_codigo = '").append(StringUtil.getValor(operacao, CODIGO_EXAME_REQUISICAO)).append("'");
                                sqlRemoveLogExportacao.append(" and mco_codigo = ").append(StringUtil.getValor(operacao, MATERIAL_EXAME_REQUISICAO));
                                st.execute(sqlRemoveLogExportacao.toString());
                            }
                            Laboratorio.setHintEstacao("Enviando: " + String.valueOf(contador++) + " de " + String.valueOf(registros) + " de um total de " + String.valueOf(this.totalParaEnviar));
                            this.exportacaoMonitor.setQuantidadeParaEnviar(this.totalParaEnviar);
                            this.exportacaoMonitor.setOperacaoAtual(operacao);
                            this.exportacaoMonitor.setLogAtual(contador - 1);
                            this.exportacaoMonitor.setQuantidadeLogEnvio(registros);
                        }
                        try {
                            ExportaWeb.sleep(10L);
                        }
                        catch (Exception path) {
                        }
                    }
                    this.mostraMensagem("Arquivando dados");
                    ConexaoTemporaria.arquivaSQL();
                    this.ultimaExportacaoValida = new Date();
                    if (this.progresso != null) {
                        this.progresso.setValue(0);
                    }
                    if (this.mostrarIcones) {
                        Laboratorio.setIconeEstacao(ImagemUtils.carregaImagemJalis("enviando_internet_off.gif"));
                    }
                }
                catch (SQLException ex) {
                    try {
                        ConexaoTemporaria.anulaSQL();
                    }
                    catch (SQLException path) {
                        // empty catch block
                    }
                    if (this.mostrarIcones) {
                        Laboratorio.setIconeEstacao(ImagemUtils.carregaImagemJalis("enviando_internet_erro.gif"));
                        VerificaMensagens.mostraErro(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel enviar resultados para internet");
                    }
                    Laboratorio.setHintEstacao(ex.getMessage());
                    ErrorLogger.mostraMensagem(null, ex.getMessage() + "\n(" + operacao + ")", ex.getStackTrace(), "ExportaWeb (247)\n" + operacao);
                }
                if (this.mostrarIcones) {
                    Laboratorio.setIconeEstacao(ImagemUtils.carregaImagemJalis("enviando_internet_off.gif"));
                }
            }
            if (!this.automatico) {
                this.parar();
            } else {
                String tempo = ParametrosLocais.getParametro("tempoExportacaoWeb");
                this.tempoEspera = Funcoes.isNumeric(tempo) && Integer.parseInt(tempo) > 0 ? (long)(Integer.parseInt(tempo) * 1000) : 5000L;
                this.exportacaoMonitor.setTempoProximaIteracao(this.tempoEspera);
                ExportaWeb.sleep(this.tempoEspera);
            }
            if (conexaoWeb != null) {
                conexaoWeb.shutdown();
            }
            this.validaTempoSemExportacao();
            continue;
            finally {
                this.exportandoDados = false;
                if (conexaoWeb == null) continue;
                conexaoWeb.shutdown();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validaTempoSemExportacao() {
        if (Funcoes.diferencaEmHoras(this.ultimaExportacaoValida, new Date()) > 0) {
            Statement st = ConexaoTemporaria.getStatement();
            Statement st2 = ConexaoTemporaria.getStatement();
            try {
                String sql = "select usr_codigo from usuario where usr_inativo = false and usr_mensagemweb = true";
                try (ResultSet rs = null;){
                    rs = st.executeQuery(sql);
                    while (rs.next()) {
                        this.enviarMensagem(st2, Funcoes.textoVazio(Variaveis.login) ? rs.getString(1) : Variaveis.login, rs.getString(1));
                    }
                }
                VerificaMensagens.mostraErro(Laboratorio.getInstancia(), "Verifique a exporta\u00e7\u00e3o para web, muito tempo sem exportar");
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace(), "ExportaWeb (520)");
            }
            finally {
                ConexaoTemporaria.fecharStatement(st);
                ConexaoTemporaria.fecharStatement(st2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enviarMensagem(Statement st, String usuarioOrigem, String usuarioDestino) {
        try {
            SalvaDados salvar = new SalvaDados("usuariomensagem", 0);
            salvar.adicionaCampo("usr_codorigem", 0, false, false, usuarioOrigem);
            salvar.adicionaCampo("usr_coddestino", 0, false, false, usuarioDestino);
            salvar.adicionaCampo("ume_assunto", 0, false, false, "Erro de exporta\u00e7\u00e3o para web");
            salvar.adicionaCampo("ume_mensagem", 0, false, false, "Verifique a exporta\u00e7\u00e3o para web, pois a mesma esta sem enviar resultados a muito tempo");
            salvar.adicionaCampo("ume_confirmarleitura", 4, false, false, false);
            String comando = salvar.getComando();
            ConexaoTemporaria.execute(st, comando);
            ConexaoTemporaria.arquivaSQL();
        }
        catch (Exception e) {
            try {
                ConexaoTemporaria.anulaSQL();
            }
            catch (Exception exception) {
                // empty catch block
            }
            e.printStackTrace();
        }
        finally {
            ConexaoTemporaria.fecharStatement(st);
        }
    }

    public void parar() {
        this.parar = true;
    }

    public boolean exportando() {
        return this.exportandoDados;
    }

    private String[] criaComando(Statement st, String op, String tipo) throws SQLException {
        String tmp = StringUtil.getValor(op, CHAVE_CONFIGURACAO);
        if (!Funcoes.textoVazio(tmp)) {
            return new String[]{this.montaConfiguracao(op)};
        }
        tmp = StringUtil.getValor(op, CHAVE_CONVENIO);
        if (!Funcoes.textoVazio(tmp)) {
            return new String[]{this.montaConvenio(st, op, tipo)};
        }
        tmp = StringUtil.getValor(op, CHAVE_MEDICO);
        if (!Funcoes.textoVazio(tmp)) {
            return new String[]{this.montaMedico(st, op, tipo)};
        }
        tmp = StringUtil.getValor(op, CHAVE_EXAMES);
        if (!Funcoes.textoVazio(tmp)) {
            return new String[]{this.montaExame(st, op, tipo)};
        }
        tmp = StringUtil.getValor(op, CHAVE_REQUISICAO);
        if (!Funcoes.textoVazio(tmp)) {
            return new String[]{this.montaRequisicao(st, op, tipo)};
        }
        tmp = StringUtil.getValor(op, CHAVE_REQUISICAOEXAME);
        if (!Funcoes.textoVazio(tmp)) {
            String requisicaoExame = this.montaRequisicaoExame(st, op, tipo);
            return new String[]{requisicaoExame};
        }
        tmp = StringUtil.getValor(op, CHAVE_REQUISICAOEXAMERESULTADOPAGINA);
        if (!Funcoes.textoVazio(tmp)) {
            return new String[]{this.montaRequisicaoExameResultadoPagina(st, op, tipo)};
        }
        tmp = StringUtil.getValor(op, CHAVE_REQUISICAOEXAMEIMAGEM);
        if (!Funcoes.textoVazio(tmp)) {
            return new String[]{this.montaRequisicaoExameImagem(st, op, tipo)};
        }
        tmp = StringUtil.getValor(op, "paciente");
        if (!Funcoes.textoVazio(tmp)) {
            return new String[]{this.montaPaciente(st, op, tipo)};
        }
        tmp = StringUtil.getValor(op, CHAVE_ENTIDADES);
        if (!Funcoes.textoVazio(tmp)) {
            return new String[]{this.montaEntidade(st, op, tipo)};
        }
        tmp = StringUtil.getValor(op, CHAVE_PACIENTE_ENTIDADE);
        if (!Funcoes.textoVazio(tmp)) {
            return new String[]{this.montaPacienteEntidade(st, op, tipo)};
        }
        tmp = StringUtil.getValor(op, CHAVE_MENSAGENS);
        if (!Funcoes.textoVazio(tmp)) {
            return new String[]{this.montaMensagem(st, op, tipo)};
        }
        tmp = StringUtil.getValor(op, CHAVE_DESTINO);
        if (!Funcoes.textoVazio(tmp)) {
            return new String[]{this.montaDestino(st, op, tipo)};
        }
        tmp = StringUtil.getValor(op, CHAVE_MEDICOEXAME);
        if (!Funcoes.textoVazio(tmp)) {
            return new String[]{this.montaMedicoExame(st, op, tipo)};
        }
        tmp = StringUtil.getValor(op, CHAVE_USUARIO);
        if (!Funcoes.textoVazio(tmp)) {
            return new String[]{this.montaUsuario(st, op, tipo)};
        }
        return new String[]{""};
    }

    public static List<ComandoLog> geraPdfExportaWeb1(Statement stJalis, Statement stWeb, String operacao, String tipo, String codigoFilial) throws SQLException {
        ArrayList<ComandoLog> comandoLogs = new ArrayList<ComandoLog>();
        String xmlExportacao = StringUtil.tratarUnicode(operacao, true);
        String codigoRequisicao = StringUtil.getValor(operacao, CODIGO_REQUISICAO);
        Map<String, String> listaPdfs = new ExportaWebService().gerarDadosWeb(operacao, codigoFilial, codigoRequisicao, stJalis);
        comandoLogs.add(ExportaWeb.montaRequisicaoPdf(stWeb, stJalis, operacao, tipo, listaPdfs, codigoFilial, codigoRequisicao, PDF_DESTINO, false));
        comandoLogs.add(ExportaWeb.montaRequisicaoPdf(stWeb, stJalis, operacao, OPERACAO_ALTERAR, listaPdfs, codigoFilial, codigoRequisicao, PDF_CONVENIO, true));
        comandoLogs.add(ExportaWeb.montaRequisicaoPdf(stWeb, stJalis, operacao, OPERACAO_ALTERAR, listaPdfs, codigoFilial, codigoRequisicao, PDF_MEDICO, true));
        comandoLogs.add(ExportaWeb.montaRequisicaoPdf(stWeb, stJalis, operacao, OPERACAO_ALTERAR, listaPdfs, codigoFilial, codigoRequisicao, PDF_PACIENTE, true));
        comandoLogs.add(ExportaWeb.montaRequisicaoPdf(stWeb, stJalis, operacao, OPERACAO_ALTERAR, listaPdfs, codigoFilial, codigoRequisicao, PDF_FISCAL, true));
        comandoLogs.add(ExportaWeb.montaRequisicaoPdf(stWeb, stJalis, operacao, OPERACAO_ALTERAR, listaPdfs, codigoFilial, codigoRequisicao, PDF_RESPONSAVEL, true));
        String codigoExame = StringUtil.getValor(operacao, CODIGO_EXAME_REQUISICAO);
        String codigoMaterial = StringUtil.getValor(operacao, MATERIAL_EXAME_REQUISICAO);
        comandoLogs.add(ExportaWeb.montaRequisicaoExameResultado(stWeb, stJalis, operacao, tipo, listaPdfs, codigoFilial, codigoRequisicao, codigoExame, codigoMaterial));
        return comandoLogs;
    }

    private static ComandoLog montaRequisicaoPdf(Statement stWeb, Statement st, String op, String tipo, Map<String, String> listaPdfs, String codigoFilial, String codigoRequisicao, String tipoPdf, boolean apenasUpdate) throws SQLException {
        ArrayList<String> a = new ArrayList<String>();
        a.add("codigoBase");
        a.add(ExportaWeb.getCodigoBaseWeb(st, codigoFilial));
        a.add(CODIGO_REQUISICAO);
        a.add(codigoRequisicao);
        if (tipoPdf.equalsIgnoreCase(PDF_PACIENTE)) {
            a.add("pacienteRequisicaoPdf");
            a.add(listaPdfs.get(PDF_PACIENTE));
        }
        if (tipoPdf.equalsIgnoreCase(PDF_CONVENIO)) {
            a.add("convenioRequisicaoPdf");
            a.add(listaPdfs.get(PDF_CONVENIO));
        }
        if (tipoPdf.equalsIgnoreCase(PDF_MEDICO)) {
            a.add("medicoRequisicaoPdf");
            a.add(listaPdfs.get(PDF_MEDICO));
        }
        if (tipoPdf.equalsIgnoreCase(PDF_DESTINO)) {
            a.add("destinoRequisicaoPdf");
            a.add(listaPdfs.get(PDF_DESTINO));
        }
        if (tipoPdf.equalsIgnoreCase(PDF_FISCAL)) {
            a.add("fiscalRequisicaoPdf");
            a.add(listaPdfs.get(PDF_FISCAL));
        }
        if (tipoPdf.equalsIgnoreCase(PDF_RESPONSAVEL)) {
            a.add("responsavelRequisicaoPdf");
            a.add(listaPdfs.get(PDF_RESPONSAVEL));
        }
        StringBuilder buf = new StringBuilder();
        if (!apenasUpdate) {
            buf.append(ExportaWeb.montaSelect(CHAVE_REQUISICAOPDF, a));
            ResultSet rs = conexaoWeb.executeQuery(stWeb, buf.toString());
            buf.delete(0, buf.length());
            boolean existe = rs.next();
            rs.close();
            if (tipo.equals(OPERACAO_INSERIR)) {
                if (!existe) {
                    buf.append(ExportaWeb.montaInsert(CHAVE_REQUISICAOPDF, a));
                } else {
                    buf.append(ExportaWeb.montaUpdate(CHAVE_REQUISICAOPDF, a));
                }
            } else if (tipo.equals(OPERACAO_ALTERAR)) {
                if (!existe) {
                    buf.append(ExportaWeb.montaInsert(CHAVE_REQUISICAOPDF, a));
                } else {
                    buf.append(ExportaWeb.montaUpdate(CHAVE_REQUISICAOPDF, a));
                }
            }
        } else {
            buf.append(ExportaWeb.montaUpdate(CHAVE_REQUISICAOPDF, a));
        }
        return new ComandoLog(codigoFilial, null, buf.toString(), null, null, a, CHAVE_REQUISICAOPDF, tipo);
    }

    private String montaRequisicaoExameResultadoPagina(Statement st, String op, String tipo) throws SQLException {
        ArrayList a = this.parseXml(op.toString());
        StringBuilder buf = new StringBuilder();
        if (tipo.equals(OPERACAO_INSERIR)) {
            buf.append(ExportaWeb.montaSelect(CHAVE_REQUISICAOEXAMERESULTADOPAGINA, a));
            ResultSet rs = conexaoWeb.executeQuery(st, buf.toString());
            buf.delete(0, buf.length());
            if (!rs.next()) {
                buf.append(ExportaWeb.montaInsert(CHAVE_REQUISICAOEXAMERESULTADOPAGINA, a));
            } else {
                buf.append(ExportaWeb.montaUpdate(CHAVE_REQUISICAOEXAMERESULTADOPAGINA, a));
            }
            rs.close();
        } else if (tipo.equals(OPERACAO_ALTERAR)) {
            buf.append(ExportaWeb.montaUpdate(CHAVE_REQUISICAOEXAMERESULTADOPAGINA, a));
        } else {
            buf.append(ExportaWeb.montaDelete(CHAVE_REQUISICAOEXAMERESULTADOPAGINA, a));
        }
        return buf.toString();
    }

    private static ComandoLog montaRequisicaoExameResultado(Statement stWeb, Statement st, String op, String tipo, Map<String, String> listaPdfs, String codigoFilial, String codigoRequisicao, String codigoExame, String codigoMaterial) throws SQLException {
        if (Funcoes.textoVazio(codigoExame)) {
            return null;
        }
        if (Funcoes.textoVazio(codigoMaterial)) {
            return null;
        }
        ArrayList<String> a = new ArrayList<String>();
        a.add("codigoBase");
        a.add(ExportaWeb.getCodigoBaseWeb(st, codigoFilial));
        a.add(CODIGO_REQUISICAO);
        a.add(codigoRequisicao);
        a.add("codigoExame");
        a.add(codigoExame);
        a.add("codigoMaterialExame");
        a.add(codigoMaterial);
        a.add("resultadoPdf");
        a.add(listaPdfs.get(PDF_EXAME));
        a.add("codigoHash");
        a.add(listaPdfs.get("codigoHash"));
        a.add("dataConferencia");
        a.add(listaPdfs.get("dataConferencia"));
        a.add("codigoUsuarioConferenciaExameRequisicaoResultado");
        a.add(listaPdfs.get("codigoUsuarioAssinatura"));
        a.add("resultadoTexto");
        a.add(listaPdfs.get("resultadoTexto"));
        ResultSet rs = conexaoWeb.executeQuery(stWeb, ExportaWeb.montaSelect(CHAVE_REQUISICAOEXAMERESULTADO, a));
        boolean jaExiste = rs.next();
        rs.close();
        String comando = "";
        if (tipo.equals(OPERACAO_INSERIR)) {
            comando = jaExiste ? ExportaWeb.montaUpdate(CHAVE_REQUISICAOEXAMERESULTADO, a) : ExportaWeb.montaInsert(CHAVE_REQUISICAOEXAMERESULTADO, a);
        } else if (tipo.equals(OPERACAO_ALTERAR)) {
            comando = jaExiste ? ExportaWeb.montaUpdate(CHAVE_REQUISICAOEXAMERESULTADO, a) : ExportaWeb.montaInsert(CHAVE_REQUISICAOEXAMERESULTADO, a);
        } else if (jaExiste) {
            comando = ExportaWeb.montaDelete(CHAVE_REQUISICAOEXAMERESULTADO, a);
        }
        return new ComandoLog(codigoFilial, null, comando, null, null, a, CHAVE_REQUISICAOEXAMERESULTADO, tipo);
    }

    private String montaConfiguracao(String c) {
        ArrayList a = this.parseXml(c);
        return ExportaWeb.montaUpdate(CHAVE_CONFIGURACAO, a);
    }

    private String montaConvenio(Statement st, String c, String tipo) throws SQLException {
        ArrayList a = this.parseXml(c);
        StringBuilder buf = new StringBuilder();
        if (tipo.equals(OPERACAO_INSERIR)) {
            buf.append(ExportaWeb.montaSelect(CHAVE_CONVENIO, a));
            ResultSet rs = conexaoWeb.executeQuery(st, buf.toString());
            buf.delete(0, buf.length());
            if (!rs.next()) {
                buf.append(ExportaWeb.montaInsert(CHAVE_CONVENIO, a));
            } else {
                buf.append(ExportaWeb.montaUpdate(CHAVE_CONVENIO, a));
            }
            rs.close();
        } else if (tipo.equals(OPERACAO_ALTERAR)) {
            buf.append(ExportaWeb.montaUpdate(CHAVE_CONVENIO, a));
        } else {
            buf.append(ExportaWeb.montaDelete(CHAVE_CONVENIO, a));
        }
        return buf.toString();
    }

    private String montaPaciente(Statement st, String c, String tipo) throws SQLException {
        ArrayList a = this.parseXml(c);
        StringBuilder buf = new StringBuilder();
        if (tipo.equals(OPERACAO_INSERIR)) {
            buf.append(ExportaWeb.montaSelect("paciente", a));
            ResultSet rs = conexaoWeb.executeQuery(st, buf.toString());
            buf.delete(0, buf.length());
            if (!rs.next()) {
                buf.append(ExportaWeb.montaInsert("paciente", a));
            } else {
                buf.append(ExportaWeb.montaUpdate("paciente", a));
            }
            rs.close();
        } else if (tipo.equals(OPERACAO_ALTERAR)) {
            buf.append(ExportaWeb.montaUpdate("paciente", a));
        } else {
            buf.append(ExportaWeb.montaDelete("paciente", a));
        }
        return buf.toString();
    }

    private String montaEntidade(Statement st, String c, String tipo) throws SQLException {
        ArrayList a = this.parseXml(c);
        StringBuilder buf = new StringBuilder();
        if (tipo.equals(OPERACAO_INSERIR)) {
            buf.append(ExportaWeb.montaSelect(CHAVE_ENTIDADES, a));
            ResultSet rs = conexaoWeb.executeQuery(st, buf.toString());
            buf.delete(0, buf.length());
            if (!rs.next()) {
                buf.append(ExportaWeb.montaInsert(CHAVE_ENTIDADES, a));
            } else {
                buf.append(ExportaWeb.montaUpdate(CHAVE_ENTIDADES, a));
            }
            rs.close();
        } else if (tipo.equals(OPERACAO_ALTERAR)) {
            buf.append(ExportaWeb.montaUpdate(CHAVE_ENTIDADES, a));
        } else {
            buf.append(ExportaWeb.montaDelete(CHAVE_ENTIDADES, a));
        }
        return buf.toString();
    }

    private String montaPacienteEntidade(Statement st, String c, String tipo) throws SQLException {
        ArrayList a = this.parseXml(c);
        StringBuilder buf = new StringBuilder();
        if (tipo.equals(OPERACAO_INSERIR)) {
            buf.append(ExportaWeb.montaSelect(CHAVE_PACIENTE_ENTIDADE, a));
            ResultSet rs = conexaoWeb.executeQuery(st, buf.toString());
            buf.delete(0, buf.length());
            if (!rs.next()) {
                buf.append(ExportaWeb.montaInsert(CHAVE_PACIENTE_ENTIDADE, a));
            }
            rs.close();
        } else if (tipo.equals(OPERACAO_ALTERAR)) {
            buf.append(ExportaWeb.montaUpdate(CHAVE_PACIENTE_ENTIDADE, a));
        } else {
            buf.append(ExportaWeb.montaDelete(CHAVE_PACIENTE_ENTIDADE, a));
        }
        return buf.toString();
    }

    private String montaMensagem(Statement st, String c, String tipo) throws SQLException {
        ArrayList a = this.parseXml(c);
        StringBuilder buf = new StringBuilder();
        if (tipo.equals(OPERACAO_INSERIR)) {
            buf.append(ExportaWeb.montaSelect(CHAVE_MENSAGENS, a));
            ResultSet rs = conexaoWeb.executeQuery(st, buf.toString());
            buf.delete(0, buf.length());
            if (!rs.next()) {
                buf.append(ExportaWeb.montaInsert(CHAVE_MENSAGENS, a));
            }
            rs.close();
        } else if (tipo.equals(OPERACAO_DELETAR)) {
            buf.append(ExportaWeb.montaDelete(CHAVE_MENSAGENS, a));
        } else {
            return "";
        }
        return buf.toString();
    }

    private String montaDestino(Statement st, String c, String tipo) throws SQLException {
        ArrayList a = this.parseXml(c);
        StringBuilder buf = new StringBuilder();
        if (tipo.equals(OPERACAO_INSERIR)) {
            buf.append(ExportaWeb.montaSelect(CHAVE_DESTINO, a));
            ResultSet rs = conexaoWeb.executeQuery(st, buf.toString());
            buf.delete(0, buf.length());
            if (!rs.next()) {
                buf.append(ExportaWeb.montaInsert(CHAVE_DESTINO, a));
            } else {
                buf.append(ExportaWeb.montaUpdate(CHAVE_DESTINO, a));
            }
            rs.close();
        } else if (tipo.equals(OPERACAO_ALTERAR)) {
            buf.append(ExportaWeb.montaUpdate(CHAVE_DESTINO, a));
        } else {
            buf.append(ExportaWeb.montaDelete(CHAVE_DESTINO, a));
        }
        return buf.toString();
    }

    private String montaMedico(Statement st, String c, String tipo) throws SQLException {
        ArrayList a = this.parseXml(c);
        StringBuilder buf = new StringBuilder();
        if (tipo.equals(OPERACAO_INSERIR)) {
            buf.append(ExportaWeb.montaSelect(CHAVE_MEDICO, a));
            ResultSet rs = conexaoWeb.executeQuery(st, buf.toString());
            buf.delete(0, buf.length());
            if (!rs.next()) {
                buf.append(ExportaWeb.montaInsert(CHAVE_MEDICO, a));
            } else {
                buf.append(ExportaWeb.montaUpdate(CHAVE_MEDICO, a));
            }
            rs.close();
        } else if (tipo.equals(OPERACAO_ALTERAR)) {
            buf.append(ExportaWeb.montaUpdate(CHAVE_MEDICO, a));
        } else {
            buf.append(ExportaWeb.montaDelete(CHAVE_MEDICO, a));
        }
        return buf.toString();
    }

    private String montaUsuario(Statement st, String c, String tipo) throws SQLException {
        ArrayList a = this.parseXml(c);
        StringBuilder buf = new StringBuilder();
        if (tipo.equals(OPERACAO_INSERIR)) {
            buf.append(ExportaWeb.montaSelect(CHAVE_USUARIO, a));
            ResultSet rs = conexaoWeb.executeQuery(st, buf.toString());
            buf.delete(0, buf.length());
            if (!rs.next()) {
                buf.append(ExportaWeb.montaInsert(CHAVE_USUARIO, a));
            } else {
                buf.append(ExportaWeb.montaUpdate(CHAVE_USUARIO, a));
            }
            rs.close();
        } else if (tipo.equals(OPERACAO_ALTERAR)) {
            buf.append(ExportaWeb.montaUpdate(CHAVE_USUARIO, a));
        } else {
            buf.append(ExportaWeb.montaDelete(CHAVE_USUARIO, a));
        }
        return buf.toString();
    }

    private String montaMedicoExame(Statement st, String c, String tipo) throws SQLException {
        ArrayList a = this.parseXml(c);
        StringBuilder buf = new StringBuilder();
        if (tipo.equals(OPERACAO_INSERIR)) {
            buf.append(ExportaWeb.montaSelect(CHAVE_MEDICOEXAME, a));
            ResultSet rs = conexaoWeb.executeQuery(st, buf.toString());
            buf.delete(0, buf.length());
            if (!rs.next()) {
                buf.append(ExportaWeb.montaInsert(CHAVE_MEDICOEXAME, a));
            }
            rs.close();
        } else if (tipo.equals(OPERACAO_ALTERAR)) {
            buf.append(ExportaWeb.montaUpdate(CHAVE_MEDICOEXAME, a));
        } else {
            buf.append(ExportaWeb.montaDelete(CHAVE_MEDICOEXAME, a));
        }
        return buf.toString();
    }

    private String montaExame(Statement st, String c, String tipo) throws SQLException {
        ArrayList a = this.parseXml(c);
        StringBuilder buf = new StringBuilder();
        if (tipo.equals(OPERACAO_INSERIR)) {
            buf.append(ExportaWeb.montaSelect(CHAVE_EXAMES, a));
            ResultSet rs = conexaoWeb.executeQuery(st, buf.toString());
            buf.delete(0, buf.length());
            if (!rs.next()) {
                buf.append(ExportaWeb.montaInsert(CHAVE_EXAMES, a));
            } else {
                buf.append(ExportaWeb.montaUpdate(CHAVE_EXAMES, a));
            }
            rs.close();
        } else if (tipo.equals(OPERACAO_ALTERAR)) {
            buf.append(ExportaWeb.montaUpdate(CHAVE_EXAMES, a));
        } else {
            buf.append(ExportaWeb.montaDelete(CHAVE_EXAMES, a));
        }
        return buf.toString();
    }

    private String montaRequisicao(Statement st, String c, String tipo) throws SQLException {
        ArrayList a = this.parseXml(c);
        StringBuilder buf = new StringBuilder();
        if (tipo.equals(OPERACAO_INSERIR)) {
            buf.append(ExportaWeb.montaSelect(CHAVE_REQUISICAO, a));
            ResultSet rs = conexaoWeb.executeQuery(st, buf.toString());
            buf.delete(0, buf.length());
            if (!rs.next()) {
                buf.append(ExportaWeb.montaInsert(CHAVE_REQUISICAO, a));
            } else {
                buf.append(ExportaWeb.montaUpdate(CHAVE_REQUISICAO, a));
            }
            rs.close();
        } else if (tipo.equals(OPERACAO_ALTERAR)) {
            buf.append(ExportaWeb.montaUpdate(CHAVE_REQUISICAO, a));
        } else {
            buf.append(ExportaWeb.montaDelete(CHAVE_REQUISICAO, a));
        }
        return buf.toString();
    }

    private String montaRequisicaoExame(Statement st, String c, String tipo) throws SQLException {
        ArrayList a = this.parseXml(c);
        StringBuilder buf = new StringBuilder();
        if (tipo.equals(OPERACAO_INSERIR)) {
            String tmp = ExportaWeb.montaSelect(CHAVE_REQUISICAOEXAME, a);
            buf.append(tmp);
            ResultSet rs = conexaoWeb.executeQuery(st, buf.toString());
            buf.delete(0, buf.length());
            if (!rs.next()) {
                buf.append(ExportaWeb.montaInsert(CHAVE_REQUISICAOEXAME, a));
            } else {
                buf.append(ExportaWeb.montaUpdate(CHAVE_REQUISICAOEXAME, a));
            }
            rs.close();
        } else if (tipo.equals(OPERACAO_ALTERAR)) {
            buf.append(ExportaWeb.montaUpdate(CHAVE_REQUISICAOEXAME, a));
        } else {
            buf.append(ExportaWeb.montaDelete(CHAVE_REQUISICAOEXAME, a));
        }
        return buf.toString();
    }

    private String montaRequisicaoExameImagem(Statement st, String c, String tipo) throws SQLException {
        ArrayList a = this.parseXml(c);
        StringBuilder buf = new StringBuilder();
        if (tipo.equals(OPERACAO_INSERIR)) {
            buf.append(ExportaWeb.montaSelect(CHAVE_REQUISICAOEXAMEIMAGEM, a));
            ResultSet rs = conexaoWeb.executeQuery(st, buf.toString());
            buf.delete(0, buf.length());
            if (!rs.next()) {
                buf.append(ExportaWeb.montaInsert(CHAVE_REQUISICAOEXAMEIMAGEM, a));
            } else {
                buf.append(ExportaWeb.montaUpdate(CHAVE_REQUISICAOEXAMEIMAGEM, a));
            }
            rs.close();
        } else if (tipo.equals(OPERACAO_ALTERAR)) {
            buf.append(ExportaWeb.montaUpdate(CHAVE_REQUISICAOEXAMEIMAGEM, a));
        } else {
            buf.append(ExportaWeb.montaDelete(CHAVE_REQUISICAOEXAMEIMAGEM, a));
        }
        return buf.toString();
    }

    private static String montaInsert(String tabela, ArrayList<String> a) {
        StringBuilder campos = new StringBuilder();
        StringBuilder valores = new StringBuilder("");
        if (!a.contains("codigoImagemExame") && tabela.equalsIgnoreCase(CHAVE_REQUISICAOEXAMEIMAGEM)) {
            return "";
        }
        ArrayList<Integer> remover = new ArrayList<Integer>();
        HashMap<String, Integer> repetido = new HashMap<String, Integer>();
        for (int i = 0; i < a.size(); i += 2) {
            CamposWeb c;
            if (camposIgnorar.contains(a.get(i)) || (c = (CamposWeb)CAMPOS.get(a.get(i))) == null) continue;
            if (repetido.containsKey(c.getNomeCampo().toLowerCase())) {
                remover.add(i);
                continue;
            }
            repetido.put(c.getNomeCampo().toLowerCase(), i);
        }
        if (remover != null && remover.size() > 0) {
            for (Integer i : remover) {
                a.remove(i);
                a.remove(i);
            }
        }
        int pulo = ExportaWeb.pularCampos(a);
        for (int i = 0; i < a.size(); i += 2) {
            CamposWeb campo;
            if (camposIgnorar.contains(a.get(i)) || (campo = (CamposWeb)CAMPOS.get(a.get(i))) == null) continue;
            campos.append(campo.getNomeCampo());
            if (i < a.size() - pulo) {
                campos.append(",");
            }
            if (campo.getTipoCampo() == 2) {
                valores.append(a.get(i + 1).toString());
            } else if (campo.getTipoCampo() == 3) {
                if (a.get(i + 1) == null || Funcoes.textoVazio(a.get(i + 1).toString())) {
                    valores.append("null");
                } else {
                    valores.append(Funcoes.limpaDecimal(a.get(i + 1).toString()));
                }
            } else if (campo.getTipoCampo() == 1) {
                if (campo.getNomeCampo().equalsIgnoreCase("usr_assinatura") && a.get(i + 1).toString().length() > 20) {
                    valores.append(StringUtil.textoDBEscape(a.get(i + 1).toString().substring(0, 20)));
                } else {
                    valores.append(StringUtil.textoDBEscape(a.get(i + 1).toString()));
                }
            } else if (campo.getTipoCampo() == 4) {
                if (Funcoes.verificaData(a.get(i + 1).toString())) {
                    valores.append("'");
                    valores.append(Funcoes.formataData("MM/dd/yyyy", a.get(i + 1).toString()));
                    valores.append("'");
                } else {
                    valores.append("null");
                }
            } else if (campo.getTipoCampo() == 5) {
                if (Funcoes.verificaHora(a.get(i + 1).toString())) {
                    valores.append("'");
                    valores.append(a.get(i + 1).toString());
                    valores.append("'");
                } else {
                    valores.append("null");
                }
            } else if (campo.getTipoCampo() == 6) {
                if (!Funcoes.textoVazio(a.get(i + 1).toString()) && (a.get(i + 1).toString().equalsIgnoreCase("S") || a.get(i + 1).toString().equalsIgnoreCase("TRUE") || a.get(i + 1).toString().equalsIgnoreCase("SIM"))) {
                    valores.append("true");
                } else {
                    valores.append("false");
                }
            }
            if (i >= a.size() - pulo) continue;
            valores.append(",");
        }
        StringBuilder retorno = new StringBuilder("insert into ");
        retorno.append(tabela);
        retorno.append(" (");
        retorno.append((CharSequence)ExportaWeb.arrumaComando(campos));
        retorno.append(") values (");
        retorno.append((CharSequence)ExportaWeb.arrumaComando(valores));
        retorno.append(")");
        return retorno.toString();
    }

    private static StringBuilder arrumaComando(StringBuilder comando) {
        int tamanho = comando.length() - 1;
        if (tamanho > 0 && comando.charAt(tamanho) == ',') {
            comando.replace(tamanho, comando.length(), "");
        }
        return comando;
    }

    private static int pularCampos(ArrayList<String> a) {
        boolean pula = a.containsAll(camposIgnorar);
        int pulo = 2;
        if (pula) {
            pulo = 2;
        }
        return pulo;
    }

    private static String montaUpdate(String tabela, ArrayList a) {
        int i;
        StringBuilder pk = new StringBuilder();
        StringBuilder valores = new StringBuilder("");
        ArrayList<Integer> remover = new ArrayList<Integer>();
        HashMap<String, Integer> repetido = new HashMap<String, Integer>();
        for (i = 0; i < a.size(); i += 2) {
            CamposWeb c;
            if (camposIgnorar.contains(a.get(i)) || (c = (CamposWeb)CAMPOS.get(a.get(i))) == null) continue;
            if (repetido.containsKey(c.getNomeCampo().toLowerCase())) {
                remover.add(i);
                continue;
            }
            repetido.put(c.getNomeCampo().toLowerCase(), i);
        }
        if (remover != null && remover.size() > 0) {
            for (Integer i2 : remover) {
                a.remove(i2);
                a.remove(i2);
            }
        }
        for (i = 0; i < a.size(); i += 2) {
            CamposWeb campo = (CamposWeb)CAMPOS.get(a.get(i));
            if (campo == null) continue;
            if (campo.getPK() && !campo.getForcarUpdate()) {
                if (pk.length() > 0) {
                    pk.append(" and ");
                }
                pk.append(ExportaWeb.montaCampoUpdate(campo, a.get(i + 1).toString()));
                continue;
            }
            if (valores.length() > 0) {
                valores.append(", ");
            }
            if (campo.getNomeCampo().equalsIgnoreCase("usr_assinatura") && a.get(i + 1).toString().length() > 20) {
                valores.append(ExportaWeb.montaCampoUpdate(campo, a.get(i + 1).toString().substring(0, 20)));
                continue;
            }
            valores.append(ExportaWeb.montaCampoUpdate(campo, a.get(i + 1).toString()));
        }
        StringBuilder retorno = new StringBuilder("update ");
        retorno.append(tabela);
        retorno.append(" set ");
        retorno.append((CharSequence)valores);
        retorno.append(" where ");
        retorno.append((CharSequence)pk);
        return retorno.toString();
    }

    private static String montaDelete(String tabela, ArrayList a) {
        StringBuilder pk = new StringBuilder();
        for (int i = 0; i < a.size(); i += 2) {
            CamposWeb campo;
            if (camposIgnorar.contains(a.get(i)) || (campo = (CamposWeb)CAMPOS.get(a.get(i))) == null || !campo.getPK()) continue;
            if (pk.length() > 0) {
                pk.append(" and ");
            }
            pk.append(ExportaWeb.montaCampoUpdate(campo, a.get(i + 1).toString()));
        }
        StringBuilder retorno = new StringBuilder("delete from ");
        retorno.append(tabela);
        retorno.append(" where ");
        retorno.append((CharSequence)pk);
        return retorno.toString();
    }

    private static String montaSelect(String tabela, ArrayList a) {
        StringBuilder pk = new StringBuilder();
        for (int i = 0; i < a.size(); i += 2) {
            CamposWeb campo;
            if (camposIgnorar.contains(a.get(i)) || (campo = (CamposWeb)CAMPOS.get(a.get(i))) == null || !campo.getPK()) continue;
            if (tabela.equals(CHAVE_REQUISICAO) && campo.getNomeCampo().equals("pac_codigo")) {
                pk.append("");
                continue;
            }
            if (pk.length() > 0) {
                pk.append(" and ");
            }
            pk.append(ExportaWeb.montaCampoUpdate(campo, a.get(i + 1).toString()));
        }
        StringBuilder retorno = new StringBuilder("select 1 from ");
        retorno.append(tabela);
        retorno.append(" where ");
        retorno.append((CharSequence)pk);
        return retorno.toString();
    }

    private static String montaCampoUpdate(CamposWeb campo, String valor) {
        StringBuilder tmp = new StringBuilder();
        tmp.append(campo.getNomeCampo());
        if (!(valor.equalsIgnoreCase("is not null") || valor.equalsIgnoreCase("is null") || valor.trim().startsWith(">"))) {
            tmp.append(" = ");
        } else {
            tmp.append(" ");
        }
        if (campo.getTipoCampo() == 2) {
            tmp.append(Funcoes.textoVazio(valor) ? "null" : valor);
        } else if (campo.getTipoCampo() == 3) {
            tmp.append(Funcoes.textoVazio(valor) ? "null" : Funcoes.limpaDecimal(valor));
        } else if (campo.getTipoCampo() == 1) {
            tmp.append(StringUtil.textoDBEscape(valor));
        } else if (campo.getTipoCampo() == 4) {
            if (Funcoes.verificaData(valor) || Funcoes.verificaData("dd-MM-yyyy HH:mm:ss", valor)) {
                if (Funcoes.verificaData(valor)) {
                    tmp.append("'");
                    tmp.append(Funcoes.formataData("MM/dd/yyyy", valor));
                    tmp.append("'");
                } else {
                    try {
                        tmp.append("'");
                        tmp.append(Funcoes.formataData("yyyy-MM-dd HH:mm:ss", new SimpleDateFormat("dd-MM-yyyy HH:mm:ss").parse(valor)));
                        tmp.append("'");
                    }
                    catch (Exception ex) {
                        tmp.append("null");
                    }
                }
            } else {
                tmp.append("null");
            }
        } else if (campo.getTipoCampo() == 5) {
            if (Funcoes.verificaHora(valor)) {
                tmp.append("'");
                tmp.append(valor);
                tmp.append("'");
            } else {
                tmp.append("null");
            }
        } else if (campo.getTipoCampo() == 6) {
            if (!Funcoes.textoVazio(valor) && (valor.equalsIgnoreCase("S") || valor.equalsIgnoreCase("TRUE") || valor.equalsIgnoreCase("SIM"))) {
                tmp.append("true");
            } else {
                tmp.append("false");
            }
        }
        return tmp.toString();
    }

    public static String montaXmlGerarPdf(String filial, String codigoRequisicao) throws Exception {
        StringBuilder xml = new StringBuilder();
        xml.append("<").append(TAG_FILIAL).append(">").append(filial).append("</").append(TAG_FILIAL).append(">");
        xml.append("<").append(CODIGO_REQUISICAO).append(">").append(codigoRequisicao).append("</").append(CODIGO_REQUISICAO).append(">");
        return xml.toString();
    }

    private void marcaExportado(Statement st, String filial, String codigo) throws SQLException {
        StringBuilder buf = new StringBuilder("update exportaweb set ewe_exportado = true where fil_codigo = ");
        buf.append(filial);
        buf.append(" and ewe_codigo = ");
        buf.append(codigo);
        ConexaoTemporaria.executeUpdate(filial, st, buf.toString(), true);
    }

    private ArrayList parseXml(String xml) {
        ArrayList a = new ArrayList();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            DocumentBuilder db = factory.newDocumentBuilder();
            Document doc = db.parse(new InputSource(new StringReader(this.geraEscapesXML(xml, "utf-8"))));
            NodeList list = doc.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                Node node = list.item(i);
                this.trataNodeChild(node, a);
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "ExportaWeb (1118)");
            ex.printStackTrace();
        }
        return a;
    }

    private String geraEscapesXML(String xml, String charset) {
        StringBuilder buf = new StringBuilder();
        buf.append("<?xml version=\"1.0\" encoding=\"").append(charset).append("\" standalone=\"no\"?>");
        buf.append("<!--DTD-->");
        buf.append("<!DOCTYPE my_file [");
        buf.append("<!ELEMENT my_file (text)>");
        buf.append("<!ELEMENT text (#PCDATA)>");
        buf.append("<!--Entity declarations-->");
        buf.append("<!ENTITY exm \"&amp;exm\">");
        buf.append("<!ENTITY mat \"&amp;mat\">");
        buf.append("<!ENTITY img \"&amp;img\">");
        buf.append("<!ENTITY iexcl \"\u00a1\">");
        buf.append("<!ENTITY cent \"\u00a2\">");
        buf.append("<!ENTITY pound \"\u00a3\">");
        buf.append("<!ENTITY curren \"\u00a4\">");
        buf.append("<!ENTITY yen \"\u00a5\">");
        buf.append("<!ENTITY brvbar \"\u00a6\">");
        buf.append("<!ENTITY sect \"\u00a7\">");
        buf.append("<!ENTITY uml \"\u00a8\">");
        buf.append("<!ENTITY copy \"\u00a9\">");
        buf.append("<!ENTITY ordf \"\u00aa\">");
        buf.append("<!ENTITY laquo \"\u00ab\">");
        buf.append("<!ENTITY not \"\u00ac\">");
        buf.append("<!ENTITY shy \"\u00ad\">");
        buf.append("<!ENTITY reg \"\u00ae\">");
        buf.append("<!ENTITY macr \"\u00af\">");
        buf.append("<!ENTITY deg \"\u00b0\">");
        buf.append("<!ENTITY plusmn \"\u00b1\">");
        buf.append("<!ENTITY sup2 \"\u00b2\">");
        buf.append("<!ENTITY sup3 \"\u00b3\">");
        buf.append("<!ENTITY acute \"\u00b4\">");
        buf.append("<!ENTITY micro \"\u00b5\">");
        buf.append("<!ENTITY para \"\u00b6\">");
        buf.append("<!ENTITY middot \"\u00b7\">");
        buf.append("<!ENTITY cedil \"\u00b8\">");
        buf.append("<!ENTITY sup1 \"\u00b9\">");
        buf.append("<!ENTITY ordm \"\u00ba\">");
        buf.append("<!ENTITY raquo \"\u00bb\">");
        buf.append("<!ENTITY frac14 \"\u00bc\">");
        buf.append("<!ENTITY frac12 \"\u00bd\">");
        buf.append("<!ENTITY frac34 \"\u00be\">");
        buf.append("<!ENTITY iquest \"\u00bf\">");
        buf.append("<!ENTITY Agrave \"\u00c0\">");
        buf.append("<!ENTITY Aacute \"\u00c1\">");
        buf.append("<!ENTITY Acirc \"\u00c2\">");
        buf.append("<!ENTITY Atilde \"\u00c3\">");
        buf.append("<!ENTITY Auml \"\u00c4\">");
        buf.append("<!ENTITY Aring \"\u00c5\">");
        buf.append("<!ENTITY AElig \"\u00c6\">");
        buf.append("<!ENTITY Ccedil \"\u00c7\">");
        buf.append("<!ENTITY Egrave \"\u00c8\">");
        buf.append("<!ENTITY Eacute \"\u00c9\">");
        buf.append("<!ENTITY Ecirc \"\u00ca\">");
        buf.append("<!ENTITY Euml \"\u00cb\">");
        buf.append("<!ENTITY Igrave \"\u00cc\">");
        buf.append("<!ENTITY Iacute \"\u00cd\">");
        buf.append("<!ENTITY Icirc \"\u00ce\">");
        buf.append("<!ENTITY Iuml \"\u00cf\">");
        buf.append("<!ENTITY ETH \"\u00d0\">");
        buf.append("<!ENTITY Ntilde \"\u00d1\">");
        buf.append("<!ENTITY Ograve \"\u00d2\">");
        buf.append("<!ENTITY Oacute \"\u00d3\">");
        buf.append("<!ENTITY Ocirc \"\u00d4\">");
        buf.append("<!ENTITY Otilde \"\u00d5\">");
        buf.append("<!ENTITY Ouml \"\u00d6\">");
        buf.append("<!ENTITY times \"\u00d7\">");
        buf.append("<!ENTITY Oslash \"\u00d8\">");
        buf.append("<!ENTITY Ugrave \"\u00d9\">");
        buf.append("<!ENTITY Uacute \"\u00da\">");
        buf.append("<!ENTITY Ucirc \"\u00db\">");
        buf.append("<!ENTITY Uuml \"\u00dc\">");
        buf.append("<!ENTITY Yacute \"\u00dd\">");
        buf.append("<!ENTITY THORN \"\u00de\">");
        buf.append("<!ENTITY szlig \"\u00df\">");
        buf.append("<!ENTITY agrave \"\u00e0\">");
        buf.append("<!ENTITY aacute \"\u00e1\">");
        buf.append("<!ENTITY acirc \"\u00e2\">");
        buf.append("<!ENTITY atilde \"\u00e3\">");
        buf.append("<!ENTITY auml \"\u00e4\">");
        buf.append("<!ENTITY aring \"\u00e5\">");
        buf.append("<!ENTITY aelig \"\u00e6\">");
        buf.append("<!ENTITY ccedil \"\u00e7\">");
        buf.append("<!ENTITY egrave \"\u00e8\">");
        buf.append("<!ENTITY eacute \"\u00e9\">");
        buf.append("<!ENTITY ecirc \"\u00ea\">");
        buf.append("<!ENTITY euml \"\u00eb\">");
        buf.append("<!ENTITY igrave \"\u00ec\">");
        buf.append("<!ENTITY iacute \"\u00ed\">");
        buf.append("<!ENTITY icirc \"\u00ee\">");
        buf.append("<!ENTITY iuml \"\u00ef\">");
        buf.append("<!ENTITY eth \"\u00f0\">");
        buf.append("<!ENTITY ntilde \"\u00f1\">");
        buf.append("<!ENTITY ograve \"\u00f2\">");
        buf.append("<!ENTITY oacute \"\u00f3\">");
        buf.append("<!ENTITY ocirc \"\u00f4\">");
        buf.append("<!ENTITY otilde \"\u00f5\">");
        buf.append("<!ENTITY ouml \"\u00f6\">");
        buf.append("<!ENTITY divide \"\u00f7\">");
        buf.append("<!ENTITY oslash \"\u00f8\">");
        buf.append("<!ENTITY ugrave \"\u00f9\">");
        buf.append("<!ENTITY uacute \"\u00fa\">");
        buf.append("<!ENTITY ucirc \"\u00fb\">");
        buf.append("<!ENTITY uuml \"\u00fc\">");
        buf.append("<!ENTITY yacute \"\u00fd\">");
        buf.append("<!ENTITY thorn \"\u00fe\">");
        buf.append("<!ENTITY yuml \"\u00ff\">");
        buf.append("]>");
        buf.append(xml.replaceAll("&exm=", "&exm;=").replaceAll("&mat=", "&mat;=").replaceAll("&img=", "&img;="));
        return buf.toString();
    }

    private void trataNodeChild(Node node, ArrayList a) {
        if (!node.hasChildNodes()) {
            return;
        }
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node no = list.item(i);
            a.add(no.getNodeName());
            a.add(no.getTextContent());
        }
    }

    public void setProgressBar(JProgressBar progresso) {
        if (progresso != null) {
            this.progresso = progresso;
        }
    }

    public void setTextMensagens(JTextArea txt) {
        if (txt != null) {
            this.txtMensagens = txt;
        }
    }

    private void mostraMensagem(String mensagem) {
        if (this.txtMensagens != null) {
            this.txtMensagens.append("\n" + mensagem);
            this.txtMensagens.setCaretPosition(this.txtMensagens.getText().length());
        }
    }

    public void setAutomatico(boolean b) {
        this.automatico = b;
    }

    public void setIgnorarFiliais(boolean b) {
        this.ignorarFilial = b;
    }

    public void setMostrarIcones(boolean b) {
        this.mostrarIcones = b;
    }

    public void addThreadListener(ThreadListener l) {
        this.listenerList.add(ThreadListener.class, l);
    }

    public void removeThreadListener(ThreadListener l) {
        this.listenerList.remove(ThreadListener.class, l);
    }

    private void fireIniciouExecucao() {
        ThreadListener[] lis = (ThreadListener[])this.listenerList.getListeners(ThreadListener.class);
        for (int i = 0; i < lis.length; ++i) {
            lis[i].iniciouExecucao(new EventObject(this));
        }
    }

    private void fireTerminouExecucao() {
        ThreadListener[] lis = (ThreadListener[])this.listenerList.getListeners(ThreadListener.class);
        for (int i = 0; i < lis.length; ++i) {
            lis[i].terminouExecucao(new EventObject(this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getTotalParaExportar(Statement st) throws SQLException {
        StringBuilder tmp = new StringBuilder("select count(ewe_codigo) ");
        tmp.append("from exportaweb where ");
        if (!this.ignorarFilial) {
            tmp.append(" fil_codigo = ");
            tmp.append(Variaveis.filialPadrao);
            tmp.append(" and ");
        }
        tmp.append(" ewe_exportado = false or ewe_exportado is null");
        int result = 0;
        try (ResultSet rs = null;){
            rs = st.executeQuery(tmp.toString());
            result = rs.next() ? rs.getInt(1) : 0;
        }
        return result;
    }

    private String getSelect(boolean gerandoArquivo) {
        StringBuilder tmp = new StringBuilder("select fil_codigo, ewe_codigo, ewe_datahora, ewe_tipooperacao ");
        tmp.append("from exportaweb where ");
        if (!this.ignorarFilial) {
            tmp.append(" fil_codigo = ");
            tmp.append(Variaveis.filialPadrao);
            tmp.append(" and ");
        }
        tmp.append(" ewe_exportado = false or ewe_exportado is null order by ");
        tmp.append(gerandoArquivo ? "ewe_codigo" : "ewe_datahora, ewe_codigo");
        tmp.append(" limit ").append(gerandoArquivo ? "1000" : (ParametrosGerais.getCodigoCliente() == 1238L ? "50" : "200"));
        return tmp.toString();
    }

    private String getOperacao(Statement st, String filial, String codigo) throws SQLException {
        String retorno = "";
        StringBuilder tmp = new StringBuilder("select ewe_operacao ");
        tmp.append("from exportaweb where ");
        tmp.append(" fil_codigo = ").append(filial);
        tmp.append(" and ewe_codigo =  ").append(codigo);
        ResultSet rsT = ConexaoTemporaria.executeQuery(st, tmp);
        if (rsT.next()) {
            retorno = rsT.getString(1);
        }
        return retorno;
    }

    public static String getOperacaoConexaoJalis(Statement st, String filial, String codigo) throws SQLException {
        String retorno = "";
        StringBuilder tmp = new StringBuilder("select ewe_operacao ");
        tmp.append("from exportaweb where ");
        tmp.append(" fil_codigo = ").append(filial);
        tmp.append(" and ewe_codigo =  ").append(codigo);
        ResultSet rsT = Conexao.executeQuery(st, tmp);
        if (rsT.next()) {
            retorno = rsT.getString(1);
        }
        return retorno;
    }

    public static void atualizaPaginaOrdemExameWeb(Statement st, String filial, String requisicao, String codigoBase) throws Exception {
        ExportaWeb2.atualizaPaginaOrdemExameWeb(st, filial, requisicao, codigoBase);
    }

    public static void atualizaPaginaOrdemExameWeb(Statement st, String filial, String requisicao, String codigoExame, String codigoMaterial, String codigoBase) throws Exception {
        ExportaWeb2.atualizaPaginaOrdemExameWeb(st, filial, requisicao, codigoExame, codigoMaterial, codigoBase);
    }

    private static String getCabecalhoRodape(Statement st, String filial, String codigoLayout) throws Exception {
        StringBuilder bui = new StringBuilder("select lay_cabec, lay_laudoweb from layout where fil_codigo = ");
        bui.append(filial);
        bui.append(" and lay_codigo = ");
        bui.append(codigoLayout);
        ResultSet rs = ConexaoTemporaria.executeQuery(st, bui.toString());
        if (rs.next()) {
            return !DBUtil.campoNull(rs.getString("lay_laudoweb")) && !Funcoes.textoVazio(rs.getString("lay_laudoweb")) ? rs.getString("lay_laudoweb") : rs.getString("lay_cabec");
        }
        return "";
    }

    public static String getCodigoBaseWeb(Statement st, String filial) throws SQLException {
        String codigoBase = "";
        FilialService filService = new FilialService();
        FilialVOAux filVO = filService.getDadosExportaBaseWeb(st, filial);
        if (Funcoes.carregouVO(filVO)) {
            codigoBase = filVO.getTipoBase();
        }
        if (Funcoes.textoVazio(codigoBase) && Funcoes.carregouVO(filVO = filService.contemAgrupamento(st, filial)) && Funcoes.isExportarBaseWeb(filVO)) {
            codigoBase = filVO.getTipoBase();
        }
        return codigoBase;
    }

    public static boolean isGerarPdfResultado(Statement st, String filial) throws SQLException {
        FilialService filService = new FilialService();
        return filService.isGerarPdfResultado(st, filial);
    }

    public static Map<String, Object> getBaseWebEGeraPdf(Statement st, String filial) throws SQLException {
        HashMap<String, Object> maps = new HashMap<String, Object>();
        maps.put("fil_baseweb", "");
        maps.put("fil_webpdf", false);
        FilialService filService = new FilialService();
        FilialVOAux filVO = filService.getDadosExportaBaseWeb(st, filial);
        if (Funcoes.carregouVO(filVO) && Funcoes.isExportarBaseWeb(filVO)) {
            maps.put("fil_baseweb", filVO.getTipoBase());
            maps.put("fil_webpdf", ExportaWeb.isGerarPDF(filVO));
        }
        if (Funcoes.textoVazio(ExportaWeb.getFilBase(maps)) && Funcoes.carregouVO(filVO = filService.contemAgrupamento(st, filial)) && Funcoes.isExportarBaseWeb(filVO)) {
            maps.put("fil_baseweb", filVO.getTipoBase());
            maps.put("fil_webpdf", ExportaWeb.isGerarPDF(filVO));
        }
        return maps;
    }

    private static String getFilBase(Map<String, Object> maps) {
        return (String)maps.get("fil_baseweb");
    }

    private static boolean isGerarPDF(FilialVOAux filVO) {
        return filVO.isWebPdf() != false && filVO.isWebStandAlone() == false;
    }

    public static boolean isBaseWebAgrupada(Statement st, String filial) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.delete(0, buf.length());
        buf.append("select fil_codigo from filiaisweb where fil_kodigo = ").append(filial);
        ResultSet rs = st.executeQuery(buf.toString());
        boolean retorno = rs.next();
        rs.close();
        return retorno;
    }

    public static Map<String, Object> getBaseWebAgrupada(Statement st, String filial) throws Exception {
        FilialService filService = new FilialService();
        FilialVOAux filVO = filService.contemAgrupamento(st, filial);
        HashMap<String, Object> maps = new HashMap<String, Object>();
        String baseWeb = null;
        if (Funcoes.carregouVO(filVO)) {
            baseWeb = filVO.getTipoBase();
        } else {
            filVO = filService.getDadosExportaBaseWeb(st, filial);
            if (Funcoes.carregouVO(filVO)) {
                baseWeb = filVO.getTipoBase();
            }
        }
        maps.put("baseWeb", baseWeb);
        return maps;
    }

    public static boolean isEnviarExamesParaWeb(Statement st, String filial) throws SQLException {
        boolean retorno = false;
        FilialService filService = new FilialService();
        FilialVOAux filialVO = filService.getDadosExportaBaseWeb(st, filial);
        if (Funcoes.carregouVO(filialVO)) {
            return Funcoes.isExportarBaseWeb(filialVO);
        }
        return retorno;
    }

    public static void enviarResultadoPDF(Statement st, String filial, String requisicao, String codigoBaseWeb) throws SQLException {
        ArrayList<String> tmp = new ArrayList<String>();
        tmp.add(CODIGO_REQUISICAO);
        tmp.add(IntegracaoUtil.formataCodigoRequisicao(filial, requisicao, st));
        tmp.add("codigoBase");
        tmp.add(codigoBaseWeb);
        tmp.add("resultadoPdfRequisicao");
        RetornoImpressaoResultados retorno = ImpressaoResultados.imprimirExamesPdfWeb(filial, requisicao, false);
        String resultado = retorno.getResultadoPdfWeb() != null ? new Base64().encodeAsString(retorno.getResultadoPdfWeb()) : "";
        tmp.add(resultado);
        DBUtil.insereExportaWeb(filial, st, CHAVE_REQUISICAO, OPERACAO_ALTERAR, tmp.toArray(new String[tmp.size()]));
    }

    @Override
    public ExportacaoMonitor getMonitorExportacao() {
        return this.exportacaoMonitor;
    }

    @Override
    public boolean podeApresentarJanelaMonitoramento() {
        try {
            return ExportaWeb.isEnviarExamesParaWeb(ConexaoTemporaria.getStatement(), Variaveis.filialPadrao);
        }
        catch (Exception e) {
            return false;
        }
    }

    private void atualizaTempoEntreIteracoes() {
        if (this.tempoIteracaoAnterior != null) {
            Calendar calAnterior = Calendar.getInstance();
            calAnterior.setTime(this.tempoIteracaoAnterior);
            Calendar calAtual = Calendar.getInstance();
            calAtual.setTime(new Date());
            long qtde = calAtual.getTimeInMillis() - calAnterior.getTimeInMillis();
            this.mediaTempoIteracoes = (this.mediaTempoIteracoes * 4L + qtde * 3L) / 7L;
            this.exportacaoMonitor.setTempoEntreIteracoes(this.mediaTempoIteracoes);
            this.tempoIteracaoAnterior = calAtual.getTime();
        } else {
            this.tempoIteracaoAnterior = new Date();
        }
    }

    static {
        camposIgnorar = new ArrayList<String>();
        debug = Funcoes.arquivoExiste(System.getProperty("user.home") + System.getProperty("file.separator") + "debug.jalis");
        CAMPOS = new Hashtable();
        CAMPOS.put("codigoBase", new CamposWeb(1, "cfg_codigo", true));
        CAMPOS.put("laboratorioFilial", new CamposWeb(1, "cfg_laboratorio", false));
        CAMPOS.put("fraseProibido", new CamposWeb(1, "cfg_fraseproibido", false));
        CAMPOS.put("fraseIncompleto", new CamposWeb(1, "cfg_fraseandamento", false));
        CAMPOS.put("fraseResponsavel", new CamposWeb(1, "cfg_fraseassinatura", false));
        CAMPOS.put("enderecoFilial", new CamposWeb(1, "cfg_endereco", false));
        CAMPOS.put("bairroFilial", new CamposWeb(1, "cfg_bairro", false));
        CAMPOS.put("cidadeFilial", new CamposWeb(1, "cfg_cidade", false));
        CAMPOS.put("cepFilial", new CamposWeb(1, "cfg_cep", false));
        CAMPOS.put("foneFilial", new CamposWeb(1, "cfg_fone", false));
        CAMPOS.put("faxFilial", new CamposWeb(1, "cfg_fax", false));
        CAMPOS.put("responsavelFilial", new CamposWeb(1, "cfg_responsavel", false));
        CAMPOS.put("ufFilial", new CamposWeb(1, "cfg_uf", false));
        CAMPOS.put("emailFilial", new CamposWeb(1, "cfg_email", false));
        CAMPOS.put("siteFilial", new CamposWeb(1, "cfg_site", false));
        CAMPOS.put("fraseDevedor", new CamposWeb(1, "cfg_frasedevedor", false));
        CAMPOS.put("complementoFilial", new CamposWeb(1, "cfg_complemento", false));
        CAMPOS.put("razaoSocialFilial", new CamposWeb(1, "cfg_razaosocial", false));
        CAMPOS.put("cnpjFilial", new CamposWeb(1, "cfg_cnpj", false));
        CAMPOS.put("mostraDevedoraFilial", new CamposWeb(2, "cfg_verdevedora", false));
        CAMPOS.put("mostraNaoAssinadoFilial", new CamposWeb(2, "cfg_vernaoassinado", false));
        CAMPOS.put("campoBuscaPacienteFilial", new CamposWeb(1, "cfg_buscapaciente", false));
        CAMPOS.put("mostrarBotaoImprimir", new CamposWeb(2, "cfg_mostrarimprimir", false));
        CAMPOS.put("mostrarAssinatura", new CamposWeb(2, "cfg_mostrarassinatura", false));
        CAMPOS.put("imagemAssinatura", new CamposWeb(1, "cfg_imagemassinatura", false));
        CAMPOS.put("apresentarResultadoEmJanela", new CamposWeb(6, "cfg_rstemjanela", false));
        CAMPOS.put("apresentarMensagemPopup", new CamposWeb(6, "cfg_mensagempopup", false));
        CAMPOS.put("apresentarCabecalhoCliente", new CamposWeb(6, "cfg_iscabeccliente", false));
        CAMPOS.put("enviarResultadoTexto", new CamposWeb(6, "cfg_resultadotexto", false));
        CAMPOS.put("enviarResultadoPdf", new CamposWeb(6, "cfg_resultadopdf", false));
        CAMPOS.put("assinaturaExame", new CamposWeb(6, "cfg_assinaturaexame", false));
        CAMPOS.put("tipoFilial", new CamposWeb(1, "cfg_tipofilial", false));
        CAMPOS.put("mostraDevedoraPacienteFilial", new CamposWeb(2, "cfg_verdevedorapaciente", false));
        CAMPOS.put("mostraDevedoraMedicoFilial", new CamposWeb(2, "cfg_verdevedoramedico", false));
        CAMPOS.put("mostraDevedoraConvenioFilial", new CamposWeb(2, "cfg_verdevedoraconvenio", false));
        CAMPOS.put("mostraDevedoraEntidadeFilial", new CamposWeb(2, "cfg_verdevedoraentidade", false));
        CAMPOS.put("mostraDevedoraDestinoFilial", new CamposWeb(2, "cfg_verdevedoradestino", false));
        CAMPOS.put("requisicoesPorPaginaFilial", new CamposWeb(2, "cfg_webreqpagina", false));
        CAMPOS.put("trocarImagemConvenioFilial", new CamposWeb(6, "cfg_webimgconvenio", false));
        CAMPOS.put("trocarImagemDestinoFilial", new CamposWeb(6, "cfg_webimgdestino", false));
        CAMPOS.put("enviarEmailConvenioFilial", new CamposWeb(6, "cfg_webemailconvenio", false));
        CAMPOS.put("enviarEmailDestinoFilial", new CamposWeb(6, "cfg_webemaildestino", false));
        CAMPOS.put("enviarEmailEntidadeFilial", new CamposWeb(6, "cfg_webemailentidade", false));
        CAMPOS.put("enviarEmailMedicoFilial", new CamposWeb(6, "cfg_webemailmedico", false));
        CAMPOS.put("enviarEmailPacienteFilial", new CamposWeb(6, "cfg_webemailpaciente", false));
        CAMPOS.put("codigoConvenio", new CamposWeb(2, "con_codigo", true));
        CAMPOS.put("descricaoConvenio", new CamposWeb(1, "con_descricao", false));
        CAMPOS.put("senhaConvenio", new CamposWeb(1, "con_senha", false));
        CAMPOS.put("bloqueadoConvenio", new CamposWeb(2, "con_bloqueado", false));
        CAMPOS.put("mensagemPopupConvenio", new CamposWeb(6, "con_msgpopup", false));
        CAMPOS.put("conselhoMedico", new CamposWeb(1, "med_conselho", true));
        CAMPOS.put("crmMedico", new CamposWeb(1, "med_codigo", true));
        CAMPOS.put("ufMedico", new CamposWeb(1, "med_uf", true));
        CAMPOS.put("senhaMedico", new CamposWeb(1, "med_senha", false));
        CAMPOS.put("nomeMedico", new CamposWeb(1, "med_nome", false));
        CAMPOS.put("codigoExame", new CamposWeb(1, "exm_codigo", true));
        CAMPOS.put("codigoMaterialExame", new CamposWeb(2, "exm_codmaterial", true));
        CAMPOS.put("descricaoExame", new CamposWeb(1, "exm_descricao", false));
        CAMPOS.put("modoColetaExame", new CamposWeb(1, "exm_modocoleta", false));
        CAMPOS.put("sinonimoExame", new CamposWeb(1, "exm_sinonimo", false));
        CAMPOS.put("metodoExame", new CamposWeb(1, "exm_metodo", false));
        CAMPOS.put("ambExame", new CamposWeb(1, "exm_amb", false));
        CAMPOS.put("cbhpmExame", new CamposWeb(1, "exm_cbhpm", false));
        CAMPOS.put("prazoExame", new CamposWeb(1, "exm_prazo", false));
        CAMPOS.put("valorReferenciaExame", new CamposWeb(1, "exm_referencia", false));
        CAMPOS.put("interferenciaExame", new CamposWeb(1, "exm_interferencia", false));
        CAMPOS.put("diagnosticoExame", new CamposWeb(1, "exm_diagnostico", false));
        CAMPOS.put("modoPreparoExame", new CamposWeb(1, "exm_modopreparo", false));
        CAMPOS.put("materialExame", new CamposWeb(1, "exm_material", false));
        CAMPOS.put("preparoAmostraExame", new CamposWeb(1, "exm_prepamostra", false));
        CAMPOS.put("amostraInadequadaExame", new CamposWeb(1, "exm_inadequada", false));
        CAMPOS.put("conservacaoExame", new CamposWeb(1, "exm_conservacao", false));
        CAMPOS.put("procedimentoExame", new CamposWeb(1, "exm_procedimento", false));
        CAMPOS.put("bloqueadoExame", new CamposWeb(6, "exm_bloqueado", false));
        CAMPOS.put("assinaturaPadraoExame", new CamposWeb(1, "exm_assinaturapadrao", false));
        CAMPOS.put("proibidoPaciente", new CamposWeb(6, "exm_proibidopaciente", false));
        CAMPOS.put("proibidoConvenio", new CamposWeb(6, "exm_proibidoconvenio", false));
        CAMPOS.put("proibidoMedico", new CamposWeb(6, "exm_proibidomedico", false));
        CAMPOS.put("proibidoDestino", new CamposWeb(6, "exm_proibidodestino", false));
        CAMPOS.put("proibidoFiscal", new CamposWeb(6, "exm_proibidofiscal", false));
        CAMPOS.put("proibidoResponsavel", new CamposWeb(6, "exm_proibidoresponsavel", false));
        CAMPOS.put(CODIGO_REQUISICAO, new CamposWeb(2, "req_codigo", true));
        CAMPOS.put("dataRequisicao", new CamposWeb(4, "req_data", false));
        CAMPOS.put("horaRequisicao", new CamposWeb(5, "req_hora", false));
        CAMPOS.put("destinoRequisicao", new CamposWeb(1, "des_descricao", false));
        CAMPOS.put("coletaRequisicao", new CamposWeb(1, "col_descricao", false));
        CAMPOS.put("codigoConvenioRequisicao", new CamposWeb(2, "con_codigo", false));
        CAMPOS.put("conselhoMedicoRequisicao", new CamposWeb(1, "med_conselho", false));
        CAMPOS.put("crmMedicoRequisicao", new CamposWeb(1, "med_codigo", false));
        CAMPOS.put("ufMedicoRequisicao", new CamposWeb(1, "med_uf", false));
        CAMPOS.put("idadeRequisicao", new CamposWeb(1, "req_idade", false));
        CAMPOS.put("dataNascimentoRequisicao", new CamposWeb(4, "req_dtnascimento", false));
        CAMPOS.put("senhaRequisicao", new CamposWeb(1, "req_senha", false));
        CAMPOS.put("valorRequisicao", new CamposWeb(3, "req_total", false));
        CAMPOS.put("valorPagoRequisicao", new CamposWeb(3, "req_valorpago", false));
        CAMPOS.put("codigoPacienteRequisicao", new CamposWeb(2, "pac_codigo", false));
        CAMPOS.put("dadosCabecalhoRequisicao", new CamposWeb(1, "req_dadoscabec", false));
        CAMPOS.put("codigoDestinoRequisicao", new CamposWeb(1, "des_codigo", false));
        CAMPOS.put("entidadeRequisicao", new CamposWeb(2, "ent_codigo", false));
        CAMPOS.put("resultadoPdfRequisicao", new CamposWeb(1, "req_resultadopdf", false));
        CAMPOS.put("dataRecebimentoProdutoRequisicao", new CamposWeb(4, "req_datarecebimentoproduto", false));
        CAMPOS.put("dataColetaProdutoRequisicao", new CamposWeb(4, "req_datacoletaproduto", false));
        CAMPOS.put("horaRecebimentoProdutoRequisicao", new CamposWeb(1, "req_horarecebimentoproduto", false));
        CAMPOS.put("horaColetaProdutoRequisicao", new CamposWeb(1, "req_horacoletaproduto", false));
        CAMPOS.put("descricaoProdutoRequisicao", new CamposWeb(1, "req_descricaoproduto", false));
        CAMPOS.put("numeroLoteProdutoRequisicao", new CamposWeb(1, "req_numeroloteproduto", false));
        CAMPOS.put("lacreProdutoRequisicao", new CamposWeb(1, "req_lacreproduto", false));
        CAMPOS.put("situacaoRequisicao", new CamposWeb(1, "req_situacao", false));
        CAMPOS.put("numeroSolicitacao", new CamposWeb(1, "req_nrsolicitacaoproduto", false));
        CAMPOS.put("prontuarioRequisicao", new CamposWeb(1, "req_prontuario ", false));
        CAMPOS.put(CODIGO_EXAME_REQUISICAO, new CamposWeb(1, "exm_codigo", true));
        CAMPOS.put(MATERIAL_EXAME_REQUISICAO, new CamposWeb(2, "exm_codmaterial", true));
        CAMPOS.put("descricaoMaterialExameRequisicao", new CamposWeb(1, "rex_descricaomaterial", false));
        CAMPOS.put("dataColetaExameRequisicao", new CamposWeb(4, "rex_datacoleta", false));
        CAMPOS.put("horaColetaExameRequisicao", new CamposWeb(5, "rex_horacoleta", false));
        CAMPOS.put("paginaExameRequisicao", new CamposWeb(2, "rex_pagina", false));
        CAMPOS.put("ordemExameRequisicao", new CamposWeb(2, "rex_ordem", false));
        CAMPOS.put(SITUACAO_EXAME_REQUISICAO, new CamposWeb(1, "rex_situacao", false));
        CAMPOS.put("assinaturaExameRequisicao", new CamposWeb(1, "usr_assinatura", false));
        CAMPOS.put("nomeAssinaturaExameRequisicao", new CamposWeb(1, "rex_nomeassinatura", false));
        CAMPOS.put("resultadoExameRequisicao", new CamposWeb(1, "rex_resultado", false));
        CAMPOS.put("dataEnvioExameRequisicao", new CamposWeb(2, "rex_dataenvio", false));
        CAMPOS.put("resultadoTextoExameRequisicao", new CamposWeb(1, "rex_resultadotexto", false));
        CAMPOS.put("contadorPaginaExameRequisicao", new CamposWeb(2, "rex_contadorpagina", true, true));
        CAMPOS.put("codigoUsuarioConferenciaExameRequisicao", new CamposWeb(1, "usr_codigoconferencia", false));
        CAMPOS.put("codigoUsuarioConferenciaExameRequisicao", new CamposWeb(1, "usr_codigoconferencia", false));
        CAMPOS.put("codigoImagemExame", new CamposWeb(2, "rei_codigo", true));
        CAMPOS.put("imagemExame", new CamposWeb(1, "rei_imagem", false));
        CAMPOS.put("codigoPaciente", new CamposWeb(2, "pac_codigo", true));
        CAMPOS.put("nomePaciente", new CamposWeb(1, "pac_nome", false));
        CAMPOS.put("senhaPaciente", new CamposWeb(1, "pac_senha", false));
        CAMPOS.put("cpfPaciente", new CamposWeb(1, "pac_cpf", false));
        CAMPOS.put("sifPaciente", new CamposWeb(1, "pac_sif", false));
        CAMPOS.put("proprietarioPaciente", new CamposWeb(1, "pac_proprietario", false));
        CAMPOS.put("bloqueadoWebPaciente", new CamposWeb(1, "pac_proibidoweb", false));
        CAMPOS.put("codigoMensagem", new CamposWeb(2, "mec_codigo", true));
        CAMPOS.put("textoMensagem", new CamposWeb(1, "mec_mensagem", false));
        CAMPOS.put("dataMensagem", new CamposWeb(2, "mec_data", false));
        CAMPOS.put("tituloMensagem", new CamposWeb(1, "mec_titulo", false));
        CAMPOS.put("codigoDestino", new CamposWeb(1, "des_codigo", true));
        CAMPOS.put("descricaoDestino", new CamposWeb(1, "des_descricao", false));
        CAMPOS.put("senhaDestino", new CamposWeb(1, "des_senha", false));
        CAMPOS.put("ativadoDestino", new CamposWeb(6, "des_ativado", false));
        CAMPOS.put("conselhoMedicoExame", new CamposWeb(1, "med_conselho", true));
        CAMPOS.put("crmMedicoExame", new CamposWeb(1, "med_codigo", true));
        CAMPOS.put("ufMedicoExame", new CamposWeb(1, "med_uf", true));
        CAMPOS.put("codigoExameMedicoExame", new CamposWeb(1, "exm_codigo", true));
        CAMPOS.put("proibidoMedicoExame", new CamposWeb(1, "mee_proibido", false));
        CAMPOS.put("codigoEntidade", new CamposWeb(2, "ent_codigo", true));
        CAMPOS.put("tipoEntidade", new CamposWeb(1, "ent_tipo", true));
        CAMPOS.put("nomeEntidade", new CamposWeb(1, "ent_nome", false));
        CAMPOS.put("senhaEntidade", new CamposWeb(1, "ent_senha", false));
        CAMPOS.put("cpfEntidade", new CamposWeb(1, "ent_cpf", false));
        CAMPOS.put("codigoUsuario", new CamposWeb(1, "usr_codigo", true));
        CAMPOS.put("nomeUsuario", new CamposWeb(1, "usr_nome", false));
        CAMPOS.put("assinaturaUsuario", new CamposWeb(1, "usr_imagemassinatura", false));
        CAMPOS.put("codigoRequisicaoResultado", new CamposWeb(2, "rer_id", true));
        CAMPOS.put("codigoHash", new CamposWeb(1, "rer_hash", false));
        CAMPOS.put("dataConferencia", new CamposWeb(4, "rer_dataconferencia", false));
        CAMPOS.put("codigoUsuarioConferenciaExameRequisicaoResultado", new CamposWeb(1, "usr_codconferencia", false));
        CAMPOS.put("resultadoPdf", new CamposWeb(1, "rer_resultadopdf", false));
        CAMPOS.put("resultadoTexto", new CamposWeb(1, "rer_resultadotexto", false));
        CAMPOS.put("codigoExameRequisicaoResultadoPagina", new CamposWeb(1, "exm_codigo", true));
        CAMPOS.put("codigoMaterialExameRequisicaoResultadoPagina", new CamposWeb(2, "exm_codmaterial", true));
        CAMPOS.put("contadorPaginaRequisicaoExameResultadoPagina", new CamposWeb(2, "rep_contadorpagina", true));
        CAMPOS.put("resultadoHtmlRequisicaoExameResultadoPagina", new CamposWeb(1, "rep_resultadohtml", false));
        CAMPOS.put("pacienteRequisicaoPdf", new CamposWeb(1, "pdf_paciente", false));
        CAMPOS.put("convenioRequisicaoPdf", new CamposWeb(1, "pdf_convenio", false));
        CAMPOS.put("destinoRequisicaoPdf", new CamposWeb(1, "pdf_destino", false));
        CAMPOS.put("medicoRequisicaoPdf", new CamposWeb(1, "pdf_medico", false));
        CAMPOS.put("fiscalRequisicaoPdf", new CamposWeb(1, "pdf_fiscal", false));
        CAMPOS.put("responsavelRequisicaoPdf", new CamposWeb(1, "pdf_responsavel", false));
    }
}

