/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.exportacao.thread;

import jalis.comum.ConexaoSMS;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.exportacao.thread.FilialSMS;
import jalis.laboratorio.exportacao.thread.ThreadMensagens;
import jalis.laboratorio.exportacao.util.ExportacaoMonitor;
import jalis.laboratorio.exportacao.util.ExportacaoMonitorListener;
import jalis.laboratorio.interfaceamento.comunicacao.PortaCOM;
import jalis.laboratorio.interfaceamento.comunicacao.processararquivo.ProcessaArquivoComunicacao;
import jalis.laboratorio.util.SMSUtil;
import jalis.model.bean.exportadores.LogSMSBean;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.logger.ErrorLogger;
import jalis.util.sms.SmsBean;
import jalis.util.sms.SmsSender;
import jalis.util.sms.SmsSenderAPI;
import jalis.util.sms.SmsSituacaoListener;
import jalis.util.sms.StatusReportBean;
import jalis.util.sms.comunicacao.DataBits;
import jalis.util.sms.comunicacao.Fluxo;
import jalis.util.sms.comunicacao.Paridade;
import jalis.util.sms.comunicacao.StopBits;
import jalis.util.sms.comunicacao.Velocidade;
import jalis.util.sms.utils.Utils;
import java.awt.TextArea;
import java.io.File;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Set;
import javax.swing.ImageIcon;

public class ExportaSMS
extends Thread
implements SmsSituacaoListener,
ExportacaoMonitorListener {
    public static final ImageIcon ICONE_ENVIANDO_SMS_OFF = ImagemUtils.carregaImagemJalis("enviando_sms_off.jpg");
    public static final ImageIcon ICONE_ENVIANDO_SMS_ON = ImagemUtils.carregaImagemJalis("enviando_sms_on.jpg");
    public static final ImageIcon ICONE_ENVIANDO_SMS_ERRO = ImagemUtils.carregaImagemJalis("enviando_sms_erro.jpg");
    private static final String MASCARA_DATA = "yyyy/MM/dd HH:mm:ss:SSS";
    private static final int TEMPO_ESPERA_ENVIO_SMS = 60000;
    private static final int QUANTIDADE_DIAS_ARMAZENAR_LOGS = 10;
    private SmsSender sender = null;
    private SmsSenderAPI senderAPI = null;
    private TextArea textMensagens = null;
    private ThreadMensagens th;
    private boolean executar = true;
    private boolean parar = false;
    private String modemConfiguracao = "";
    private String xmlApiSms = "";
    private String portaModem = "";
    private ExportacaoMonitor exportacaoMonitor = new ExportacaoMonitor();
    private PreparedStatement prstRemoveLogs = null;
    private HashMap<Integer, FilialSMS> dadosFilial = new HashMap();
    ThreadGeraLogSMSAniversario threadAniversario = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExportaSMS() {
        super("Thread ExportaSMS");
        this.setPriority(1);
        if (!this.testaParametros(true)) {
            Laboratorio.setIconeEnvioSMS(ICONE_ENVIANDO_SMS_ERRO);
            this.parar = true;
            return;
        }
        Laboratorio.setIconeEnvioSMS(this.parar ? ICONE_ENVIANDO_SMS_ERRO : ICONE_ENVIANDO_SMS_OFF);
        this.exportacaoMonitor.addExportacaoListener(Laboratorio.getJanelaMonitoramentoExportacaoSms());
        this.threadAniversario = new ThreadGeraLogSMSAniversario();
        this.threadAniversario.start();
        StringBuilder buf = new StringBuilder();
        buf.append(" delete from logsms ");
        buf.append("  where fil_codigo = ? ");
        buf.append("    and sms_datahora <= ? ");
        this.prstRemoveLogs = ConexaoSMS.getPreparedStatement(buf.toString());
        Statement st = ConexaoSMS.getStatement();
        Statement st2 = ConexaoSMS.getStatement();
        try {
            buf.setLength(0);
            buf.append(" select fil_codigo ");
            buf.append("       ,fil_smsresumofinanceiro ");
            buf.append("       ,fil_smshorainicial ");
            buf.append("       ,fil_smshorafinal ");
            buf.append("       ,fil_fonessmsresumo ");
            buf.append("       ,fil_smshoraresumofinanceiro ");
            buf.append("   from filiais_postocoleta ");
            buf.append("  where fil_enviarsms = true ");
            buf.append("  order by fil_codigo ");
            ResultSet rs = ConexaoSMS.executeQuery(st, buf.toString());
            while (rs.next()) {
                String[] fones = !DBUtil.campoNull(rs.getString("fil_fonessmsresumo")) ? rs.getString("fil_fonessmsresumo").split(";") : null;
                FilialSMS fs = new FilialSMS(rs.getTime("fil_smshorainicial"), rs.getTime("fil_smshorafinal"), rs.getBoolean("fil_smsresumofinanceiro"), fones, rs.getTime("fil_smshoraresumofinanceiro"));
                this.dadosFilial.put(rs.getInt("fil_codigo"), fs);
            }
            if (this.sender == null || this.senderAPI == null) {
                this.escreverMensagem("Conectando ao modem na porta " + this.portaModem + " .");
                if (this.portaModem.equals("API")) {
                    this.senderAPI = this.configuraSmsApi();
                    this.senderAPI.carregar();
                    this.senderAPI.addSmsSituacaoListener(this);
                    this.escreverMensagem("API Configurada, iniciando envio.");
                } else {
                    Velocidade velocidade = (Velocidade)Velocidade.V9600.getTipo(Utils.getXMLTagValue(this.modemConfiguracao, "velocidade", true));
                    DataBits dataBits = (DataBits)DataBits.D8.getTipo(Utils.getXMLTagValue(this.modemConfiguracao, "dataBits", true));
                    StopBits stopBits = (StopBits)StopBits.S1.getTipo(Utils.getXMLTagValue(this.modemConfiguracao, "stopBits", true));
                    Paridade paridade = (Paridade)Paridade.Nenhuma.getTipo(String.valueOf(Utils.getXMLTagValue(this.modemConfiguracao, "paridade", true).charAt(0)));
                    Fluxo fluxo = (Fluxo)Fluxo.Nenhum.getTipo(String.valueOf(Utils.getXMLTagValue(this.modemConfiguracao, "fluxo", true).charAt(0)));
                    boolean gravaLog = Boolean.parseBoolean(Utils.getXMLTagValue(this.modemConfiguracao, "log", true));
                    long delayEnvioSms = Long.parseLong(Utils.getXMLTagValue(this.modemConfiguracao, "delayEnvioSms", true)) * 1000L;
                    this.sender = new SmsSender();
                    this.sender.config(this.portaModem, velocidade, dataBits, stopBits, paridade, fluxo, gravaLog, delayEnvioSms, this.exportacaoMonitor);
                    this.sender.carregar();
                    this.sender.configModem();
                    this.sender.addSmsSituacaoListener(this);
                    while (this.sender.isEnviandoConfiguracao()) {
                        this.sender.enviarProximaConfiguracao();
                    }
                    this.escreverMensagem("Porta configurada, iniciando envio.");
                }
            }
            buf.setLength(0);
            buf.append(" select fil_codigo ");
            buf.append("       ,sms_codigo ");
            buf.append("       ,sms_datahora ");
            buf.append("       ,sms_celular ");
            buf.append("       ,sms_mensagem ");
            buf.append("       ,sms_dataenvio ");
            buf.append("   from logsms ");
            buf.append("  where sms_dataenvio is null ");
            buf.append("    and sms_situacao = '").append("F").append("' ");
            buf.append("  order by sms_datahora ");
            buf.append("          ,fil_codigo ");
            buf.append("          ,sms_codigo ");
            ResultSet rsLogs = ConexaoSMS.executeQuery(st, buf.toString());
            while (rsLogs.next()) {
                this.adicionaSMSnaFila(st2, rsLogs.getInt("fil_codigo"), rsLogs.getLong("sms_codigo"), rsLogs.getString("sms_celular"), rsLogs.getString("sms_mensagem"));
                ExportaSMS.sleep(50L);
            }
            ConexaoSMS.arquivaSQL();
        }
        catch (Exception e) {
            try {
                ConexaoSMS.anulaSQL();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
        }
        finally {
            ConexaoSMS.fecharStatement(st);
            ConexaoSMS.fecharStatement(st2);
        }
    }

    private SmsSenderAPI configuraSmsApi() {
        String codigoCliente = Utils.getXMLTagValue(this.xmlApiSms, "codigoEnvioSms", true);
        String key = Utils.getXMLTagValue(this.xmlApiSms, "keyEnvioSms", true);
        return new SmsSenderAPI(this.portaModem, codigoCliente, key, this.exportacaoMonitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        StringBuilder buf = new StringBuilder();
        buf.append(" select fil_codigo ");
        buf.append("       ,sms_codigo ");
        buf.append("       ,sms_datahora ");
        buf.append("       ,sms_celular ");
        buf.append("       ,sms_mensagem ");
        buf.append("       ,sms_dataenvio ");
        buf.append("   from logsms ");
        buf.append("  where sms_dataenvio is null ");
        buf.append("    and sms_situacao = '").append("E").append("' ");
        buf.append("  order by sms_datahora ");
        buf.append("          ,fil_codigo ");
        buf.append("          ,sms_codigo ");
        PreparedStatement prstLogs = ConexaoSMS.getPreparedStatement(buf.toString());
        Statement st = ConexaoSMS.getStatement();
        while (this.executar) {
            try {
                for (int chaveFilial : this.dadosFilial.keySet()) {
                    FilialSMS df = this.dadosFilial.get(chaveFilial);
                    if (!df.isGerarResumoFinanceiro() || df.getFonesResumo() == null || df.getFonesResumo().length <= 0 || Funcoes.comparaHora(Funcoes.formataData("HH:mm", new java.util.Date()), Funcoes.formataData("HH:mm", df.getHoraEnviarResumoFinanceiro())) < 0 || this.jaGerouSMSResumoFinanceiro(st, chaveFilial)) continue;
                    BigDecimal valorRecebido = new BigDecimal("0");
                    BigDecimal valorPago = new BigDecimal("0");
                    BigDecimal valorFaturado = new BigDecimal("0");
                    int qtdeRequisicoes = 0;
                    int qtdeExames = 0;
                    StringBuilder bui = new StringBuilder();
                    bui.append(" select sum(lcx_valor) as soma ");
                    bui.append("   from lanctocaixa ");
                    bui.append("  where fil_codigo = ").append(chaveFilial);
                    bui.append("    and lcx_tipo = '").append("C").append("' ");
                    bui.append("    and cast(lcx_datahora as date) = '").append(Funcoes.formataData("yyyy-MM-dd", new java.util.Date())).append("' ");
                    bui.append("    and lcx_datacancelado is null ");
                    ResultSet rsResumo = ConexaoSMS.executeQuery(st, bui);
                    if (rsResumo.next() && rsResumo.getBigDecimal(1) != null) {
                        valorRecebido = rsResumo.getBigDecimal(1);
                    }
                    bui.setLength(0);
                    bui.append(" select sum(lcx_valor) as soma ");
                    bui.append("   from lanctocaixa ");
                    bui.append("  where fil_codigo = ").append(chaveFilial);
                    bui.append("    and lcx_tipo = '").append("D").append("' ");
                    bui.append("    and cast(lcx_datahora as date) = '").append(Funcoes.formataData("yyyy-MM-dd", new java.util.Date())).append("' ");
                    bui.append("    and lcx_datacancelado is null ");
                    rsResumo = ConexaoSMS.executeQuery(st, bui);
                    if (rsResumo.next() && rsResumo.getBigDecimal(1) != null) {
                        valorPago = rsResumo.getBigDecimal(1);
                    }
                    bui.setLength(0);
                    bui.append(" select sum(fat_totalexames) as soma ");
                    bui.append("   from fatura ");
                    bui.append("  where fil_codigo = ").append(chaveFilial);
                    bui.append("    and fat_dtemis = '").append(Funcoes.formataData("yyyy-MM-dd", new java.util.Date())).append("' ");
                    bui.append("    and fat_datacancelamento is null ");
                    rsResumo = ConexaoSMS.executeQuery(st, bui);
                    if (rsResumo.next() && rsResumo.getBigDecimal(1) != null) {
                        valorFaturado = rsResumo.getBigDecimal(1);
                    }
                    bui.setLength(0);
                    bui.append(" select count(req_codigo) as soma ");
                    bui.append("   from requisicao ");
                    bui.append("  where fil_codigo = ").append(chaveFilial);
                    bui.append("    and req_data = '").append(Funcoes.formataData("yyyy-MM-dd", new java.util.Date())).append("' ");
                    bui.append("    and (req_excluida is null or req_excluida = false) ");
                    rsResumo = ConexaoSMS.executeQuery(st, bui);
                    if (rsResumo.next() && rsResumo.getBigDecimal(1) != null) {
                        qtdeRequisicoes = rsResumo.getInt(1);
                    }
                    bui.setLength(0);
                    bui.append(" select count(req_codigo) as soma ");
                    bui.append("   from examerequisicao ");
                    bui.append("  where fil_codigo = ").append(chaveFilial);
                    bui.append("    and cast(exr_data as date) = '").append(Funcoes.formataData("yyyy-MM-dd", new java.util.Date())).append("' ");
                    bui.append("    and (exr_excluido is null or exr_excluido = false) ");
                    rsResumo = ConexaoSMS.executeQuery(st, bui);
                    if (rsResumo.next() && rsResumo.getBigDecimal(1) != null) {
                        qtdeExames = rsResumo.getInt(1);
                    }
                    String mensagem = "Resumo do dia " + Funcoes.formataData("dd/MM/yy", new java.util.Date()) + " da filial " + String.valueOf(chaveFilial) + ": " + String.valueOf(qtdeRequisicoes) + " requisicoes, " + String.valueOf(qtdeExames) + " exames, R$ " + Funcoes.formataDecimal(valorRecebido.floatValue(), 2) + " recebido, R$ " + Funcoes.formataDecimal(valorPago.floatValue(), 2) + " pago e R$ " + Funcoes.formataDecimal(valorFaturado.floatValue(), 2) + " faturado ";
                    try {
                        this.exportacaoMonitor.setOperacaoAtual("Gerando logs de resumo financeiro.");
                        for (String celular : df.getFonesResumo()) {
                            if (SMSUtil.isCelularVazio(celular)) continue;
                            SMSUtil.enviarSMS(Laboratorio.getInstancia(), String.valueOf(chaveFilial), celular, mensagem, TipoSMS.FINANCEIRO, st, null, null);
                        }
                        bui.setLength(0);
                        bui.append(" insert into filialsmsresumo (fil_codigo, fsr_data, fsr_mensagem) ");
                        bui.append(" values (").append(chaveFilial);
                        bui.append("        ,'").append(Funcoes.formataData("yyyy-MM-dd", new java.util.Date())).append("' ");
                        bui.append("        ,'").append(mensagem).append("') ");
                        ConexaoSMS.execute(st, bui);
                        ConexaoSMS.arquivaSQL();
                    }
                    catch (Exception e) {
                        try {
                            ConexaoSMS.anulaSQL();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
                    }
                }
                ResultSet rs = null;
                try {
                    rs = prstLogs.executeQuery();
                    int qtdeTotal = 0;
                    while (rs.next()) {
                        ++qtdeTotal;
                    }
                    rs.beforeFirst();
                    this.exportacaoMonitor.setQuantidadeLogEnvio(qtdeTotal);
                    this.exportacaoMonitor.setLogAtual(0);
                    this.exportacaoMonitor.setOperacaoAtual("Processando logs.");
                    int i = 1;
                    while (rs.next()) {
                        this.exportacaoMonitor.setLogAtual(i);
                        this.adicionaSMSnaFila(st, rs.getInt("fil_codigo"), rs.getLong("sms_codigo"), rs.getString("sms_celular"), rs.getString("sms_mensagem"));
                        ExportaSMS.sleep(50L);
                        ++i;
                    }
                    this.exportacaoMonitor.setOperacaoAtual("Logs processados.");
                    this.exportacaoMonitor.setQuantidadeLogEnvio(0);
                    this.exportacaoMonitor.setLogAtual(0);
                    ConexaoSMS.arquivaSQL();
                    if (this.sender != null) {
                        this.sender.startServico();
                    }
                    if (this.senderAPI != null) {
                        this.senderAPI.startServico();
                    }
                    this.escreverMensagem("Aguardando pr\u00f3ximo envio...(" + (this.sender != null ? this.sender.getQuantidadeSmsEnviar() : 0) + " para enviar)");
                    ExportaSMS.sleep(60000L);
                }
                finally {
                    if (rs == null) continue;
                    rs.close();
                }
            }
            catch (Exception e) {
                try {
                    ConexaoSMS.anulaSQL();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
                this.smsNaoEnviada();
            }
        }
    }

    private void adicionaSMSnaFila(Statement st, int codigoFilial, long codigoSMS, String celular, String mensagem) throws SQLException {
        FilialSMS df = this.dadosFilial.get(codigoFilial);
        if (df != null && df.getHoraInicial() != null && df.getHoraFinal() != null && (Funcoes.comparaHora(Funcoes.formataData("HH:mm", new java.util.Date()), Funcoes.formataData("HH:mm", df.getHoraInicial())) <= 0 || Funcoes.comparaHora(Funcoes.formataData("HH:mm", new java.util.Date()), Funcoes.formataData("HH:mm", df.getHoraFinal())) >= 0)) {
            return;
        }
        LogSMSBean bean = new LogSMSBean();
        FilialVO filialVO = new FilialVO();
        filialVO.setCodigo(codigoFilial);
        bean.setFilial(filialVO);
        bean.setCodigo(codigoSMS);
        bean.setCelular(celular);
        bean.setMensagem(mensagem);
        SmsBean smsBean = new SmsBean(bean.getFilial().getCodigo(), bean.getCodigo(), bean.getCelular(), bean.getMensagem());
        if (this.portaModem.equals("API")) {
            this.senderAPI.addSmsEnvio(smsBean);
        } else {
            this.sender.addSmsEnvio(smsBean);
        }
        StringBuilder bufUpdate = new StringBuilder();
        bufUpdate.append(" update logsms ");
        bufUpdate.append("    set sms_situacao = '").append("F").append("' ");
        bufUpdate.append("  where sms_codigo = ").append(smsBean.getCodigo());
        ConexaoSMS.execute(String.valueOf(codigoFilial), st, bufUpdate.toString(), false);
    }

    private boolean jaGerouSMSResumoFinanceiro(Statement st, int filial) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append(" select fsr_data ");
        buf.append("   from filialsmsresumo ");
        buf.append("  where fil_codigo = ").append(filial);
        buf.append("    and fsr_data = '").append(Funcoes.formataData("yyyy-MM-dd", new java.util.Date())).append("'");
        ResultSet rs = ConexaoSMS.executeQuery(st, buf.toString());
        return rs.next();
    }

    public boolean isEnviandoSms() {
        if (this.isSmsApi()) {
            return this.senderAPI == null ? false : this.senderAPI.isEnviando();
        }
        return this.sender == null ? false : this.sender.isEnviando();
    }

    @Override
    public void smsEnviada(SmsBean sms) {
        if (sms != null) {
            this.escreverMensagem("Mensagem enviada para " + sms.getNumero());
            Statement st = ConexaoSMS.getStatement();
            try {
                StringBuilder sql = new StringBuilder();
                sql.append(" update logsms ");
                sql.append("    set sms_situacao = '").append("O").append("' ");
                if (!Funcoes.textoVazio(sms.getMensagemErro())) {
                    sql.append("     ,sms_mensagemerro = '").append(sms.getMensagemErro()).append("' ");
                }
                sql.append("       ,sms_id = '").append(sms.getId()).append("' ");
                sql.append("  where sms_codigo = ").append(sms.getCodigo());
                ConexaoSMS.execute(Variaveis.filialPadrao, st, sql.toString(), false);
                ConexaoSMS.arquivaSQL();
            }
            catch (SQLException e) {
                try {
                    ConexaoSMS.anulaSQL();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            }
        }
    }

    @Override
    public void smsEnviadaOperadora(SmsBean sms) {
        if (sms != null) {
            this.escreverMensagem("Mensagem enviada para " + sms.getNumero());
            Statement st = ConexaoSMS.getStatement();
            try {
                StringBuilder sql = new StringBuilder();
                sql.append(" update logsms ");
                sql.append("    set sms_dataenvio = '").append(Funcoes.formataData("yyyy-MM-dd HH:mm:ss", new java.util.Date())).append("' ");
                sql.append("\t\t, sms_situacao = '").append("O").append("' ");
                sql.append("  where sms_codigo = ").append(sms.getCodigo());
                ConexaoSMS.execute(Variaveis.filialPadrao, st, sql.toString(), false);
                ConexaoSMS.arquivaSQL();
            }
            catch (SQLException e) {
                try {
                    ConexaoSMS.anulaSQL();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            }
        }
    }

    public void escreverMensagem(String mensagem) {
        if (this.th != null) {
            this.th.adicionarMensagem("\n" + Funcoes.formataData(MASCARA_DATA, Calendar.getInstance().getTime()) + "| " + mensagem);
        }
    }

    @Override
    public void smsNaoEnviada(SmsBean sms) {
        ExportaSMS.smsNaoEnviada(sms, "E");
    }

    public static void smsNaoEnviada(SmsBean sms, String tipo) {
        if (sms != null) {
            Statement st = ConexaoSMS.getStatement();
            try {
                StringBuilder sql = new StringBuilder();
                sql.append(" update logsms ");
                sql.append("    set sms_situacao = '").append(tipo).append("' ");
                sql.append("       ,sms_dataenvio = null ");
                sql.append("  where sms_id is null ");
                sql.append("    and sms_codigo = ").append(sms.getCodigo());
                sql.append("    and sms_situacao = '").append("F").append("' ");
                sql.append("    and sms_celular = '").append(sms.getNumero()).append("' ");
                ConexaoSMS.execute(sms.getFilial().toString(), st, sql.toString(), false);
                ConexaoSMS.arquivaSQL();
            }
            catch (SQLException e) {
                try {
                    ConexaoSMS.anulaSQL();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            }
        }
    }

    public void smsNaoEnviada() {
        Statement st = ConexaoSMS.getStatement();
        try {
            StringBuilder sql = new StringBuilder();
            sql.append(" update logsms ");
            sql.append("    set sms_situacao = '").append("E").append("' ");
            sql.append("  where sms_id is null ");
            sql.append("    and sms_situacao = '").append("F").append("' ");
            ConexaoSMS.execute(Variaveis.filialPadrao, st, sql.toString(), false);
            ConexaoSMS.arquivaSQL();
        }
        catch (SQLException e) {
            try {
                ConexaoSMS.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
        }
    }

    @Override
    public void statusReportRecebido(StatusReportBean sr) {
        if (sr != null) {
            this.escreverMensagem("Mensagem confirmada para o sms " + sr.getSmsNumero());
            Statement st = ConexaoSMS.getStatement();
            try {
                StringBuilder sql = new StringBuilder();
                sql.append(" update logsms ");
                sql.append("    set sms_situacao = '").append("C").append("' ");
                sql.append("  where (sms_id = ").append(sr.getSmsId());
                sql.append("         or sms_id = 500)");
                sql.append("    and sms_situacao in ('").append("O").append("', '").append("F").append("') ");
                sql.append("    and sms_celular = '").append(sr.getCelular()).append("' ");
                ConexaoSMS.execute(Variaveis.filialPadrao, st, sql.toString(), false);
                ConexaoSMS.arquivaSQL();
            }
            catch (SQLException e) {
                try {
                    ConexaoSMS.anulaSQL();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            }
        }
    }

    public static boolean existeArquivoConfiguracao() {
        File f = new File(System.getProperty("user.home") + System.getProperty("file.separator") + "sms.jalis");
        return f.exists();
    }

    public void setTextMensagens(TextArea textMensagens) {
        this.textMensagens = textMensagens;
        if (this.th == null) {
            this.th = new ThreadMensagens(textMensagens);
            this.th.start();
        }
    }

    public void setParar() {
        this.executar = false;
        if (this.isSmsApi()) {
            if (null != this.senderAPI) {
                this.senderAPI.pararEnvio();
            }
        } else if (this.sender != null) {
            this.sender.pararEnvio();
        }
    }

    private boolean testaParametros(boolean mostrarMensagem) {
        boolean isModemConfigurado;
        this.modemConfiguracao = ParametrosLocais.getParametro("xmlModemSms");
        this.xmlApiSms = ParametrosLocais.getParametro("xmlApiSms");
        ArrayList<String> lista = null;
        if (new ProcessaArquivoComunicacao().processarArquivoRxtx() && this.modemConfiguracao != null) {
            PortaCOM portaCOM = new PortaCOM();
            lista = portaCOM.getListaPortasSeriaisDisponiveis();
            if (lista.isEmpty()) {
                Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel conectar com dispositivo SMS, verifique as configura\u00e7\u00f5es de porta.", 1);
                return false;
            }
        } else if (this.xmlApiSms == null) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel conectar com dispositivo SMS, verifique as configura\u00e7\u00f5es de porta.", 1);
            return false;
        }
        if (this.modemConfiguracao == null && this.xmlApiSms == null) {
            if (mostrarMensagem) {
                Funcoes.mensagem(null, "N\u00e3o encontrada nenhuma configura\u00e7\u00e3o para envio de SMS.", 1);
            }
            Laboratorio.setIconeEnvioSMS(ICONE_ENVIANDO_SMS_ERRO);
            Laboratorio.setHintEnvioSMS("N\u00e3o encontrada nenhuma configura\u00e7\u00e3o para envio de SMS.");
            return false;
        }
        this.portaModem = ParametrosLocais.getParametro("modemSms");
        boolean bl = isModemConfigurado = !Funcoes.textoVazio(this.modemConfiguracao);
        if (Funcoes.textoVazio(this.portaModem) || this.portaModem.equals("Sem modem")) {
            if (mostrarMensagem) {
                Laboratorio.setIconeEnvioSMS(ICONE_ENVIANDO_SMS_ERRO);
                Laboratorio.setHintEnvioSMS("Porta n\u00e3o configurada para o modem.");
            }
            return false;
        }
        if (!isModemConfigurado && !this.portaModem.equals("API")) {
            if (mostrarMensagem) {
                Laboratorio.setIconeEnvioSMS(ICONE_ENVIANDO_SMS_ERRO);
                Laboratorio.setHintEnvioSMS("Nenhum modem foi configurado.\nVerifique a configura\u00e7\u00e3o da esta\u00e7\u00e3o.");
            }
            return false;
        }
        if (!this.verificaFiliaisConfiguradas()) {
            if (mostrarMensagem) {
                Laboratorio.setIconeEnvioSMS(ICONE_ENVIANDO_SMS_ERRO);
                Laboratorio.setHintEnvioSMS("Nenhuma filial configurada para enviar SMS.");
            }
            return false;
        }
        return true;
    }

    public boolean isParar() {
        return this.parar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean verificaFiliaisConfiguradas() {
        Statement st = ConexaoSMS.getStatement();
        boolean ret = false;
        try {
            StringBuilder buf = new StringBuilder();
            buf.append(" select fil_codigo ");
            buf.append("   from filiais_postocoleta ");
            buf.append("  where fil_enviarsms ");
            ResultSet rs = ConexaoSMS.executeQuery(st, buf.toString());
            ret = rs.next();
            rs.close();
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
        }
        finally {
            ConexaoSMS.fecharStatement(st);
        }
        return ret;
    }

    private void removeLogsAntigos() throws Exception {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new java.util.Date());
        calendar.set(5, calendar.get(5) - 10);
        this.prstRemoveLogs.setInt(1, Integer.parseInt(Variaveis.filialPadrao));
        this.prstRemoveLogs.setTimestamp(2, new Timestamp(calendar.getTime().getTime()));
        int qtde = this.prstRemoveLogs.executeUpdate();
        if (qtde == 0) {
            ConexaoSMS.anulaSQL();
        } else {
            ConexaoSMS.arquivaSQL();
        }
    }

    @Override
    public void valorSinalRecebido(int valorSinal) {
        Laboratorio.setHintEnvioSMS("Sinal: " + String.valueOf(valorSinal));
        if (this.exportacaoMonitor != null) {
            this.exportacaoMonitor.setValorSinal(valorSinal);
        }
    }

    @Override
    public ExportacaoMonitor getMonitorExportacao() {
        return this.exportacaoMonitor;
    }

    public SmsSender getSMSSender() {
        return this.sender;
    }

    public SmsSenderAPI getSMSSenderApi() {
        return this.senderAPI;
    }

    public boolean isSmsApi() {
        return this.portaModem.equals("API");
    }

    @Override
    public boolean podeApresentarJanelaMonitoramento() {
        return this.testaParametros(false);
    }

    private class ThreadGeraLogSMSAniversario
    extends Thread {
        private static final long TEMPO_ESPERA = 300000L;
        private HashMap<Integer, Time> mapaFiliais = new HashMap();
        private PreparedStatement prstBuscaPacientes = null;
        private PreparedStatement prstInsereDataGeracaoFilial = null;
        private boolean parar = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ThreadGeraLogSMSAniversario() {
            StringBuilder buf;
            Statement st = ConexaoSMS.getStatement();
            try {
                buf = new StringBuilder();
                buf.append(" select fil_smshoraaniversario as hora ");
                buf.append("       ,fil_codigo as filial ");
                buf.append("   from filiais_postocoleta ");
                buf.append("  where fil_smshoraaniversario is not null ");
                buf.append("    and fil_smsaniversario ");
                buf.append("    and fil_enviarsms ");
                ResultSet rs = ConexaoSMS.executeQuery(st, buf.toString());
                if (rs.next()) {
                    this.mapaFiliais.put(rs.getInt("filial"), rs.getTime("hora"));
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel iniciar thread de gera\u00e7\u00e3o de logs de SMS de anivers\u00e1rio.", e.getStackTrace());
                return;
            }
            finally {
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
            buf = new StringBuilder();
            buf.append(" select pac.pac_codigo as codigoPaciente ");
            buf.append("       ,pac.pac_celular as celularPaciente ");
            buf.append("   from paciente pac ");
            buf.append("  where pac.fil_codigo = ? ");
            buf.append("    and extract('day' from pac.pac_datanasc) = ? ");
            buf.append("    and extract('month' from pac.pac_datanasc) = ? ");
            buf.append("    and NULLIF(trim(replace(replace(replace(pac.pac_celular, ')', ''), '(', ''), '-', '')), '') is not null ");
            this.prstBuscaPacientes = ConexaoSMS.getPreparedStatement(buf.toString());
            buf.setLength(0);
            buf.append(" insert into filialsmsaniversario ");
            buf.append(" values (?, ?) ");
            this.prstInsereDataGeracaoFilial = ConexaoSMS.getPreparedStatement(buf.toString());
            this.setPriority(1);
        }

        private void setParar(boolean parar) {
            this.parar = parar;
        }

        @Override
        public void run() {
            if (this.mapaFiliais == null || this.mapaFiliais.size() == 0) {
                return;
            }
            try {
                while (!this.parar) {
                    Set<Integer> filiais = this.mapaFiliais.keySet();
                    for (Integer filial : filiais) {
                        Time horaGeracao = this.mapaFiliais.get(filial);
                        java.util.Date dataAtual = new java.util.Date();
                        Calendar horaAtual = Calendar.getInstance();
                        horaAtual.setTime(dataAtual);
                        horaAtual.set(5, 1);
                        horaAtual.set(2, 0);
                        horaAtual.set(1, 1970);
                        boolean jaExecutou = this.verificaThreadJaExecutouFilial(filial, dataAtual);
                        if (jaExecutou || horaAtual.getTime().getTime() < horaGeracao.getTime()) continue;
                        this.geraLogsAniversario(filial, dataAtual);
                    }
                    ThreadGeraLogSMSAniversario.sleep(300000L);
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel gerar logs de envio de SMS de anivers\u00e1rio.\n" + e.getMessage(), e.getStackTrace());
            }
        }

        private boolean insereDataGeracaoFilial(Integer filial, java.util.Date data) throws Exception {
            this.prstInsereDataGeracaoFilial.setInt(1, filial);
            this.prstInsereDataGeracaoFilial.setDate(2, new Date(data.getTime()));
            return this.prstInsereDataGeracaoFilial.executeUpdate() > 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void geraLogsAniversario(Integer filial, java.util.Date data) throws Exception {
            if (filial == null || data == null) {
                return;
            }
            ExportaSMS.this.exportacaoMonitor.setOperacaoAtual("Gerando logs de anivers\u00e1rio.");
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(data);
            this.prstBuscaPacientes.setInt(1, filial);
            this.prstBuscaPacientes.setInt(2, calendar.get(5));
            this.prstBuscaPacientes.setInt(3, calendar.get(2) + 1);
            try (ResultSet rs = null;){
                rs = this.prstBuscaPacientes.executeQuery();
                boolean temLogs = false;
                while (rs.next()) {
                    temLogs = true;
                    if (!SMSUtil.criaLogSmsSemDadosRequisicao(filial.toString(), rs.getString("codigoPaciente"), TipoSMS.ANIVERSARIO, ConexaoSMS.getStatement(), ConexaoSMS.getStatement())) {
                        ConexaoSMS.anulaSQL();
                        continue;
                    }
                    ConexaoSMS.arquivaSQL();
                }
                if (this.insereDataGeracaoFilial(filial, data)) {
                    ConexaoSMS.arquivaSQL();
                } else {
                    ConexaoSMS.anulaSQL();
                }
                ExportaSMS.this.exportacaoMonitor.setOperacaoAtual("Logs de anivers\u00e1rio gerados.");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean verificaThreadJaExecutouFilial(Integer filial, java.util.Date data) throws SQLException {
            Statement st = ConexaoSMS.getStatement();
            try {
                StringBuilder buf = new StringBuilder();
                buf.append(" select 1 ");
                buf.append("   from filialsmsaniversario ");
                buf.append("  where fil_codigo = ").append(filial);
                buf.append("    and fsa_data = '").append(Funcoes.formataData("yyyy-MM-dd", data)).append("' ");
                ResultSet rs = ConexaoSMS.executeQuery(st, buf.toString());
                boolean bl = rs.next();
                return bl;
            }
            finally {
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
    }

    public static enum TipoSMS {
        ANIVERSARIO("A", "Anivers\u00e1rio"),
        RESULTADO("R", "Resultado"),
        SENHA_WEB("S", "Senha Web"),
        RECOLETA("T", "Recoleta"),
        REQUISICAO("Q", "Requisi\u00e7\u00e3o"),
        FINANCEIRO("F", "Resumo Financeiro"),
        AGENDAMENTO("D", "Agendamento"),
        AVISO_AGENDAMENTO("V", "Aviso de agendamento");

        String codigo = null;
        String descricao = null;

        private TipoSMS(String codigo, String descricao) {
            this.codigo = codigo;
            this.descricao = descricao;
        }

        public static String[] getTipos() {
            String[] lista = new String[TipoSMS.values().length];
            for (int i = 0; i < TipoSMS.values().length; ++i) {
                lista[i] = TipoSMS.values()[i].descricao;
            }
            return lista;
        }

        public static TipoSMS get(String descricao) {
            if (descricao == null) {
                return null;
            }
            for (TipoSMS tipo : TipoSMS.values()) {
                if (!(descricao.length() > 1 ? tipo.descricao.equalsIgnoreCase(descricao) : tipo.codigo.equalsIgnoreCase(descricao))) continue;
                return tipo;
            }
            return null;
        }

        public String getDescricao() {
            return this.descricao;
        }

        public String getCodigo() {
            return this.codigo;
        }
    }

    public static enum SituacaoSMS {
        TIPO_SMS_SITUACAO_ENVIAR("E", "Enviar"),
        TIPO_SMS_SITUACAO_ENVIANDO("F", "Enviando"),
        TIPO_SMS_SITUACAO_ENVIADO("O", "Enviado"),
        TIPO_SMS_SITUACAO_CONFIRMADA("C", "Confirmado"),
        TIPO_SMS_SITUACAO_ERRO("R", "Erro");

        String codigo = null;
        String descricao = null;

        private SituacaoSMS(String codigo, String descricao) {
            this.codigo = codigo;
            this.descricao = descricao;
        }

        public static String[] getTipos() {
            String[] lista = new String[SituacaoSMS.values().length];
            for (int i = 0; i < SituacaoSMS.values().length; ++i) {
                lista[i] = SituacaoSMS.values()[i].descricao;
            }
            return lista;
        }

        public static SituacaoSMS get(String descricao) {
            if (descricao == null) {
                return null;
            }
            for (SituacaoSMS tipo : SituacaoSMS.values()) {
                if (!(descricao.length() > 1 ? tipo.descricao.equalsIgnoreCase(descricao) : tipo.codigo.equalsIgnoreCase(descricao))) continue;
                return tipo;
            }
            return null;
        }

        public String getDescricao() {
            return this.descricao;
        }

        public String getCodigo() {
            return this.codigo;
        }
    }
}

