/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.exportacao.thread;

import jalis.comum.ConexaoEmail;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.exportacao.util.ExportacaoMonitor;
import jalis.laboratorio.exportacao.util.ExportacaoMonitorListener;
import jalis.laboratorio.util.EmailUtil;
import jalis.mensagens.VerificaMensagens;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Set;
import javax.swing.ImageIcon;
import org.postgresql.PGConnection;
import org.postgresql.largeobject.LargeObject;
import org.postgresql.largeobject.LargeObjectManager;

public class ExportaEmail
extends Thread
implements ExportacaoMonitorListener {
    public static final ImageIcon ICONE_ENVIANDO_E_MAIL_OFF = ImagemUtils.carregaImagemJalis("enviando_email_off.jpg");
    public static final ImageIcon ICONE_ENVIANDO_E_MAIL_ON = ImagemUtils.carregaImagemJalis("enviando_email_on.jpg");
    public static final ImageIcon ICONE_ENVIANDO_E_MAIL_ERRO = ImagemUtils.carregaImagemJalis("enviando_email_erro.jpg");
    private static final long TEMPO_ENTRE_ENVIOS = 1000L;
    private static final long TEMPO_ESPERA = 60000L;
    private static final int QUANTIDADE_DIAS_ARMAZENAR_LOGS = 5;
    private boolean isExecutar = true;
    private boolean isEnviandoEmail = false;
    private PreparedStatement prstLogs = null;
    private PreparedStatement prstQtdeEmail = null;
    private String xmlConfiguracaoEnvio = null;
    ThreadGeraLogEmailAniversario threadAniversario = null;
    ThreadGeraLogEmailResultadoAtrasado threadResultadoAtrasado = null;
    private ExportacaoMonitor monitor = new ExportacaoMonitor();
    private java.util.Date tempoIteracaoAnterior = null;
    private long mediaTempoIteracoes = 0L;
    private int qtdeParaEnviar = 0;
    private int iteracaoAtual = 0;

    public ExportaEmail() {
        super("Thread Exporta E-mail");
        this.setPriority(1);
        Laboratorio.setIconeEnvioEmail(ICONE_ENVIANDO_E_MAIL_OFF);
        this.iniciaThreadLogEmailAniversario();
        this.iniciaThreadLogEmailResultadoAtrasado();
        StringBuilder buf = new StringBuilder();
        buf.append(" select fil_codigo as codigoFilial ");
        buf.append("       ,ema_codigo as codigoLog ");
        buf.append("       ,ema_datahora as dataHora ");
        buf.append("       ,ema_situacao as situacao ");
        buf.append("       ,ema_email as enderecoEmail ");
        buf.append("       ,ema_mensagem as mensagemEmail ");
        buf.append("       ,ema_assunto as assuntoEmail ");
        buf.append("       ,ema_anexo as pdf ");
        buf.append("       ,ema_extensao as extensao ");
        buf.append("   from logemail ");
        buf.append("  where upper(ema_situacao) like upper(?) ");
        buf.append("  order by ema_datahora ");
        buf.append("          ,fil_codigo ");
        buf.append("          ,ema_codigo ");
        this.prstLogs = ConexaoEmail.getPreparedStatement(buf.toString());
        buf.setLength(0);
        buf.append(" select count(*) as contagem from logemail where ema_situacao = ?");
        this.prstQtdeEmail = ConexaoEmail.getPreparedStatement(buf.toString());
        this.monitor.addExportacaoListener(Laboratorio.getJanelaMonitoramentoExportacaoEmail());
    }

    private String getXMLConfiguracaoEnvio(Integer codigoFilial) {
        StringBuilder buf = new StringBuilder();
        buf.append(" select fil_configuracaoemail as xml ");
        buf.append("   from filiais_postocoleta ");
        buf.append("  where fil_codigo = ").append(codigoFilial);
        buf.append("    and fil_enviaremail ");
        try {
            ResultSet rs = ConexaoEmail.executeQuery(ConexaoEmail.getStatement(), buf.toString());
            if (rs.next()) {
                return rs.getString("xml");
            }
            return null;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel buscar o XML de envio de e-mail.\n" + e.getMessage(), e.getStackTrace());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (!this.haFilialConfiguradaEnvioEmail()) {
            this.setSituacaoEstacao(ICONE_ENVIANDO_E_MAIL_ERRO, "Nenhuma filial configurada para envio de e-mail.");
            this.monitor.setOperacaoAtual("Nenhuma filial configurada para envio de e-mail.");
            return;
        }
        while (this.isExecutar) {
            try {
                this.isEnviandoEmail = true;
                this.setSituacaoEstacao(ICONE_ENVIANDO_E_MAIL_ON, "Enviando e-mails");
                this.prstLogs.setString(1, "E");
                try (ResultSet rs = null;){
                    rs = this.prstLogs.executeQuery();
                    this.prstQtdeEmail.setString(1, "E");
                    try (ResultSet rsQt = null;){
                        rsQt = this.prstQtdeEmail.executeQuery();
                        if (rsQt.next()) {
                            this.qtdeParaEnviar = rsQt.getInt("contagem");
                        }
                    }
                    this.iteracaoAtual = 0;
                    this.mediaTempoIteracoes = 0L;
                    this.tempoIteracaoAnterior = null;
                    this.monitor.setQuantidadeParaEnviar(this.qtdeParaEnviar);
                    while (rs.next()) {
                        byte[] pdf = null;
                        if (rs.getLong("pdf") > 0L) {
                            long oid = rs.getLong("pdf");
                            LargeObjectManager lobj = ((PGConnection)this.prstLogs.getConnection()).getLargeObjectAPI();
                            LargeObject obj = lobj.open(oid, 262144);
                            pdf = new byte[obj.size()];
                            obj.read(pdf, 0, obj.size());
                            obj.close();
                        }
                        ++this.iteracaoAtual;
                        this.monitor.setOperacaoAtual("Enviando e-mail: " + rs.getString("enderecoEmail"));
                        String configuracaoEnvio = this.getXMLConfiguracaoEnvio(rs.getInt("codigoFilial"));
                        if (Funcoes.textoVazio(configuracaoEnvio)) {
                            this.monitor.setOperacaoAtual("A filial " + rs.getInt("codigoFilial") + " n\u00e3o est\u00e1 configurada para envio de e-mail.");
                            this.monitor.setLogAtual(this.iteracaoAtual);
                            continue;
                        }
                        if (!EmailUtil.enviaEmail(configuracaoEnvio, rs.getString("enderecoEmail"), rs.getString("mensagemEmail"), rs.getString("assuntoEmail"), pdf, rs.getInt("codigoFilial"), rs.getInt("codigoLog"), rs.getString("extensao"))) continue;
                        EmailUtil.atualizaLog(rs.getInt("codigoFilial"), rs.getInt("codigoLog"), "O", ConexaoEmail.getStatement());
                        this.atualizaTempoEntreIteracoes();
                        this.monitor.setOperacaoAtual("E-mail enviado com sucesso.");
                        this.monitor.setLogAtual(this.iteracaoAtual);
                        ExportaEmail.sleep(1000L);
                    }
                    this.setSituacaoEstacao(ICONE_ENVIANDO_E_MAIL_OFF, null);
                    this.monitor.setQuantidadeParaEnviar(0);
                    this.monitor.setLogAtual(0);
                    this.monitor.setTempoEntreIteracoes(0L);
                    this.monitor.setTempoProximaIteracao(60000L);
                    this.isEnviandoEmail = false;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.setSituacaoEstacao(ICONE_ENVIANDO_E_MAIL_ERRO, "N\u00e3o foi poss\u00edvel enviar e-mail.\n" + e.getMessage());
                VerificaMensagens.mostraErro(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel enviar e-mail: " + e.getMessage());
            }
            try {
                Thread.sleep(60000L);
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean haFilialConfiguradaEnvioEmail() {
        StringBuilder buf = new StringBuilder();
        buf.append(" select count(1) as qtde ");
        buf.append("   from filiais_postocoleta ");
        buf.append("  where fil_enviaremail ");
        buf.append("    and NULLIF(TRIM(fil_configuracaoemail), '') IS NOT NULL ");
        Statement st = ConexaoEmail.getStatement();
        try {
            ResultSet rs = ConexaoEmail.executeQuery(st, buf.toString());
            if (rs.next()) {
                boolean bl = rs.getInt("qtde") > 0;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel verificar se h\u00e1 filiais configuradas para enviar e-mail.\n" + e.getMessage(), e.getStackTrace());
            boolean bl = false;
            return bl;
        }
        finally {
            if (st != null) {
                ConexaoEmail.fecharStatement(st);
            }
        }
    }

    private void setSituacaoEstacao(ImageIcon icone, String mensagem) {
        Laboratorio.setIconeEnvioEmail(icone);
        Laboratorio.setHintEnvioEmail(mensagem);
    }

    public void parar() {
        this.isExecutar = false;
        this.paraThreadLogEmailAniversario();
        this.paraThreadLogEmailResultadoAtrasado();
    }

    public boolean isEnviandoEmail() {
        return this.isEnviandoEmail;
    }

    public boolean isParar() {
        return !this.isExecutar;
    }

    private void iniciaThreadLogEmailAniversario() {
        this.threadAniversario = new ThreadGeraLogEmailAniversario();
        this.threadAniversario.start();
    }

    private void iniciaThreadLogEmailResultadoAtrasado() {
        this.threadResultadoAtrasado = new ThreadGeraLogEmailResultadoAtrasado();
        this.threadResultadoAtrasado.start();
    }

    private void paraThreadLogEmailAniversario() {
        if (this.threadAniversario != null) {
            this.threadAniversario.setParar(true);
        }
    }

    private void paraThreadLogEmailResultadoAtrasado() {
        if (this.threadResultadoAtrasado != null) {
            this.threadResultadoAtrasado.setParar(true);
        }
    }

    @Override
    public ExportacaoMonitor getMonitorExportacao() {
        return this.monitor;
    }

    @Override
    public boolean podeApresentarJanelaMonitoramento() {
        return this.isExecutar;
    }

    private void atualizaTempoEntreIteracoes() {
        if (this.tempoIteracaoAnterior != null) {
            Calendar calAnterior = Calendar.getInstance();
            calAnterior.setTime(this.tempoIteracaoAnterior);
            Calendar calAtual = Calendar.getInstance();
            calAtual.setTime(new java.util.Date());
            long qtde = calAtual.getTimeInMillis() - calAnterior.getTimeInMillis();
            this.mediaTempoIteracoes = (this.mediaTempoIteracoes + qtde) / 2L;
            this.monitor.setTempoEntreIteracoes(this.mediaTempoIteracoes + (long)(this.qtdeParaEnviar - this.iteracaoAtual) * 1000L);
            this.tempoIteracaoAnterior = calAtual.getTime();
        } else {
            this.tempoIteracaoAnterior = new java.util.Date();
        }
    }

    private class ThreadGeraLogEmailAniversario
    extends Thread {
        private static final long TEMPO_ESPERA = 300000L;
        private HashMap<Integer, Time> mapaFiliais = null;
        private PreparedStatement prstBuscaPacientes = null;
        private PreparedStatement prstInsereDataGeracaoFilial = null;
        private boolean parar = false;
        private ArrayList<String> chaves = new ArrayList();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ThreadGeraLogEmailAniversario() {
            StringBuilder buf;
            this.mapaFiliais = new HashMap();
            Statement st = ConexaoEmail.getStatement();
            try {
                buf = new StringBuilder();
                buf.append(" select fil_emailhoraaniversario as hora ");
                buf.append("       ,fil_codigo as filial ");
                buf.append("   from filiais_postocoleta ");
                buf.append("  where fil_emailhoraaniversario is not null ");
                buf.append("    and fil_emailaniversario ");
                ResultSet rs = ConexaoEmail.executeQuery(st, buf.toString());
                while (rs.next()) {
                    this.mapaFiliais.put(rs.getInt("filial"), rs.getTime("hora"));
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel iniciar thread de gera\u00e7\u00e3o de logs de e-mail de anivers\u00e1rio.", e.getStackTrace());
                return;
            }
            finally {
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
            buf = new StringBuilder();
            buf.append(" select pac_codigo as codigoPaciente ");
            buf.append("       ,pac_email as emailPaciente ");
            buf.append("       ,pac_datanasc as dataNascPaciente ");
            buf.append("       ,pac_nome as nomePaciente ");
            buf.append("   from paciente ");
            buf.append("  where fil_codigo = ? ");
            buf.append("    and extract('day' from pac_datanasc) = ? ");
            buf.append("    and extract('month' from pac_datanasc) = ? ");
            buf.append("    and NULLIF(trim(pac_email), '') is not null ");
            this.prstBuscaPacientes = ConexaoEmail.getPreparedStatement(buf.toString());
            buf.setLength(0);
            buf.append(" insert into filialemailaniversario ");
            buf.append(" values (?, ?) ");
            this.prstInsereDataGeracaoFilial = ConexaoEmail.getPreparedStatement(buf.toString());
            this.setPriority(1);
        }

        private void setParar(boolean parar) {
            this.parar = parar;
        }

        @Override
        public void run() {
            if (this.mapaFiliais == null || this.mapaFiliais.size() == 0) {
                this.chaves.clear();
                return;
            }
            try {
                ExportaEmail.this.monitor.setOperacaoAtual("Criando logs de e-mail de anivers\u00e1rio.");
                while (!this.parar) {
                    Set<Integer> filiais = this.mapaFiliais.keySet();
                    for (Integer filial : filiais) {
                        Time horaGeracao = this.mapaFiliais.get(filial);
                        java.util.Date dataAtual = new java.util.Date();
                        Calendar horaAtual = Calendar.getInstance();
                        horaAtual.setTime(dataAtual);
                        horaAtual.set(5, 1);
                        horaAtual.set(2, 0);
                        horaAtual.set(1, 1970);
                        if (this.verificaThreadJaExecutouFilial(filial, dataAtual) || horaAtual.getTime().getTime() < horaGeracao.getTime()) continue;
                        this.geraLogsAniversario(filial, dataAtual);
                    }
                    this.chaves.clear();
                    ThreadGeraLogEmailAniversario.sleep(300000L);
                }
                ExportaEmail.this.monitor.setOperacaoAtual("Logs de e-mail de anivers\u00e1rio criados.");
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel gerar logs de envio de e-mail de anivers\u00e1rio.\n" + e.getMessage(), e.getStackTrace());
            }
        }

        private boolean insereDataGeracaoFilial(Integer filial, java.util.Date data) throws Exception {
            this.prstInsereDataGeracaoFilial.setInt(1, filial);
            this.prstInsereDataGeracaoFilial.setDate(2, new Date(data.getTime()));
            return this.prstInsereDataGeracaoFilial.executeUpdate() > 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void geraLogsAniversario(Integer filial, java.util.Date data) throws Exception {
            if (filial == null || data == null) {
                return;
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(data);
            this.prstBuscaPacientes.setInt(1, filial);
            this.prstBuscaPacientes.setInt(2, calendar.get(5));
            this.prstBuscaPacientes.setInt(3, calendar.get(2) + 1);
            boolean temLogs = false;
            try (ResultSet rs = null;){
                rs = this.prstBuscaPacientes.executeQuery();
                while (rs.next()) {
                    temLogs = true;
                    StringBuilder chave = new StringBuilder();
                    chave.append(rs.getString("codigoPaciente"));
                    chave.append(rs.getString("emailPaciente"));
                    chave.append(rs.getString("dataNascPaciente"));
                    chave.append(rs.getString("nomePaciente"));
                    if (this.chaves.contains(chave.toString())) continue;
                    if (!EmailUtil.criaLogEmailSemDadosRequisicao(filial.toString(), rs.getString("codigoPaciente"), rs.getString("emailPaciente"), null, EmailUtil.TipoEmail.ANIVERSARIO, false, ConexaoEmail.getStatement(), false)) {
                        ConexaoEmail.anulaSQL();
                        return;
                    }
                    this.chaves.add(chave.toString());
                }
                if (this.insereDataGeracaoFilial(filial, data)) {
                    ConexaoEmail.arquivaSQL();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean verificaThreadJaExecutouFilial(Integer filial, java.util.Date data) throws SQLException {
            Statement st = ConexaoEmail.getStatement();
            try {
                StringBuilder buf = new StringBuilder();
                buf.append(" select 1 ");
                buf.append("   from filialemailaniversario ");
                buf.append("  where fil_codigo = ").append(filial);
                buf.append("    and fea_data = '").append(Funcoes.formataData("yyyy-MM-dd", data)).append("' ");
                ResultSet rs = ConexaoEmail.executeQuery(st, buf.toString());
                boolean bl = rs.next();
                return bl;
            }
            finally {
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
    }

    private class ExamesAvisados {
        String codigoExame;
        String material;

        public ExamesAvisados(String codigoExame, String codigoMaterial) {
            this.codigoExame = codigoExame;
            this.material = codigoMaterial;
        }

        public String getCodigoExame() {
            return this.codigoExame;
        }

        public String getMaterial() {
            return this.material;
        }
    }

    private class ThreadGeraLogEmailResultadoAtrasado
    extends Thread {
        private static final long TEMPO_ESPERA = 60000L;
        private HashMap<Integer, Boolean> mapaFiliais = new HashMap();
        private PreparedStatement prstBuscaAtrasados = null;
        private PreparedStatement prstInsereDataGeracaoFilial = null;
        private boolean parar = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ThreadGeraLogEmailResultadoAtrasado() {
            StringBuilder buf;
            Statement st = ConexaoEmail.getStatement();
            try {
                buf = new StringBuilder();
                buf.append(" select fil_codigo as filial ");
                buf.append("   from filiais_postocoleta ");
                buf.append("  where fil_emailentrega ");
                ResultSet rs = ConexaoEmail.executeQuery(st, buf.toString());
                if (rs.next()) {
                    this.mapaFiliais.put(rs.getInt("filial"), Boolean.TRUE);
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel iniciar thread de gera\u00e7\u00e3o de logs de atraso de resultados.", e.getStackTrace());
                return;
            }
            finally {
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
            buf = new StringBuilder();
            buf.append(" select a.req_codigo as codigoRequisicao ");
            buf.append("       ,a.pac_codigo as codigoPaciente ");
            buf.append("       ,a.fil_codigo as codigoFilial ");
            buf.append("       ,b.pac_email as emailPaciente ");
            buf.append("       ,a.req_dataentregaprev as dataEntregaRequisicao ");
            buf.append("       ,a.req_horaentregaprev as horaEntregaRequisicao ");
            buf.append("       ,a.req_imprimirseparado as imprimirSeparadoRequisicao ");
            buf.append("       ,a.req_emailatrasoenviado is not null as emailEnviado ");
            buf.append("   from requisicao a ");
            buf.append("  left join paciente b on a.fil_codigo = b.fil_codigo and a.pac_codigo = b.pac_codigo ");
            buf.append("  where a.fil_codigo = ? ");
            buf.append("    and a.req_dataentregaprev is not null ");
            buf.append("    and cast(a.req_dataentregaprev || ' ' || a.req_horaentregaprev as timestamp) < current_timestamp ");
            buf.append("    and cast(a.req_dataentregaprev || ' ' || a.req_horaentregaprev as timestamp) >= ? ");
            buf.append("    and a.req_excluida = false ");
            this.prstBuscaAtrasados = ConexaoEmail.getPreparedStatement(buf.toString());
            buf.setLength(0);
            buf.append(" insert into filialemailaniversario ");
            buf.append(" values (?, ?) ");
            this.prstInsereDataGeracaoFilial = ConexaoEmail.getPreparedStatement(buf.toString());
            this.setPriority(1);
        }

        public void setParar(boolean p) {
            this.parar = p;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.mapaFiliais == null || this.mapaFiliais.size() == 0) {
                return;
            }
            try {
                ExportaEmail.this.monitor.setOperacaoAtual("Criando logs de e-mail de resultado atrasado.");
                while (!this.parar) {
                    Set<Integer> filiais = this.mapaFiliais.keySet();
                    for (Integer filial : filiais) {
                        java.util.Date dataAtual = new java.util.Date();
                        Calendar horaAtual = Calendar.getInstance();
                        horaAtual.setTime(dataAtual);
                        horaAtual.add(10, -1);
                        this.prstBuscaAtrasados.setInt(1, filial);
                        this.prstBuscaAtrasados.setTimestamp(2, new Timestamp(horaAtual.getTimeInMillis()));
                        ResultSet rs = null;
                        try {
                            rs = this.prstBuscaAtrasados.executeQuery();
                            while (rs.next()) {
                                Statement st;
                                ArrayList<ExamesAvisados> enviado;
                                if (rs.getBoolean("emailEnviado") || (enviado = this.possuiExamesSemResultado(st = ConexaoEmail.getStatement(), rs.getString("codigoFilial"), rs.getString("codigoRequisicao"))) == null || enviado.size() <= 0) continue;
                                this.geraLogResultadoAtrasado(rs.getInt("codigoFilial"), rs.getString("codigoRequisicao"), rs.getString("codigoPaciente"), rs.getString("emailPaciente"));
                                this.atualizaRequisicaoComoEnviado(st, rs.getString("codigoFilial"), rs.getString("codigoRequisicao"));
                                for (ExamesAvisados exm : enviado) {
                                    this.gravaLogExameEmailEnviado(st, rs.getString("codigoFilial"), rs.getString("codigoRequisicao"), exm.codigoExame, exm.material);
                                }
                            }
                            ConexaoEmail.arquivaSQL();
                        }
                        finally {
                            if (rs == null) continue;
                            rs.close();
                        }
                    }
                    ThreadGeraLogEmailResultadoAtrasado.sleep(60000L);
                }
                ExportaEmail.this.monitor.setOperacaoAtual("Logs de e-mail de anivers\u00e1rio criados.");
            }
            catch (Exception e) {
                try {
                    ConexaoEmail.anulaSQL();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel gerar logs de envio de e-mail de resultado atrasado.\n" + e.getMessage(), e.getStackTrace());
            }
        }

        private void atualizaRequisicaoComoEnviado(Statement st, String codigoFilial, String codigoRequisicao) throws SQLException {
            StringBuilder buf = new StringBuilder();
            buf.append("update requisicao set req_emailatrasoenviado = current_timestamp ");
            buf.append(" where fil_codigo = ").append(codigoFilial);
            buf.append("   and req_codigo = ").append(codigoRequisicao);
            st.executeUpdate(buf.toString());
        }

        private void gravaLogExameEmailEnviado(Statement st, String codigoFilial, String codigoRequisicao, String codigoExame, String codigoMaterial) throws SQLException {
            StringBuilder buf = new StringBuilder();
            buf.append("insert into examerequisicaoemailatraso(fil_codigo, req_codigo, exa_codigo, mco_codigo, rea_datahora) values (");
            buf.append(codigoFilial).append(", ");
            buf.append(codigoRequisicao).append(", ");
            buf.append(StringUtil.textoDBEscape(codigoExame)).append(", ");
            buf.append(codigoMaterial).append(", ");
            buf.append("current_timestamp)");
            st.executeUpdate(buf.toString());
        }

        private void geraLogResultadoAtrasado(Integer filial, String requisicao, String codigoPaciente, String emailPaciente) throws Exception {
            if (filial == null || requisicao == null || codigoPaciente == null || emailPaciente == null) {
                return;
            }
            if (!EmailUtil.criaLogEmail(filial.toString(), requisicao, null, EmailUtil.TipoEmail.ATRASO_ENTREGA, false, ConexaoEmail.getStatement())) {
                ConexaoEmail.anulaSQL();
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ArrayList<ExamesAvisados> possuiExamesSemResultado(Statement st, String filial, String requisicao) throws SQLException {
            ArrayList<ExamesAvisados> retorno = null;
            StringBuilder buf = new StringBuilder("select exa_codigo, mco_codigo, exr_situacao from examerequisicao ");
            buf.append(" where fil_codigo = ").append(filial);
            buf.append("   and req_codigo = ").append(requisicao);
            buf.append("   and exr_excluido = false ");
            try (ResultSet rs = null;){
                rs = st.executeQuery(buf.toString());
                while (rs.next()) {
                    String situacao = rs.getString("exr_situacao");
                    if (Funcoes.textoVazio(situacao)) continue;
                    if (retorno == null) {
                        retorno = new ArrayList<ExamesAvisados>();
                    }
                    retorno.add(new ExamesAvisados(rs.getString("exa_codigo"), rs.getString("mco_codigo")));
                }
            }
            return retorno;
        }
    }
}

