/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.exportacao.operadora.vtrp;

import jalis.comum.Conexao;
import jalis.integracaooperadoras.sistemas.FabricaIntegracaoOperadora;
import jalis.integracaooperadoras.sistemas.unimed.vtrp.IntegracaoOperadoraUnimedVTRP;
import jalis.integracaooperadoras.sistemas.util.LogIntegracaoOperadora;
import jalis.laboratorio.exportacao.integracao.IntegracaoException;
import jalis.laboratorio.exportacao.operadora.ConsultaIntegracaoOperadoraDao;
import jalis.laboratorio.exportacao.operadora.util.Filtros;
import jalis.laboratorio.exportacao.operadora.util.IntervaloData;
import jalis.util.Funcoes;
import jalis.util.tabela.Registro;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class ConsultaVtrpDao
extends ConsultaIntegracaoOperadoraDao {
    public IntegracaoOperadoraUnimedVTRP getIntegracaoOperadoraVTRP(String filial) throws IntegracaoException {
        Statement st = Conexao.getStatement();
        IntegracaoOperadoraUnimedVTRP integracaoOperadoraVTRP = null;
        StringBuilder buf = new StringBuilder();
        buf.append(" select fil_codigo as codigoFilial ");
        buf.append("       ,con_codigo as codigoConvenio ");
        buf.append("       ,con_tipointegracaooperadora as tipoIntegracao ");
        buf.append("       ,con_integracaooperadora as xmlConfiguracao ");
        buf.append("  from convenios ");
        buf.append(" where fil_codigo = ").append(filial);
        buf.append("   and NULLIF(TRIM(con_tipointegracaooperadora), '') IS NOT NULL ");
        buf.append("   and NULLIF(TRIM(con_integracaooperadora), '') IS NOT NULL ");
        buf.append(" order by fil_codigo, con_codigo ");
        try {
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                integracaoOperadoraVTRP = new IntegracaoOperadoraUnimedVTRP(rs.getString("xmlConfiguracao"), rs.getInt("codigoConvenio"));
            }
        }
        catch (SQLException e) {
            try {
                throw new IntegracaoException(0L, e.getMessage(), "", true);
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
        }
        Conexao.fecharStatement(st);
        return integracaoOperadoraVTRP;
    }

    public List<Registro> buscarRegistrosLog(IntervaloData intervalo, Filtros itens, boolean filtraLogsRejeitados) throws IntegracaoException {
        Statement st = Conexao.getStatement();
        ArrayList<Registro> logs = new ArrayList<Registro>();
        try {
            if (st != null) {
                ResultSet rs = Conexao.executeQuery(st, this.getSqlConsulta(intervalo, itens, FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.VTRP, filtraLogsRejeitados));
                while (rs.next()) {
                    if (rs.getDate("req_data") == null || !rs.getDate("req_data").after(Funcoes.stringToDate("01/09/2017"))) continue;
                    Registro registro = this.montaDados(rs);
                    logs.add(registro);
                }
            }
            return logs;
        }
        catch (Exception e) {
            throw new IntegracaoException(0L, e.getMessage(), "", true);
        }
    }

    public static boolean consultarExameRetificado(LogIntegracaoOperadora log) throws IntegracaoException {
        Statement st;
        block4: {
            boolean bl;
            st = Conexao.getStatement();
            StringBuilder bui = new StringBuilder();
            bui.append("select eio_retorno ");
            bui.append(" from exportaintegracaooperadora ");
            bui.append(" where ");
            bui.append(" fil_codigo = ").append(log.getCodigoFilial());
            bui.append(" and req_codigo = ").append(log.getCodigoRequisicao());
            bui.append(" and con_codigo = ").append(log.getCodigoConvenio());
            bui.append(" and pac_codigo = ").append(log.getCodigoPaciente());
            bui.append(" and exa_codigo = '").append(log.getCodigoExame()).append("' ");
            bui.append(" and mco_codigo = ").append(log.getCodigoMaterial());
            bui.append(" and mco_codigo = ").append(log.getCodigoMaterial());
            bui.append(" and eio_exportado = true ");
            bui.append(" order by eio_datahora desc limit 1");
            try {
                ResultSet rs = Conexao.executeQuery(st, bui.toString());
                if (!rs.next()) break block4;
                String retorno = rs.getString("eio_retorno");
                bl = retorno.equalsIgnoreCase("Exame desmarcado conferido");
            }
            catch (SQLException e) {
                try {
                    throw new IntegracaoException(0L, e.getMessage(), "", true);
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
            }
            Conexao.fecharStatement(st);
            return bl;
        }
        Conexao.fecharStatement(st);
        return false;
    }
}

