/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.exportacao.operadora.vtrp;

import jalis.integracaooperadoras.sistemas.AbstractIntegracaoOperadora;
import jalis.integracaooperadoras.sistemas.FabricaIntegracaoOperadora;
import jalis.integracaooperadoras.sistemas.unimed.vtrp.IntegracaoOperadoraUnimedVTRP;
import jalis.integracaooperadoras.sistemas.util.LogIntegracaoOperadora;
import jalis.laboratorio.exportacao.integracao.IntegracaoException;
import jalis.laboratorio.exportacao.operadora.ConsultaIntegracao;
import jalis.laboratorio.exportacao.operadora.RetornoOperadora;
import jalis.laboratorio.exportacao.operadora.util.Filtros;
import jalis.laboratorio.exportacao.operadora.util.IntervaloData;
import jalis.laboratorio.exportacao.operadora.vtrp.ConsultaVtrpDao;
import jalis.util.StringUtil;
import jalis.util.tabela.Registro;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ConsultaIntegracaoVtrp
implements ConsultaIntegracao {
    ConsultaVtrpDao dao = new ConsultaVtrpDao();

    @Override
    public int consultarLogsHaEnviar() throws IntegracaoException {
        return this.dao.consultarLogsHaEnviar(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.VTRP);
    }

    @Override
    public RetornoOperadora reenviarLog(LogIntegracaoOperadora log) throws IntegracaoException {
        IntegracaoOperadoraUnimedVTRP integracaoOperadoraVTRP = this.dao.getIntegracaoOperadoraVTRP(String.valueOf(log.getCodigoFilial()));
        HashMap<String, ArrayList<LogIntegracaoOperadora>> mapRequisicoes = new HashMap<String, ArrayList<LogIntegracaoOperadora>>();
        if (log.getTipoOperacao() == AbstractIntegracaoOperadora.TipoOperacaoIntegracaoOperadora.ENVIO_RESULTADO) {
            try {
                String reqCodigo = StringUtil.getValor(log.getXmlLog(), "codreq");
                if (mapRequisicoes.containsKey(reqCodigo)) {
                    ((ArrayList)mapRequisicoes.get(reqCodigo)).add(log);
                } else {
                    ArrayList<LogIntegracaoOperadora> logsIntegracao = new ArrayList<LogIntegracaoOperadora>();
                    logsIntegracao.add(log);
                    mapRequisicoes.put(reqCodigo, logsIntegracao);
                }
                integracaoOperadoraVTRP.reenviarResultado(mapRequisicoes, log);
            }
            catch (Exception e) {
                throw new IntegracaoException(0L, e.getMessage(), "", true);
            }
        }
        return new RetornoOperadora("", "", "");
    }

    @Override
    public List<Registro> buscarRegistros(IntervaloData intervalo, Filtros itens, boolean filtraLogsRejeitados) throws IntegracaoException {
        return this.dao.buscarRegistrosLog(intervalo, itens, filtraLogsRejeitados);
    }

    @Override
    public void teste() {
    }
}

