/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.exportacao.operadora.valedossinos;

import jalis.comum.Conexao;
import jalis.integracaooperadoras.sistemas.FabricaIntegracaoOperadora;
import jalis.integracaooperadoras.sistemas.unimed.sinos.ValeDosSinosService;
import jalis.integracaooperadoras.sistemas.util.LogIntegracaoOperadora;
import jalis.laboratorio.exportacao.integracao.IntegracaoException;
import jalis.laboratorio.exportacao.operadora.ConsultaIntegracao;
import jalis.laboratorio.exportacao.operadora.RetornoOperadora;
import jalis.laboratorio.exportacao.operadora.util.Filtros;
import jalis.laboratorio.exportacao.operadora.util.IntervaloData;
import jalis.laboratorio.exportacao.operadora.valedossinos.ConsultaValeDosSinosDao;
import jalis.util.tabela.Registro;
import java.sql.SQLException;
import java.util.List;

public class ConsultaIntegracaoValeDosSinos
implements ConsultaIntegracao {
    private ConsultaValeDosSinosDao dao = new ConsultaValeDosSinosDao();
    private ValeDosSinosService service = new ValeDosSinosService();

    @Override
    public int consultarLogsHaEnviar() throws IntegracaoException {
        return this.dao.consultarLogsHaEnviar(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.SINOS);
    }

    @Override
    public RetornoOperadora reenviarLog(LogIntegracaoOperadora log) throws IntegracaoException {
        try {
            this.dao.atualizarLogCorrigidoParaExportar(log);
            Conexao.arquivaSQL();
        }
        catch (SQLException e) {
            this.rollback(log);
            throw new IntegracaoException(log.getCodigoLog(), e.getMessage(), "", true);
        }
        return new RetornoOperadora("", "", "");
    }

    private void rollback(LogIntegracaoOperadora log) throws IntegracaoException {
        try {
            Conexao.anulaSQL();
        }
        catch (SQLException e) {
            throw new IntegracaoException(log.getCodigoLog(), e.getMessage(), "", true);
        }
    }

    @Override
    public List<Registro> buscarRegistros(IntervaloData intervalo, Filtros itens, boolean filtraLogsRejeitados) throws IntegracaoException {
        try {
            return this.dao.buscarRegistrosLog(intervalo, itens, filtraLogsRejeitados);
        }
        catch (SQLException e) {
            throw new IntegracaoException(-1L, e.getMessage(), "", true);
        }
    }

    @Override
    public void teste() {
        try {
            this.service.testeLog();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

