/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.exportacao.operadora.upy;

import jalis.integracaooperadoras.sistemas.FabricaIntegracaoOperadora;
import jalis.integracaooperadoras.sistemas.upy.IntegracaoOperadoraUpy;
import jalis.integracaooperadoras.sistemas.util.DadosErrosIntegracaoOperadora;
import jalis.integracaooperadoras.sistemas.util.IntegracaoOperadoraException;
import jalis.integracaooperadoras.sistemas.util.LogIntegracaoOperadora;
import jalis.laboratorio.exportacao.integracao.IntegracaoException;
import jalis.laboratorio.exportacao.operadora.ConsultaIntegracao;
import jalis.laboratorio.exportacao.operadora.RetornoOperadora;
import jalis.laboratorio.exportacao.operadora.upy.ConsultaUpyDao;
import jalis.laboratorio.exportacao.operadora.util.Filtros;
import jalis.laboratorio.exportacao.operadora.util.IntervaloData;
import jalis.util.tabela.Registro;
import java.util.List;
import org.apache.axis.message.MessageElement;

public class ConsultaIntegracaoUpy
implements ConsultaIntegracao {
    private ConsultaUpyDao dao = new ConsultaUpyDao();

    @Override
    public int consultarLogsHaEnviar() throws IntegracaoException {
        return this.dao.consultarLogsHaEnviar(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.UPY);
    }

    @Override
    public RetornoOperadora reenviarLog(LogIntegracaoOperadora log) throws IntegracaoException {
        String situacao = "";
        String retorno = "";
        DadosErrosIntegracaoOperadora erros = null;
        IntegracaoOperadoraUpy integracaoOperadoraUpy = this.dao.getIntegracaoOperadoraUpy();
        erros = integracaoOperadoraUpy.integrarOperadoraReenviar(log);
        if (erros.haErros()) {
            if (erros.getErrosEnvioResultado().size() > 0) {
                for (IntegracaoOperadoraException erro : erros.getErrosEnvioResultado()) {
                    retorno = erro.getMensagemErro();
                    situacao = "N";
                }
            }
            if (erros.getErrosLogin().size() > 0) {
                for (IntegracaoOperadoraException erro : erros.getErrosLogin()) {
                    retorno = erro.getMensagemErro();
                    situacao = "N";
                }
            }
            if (erros.getErrosProcesso().size() > 0) {
                for (IntegracaoOperadoraException erro : erros.getErrosProcesso()) {
                    retorno = erro.getMensagemErro();
                    situacao = "N";
                }
            }
        }
        String xml = this.buscarXMLRetorno(integracaoOperadoraUpy);
        return new RetornoOperadora(retorno, xml, situacao);
    }

    private String buscarXMLRetorno(IntegracaoOperadoraUpy integracaoOperadoraUpy) throws IntegracaoException {
        if (integracaoOperadoraUpy.getRetornoSolicitacao() != null) {
            return this.getXmlEnvio(integracaoOperadoraUpy.getRetornoSolicitacao().getRESULTADOSEXAMES().get_any());
        }
        if (integracaoOperadoraUpy.getRetornoEnvioResultado() != null) {
            return this.getXmlRetorno(integracaoOperadoraUpy.getRetornoEnvioResultado().getRESULTADOSEXAMES().get_any());
        }
        return "";
    }

    private String getXmlEnvio(MessageElement[] messageElements) throws IntegracaoException {
        String retorno = null;
        try {
            retorno = messageElements[0].getAsString();
        }
        catch (Exception e) {
            throw new IntegracaoException(0L, e.getMessage(), "", true);
        }
        return retorno;
    }

    private String getXmlRetorno(MessageElement[] messageElements) throws IntegracaoException {
        String retorno = null;
        try {
            retorno = messageElements[0].getAsString();
        }
        catch (Exception e) {
            throw new IntegracaoException(0L, e.getMessage(), "", true);
        }
        return retorno;
    }

    @Override
    public List<Registro> buscarRegistros(IntervaloData intervalo, Filtros itens, boolean filtraLogsRejeitados) throws IntegracaoException {
        return this.dao.buscarRegistroslog(intervalo, itens, filtraLogsRejeitados);
    }

    @Override
    public void teste() {
    }
}

