/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.exportacao.operadora.unimedpr;

import jalis.comum.Conexao;
import jalis.integracaooperadoras.sistemas.FabricaIntegracaoOperadora;
import jalis.integracaooperadoras.sistemas.util.LogIntegracaoOperadora;
import jalis.laboratorio.exportacao.integracao.IntegracaoException;
import jalis.laboratorio.exportacao.operadora.ConsultaIntegracao;
import jalis.laboratorio.exportacao.operadora.RetornoOperadora;
import jalis.laboratorio.exportacao.operadora.unimedpr.ConsultaUnimedPRDao;
import jalis.laboratorio.exportacao.operadora.util.Filtros;
import jalis.laboratorio.exportacao.operadora.util.IntervaloData;
import jalis.util.tabela.Registro;
import java.sql.SQLException;
import java.util.List;

public class ConsultaIntegracaoUnimedPR
implements ConsultaIntegracao {
    private ConsultaUnimedPRDao dao = new ConsultaUnimedPRDao();

    @Override
    public int consultarLogsHaEnviar() throws IntegracaoException {
        return this.dao.consultarLogsHaEnviar(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.UNIMEDPR);
    }

    @Override
    public RetornoOperadora reenviarLog(LogIntegracaoOperadora log) throws IntegracaoException {
        try {
            this.dao.marcarParaExportar(log);
            Conexao.arquivaSQL();
        }
        catch (SQLException e) {
            this.rollback(log);
            throw new IntegracaoException(log.getCodigoLog(), e.getMessage(), "", true);
        }
        return new RetornoOperadora("", "", "");
    }

    private void rollback(LogIntegracaoOperadora log) throws IntegracaoException {
        try {
            Conexao.anulaSQL();
        }
        catch (SQLException e) {
            throw new IntegracaoException(log.getCodigoLog(), e.getMessage(), "", true);
        }
    }

    @Override
    public List<Registro> buscarRegistros(IntervaloData intervalo, Filtros itens, boolean filtraLogsRejeitados) throws IntegracaoException {
        return this.dao.buscarRegistrosLog(intervalo, itens, filtraLogsRejeitados);
    }

    @Override
    public void teste() {
    }
}

