/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.exportacao.operadora.sline;

import jalis.comum.Conexao;
import jalis.integracaooperadoras.sistemas.FabricaIntegracaoOperadora;
import jalis.integracaooperadoras.sistemas.util.LogIntegracaoOperadora;
import jalis.laboratorio.exportacao.integracao.IntegracaoException;
import jalis.laboratorio.exportacao.operadora.ConsultaIntegracao;
import jalis.laboratorio.exportacao.operadora.RetornoOperadora;
import jalis.laboratorio.exportacao.operadora.sline.ConsultaSLineDao;
import jalis.laboratorio.exportacao.operadora.util.Filtros;
import jalis.laboratorio.exportacao.operadora.util.IntervaloData;
import jalis.util.tabela.Registro;
import java.sql.SQLException;
import java.util.List;

public class ConsultaIntegracaoSLine
implements ConsultaIntegracao {
    private ConsultaSLineDao dao = new ConsultaSLineDao();

    @Override
    public int consultarLogsHaEnviar() throws IntegracaoException {
        return this.dao.consultarLogsHaEnviar(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.SLINE);
    }

    @Override
    public RetornoOperadora reenviarLog(LogIntegracaoOperadora log) throws IntegracaoException {
        try {
            this.dao.marcarParaExportar(log);
            Conexao.arquivaSQL();
        }
        catch (SQLException e) {
            this.rollback(log);
            throw new IntegracaoException(log.getCodigoLog(), e.getMessage(), "", true);
        }
        return new RetornoOperadora("", "", "");
    }

    private void rollback(LogIntegracaoOperadora log) throws IntegracaoException {
        try {
            Conexao.anulaSQL();
        }
        catch (SQLException e) {
            throw new IntegracaoException(log.getCodigoLog(), e.getMessage(), "", true);
        }
    }

    @Override
    public List<Registro> buscarRegistros(IntervaloData intervalo, Filtros itens, boolean filtraLogsRejeitados) throws IntegracaoException {
        return this.dao.buscarRegistrosLog(intervalo, itens, filtraLogsRejeitados);
    }

    public void atualizarLogEditado(String codFilial, String codLog, String codRequisicao) throws Exception {
        this.dao.atualizarLogEditado(codFilial, codLog, codRequisicao);
    }

    @Override
    public void teste() {
    }
}

