/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.exportacao.operadora.simus;

import jalis.comum.Conexao;
import jalis.integracaooperadoras.sistemas.FabricaIntegracaoOperadora;
import jalis.integracaooperadoras.sistemas.util.LogIntegracaoOperadora;
import jalis.laboratorio.exportacao.integracao.IntegracaoException;
import jalis.laboratorio.exportacao.operadora.ConsultaIntegracaoOperadoraDao;
import jalis.laboratorio.exportacao.operadora.util.Filtros;
import jalis.laboratorio.exportacao.operadora.util.IntervaloData;
import jalis.util.tabela.Registro;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ConsultaSIMUSDao
extends ConsultaIntegracaoOperadoraDao {
    public void criarNovoLog(LogIntegracaoOperadora log) throws SQLException {
        Integer filial = log.getCodigoFilial();
        PreparedStatement pr = Conexao.getPreparedStatement("insert into exportaintegracaooperadora (fil_codigo, con_codigo, eio_codigo, eio_datahora, eio_operacao, eio_tipooperacao, eio_exportado, req_codigo, pac_codigo, exa_codigo, mco_codigo, eio_situacao) values(?, ?, nextval('exportaintegracaooperadora_" + filial + "_sequence') , ?, ?, ?, ?, ?, ?, ?, ?, ?);");
        pr.setInt(1, filial);
        pr.setInt(2, log.getCodigoConvenio());
        pr.setTimestamp(3, this.currentTimeStamp());
        pr.setString(4, log.getXmlLog());
        pr.setString(5, log.getTipoOperacao().toString());
        pr.setBoolean(6, false);
        if (log.getCodigoRequisicao() == null) {
            pr.setObject(7, log.getCodigoRequisicao());
        } else {
            pr.setInt(7, log.getCodigoRequisicao());
        }
        pr.setInt(8, Integer.parseInt(log.getCodigoPaciente()));
        pr.setString(9, log.getCodigoExame());
        pr.setInt(10, log.getCodigoMaterial());
        pr.setString(11, "");
        pr.execute();
        pr.close();
    }

    private Timestamp currentTimeStamp() {
        return new Timestamp(new Date().getTime());
    }

    public List<Registro> buscarRegistrosLog(IntervaloData intervalo, Filtros itens, boolean filtraLogsRejeitados) throws SQLException {
        Statement st = Conexao.getStatement();
        String sql = this.getSqlConsulta(intervalo, itens, FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.SIMUS, filtraLogsRejeitados);
        ResultSet rs = Conexao.executeQuery(st, sql);
        List<Registro> listaRegistros = this.criarListaRegistros(rs);
        rs.close();
        st.close();
        return listaRegistros;
    }

    private List<Registro> criarListaRegistros(ResultSet rs) throws SQLException {
        ArrayList<Registro> logs = new ArrayList<Registro>();
        while (rs.next()) {
            logs.add(this.montaDados(rs));
        }
        return logs;
    }

    public void marcarLogComoExportado(LogIntegracaoOperadora log) throws SQLException {
        StringBuilder sql = new StringBuilder(" update exportaintegracaooperadora set ");
        sql.append(" eio_exportado = 't', eio_situacao = 'C' ");
        sql.append(" where eio_codigo = ").append(log.getCodigoLog());
        sql.append(" and fil_codigo = ").append(log.getCodigoFilial());
        sql.append(" and con_codigo = ").append(log.getCodigoConvenio());
        Statement st = Conexao.getStatement();
        Conexao.execute(log.getCodigoFilial().toString(), st, sql.toString());
        Conexao.fecharStatement(st);
    }

    @Override
    public int consultarLogsHaEnviar(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora protocolo) throws IntegracaoException {
        int logs = 0;
        List<Integer> convenios = this.pesquisarConveniosConfigurados();
        if (!convenios.isEmpty()) {
            Statement st;
            block5: {
                StringBuilder codConv = new StringBuilder("(");
                convenios.forEach(c -> codConv.append(c + ","));
                codConv.replace(codConv.length() - 1, codConv.length(), "");
                codConv.append(")");
                st = Conexao.getStatement();
                StringBuilder buf = new StringBuilder("");
                buf.append("select count(*) as logs from exportaintegracaooperadora ");
                buf.append(" where eio_exportado = 'f' ");
                buf.append(" and eio_operacao like '%").append("<nomeintegracaooperadora>").append(protocolo.getDescricao()).append("</nomeintegracaooperadora>").append("%'");
                buf.append(" and (eio_situacao is null or eio_situacao = '')");
                buf.append(" and con_codigo in ").append(codConv.toString());
                try {
                    ResultSet rs = Conexao.executeQuery(st, buf.toString());
                    if (!rs.next()) break block5;
                    logs = rs.getInt("logs");
                }
                catch (SQLException e) {
                    try {
                        throw new IntegracaoException(0L, e.getMessage(), "", true);
                    }
                    catch (Throwable throwable) {
                        Conexao.fecharStatement(st);
                        throw throwable;
                    }
                }
            }
            Conexao.fecharStatement(st);
        }
        return logs;
    }

    private List<Integer> pesquisarConveniosConfigurados() throws IntegracaoException {
        Statement st = Conexao.getStatement();
        StringBuilder buf = new StringBuilder("");
        buf.append(" select con_codigo from convenios ");
        buf.append(" where  con_integracaooperadora is not null ");
        buf.append(" and  con_integracaooperadora ilike '%<protocolo>SIMUS</protocolo>%'");
        ArrayList<Integer> convenios = new ArrayList<Integer>();
        try {
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            while (rs.next()) {
                convenios.add(rs.getInt("con_codigo"));
            }
        }
        catch (SQLException e) {
            try {
                throw new IntegracaoException(0L, e.getMessage(), "", true);
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
        }
        Conexao.fecharStatement(st);
        return convenios;
    }
}

