/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.exportacao.operadora.mksaude;

import jalis.comum.Conexao;
import jalis.integracaooperadoras.sistemas.FabricaIntegracaoOperadora;
import jalis.integracaooperadoras.sistemas.util.LogIntegracaoOperadora;
import jalis.laboratorio.exportacao.operadora.ConsultaIntegracaoOperadoraDao;
import jalis.laboratorio.exportacao.operadora.util.Filtros;
import jalis.laboratorio.exportacao.operadora.util.IntervaloData;
import jalis.util.tabela.Registro;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ConsultaMKSaudeDao
extends ConsultaIntegracaoOperadoraDao {
    public void criarNovoLog(LogIntegracaoOperadora log) throws SQLException {
        Integer filial = log.getCodigoFilial();
        PreparedStatement pr = Conexao.getPreparedStatement("insert into exportaintegracaooperadora (fil_codigo, con_codigo, eio_codigo, eio_datahora, eio_operacao, eio_tipooperacao, eio_exportado, req_codigo, pac_codigo, exa_codigo, mco_codigo, eio_situacao) values(?, ?, nextval('exportaintegracaooperadora_" + filial + "_sequence') , ?, ?, ?, ?, ?, ?, ?, ?, ?);");
        pr.setInt(1, filial);
        pr.setInt(2, log.getCodigoConvenio());
        pr.setTimestamp(3, this.currentTimeStamp());
        pr.setString(4, log.getXmlLog());
        pr.setString(5, log.getTipoOperacao().toString());
        pr.setBoolean(6, false);
        if (log.getCodigoRequisicao() == null) {
            pr.setObject(7, log.getCodigoRequisicao());
        } else {
            pr.setInt(7, log.getCodigoRequisicao());
        }
        pr.setInt(8, Integer.parseInt(log.getCodigoPaciente()));
        pr.setString(9, log.getCodigoExame());
        pr.setInt(10, log.getCodigoMaterial());
        pr.setString(11, "");
        pr.execute();
        pr.close();
    }

    private Timestamp currentTimeStamp() {
        return new Timestamp(new Date().getTime());
    }

    public List<Registro> buscarRegistrosLog(IntervaloData intervalo, Filtros itens, boolean filtraLogsRejeitados) throws SQLException {
        Statement st = Conexao.getStatement();
        String sql = this.getSqlConsulta(intervalo, itens, FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.MK, filtraLogsRejeitados);
        ResultSet rs = Conexao.executeQuery(st, sql);
        List<Registro> listaRegistros = this.criarListaRegistros(rs);
        rs.close();
        st.close();
        return listaRegistros;
    }

    private List<Registro> criarListaRegistros(ResultSet rs) throws SQLException {
        ArrayList<Registro> logs = new ArrayList<Registro>();
        while (rs.next()) {
            logs.add(this.montaDados(rs));
        }
        return logs;
    }

    public void marcarLogComoExportado(LogIntegracaoOperadora log) throws SQLException {
        String sql = "update exportaintegracaooperadora set eio_exportado = true where eio_codigo = ? and fil_codigo = ? and con_codigo = ?;";
        PreparedStatement pr = Conexao.getPreparedStatement(sql);
        pr.setLong(1, log.getCodigoLog());
        pr.setInt(2, log.getCodigoFilial());
        pr.setInt(3, log.getCodigoConvenio());
        pr.executeUpdate();
        pr.close();
    }
}

