/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.exportacao.operadora.ipmsaude;

import jalis.comum.Conexao;
import jalis.integracaooperadoras.sistemas.FabricaIntegracaoOperadora;
import jalis.integracaooperadoras.sistemas.util.LogIntegracaoOperadora;
import jalis.laboratorio.exportacao.integracao.IntegracaoException;
import jalis.laboratorio.exportacao.operadora.ConsultaIntegracao;
import jalis.laboratorio.exportacao.operadora.RetornoOperadora;
import jalis.laboratorio.exportacao.operadora.ipmsaude.ConsultaIPMSaudeDao;
import jalis.laboratorio.exportacao.operadora.util.Filtros;
import jalis.laboratorio.exportacao.operadora.util.IntervaloData;
import jalis.util.tabela.Registro;
import java.sql.SQLException;
import java.util.List;

public class ConsultaIntegracaoIPMSaude
implements ConsultaIntegracao {
    private ConsultaIPMSaudeDao dao = new ConsultaIPMSaudeDao();

    @Override
    public int consultarLogsHaEnviar() throws IntegracaoException {
        return this.dao.consultarLogsHaEnviar(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.IPMSAUDE);
    }

    @Override
    public RetornoOperadora reenviarLog(LogIntegracaoOperadora log) throws IntegracaoException {
        try {
            this.dao.criarNovoLog(log);
            this.dao.marcarLogComoExportado(log);
            Conexao.arquivaSQL();
        }
        catch (SQLException e) {
            this.rollback(log);
            throw new IntegracaoException(log.getCodigoLog(), e.getMessage(), "", true);
        }
        return new RetornoOperadora("", "", "");
    }

    @Override
    public List<Registro> buscarRegistros(IntervaloData intervalo, Filtros itens, boolean filtraLogsRejeitados) throws IntegracaoException {
        try {
            return this.dao.buscarRegistrosLog(intervalo, itens, filtraLogsRejeitados);
        }
        catch (SQLException e) {
            throw new IntegracaoException(-1L, e.getMessage(), "", true);
        }
    }

    private void rollback(LogIntegracaoOperadora log) throws IntegracaoException {
        try {
            Conexao.anulaSQL();
        }
        catch (SQLException e) {
            throw new IntegracaoException(log.getCodigoLog(), e.getMessage(), "", true);
        }
    }

    @Override
    public void teste() {
    }
}

