/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.exportacao.operadora;

import jalis.integracaooperadoras.sistemas.FabricaIntegracaoOperadora;
import jalis.laboratorio.exportacao.integracao.IntegracaoException;
import jalis.laboratorio.exportacao.operadora.ConfiguracaoOperadoraDao;
import jalis.laboratorio.exportacao.operadora.ConsultaIntegracao;
import jalis.laboratorio.exportacao.operadora.datahealth.ConsultaIntegracaoDataHealth;
import jalis.laboratorio.exportacao.operadora.ipmsaude.ConsultaIntegracaoIPMSaude;
import jalis.laboratorio.exportacao.operadora.mksaude.ConsultaIntegracaoMkSaude;
import jalis.laboratorio.exportacao.operadora.simus.ConsultaIntegracaoSIMUS;
import jalis.laboratorio.exportacao.operadora.sline.ConsultaIntegracaoSLine;
import jalis.laboratorio.exportacao.operadora.uberaba.ConsultaIntegracaoUberaba;
import jalis.laboratorio.exportacao.operadora.unimedguaxupe.ConsultaIntegracaoUnimedGuaxupe;
import jalis.laboratorio.exportacao.operadora.unimedibitinga.ConsultaIntegracaoUnimedIbitinga;
import jalis.laboratorio.exportacao.operadora.unimedpr.ConsultaIntegracaoUnimedPR;
import jalis.laboratorio.exportacao.operadora.upy.ConsultaIntegracaoUpy;
import jalis.laboratorio.exportacao.operadora.valedossinos.ConsultaIntegracaoValeDosSinos;
import jalis.laboratorio.exportacao.operadora.vtrp.ConsultaIntegracaoVtrp;

public enum ConsultaIntegracaoOperadoraFactory {
    VTRP(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.VTRP, new ConsultaIntegracaoVtrp()),
    UPY(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.UPY, new ConsultaIntegracaoUpy()),
    MK_SAUDE(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.MK, new ConsultaIntegracaoMkSaude()),
    SINOS(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.SINOS, new ConsultaIntegracaoValeDosSinos()),
    UBERABA(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.UBERABA, new ConsultaIntegracaoUberaba()),
    IPMSAUDE(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.IPMSAUDE, new ConsultaIntegracaoIPMSaude()),
    UNIMEDPR(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.UNIMEDPR, new ConsultaIntegracaoUnimedPR()),
    UNIMEDGUAXUPE(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.UNIMEDGUAXUPE, new ConsultaIntegracaoUnimedGuaxupe()),
    SIMUS(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.SIMUS, new ConsultaIntegracaoSIMUS()),
    IBI(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.IBI, new ConsultaIntegracaoUnimedIbitinga()),
    DATAHEALTH(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.SDH, new ConsultaIntegracaoDataHealth()),
    SLINE(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.SLINE, new ConsultaIntegracaoSLine());

    private static final ConfiguracaoOperadoraDao dao;
    private final FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora protocolo;
    private final ConsultaIntegracao service;

    private ConsultaIntegracaoOperadoraFactory(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora protocolo, ConsultaIntegracao service) {
        this.protocolo = protocolo;
        this.service = service;
    }

    public static ConsultaIntegracao criar(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora protocolo) throws IntegracaoException {
        for (ConsultaIntegracaoOperadoraFactory integracao : ConsultaIntegracaoOperadoraFactory.values()) {
            if (!integracao.protocolo.equals((Object)protocolo)) continue;
            return integracao.service;
        }
        throw new IntegracaoException(0L, "N\u00e3o foi encontrado integra\u00e7\u00e3o para o protocolo informado\n" + protocolo.getDescricao(), "", true);
    }

    static {
        dao = new ConfiguracaoOperadoraDao();
    }
}

