/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.exportacao.operadora;

import jalis.comum.Conexao;
import jalis.integracaooperadoras.sistemas.FabricaIntegracaoOperadora;
import jalis.laboratorio.exportacao.integracao.IntegracaoException;
import jalis.laboratorio.exportacao.operadora.util.Filtros;
import jalis.laboratorio.exportacao.operadora.util.IntervaloData;
import jalis.util.Funcoes;
import jalis.util.tabela.Registro;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public abstract class ConsultaIntegracaoOperadoraDao {
    public static final String INFO_XML_LOG = "xmlLog";
    public static final String INFO_TIPO_OPERACAO = "tipoOperacao";
    public static final String INFO_EXPORTADO = "exportado";
    public static final String INFO_RETORNO = "retorno";
    public static final String INFO_COD_LOG = "log";
    public static final String INFO_DATA_LOG = "dataLog";
    public static final String INFO_FILIAL = "filial";
    public static final String INFO_FILIAL_DESCRICAO = "descricaofilial";
    public static final String INFO_COD_REQUISICAO = "Requisi\u00e7\u00e3o";
    public static final String INFO_NOME_PACIENTE = "nomePaciente";
    public static final String INFO_COD_PACIENTE = "codigoPaciente";
    public static final String INFO_COD_CONVENIO = "codigoConvenio";
    public static final String INFO_DESC_CONVENIO = "descricaoConvenio";
    public static final String INFO_IDADE = "idade";
    public static final String INFO_MATRICULA = "matricula";
    public static final String CARTAO_SUS = "cartaosus";
    public static final String INFO_EXAME = "exame";
    public static final String INFO_COD_MATERIAL = "codigoMaterial";
    public static final String INFO_DESC_MATERIAL = "descricaoMaterial";
    public static final String INFO_DESC_EXAME = "descricaoExame";
    public static final String INFO_GUIA = "guia";
    public static final String INFO_DATA_GUIA = "dataGuia";
    public static final String INFO_AMB = "amb";
    public static final String INFO_SITUACAO = "situacao";
    public static final String INFO_SITUACAO_LOG = "situacaoLog";
    public static final String INFO_CONFERENCIA = "conferencia";
    public static final String INFO_USR_CONFERENCIA = "usrconferencia";
    public static final String INFO_DATA_REQUISICAO = "dataRequisicao";
    public static final String INFO_OBS_REQUISICAO = "observacao";
    public static final String INFO_ID_EXAME = "idExame";
    private static final String FILTRO_NAO_ENVIADO = "N\u00e3o Enviados";
    private static final String FILTRO_ENVIADOS = "Enviados";
    public static final String TAG_INICIO = "<nomeintegracaooperadora>";
    public static final String TAG_FIM = "</nomeintegracaooperadora>";

    protected Registro montaDados(ResultSet rs) throws SQLException {
        Registro registro = new Registro();
        registro.setValor(INFO_FILIAL, rs.getString("fil_codigo"));
        registro.setValor(INFO_FILIAL_DESCRICAO, rs.getString("descricaoFilial"));
        registro.setValor(INFO_COD_REQUISICAO, rs.getString("req_codigo"));
        registro.setValor(INFO_COD_LOG, rs.getString("eio_codigo"));
        registro.setValor(INFO_EXPORTADO, rs.getBoolean("eio_exportado"));
        registro.setValor(INFO_XML_LOG, rs.getString("eio_operacao"));
        registro.setValor(INFO_DATA_LOG, rs.getString("eio_datahora"));
        registro.setValor(INFO_TIPO_OPERACAO, rs.getString("eio_tipooperacao"));
        registro.setValor(INFO_RETORNO, rs.getString("eio_retorno"));
        registro.setValor(INFO_SITUACAO, rs.getString("situacaoExame"));
        registro.setValor(INFO_COD_PACIENTE, rs.getString("pac_codigo"));
        registro.setValor(INFO_NOME_PACIENTE, rs.getString("pac_nome"));
        registro.setValor(INFO_COD_CONVENIO, rs.getString("con_codigo"));
        registro.setValor(INFO_DESC_CONVENIO, rs.getString("con_razao"));
        registro.setValor(INFO_IDADE, rs.getInt("pac_idade"));
        registro.setValor(INFO_MATRICULA, rs.getString("req_matricula"));
        registro.setValor(INFO_EXAME, rs.getString("exa_codigo"));
        registro.setValor(INFO_COD_MATERIAL, rs.getString("mco_codigo"));
        registro.setValor(INFO_DESC_MATERIAL, rs.getString("mco_abreviatura"));
        registro.setValor(INFO_DESC_EXAME, rs.getString(INFO_DESC_EXAME));
        registro.setValor(INFO_GUIA, rs.getString("req_guia"));
        registro.setValor(INFO_DATA_GUIA, rs.getString("exr_dataguia"));
        registro.setValor(INFO_AMB, rs.getString("cod_amb"));
        registro.setValor(INFO_CONFERENCIA, rs.getString("exr_dataassina"));
        registro.setValor(INFO_USR_CONFERENCIA, rs.getString("usr_codassina"));
        registro.setValor(INFO_DATA_REQUISICAO, rs.getString("req_data"));
        registro.setValor(CARTAO_SUS, rs.getString("req_cartaosus"));
        registro.setValor(INFO_SITUACAO_LOG, rs.getString(INFO_SITUACAO_LOG));
        registro.setValor(INFO_OBS_REQUISICAO, rs.getString(INFO_OBS_REQUISICAO));
        registro.setValor(INFO_ID_EXAME, rs.getString("cod_autorizacao"));
        return registro;
    }

    protected String getSqlConsulta(IntervaloData intervalo, Filtros itens, FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora protocolo, boolean filtraLogsRejeitados) {
        StringBuilder bui = new StringBuilder();
        bui.append("select distinct pa.pac_codigo ");
        bui.append(", pa.pac_nome");
        bui.append(", pac_idade");
        bui.append(", exr.exa_codigo");
        bui.append(", exr.mco_codigo");
        bui.append(", mco.mco_abreviatura");
        bui.append(", exr_situacao as situacaoExame");
        bui.append(", exr_dataassina");
        bui.append(", exr.usr_codassina");
        bui.append(", eio.con_codigo");
        bui.append(", con.con_razao");
        bui.append(", req.req_matricula");
        bui.append(", req.req_cartaosus");
        bui.append(", req.req_codigo");
        bui.append(", req.req_data");
        bui.append(", COALESCE(NULLIF(TRIM(exr.exr_guia), '') ");
        bui.append(", req.req_guia) as req_guia");
        bui.append(", exr.exr_dataguia ");
        bui.append(", cast(req.req_dataguia as text) as req_dataguia");
        bui.append(", dtp.dtp_codamb as cod_amb");
        bui.append(", eio.fil_codigo ");
        bui.append(", eio_codigo");
        bui.append(", eio_exportado");
        bui.append(", eio_operacao");
        bui.append(", eio_tipooperacao");
        bui.append(", eio_retorno");
        bui.append(", eio_datahora");
        bui.append(", eio_situacao as situacaoLog ");
        bui.append(", fil.fil_descricao as descricaoFilial");
        bui.append(", e.exa_descricao as descricaoExame");
        bui.append(", req.req_obs as observacao");
        bui.append(", exr.exr_codautorizacao as cod_autorizacao");
        bui.append(" from exportaintegracaooperadora eio ");
        bui.append("left join filiais_postocoleta fil on eio.fil_codigo = fil.fil_codigo ");
        bui.append("left join requisicao req on req.fil_codigo = eio.fil_codigo and req.req_codigo = eio.req_codigo ");
        bui.append("left join examerequisicao exr on eio.fil_codigo = exr.fil_codigo and exr.req_codigo = req.req_codigo and eio.exa_codigo = exr.exa_codigo and eio.mco_codigo = exr.mco_codigo ");
        bui.append("left join materialcoleta mco on eio.fil_codigo = mco.fil_codigo and exr.mco_codigo = mco.mco_codigo ");
        bui.append("left join paciente pa on pa.fil_codigo = eio.fil_codigo and pa.pac_codigo = req.pac_codigo ");
        bui.append("left join convenios con on con.fil_codigo = eio.fil_codigo and con.con_codigo = eio.con_codigo ");
        bui.append("left join detalhetabelapreco dtp  on exr.fil_codigo = dtp.fil_codigo  and exr.exa_codigo = dtp.exa_codigo  ");
        bui.append("and exr.mco_codigo = dtp.mco_codigo and con.tpe_codigo = dtp.tpe_codigo ");
        bui.append("left join exames e on exr.fil_codigo = e.fil_codigo  and exr.exa_codigo = e.exa_codigo  ");
        bui.append(" where (req.req_excluida is null or req.req_excluida = false) ");
        bui.append(" and (exr.exr_excluido is null or exr.exr_excluido = false)");
        bui.append(" and (eio.eio_situacao is null or eio.eio_situacao != '").append("D").append("') ");
        if (Funcoes.verificaData(intervalo.dataInicial)) {
            bui.append(" and eio.eio_datahora >= '").append(Funcoes.formataData("yyyy-MM-dd HH:mm:ss", intervalo.dataInicial)).append("' ");
        }
        if (Funcoes.verificaData(intervalo.dataFinal)) {
            bui.append(" and eio.eio_datahora <= ' ").append(Funcoes.formataData("yyyy-MM-dd 23:59:59", intervalo.dataFinal)).append("' ");
        }
        if (itens.itemRequisicao.isSelected()) {
            this.addExpressao(bui, this.getExpressao("eio.req_codigo", itens.itemRequisicao.getSelecionadosAvancado(0), true));
        }
        if (itens.itemConvenio.isSelected()) {
            this.addExpressao(bui, this.getExpressao("eio.con_codigo", itens.itemConvenio.getSelecionados(0), false));
        }
        if (itens.itemPaciente.isSelected()) {
            this.addExpressao(bui, this.getExpressao("eio.pac_codigo", itens.itemPaciente.getSelecionados(0), true));
        }
        if (itens.itemExame.isSelected()) {
            this.addExpressao(bui, this.getExpressao("eio.exa_codigo", itens.itemExame.getSelecionados(0), true));
        }
        if (itens.itemFilial.isSelected()) {
            this.addExpressao(bui, this.getExpressao("eio.fil_codigo", itens.itemFilial.getSelecionados(0), true));
        }
        if (itens.itemSituacao.isSelected()) {
            this.addExpressao(bui, this.getExpressao("eio.eio_situacao", itens.itemSituacao.getSelecionados(0), true));
        }
        if (filtraLogsRejeitados) {
            bui.append(" and eio.eio_situacao = 'R' ");
        }
        if (itens.itemExibirExportado.getSelectedItem().equals(FILTRO_ENVIADOS)) {
            bui.append(" and eio.eio_exportado in (true)");
        } else if (itens.itemExibirExportado.getSelectedItem().equals(FILTRO_NAO_ENVIADO)) {
            bui.append(" and eio.eio_exportado in (false)");
        } else {
            bui.append(" and eio.eio_exportado in (true, false)");
        }
        bui.append(" and eio_operacao like '%").append(TAG_INICIO).append(protocolo.getDescricao()).append(TAG_FIM).append("%'");
        bui.append(" order by eio_codigo");
        return bui.toString();
    }

    protected String getExpressao(String campo, String[] valores, boolean aspas) {
        if (campo != null && valores != null && valores.length > 0) {
            StringBuilder buf = new StringBuilder("(");
            for (int i = 0; i < valores.length; ++i) {
                if (i > 0) {
                    buf.append(" or ");
                }
                String valor = valores[i];
                String condicao = this.montarCondicao(campo, aspas, valor);
                buf.append(condicao);
            }
            return buf.append(")").toString();
        }
        return "";
    }

    private String montarCondicao(String campo, boolean aspas, String valor) {
        String condicao = "";
        condicao = Funcoes.textoVazio(valor) ? this.montarCondicaoParaVazio(campo, valor, aspas) : this.montarCondicaoComValor(campo, valor, aspas);
        return condicao;
    }

    private String montarCondicaoParaVazio(String campo, String valor, boolean aspas) {
        StringBuilder buf = new StringBuilder();
        buf.append("(");
        buf.append(this.montarCondicaoComValor(campo, valor, aspas));
        buf.append(")");
        buf.append(" is not false");
        return buf.toString();
    }

    private String montarCondicaoComValor(String campo, String valor, boolean aspas) {
        StringBuilder buf = new StringBuilder();
        buf.append(campo);
        buf.append(" = ");
        if (aspas) {
            buf.append('\'');
        }
        buf.append(valor);
        if (aspas) {
            buf.append('\'');
        }
        return buf.toString();
    }

    protected void addExpressao(StringBuilder bui, String exp) {
        if (exp != null && exp.length() > 0) {
            if (bui.length() > 0) {
                bui.append("and ");
            }
            bui.append(exp);
            bui.append(' ');
        }
    }

    public int consultarLogsHaEnviar(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora protocolo) throws IntegracaoException {
        Statement st = Conexao.getStatement();
        StringBuilder buf = new StringBuilder("");
        buf.append("select count(1) as logs from exportaintegracaooperadora eio ");
        buf.append("left join requisicao req on ");
        buf.append("req.req_codigo = eio.req_codigo  ");
        buf.append("and req.fil_codigo = eio.fil_codigo ");
        buf.append("left join examerequisicao exr on ");
        buf.append("exr.req_codigo = eio.req_codigo  ");
        buf.append("and exr.fil_codigo = eio.fil_codigo ");
        buf.append("and exr.exa_codigo = eio.exa_codigo ");
        buf.append("and exr.mco_codigo = eio.mco_codigo ");
        buf.append("where eio_exportado is false ");
        buf.append("and (req.req_excluida is null or req.req_excluida = false) ");
        buf.append("and (exr.exr_excluido is null or exr.exr_excluido = false) ");
        buf.append("and exr.exr_situacao in ('");
        buf.append("C").append("', '");
        buf.append("E").append("', '");
        buf.append("I").append("') ");
        buf.append("and (eio.eio_situacao not in ('");
        buf.append("T").append("', '");
        buf.append("N").append("', '");
        buf.append("R").append("', '");
        buf.append("N").append("', '");
        buf.append("M").append("', '");
        buf.append("E").append("') ");
        buf.append("or eio.eio_situacao is null) ");
        buf.append("and eio_operacao like '%").append(TAG_INICIO).append(protocolo.getDescricao()).append(TAG_FIM).append("%'");
        try {
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                return rs.getInt("logs");
            }
        }
        catch (SQLException e) {
            throw new IntegracaoException(0L, e.getMessage(), "", true);
        }
        throw new IntegracaoException(0L, "N\u00e3o foi poss\u00edvel consultar logs para envio", "", true);
    }
}

