/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.exportacao.integracao;

import jalis.comum.Conexao;
import jalis.comum.ConexaoIntegracao;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmPadrao;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.exportacao.integracao.DadosIntegracaoFilial;
import jalis.laboratorio.exportacao.integracao.IntegracaoUtil;
import jalis.laboratorio.exportacao.thread.ExportaWeb;
import jalis.servidor.Estacoes;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;

public class NovaBase
extends FrmPadrao
implements ActionListener {
    private static final long ACESSO = 907000101L;
    private static final int QTDE_REGISTROS_GERAR_COMANDO = 300;
    private static final int QTDE_REGISTROS_COMMIT = 50;
    private JButton buttonFechar = ComponenteFactory.novoJButton("Fechar", 'F', this);
    private JButton buttonNovo = ComponenteFactory.novoJButton("Novo", 'N', this);
    private JButton buttonCriar = ComponenteFactory.novoJButton("Criar base", 'b', this);
    private JButton buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this);
    private JLabel labelServidorPrincipal = new JLabel("Servidor principal:");
    private JLabel labelServidorSecundario = new JLabel("Servidor secund\u00e1rio:");
    private JLabel labelVServidorPrincipal = ComponenteFactory.novoJLabel(ParametrosLocais.getParametro("caminhoBanco"), null, new TitledBorder(""));
    private TTextField textServidorSecundario = new TTextField(80);
    private JLabel labelFilial = new JLabel("Filial para integrar:");
    private JComboBox comboFilial = new JComboBox();
    private JPanel panelCentro = new JPanel(new GridBagLayout());
    private JTextArea textMensagens = new JTextArea();
    private JScrollPane scroll = new JScrollPane(this.textMensagens);
    private boolean cancelarOperacao = false;
    private boolean exportando = false;

    public NovaBase() {
        this.montaTela();
        this.preencheFiliais();
        this.habilitarCampos(true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NovaBase.this.novo();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void preencheFiliais() {
        Statement st = Conexao.getStatement();
        try {
            DadosIntegracaoFilial[] filiais = IntegracaoUtil.buscaFiliais(st);
            this.comboFilial.removeAllItems();
            for (DadosIntegracaoFilial f : filiais) {
                this.comboFilial.addItem(f);
            }
        }
        catch (SQLException ex) {
            try {
                ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "NovaBase (83)");
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
    }

    private void montaTela() {
        this.setLayout(new BorderLayout());
        Funcoes.criaBarraDescricao(this, "Nova Base", "Cria uma nova base para integra\u00e7\u00e3o de dados entre filiais", "integracao/nova_base.jpg");
        JPanel panelBotoes = new JPanel(new FlowLayout(2));
        panelBotoes.add(this.buttonNovo);
        panelBotoes.add(this.buttonCriar);
        panelBotoes.add(this.buttonCancelar);
        panelBotoes.add(this.buttonFechar);
        this.add((Component)panelBotoes, "South");
        this.add((Component)this.panelCentro, "Center");
        this.panelCentro.setBorder(ScreenUtil.criarBordaVazia());
        this.textMensagens.setEditable(false);
        this.textMensagens.setBackground(this.getBackground());
        this.scroll.setBorder(null);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 0;
        c.insets = new Insets(2, 0, 0, 0);
        this.panelCentro.add((Component)this.labelServidorPrincipal, c);
        c.gridy = 1;
        this.panelCentro.add((Component)this.labelServidorSecundario, c);
        c.gridy = 2;
        this.panelCentro.add((Component)this.labelFilial, c);
        c.fill = 2;
        c.weightx = 1.0;
        c.gridx = 1;
        c.gridy = 0;
        this.labelVServidorPrincipal.setPreferredSize(new Dimension(100, 20));
        this.labelVServidorPrincipal.setMinimumSize(new Dimension(100, 20));
        this.panelCentro.add((Component)this.labelVServidorPrincipal, c);
        c.gridy = 1;
        this.textServidorSecundario.setPreferredSize(new Dimension(100, 20));
        this.textServidorSecundario.setMinimumSize(new Dimension(100, 20));
        this.panelCentro.add((Component)this.textServidorSecundario, c);
        c.gridy = 2;
        this.comboFilial.setPreferredSize(new Dimension(100, 20));
        this.comboFilial.setMinimumSize(new Dimension(100, 20));
        this.panelCentro.add((Component)this.comboFilial, c);
        c.gridy = 3;
        c.gridx = 0;
        c.fill = 1;
        c.weighty = 1.0;
        c.gridwidth = 2;
        this.panelCentro.add((Component)this.scroll, c);
    }

    public static long getModuloAcesso() {
        return 907000101L;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonFechar) {
            this.fechar();
        } else if (e.getSource() == this.buttonNovo) {
            this.novo();
        } else if (e.getSource() == this.buttonCriar) {
            new Thread(){

                @Override
                public void run() {
                    NovaBase.this.criarBase();
                }
            }.start();
        } else if (e.getSource() == this.buttonCancelar) {
            this.cancelarExportacao();
        }
    }

    private void cancelarExportacao() {
        if (Funcoes.mensagem(this, "As informa\u00e7\u00f5es adicionadas ser\u00e3o perdidas.", 4) == 0) {
            this.cancelarOperacao = true;
            if (!this.exportando) {
                this.habilitarCampos(true);
                this.textServidorSecundario.grabFocus();
            }
        }
    }

    private void fechar() {
        this.setVisible(false);
    }

    private void novo() {
        this.textServidorSecundario.clear();
        this.textMensagens.setText("");
        this.textServidorSecundario.setEnabled(true);
        this.comboFilial.setEnabled(true);
        this.buttonNovo.setEnabled(false);
        this.buttonFechar.setEnabled(false);
        this.buttonCriar.setEnabled(true);
        this.buttonCancelar.setEnabled(true);
        ScreenUtil.requisitarFoco(this.textServidorSecundario);
    }

    private boolean validarCampos() {
        DadosIntegracaoFilial c = (DadosIntegracaoFilial)this.comboFilial.getSelectedItem();
        if (!c.isIntegraDados()) {
            Funcoes.mensagem(this, "A filial selecionada n\u00e3o permite integra\u00e7\u00e3o de dados", 1);
            ScreenUtil.requisitarFoco(this.comboFilial);
            return false;
        }
        if (Funcoes.textoVazio(this.textServidorSecundario.getText())) {
            Funcoes.mensagem(this, "O endere\u00e7o do servidor secund\u00e1rio n\u00e3o foi especificado", 1);
            ScreenUtil.requisitarFoco(this.textServidorSecundario);
            return false;
        }
        return true;
    }

    private void habilitarCampos(boolean b) {
        this.buttonCriar.setEnabled(b);
        this.buttonFechar.setEnabled(b);
        this.buttonNovo.setEnabled(b);
        this.buttonCancelar.setEnabled(!b);
        this.textServidorSecundario.setEnabled(!b);
        this.comboFilial.setEnabled(!b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void criarBase() {
        if (!this.validarCampos()) {
            return;
        }
        this.textMensagens.setText("");
        this.textServidorSecundario.setEnabled(false);
        this.habilitarCampos(false);
        Sequence[] sequences = new Sequence[]{new Sequence("estacoes_sequence", "estacoes", "est_codigo", false), new Sequence("aparelhosinterface_apa_codigo_seq", "aparelhosinterface", "apa_codigo", false), new Sequence("conveniomensagem_cme_codigo_seq", "conveniomensagem", "cme_codigo", false), new Sequence("conveniomensagem_cme_codigo_seq", "conveniomensagem", "cme_codigo", false), new Sequence("erroparada_err_codigo_seq", "erroparada", "err_codigo", false), new Sequence("usuariomensagem_ume_codigo_seq", "usuariomensagem", "ume_codigo", false), new Sequence("tipousuario_sequence", "tipousuario", "tpu_codigo", false), new Sequence("requisicao_sequence", "requisicao", "req_codigo", true), new Sequence("historicoregistrocontato_sequence", "historicoregistrocontato", "hrc_codigo", true), new Sequence("lanctocaixa_sequence", "lanctocaixa", "lcx_codigo", true), new Sequence("fatura_sequence", "fatura", "fat_codigo", true)};
        String[] tabelasSemFilial = new String[]{"parametros", "estacoes", "indicacaopaciente", "cid10", "atualizacoes", "aparelhosinterface", "relatoriosistema", "tipousuario", "usuario", "usuarioacesso", "usuariomensagem", "usuarioparametro", "tipousuarioacesso", "nacionalidade", "etniaindigena", "identidadegenero"};
        String[] sequenciaTabelas = new String[]{"filiaisweb", "pais", "cidades", "bairro", "alahospital", "banco", "agencia", "historicopadrao", "coletas", "destino", "tipomaterialcoleta", "motivoalteracao", "motivocontato", "especialidades", "grupo", "unidadesaude", "formapagto", "formapagtoparcelas", "series", "rota", "salaatendimento", "celulaestoque", "historicos", "layout", "metodologia", "prazoentrega", "principios", "prioridade", "unidademedida", "tabelaprecoexames", "situacao", "tipomaterial", "material", "materialcoleta", "origemplanocusto", "motivoscancelamentos", "centrocusto", "labexterno", "identificadorlamina", "setores", "medicamentos", "interface", "convenios", "despcobranca", "medico", "agrupasituacao", "conversaounidade", "planoconta", "recipientes", "contacorrente", "apropriaplanoconta", "saldocontas", "servico", "geladeiras", "especie", "raca", "embalagemproduto", "geladeirasprateleiras", "estantes", "feriados", "exames", "tagsresultadoanterior", "examematcoleta", "entidade", "agrupaexameconvenio", "origemnaoconformidade", "taxa", "procedencianaoconformidade", "acaonaoconformidade", "motivorecoleta", "fichatecnicamaterial", "exameagrupaexameconvenio", "exameagrupasituacao", "examematgrupo", "examehistorico", "examelayout", "examelayoutmetodo", "examematconvenioprazo", "examesetor", "examesmatconvenio", "examesprincipios", "recipcoleta", "adicionalfatura", "conveniodesconto", "conveniomensagem", "conveniosvencimento", "destinoconvlayout", "conveniostaxa", "recipmaterial", "reciptriagem", "materialexame", "destinotaxa", "coletastaxa", "medicoconveniotiss", "medicoconvenio", "medicoespecialidades", "medprincipios", "modelofatura", "detalhetabelapreco", "detalhetabelaprecometodologia", "interfacerack", "paciente", "pacienteconvenio", "pacientemedicamento", "orcamento", "orcamentoconvenio", "orcamentoconvenioexame", "requisicao", "requisicaocid10", "historicoregistrocontato", "requisicaomedicamento", "requisicaorequisicao", "requisicaousuario", "examerequisicao", "examerequisicaoresultado", "examematinterface", "examematintdesmembrar", "interfaceexamerequisicao", "interfaceexamerequisicaodesm", "interfaceexmreqcomplexo", "interfaceexmreqhistorico", "interfaceexmreqsimples", "interfaceexmreqsimplesdesm", "examescontrole", "contrasenha", "lanctocaixa", "log", "loteapoio", "loteapoiorequisicao", "loteexterno", "loteexternorequisicao", "loteexternoexamerequisicao", "fatura", "faturarequisicao", "faturaexamerequisicao", "materialexamerequis", "requisicaolanctocaixa", "tabelaprecoexamesporte", "conveniospreco", "examesalvaro", "examesbalague", "examesdelta", "examesjalis", "examesmatrix", "examespardini", "examesreacao", "examesrede", "examesatitude", "examesdb", "examessolucao", "examessaomarcos", "examessyslab", "examessergiofranco", "examematcoletajalis", "examematcoletalabexterno", "banhomaria", "loteexternoexamerequisicaodesm", "loteexternoexamerequisicaorecip"};
        Statement st = Conexao.getStatement();
        ConexaoIntegracao conexao = new ConexaoIntegracao(this.textServidorSecundario.getText(), false);
        Statement stIntegracao = null;
        if (conexao.getConnected()) {
            stIntegracao = conexao.getStatement();
        }
        if (!conexao.getConnected() || stIntegracao == null) {
            Funcoes.mensagem(this, "A conex\u00e3o com o servidor secund\u00e1rio falhou.", 1);
            if (conexao.getConnected()) {
                conexao.shutdown();
            }
            this.habilitarCampos(true);
            ScreenUtil.requisitarFoco(this.textServidorSecundario);
            return;
        }
        int filialSelecionada = ((DadosIntegracaoFilial)this.comboFilial.getSelectedItem()).getCodigo();
        String comando = "";
        try {
            this.exportando = true;
            StringBuilder buf = new StringBuilder();
            buf.append("select fil_codigo, fil_descricao, fil_baseweb, fil_integrar, fil_devedorweb, fil_responsavelweb, ");
            buf.append(" fil_proibidoweb, fil_incompletoweb, fil_webdevedora, fil_webvernaoassinado, fil_webmostrarassinatura, fil_webcpfpaciente, fil_webbotaoimprimir, ");
            buf.append(" fil_webimagemassinatura, fil_webrstjanela, fil_webmsgpopup, fil_webenviarcabecalho, fil_webresultadotexto, fil_webpdf, fil_webassinaturaexame ");
            buf.append(" from filiais_postocoleta ");
            ResultSet rs = Conexao.executeQuery(st, buf);
            buf.delete(0, buf.length());
            while (rs.next()) {
                if (this.possuiFilial(rs.getInt("fil_codigo"), conexao)) continue;
                buf.append("insert into filiais_postocoleta(fil_codigo, fil_descricao, fil_baseweb, fil_integrar, fil_devedorweb, fil_responsavelweb, ");
                buf.append(" fil_proibidoweb, fil_incompletoweb, fil_webdevedora, fil_webvernaoassinado, fil_webmostrarassinatura, fil_webcpfpaciente, fil_webbotaoimprimir, ");
                buf.append(" fil_webimagemassinatura, fil_webrstjanela, fil_webmsgpopup, fil_webenviarcabecalho, fil_webresultadotexto, fil_webpdf, fil_webassinaturaexame ");
                buf.append(") values (");
                buf.append(rs.getInt("fil_codigo")).append(", ");
                buf.append("'").append(rs.getString("fil_descricao")).append("', '").append(rs.getString("fil_baseweb")).append("', ");
                buf.append(rs.getBoolean("fil_integrar") ? "true" : "false");
                buf.append(",'").append(rs.getString("fil_devedorweb")).append("'");
                buf.append(",'").append(rs.getString("fil_responsavelweb")).append("'");
                buf.append(",'").append(rs.getString("fil_proibidoweb")).append("'");
                buf.append(",'").append(rs.getString("fil_incompletoweb")).append("'");
                buf.append(",").append(rs.getBoolean("fil_webdevedora"));
                buf.append(",").append(rs.getBoolean("fil_webvernaoassinado"));
                buf.append(",").append(rs.getBoolean("fil_webmostrarassinatura"));
                buf.append(",").append(rs.getBoolean("fil_webcpfpaciente"));
                buf.append(",").append(rs.getBoolean("fil_webbotaoimprimir"));
                buf.append(",'").append(rs.getString("fil_webimagemassinatura")).append("'");
                buf.append(",").append(rs.getBoolean("fil_webrstjanela"));
                buf.append(",").append(rs.getBoolean("fil_webmsgpopup"));
                buf.append(",").append(rs.getBoolean("fil_webenviarcabecalho"));
                buf.append(",").append(rs.getBoolean("fil_webresultadotexto"));
                buf.append(",").append(rs.getBoolean("fil_webpdf"));
                buf.append(",").append(rs.getBoolean("fil_webassinaturaexame")).append(");");
            }
            conexao.executeUpdate(stIntegracao, buf.toString());
            conexao.arquivaSQL();
            conexao.executeUpdate(stIntegracao, "set session_replication_role = replica");
            for (String string : tabelasSemFilial) {
                System.gc();
                this.mostraMensagem("Processando tabela: " + string);
                buf.delete(0, buf.length());
                buf.append("select relname from pg_class where upper(relname) = upper('").append(string).append("') and relkind='r'");
                rs = Conexao.executeQuery(st, buf);
                if (!rs.next()) continue;
                StringBuilder query = new StringBuilder();
                query.append(" select count(1) as quantidadeRegistro from ").append(string);
                ResultSet rsQuantidadeRegistro = Conexao.executeQuery(st, query.toString());
                int quantidadeRegistro = 0;
                if (!rsQuantidadeRegistro.next()) continue;
                quantidadeRegistro = rsQuantidadeRegistro.getInt("quantidadeRegistro");
                Set<String> chaves = this.chavesPrimariasTabela(string, conexao);
                String chavesTabela = StringUtil.limpaString(chaves.toString(), new String[]{"[", "]"});
                boolean enviarParticionado = !Funcoes.textoVazio(chavesTabela);
                HashSet<String> comandos = new HashSet<String>();
                int offset = 0;
                while (offset < quantidadeRegistro && !this.cancelarOperacao) {
                    buf.delete(0, buf.length());
                    buf.append("select * from ").append(string);
                    if (enviarParticionado) {
                        buf.append(" order by ").append(chavesTabela);
                        buf.append(" limit ").append(300).append(" offset ").append(offset);
                    }
                    rs = Conexao.executeQuery(st, buf);
                    while (rs.next()) {
                        this.constroiInsertUpdateTabelaSemFilial(rs, string, comandos, conexao, chaves);
                        ++offset;
                    }
                    int qtd = 0;
                    for (String s : comandos) {
                        if (this.cancelarOperacao) break;
                        comando = s;
                        conexao.executeUpdate(stIntegracao, comando);
                        if (qtd == 50) {
                            conexao.arquivaSQL();
                            qtd = 0;
                            continue;
                        }
                        ++qtd;
                    }
                    if (qtd > 0) {
                        conexao.arquivaSQL();
                    }
                    comandos.clear();
                    System.gc();
                }
            }
            conexao.arquivaSQL();
            comando = "";
            String chave = StringUtil.encriptar(Long.parseLong("0000"));
            String estacao = Estacoes.codificar(Long.parseLong("0000"), 1);
            StringBuilder cliente = new StringBuilder("update parametros set par_cliente = '");
            cliente.append(chave).append("', par_estacoes = '").append(estacao).append("'");
            conexao.executeUpdate(stIntegracao, cliente.toString());
            if (!this.cancelarOperacao) {
                for (String tabela : sequenciaTabelas) {
                    if (this.cancelarOperacao) break;
                    System.gc();
                    this.mostraMensagem("Processando tabela: " + tabela);
                    buf.delete(0, buf.length());
                    buf.append("select relname from pg_class where upper(relname) = upper('").append(tabela).append("') and relkind='r'");
                    rs = Conexao.executeQuery(st, buf);
                    if (!rs.next()) continue;
                    StringBuilder query = new StringBuilder();
                    query.append(" select count(1) as quantidadeRegistro from ").append(tabela);
                    query.append(" where fil_codigo = ");
                    query.append(filialSelecionada);
                    int quantidadeRegistro = 0;
                    ResultSet rsQuantidadeRegistro = st.executeQuery(query.toString());
                    if (!rsQuantidadeRegistro.next()) continue;
                    quantidadeRegistro = rsQuantidadeRegistro.getInt("quantidadeRegistro");
                    if (this.cancelarOperacao) continue;
                    Set<String> chaves = this.chavesPrimariasTabela(tabela, conexao);
                    String chavesTabela = StringUtil.limpaString(chaves.toString(), new String[]{"[", "]"});
                    boolean enviarParticionado = !Funcoes.textoVazio(chavesTabela);
                    HashSet<String> comandos = new HashSet<String>();
                    int offset = 0;
                    while (offset < quantidadeRegistro && !this.cancelarOperacao) {
                        buf.delete(0, buf.length());
                        buf.append("select * from ").append(tabela).append(" where fil_codigo = ").append(filialSelecionada);
                        if (enviarParticionado) {
                            buf.append(" order by ").append(chavesTabela);
                            buf.append(" limit ").append(300).append(" offset ").append(offset);
                        }
                        rs = Conexao.executeQuery(st, buf);
                        while (rs.next()) {
                            this.constroiInsertUpdateDeTabelaComFilial(rs, tabela, comandos, conexao, chaves);
                            ++offset;
                        }
                        int qtd = 0;
                        for (String s : comandos) {
                            if (this.cancelarOperacao) break;
                            comando = s;
                            conexao.executeUpdate(stIntegracao, comando);
                            if (qtd == 50) {
                                conexao.arquivaSQL();
                                qtd = 0;
                                continue;
                            }
                            ++qtd;
                        }
                        if (qtd > 0) {
                            conexao.arquivaSQL();
                        }
                        comandos.clear();
                        System.gc();
                    }
                }
            }
            conexao.executeUpdate(stIntegracao, "set session_replication_role = DEFAULT");
            conexao.arquivaSQL();
            comando = "";
            HashSet<String> hashSet = new HashSet<String>();
            ResultSet updateFilial = Conexao.executeQuery(Conexao.getStatement(), "select fil_codigo, fil_descricao, fil_cnpj, fil_endereco, fil_complemento, fil_cep, fil_fone, fil_fax, fil_responsavel, fil_baseweb, fil_tipobase from filiais_postocoleta");
            while (updateFilial.next()) {
                hashSet.add(this.constroiUpdateDeTabelaComFilial(updateFilial, "filiais_postocoleta", updateFilial.getInt("fil_codigo")));
            }
            for (String update : hashSet) {
                conexao.executeUpdate(conexao.getStatement(), update);
                conexao.arquivaSQL();
            }
            if (!this.cancelarOperacao) {
                for (Sequence seq : sequences) {
                    this.mostraMensagem("Processando sequencia: " + seq.nome);
                    String sequencia = seq.nome;
                    buf.delete(0, buf.length());
                    buf.append("select relname from pg_class where upper(relname) = upper('").append(sequencia).append("') and relkind='S'");
                    rs = Conexao.executeQuery(st, buf);
                    if (!rs.next()) continue;
                    if (seq.usarFilial) {
                        sequencia = sequencia.substring(0, sequencia.indexOf("_")) + "_" + filialSelecionada + "_" + sequencia.substring(sequencia.indexOf("_") + 1);
                    }
                    buf.setLength(0);
                    buf.append("select max(").append(seq.campoChave).append(") as maximo ");
                    buf.append("from ").append(seq.tabela);
                    rs = conexao.executeQuery(stIntegracao, buf.toString());
                    if (!rs.next()) continue;
                    buf.setLength(0);
                    buf.append("select setval('").append(sequencia).append("', ");
                    buf.append(String.valueOf(rs.getInt("maximo") + 1));
                    buf.append(")");
                    conexao.executeQuery(stIntegracao, buf.toString());
                    if (this.cancelarOperacao) break;
                }
            }
            if (!this.cancelarOperacao && Funcoes.mensagem(this, "Deseja atualizar os par\u00e2metros gerais como sendo uma Filial de exporta\u00e7\u00e3o de dados?", 4) == 0) {
                conexao.executeUpdate(stIntegracao, "update parametros set par_tipointegracao = 'F', par_ipintegracao = '" + ParametrosLocais.getParametro("caminhoBanco") + "'");
            }
            if (!this.cancelarOperacao && ExportaWeb.isEnviarExamesParaWeb(stIntegracao, Variaveis.filialPadrao) && !this.filialInseridaNaWeb(stIntegracao, filialSelecionada) && Funcoes.mensagem(this, "A filial padr\u00e3o esta configurada para enviar exames para Internet.\nDeseja configurar a nova base para enviar como dependente?", 4) == 0) {
                conexao.executeUpdate(stIntegracao, "insert into filiaisweb(fil_codigo, fil_kodigo) values (" + Variaveis.filialPadrao + ", " + filialSelecionada + ")");
            }
            if (!this.cancelarOperacao && ((DadosIntegracaoFilial)this.comboFilial.getSelectedItem()).getUltimaIntegracaoGerada() > 0L && Funcoes.mensagem(this, "A filial que esta sendo criada j\u00e1 tem logs de integra\u00e7\u00e3o.\nDeseja corrigir os contadores de recebimento?", 4) == 0) {
                DadosIntegracaoFilial dados = (DadosIntegracaoFilial)this.comboFilial.getSelectedItem();
                conexao.executeUpdate(stIntegracao, "update filiais_postocoleta set fil_integracaogerada = '" + dados.getXmlUltimaIntegracaoRecebida() + "', fil_integracaorecebida = '" + dados.getXmlUltimaIntegracaoGerada() + "' where fil_codigo = " + String.valueOf(dados.getCodigo()));
                Conexao.executeUpdate(String.valueOf(dados.getCodigo()), st, "update logoffline set off_exportado = true where off_exportado = false and fil_coddestino = " + String.valueOf(dados.getCodigo()));
            }
            conexao.arquivaSQL();
            Conexao.arquivaSQL();
            Funcoes.mensagem(this, "Nova base criada com sucesso no endere\u00e7o: " + this.textServidorSecundario.getText(), 2);
        }
        catch (SQLException ex) {
            try {
                try {
                    conexao.anulaSQL();
                    Conexao.anulaSQL();
                    ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel executar o comando sql.\n" + ex.getMessage() + "\n" + comando, ex.getStackTrace());
                }
                catch (SQLException e) {
                    try {
                        conexao.anulaSQL();
                    }
                    catch (SQLException e1) {
                        ErrorLogger.mostraMensagem(this, ex.getMessage() + comando, ex.getStackTrace(), "NovaBase (307)");
                    }
                }
                ErrorLogger.mostraMensagem(this, ex.getMessage() + comando, ex.getStackTrace(), "NovaBase (307)");
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                conexao.fecharStatement(stIntegracao);
                conexao.shutdown();
                this.exportando = false;
                throw throwable;
            }
            Conexao.fecharStatement(st);
            conexao.fecharStatement(stIntegracao);
            conexao.shutdown();
            this.exportando = false;
        }
        Conexao.fecharStatement(st);
        conexao.fecharStatement(stIntegracao);
        conexao.shutdown();
        this.exportando = false;
        this.textServidorSecundario.setEnabled(true);
        ScreenUtil.requisitarFoco(this.textServidorSecundario);
        this.habilitarCampos(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean filialInseridaNaWeb(Statement st, int filial) {
        String sql = "select fil_kodigo from filiaisweb where fil_kodigo = " + filial;
        boolean retorno = false;
        ResultSet rs = null;
        try {
            rs = st.executeQuery(sql);
            retorno = rs.next();
        }
        catch (Exception exception) {
        }
        finally {
            Conexao.fecharResultSet(rs);
        }
        return retorno;
    }

    private void mostraMensagem(String mensagem) {
        MostraMensagem m = new MostraMensagem(this.textMensagens, this.scroll);
        m.escrever(mensagem);
    }

    private void constroiInsertUpdateDeTabelaComFilial(ResultSet rs, String tabela, Set<String> comandos, ConexaoIntegracao conexaoIntegracao, Set<String> chaves) throws SQLException {
        StringBuilder campos = new StringBuilder();
        StringBuilder valores = new StringBuilder();
        ResultSetMetaData rsd = rs.getMetaData();
        if (this.possuiRegistro(rs, tabela, conexaoIntegracao, chaves)) {
            this.constroiUpdateDeRegistro(rs, tabela, comandos, chaves);
        } else {
            campos.delete(0, campos.length());
            valores.delete(0, valores.length());
            campos.append("insert into ").append(tabela).append("(");
            valores.append(" values (");
            for (int i = 1; i <= rsd.getColumnCount(); ++i) {
                String nomeCampo = rsd.getColumnName(i);
                int tipoCampo = rsd.getColumnType(i);
                String valor = DBUtil.testaTipoCampo(rs.getObject(i), tipoCampo, true);
                valor = NovaBase.validaBarras(valor);
                campos.append(nomeCampo).append(i == rsd.getColumnCount() ? ")" : ",");
                valores.append(valor).append(i == rsd.getColumnCount() ? ")" : ",");
                if (!this.cancelarOperacao) continue;
                System.gc();
                return;
            }
            comandos.add(campos.toString() + valores.toString() + ";");
            if (this.cancelarOperacao) {
                System.gc();
                return;
            }
        }
    }

    private void constroiInsertUpdateTabelaSemFilial(ResultSet rs, String tabela, Set<String> comandos, ConexaoIntegracao conexaoIntegracao, Set<String> chaves) throws SQLException {
        StringBuilder campos = new StringBuilder();
        StringBuilder valores = new StringBuilder();
        if (this.possuiRegistro(rs, tabela, conexaoIntegracao, chaves)) {
            this.constroiUpdateDeRegistro(rs, tabela, comandos, chaves);
        } else {
            ResultSetMetaData rsd = rs.getMetaData();
            campos.delete(0, campos.length());
            valores.delete(0, valores.length());
            campos.append("insert into ").append(tabela).append("(");
            valores.append(" values (");
            for (int i = 1; i <= rsd.getColumnCount(); ++i) {
                String nomeCampo = rsd.getColumnName(i);
                int tipoCampo = rsd.getColumnType(i);
                String valor = DBUtil.testaTipoCampo(rs.getObject(i), tipoCampo, true);
                valor = NovaBase.validaBarras(valor);
                campos.append(nomeCampo).append(i == rsd.getColumnCount() ? ")" : ",");
                valores.append(valor).append(i == rsd.getColumnCount() ? ")" : ",");
                if (!this.cancelarOperacao) continue;
                System.gc();
                return;
            }
            comandos.add(campos.toString() + valores.toString() + ";");
        }
        if (comandos.size() % 100 == 0) {
            System.gc();
        }
        if (this.cancelarOperacao) {
            System.gc();
            return;
        }
    }

    private String constroiUpdateDeTabelaComFilial(ResultSet rs, String tabela, int filialSelecionada) throws SQLException {
        StringBuilder campos = new StringBuilder();
        ResultSetMetaData rsd = rs.getMetaData();
        campos.delete(0, campos.length());
        campos.append(" update ").append(tabela).append(" set ");
        for (int i = 1; i <= rsd.getColumnCount(); ++i) {
            String nomeCampo = rsd.getColumnName(i);
            int tipoCampo = rsd.getColumnType(i);
            String valor = DBUtil.testaTipoCampo(rs.getObject(i), tipoCampo, true);
            valor = NovaBase.validaBarras(valor);
            campos.append(nomeCampo).append("=");
            if (i == rsd.getColumnCount()) {
                campos.append(valor).append(" where fil_codigo = " + filialSelecionada + ";");
                continue;
            }
            campos.append(valor).append(",");
        }
        return campos.toString();
    }

    private void constroiUpdateDeRegistro(ResultSet rs, String tabela, Set<String> comandos, Set<String> chaves) throws SQLException {
        StringBuilder campos = new StringBuilder();
        ResultSetMetaData rsd = rs.getMetaData();
        campos.delete(0, campos.length());
        campos.append(" update ").append(tabela).append(" set ");
        for (int i = 1; i <= rsd.getColumnCount(); ++i) {
            String nomeCampo = rsd.getColumnName(i).trim();
            if (chaves.contains(nomeCampo) && i != rsd.getColumnCount()) continue;
            int tipoCampo = rsd.getColumnType(i);
            String valor = DBUtil.testaTipoCampo(rs.getObject(i), tipoCampo, true);
            valor = NovaBase.validaBarras(valor);
            campos.append(nomeCampo).append("=");
            if (i == rsd.getColumnCount()) {
                String valores;
                int c;
                campos.append(valor).append(" where ");
                if (!chaves.isEmpty()) {
                    int cont = 0;
                    for (c = 1; c <= rsd.getColumnCount(); ++c) {
                        String campo = rsd.getColumnName(c).trim();
                        int tipo = rsd.getColumnType(c);
                        valores = DBUtil.testaTipoCampo(rs.getObject(c), tipo, true);
                        valores = NovaBase.validaBarras(valores);
                        if (!chaves.contains(campo)) continue;
                        campos.append(campo).append("=").append(valores);
                        if (++cont == chaves.size()) continue;
                        campos.append(" and ");
                    }
                    continue;
                }
                HashMap<String, String> camposValores = new HashMap<String, String>();
                for (c = 1; c <= rsd.getColumnCount(); ++c) {
                    String campo = rsd.getColumnName(c);
                    int tipo = rsd.getColumnType(c);
                    valores = DBUtil.testaTipoCampo(rs.getObject(c), tipo, true);
                    valor = NovaBase.validaBarras(valor);
                    if (valores == null || Funcoes.textoVazio(valores) || valores.trim().equalsIgnoreCase("null")) continue;
                    camposValores.put(campo, valores);
                }
                Set keys = camposValores.keySet();
                int cont = 0;
                for (String key : keys) {
                    ++cont;
                    campos.append(key);
                    campos.append("=");
                    campos.append((String)camposValores.get(key));
                    campos.append(" ");
                    if (cont == keys.size()) continue;
                    campos.append(" and ");
                }
                continue;
            }
            campos.append(valor).append(",");
        }
        campos.append(";");
        if (rsd.getColumnCount() > chaves.size() && campos.toString().contains("where")) {
            comandos.add(campos.toString());
        }
    }

    private boolean possuiRegistro(ResultSet rs, String tabela, ConexaoIntegracao conexaoIntegracao, Set<String> chaves) throws SQLException {
        StringBuilder campos = new StringBuilder();
        ResultSetMetaData rsd = rs.getMetaData();
        HashMap<String, String> camposValores = new HashMap<String, String>();
        campos.append(" select count(1) as quantidade from ").append(tabela);
        for (int i = 1; i <= rsd.getColumnCount(); ++i) {
            String nomeCampo = rsd.getColumnName(i).trim();
            int tipoCampo = rsd.getColumnType(i);
            String valor = DBUtil.testaTipoCampo(rs.getObject(i), tipoCampo, true);
            if (Funcoes.textoVazio(valor = NovaBase.validaBarras(valor)) || valor.trim().equalsIgnoreCase("null") || !chaves.contains(nomeCampo)) continue;
            camposValores.put(nomeCampo, valor);
        }
        Set keys = camposValores.keySet();
        if (keys.size() > 0) {
            campos.append(" where ");
        }
        int cont = 0;
        for (String key : keys) {
            ++cont;
            campos.append(" ");
            campos.append(key);
            campos.append("=");
            campos.append((String)camposValores.get(key));
            if (cont == keys.size()) continue;
            campos.append(" and ");
        }
        ResultSet resultSetIntegracao = conexaoIntegracao.executeQuery(conexaoIntegracao.getStatement(), campos.toString());
        if (resultSetIntegracao.next() && resultSetIntegracao.getInt("quantidade") > 0) {
            resultSetIntegracao.close();
            return true;
        }
        resultSetIntegracao.close();
        return false;
    }

    private Set<String> chavesPrimariasTabela(String tabela, ConexaoIntegracao conexaoIntegracao) {
        HashSet<String> retorno = new HashSet<String>();
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT pg_get_constraintdef(pg_constraint.oid) AS definicao_da_restricao ");
        sql.append("  FROM pg_namespace JOIN pg_class ON pg_namespace.oid=pg_class.relnamespace ");
        sql.append("  JOIN pg_constraint ON pg_class.oid=pg_constraint.conrelid ");
        sql.append(" WHERE pg_class.relname='");
        sql.append(tabela);
        sql.append("' ");
        sql.append(" AND pg_class.relkind='r' ");
        sql.append(" ORDER BY pg_class.relname;");
        try {
            ResultSet rsChaves = conexaoIntegracao.executeQuery(conexaoIntegracao.getStatement(), sql.toString());
            if (rsChaves.next()) {
                String[] chavesArray;
                String chaves = rsChaves.getString("definicao_da_restricao").toLowerCase();
                chaves = chaves.replaceAll("primary", "").trim();
                chaves = chaves.replaceAll("key", "").trim();
                chaves = chaves.replaceAll("\\)", "").trim();
                chaves = chaves.replaceAll("\\(", "").trim();
                for (String chave : chavesArray = chaves.split(",")) {
                    retorno.add(chave.trim());
                }
                return retorno;
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
        }
        return retorno;
    }

    private boolean possuiFilial(int codigoFilial, ConexaoIntegracao conexaoIntegracao) throws SQLException {
        StringBuilder campos = new StringBuilder();
        campos.append(" select count(1) as quantidade from filiais_postocoleta where fil_codigo = ").append(codigoFilial);
        ResultSet resultSetIntegracao = conexaoIntegracao.executeQuery(conexaoIntegracao.getStatement(), campos.toString());
        if (resultSetIntegracao.next() && resultSetIntegracao.getInt("quantidade") > 0) {
            resultSetIntegracao.close();
            return true;
        }
        resultSetIntegracao.close();
        return false;
    }

    private static String validaBarras(String valor) {
        StringBuilder bui = new StringBuilder();
        for (int k = 0; k < valor.length(); ++k) {
            char c = valor.charAt(k);
            if (c == '\\') {
                bui.append("\\");
            }
            bui.append(c);
        }
        return bui.toString();
    }

    class Sequence {
        protected String nome;
        protected String tabela;
        protected boolean usarFilial = false;
        protected String campoChave;

        public Sequence(String nome, String tabela, String campoChave, boolean usarFilial) {
            this.nome = nome;
            this.tabela = tabela;
            this.campoChave = campoChave;
            this.usarFilial = usarFilial;
        }
    }

    class MostraMensagem
    extends Thread {
        private JTextArea text;
        private JScrollPane scroll;

        public MostraMensagem(JTextArea txt, JScrollPane scroll) {
            super("MostraMensagem - thread");
            this.text = null;
            this.scroll = null;
            this.text = txt;
            this.scroll = scroll;
        }

        public void escrever(String mensagem) {
            this.text.append(mensagem + "\n");
            this.start();
        }

        @Override
        public void run() {
            this.text.revalidate();
            this.text.repaint();
            this.scroll.repaint();
            this.text.setCaretPosition(this.text.getDocument().getLength());
        }
    }
}

