/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.exportacao.integracao;

import jalis.comum.ConexaoTemporaria;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.integracao.servidor.GZipException;
import jalis.integracao.servidor.Servidor2;
import jalis.laboratorio.exportacao.integracao.DadosIntegracaoFilial;
import jalis.laboratorio.exportacao.integracao.IntegracaoException;
import jalis.laboratorio.exportacao.thread.ExportaWeb;
import jalis.util.ArraysUtil;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.TreeSet;
import java.util.zip.DataFormatException;
import javax.swing.JProgressBar;

public class IntegracaoUtil {
    private static final int TEMPO_AGUARDAR_ENTRE_COMANDO = 50;
    private static final int TAMANHO_ARQUIVO_ONLINE = 2000000;
    public static final VersaoXML VERSAO_ARQUIVO = VersaoXML.VERSAO_2_0_0;
    public static final String CAMPO_VERSAO = "versao";
    public static final String CAMPO_ARQUIVO = "arquivo";
    public static final String CAMPO_LOG = "log";
    public static final String CAMPO_DATA = "data";
    public static final String CAMPO_FILIAL = "filial";
    public static final String CAMPO_LOG_CODIGO = "codigo";
    public static final String CAMPO_LOG_OPERACAO = "operacao";
    public static final String CAMPO_LOG_DESTINO = "destino";
    public static final String CAMPO_LOG_ORIGEM = "origem";
    public static final String CAMPO_LOG_USUARIO = "usuario";
    public static final String CAMPO_LOG_DATA = "datalog";
    public static final String CAMPO_ERRO_AO_IMPORTAR_ARQUIVO = "erroImportacao";
    private static final boolean debug = Funcoes.arquivoExiste(System.getProperty("user.home") + "/debug.jalis");
    private static final String TAG_INTEGRACOES = "integracoes";
    private static final String TAG_FILIAL = "filial";
    private static final String TAG_CODIGO = "codigo";
    private static final String TAG_SEQUENCIA = "sequencia";
    private static final String TAG_DATA_HORA = "datahora";

    public static void removeLogsAntigos(Statement st) throws SQLException {
    }

    public static Registro[] getLogParaEnviar(Statement st, String filialDestino) throws SQLException {
        return IntegracaoUtil.getLogParaEnviar(st, filialDestino, null, 0);
    }

    public static Registro[] getLogParaEnviar(Statement st, String filialDestino, Long codigoArquivoAnterior) throws SQLException {
        return IntegracaoUtil.getLogParaEnviar(st, filialDestino, codigoArquivoAnterior, 0);
    }

    public static Registro[] getLogParaEnviar(Statement st, String filialDestino, Long codigoArquivoAnterior, int qtde) throws SQLException {
        Registro r;
        StringBuilder buf = new StringBuilder();
        buf.append(" select fil_codigo, fil_coddestino, off_operacao, off_codigo ");
        buf.append("   from logoffline ");
        buf.append("  where fil_coddestino = ").append(filialDestino);
        if (codigoArquivoAnterior == null) {
            buf.append(" and off_exportado = false ");
        } else {
            buf.append(" and off_codigoarquivo = ").append(codigoArquivoAnterior);
        }
        buf.append(" order by off_codigo ");
        if (qtde > 0) {
            buf.append(" limit ").append(qtde);
        }
        ResultSet rs = ConexaoTemporaria.executeQuery(st, buf);
        ArrayList<Registro> temp = new ArrayList<Registro>();
        int qtdeCaracteres = 0;
        for (int somaQtde = 0; rs.next() && (qtde == 0 || qtde > 0 && somaQtde <= qtde || qtdeCaracteres < 2000000); qtdeCaracteres += r.getString("off_operacao").length(), ++somaQtde) {
            r = new Registro(rs);
            temp.add(r);
        }
        return temp.toArray(new Registro[temp.size()]);
    }

    public static String geraArquivoFaltante(String path, String filial, Long codigoArquivo) throws Exception {
        StringBuilder buf = new StringBuilder();
        buf.append(" select fil_codigo ");
        buf.append("       ,fil_coddestino ");
        buf.append("       ,off_operacao ");
        buf.append("       ,off_codigo ");
        buf.append("   from logoffline ");
        buf.append("  where fil_coddestino = ").append(filial);
        buf.append("    and off_codigoarquivo = ").append(codigoArquivo);
        buf.append("  order by off_codigo ");
        Statement st = ConexaoTemporaria.getStatement();
        ResultSet rs = ConexaoTemporaria.executeQuery(st, buf);
        Integer primeiroLog = null;
        ArrayList<Registro> lista = new ArrayList<Registro>();
        while (rs.next()) {
            if (primeiroLog == null) {
                primeiroLog = rs.getInt("off_codigo");
            }
            lista.add(new Registro(rs));
        }
        boolean arquivoOk = false;
        if (lista.size() > 0) {
            StringBuilder corpo = new StringBuilder();
            for (Registro registro : lista) {
                if (Servidor2.getListaIgnorarFiliais() != null && Servidor2.getListaIgnorarFiliais().contains(filial) && registro.getString("fil_codigo").equals(filial) && registro.getString("off_operacao").contains("exportaweb")) {
                    registro.substituirValor("off_operacao", "");
                }
                String aux = IntegracaoUtil.registroParaTexto(registro);
                if (corpo.length() > 0) {
                    corpo.append(",");
                }
                corpo.append(aux);
            }
            String charset = StringUtil.getCharsetIntegracao(ParametrosLocais.getParametro("codificacaoIntegracaoOffline"));
            XMLStringBuilder xml = new XMLStringBuilder();
            xml.abrir("integracao");
            xml.escrever(CAMPO_VERSAO, VERSAO_ARQUIVO.toString());
            xml.escrever(CAMPO_ARQUIVO, String.valueOf(codigoArquivo));
            xml.escrever("filial", String.valueOf(filial));
            xml.escrever(CAMPO_LOG, String.valueOf(primeiroLog));
            String texto = StringUtil.tratarEntidadesHTML(corpo.toString(), false);
            texto = StringUtil.tratarUnicode(texto);
            texto = StringUtil.compactar(corpo.toString(), 9, charset);
            xml.escrever(CAMPO_DATA, texto);
            xml.fechar("integracao");
            String arquivo = ParametrosGerais.getTipoIntegracao() + Funcoes.preencheZero(String.valueOf(filial), 3) + Funcoes.preencheZero(codigoArquivo, 8) + ".thi";
            if (texto == null || Funcoes.textoVazio(texto)) {
                System.out.println("N\u00e3o h\u00e1 dados para gerar o arquivo: \"" + arquivo + "\". O processo de gera\u00e7\u00e3o ser\u00e1 abortado.");
            } else if (!StringUtil.escreverArquivoTexto(path + "enviados" + Servidor2.SEPARADOR + arquivo, xml.getXML(), charset)) {
                System.out.println("N\u00e3o foi poss\u00edvel criar o arquivo para envio da integra\u00e7\u00e3o, comunica\u00e7\u00e3o interrompida");
            } else {
                return arquivo;
            }
        }
        if (!arquivoOk) {
            String nomeI = ParametrosGerais.getTipoIntegracao() + Funcoes.preencheZero(String.valueOf(filial), 3) + Funcoes.preencheZero(codigoArquivo, 8) + ".thi";
            File arquivoI = new File(path + "enviados" + Servidor2.SEPARADOR + nomeI);
            if (arquivoI.exists()) {
                return nomeI;
            }
            String nomeW = ParametrosGerais.getTipoIntegracao() + Funcoes.preencheZero(String.valueOf(filial), 3) + Funcoes.preencheZero(codigoArquivo, 8) + ".thw";
            File arquivoW = new File(path + "enviados" + Servidor2.SEPARADOR + nomeW);
            if (arquivoW.exists()) {
                System.gc();
                if (arquivoW.renameTo(arquivoI)) {
                    return nomeW;
                }
                return null;
            }
            return null;
        }
        return null;
    }

    public static DadosIntegracaoFilial[] buscaFiliais(Statement st) throws SQLException {
        return IntegracaoUtil.buscaFiliais(st, false);
    }

    public static DadosIntegracaoFilial[] buscaFiliais(Statement st, boolean contarLogsParaEnviar) throws SQLException {
        ResultSet rs = ConexaoTemporaria.executeQuery(st, "select fil_codigo, fil_descricao, fil_integrar, fil_integracaogerada, fil_integracaorecebida, fil_logintegracaorecebido from filiais_postocoleta order by fil_codigo");
        ArrayList<DadosIntegracaoFilial> temp = new ArrayList<DadosIntegracaoFilial>();
        while (rs.next()) {
            temp.add(new DadosIntegracaoFilial(rs.getInt("fil_codigo"), rs.getString("fil_descricao"), rs.getBoolean("fil_integrar"), IntegracaoUtil.parseUltimaIntegracao(rs.getString("fil_integracaogerada"), rs.getString("fil_codigo")), IntegracaoUtil.parseUltimaIntegracao(rs.getString("fil_integracaorecebida"), rs.getString("fil_codigo")), IntegracaoUtil.parseUltimaIntegracao(rs.getString("fil_logintegracaorecebido"), rs.getString("fil_codigo")), rs.getString("fil_integracaogerada"), rs.getString("fil_integracaorecebida"), rs.getString("fil_logintegracaorecebido")));
        }
        if (contarLogsParaEnviar && temp.size() > 0) {
            StringBuilder b = new StringBuilder();
            for (DadosIntegracaoFilial f : temp) {
                b.setLength(0);
                b.append("select count(off_codigo) from logoffline where off_exportado = false ");
                b.append(" and fil_coddestino = ").append(f.getCodigo());
                rs = ConexaoTemporaria.executeQuery(st, b);
                if (!rs.next()) continue;
                f.setLogsParaEnviar(rs.getInt(1));
            }
        }
        return temp.toArray(new DadosIntegracaoFilial[temp.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DadosIntegracaoFilial buscaDadosFilial(Statement st, String filial) throws SQLException {
        DadosIntegracaoFilial retorno = null;
        try (ResultSet rs = null;){
            rs = st.executeQuery("select fil_codigo, fil_descricao, fil_integrar, fil_integracaogerada, fil_integracaorecebida, fil_logintegracaorecebido from filiais_postocoleta where fil_codigo = " + filial);
            if (rs.next()) {
                retorno = new DadosIntegracaoFilial(rs.getInt("fil_codigo"), rs.getString("fil_descricao"), rs.getBoolean("fil_integrar"), IntegracaoUtil.parseUltimaIntegracao(rs.getString("fil_integracaogerada"), rs.getString("fil_codigo")), IntegracaoUtil.parseUltimaIntegracao(rs.getString("fil_integracaorecebida"), rs.getString("fil_codigo")), IntegracaoUtil.parseUltimaIntegracao(rs.getString("fil_logintegracaorecebido"), rs.getString("fil_codigo")), rs.getString("fil_integracaogerada"), rs.getString("fil_integracaorecebida"), rs.getString("fil_logintegracaorecebido"));
            }
        }
        return retorno;
    }

    public static String xmlParaEnviar(Statement st, int filial, long codigoIntegracao, long codigoPrimeiroLog, String texto, BufferedWriter log) throws XMLStringBuilderException, SQLException, IOException {
        long primeiroLog = codigoPrimeiroLog;
        Servidor2.mensagemLog("Buscando ultimo log para filial " + filial + ".", true, String.valueOf(filial));
        StringBuilder buf = new StringBuilder("select max(off_codigo) as maximo from logoffline ");
        buf.append("where fil_coddestino = ").append(filial);
        buf.append(" and off_codigo < ").append(codigoPrimeiroLog);
        ResultSet rs = ConexaoTemporaria.executeQuery(st, buf);
        if (rs.next() && rs.getLong("maximo") + 1L != codigoPrimeiroLog) {
            primeiroLog = rs.getLong("maximo") + 1L;
        }
        Servidor2.mensagemLog("Gerando arquivo xml para filial " + filial + ".", true, String.valueOf(filial));
        XMLStringBuilder xml = new XMLStringBuilder();
        xml.abrir("integracao");
        xml.escrever(CAMPO_VERSAO, VERSAO_ARQUIVO.toString());
        xml.escrever(CAMPO_ARQUIVO, String.valueOf(codigoIntegracao));
        xml.escrever("filial", String.valueOf(filial));
        xml.escrever(CAMPO_LOG, String.valueOf(primeiroLog));
        xml.escrever(CAMPO_DATA, StringUtil.compactar(texto));
        xml.fechar("integracao");
        return xml.getXML();
    }

    public static String xmlParaEnviarPorTamanho(Statement st, int filial, long codigoIntegracao, long codigoPrimeiroLog, String texto, BufferedWriter log) throws XMLStringBuilderException, SQLException, IOException {
        long primeiroLog = codigoPrimeiroLog;
        Servidor2.mensagemLog("Buscando ultimo log para filial " + filial + ".", true, String.valueOf(filial));
        StringBuilder buf = new StringBuilder();
        buf.append(" select max(off_codigo) as maximo ");
        buf.append("   from logoffline ");
        buf.append("  where fil_coddestino = ").append(filial);
        buf.append("    and off_codigo < ").append(codigoPrimeiroLog);
        ResultSet rs = ConexaoTemporaria.executeQuery(st, buf);
        if (rs.next() && rs.getLong("maximo") + 1L != codigoPrimeiroLog) {
            primeiroLog = rs.getLong("maximo") + 1L;
        }
        Servidor2.mensagemLog("Gerando arquivo xml para filial " + filial + ".", true, String.valueOf(filial));
        XMLStringBuilder xml = new XMLStringBuilder();
        xml.abrir("integracao");
        xml.escrever(CAMPO_VERSAO, VERSAO_ARQUIVO.toString());
        xml.escrever(CAMPO_ARQUIVO, String.valueOf(codigoIntegracao));
        xml.escrever("filial", String.valueOf(filial));
        xml.escrever(CAMPO_LOG, String.valueOf(primeiroLog));
        texto = StringUtil.tratarEntidadesHTML(texto, false);
        xml.escrever(CAMPO_DATA, StringUtil.compactar(texto));
        xml.fechar("integracao");
        return xml.getXML();
    }

    public static String registroParaTexto(Registro registro) throws XMLStringBuilderException {
        if (registro == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        buf.append("<registro>");
        buf.append(StringUtil.getTag("codigo", String.valueOf(registro.getInt("off_codigo"))));
        buf.append(StringUtil.getTag(CAMPO_LOG_OPERACAO, registro.getString("off_operacao")));
        buf.append(StringUtil.getTag(CAMPO_LOG_DESTINO, String.valueOf(registro.getInt("fil_coddestino"))));
        buf.append(StringUtil.getTag(CAMPO_LOG_USUARIO, registro.getString("usr_codigo")));
        buf.append(StringUtil.getTag(CAMPO_LOG_DATA, registro.getString("off_datahora")));
        buf.append("</registro>");
        return buf.toString();
    }

    public static String registroParaTexto(Registro[] registros, JProgressBar progresso, BufferedWriter log) throws XMLStringBuilderException {
        if (registros == null || registros.length == 0) {
            return "";
        }
        if (progresso != null) {
            progresso.setMaximum(registros.length);
            progresso.setValue(0);
        }
        boolean i = false;
        StringBuilder buf = new StringBuilder();
        Servidor2.mensagemLog("Convertendo " + String.valueOf(registros.length) + " para texto...", true, null);
        int iii = 1;
        for (Registro r : registros) {
            buf.append("<registro>");
            buf.append(StringUtil.getTag("codigo", String.valueOf(r.getInt("off_codigo"))));
            buf.append(StringUtil.getTag(CAMPO_LOG_OPERACAO, r.getString("off_operacao")));
            buf.append(StringUtil.getTag(CAMPO_LOG_DESTINO, String.valueOf(r.getInt("fil_coddestino"))));
            buf.append(StringUtil.getTag(CAMPO_LOG_ORIGEM, String.valueOf(r.getInt("fil_codigo"))));
            buf.append("</registro>");
            if (progresso == null) continue;
            progresso.setValue(progresso.getValue() + 1);
        }
        Servidor2.mensagemLog("Executando gc() no fim da exporta\u00e7\u00e3o dos registros", true, null);
        Servidor2.mensagemLog(String.valueOf(buf.length() / 1024) + "Kb convertidos (" + String.valueOf(iii) + " registros)", true, null);
        return buf.toString();
    }

    public static Registro arquivoRecebidoParaRegistro(String texto, String charset) throws GZipException, DataFormatException {
        if (texto == null || Funcoes.textoVazio(texto) || Funcoes.textoVazio(StringUtil.getValor(texto, "integracao"))) {
            return null;
        }
        Registro registro = new Registro();
        String versao = StringUtil.getValor(texto, CAMPO_VERSAO);
        registro.setValor(CAMPO_VERSAO, versao);
        registro.setValor(CAMPO_ARQUIVO, StringUtil.getValor(texto, CAMPO_ARQUIVO));
        registro.setValor(CAMPO_LOG, StringUtil.getValor(texto, CAMPO_LOG));
        registro.setValor("filial", StringUtil.getValor(texto, "filial"));
        String data = "";
        data = StringUtil.descompactar(VersaoXML.getVersaoXML(versao), StringUtil.getValor(texto, CAMPO_DATA), charset);
        String[] tmp = StringUtil.getValores(data, "registro");
        int posicao = 0;
        Registro[] registros = new Registro[tmp.length];
        for (String s : tmp) {
            Registro r = new Registro();
            r.setValor("codigo", StringUtil.getValor(s, "codigo"));
            r.setValor(CAMPO_LOG_OPERACAO, StringUtil.getValor(s, CAMPO_LOG_OPERACAO, false, null, false));
            r.setValor(CAMPO_LOG_ORIGEM, StringUtil.getValor(s, CAMPO_LOG_ORIGEM));
            r.setValor(CAMPO_LOG_DESTINO, StringUtil.getValor(s, CAMPO_LOG_DESTINO));
            registros[posicao++] = r;
        }
        registro.setValor(CAMPO_DATA, registros);
        return registro;
    }

    public static void insereComandoLog(Statement st, String filialOrigem, String filialDestino, String sql) throws SQLException {
        String sequencia = DBUtil.getSequencia(st, "logoffline", filialDestino);
        StringBuilder buf = new StringBuilder("insert into logoffline(fil_codigo, fil_coddestino, off_operacao, off_codigo) values (");
        buf.append(filialOrigem).append(", ");
        buf.append(filialDestino).append(", ");
        buf.append(StringUtil.textoDBEscape(sql)).append(", ");
        buf.append(sequencia).append(") ");
        st.execute(buf.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isFilialParaIntegrar(Statement st, String filial) throws SQLException {
        if (st == null || Funcoes.textoVazio(filial)) {
            return false;
        }
        StringBuilder buf = new StringBuilder("select fil_integrar from filiais_postocoleta where fil_codigo = ");
        buf.append(filial);
        boolean result = false;
        try (ResultSet rs = null;){
            rs = st.executeQuery(buf.toString());
            result = rs.next() && rs.getBoolean("fil_integrar");
        }
        return result;
    }

    public static String formataCodigoRequisicao(String filial, String codigo, Statement st) {
        return IntegracaoUtil.formataCodigoRequisicao(filial, codigo, st, ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboRequisicao());
    }

    public static String formataCodigoRequisicao(String filial, String codigo, Statement st, int digitosTuboFilial, int digitosTuboRequisicao) {
        String retorno = codigo;
        try {
            if (Variaveis.exportarWebFilial && ExportaWeb.isBaseWebAgrupada(st, filial) && Funcoes.isNumeric(filial) && Funcoes.isNumeric(codigo)) {
                retorno = Funcoes.preencheZero(filial, digitosTuboFilial) + Funcoes.preencheZero(codigo, digitosTuboRequisicao);
            }
        }
        catch (SQLException ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "IntegracaoUtil (271)");
        }
        return retorno;
    }

    public static long parseUltimaIntegracao(String xml, String filial) {
        String integracoes;
        long retorno = 0L;
        if (!Funcoes.textoVazio(xml) && !Funcoes.textoVazio(integracoes = StringUtil.getValor(xml, TAG_INTEGRACOES))) {
            String[] filiais;
            for (String s : filiais = StringUtil.getValores(integracoes, "filial")) {
                String codigo = StringUtil.getValor(s, "codigo");
                String sequencia = StringUtil.getValor(s, TAG_SEQUENCIA);
                if (!codigo.equalsIgnoreCase(filial) || !Funcoes.isNumeric(sequencia)) continue;
                retorno = Long.parseLong(sequencia);
                break;
            }
        }
        return retorno;
    }

    public static String atualizarXMLUltimaIntegracao(String xmlAtual, String filial, String novoCodigo) throws XMLStringBuilderException {
        String integracoes;
        XMLStringBuilder xml = new XMLStringBuilder();
        xml.abrir(TAG_INTEGRACOES);
        boolean adicionado = false;
        if (!Funcoes.textoVazio(xmlAtual) && !Funcoes.textoVazio(integracoes = StringUtil.getValor(xmlAtual, TAG_INTEGRACOES))) {
            String[] filiais;
            for (String s : filiais = StringUtil.getValores(integracoes, "filial")) {
                String codigo = StringUtil.getValor(s, "codigo");
                String sequencia = StringUtil.getValor(s, TAG_SEQUENCIA);
                xml.abrir("filial");
                xml.escrever("codigo", codigo);
                if (codigo.equalsIgnoreCase(filial)) {
                    adicionado = true;
                    xml.escrever(TAG_SEQUENCIA, novoCodigo);
                } else {
                    xml.escrever(TAG_SEQUENCIA, sequencia);
                }
                xml.escrever(TAG_DATA_HORA, Funcoes.formataData("dd/MM/yyyy HH:mm:ss", new Date()));
                xml.fechar("filial");
            }
        }
        if (!adicionado) {
            xml.abrir("filial");
            xml.escrever("codigo", filial);
            xml.escrever(TAG_SEQUENCIA, novoCodigo);
            xml.escrever(TAG_DATA_HORA, Funcoes.formataData("dd/MM/yyyy HH:mm:ss", new Date()));
            xml.fechar("filial");
        }
        xml.fechar(TAG_INTEGRACOES);
        return xml.getXML();
    }

    public static String[] filiaisParaIntegrar(Statement st) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append("select fil_codigo from filiais_postocoleta where fil_integrar = true order by fil_codigo");
        ResultSet rs = ConexaoTemporaria.executeQuery(st, buf);
        ArrayList<String> temp = new ArrayList<String>();
        while (rs.next()) {
            temp.add(rs.getString("fil_codigo"));
        }
        return temp.toArray(new String[temp.size()]);
    }

    public static void pesquisaArquivosNaoEnviadosAutomatico(String tipoIntegracao, String filial, String path, ArrayList<String> arquivos) {
        File diretorio = new File(path);
        String[] lista = null;
        if (diretorio.isDirectory() && (lista = diretorio.list()) != null) {
            for (String s : lista) {
                if (s.length() < 16 || (!s.startsWith(tipoIntegracao + Funcoes.preencheZero(filial, 3)) || !s.endsWith(".thw")) && (!s.startsWith(tipoIntegracao + Funcoes.preencheZero(filial, 3)) || !s.endsWith(".rdw"))) continue;
                arquivos.add(s);
            }
        }
        if (arquivos.size() > 0) {
            Collections.sort(arquivos, new Comparator(){

                public int compare(Object o1, Object o2) {
                    if (o2.toString().endsWith(".rdw")) {
                        return 1;
                    }
                    String primeiro = "";
                    String segundo = "";
                    if (o1 instanceof String) {
                        primeiro = o1.toString().substring(o1.toString().length() - 16);
                    }
                    if (o2 instanceof String) {
                        segundo = o2.toString().substring(o1.toString().length() - 16);
                    }
                    return primeiro.length() > 12 && Funcoes.isNumeric(primeiro.substring(5, 12)) && segundo.length() > 12 && Funcoes.isNumeric(segundo.substring(5, 12)) && Long.parseLong(primeiro.substring(5, 12)) > Long.parseLong(segundo.substring(5, 12)) ? 1 : 0;
                }
            });
        }
    }

    public static void removeArquivosAntigosIntegrados(String filial, String path, long ultimoArquivoRecebido, long ultimoArquivoEnviado, boolean isServidor) {
        File arquivo;
        Integer codigoArquivo;
        if (Servidor2.debug) {
            System.out.println("Removendo arquivos enviados j\u00e1 integrados. \u00dalt. Enviado: " + ultimoArquivoEnviado + ", \u00dalt. Recebido: " + ultimoArquivoRecebido);
        }
        String pathAux = path + "enviados";
        if (Servidor2.debug) {
            System.out.println("Enviados: " + pathAux);
        }
        File diretorio = new File(pathAux);
        String[] lista = null;
        if (diretorio.isDirectory() && (lista = diretorio.list()) != null) {
            for (String s : lista) {
                if (Servidor2.debug) {
                    System.out.println("Removendo arquivos enviados: " + s);
                }
                if (s.length() < 16 || !s.startsWith(!isServidor ? "F" : "M" + Funcoes.preencheZero(filial, 3)) || !s.endsWith(".thi")) continue;
                codigoArquivo = Integer.parseInt(s.substring(4, 12));
                if (Servidor2.debug) {
                    System.out.println("C\u00f3digo arquivo: " + codigoArquivo + ", limite: " + (ultimoArquivoEnviado - 1000L));
                }
                if ((long)codigoArquivo.intValue() >= ultimoArquivoEnviado - 1000L) continue;
                arquivo = new File(pathAux + Servidor2.SEPARADOR + s);
                if (arquivo.delete()) {
                    if (!Servidor2.debug) continue;
                    System.out.println("Arquivo \"" + s + "\" removido com sucesso.");
                    continue;
                }
                System.out.println(" O arquivo \"" + s + "\" n\u00e3o p\u00f4de ser removido.");
            }
        }
        if (Servidor2.debug) {
            System.out.println("Removendo arquivos importados j\u00e1 integrados.");
        }
        pathAux = path + "importados";
        if (Servidor2.debug) {
            System.out.println("Importados: " + pathAux);
        }
        diretorio = new File(pathAux);
        lista = null;
        if (diretorio.isDirectory() && (lista = diretorio.list()) != null) {
            for (String s : lista) {
                if (Servidor2.debug) {
                    System.out.println("Removendo arquivos importados: " + s);
                }
                if (s.length() < 16) continue;
                if (s.startsWith((!isServidor ? "M" : "F") + Funcoes.preencheZero(filial, 3)) && s.endsWith(".thi")) {
                    codigoArquivo = Integer.parseInt(s.substring(4, 12));
                    if (Servidor2.debug) {
                        System.out.println("C\u00f3digo arquivo: " + codigoArquivo + ", limite: " + (ultimoArquivoRecebido - 1000L));
                    }
                    if ((long)codigoArquivo.intValue() >= ultimoArquivoRecebido - 1000L) continue;
                    arquivo = new File(pathAux + Servidor2.SEPARADOR + s);
                    if (arquivo.delete()) {
                        if (!Servidor2.debug) continue;
                        System.out.println("Arquivo \"" + s + "\" removido com sucesso.");
                        continue;
                    }
                    System.out.println(" O arquivo \"" + pathAux + Servidor2.SEPARADOR + s + "\" n\u00e3o p\u00f4de ser removido.");
                    continue;
                }
                if (!Servidor2.debug) continue;
                System.out.println("O arquivo " + s + " n\u00e3o deve ser removido.");
            }
        }
    }

    public static void removeLogsAntigosIntegrados(String filial, long ultimoArquivoEnviado, boolean isServidor) throws Exception {
        Statement st = ConexaoTemporaria.getStatement();
        long codigoAux = ultimoArquivoEnviado - 1000L;
        StringBuilder buf = new StringBuilder();
        buf.append(" delete from logoffline ");
        buf.append("  where off_codigoarquivo < ").append(codigoAux);
        buf.append("    and off_exportado ");
        if (isServidor) {
            buf.append("  and fil_coddestino = ").append(filial);
        } else {
            buf.append("  and fil_codigo = ").append(filial);
        }
        int qtde = 0;
        try {
            qtde = ConexaoTemporaria.executeUpdate(Variaveis.filialPadrao, st, buf.toString(), true);
            ConexaoTemporaria.arquivaSQL();
        }
        catch (SQLException e) {
            throw new Exception(ConexaoTemporaria.getUltimoComando() + "\n" + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processaVersao100(Registro[] registros, Statement st, DadosIntegracaoFilial filial, String sequencialArquivo, JProgressBar progresso, Integer registroAtual) throws Exception {
        block46: {
            String codigoLogErro = "";
            int contadorComandosExecutados = 0;
            int tamanhoOriginal = registros.length;
            if (registroAtual == null) {
                registroAtual = 0;
            }
            try {
                long ultimo = 0L;
                if (progresso != null) {
                    progresso.setMaximum(registros.length);
                    progresso.setValue(0);
                }
                IntegracaoUtil.insereOIDUsuarioConectado(1);
                for (int i = registroAtual.intValue(); i < registros.length; ++i) {
                    String codigoLog;
                    registroAtual = i;
                    Registro r = registros[i];
                    codigoLogErro = codigoLog = r.getString("codigo");
                    String comando = r.getString(CAMPO_LOG_OPERACAO);
                    String comandoLowerCase = comando.toLowerCase();
                    IntegracaoUtil.setUsuarioDataIntegracao(r.getString(CAMPO_LOG_USUARIO), r.getString(CAMPO_LOG_DATA));
                    if (Long.parseLong(codigoLog) > ultimo) {
                        ultimo = Long.parseLong(codigoLog);
                    }
                    if (comandoLowerCase.indexOf("insert") > -1 || comandoLowerCase.indexOf("update") > -1 && comandoLowerCase.indexOf("examespardini") > -1) {
                        boolean executar;
                        block44: {
                            executar = true;
                            String comandoUpdate = "";
                            if (comandoLowerCase.indexOf("insert") > -1) {
                                try {
                                    String select = IntegracaoUtil.converteInsertParaSelect(st, comando, new String[]{"examerequisicaosituacoes", "exportaweb", "logsms"});
                                    if (Funcoes.textoVazio(select)) break block44;
                                    try (ResultSet rs = null;){
                                        rs = Servidor2.getConexaoIntegracao(String.valueOf(filial.getCodigo())).executeQuery(st, select);
                                        boolean bl = executar = !rs.next();
                                        if (!executar && !Funcoes.textoVazio(comandoUpdate = IntegracaoUtil.converteInsertParaUpdate(st, comando, new String[]{"examerequisicaosituacoes", "exportaweb"}))) {
                                            Servidor2.getConexaoIntegracao(String.valueOf(filial.getCodigo())).executeUpdate(st, new StringBuilder(comandoUpdate));
                                        }
                                    }
                                }
                                catch (Exception ex) {
                                    System.out.println(ex.getMessage());
                                }
                            }
                        }
                        if (executar || comandoLowerCase.indexOf("usuariomensagem") > -1) {
                            block45: {
                                String novoTexto;
                                String paraCorrigir;
                                int posicaoFinal;
                                StringBuilder buf;
                                if (comandoLowerCase.indexOf("examesdb") > -1) {
                                    buf = new StringBuilder(comando);
                                    if (buf.indexOf("<ds_exame>") > -1) {
                                        int posicaoInicial = buf.indexOf("<ds_exame>");
                                        posicaoFinal = buf.indexOf("</ds_exame>");
                                        paraCorrigir = buf.substring(posicaoInicial + 9, posicaoFinal);
                                        paraCorrigir = StringUtil.tratarUnicode(paraCorrigir, true);
                                        buf.delete(posicaoInicial + 9, posicaoFinal);
                                        buf.insert(posicaoInicial + 9, paraCorrigir);
                                        comando = buf.toString();
                                    }
                                    if ((buf = new StringBuilder(comando)).indexOf("<valorRef>") > -1) {
                                        int posicaoInicial = buf.indexOf("<valorRef>");
                                        posicaoFinal = buf.indexOf("</valorRef>");
                                        paraCorrigir = buf.substring(posicaoInicial + 9, posicaoFinal);
                                        paraCorrigir = StringUtil.tratarUnicode(paraCorrigir, true);
                                        buf.delete(posicaoInicial + 9, posicaoFinal);
                                        buf.insert(posicaoInicial + 9, paraCorrigir);
                                        comando = buf.toString();
                                    }
                                    buf.setLength(0);
                                    buf.trimToSize();
                                    buf = null;
                                }
                                if (comandoLowerCase.indexOf("examespardini") > -1) {
                                    buf = new StringBuilder(comando);
                                    if (buf.toString().toLowerCase().indexOf("<superexame>") > -1) {
                                        int posicaoInicial = buf.toString().toLowerCase().indexOf("<superexame>");
                                        posicaoFinal = buf.toString().toLowerCase().indexOf("</superexame>");
                                        paraCorrigir = buf.substring(posicaoInicial + 12, posicaoFinal);
                                        novoTexto = "";
                                        for (char c : paraCorrigir.toCharArray()) {
                                            novoTexto = novoTexto + StringUtil.tratarUnicode(c, true);
                                        }
                                        buf.delete(posicaoInicial + 12, posicaoFinal);
                                        buf.insert(posicaoInicial + 12, novoTexto);
                                        comando = buf.toString();
                                    }
                                    buf.setLength(0);
                                    buf.trimToSize();
                                    buf = null;
                                }
                                if (comandoLowerCase.indexOf("examesalvaro") > -1) {
                                    buf = new StringBuilder(comando);
                                    if (buf.indexOf("<valor_referencia>") > -1) {
                                        int posicaoInicial = buf.indexOf("<valor_referencia>");
                                        posicaoFinal = buf.indexOf("</valor_referencia>");
                                        paraCorrigir = buf.substring(posicaoInicial + 17, posicaoFinal);
                                        novoTexto = "";
                                        for (char c : paraCorrigir.toCharArray()) {
                                            novoTexto = novoTexto + StringUtil.tratarUnicode(c, true);
                                        }
                                        buf.delete(posicaoInicial + 17, posicaoFinal);
                                        buf.insert(posicaoInicial + 17, novoTexto);
                                        comando = buf.toString();
                                    }
                                    buf.setLength(0);
                                    buf.trimToSize();
                                    buf = null;
                                }
                                comandoLowerCase = null;
                                if (Servidor2.debug) {
                                    System.out.println(comando);
                                }
                                try {
                                    Servidor2.getConexaoIntegracao(String.valueOf(filial.getCodigo())).executeUpdate(Variaveis.filialPadrao, st, comando, true);
                                }
                                catch (Exception sqle) {
                                    st.execute("rollback;");
                                    String mensagem = sqle.getMessage();
                                    if (mensagem.contains("duplicate key value")) break block45;
                                    throw sqle;
                                }
                            }
                            ++contadorComandosExecutados;
                        } else {
                            ++contadorComandosExecutados;
                        }
                    } else {
                        comandoLowerCase = null;
                        if (Servidor2.debug) {
                            System.out.println(comando);
                        }
                        Servidor2.getConexaoIntegracao(String.valueOf(filial.getCodigo())).executeUpdate(Variaveis.filialPadrao, st, comando, true);
                        ++contadorComandosExecutados;
                    }
                    comando = null;
                    if (progresso != null) {
                        progresso.setValue(progresso.getValue() + 1);
                    }
                    Thread.sleep(50L);
                }
                if (contadorComandosExecutados != tamanhoOriginal) {
                    throw new IntegracaoException(registroAtual.intValue(), "Nem todos os registros do arquivo puderam ser processados. QTDE REGISTROS: " + registros.length + " QTDE PROCESSADOS: " + contadorComandosExecutados, null, true);
                }
                codigoLogErro = null;
                StringBuilder buf = new StringBuilder();
                buf.append("select fil_integracaorecebida from filiais_postocoleta where fil_codigo = ").append(filial.getCodigo());
                ResultSet rs = Servidor2.getConexaoIntegracao(String.valueOf(filial)).executeQuery(st, buf.toString());
                Long ultimoRecebido = new Long(0L);
                if (rs.next()) {
                    ultimoRecebido = IntegracaoUtil.parseUltimaIntegracao(rs.getString("fil_integracaorecebida"), String.valueOf(filial.getCodigo()));
                }
                if (Funcoes.isNumeric(sequencialArquivo) && filial.getUltimaIntegracaoRecebida() == ultimoRecebido.longValue() && ultimoRecebido == Long.parseLong(sequencialArquivo) - 1L) {
                    String novoXMLIntegracaoRecebida = IntegracaoUtil.atualizarXMLUltimaIntegracao(filial.getXmlUltimaIntegracaoRecebida(), String.valueOf(filial.getCodigo()), String.valueOf(sequencialArquivo));
                    String novoXMLLogIntegracaoRecebida = IntegracaoUtil.atualizarXMLUltimaIntegracao(filial.getXmlUltimoLogIntegracaoRecebido(), String.valueOf(filial.getCodigo()), String.valueOf(ultimo));
                    filial.setUtimaIntegracaoRecebida(Long.parseLong(sequencialArquivo));
                    filial.setUltimoLogIntegracaoRecebido(ultimo);
                    filial.setXmlUltimaIntegracaoRecebida(novoXMLIntegracaoRecebida);
                    filial.setXmlUltimoLogIntegracaoRecebido(novoXMLLogIntegracaoRecebida);
                    buf.setLength(0);
                    buf.append("update filiais_postocoleta set fil_integracaorecebida = '").append(novoXMLIntegracaoRecebida).append("'");
                    buf.append(", fil_logintegracaorecebido = '").append(novoXMLLogIntegracaoRecebida).append("'");
                    buf.append(" where fil_codigo = ").append(filial.getCodigo());
                    Servidor2.getConexaoIntegracao(String.valueOf(filial.getCodigo())).executeUpdate(Variaveis.filialPadrao, st, buf.toString(), true);
                    break block46;
                }
                throw new IntegracaoException(registroAtual.intValue(), "N\u00e3o foi poss\u00edvel atualizar o registro do \u00faltimo arquivo recebido. \u00daLTIMO ARQUIVO RECEBIDO: " + filial.getUltimaIntegracaoRecebida() + "- ARQUIVO ATUAL: " + sequencialArquivo, null, false);
            }
            catch (SQLException ex) {
                if (Servidor2.debug) {
                    ex.printStackTrace();
                }
                throw new IntegracaoException(registroAtual.intValue(), ex.getMessage() + (codigoLogErro != null ? "\nLog:" + codigoLogErro : ""), ex.getSQLState(), true);
            }
            catch (Exception ex) {
                if (Servidor2.debug) {
                    ex.printStackTrace();
                }
                throw new IntegracaoException(registroAtual.intValue(), ex.getMessage() + (codigoLogErro != null ? "\nLog:" + codigoLogErro : ""), null, false);
            }
            finally {
                try {
                    IntegracaoUtil.removeOIDUsuarioConectado();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static void insereOIDUsuarioConectado(Integer filial) throws Exception {
        StringBuilder buf = new StringBuilder();
        buf.append("select count(*) as qtde from usuarioconectado ");
        buf.append("where usc_oid = pg_backend_pid()");
        Statement st = ConexaoTemporaria.getStatement();
        try {
            ResultSet rs = ConexaoTemporaria.executeQuery(st, buf.toString());
            if (rs.next() && rs.getInt("qtde") == 0) {
                buf.setLength(0);
                buf.append(" insert into usuarioconectado ");
                buf.append(" (usc_oid, usc_filial) ");
                buf.append(" values (");
                buf.append(" pg_backend_pid()");
                buf.append(" ,").append(filial);
                buf.append(" ) ");
                ConexaoTemporaria.executeUpdate(Variaveis.filialPadrao, st, buf.toString(), true);
                ConexaoTemporaria.arquivaSQL();
            }
        }
        catch (SQLException e) {
            try {
                ConexaoTemporaria.anulaSQL();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new Exception("N\u00e3o foi poss\u00edvel inserir informa\u00e7\u00f5es do usu\u00e1rio gerador de integra\u00e7\u00e3o.\n" + e.getMessage());
        }
        finally {
            ConexaoTemporaria.fecharStatement(st);
        }
    }

    private static void removeOIDUsuarioConectado() throws Exception {
        StringBuilder buf = new StringBuilder();
        buf.append(" delete from usuarioconectado ");
        buf.append("  where usc_oid = pg_backend_pid() ");
        Statement st = ConexaoTemporaria.getStatement();
        try {
            ConexaoTemporaria.executeUpdate(Variaveis.filialPadrao, st, buf.toString(), true);
            ConexaoTemporaria.arquivaSQL();
        }
        catch (SQLException e) {
            try {
                ConexaoTemporaria.anulaSQL();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new Exception("N\u00e3o foi poss\u00edvel remover informa\u00e7\u00f5es do usu\u00e1rio gerador de integra\u00e7\u00e3o.\n" + e.getMessage());
        }
        finally {
            ConexaoTemporaria.fecharStatement(st);
        }
    }

    private static void setUsuarioDataIntegracao(String usuario, String dataHora) throws Exception {
        if (!Funcoes.textoVazio(usuario) || !Funcoes.textoVazio(dataHora)) {
            StringBuilder buf = new StringBuilder();
            buf.append(" update usuarioconectado ");
            buf.append("    set usc_login = '").append(usuario).append("' ");
            buf.append("       ,usc_datahora = '").append(dataHora).append("' ");
            buf.append("  where usc_oid = pg_backend_pid() ");
            Statement st = ConexaoTemporaria.getStatement();
            try {
                ConexaoTemporaria.executeUpdate(Variaveis.filialPadrao, st, buf.toString(), true);
            }
            catch (SQLException e) {
                throw new Exception("N\u00e3o foi poss\u00edvel atualizar informa\u00e7\u00f5es do usu\u00e1rio gerador de integra\u00e7\u00e3o.\n" + e.getMessage());
            }
            finally {
                ConexaoTemporaria.fecharStatement(st);
            }
        }
    }

    public static ArrayList<String> selecionarArquivosParaImportar(String tipoIntegracao, String filial, String caminho, long ultimaIntegracaoRecebida, boolean renomearArquivos, BufferedWriter bufferLog, String charset) {
        TreeSet<String> retornoOrdenado = new TreeSet<String>(new Comparator(){

            public int compare(Object o1, Object o2) {
                boolean isArquivo2Preferencial;
                if (Servidor2.debug) {
                    System.out.println(o1.toString() + "  " + o2.toString());
                }
                boolean isArquivo1Preferencial = o1.toString().toUpperCase().endsWith(".RDW") || o1.toString().toUpperCase().endsWith(".RDI");
                boolean bl = isArquivo2Preferencial = o2.toString().toUpperCase().endsWith(".RDW") || o2.toString().toUpperCase().endsWith(".RDI");
                if (isArquivo1Preferencial && isArquivo2Preferencial) {
                    return -1;
                }
                if (isArquivo1Preferencial && !isArquivo2Preferencial) {
                    return -1;
                }
                if (!isArquivo1Preferencial && isArquivo2Preferencial) {
                    return 1;
                }
                String primeiro = "";
                String segundo = "";
                if (o1 instanceof String) {
                    primeiro = o1.toString();
                }
                if (o2 instanceof String) {
                    segundo = o2.toString();
                }
                String numeracaoPrimeiro = primeiro.substring(5, 12);
                String numeracaoSegundo = segundo.substring(5, 12);
                return primeiro.length() > 12 && Funcoes.isNumeric(numeracaoPrimeiro) && segundo.length() > 12 && Funcoes.isNumeric(numeracaoSegundo) && Long.parseLong(numeracaoPrimeiro) > Long.parseLong(numeracaoSegundo) ? 1 : -1;
            }
        });
        File diretorio = new File(caminho);
        boolean renomearTHW = false;
        if (diretorio.isDirectory()) {
            String[] arquivos = diretorio.list();
            Servidor2.mensagemLog("Pesquisando em " + arquivos.length + " arquivo(s)", true, filial);
            for (String a : arquivos) {
                boolean isPreferencial;
                if (renomearArquivos) {
                    if (a.toUpperCase().endsWith(".THW") && !renomearTHW) {
                        boolean bl = renomearTHW = Funcoes.mensagem(null, "Alguns arquivos de importa\u00e7\u00e3o online foram encontrados, deseja renome\u00e1-los para a importa\u00e7\u00e3o?", 4) == 0;
                    }
                    if (a.toUpperCase().endsWith(".THW") && renomearTHW) {
                        Servidor2.mensagemLog("Renomeando arquivo " + a, true, filial);
                        File f1 = new File(caminho + (caminho.endsWith("/") ? "" : "/") + a);
                        File f2 = new File(caminho + (caminho.endsWith("/") ? "" : "/") + a.substring(0, a.length() - 3) + "thi");
                        System.gc();
                        f1.renameTo(f2);
                    }
                }
                boolean bl = isPreferencial = a.toUpperCase().endsWith(".RDW") || a.toUpperCase().endsWith(".RDI");
                if (a.toUpperCase().endsWith(".THI") || a.toUpperCase().endsWith(".THW") && IntegracaoUtil.isArquivoCompleto(caminho, a, charset) || isPreferencial) {
                    String lote;
                    String copia = a.length() > 12 ? a.substring(1, 4) : "";
                    String string = lote = a.length() > 12 ? a.substring(5, 12) : "";
                    if (isPreferencial && a.startsWith(tipoIntegracao) && Funcoes.isNumeric(copia) && Integer.parseInt(copia) == Integer.parseInt(filial)) {
                        Servidor2.mensagemLog("Adicionando arquivo " + a + " para importacao", true, filial);
                        retornoOrdenado.add(a);
                        continue;
                    }
                    if (a.startsWith(tipoIntegracao) && Funcoes.isNumeric(copia) && Funcoes.isNumeric(lote) && Integer.parseInt(copia) == Integer.parseInt(filial)) {
                        if (Long.parseLong(lote) > ultimaIntegracaoRecebida) {
                            Servidor2.mensagemLog("Adicionando arquivo " + a + " para importacao", true, filial);
                            retornoOrdenado.add(a);
                            continue;
                        }
                        Servidor2.mensagemLog("Movendo arquivo " + a + " para importados", true, filial);
                        try {
                            Servidor2.moveArquivo(a, caminho);
                        }
                        catch (Exception e) {
                            Servidor2.mensagemLog("N\u00e3o foi poss\u00edvel mover arquivo " + a + " para pasta importado.", false, filial);
                        }
                        continue;
                    }
                    Servidor2.mensagemLog(a + " rejeitado para importacao (tipo:" + tipoIntegracao + ", copia:" + copia + ", lote:" + lote + ", filial:" + filial + ", ultima:" + ultimaIntegracaoRecebida + ")", true, filial);
                    continue;
                }
                if (!a.toUpperCase().endsWith(".THW")) continue;
                Servidor2.mensagemLog(a + " rejeitado para importacao pois nao esta completo", true, filial);
            }
        }
        return new ArrayList<String>(retornoOrdenado);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isArquivoCompleto(String path, String nomeArquivo, String charset) {
        FileInputStream fis = null;
        try {
            File arquivo = new File(path + (path.endsWith("/") ? "" : "/") + nomeArquivo);
            if (arquivo != null && arquivo.exists() && (fis = new FileInputStream(arquivo)) != null) {
                byte[] b = new byte[(int)arquivo.length()];
                fis.read(b);
                String conteudo = null;
                conteudo = Funcoes.textoVazio(charset) ? new String(b) : new String(b, charset);
                boolean bl = conteudo.indexOf("</integracao>") >= 0;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static String converteInsertParaSelect(Statement st, String sql, String[] tabelasParaIgnorar) {
        String comando = sql.trim();
        if ((comando = comando.trim()).endsWith(";")) {
            comando = comando.substring(0, comando.length() - 1);
        }
        String tabela = comando.substring(comando.toUpperCase().indexOf("INTO") + "into".length() + 1, comando.toUpperCase().indexOf("(")).trim();
        String campos = comando.substring(comando.toUpperCase().indexOf("("), comando.toUpperCase().indexOf("VALUES") - 1);
        String valores = comando.substring(comando.toUpperCase().indexOf("VALUES") + "VALUES".length() + 1);
        if (ArraysUtil.indice((Object[])tabelasParaIgnorar, tabela) > -1) {
            return "";
        }
        if ((campos = campos.trim()).startsWith("(")) {
            campos = campos.substring(1);
        }
        if (campos.endsWith(")")) {
            campos = campos.substring(0, campos.length() - 1);
        }
        if ((valores = valores.trim()).startsWith("(")) {
            valores = valores.substring(1);
        }
        if (valores.endsWith(")")) {
            valores = valores.substring(0, valores.length() - 1);
        }
        String[] campo = campos.split(",");
        String[] valor = IntegracaoUtil.interpretaValores(valores);
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < campo.length; ++i) {
            map.put(campo[i].trim(), valor[i].trim());
        }
        try {
            String[] pk = DBUtil.pegaColunasPK(st, tabela);
            if (pk.length > 0) {
                StringBuilder select = new StringBuilder("select * from ");
                select.append(tabela);
                boolean chaveInserida = false;
                for (int i = 0; i < pk.length; ++i) {
                    if (map.get(pk[i].trim()) == null) continue;
                    chaveInserida = true;
                    if (select.indexOf("where") < 0) {
                        select.append(" where ");
                    } else {
                        select.append(" and ");
                    }
                    select.append(pk[i].trim()).append(" = ").append((String)map.get(pk[i].trim()));
                }
                if (!chaveInserida) {
                    select.append(" limit 0 ");
                }
                return select.toString();
            }
            return "";
        }
        catch (Exception ex) {
            return "";
        }
    }

    public static String converteInsertParaUpdate(Statement st, String sql, String[] tabelasParaIgnorar) {
        String comando = sql.trim();
        if ((comando = comando.trim()).endsWith(";")) {
            comando = comando.substring(0, comando.length() - 1);
        }
        String tabela = comando.substring(comando.toUpperCase().indexOf("INTO") + "into".length() + 1, comando.toUpperCase().indexOf("(")).trim();
        String campos = comando.substring(comando.toUpperCase().indexOf("("), comando.toUpperCase().indexOf("VALUES") - 1);
        String valores = comando.substring(comando.toUpperCase().indexOf("VALUES") + "VALUES".length() + 1);
        if (ArraysUtil.indice((Object[])tabelasParaIgnorar, tabela) > -1) {
            return "";
        }
        if ((campos = campos.trim()).startsWith("(")) {
            campos = campos.substring(1);
        }
        if (campos.endsWith(")")) {
            campos = campos.substring(0, campos.length() - 1);
        }
        if ((valores = valores.trim()).startsWith("(")) {
            valores = valores.substring(1);
        }
        if (valores.endsWith(")")) {
            valores = valores.substring(0, valores.length() - 1);
        }
        String[] campo = campos.split(",");
        String[] valor = IntegracaoUtil.interpretaValores(valores);
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < campo.length; ++i) {
            map.put(campo[i].trim(), valor[i].trim());
        }
        try {
            String[] pk = DBUtil.pegaColunasPK(st, tabela);
            if (pk.length > 0) {
                if (pk.length >= campo.length) {
                    return "";
                }
                StringBuilder update = new StringBuilder();
                update.append("update ").append(tabela).append(" set ");
                boolean campoInserido = false;
                for (int i = 0; i < campo.length; ++i) {
                    boolean isPk = false;
                    for (int j = 0; j < pk.length; ++j) {
                        if (!campo[i].trim().equals(pk[j].trim())) continue;
                        isPk = true;
                    }
                    if (isPk) continue;
                    if (campoInserido) {
                        update.append(", ");
                    }
                    update.append(campo[i]).append(" = ").append((String)map.get(campo[i].trim()));
                    isPk = false;
                    campoInserido = true;
                }
                boolean chaveInserida = false;
                for (int i = 0; i < pk.length; ++i) {
                    if (map.get(pk[i].trim()) == null) continue;
                    chaveInserida = true;
                    if (update.indexOf("where") < 0) {
                        update.append(" where ");
                    } else {
                        update.append(" and ");
                    }
                    update.append(pk[i].trim()).append(" = ").append((String)map.get(pk[i].trim()));
                }
                if (!chaveInserida) {
                    throw new Exception("N\u00e3o foi poss\u00edvel gerar o comando de UPDATE utilizando o INSERT.\nComando original = \"" + sql + "\".");
                }
                return update.toString();
            }
            return "";
        }
        catch (Exception ex) {
            return "";
        }
    }

    private static String[] interpretaValores(String valores) {
        StringBuilder tmp = new StringBuilder();
        ArrayList<String> retorno = new ArrayList<String>();
        boolean aspasAberta = false;
        for (char c : valores.toCharArray()) {
            if (c == ',' && !aspasAberta) {
                retorno.add(tmp.toString().trim());
                tmp.setLength(0);
                continue;
            }
            if (c == '\'' && !aspasAberta) {
                aspasAberta = true;
                tmp.append(c);
                continue;
            }
            if (c == '\'' && aspasAberta) {
                aspasAberta = false;
                tmp.append(c);
                continue;
            }
            tmp.append(c);
        }
        retorno.add(tmp.toString().trim());
        return retorno.toArray(new String[retorno.size()]);
    }

    public static boolean moveArquivo(String arquivo, String nomeDirImportados, BufferedWriter bufferLog) {
        try {
            File f = new File(Variaveis.estacaoPathIntegracao + arquivo);
            File f2 = new File(Variaveis.estacaoPathIntegracao + nomeDirImportados + "/" + arquivo);
            Servidor2.mensagemLog("Movendo arquivo " + f.getAbsolutePath() + " para " + f2.getAbsolutePath(), true, null);
            if (f2.exists() || f2.getAbsoluteFile().exists()) {
                Servidor2.mensagemLog("Arquivo sendo excluido, pois j\u00e1 existe: " + f2.getName(), true, null);
                f2.delete();
            }
            System.gc();
            return f.renameTo(f2);
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static String carregarParCliente(Statement st) throws SQLException {
        String sql = "select par_cliente from parametros";
        ResultSet rs = st.executeQuery("select par_cliente from parametros");
        String parCliente = rs.next() ? rs.getString("par_cliente") : "";
        rs.close();
        return parCliente;
    }

    public static enum VersaoXML {
        VERSAO_1_0_0("1.0.0"),
        VERSAO_2_0_0("2.0.0"),
        VERSAO_3_0_0("3.0.0");

        private String versao = null;

        private VersaoXML(String versao) {
            this.versao = versao;
        }

        public String toString() {
            return this.versao;
        }

        public static VersaoXML getVersaoXML(String versao) {
            if (Funcoes.textoVazio(versao)) {
                return null;
            }
            VersaoXML[] valores = VersaoXML.values();
            for (int i = 0; i < valores.length; ++i) {
                if (!valores[i].toString().equals(versao)) continue;
                return valores[i];
            }
            return null;
        }
    }
}

