/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.exportacao.integracao;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.ParametrosUsuarios;
import jalis.comum.padroes.FrmPadrao;
import jalis.integracao.servidor.ExportaIntegracao2;
import jalis.integracao.servidor.GZipException;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.exportacao.integracao.DadosIntegracaoFilial;
import jalis.laboratorio.exportacao.integracao.IntegracaoUtil;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.ThreadFinalizadaListener;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.sql.Statement;
import java.util.EventObject;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class ImportarDados
extends FrmPadrao
implements ActionListener,
ThreadFinalizadaListener {
    private static final long ACESSO = 907000301L;
    private static final long ACESSO_DIRETORIO = 907000302L;
    public static final String DIRETORIO_IMPORTACAO = "ImportarDados.diretorio";
    private JButton buttonFechar = ComponenteFactory.novoJButton("Fechar", 'F', this);
    private JButton buttonImportar = ComponenteFactory.novoJButton("Importar", 'I', this);
    private JLabel labelFilial = new JLabel("Filial origem:");
    private JComboBox comboFilial = new JComboBox();
    private JLabel labelPath = new JLabel("Diret\u00f3rio de importa\u00e7\u00f5es:");
    private TTextField textPath = new TTextField();
    private JButton buttonPath = ComponenteFactory.novoJButton(this, null, null, true);
    private JPanel panelCentro = new JPanel(new GridBagLayout());
    private JProgressBar progressoArquivo = new JProgressBar();
    private JProgressBar progressoRegistro = new JProgressBar();
    private boolean isImportando = false;

    public ImportarDados() {
        this.montaTela();
        this.preencheFiliais();
    }

    private void controlaCampos() {
        this.buttonFechar.setEnabled(!this.isImportando);
        this.buttonImportar.setEnabled(!this.isImportando);
        this.comboFilial.setEnabled(!this.isImportando);
        this.textPath.setEnabled(!this.isImportando);
        this.buttonPath.setEnabled(!this.isImportando);
    }

    private void montaTela() {
        this.setLayout(new BorderLayout());
        Funcoes.criaBarraDescricao(this, "Importar dados", "Importa os dados necess\u00e1rios para a integra\u00e7\u00e3o entre as filiais off-line", "integracao/integ_importa.jpg");
        JPanel panelBotoes = new JPanel(new FlowLayout(2));
        panelBotoes.add(this.buttonImportar);
        panelBotoes.add(this.buttonFechar);
        this.add((Component)panelBotoes, "South");
        this.add((Component)this.panelCentro, "Center");
        this.panelCentro.setBorder(ScreenUtil.criarBordaVazia());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 0;
        c.insets = new Insets(2, 0, 0, 0);
        this.panelCentro.add((Component)this.labelFilial, c);
        c.gridy = 1;
        this.panelCentro.add((Component)this.labelPath, c);
        c.fill = 2;
        c.weightx = 1.0;
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 2;
        this.comboFilial.setPreferredSize(new Dimension(100, 20));
        this.comboFilial.setMinimumSize(new Dimension(100, 20));
        this.panelCentro.add((Component)this.comboFilial, c);
        c.gridy = 1;
        c.gridwidth = 1;
        this.textPath.setPreferredSize(new Dimension(100, 20));
        this.textPath.setMinimumSize(new Dimension(100, 20));
        this.panelCentro.add((Component)this.textPath, c);
        c.fill = 0;
        c.weightx = 0.0;
        c.gridx = 2;
        this.buttonPath.setPreferredSize(new Dimension(20, 20));
        this.buttonPath.setMinimumSize(new Dimension(20, 20));
        this.panelCentro.add((Component)this.buttonPath, c);
        c.gridy = 3;
        c.gridx = 0;
        c.fill = 1;
        c.weighty = 1.0;
        c.gridwidth = 3;
        this.panelCentro.add((Component)new JPanel(), c);
        c.gridy = 4;
        c.fill = 2;
        c.weighty = 0.0;
        this.progressoArquivo.setPreferredSize(new Dimension(100, 20));
        this.progressoArquivo.setMinimumSize(new Dimension(100, 20));
        this.panelCentro.add((Component)this.progressoArquivo, c);
        c.gridy = 5;
        this.progressoRegistro.setPreferredSize(new Dimension(100, 14));
        this.progressoRegistro.setMinimumSize(new Dimension(100, 14));
        this.panelCentro.add((Component)this.progressoRegistro, c);
        boolean acessoDiretorio = Acesso.getAcesso(ImportarDados.getModuloAcessoDiretorio());
        this.textPath.setEnabled(acessoDiretorio);
        this.buttonPath.setEnabled(acessoDiretorio);
        this.buttonPath.setFocusable(false);
        this.textPath.setText(ParametrosUsuarios.getValor(DIRETORIO_IMPORTACAO));
        this.progressoArquivo.setStringPainted(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void preencheFiliais() {
        Statement st = Conexao.getStatement();
        try {
            DadosIntegracaoFilial[] filiais = IntegracaoUtil.buscaFiliais(st);
            this.comboFilial.removeAllItems();
            for (DadosIntegracaoFilial f : filiais) {
                this.comboFilial.addItem(f);
            }
        }
        catch (Exception ex) {
            try {
                ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "ImportarDados (148)");
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
    }

    public static long getModuloAcesso() {
        return 907000301L;
    }

    public static long getModuloAcessoDiretorio() {
        return 907000302L;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonFechar) {
            this.setVisible(false);
        } else if (e.getSource() == this.buttonImportar) {
            Thread processamento = new Thread(){
                ThreadFinalizadaListener listener;
                {
                    this.listener = ImportarDados.this;
                }

                @Override
                public void run() {
                    this.fireIniciouExecucao();
                    ImportarDados.this.importar();
                    System.gc();
                    this.fireTerminouExecucao();
                }

                private void fireIniciouExecucao() {
                    this.listener.threadIniciada(new EventObject(this));
                }

                private void fireTerminouExecucao() {
                    this.listener.threadFinalizada(new EventObject(this));
                }
            };
            processamento.start();
        } else if (e.getSource() == this.buttonPath) {
            this.alterarPath();
        }
    }

    private void alterarPath() {
        JFileChooser file = ComponenteFactory.novoJFileChooser("Diret\u00f3rio de importa\u00e7\u00e3o");
        if (!Funcoes.textoVazio(this.textPath.getText()) && Funcoes.diretorioExiste(this.textPath.getText())) {
            file.setCurrentDirectory(new File(this.textPath.getText()));
        }
        file.setFileSelectionMode(1);
        if (file.showOpenDialog(this) == 0) {
            this.textPath.setText(file.getSelectedFile().getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private synchronized void importar() {
        if (Funcoes.textoVazio(this.textPath.getText()) || !Funcoes.diretorioExiste(this.textPath.getText())) {
            Funcoes.mensagem(this, "O diret\u00f3rio para importa\u00e7\u00e3o de dados n\u00e3o foi encontrado", 1);
            if (this.textPath.isEnabled()) {
                ScreenUtil.requisitarFoco(this.textPath);
            }
            return;
        }
        f = (DadosIntegracaoFilial)this.comboFilial.getSelectedItem();
        if (!f.isIntegraDados()) {
            Funcoes.mensagem(this, "A filial selecionada n\u00e3o permite integra\u00e7\u00e3o de dados", 1);
            ScreenUtil.requisitarFoco(this.comboFilial);
            return;
        }
        ParametrosUsuarios.setValor("ImportarDados.diretorio", this.textPath.getText());
        ParametrosUsuarios.salvarParametros(false);
        v0 = isIP = Funcoes.textoVazio(ParametrosGerais.getIpIntegracao()) == false;
        if (Laboratorio.getExportaIntegracao() != null && Laboratorio.getExportaIntegracao() instanceof ExportaIntegracao2) {
            if (((ExportaIntegracao2)Laboratorio.getExportaIntegracao()).isIntegrandoDados()) {
                Funcoes.mensagem(this, "A importa\u00e7\u00e3o autom\u00e1tica est\u00e1 em funcionamento, aguarde at\u00e9 que seja finalizada", 1);
                return;
            }
            ((ExportaIntegracao2)Laboratorio.getExportaIntegracao()).setAguardar(true);
        }
        this.progressoArquivo.setString("Verificando arquivos de importa\u00e7\u00e3o, aguarde...");
        importarTipo = ParametrosGerais.getTipoIntegracao().equalsIgnoreCase("M") != false ? "F" : "M";
        importar = IntegracaoUtil.selecionarArquivosParaImportar(importarTipo, String.valueOf(f.getCodigo()), this.textPath.getText(), f.getUltimaIntegracaoRecebida(), true, null, StringUtil.getCharsetIntegracao(ParametrosLocais.getParametro("codificacaoIntegracaoOffline")));
        if (importar.size() == 0) {
            Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para integrar", 2);
            return;
        }
        this.buttonImportar.setEnabled(false);
        this.progressoArquivo.setMaximum(importar.size());
        this.progressoArquivo.setValue(0);
        sucesso = true;
        arquivoComErro = "";
        for (String s : importar) {
            registroArquivo = null;
            try {
                registroArquivo = this.validaSequencialArquivo(s, f);
            }
            catch (GZipException e) {
                Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel descompactar arquivo.\n" + e.getMessage(), 2);
                return;
            }
            sucesso = registroArquivo != null;
            st = Conexao.getStatement();
            ** if (sucesso) goto lbl-1000
lbl-1000:
            // 1 sources

            {
                Conexao.fecharStatement(new Statement[]{st});
                break;
            }
lbl-1000:
            // 1 sources

            {
                this.progressoArquivo.setString(s);
                versao = registroArquivo.getString("versao");
                if (registroArquivo.getValor("data") instanceof Registro[]) {
                    IntegracaoUtil.processaVersao100((Registro[])registroArquivo.getValor("data"), st, f, registroArquivo.getString("arquivo"), this.progressoRegistro, null);
                }
            }
            try {
                Conexao.arquivaSQL();
            }
            catch (Exception ex) {
                try {
                    sucesso = false;
                    arquivoComErro = s;
                    try {
                        Conexao.anulaSQL();
                    }
                    catch (Exception var12_14) {
                        // empty catch block
                    }
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "ImportarDados (279) \nArquivo:" + arquivoComErro);
                }
                catch (Throwable var13_15) {
                    Conexao.fecharStatement(new Statement[]{st});
                    throw var13_15;
                }
                Conexao.fecharStatement(new Statement[]{st});
            }
            Conexao.fecharStatement(new Statement[]{st});
            this.progressoArquivo.setValue(this.progressoArquivo.getValue() + 1);
        }
        if (importar.size() > 0) {
            Funcoes.mensagem(this, sucesso != false ? "Importa\u00e7\u00e3o finalizada com sucesso" : "A importa\u00e7\u00e3o apresentou um erro no arquivo " + arquivoComErro, 2);
        }
        this.buttonImportar.setEnabled(true);
        if (Laboratorio.getExportaIntegracao() != null && Laboratorio.getExportaIntegracao() instanceof ExportaIntegracao2) {
            ((ExportaIntegracao2)Laboratorio.getExportaIntegracao()).setAguardar(false);
        }
        this.progressoArquivo.setString(null);
        this.progressoArquivo.setValue(0);
        this.progressoRegistro.setValue(0);
    }

    private Registro validaSequencialArquivo(String arquivo, DadosIntegracaoFilial filial) throws GZipException {
        long proximaIntegracao = Long.parseLong(arquivo.substring(5, 12));
        Registro retorno = null;
        if (filial.getUltimaIntegracaoRecebida() != proximaIntegracao - 1L) {
            Funcoes.mensagem(this, "A sequ\u00eancia de arquivos de importa\u00e7\u00e3o est\u00e1 incorreta", 1);
            return retorno;
        }
        String dir = this.textPath.getText();
        if (!dir.endsWith("/")) {
            dir = dir + "/";
        }
        try {
            String textoArquivo = StringUtil.lerArquivoTexto(dir + arquivo);
            retorno = IntegracaoUtil.arquivoRecebidoParaRegistro(textoArquivo, StringUtil.getCharsetIntegracao(ParametrosLocais.getParametro("codificacaoIntegracaoOffline")));
            if (retorno == null) {
                Funcoes.mensagem(this, "O arquivo recebido \u00e9 inv\u00e1lido", 1);
            }
        }
        catch (Exception e) {
            Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel validar o arquivo " + arquivo + ".\nMensagem: " + e.getMessage(), 1);
        }
        return retorno;
    }

    private boolean validaSequencialRecebimento(Registro registro, long proximaIntegracao, DadosIntegracaoFilial filial) {
        boolean retorno = false;
        if (Funcoes.isNumeric(registro.getString("arquivo")) && Long.parseLong(registro.getString("arquivo")) != proximaIntegracao) {
            Funcoes.mensagem(this, "O conte\u00fado do arquivo esta incorreto.\nEsperado:" + String.valueOf(proximaIntegracao), 1);
        } else if (Funcoes.isNumeric(registro.getString("log")) && Long.parseLong(registro.getString("log")) != filial.getUltimoLogIntegracaoRecebido() + 1L) {
            Funcoes.mensagem(this, "O n\u00famero sequencial do log est\u00e1 incorreto\nEsperado:" + String.valueOf(filial.getUltimoLogIntegracaoRecebido() + 1L) + "\tRecebido:" + registro.getString("log"), 1);
        } else {
            retorno = true;
        }
        return retorno;
    }

    @Override
    public void threadIniciada(EventObject e) {
        this.isImportando = true;
        this.controlaCampos();
    }

    @Override
    public void threadFinalizada(EventObject e) {
        this.isImportando = false;
        this.controlaCampos();
    }
}

