/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.exportacao.integracao;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.ParametrosUsuarios;
import jalis.comum.padroes.FrmPadrao;
import jalis.integracao.servidor.ExportaIntegracao2;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.exportacao.integracao.DadosIntegracaoFilial;
import jalis.laboratorio.exportacao.integracao.IntegracaoUtil;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.ThreadFinalizadaListener;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.EventObject;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.border.TitledBorder;

public class ExportarDados
extends FrmPadrao
implements ActionListener,
ThreadFinalizadaListener {
    private static final long ACESSO = 907000201L;
    private static final long ACESSO_DIRETORIO = 907000202L;
    private static final long ACESSO_ARQUIVO_ANTERIOR = 907000203L;
    public static final String DIRETORIO_EXPORTACAO = "ExportarDados.diretorio";
    private JButton buttonFechar = ComponenteFactory.novoJButton("Fechar", 'F', this);
    private JButton buttonExportar = ComponenteFactory.novoJButton("Exportar", 'E', this);
    private JLabel labelFilial = new JLabel("Filial destino:");
    private JComboBox comboFilial = new JComboBox();
    private JLabel labelPath = new JLabel("Diret\u00f3rio de exporta\u00e7\u00f5es:");
    private TTextField textPath = new TTextField();
    private JButton buttonPath = ComponenteFactory.novoJButton(this, null, null, true);
    private JPanel panelCentro = new JPanel(new GridBagLayout());
    private JProgressBar progresso = new JProgressBar();
    private JPanel panelArquivoAnterior = new JPanel(new FlowLayout(0));
    private JCheckBox checkAnterior = ComponenteFactory.novoJCheckBox("Arquivo anterior:", this);
    private TTextField textAnterior = new TTextField(8, 1);
    private boolean isExportando = false;
    private JLabel labelInfo = ComponenteFactory.novoJLabel("", null, new TitledBorder("Informa\u00e7\u00f5es da integra\u00e7\u00e3o"));

    private void controlaCampos() {
        this.buttonFechar.setEnabled(!this.isExportando);
        this.buttonExportar.setEnabled(!this.isExportando);
        this.comboFilial.setEnabled(!this.isExportando);
        this.textPath.setEnabled(!this.isExportando);
        this.buttonPath.setEnabled(!this.isExportando);
        this.checkAnterior.setEnabled(!this.isExportando);
    }

    public ExportarDados() {
        this.montaTela();
        this.preencheFiliais();
    }

    private void montaTela() {
        this.setLayout(new BorderLayout());
        Funcoes.criaBarraDescricao(this, "Exportar dados", "Gera os dados necess\u00e1rios para a integra\u00e7\u00e3o entre as filiais off-line", "integracao/integ_exporta.jpg");
        JPanel panelBotoes = new JPanel(new FlowLayout(2));
        panelBotoes.add(this.buttonExportar);
        panelBotoes.add(this.buttonFechar);
        this.add((Component)panelBotoes, "South");
        this.add((Component)this.panelCentro, "Center");
        this.panelCentro.setBorder(ScreenUtil.criarBordaVazia());
        this.panelArquivoAnterior.add(this.checkAnterior);
        this.panelArquivoAnterior.add(this.textAnterior);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 0;
        c.insets = new Insets(2, 0, 0, 0);
        this.panelCentro.add((Component)this.labelFilial, c);
        c.gridy = 1;
        this.panelCentro.add((Component)this.labelPath, c);
        c.fill = 2;
        c.weightx = 1.0;
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 2;
        this.comboFilial.setPreferredSize(new Dimension(100, 20));
        this.comboFilial.setMinimumSize(new Dimension(100, 20));
        this.panelCentro.add((Component)this.comboFilial, c);
        c.gridy = 1;
        c.gridwidth = 1;
        this.textPath.setPreferredSize(new Dimension(100, 20));
        this.textPath.setMinimumSize(new Dimension(100, 20));
        this.panelCentro.add((Component)this.textPath, c);
        c.fill = 0;
        c.weightx = 0.0;
        c.gridx = 2;
        this.buttonPath.setPreferredSize(new Dimension(20, 20));
        this.buttonPath.setMinimumSize(new Dimension(20, 20));
        this.panelCentro.add((Component)this.buttonPath, c);
        c.gridy = 3;
        c.gridx = 0;
        c.fill = 1;
        c.weighty = 1.0;
        this.panelCentro.add((Component)new JPanel(), c);
        c.gridy = 4;
        c.gridx = 0;
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 3;
        this.labelInfo.setPreferredSize(new Dimension(100, 90));
        this.labelInfo.setFont(new Font(this.labelInfo.getFont().getFontName(), 0, 10));
        this.panelCentro.add((Component)this.labelInfo, c);
        c.gridy = 5;
        c.fill = 2;
        c.weighty = 0.0;
        this.progresso.setPreferredSize(new Dimension(100, 20));
        this.progresso.setMinimumSize(new Dimension(100, 20));
        this.progresso.setStringPainted(true);
        this.panelCentro.add((Component)this.progresso, c);
        if (Acesso.getAcesso(907000203L)) {
            c.gridy = 6;
            this.textAnterior.setPreferredSize(new Dimension(60, 20));
            this.textAnterior.setMinimumSize(new Dimension(60, 20));
            this.panelCentro.add((Component)this.panelArquivoAnterior, c);
        }
        boolean acessoDiretorio = Acesso.getAcesso(ExportarDados.getModuloAcessoDiretorio());
        this.textPath.setEnabled(acessoDiretorio);
        this.buttonPath.setEnabled(acessoDiretorio);
        this.buttonPath.setFocusable(false);
        this.textAnterior.setEnabled(false);
        this.textPath.setText(ParametrosUsuarios.getValor(DIRETORIO_EXPORTACAO));
        this.comboFilial.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ExportarDados.this.comboFilial.getSelectedItem() instanceof DadosIntegracaoFilial) {
                    DadosIntegracaoFilial df = (DadosIntegracaoFilial)ExportarDados.this.comboFilial.getSelectedItem();
                    String texto = "<html>Filial: " + String.valueOf(df.getCodigo()) + " - " + df.getDescricao() + "<br>\u00daltima integra\u00e7\u00e3o enviada: " + String.valueOf(df.getUltimaIntegracaoGerada()) + "<br>\u00daltima integra\u00e7\u00e3o recebida: " + String.valueOf(df.getUltimaIntegracaoRecebida()) + "<br>\u00daltima log de integra\u00e7\u00e3o recebido: " + String.valueOf(df.getUltimoLogIntegracaoRecebido()) + "<br>Logs para enviar: " + String.valueOf(df.getLogsParaEnviar()) + "</html>";
                    ExportarDados.this.labelInfo.setText(texto);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void preencheFiliais() {
        Statement st = Conexao.getStatement();
        try {
            DadosIntegracaoFilial[] filiais = IntegracaoUtil.buscaFiliais(st, true);
            this.comboFilial.removeAllItems();
            for (DadosIntegracaoFilial f : filiais) {
                this.comboFilial.addItem(f);
            }
        }
        catch (Exception ex) {
            try {
                ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "ExportarDados (140)");
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
    }

    public static long getModuloAcesso() {
        return 907000201L;
    }

    public static long getModuloAcessoDiretorio() {
        return 907000202L;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonFechar) {
            this.setVisible(false);
        } else if (e.getSource() == this.buttonExportar) {
            Thread processamento = new Thread(){
                ThreadFinalizadaListener listener;
                {
                    this.listener = ExportarDados.this;
                }

                @Override
                public void run() {
                    this.fireIniciouExecucao();
                    ExportarDados.this.exportar();
                    System.gc();
                    this.fireTerminouExecucao();
                }

                private void fireIniciouExecucao() {
                    this.listener.threadIniciada(new EventObject(this));
                }

                private void fireTerminouExecucao() {
                    this.listener.threadFinalizada(new EventObject(this));
                }
            };
            processamento.start();
        } else if (e.getSource() == this.buttonPath) {
            this.alterarPath();
        } else if (e.getSource() == this.checkAnterior) {
            this.textAnterior.setEnabled(this.checkAnterior.isSelected());
        }
    }

    private void alterarPath() {
        JFileChooser file = ComponenteFactory.novoJFileChooser("Diret\u00f3rio de exporta\u00e7\u00e3o");
        if (!Funcoes.textoVazio(this.textPath.getText()) && Funcoes.diretorioExiste(this.textPath.getText())) {
            file.setCurrentDirectory(new File(this.textPath.getText()));
        }
        file.setFileSelectionMode(1);
        if (file.showOpenDialog(this) == 0) {
            this.textPath.setText(file.getSelectedFile().getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void exportar() {
        Statement st;
        block27: {
            if (Funcoes.textoVazio(this.textPath.getText()) || !Funcoes.diretorioExiste(this.textPath.getText())) {
                Funcoes.mensagem(this, "O diret\u00f3rio para exporta\u00e7\u00e3o de dados n\u00e3o foi encontrado", 1);
                if (this.textPath.isEnabled()) {
                    ScreenUtil.requisitarFoco(this.textPath);
                }
                return;
            }
            DadosIntegracaoFilial f = (DadosIntegracaoFilial)this.comboFilial.getSelectedItem();
            if (!f.isIntegraDados()) {
                Funcoes.mensagem(this, "A filial selecionada n\u00e3o permite integra\u00e7\u00e3o de dados", 1);
                ScreenUtil.requisitarFoco(this.comboFilial);
                return;
            }
            if (Laboratorio.getExportaIntegracao() != null && Laboratorio.getExportaIntegracao() instanceof ExportaIntegracao2) {
                if (((ExportaIntegracao2)Laboratorio.getExportaIntegracao()).isIntegrandoDados()) {
                    Funcoes.mensagem(this, "A importa\u00e7\u00e3o autom\u00e1tica est\u00e1 em funcionamento, aguarde at\u00e9 que seja finalizada", 1);
                    return;
                }
                ((ExportaIntegracao2)Laboratorio.getExportaIntegracao()).setAguardar(true);
            }
            this.buttonExportar.setEnabled(false);
            st = Conexao.getStatement();
            boolean reenvio = this.checkAnterior.isSelected() && Funcoes.isNumeric(this.textAnterior.getText());
            boolean exportado = false;
            try {
                Registro[] registros = IntegracaoUtil.getLogParaEnviar(st, String.valueOf(f.getCodigo()), reenvio ? new Long(this.textAnterior.getText()) : null, reenvio ? 0 : 50);
                ArrayList<String> arquivosGerados = new ArrayList<String>();
                if (registros != null && registros.length > 0) {
                    while (registros != null && registros.length > 0) {
                        long novaIntegracao = reenvio ? Long.parseLong(this.textAnterior.getText()) : f.getUltimaIntegracaoGerada() + 1L;
                        String tipoIntegracao = ParametrosGerais.getTipoIntegracao();
                        if (tipoIntegracao.equals("W")) {
                            tipoIntegracao = "F";
                        }
                        String nomeArquivo = tipoIntegracao + Funcoes.preencheZero(String.valueOf(f.getCodigo()), 3) + Funcoes.preencheZero(novaIntegracao, 8) + ".thi";
                        this.progresso.setString("Gerando arquivo de exporta\u00e7\u00e3o: " + nomeArquivo);
                        String corpo = IntegracaoUtil.registroParaTexto(registros, this.progresso, null);
                        boolean novoPadraoIntegracao = Funcoes.arquivoExiste(System.getProperty("user.home") + "/novaintegracao.jalis");
                        boolean isIP = !Funcoes.textoVazio(ParametrosGerais.getIpIntegracao()) && Funcoes.verificaIP(ParametrosGerais.getIpIntegracao());
                        String arquivo = this.textPath.getText();
                        if (!arquivo.endsWith("/")) {
                            arquivo = arquivo + "/";
                        }
                        arquivo = arquivo + nomeArquivo;
                        try {
                            if (!novoPadraoIntegracao) {
                                String corpoCompactado = IntegracaoUtil.xmlParaEnviar(st, f.getCodigo(), novaIntegracao, registros[0].getInt("off_codigo"), corpo, null);
                                exportado = StringUtil.escreverArquivoTexto(arquivo, corpoCompactado);
                            } else {
                                String charset = StringUtil.getCharsetIntegracao(ParametrosLocais.getParametro("codificacaoIntegracaoOffline"));
                                XMLStringBuilder xml = new XMLStringBuilder();
                                xml.abrir("integracao");
                                xml.escrever("versao", IntegracaoUtil.VERSAO_ARQUIVO.toString());
                                xml.escrever("arquivo", String.valueOf(novaIntegracao));
                                xml.escrever("filial", String.valueOf(f.getCodigo()));
                                xml.escrever("log", String.valueOf(registros[0].getInt("off_codigo")));
                                String texto = StringUtil.tratarEntidadesHTML(corpo.toString(), false);
                                texto = StringUtil.tratarUnicode(texto);
                                texto = StringUtil.compactar(corpo.toString(), 9, charset);
                                xml.escrever("data", texto);
                                xml.fechar("integracao");
                                exportado = StringUtil.escreverArquivoTexto(arquivo, xml.getXML(), charset);
                            }
                            arquivosGerados.add(arquivo);
                        }
                        catch (Exception e) {
                            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
                        }
                        if (exportado) {
                            StringBuilder buf = new StringBuilder();
                            ParametrosUsuarios.setValor(DIRETORIO_EXPORTACAO, this.textPath.getText());
                            ParametrosUsuarios.salvarParametros(false);
                            if (!reenvio) {
                                buf.delete(0, buf.length());
                                buf.append("update filiais_postocoleta set fil_integracaogerada = '");
                                String novoXML = IntegracaoUtil.atualizarXMLUltimaIntegracao(f.getXmlUltimaIntegracaoGerada(), String.valueOf(f.getCodigo()), String.valueOf(novaIntegracao));
                                buf.append(novoXML).append("' where fil_codigo = ").append(f.getCodigo());
                                Conexao.executeUpdate(String.valueOf(f.getCodigo()), st, buf.toString(), true);
                                f.setUtimaIntegracaoGerada(novaIntegracao);
                            }
                            for (Registro r : registros) {
                                buf.delete(0, buf.length());
                                buf.append("update logoffline set off_exportado = true, off_codigoarquivo = ").append(novaIntegracao);
                                buf.append(" where fil_codigo = ").append(r.getInt("fil_codigo"));
                                buf.append(" and fil_coddestino = ").append(r.getInt("fil_coddestino"));
                                buf.append(" and off_codigo = ").append(r.getInt("off_codigo"));
                                Conexao.executeUpdate(r.getString("fil_codigo"), st, buf.toString(), true);
                            }
                            Conexao.arquivaSQL();
                            if (!reenvio) {
                                registros = IntegracaoUtil.getLogParaEnviar(st, String.valueOf(f.getCodigo()), reenvio ? new Long(this.textAnterior.getText()) : null, reenvio ? 0 : 50);
                                continue;
                            }
                            registros = null;
                            continue;
                        }
                        Funcoes.mensagem(this, "Ocorreu um erro ao gerar o arquivo para integra\u00e7\u00e3o. Verifique se o diret\u00f3rio est\u00e1 correto ou as permiss\u00f5es de escrita para o diret\u00f3rio", 1);
                    }
                    if (arquivosGerados.size() > 0) {
                        Funcoes.mensagem(this, arquivosGerados.size() > 1 ? String.valueOf(arquivosGerados.size()) + " arquivos de integra\u00e7\u00e3o gerados com sucesso" : "1 arquivo de integra\u00e7\u00e3o gerado com sucesso", 2);
                    }
                    break block27;
                }
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 informa\u00e7\u00e3o para ser integrada", 2);
            }
            catch (XMLStringBuilderException xex) {
                ErrorLogger.mostraMensagem(this, xex.getMessage(), xex.getStackTrace(), "ExportarDados (224)");
                Conexao.fecharStatement(st);
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "ExportarDados (226)");
                try {
                    Conexao.anulaSQL();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                {
                    catch (Throwable throwable) {
                        Conexao.fecharStatement(st);
                        throw throwable;
                    }
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
        this.buttonExportar.setEnabled(true);
        if (Laboratorio.getExportaIntegracao() != null && Laboratorio.getExportaIntegracao() instanceof ExportaIntegracao2) {
            ((ExportaIntegracao2)Laboratorio.getExportaIntegracao()).setAguardar(false);
        }
        this.progresso.setString(null);
        this.progresso.setValue(0);
    }

    @Override
    public void threadIniciada(EventObject e) {
        this.isExportando = true;
        this.controlaCampos();
    }

    @Override
    public void threadFinalizada(EventObject e) {
        this.isExportando = false;
        this.controlaCampos();
    }
}

