/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.exportacao.integracao;

import jalis.comum.ConexaoTemporaria;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmPadrao;
import jalis.integracao.servidor.Servidor2;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.exportacao.integracao.DadosIntegracaoFilial;
import jalis.laboratorio.exportacao.integracao.EditarComandoSql;
import jalis.laboratorio.exportacao.integracao.IntegracaoUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.SplashMensagem;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.sql.SQLStyledDocument;
import jalis.util.tabela.CorTableCellRenderer;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.sql.SQLException;
import java.sql.Statement;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ErroIntegracao
extends FrmPadrao
implements ActionListener {
    private static final int COLUNA_SELECAO = 0;
    private static final int COLUNA_LOG = 1;
    private static final int COLUNA_OPERACAO = 2;
    private static final int COLUNA_ERRO = 3;
    private JButton buttonFechar = ComponenteFactory.novoJButton("Fechar", 'F', this);
    private JLabel labelFile = new JLabel("Arquivo:");
    private JLabel labelFileErro = new JLabel("Detalhes");
    private SQLStyledDocument styledDoc = new SQLStyledDocument();
    private JButton buttonPath = ComponenteFactory.novoJButton(this, null, null, true);
    private JButton buttonSeleconarTodos = ComponenteFactory.novoJButton("Selecionar todos", 'S', this);
    private JButton buttonLimparSelecao = ComponenteFactory.novoJButton("Limpar sele\u00e7\u00e3o", 'L', this);
    private JButton buttonTestarSelecionado = ComponenteFactory.novoJButton("Testar selecionado", 'T', this);
    private JButton buttonGerarArquivo = ComponenteFactory.novoJButton("Gerar arquivo", 'G', this);
    private JButton buttonExecutarArquivo = ComponenteFactory.novoJButton("Executar", 'E', this);
    private JPanel panelBotoes = new JPanel(new FlowLayout(0));
    private JPanel panelOpcoes = new JPanel(new BorderLayout());
    private JPanel panelBotaoFechar = new JPanel(new FlowLayout());
    private JPanel panelCentro = new JPanel(new GridBagLayout());
    private JLabel textPath = new JLabel();
    private SplashMensagem splashMensagem = null;
    private JTextPane jTextPaneErro = new JTextPane(){

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return true;
        }
    };
    private JScrollPane scrollTextArea = new JScrollPane(this.jTextPaneErro);
    private ModeloGridTable modeloGridTable = null;
    private JTable table = null;
    private JScrollPane scroll = null;
    private CorTableCellRenderer renderer = new CorTableCellRenderer();
    private JLabel labelInfo = ComponenteFactory.novoJLabel("", null, new TitledBorder("Informa\u00e7\u00f5es da integra\u00e7\u00e3o"));

    public ErroIntegracao() {
        this.mostrarTela();
    }

    private void mostrarTela() {
        this.modeloGridTable = new ModeloGridTable(new String[]{"", "Log", "Opera\u00e7\u00e3o"}){

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                Class[] valores = new Class[]{Boolean.class, String.class, String.class, String.class};
                return valores[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                boolean[] valores = new boolean[]{true, false, false};
                return valores[columnIndex];
            }
        };
        this.labelInfo.setFont(new Font(this.labelInfo.getFont().getFontName(), 0, 10));
        this.table = new JTable(this.modeloGridTable);
        this.table.setDefaultRenderer(Object.class, this.renderer);
        this.modeloGridTable.setColumnSize(new int[]{25, 75, 0}, this.table);
        this.table.getTableHeader().addMouseListener(this.modeloGridTable);
        this.table.addMouseListener(this.modeloGridTable);
        this.scroll = new JScrollPane(this.table);
        this.setLayout(new BorderLayout());
        Funcoes.criaBarraDescricao(this, "Verificar arquivo de integra\u00e7\u00e3o", "Verificar os itens recebidos atrav\u00e9s de integra\u00e7\u00e3o", "integracao/integ_arquivo.jpg");
        ScreenUtil.setBorda(new JComponent[]{this.textPath}, new TitledBorder(""));
        this.jTextPaneErro.setEditable(false);
        this.jTextPaneErro.setStyledDocument(this.styledDoc);
        this.panelBotoes.add(this.buttonSeleconarTodos);
        this.panelBotoes.add(this.buttonLimparSelecao);
        this.panelBotoes.add(this.buttonTestarSelecionado);
        this.panelBotoes.add(this.buttonGerarArquivo);
        this.panelBotoes.add(this.buttonExecutarArquivo);
        this.panelBotaoFechar.add(this.buttonFechar);
        this.panelOpcoes.add((Component)this.panelBotoes, "West");
        this.panelOpcoes.add((Component)this.panelBotaoFechar, "East");
        this.add((Component)this.panelOpcoes, "South");
        this.add((Component)this.panelCentro, "Center");
        this.panelCentro.setBorder(ScreenUtil.criarBordaVazia());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 0;
        c.insets = new Insets(1, 0, 0, 0);
        this.panelCentro.add((Component)this.labelFile, c);
        c.fill = 2;
        c.weightx = 1.0;
        c.gridx = 1;
        c.gridwidth = 1;
        this.textPath.setPreferredSize(new Dimension(100, 20));
        this.textPath.setMinimumSize(new Dimension(100, 20));
        this.panelCentro.add((Component)this.textPath, c);
        c.fill = 0;
        c.weightx = 0.0;
        c.gridx = 2;
        c.insets = new Insets(1, 0, 0, 1);
        this.buttonPath.setPreferredSize(new Dimension(20, 20));
        this.buttonPath.setMinimumSize(new Dimension(20, 20));
        this.panelCentro.add((Component)this.buttonPath, c);
        c.fill = 1;
        c.weighty = 1.0;
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 4;
        c.gridheight = 1;
        this.scroll.setPreferredSize(new Dimension(100, 100));
        this.scroll.setMinimumSize(new Dimension(100, 100));
        this.panelCentro.add((Component)this.scroll, c);
        ++c.gridy;
        c.weighty = 0.0;
        this.panelCentro.add((Component)this.labelFileErro, c);
        ++c.gridy;
        this.scrollTextArea.setPreferredSize(new Dimension(100, 100));
        this.scrollTextArea.setMinimumSize(new Dimension(100, 100));
        this.panelCentro.add((Component)this.scrollTextArea, c);
        ++c.gridy;
        this.labelInfo.setPreferredSize(new Dimension(50, 60));
        this.labelInfo.setMinimumSize(new Dimension(50, 60));
        this.panelCentro.add((Component)this.labelInfo, c);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (ErroIntegracao.this.table.getSelectedRow() != -1) {
                    StringBuilder erro = new StringBuilder();
                    int linhaSelecionada = ErroIntegracao.this.table.getSelectedRow();
                    ErroIntegracao.this.mostrarErroSql(erro, linhaSelecionada);
                    ErroIntegracao.this.jTextPaneErro.setText(erro.toString());
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ErroIntegracao.this.scrollTextArea.getVerticalScrollBar().setValue(0);
                        }
                    });
                }
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && e.getModifiersEx() == 64) {
                    ErroIntegracao.this.editarComando();
                }
            }
        });
        this.labelFile.setDisplayedMnemonic('A');
        ScreenUtil.addActionMap(this.panelCentro, KeyStroke.getKeyStroke(65, 8), "ALT_A", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ErroIntegracao.this.buttonPath.doClick();
            }
        });
    }

    private void editarComando() {
        int linhaSelecionada = this.table.getSelectedRow();
        String comandoSql = this.modeloGridTable.getValueAt(linhaSelecionada, 2).toString();
        EditarComandoSql comentoSqlIntegracao = EditarComandoSql.novaInstancia(Laboratorio.getInstancia(), comandoSql);
        if (comentoSqlIntegracao != null && comentoSqlIntegracao.getOK() && !Funcoes.textoVazio(comentoSqlIntegracao.getSqlEditado())) {
            this.modeloGridTable.setValueAt(comentoSqlIntegracao.getSqlEditado(), linhaSelecionada, 2);
            StringBuilder sql = new StringBuilder();
            sql.append("Sql : ");
            sql.append("\n");
            sql.append("C\u00f3digo Log : ");
            sql.append((String)this.modeloGridTable.getValueAt(linhaSelecionada, 1));
            sql.append("\n");
            sql.append((String)this.modeloGridTable.getValueAt(linhaSelecionada, 2));
            this.jTextPaneErro.setText(sql.toString());
        }
    }

    private void mostrarErroSql(StringBuilder erro, int linhaSelecionada) {
        String error = (String)this.modeloGridTable.getValueAt(linhaSelecionada, 3);
        erro.append(error);
        if (!Funcoes.textoVazio(error)) {
            erro.append("\n\n");
        }
        erro.append("Sql : ");
        erro.append("\n");
        erro.append("C\u00f3digo Log : ");
        erro.append((String)this.modeloGridTable.getValueAt(linhaSelecionada, 1));
        erro.append("\n");
        erro.append((String)this.modeloGridTable.getValueAt(linhaSelecionada, 2));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonFechar) {
            this.setVisible(false);
        } else if (e.getSource() == this.buttonPath) {
            this.alterarPath();
        } else if (e.getSource() == this.buttonSeleconarTodos) {
            this.selecionarTodos(true);
        } else if (e.getSource() == this.buttonLimparSelecao) {
            this.selecionarTodos(false);
        } else if (e.getSource() == this.buttonTestarSelecionado) {
            this.testarSelecionado();
        } else if (e.getSource() == this.buttonGerarArquivo) {
            this.gerarArquivo();
        } else if (e.getSource() == this.buttonExecutarArquivo) {
            this.executarArquivo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executarArquivo() {
        SplashMensagem spl = null;
        try {
            if (!Funcoes.textoVazio(this.textPath.getText())) {
                File file = new File(this.textPath.getText());
                FileReader fileReader = new FileReader(file);
                BufferedReader bufferedReader = new BufferedReader(fileReader);
                StringBuilder conteudo = new StringBuilder();
                String linha = "";
                while ((linha = bufferedReader.readLine()) != null) {
                    conteudo.append(linha);
                }
                bufferedReader.close();
                String filial = StringUtil.getValor(conteudo.toString(), "filial");
                DadosIntegracaoFilial dadosFilial = IntegracaoUtil.buscaDadosFilial(this.getStatement(), filial);
                Object retorno = Servidor2.validaSequencialArquivo(file.getName(), dadosFilial, file.getParent(), StringUtil.getCharsetIntegracao(ParametrosLocais.getParametro("codificacaoIntegracaoOffline")));
                if (retorno instanceof Registro) {
                    for (int i = 0; i < this.modeloGridTable.getRowCount(); ++i) {
                        this.modeloGridTable.setValueAt(true, i, 0);
                    }
                    if (!this.testarSelecionado()) {
                        return;
                    }
                    spl = SplashMensagem.getInstancia(this);
                    spl.mostrar("Executando...");
                    Registro registro = (Registro)retorno;
                    String logUltimo = "";
                    String arquivo = registro.getString("arquivo");
                    for (int i = 0; i < this.modeloGridTable.getRowCount(); ++i) {
                        String sql = this.modeloGridTable.getValueAt(i, 2).toString();
                        logUltimo = this.modeloGridTable.getValueAt(i, 1).toString();
                        ConexaoTemporaria.execute(this.getStatement(), sql);
                    }
                    String ultimoIntegracaoRecebida = IntegracaoUtil.atualizarXMLUltimaIntegracao(dadosFilial.getXmlUltimaIntegracaoRecebida(), filial, arquivo);
                    String ultimoLogIntegracaoRecebida = IntegracaoUtil.atualizarXMLUltimaIntegracao(dadosFilial.getXmlUltimoLogIntegracaoRecebido(), filial, logUltimo);
                    StringBuilder buf = new StringBuilder();
                    buf.append(" update filiais_postocoleta ");
                    buf.append("    set fil_integracaorecebida = '").append(ultimoIntegracaoRecebida).append("' ");
                    buf.append("    ,fil_logintegracaorecebido = '").append(ultimoLogIntegracaoRecebida).append("' ");
                    buf.append("  where fil_codigo = ").append(dadosFilial.getCodigo());
                    ConexaoTemporaria.executeUpdate(Variaveis.filialPadrao, ConexaoTemporaria.getStatement(), buf.toString(), true);
                    ConexaoTemporaria.arquivaSQL();
                    this.modeloGridTable.clear();
                    this.textPath.setText("");
                    this.jTextPaneErro.setText("");
                    this.labelInfo.setText("");
                    Funcoes.mensagem(this, "Arquivo executado com sucesso.", 2);
                } else if (retorno instanceof Long && retorno != null) {
                    Funcoes.mensagem(this, "O arquivo a ser executado deve ser o de n\u00famero: " + retorno, 2);
                }
            }
        }
        catch (Exception e) {
            try {
                ConexaoTemporaria.anulaSQL();
                ErrorLogger.mostraMensagem(this, "Erro ao processar o arquivo.\n" + e.getMessage(), e.getStackTrace());
            }
            catch (SQLException e1) {
                ErrorLogger.mostraMensagem(this, e1.getMessage(), e1.getStackTrace());
            }
        }
        finally {
            if (spl != null) {
                spl.apagar();
            }
        }
    }

    private void gerarArquivo() {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.modeloGridTable.getRowCount(); ++i) {
            buf.append(this.modeloGridTable.getValueAt(i, 2).toString()).append(";\n");
        }
        if (Funcoes.textoVazio(buf.toString())) {
            Funcoes.mensagem(this, "N\u00e3o h\u00e1 logs para gerar o arquivo.", 2);
            return;
        }
        JFileChooser chooser = ComponenteFactory.novoJFileChooser("Salvar");
        chooser.setApproveButtonText("Salvar");
        chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
        chooser.setFileFilter(ComponenteFactory.novoFileFilter("Standard Query Language (*.sql)", "sql"));
        if (chooser.showSaveDialog(null) == 0) {
            String nomeArquivo = chooser.getSelectedFile().getPath();
            try {
                StringUtil.escreverArquivoTexto(nomeArquivo + ".sql", buf.toString());
                Funcoes.mensagem(this, "Arquivo gerado com sucesso.", 5);
            }
            catch (Exception e) {
                Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel gerar o arquivo " + nomeArquivo + ".\nMensagem: " + e.getMessage(), 5);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean testarSelecionado() {
        boolean retorno = true;
        if (Funcoes.textoVazio(this.textPath.getText())) {
            Funcoes.mensagem(this, "Selecione o arquivo", 2);
            return false;
        }
        if (!this.validarSelecionado()) {
            return false;
        }
        this.splashMensagem = new SplashMensagem();
        this.splashMensagem.mostrar("Aguarde...");
        int linhaExecao = 0;
        Statement st = ConexaoTemporaria.getStatement();
        for (int i = 0; i < this.modeloGridTable.getRowCount(); ++i) {
            String operacao;
            linhaExecao = i;
            Boolean selecionado = (Boolean)this.modeloGridTable.getValueAt(i, 0);
            if (!selecionado.booleanValue() || Funcoes.textoVazio(operacao = (String)this.modeloGridTable.getValueAt(i, 2))) continue;
            try {
                ConexaoTemporaria.executeUpdate(null, st, operacao, true);
                continue;
            }
            catch (Exception e) {
                this.renderer.setCorLinha(Color.red, linhaExecao);
                this.modeloGridTable.setValueAt("Mensagem : " + e.getMessage(), linhaExecao, 3);
                this.repaint();
                retorno = false;
            }
        }
        try {
            ConexaoTemporaria.anulaSQL();
        }
        catch (Exception e) {
            Funcoes.mensagem(this, "Erro ao cancelar transa\u00e7\u00e3o", 1);
            retorno = false;
        }
        finally {
            try {
                st.close();
            }
            catch (Exception e) {
                Funcoes.mensagem(this, "Erro ao cancelar transa\u00e7\u00e3o", 1);
                retorno = false;
            }
            this.splashMensagem.apagar();
        }
        for (int i = 0; i < this.modeloGridTable.getRowCount(); ++i) {
            String descErro = (String)this.modeloGridTable.getValueAt(i, 3);
            Boolean selecionado = (Boolean)this.modeloGridTable.getValueAt(i, 0);
            if (Funcoes.textoVazio(descErro) || !selecionado.booleanValue()) continue;
            this.table.getSelectionModel().setSelectionInterval(i, i);
            StringBuilder erro = new StringBuilder();
            int linhaSelecionada = this.table.getSelectedRow();
            this.mostrarErroSql(erro, i);
            this.jTextPaneErro.setText(erro.toString());
            break;
        }
        return retorno;
    }

    private boolean validarSelecionado() {
        boolean algumSelecionado = false;
        for (int i = 0; i < this.modeloGridTable.getRowCount() && !(algumSelecionado = ((Boolean)this.modeloGridTable.getValueAt(i, 0)).booleanValue()); ++i) {
        }
        if (!algumSelecionado) {
            Funcoes.mensagem(this, "Selecione os registros.", 2);
        }
        return algumSelecionado;
    }

    private void selecionarTodos(boolean selecao) {
        for (int i = 0; i < this.modeloGridTable.getRowCount(); ++i) {
            this.modeloGridTable.setValueAt(selecao, i, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lerArquivo(String path) {
        block10: {
            this.buttonExecutarArquivo.setVisible(true);
            if (Funcoes.textoVazio(this.textPath.getText())) {
                Funcoes.mensagem(this, "Selecione o arquivo", 2);
                return;
            }
            this.jTextPaneErro.setText("");
            try {
                this.modeloGridTable.clear();
                if (Funcoes.textoVazio(path)) break block10;
                File file = new File(path);
                FileReader fileReader = new FileReader(file);
                StringBuilder conteudo = new StringBuilder();
                try (BufferedReader bufferedReader = null;){
                    String tipoFilial;
                    bufferedReader = new BufferedReader(fileReader);
                    String linha = "";
                    while ((linha = bufferedReader.readLine()) != null) {
                        conteudo.append(linha);
                    }
                    String identificaoArquivo = file.getName().substring(0, 1);
                    if (identificaoArquivo.equalsIgnoreCase(tipoFilial = ParametrosGerais.getTipoIntegracao()) || tipoFilial.equalsIgnoreCase("N")) {
                        this.buttonExecutarArquivo.setVisible(false);
                    }
                }
                String filial = StringUtil.getValor(conteudo.toString(), "filial");
                String versao = StringUtil.getValor(conteudo.toString(), "versao");
                this.preencheFiliais(filial);
                String compactado = StringUtil.getValor(conteudo.toString(), "data");
                String descompactado = StringUtil.descompactar(IntegracaoUtil.VersaoXML.getVersaoXML(versao), compactado, StringUtil.getCharsetIntegracao(ParametrosLocais.getParametro("codificacaoIntegracaoOffline")));
                String[] linhas = StringUtil.getValores(descompactado, "operacao");
                String[] registros = StringUtil.getValores(descompactado, "registro");
                for (int i = 0; i < linhas.length; ++i) {
                    this.modeloGridTable.addLine(new Object[]{true, StringUtil.getValor(registros[i], "codigo"), linhas[i], ""});
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                Funcoes.mensagem(this, "Erro ao processar arquivo", 1);
            }
        }
        this.renderer.limpar();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void preencheFiliais(String filial) {
        Statement st = ConexaoTemporaria.getStatement();
        try {
            DadosIntegracaoFilial dadosIntegracaoFilial = IntegracaoUtil.buscaDadosFilial(st, filial);
            if (dadosIntegracaoFilial != null) {
                String informacaoIntegracao = "";
                informacaoIntegracao = "<html>";
                informacaoIntegracao = informacaoIntegracao + "Filial: ";
                informacaoIntegracao = informacaoIntegracao + dadosIntegracaoFilial.getCodigo();
                informacaoIntegracao = informacaoIntegracao + "  ";
                informacaoIntegracao = informacaoIntegracao + dadosIntegracaoFilial.getDescricao();
                informacaoIntegracao = informacaoIntegracao + " - ";
                informacaoIntegracao = informacaoIntegracao + "\u00daltima integra\u00e7\u00e3o enviada: ";
                informacaoIntegracao = informacaoIntegracao + dadosIntegracaoFilial.getUltimaIntegracaoGerada();
                informacaoIntegracao = informacaoIntegracao + " <br> ";
                informacaoIntegracao = informacaoIntegracao + "\u00daltima integra\u00e7\u00e3o recebida: ";
                informacaoIntegracao = informacaoIntegracao + dadosIntegracaoFilial.getUltimaIntegracaoRecebida();
                informacaoIntegracao = informacaoIntegracao + " - ";
                informacaoIntegracao = informacaoIntegracao + "\u00daltima log de integra\u00e7\u00e3o recebido: ";
                informacaoIntegracao = informacaoIntegracao + dadosIntegracaoFilial.getUltimoLogIntegracaoRecebido();
                informacaoIntegracao = informacaoIntegracao + " - ";
                informacaoIntegracao = informacaoIntegracao + "Logs para enviar: ";
                informacaoIntegracao = informacaoIntegracao + dadosIntegracaoFilial.getLogsParaEnviar();
                informacaoIntegracao = informacaoIntegracao + "</html>";
                this.labelInfo.setText(informacaoIntegracao.toString());
            } else {
                this.labelInfo.setText("");
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
        }
        finally {
            ConexaoTemporaria.fecharStatement(st);
        }
    }

    private void alterarPath() {
        String caminhoAux = this.textPath.getText();
        this.textPath.setText("");
        JFileChooser file = ComponenteFactory.novoJFileChooser("Arquivo");
        if (!Funcoes.textoVazio(this.textPath.getText()) && Funcoes.diretorioExiste(this.textPath.getText())) {
            file.setCurrentDirectory(new File(this.textPath.getText()));
        }
        file.setFileFilter(ComponenteFactory.novoFileFilter("Arquivo Extens\u00e3o", "thi", "thw"));
        file.setFileSelectionMode(0);
        if (file.showOpenDialog(this) == 0) {
            this.textPath.setText(file.getSelectedFile().getAbsolutePath());
        }
        if (!Funcoes.textoVazio(this.textPath.getText())) {
            this.modeloGridTable.clear();
            this.jTextPaneErro.setText("");
            this.labelInfo.setText("");
            this.lerArquivo(this.textPath.getText());
        } else {
            this.textPath.setText(caminhoAux);
        }
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0907000380");
    }
}

