/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.exportacao.ids;

import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.laboratorio.exportacao.ids.DadosErrosIntegracaoIds;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.laboratorio.relatorios.util.RelatorioUtil;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class JanelaErrosIntegracaoIds
extends JDialog
implements ActionListener {
    private final int COLUNA_FILIAL = 0;
    private final int COLUNA_LOG = 1;
    private final int COLUNA_REQUISICAO = 2;
    private final int COLUNA_XML = 3;
    private final int COLUNA_OBJETO = 4;
    private JLabel labelLocalizar = new JLabel("Localizar XML contendo:");
    private TTextField textLocalizar = new TTextField();
    private JPanel panelLogs = new JPanel(new GridBagLayout());
    private JPanel panelExcecao = new JPanel(new BorderLayout());
    private JPanel panelPilhaExcecao = new JPanel(new BorderLayout());
    private JPanel panelBotoes = new JPanel(new BorderLayout());
    private JButton buttonMarcarComoExportado = new JButton("Marcar como exportado");
    private JButton buttonFechar = new JButton("Fechar");
    private JButton buttonLocalizar = new JButton("Localizar");
    private JButton buttonImprimir = new JButton("Imprimir");
    private ModeloGridTable modeloLogs = new ModeloGridTable(new String[]{"Filial", "Log", "Requisi\u00e7\u00e3o", "XML/Mensagem"});
    private JTable tableLogs = new JTable(this.modeloLogs);
    private JScrollPane scrollLogs = new JScrollPane(this.tableLogs);
    private JTextPane textPaneExcecao = new JTextPane();
    private JScrollPane scrollExcecao = new JScrollPane(this.textPaneExcecao);
    private JTextPane textPanePilhaExcecao = new JTextPane();
    private JScrollPane scrollPilhaExcecao = new JScrollPane(this.textPanePilhaExcecao);
    private PreparedStatement prstMarcarExportado = null;
    private DadosErrosIntegracaoIds errosIntegracao = null;
    private boolean podeMarcarExportado = false;
    private JPopupMenu menuImprimir = new JPopupMenu();
    private String[] camposRelatorio = new String[]{"codigoLog", "erroLog", "operacaoLog", "usuarioLogado"};

    public JanelaErrosIntegracaoIds(Frame pai, DadosErrosIntegracaoIds errosIntegracao, boolean podeMarcarExportado) {
        super(pai);
        this.errosIntegracao = errosIntegracao;
        this.podeMarcarExportado = podeMarcarExportado;
        this.camposRelatorio = ArraysUtil.concatenar(this.camposRelatorio, Constantes.CAMPOS_FILIAL);
        this.setTitle("Mensagens da Integra\u00e7\u00e3o IDS Sa\u00fade");
        this.setModal(true);
        this.montaTela();
        this.carregaDados();
        StringBuilder buf = new StringBuilder();
        buf.append(" update logids ");
        buf.append("    set ids_exportado = true ");
        buf.append("  where fil_codigo = ? ");
        buf.append("    and ids_codigo = ? ");
        this.prstMarcarExportado = Conexao.getPreparedStatement(buf.toString());
        this.setVisible(true);
    }

    private void carregaDados() {
        this.modeloLogs.clear();
        StringBuilder buf = new StringBuilder();
        buf.append("select * from logids");
        buf.append(" where ");
        buf.append(" not ids_exportado and ids_falha ");
        buf.append(" order by ids_datahora, fil_codigo, req_codigo desc");
        Statement st = Conexao.getStatement();
        try {
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            while (rs.next()) {
                Registro reg = new Registro(rs);
                this.modeloLogs.addLine(new Object[]{reg.getValor("fil_codigo"), reg.getValor("ids_codigo"), reg.getValor("req_codigo"), reg.getValor("ids_mensagem"), reg});
            }
            if (this.modeloLogs.getRowCount() > 0) {
                this.modeloLogs.ordenarColunaSemTrocarSentido(1);
            }
            rs.close();
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e2o foi poss\u00edvel carregar os logs.\n" + e.getMessage(), e.getStackTrace());
        }
    }

    private void montaPanelLogs() {
        this.panelLogs.setBorder(new TitledBorder("Logs"));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 3;
        this.panelLogs.add((Component)this.scrollLogs, c);
        ++c.gridy;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        this.labelLocalizar.setDisplayedMnemonic('o');
        this.labelLocalizar.setLabelFor(this.textLocalizar);
        this.panelLogs.add((Component)this.labelLocalizar, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.textLocalizar.setPreferredSize(new Dimension(20, 20));
        this.textLocalizar.setMinimumSize(new Dimension(20, 20));
        this.panelLogs.add((Component)this.textLocalizar, c);
        ++c.gridx;
        c.weightx = 0.0;
        c.fill = 0;
        this.buttonLocalizar.setMnemonic('L');
        this.buttonLocalizar.setPreferredSize(new Dimension(100, 20));
        this.buttonLocalizar.setMinimumSize(new Dimension(100, 20));
        this.buttonLocalizar.setMargin(new Insets(1, 1, 1, 1));
        this.buttonLocalizar.addActionListener(this);
        this.panelLogs.add((Component)this.buttonLocalizar, c);
        this.modeloLogs.setColumnSize(new int[]{40, 70, 70, 0}, this.tableLogs);
        this.tableLogs.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int row = JanelaErrosIntegracaoIds.this.tableLogs.getSelectedRow();
                if (row > -1) {
                    Object obj;
                    Object object = obj = JanelaErrosIntegracaoIds.this.modeloLogs != null && JanelaErrosIntegracaoIds.this.modeloLogs.getRowCount() > 0 ? JanelaErrosIntegracaoIds.this.modeloLogs.getValueAt(row, 4) : null;
                    if (obj != null) {
                        Registro reg = (Registro)obj;
                        JanelaErrosIntegracaoIds.this.textPaneExcecao.setText(reg.getString("ids_mensagem"));
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                JanelaErrosIntegracaoIds.this.textPaneExcecao.scrollRectToVisible(new Rectangle(0, 0));
                                JanelaErrosIntegracaoIds.this.textPanePilhaExcecao.scrollRectToVisible(new Rectangle(0, 0));
                            }
                        });
                    }
                }
            }
        });
    }

    private void montaPanelExcecao() {
        this.panelExcecao.setBorder(new TitledBorder("Exce\u00e7\u00e3o"));
        this.panelExcecao.add(this.scrollExcecao);
        this.textPaneExcecao.setEditable(false);
    }

    private void montaPanelPilhaExcecao() {
        this.panelPilhaExcecao.setBorder(new TitledBorder("Pilha de exce\u00e7\u00e3o"));
        this.panelPilhaExcecao.add(this.scrollPilhaExcecao);
        this.textPanePilhaExcecao.setEditable(false);
    }

    private void montaTela() {
        JPanel panelCentral = (JPanel)this.getContentPane();
        panelCentral.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 1;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 0.4;
        panelCentral.add((Component)this.panelLogs, c);
        ++c.gridy;
        c.weighty = 0.4;
        panelCentral.add((Component)this.panelExcecao, c);
        ++c.gridy;
        c.weighty = 0.0;
        panelCentral.add((Component)this.panelBotoes, c);
        this.montaPanelLogs();
        this.montaPanelExcecao();
        this.montaPanelPilhaExcecao();
        this.montaPanelBotoes();
        Funcoes.montaEnter((JComponent)this.panelLogs);
        this.setSize(700, 500);
        this.setResizable(false);
        ScreenUtil.centralizar(this);
    }

    private void montaPanelBotoes() {
        JPanel panelEsquerda = new JPanel(new FlowLayout(0));
        JPanel panelDireita = new JPanel(new FlowLayout(2));
        this.panelBotoes.add((Component)panelEsquerda, "West");
        this.panelBotoes.add((Component)panelDireita, "East");
        panelEsquerda.add(this.buttonMarcarComoExportado);
        panelEsquerda.add(this.buttonImprimir);
        panelDireita.add(this.buttonFechar);
        this.buttonMarcarComoExportado.setMnemonic('E');
        this.buttonMarcarComoExportado.addActionListener(this);
        this.buttonMarcarComoExportado.setEnabled(false);
        this.buttonFechar.setMnemonic('F');
        this.buttonFechar.addActionListener(this);
        this.buttonImprimir.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonFechar) {
            this.setVisible(false);
        } else if (e.getSource() == this.buttonMarcarComoExportado) {
            this.marcarComoExportado();
        } else if (e.getSource() == this.buttonLocalizar) {
            this.localizar();
        } else if (e.getSource() == this.buttonImprimir) {
            this.imprimirRelatorio();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void imprimirRelatorio() {
        String modeloRelatorio = "<relatorio><alturaPagina>21.0</alturaPagina><larguraPagina>29.7</larguraPagina><margens><esquerda>1.5</esquerda><direita>1.5</direita><superior>1.5</superior><inferior>1.5</inferior></margens><forcarRetrato>Nao</forcarRetrato><linhasGuias></linhasGuias><bandas><banda><tipoBanda>0</tipoBanda><nome>Banda1</nome><altura>38.0</altura><campoChave></campoChave><nomeBandaFilha></nomeBandaFilha><nomeBandaRodapeGrupo></nomeBandaRodapeGrupo><quebrarPagina>false</quebrarPagina><itens><itemBanda><tipoItem>jalis.relatorio.gerador.item.Rotulo</tipoItem><nome>Rotulo1</nome><retangulo><x>1</x><y>1</y><largura>114.0</largura><altura>10.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>8</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><texto>Listagem de erros na integra\u00e7\u00e3o</texto></itemBanda><itemBanda><tipoItem>jalis.relatorio.gerador.item.CampoBanco</tipoItem><nome>CampoBanco1</nome><retangulo><x>1</x><y>13</y><largura>295.0</largura><altura>10.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>8</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><nomeCampo>descricaoFilial</nomeCampo><mascara></mascara></itemBanda><itemBanda><tipoItem>jalis.relatorio.gerador.item.Expressao</tipoItem><nome>Expressao1</nome><retangulo><x>626</x><y>1</y><largura>128.0</largura><altura>9.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>8</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>4</alinhamentoHorizontal><quebrarLinhas>false</quebrarLinhas><quebrarPalavras>false</quebrarPalavras><expressao>data(dataHoraCorrente; \"dd/MM/aaaa hh:mm\")</expressao><mascara></mascara></itemBanda><itemBanda><tipoItem>jalis.relatorio.gerador.item.Expressao</tipoItem><nome>Expressao2</nome><retangulo><x>684</x><y>13</y><largura>70.0</largura><altura>9.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>8</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>4</alinhamentoHorizontal><quebrarLinhas>false</quebrarLinhas><quebrarPalavras>false</quebrarPalavras><expressao>\"P\u00e1gina: \" + paginaCorrente + \"/\" + quantidadePaginas</expressao><mascara></mascara></itemBanda><itemBanda><tipoItem>jalis.relatorio.gerador.item.Forma</tipoItem><nome>Forma1</nome><retangulo><x>1</x><y>23</y><largura>753.0</largura><altura>4.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>12</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>0</alinhamentoHorizontal><tipo>2</tipo><corLinha>-16777216</corLinha><corPreenchimento>-1</corPreenchimento><alinhamentoVertical>0</alinhamentoVertical><espessura>1</espessura></itemBanda><itemBanda><tipoItem>jalis.relatorio.gerador.item.Rotulo</tipoItem><nome>Rotulo4</nome><retangulo><x>35</x><y>26</y><largura>40.0</largura><altura>10.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><texto>Erro</texto></itemBanda><itemBanda><tipoItem>jalis.relatorio.gerador.item.Rotulo</tipoItem><nome>Rotulo3</nome><retangulo><x>1</x><y>26</y><largura>30.0</largura><altura>10.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><texto>C\u00f3digo</texto></itemBanda></itens></banda><banda><tipoBanda>2</tipoBanda><nome>Banda2</nome><altura>9.0</altura><colunas>0</colunas><entreColunas>0</entreColunas><campoChave></campoChave><nomeBandaFilha></nomeBandaFilha><nomeBandaRodapeGrupo></nomeBandaRodapeGrupo><quebrarPagina>false</quebrarPagina><itens><itemBanda><tipoItem>jalis.relatorio.gerador.item.CampoBanco</tipoItem><nome>CampoBanco2</nome><retangulo><x>1</x><y>1</y><largura>30.0</largura><altura>7.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>4</alinhamentoHorizontal><nomeCampo>codigoLog</nomeCampo><mascara></mascara></itemBanda><itemBanda><tipoItem>jalis.relatorio.gerador.item.CampoBanco</tipoItem><nome>CampoBanco3</nome><retangulo><x>36</x><y>0</y><largura>717.0</largura><altura>7.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><nomeCampo>erroLog</nomeCampo><mascara></mascara></itemBanda></itens></banda></bandas></relatorio>";
        ModeloGridTable modelo = new ModeloGridTable(this.camposRelatorio);
        if (this.modeloLogs != null) {
            for (int i = 0; i < this.modeloLogs.getRowCount(); ++i) {
                String erro = (String)this.modeloLogs.getValueAt(i, 3);
                Object[] o = new Object[this.camposRelatorio.length];
                for (int col = 0; col < this.camposRelatorio.length; ++col) {
                    o[col] = this.camposRelatorio[col].equalsIgnoreCase("usuarioLogado") ? Variaveis.login : (this.camposRelatorio[col].equalsIgnoreCase("erroLog") ? erro : (this.camposRelatorio[col].equalsIgnoreCase("codigoLog") ? (Integer)this.modeloLogs.getValueAt(i, 1) : ""));
                }
                modelo.addLine(o);
                HashMap<Integer, Registro> filiais = new HashMap<Integer, Registro>();
                Object f = null;
                Statement st = Conexao.getStatement();
                try {
                    Registro regFilial = null;
                    if (!filiais.containsKey(this.modeloLogs.getValueAt(i, 0))) {
                        regFilial = RelatorioUtil.pegaDadosFilial(st, this.modeloLogs.getValueAt(i, 0).toString());
                        filiais.put((Integer)this.modeloLogs.getValueAt(i, 0), regFilial);
                    } else {
                        regFilial = (Registro)filiais.get(Integer.valueOf(this.modeloLogs.getValueAt(i, 0).toString()));
                    }
                    RelatorioUtil.preencheDadosFilial(regFilial, modelo);
                }
                catch (Exception exception) {
                    Conexao.fecharStatement(st);
                    continue;
                    catch (Throwable throwable) {
                        Conexao.fecharStatement(st);
                        throw throwable;
                    }
                }
                Conexao.fecharStatement(st);
                continue;
            }
            if (modelo.getRowCount() > 0) {
                Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                gerador.setPreVisualizar(true);
                gerador.setZoomPreVisualizar(0.5f);
                gerador.executar("<relatorio><alturaPagina>21.0</alturaPagina><larguraPagina>29.7</larguraPagina><margens><esquerda>1.5</esquerda><direita>1.5</direita><superior>1.5</superior><inferior>1.5</inferior></margens><forcarRetrato>Nao</forcarRetrato><linhasGuias></linhasGuias><bandas><banda><tipoBanda>0</tipoBanda><nome>Banda1</nome><altura>38.0</altura><campoChave></campoChave><nomeBandaFilha></nomeBandaFilha><nomeBandaRodapeGrupo></nomeBandaRodapeGrupo><quebrarPagina>false</quebrarPagina><itens><itemBanda><tipoItem>jalis.relatorio.gerador.item.Rotulo</tipoItem><nome>Rotulo1</nome><retangulo><x>1</x><y>1</y><largura>114.0</largura><altura>10.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>8</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><texto>Listagem de erros na integra\u00e7\u00e3o</texto></itemBanda><itemBanda><tipoItem>jalis.relatorio.gerador.item.CampoBanco</tipoItem><nome>CampoBanco1</nome><retangulo><x>1</x><y>13</y><largura>295.0</largura><altura>10.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>8</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><nomeCampo>descricaoFilial</nomeCampo><mascara></mascara></itemBanda><itemBanda><tipoItem>jalis.relatorio.gerador.item.Expressao</tipoItem><nome>Expressao1</nome><retangulo><x>626</x><y>1</y><largura>128.0</largura><altura>9.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>8</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>4</alinhamentoHorizontal><quebrarLinhas>false</quebrarLinhas><quebrarPalavras>false</quebrarPalavras><expressao>data(dataHoraCorrente; \"dd/MM/aaaa hh:mm\")</expressao><mascara></mascara></itemBanda><itemBanda><tipoItem>jalis.relatorio.gerador.item.Expressao</tipoItem><nome>Expressao2</nome><retangulo><x>684</x><y>13</y><largura>70.0</largura><altura>9.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>8</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>4</alinhamentoHorizontal><quebrarLinhas>false</quebrarLinhas><quebrarPalavras>false</quebrarPalavras><expressao>\"P\u00e1gina: \" + paginaCorrente + \"/\" + quantidadePaginas</expressao><mascara></mascara></itemBanda><itemBanda><tipoItem>jalis.relatorio.gerador.item.Forma</tipoItem><nome>Forma1</nome><retangulo><x>1</x><y>23</y><largura>753.0</largura><altura>4.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>12</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>0</alinhamentoHorizontal><tipo>2</tipo><corLinha>-16777216</corLinha><corPreenchimento>-1</corPreenchimento><alinhamentoVertical>0</alinhamentoVertical><espessura>1</espessura></itemBanda><itemBanda><tipoItem>jalis.relatorio.gerador.item.Rotulo</tipoItem><nome>Rotulo4</nome><retangulo><x>35</x><y>26</y><largura>40.0</largura><altura>10.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><texto>Erro</texto></itemBanda><itemBanda><tipoItem>jalis.relatorio.gerador.item.Rotulo</tipoItem><nome>Rotulo3</nome><retangulo><x>1</x><y>26</y><largura>30.0</largura><altura>10.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><texto>C\u00f3digo</texto></itemBanda></itens></banda><banda><tipoBanda>2</tipoBanda><nome>Banda2</nome><altura>9.0</altura><colunas>0</colunas><entreColunas>0</entreColunas><campoChave></campoChave><nomeBandaFilha></nomeBandaFilha><nomeBandaRodapeGrupo></nomeBandaRodapeGrupo><quebrarPagina>false</quebrarPagina><itens><itemBanda><tipoItem>jalis.relatorio.gerador.item.CampoBanco</tipoItem><nome>CampoBanco2</nome><retangulo><x>1</x><y>1</y><largura>30.0</largura><altura>7.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>4</alinhamentoHorizontal><nomeCampo>codigoLog</nomeCampo><mascara></mascara></itemBanda><itemBanda><tipoItem>jalis.relatorio.gerador.item.CampoBanco</tipoItem><nome>CampoBanco3</nome><retangulo><x>36</x><y>0</y><largura>717.0</largura><altura>7.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><nomeCampo>erroLog</nomeCampo><mascara></mascara></itemBanda></itens></banda></bandas></relatorio>", (TableModel)modelo, true);
            } else {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
            }
        }
    }

    private void marcarComoExportado() {
        int row = this.tableLogs.getSelectedRow();
        if (row > -1) {
            Integer filial = (Integer)this.modeloLogs.getValueAt(row, 0);
            Integer log = (Integer)this.modeloLogs.getValueAt(row, 1);
            if (log != null && filial != null) {
                try {
                    this.prstMarcarExportado.setInt(1, filial);
                    this.prstMarcarExportado.setInt(2, log);
                    int qtde = this.prstMarcarExportado.executeUpdate();
                    if (qtde == 0) {
                        throw new Exception("O log n\u00e3o foi atualizado. Filial = " + filial + ", log = " + log);
                    }
                    Conexao.arquivaSQL();
                    if (qtde > 0) {
                        this.modeloLogs.removeLine(row);
                    }
                }
                catch (Exception e) {
                    try {
                        Conexao.anulaSQL();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel marcar o log como exportado.\n" + e.getMessage(), e.getStackTrace());
                }
            }
        }
        this.buttonMarcarComoExportado.setEnabled(false);
    }

    private void localizar() {
        int row;
        if (Funcoes.textoVazio(this.textLocalizar)) {
            return;
        }
        String textoLocalizar = this.textLocalizar.getText();
        for (int i = row = this.tableLogs.getSelectedRow() + 1; i < this.modeloLogs.getRowCount(); ++i) {
            String xml;
            Registro excecao = (Registro)this.modeloLogs.getValueAt(i, 4);
            if (excecao == null || Funcoes.textoVazio(xml = excecao.getString("ids_mensagem")) || !xml.contains(textoLocalizar)) continue;
            this.tableLogs.getSelectionModel().setSelectionInterval(i, i);
            this.tableLogs.scrollRectToVisible(this.tableLogs.getCellRect(i, 0, false));
            break;
        }
    }

    class LogRenderer
    extends JTextArea
    implements TableCellRenderer {
        public LogRenderer() {
            this.setLineWrap(true);
            this.setWrapStyleWord(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setText(value == null ? "" : value.toString());
            this.setSize(table.getColumnModel().getColumn(column).getWidth(), this.getPreferredSize().height);
            if (table.getRowHeight(row) != this.getPreferredSize().height) {
                table.setRowHeight(row, this.getPreferredSize().height);
            }
            this.setBackground(table.getBackground());
            this.setForeground(table.getForeground());
            if (isSelected) {
                this.setBackground((Color)UIManager.get("Table.selectionBackground"));
                this.setForeground((Color)UIManager.get("Table.selectionForeground"));
            }
            return this;
        }
    }
}

