/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.exportacao.filial.remover;

import jalis.laboratorio.exportacao.filial.remover.FiltroExportaFilial;
import jalis.util.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.AbstractListModel;

class ModeloList
extends AbstractListModel {
    ArrayList<FiltroExportaFilial> itens = new ArrayList();

    ModeloList() {
    }

    @Override
    public int getSize() {
        return this.itens.size();
    }

    @Override
    public Object getElementAt(int index) {
        return index > -1 && this.itens.size() > 0 ? this.itens.get(index) : null;
    }

    public void addElement(FiltroExportaFilial item) {
        if (!this.itens.contains(item)) {
            this.itens.add(item);
            Collections.sort(this.itens, new Comparator<FiltroExportaFilial>(){

                @Override
                public int compare(FiltroExportaFilial o1, FiltroExportaFilial o2) {
                    return o1 != null && o2 != null ? StringUtil.removerAcentos(o1.getTituloFiltro().toLowerCase()).compareTo(StringUtil.removerAcentos(o2.getTituloFiltro().toLowerCase())) : 0;
                }
            });
            this.fireContentsChanged(this, 0, this.itens.size() - 1);
        }
    }

    public ArrayList<FiltroExportaFilial> getItens() {
        return this.itens;
    }

    public void removeAllItens() {
        this.itens.clear();
        this.fireContentsChanged(this, 0, this.itens.size() - 1);
    }

    public void removeItem(int index) {
        if (this.itens.size() > index) {
            this.itens.remove(index);
            this.fireContentsChanged(this, 0, index);
        }
    }

    public int localizar(String titulo) {
        int i = -1;
        for (FiltroExportaFilial f : this.itens) {
            ++i;
            if (!f.getTituloFiltro().equalsIgnoreCase(titulo)) continue;
            return i;
        }
        return i;
    }
}

