/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.exportacao.filial.remover;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.exportacao.filial.DialogoFiltroFilial;
import jalis.laboratorio.exportacao.filial.remover.Agregada;
import jalis.laboratorio.exportacao.filial.remover.Dependencia;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class FiltroExportaFilial
extends JPanel {
    private static final int QTDE_REGISTRO_COMMIT = 100;
    private static final int OFFSET = 5000;
    private DialogoFiltroFilial dialogo;
    private JCheckBox check = new JCheckBox();
    private JButton button = new JButton();
    private JPanel panelEsquerdo = new JPanel(new FlowLayout(0, 3, 3));
    private JPanel panelDireito = new JPanel(new FlowLayout(2));
    private String textoFiltro = "Filtro";
    private String tabela_principal;
    private ArrayList<String> primary_keys = new ArrayList();
    private ArrayList<String> tabelas_join = new ArrayList();
    private ArrayList<String> campos_select = new ArrayList();
    private ArrayList<String> campos_exibir = new ArrayList();
    private ArrayList<String> valores_where = new ArrayList();
    private ArrayList<Dependencia> lista_dependencias = new ArrayList();
    private ArrayList<Agregada> lista_agregadas = new ArrayList();
    private Hashtable<String, ArrayList<String>> join_on = new Hashtable();
    private String[] nomesCols;
    private int[] sizesCols;
    private int colOrdenacao;
    private int colunaHint = 1;
    private ArrayList<Object[]> selecionados = new ArrayList();

    public FiltroExportaFilial(String titulo, String tabelaPrincipal, String[] chavesPrimarias, String[] camposSelect, String[] camposExibir, String[] nomesColunas, int[] tamanhoColunas, int colunaToolTip, int colunaOrdenacao) {
        String[] nomes = new String[nomesColunas.length + 1];
        int i = 0;
        String[] stringArray = nomesColunas;
        int n = stringArray.length;
        for (int j = 0; j < n; ++j) {
            String nome;
            nomes[i] = nome = stringArray[j];
            ++i;
        }
        nomes[i] = "";
        this.nomesCols = nomes;
        this.sizesCols = tamanhoColunas;
        this.colOrdenacao = colunaOrdenacao;
        this.jbInit(titulo, tabelaPrincipal, chavesPrimarias, camposSelect, camposExibir, nomes, tamanhoColunas, colunaToolTip, colunaOrdenacao);
    }

    private void jbInit(String titulo, String tabelaPrincipal, String[] chavesPrimarias, String[] camposSelect, String[] camposExibir, final String[] nomesColunas, final int[] tamanhoColunas, int colunaToolTip, final int colunaOrdenacao) {
        this.colunaHint = colunaToolTip;
        this.tabela_principal = tabelaPrincipal;
        for (String campo : camposSelect) {
            this.campos_select.add(this.tabela_principal + "." + campo);
        }
        for (String campo : camposExibir) {
            this.campos_exibir.add(this.tabela_principal + "." + campo);
        }
        for (String pk : chavesPrimarias) {
            this.primary_keys.add(this.tabela_principal + "." + pk);
        }
        this.setLayout(new BorderLayout());
        this.textoFiltro = "Filtro: " + titulo;
        this.check.setText(titulo);
        this.button.setText("Filtrar");
        this.add((Component)this.panelEsquerdo, "West");
        this.add((Component)this.panelDireito, "East");
        this.panelEsquerdo.add(this.check);
        this.panelDireito.add(this.button);
        this.setPreferredSize(new Dimension(90, 30));
        this.setMinimumSize(new Dimension(90, 30));
        this.check.setSelected(false);
        this.habilitaBotao();
        this.check.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FiltroExportaFilial.this.habilitaBotao();
            }
        });
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (FiltroExportaFilial.this.dialogo == null) {
                        FiltroExportaFilial.this.dialogo = DialogoFiltroFilial.novaInstancia(Laboratorio.getInstancia(), FiltroExportaFilial.this.textoFiltro, nomesColunas, tamanhoColunas);
                    }
                    ArrayList matriz = FiltroExportaFilial.this.getDadosExibir();
                    FiltroExportaFilial.this.dialogo.setDados(matriz, colunaOrdenacao);
                    if (!FiltroExportaFilial.this.selecionados.isEmpty()) {
                        FiltroExportaFilial.this.dialogo.setSelecionados(FiltroExportaFilial.this.selecionados);
                    }
                    FiltroExportaFilial.this.dialogo.setModal(true);
                    FiltroExportaFilial.this.dialogo.setVisible(true);
                    if (FiltroExportaFilial.this.dialogo.ok()) {
                        FiltroExportaFilial.this.selecionados = FiltroExportaFilial.this.dialogo.getSelecionados();
                        FiltroExportaFilial.this.setToolTipSelecionados();
                    }
                }
                catch (SQLException ex) {
                    ErrorLogger.mostraMensagem(FiltroExportaFilial.this.getTopLevelAncestor(), ex.getMessage(), ex.getStackTrace());
                }
            }
        });
    }

    public String getTituloFiltro() {
        return this.textoFiltro;
    }

    public String getTabelaFiltro() {
        return this.tabela_principal;
    }

    public void setTamanhoColunas(int[] tamanhos) {
        this.dialogo.setColumnSizes(tamanhos);
    }

    public int getContagemSelecionados() {
        if (this.dialogo == null) {
            return 0;
        }
        ArrayList<Object[]> matriz = this.dialogo.getSelecionados();
        if (matriz == null) {
            return 0;
        }
        return matriz.size();
    }

    private int getQuantidadeRegistros() {
        if (this.dialogo == null) {
            return 0;
        }
        return this.dialogo.getQtdeRegistros();
    }

    public void adicionarJoinTabelaPrincipal(String tabela_join, String[] campos_on, String[] campos_select, String[] campos_exibir) {
        String tabelacampo;
        ArrayList<String> campos_join;
        if (tabela_join == null || campos_on == null || campos_on.length == 0) {
            return;
        }
        if (!this.tabelas_join.contains(tabela_join)) {
            this.tabelas_join.add(tabela_join);
        }
        if ((campos_join = this.join_on.get(tabela_join)) == null) {
            campos_join = new ArrayList();
        }
        for (String campo : campos_on) {
            String on = this.tabela_principal + "." + campo + " = " + tabela_join + "." + campo;
            if (campos_join.contains(on)) continue;
            campos_join.add(on);
        }
        this.join_on.put(tabela_join, campos_join);
        if (campos_select != null && campos_select.length > 0) {
            for (String campo : campos_select) {
                tabelacampo = tabela_join + "." + campo;
                if (this.campos_select.contains(tabelacampo)) continue;
                this.campos_select.add(tabelacampo);
            }
        }
        if (campos_exibir != null && campos_exibir.length > 0) {
            for (String campo : campos_exibir) {
                tabelacampo = tabela_join + "." + campo;
                if (this.campos_exibir.contains(tabelacampo)) continue;
                this.campos_exibir.add(tabelacampo);
            }
        }
    }

    public void adicionarJoinTabelaSecundaria(String tabela_join, String tabela_secundaria, String[] campos_on, String[] campos_select, String[] campos_exibir) {
        ArrayList<String> campos_join;
        if (tabela_join == null || tabela_secundaria == null || campos_on == null || campos_on.length == 0) {
            return;
        }
        if (!this.tabelas_join.contains(tabela_join)) {
            this.tabelas_join.add(tabela_join);
        }
        if ((campos_join = this.join_on.get(tabela_join)) == null) {
            campos_join = new ArrayList();
        }
        for (String campo : campos_on) {
            String on = tabela_secundaria + "." + campo + " = " + tabela_join + campo;
            if (campos_join.contains(on)) continue;
            campos_join.add(on);
        }
        this.join_on.put(tabela_join, campos_join);
        if (campos_select != null && campos_select.length > 0) {
            for (String campo : campos_select) {
                if (this.campos_select.contains(tabela_join.concat(campo))) continue;
                this.campos_select.add(tabela_join.concat(campo));
            }
        }
        if (campos_exibir != null && campos_exibir.length > 0) {
            for (String campo : campos_exibir) {
                if (this.campos_exibir.contains(tabela_join.concat(campo))) continue;
                this.campos_exibir.add(tabela_join.concat(campo));
            }
        }
    }

    public void adicionarCondicaoWhere(String tabela, String campo, String valor) {
        if (tabela != null && campo != null && valor != null) {
            this.valores_where.add(tabela + "." + campo + " = " + valor);
        }
    }

    public void adicionarDependencia(Dependencia d) {
        if (!this.lista_dependencias.contains(d)) {
            this.lista_dependencias.add(d);
        }
    }

    public void adicionarDependencia(String tabela, String[] campos_chave_origem, String[] campos_chave_destino) {
        Dependencia d = new Dependencia(tabela, campos_chave_origem, campos_chave_destino);
        if (!this.lista_dependencias.contains(d)) {
            this.lista_dependencias.add(d);
        }
    }

    public void adicionarAgregada(Agregada a) {
        if (!this.lista_agregadas.contains(a)) {
            this.lista_agregadas.add(a);
        }
    }

    public void adicionarAgregada(String tabela, String[] campos_chave) {
        Agregada a = new Agregada(tabela, campos_chave);
        if (!this.lista_agregadas.contains(a)) {
            this.lista_agregadas.add(a);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<Object[]> getDadosExibir() throws SQLException {
        int i;
        Statement s = Conexao.getStatement();
        StringBuilder query = new StringBuilder("select ");
        for (int i2 = 0; i2 < this.campos_select.size(); ++i2) {
            query.append(this.campos_select.get(i2));
            if (i2 >= this.campos_select.size() - 1) continue;
            query.append(", ");
        }
        query.append(" from ");
        query.append(this.tabela_principal);
        for (String tabela_join : this.tabelas_join) {
            query.append(" join ");
            query.append(tabela_join);
            query.append(" on ");
            query.append(this.tabela_principal);
            query.append(".fil_codigo = ");
            query.append(tabela_join);
            query.append(".fil_codigo");
            ArrayList<String> campos_join = this.join_on.get(tabela_join);
            for (i = 0; i < campos_join.size(); ++i) {
                query.append(" and ");
                query.append(campos_join.get(i));
            }
        }
        query.append(" where ");
        query.append(this.tabela_principal);
        query.append(".fil_codigo = ");
        query.append(Variaveis.filialPadrao);
        for (int i3 = 0; i3 < this.valores_where.size(); ++i3) {
            query.append(" and ");
            query.append(this.valores_where.get(i3));
        }
        ArrayList<Object[]> matriz = new ArrayList<Object[]>();
        try (ResultSet rs = null;){
            rs = s.executeQuery(query.toString());
            while (rs != null && rs.next()) {
                Object[] linha = new Object[this.campos_exibir.size()];
                for (i = 0; i < this.campos_exibir.size(); ++i) {
                    linha[i] = rs.getObject(this.campos_exibir.get(i).substring(this.campos_exibir.get(i).indexOf(".") + 1));
                }
                matriz.add(linha);
            }
        }
        return matriz;
    }

    private int[] getIndicesColunasChaves() throws Exception {
        int[] indices = new int[this.primary_keys.size()];
        for (int i = 0; i < this.primary_keys.size(); ++i) {
            indices[i] = this.campos_exibir.indexOf(this.primary_keys.get(i));
            if (indices[i] != -1) continue;
            throw new Exception("Nome de coluna-chave incorreto: " + this.primary_keys.get(i));
        }
        return indices;
    }

    private Hashtable<String, String> getChavesValoresParaSelect() throws Exception {
        Hashtable<String, String> chaves_valores = new Hashtable<String, String>();
        ArrayList<Object[]> selecionados = this.dialogo.getSelecionados();
        if (selecionados.size() <= 0) {
            return null;
        }
        int[] key_indices = this.getIndicesColunasChaves();
        for (int i = 0; i < this.primary_keys.size(); ++i) {
            int col = key_indices[i];
            StringBuilder valores = new StringBuilder("(");
            for (int row = 0; row < selecionados.size(); ++row) {
                Object[] linha = selecionados.get(row);
                valores.append(this.bdValue(linha[col]));
                if (row >= selecionados.size() - 1) continue;
                valores.append(", ");
            }
            valores.append(")");
            chaves_valores.put(this.primary_keys.get(i), valores.toString());
        }
        return chaves_valores;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Object[]> getDadosExportar(boolean export_all, int iteracao) throws Exception {
        ArrayList<Object[]> matriz = new ArrayList<Object[]>();
        Hashtable<String, String> chaves_valores = this.getChavesValoresParaSelect();
        if (chaves_valores == null || chaves_valores.size() == 0) {
            return matriz;
        }
        Statement s = Conexao.getStatement();
        StringBuilder query = new StringBuilder();
        query.append(" select * ");
        query.append("   from ").append(this.tabela_principal);
        query.append("  where fil_codigo = ").append(Variaveis.filialPadrao);
        if (!export_all) {
            Enumeration<String> chaves = chaves_valores.keys();
            while (chaves.hasMoreElements()) {
                String chave = chaves.nextElement();
                query.append(" and ").append(chave).append(" in ").append(chaves_valores.get(chave));
            }
        }
        query.append("  limit ").append(5000);
        query.append(" offset ").append(5000 * iteracao);
        try (ResultSet rs = null;){
            rs = s.executeQuery(query.toString());
            while (rs != null && rs.next()) {
                rs.beforeFirst();
                if (rs == null) continue;
                ResultSetMetaData md = rs.getMetaData();
                String[] nomes = new String[md.getColumnCount() - 1];
                boolean found_filial = false;
                for (int i = 0; i < md.getColumnCount(); ++i) {
                    if (!md.getColumnName(i + 1).equals("fil_codigo")) {
                        nomes[!found_filial ? i : i - 1] = md.getColumnName(i + 1);
                        continue;
                    }
                    found_filial = true;
                }
                matriz.add(nomes);
                boolean conta = false;
                while (rs.next()) {
                    Object[] linha = new Object[md.getColumnCount() - 1];
                    found_filial = false;
                    for (int i = 0; i < md.getColumnCount(); ++i) {
                        if (!md.getColumnName(i + 1).equals("fil_codigo")) {
                            linha[!found_filial ? i : i - 1] = this.bdValue(rs.getObject(i + 1));
                            continue;
                        }
                        found_filial = true;
                    }
                    matriz.add(linha);
                }
            }
        }
        return matriz;
    }

    public Set<String> executaInserts(ArrayList<Object[]> dados_exportar, int qtdeTotal, String filial_destino, Statement st, JProgressBar progressoAtual) throws SQLException {
        StringBuilder query;
        String chave;
        Hashtable<String, String> campos_valores;
        progressoAtual.setMaximum(100);
        HashSet<String> tabelas = new HashSet<String>();
        if (dados_exportar == null || dados_exportar.size() <= 1) {
            return tabelas;
        }
        ArrayList<Object[]> nomes_colunas_atu = new ArrayList<Object[]>();
        Object[] nomes_colunas = dados_exportar.remove(0);
        ArrayList<Object[]> listaUpdate = new ArrayList<Object[]>();
        int contador = 0;
        System.gc();
        ArrayList<Object> lista = (ArrayList<Object[]>)dados_exportar.clone();
        boolean x = false;
        for (Object[] objectArray : lista) {
            campos_valores = new Hashtable<String, String>();
            for (int i = 0; i < nomes_colunas.length; ++i) {
                campos_valores.put(nomes_colunas[i].toString(), objectArray[i].toString());
            }
            for (Dependencia d : this.lista_dependencias) {
                ArrayList<String> tabelas_novas = this.executaInsertsResolucaoDependencia(d, filial_destino, campos_valores, st);
                tabelas.addAll(tabelas_novas);
            }
            if (this.tabela_principal.equals("labexterno")) {
                this.exportaSequenceLabExterno(filial_destino, campos_valores);
            }
            Hashtable<String, String> pk_valor = new Hashtable<String, String>();
            for (int i = 0; i < nomes_colunas.length; ++i) {
                chave = this.tabela_principal + "." + nomes_colunas[i];
                if (!this.primary_keys.contains(chave)) continue;
                pk_valor.put(nomes_colunas[i].toString(), objectArray[i].toString());
            }
            if (this.existeRegistro(pk_valor, filial_destino)) {
                dados_exportar.remove(objectArray);
                nomes_colunas_atu.add(objectArray);
                listaUpdate.add(objectArray);
            }
            if (++contador != 100) continue;
            st.getConnection().commit();
            System.gc();
            contador = 0;
        }
        st.getConnection().commit();
        contador = 0;
        System.gc();
        lista = (ArrayList)dados_exportar.clone();
        x = false;
        for (Object[] objectArray : lista) {
            int i;
            query = new StringBuilder("insert into ");
            query.append(this.tabela_principal);
            query.append(" (");
            for (i = 0; i < nomes_colunas.length; ++i) {
                Object col = nomes_colunas[i];
                query.append(col.toString());
                query.append(", ");
            }
            query.append("fil_codigo) values (");
            for (i = 0; i < nomes_colunas.length; ++i) {
                query.append(this.validaContraBarra(objectArray[i].toString()));
                query.append(", ");
            }
            query.append(filial_destino);
            query.append(");");
            st.executeUpdate(query.toString());
            if (++contador != 100) continue;
            st.getConnection().commit();
            System.gc();
            contador = 0;
        }
        st.getConnection().commit();
        contador = 0;
        System.gc();
        lista = listaUpdate;
        x = false;
        for (Object[] objectArray : lista) {
            query = new StringBuilder();
            query.append(" update ").append(this.tabela_principal);
            query.append(" set ");
            for (int i = 0; i < nomes_colunas.length; ++i) {
                if (i > 0) {
                    query.append(", ");
                }
                Object col = nomes_colunas[i];
                query.append(col.toString());
                query.append(" = ");
                query.append(this.validaContraBarra(objectArray[i].toString()));
            }
            Hashtable<String, String> pk_valor = new Hashtable<String, String>();
            for (int i = 0; i < nomes_colunas.length; ++i) {
                chave = this.tabela_principal + "." + nomes_colunas[i];
                if (!this.primary_keys.contains(chave)) continue;
                pk_valor.put(nomes_colunas[i].toString(), objectArray[i].toString());
            }
            query.append(" where fil_codigo = ").append(filial_destino);
            Enumeration chaves = pk_valor.keys();
            while (chaves.hasMoreElements()) {
                query.append(" and ");
                chave = (String)chaves.nextElement();
                String valor = (String)pk_valor.get(chave);
                query.append(chave);
                query.append(" = ");
                query.append(valor);
            }
            query.append(";");
            st.executeUpdate(query.toString());
            if (++contador != 100) continue;
            st.getConnection().commit();
            System.gc();
            contador = 0;
        }
        st.getConnection().commit();
        dados_exportar.addAll(nomes_colunas_atu);
        contador = 0;
        System.gc();
        lista = dados_exportar;
        x = false;
        for (Object[] objectArray : lista) {
            campos_valores = new Hashtable();
            for (int i = 0; i < nomes_colunas.length; ++i) {
                campos_valores.put(nomes_colunas[i].toString(), objectArray[i].toString());
            }
            String[] chaves_tab_principal = this.primary_keys.toArray(new String[this.primary_keys.size()]);
            for (int i = 0; i < chaves_tab_principal.length; ++i) {
                chaves_tab_principal[i] = chaves_tab_principal[i].substring(chaves_tab_principal[i].indexOf(".") + 1);
            }
            String[] valores_chaves = new String[chaves_tab_principal.length];
            for (int i = 0; i < chaves_tab_principal.length; ++i) {
                valores_chaves[i] = campos_valores.get(chaves_tab_principal[i]);
            }
            for (Agregada a : this.lista_agregadas) {
                ArrayList<Hashtable<String, String>> registros = a.getRegistrosFilialOrigem(chaves_tab_principal, valores_chaves, st);
                String[] chaves = a.getCamposChave();
                for (Hashtable<String, String> reg : registros) {
                    ArrayList<Dependencia> deps = a.getListaDependencias();
                    for (Dependencia d : deps) {
                        ArrayList<String> tabelas_novas = this.executaInsertsResolucaoDependencia(d, filial_destino, reg, st);
                        tabelas.addAll(tabelas_novas);
                    }
                    String[] valores = new String[chaves.length];
                    Hashtable<String, String> ch_valores = new Hashtable<String, String>();
                    for (int j = 0; j < chaves.length; ++j) {
                        valores[j] = reg.get(chaves[j]);
                        ch_valores.put(chaves[j].substring(chaves[j].indexOf(".") + 1), valores[j]);
                    }
                    if (!a.existeRegistroAgregada(valores, filial_destino)) {
                        String tabela = a.executaInsert(reg, filial_destino, st);
                        tabelas.add(tabela);
                        continue;
                    }
                    a.executaUpdate(reg, filial_destino, valores, st);
                }
            }
            if (++contador != 100) continue;
            st.getConnection().commit();
            System.gc();
            st.clearBatch();
            contador = 0;
        }
        lista.clear();
        tabelas.add(this.tabela_principal);
        return tabelas;
    }

    private void exportaSequenceLabExterno(String filial_destino, Hashtable<String, String> campos_valores) {
        Statement st = Conexao.getStatement();
        StringBuilder sb = new StringBuilder();
        String labExterno = campos_valores.get("lae_codigo");
        sb.append("select c.relname from pg_class c ");
        sb.append("where c.relname = 'codigolote_").append(filial_destino).append("_").append(labExterno).append("_sequence'");
        try {
            ResultSet rs = Conexao.executeQuery(st, sb.toString());
            if (!rs.next()) {
                Conexao.execute(Variaveis.filialPadrao, st, "create sequence codigolote_" + filial_destino + "_" + labExterno + "_sequence");
            }
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel criar o sequence " + e.getMessage(), e.getStackTrace());
        }
    }

    private void atualizaProgressoAtual(JProgressBar progresso, int x, int ult, int min, int max) {
        double xAux = x;
        double ultAux = ult;
        double minAux = min;
        double maxAux = max;
        Double y = new Double(xAux * (maxAux - minAux) / ultAux + minAux);
        progresso.setValue(y.intValue());
        progresso.revalidate();
        progresso.repaint();
    }

    private String validaContraBarra(String valor) {
        StringBuilder bui = new StringBuilder();
        for (int i = 0; i < valor.length(); ++i) {
            char c = valor.charAt(i);
            if (c == '\\') {
                bui.append("\\");
            }
            bui.append(c);
        }
        return bui.toString();
    }

    private ArrayList<String> executaInsertsResolucaoDependencia(Dependencia d, String filial_destino, Hashtable<String, String> campos_valores, Statement st) throws SQLException {
        ArrayList<String> tabelas = new ArrayList<String>();
        String[] chaves_origem = d.getCamposChaveOrigem();
        String[] chaves_destino = d.getCamposChaveDestino();
        String[] valores = new String[chaves_origem.length];
        for (int i = 0; i < chaves_origem.length; ++i) {
            valores[i] = campos_valores.get(chaves_origem[i]);
        }
        Hashtable<String, String> registro = d.getRegistroFilialOrigem(chaves_destino, valores, st);
        if (registro != null && !registro.isEmpty()) {
            ArrayList<String> colunas = new ArrayList<String>();
            ArrayList<String> dados = new ArrayList<String>();
            Enumeration<String> cols = registro.keys();
            while (cols.hasMoreElements()) {
                colunas.add(cols.nextElement());
            }
            for (String nome : colunas) {
                dados.add(registro.get(nome));
            }
            block3: for (int j = 0; j < colunas.size(); ++j) {
                for (int k = 0; k < chaves_origem.length; ++k) {
                    if (!((String)colunas.get(j)).equals(chaves_origem[k])) continue;
                    colunas.set(j, chaves_destino[k]);
                    continue block3;
                }
            }
            if (!d.existeRegistroDependencia(valores, filial_destino, st)) {
                ArrayList<String> tabelas_novas = d.executaInsertsRegistroDependencia(colunas.toArray(new String[colunas.size()]), dados.toArray(new String[dados.size()]), filial_destino, st);
                tabelas.addAll(tabelas_novas);
            }
        }
        return tabelas;
    }

    private String bdValue(Object o) {
        if (o == null) {
            return "null";
        }
        if (o instanceof Number || o instanceof Boolean || o.toString().equals("null")) {
            return o.toString();
        }
        return StringUtil.textoDBEscape(o.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean existeRegistro(Hashtable<String, String> chave_valor, String filial_destino) throws SQLException {
        Statement s = Conexao.getStatement();
        Enumeration<String> chaves = chave_valor.keys();
        StringBuilder query = new StringBuilder();
        query.append(" select count(1) as qtd ");
        query.append("   from ").append(this.tabela_principal);
        query.append("  where fil_codigo = ").append(filial_destino);
        while (chaves.hasMoreElements()) {
            query.append(" and ");
            String chave = chaves.nextElement();
            String valor = chave_valor.get(chave);
            query.append(chave);
            query.append(" = ");
            query.append(valor);
        }
        query.append(" limit 1");
        try (ResultSet rs = null;){
            rs = s.executeQuery(query.toString());
            if (rs != null && rs.next() && rs.getInt("qtd") > 0) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    private void habilitaBotao() {
        this.button.setEnabled(this.check.isSelected());
        this.setToolTipText("");
    }

    public boolean isSelected() {
        return this.check.isSelected();
    }

    public void setSelected(boolean selected) {
        this.check.setSelected(selected);
        this.setEnabled(selected);
    }

    public void setColunaHint(int coluna) {
        this.colunaHint = coluna;
    }

    public void clear() {
        this.check.setSelected(false);
        this.setToolTipText("");
        if (!this.selecionados.isEmpty()) {
            this.selecionados.clear();
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.check.setEnabled(enabled);
        this.button.setEnabled(enabled ? this.check.isSelected() : enabled);
    }

    public int getQtdeRegistros() {
        if (this.dialogo != null) {
            return this.dialogo.getQtdeRegistros();
        }
        return 0;
    }

    public void selectAll(boolean selected) {
        try {
            if (this.dialogo == null) {
                this.dialogo = DialogoFiltroFilial.novaInstancia(Laboratorio.getInstancia(), this.textoFiltro, this.nomesCols, this.sizesCols);
                ArrayList<Object[]> matriz = this.getDadosExibir();
                this.dialogo.setDados(matriz, this.colOrdenacao);
            }
            this.selecionados = this.dialogo.selectAll(selected);
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this.getTopLevelAncestor(), ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
        }
    }

    private void setToolTipSelecionados() {
        StringBuilder tooltip = new StringBuilder();
        int col = this.colunaHint < this.campos_exibir.size() ? this.colunaHint : 0;
        tooltip.append("<html><b>Filtro selecionado: </b><br>");
        int i = -1;
        for (Object[] linha : this.selecionados) {
            tooltip.append("<li>");
            tooltip.append(linha[col]);
            if (++i < this.selecionados.size()) {
                tooltip.append("<br>");
            }
            if (i <= 10) continue;
            tooltip.append("<li>...");
            break;
        }
        tooltip.append("</html>");
        this.setToolTipText(tooltip.toString());
    }

    @Override
    public String toString() {
        return this.check.getText() + (this.isSelected() ? " (" + this.getQtdeRegistros() + "/" + this.getContagemSelecionados() + ")" : "");
    }

    public JButton getBotaoFiltrar() {
        return this.button;
    }
}

