/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.exportacao.filial.remover;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.util.ArraysUtil;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class Dependencia {
    String tabela;
    String[] chaves_origem;
    String[] chaves_destino;
    String filial;
    ArrayList<Dependencia> subdependencias = new ArrayList();
    private static final String CODIGO_DO_LABORATORIO_EXTERNO = "lae_codigo";

    public Dependencia(String tabela, String[] chaves_origem, String[] chaves_destino) {
        this.tabela = tabela;
        this.chaves_origem = chaves_origem;
        this.chaves_destino = chaves_destino;
    }

    public void adicionarSubDependencia(String tabela, String[] chaves_origem, String[] chaves_destino) {
        Dependencia nova = new Dependencia(tabela, chaves_origem, chaves_destino);
        if (!this.subdependencias.contains(nova)) {
            this.subdependencias.add(nova);
        }
    }

    public void adicionarSubDependencia(Dependencia sub) {
        if (!this.subdependencias.contains(sub)) {
            this.subdependencias.add(sub);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean existeRegistroDependencia(String[] valores_chaves, String filial_destino, Statement st) throws SQLException {
        if (valores_chaves.length != this.chaves_destino.length) {
            return false;
        }
        StringBuilder query = new StringBuilder("select count(1) as  qtd from ");
        query.append(this.tabela);
        query.append(" where fil_codigo = ");
        query.append(filial_destino);
        for (int i = 0; i < this.chaves_destino.length; ++i) {
            query.append(" and ");
            String chave = this.chaves_destino[i];
            String valor = valores_chaves[i];
            query.append(chave);
            query.append(" = ");
            query.append(valor);
        }
        query.append(" limit 1");
        try (ResultSet rs = null;){
            rs = st.executeQuery(query.toString());
            if (rs != null && rs.next() && rs.getInt("qtd") > 0) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable<String, String> getRegistroFilialOrigem(String[] chaves, String[] valores, Statement s) throws SQLException {
        if (chaves.length != valores.length) {
            return null;
        }
        Hashtable<String, String> registro = new Hashtable<String, String>();
        StringBuilder query = new StringBuilder();
        query.append(" select count(1) as quantidadeRegistro from ").append(this.tabela);
        query.append(" where fil_codigo = ");
        query.append(Variaveis.filialPadrao);
        for (int i = 0; i < chaves.length; ++i) {
            query.append(" and ");
            query.append(chaves[i]);
            query.append(" = ");
            query.append(valores[i]);
        }
        query.append(" limit 1 ;");
        Long quantidadeRegistro = 0L;
        try (ResultSet rsQuantidadeRegistro = null;){
            rsQuantidadeRegistro = s.executeQuery(query.toString());
            if (rsQuantidadeRegistro.next()) {
                quantidadeRegistro = rsQuantidadeRegistro.getLong("quantidadeRegistro");
                int qtdOffSetPercorrer = (int)(quantidadeRegistro / 20L) + 1;
                int qtdOffSet = 0;
                s.clearBatch();
                for (int offset = 0; offset < qtdOffSetPercorrer; ++offset) {
                    query.setLength(0);
                    query.append("select * from ");
                    query.append(this.tabela);
                    query.append(" where fil_codigo = ");
                    query.append(Variaveis.filialPadrao);
                    for (int i = 0; i < chaves.length; ++i) {
                        query.append(" and ");
                        query.append(chaves[i]);
                        query.append(" = ");
                        query.append(valores[i]);
                    }
                    query.append(" limit 20 offset " + qtdOffSet);
                    try (ResultSet rs = null;){
                        rs = s.executeQuery(query.toString());
                        ResultSetMetaData md = rs.getMetaData();
                        if (rs != null && rs.next()) {
                            for (int i = 1; i <= md.getColumnCount(); ++i) {
                                String col = md.getColumnName(i);
                                String val = this.bdValue(rs.getObject(col));
                                registro.put(col, val);
                            }
                        }
                        qtdOffSet += 20;
                        continue;
                    }
                }
                Hashtable<String, String> hashtable = registro;
                return hashtable;
            }
        }
        return null;
    }

    public ArrayList<String> executaInsertsRegistroDependencia(String[] nomes_campos_destino, String[] valores, String filial_destino, Statement st) throws SQLException {
        ArrayList<String> tabelas = new ArrayList<String>();
        if (nomes_campos_destino.length != valores.length || nomes_campos_destino.length == 0 || valores.length == 0) {
            return tabelas;
        }
        for (Dependencia d : this.subdependencias) {
            Hashtable<String, String> pk_valor = new Hashtable<String, String>();
            String[] chaves = d.getCamposChaveOrigem();
            String[] values = new String[chaves.length];
            block1: for (int i = 0; i < chaves.length; ++i) {
                for (int j = 0; j < nomes_campos_destino.length; ++j) {
                    if (!chaves[i].equals(nomes_campos_destino[j])) continue;
                    values[i] = valores[j];
                    pk_valor.put(chaves[i], values[i]);
                    continue block1;
                }
            }
            if (d.existeRegistroDependencia(values, filial_destino, st)) continue;
            ArrayList<String> tabelas_novas = this.resolveDependencia(d, pk_valor, filial_destino, st);
            tabelas.addAll(tabelas_novas);
        }
        StringBuilder campos = new StringBuilder(" (");
        StringBuilder values = new StringBuilder(" (");
        for (int i = 0; i < nomes_campos_destino.length; ++i) {
            campos.append(nomes_campos_destino[i]);
            values.append(nomes_campos_destino[i].equals("fil_codigo") ? filial_destino : valores[i]);
            if (i >= nomes_campos_destino.length - 1) continue;
            campos.append(", ");
            values.append(", ");
        }
        campos.append(")");
        values.append(")");
        StringBuilder query = new StringBuilder("insert into ");
        query.append(this.tabela);
        query.append((CharSequence)campos);
        query.append(" values");
        query.append((CharSequence)values);
        query.append(";");
        st.executeUpdate(query.toString());
        tabelas.add(this.tabela);
        this.criarSequenceLabExterno(valores, filial_destino, nomes_campos_destino);
        System.gc();
        return tabelas;
    }

    private void criarSequenceLabExterno(String[] valores, String filial_destino, String[] nomes_campos_destino) {
        if (this.tabela.equals("labexterno")) {
            Statement st = Conexao.getStatement();
            StringBuilder sb = new StringBuilder();
            String labExterno = "";
            for (int i = 0; i < nomes_campos_destino.length; ++i) {
                if (!nomes_campos_destino[i].equals(CODIGO_DO_LABORATORIO_EXTERNO)) continue;
                labExterno = valores[i];
            }
            sb.append("select c.relname from pg_class c ");
            sb.append("where c.relname = 'codigolote_").append(filial_destino).append("_").append(labExterno).append("_sequence'");
            try {
                ResultSet rs = Conexao.executeQuery(st, sb.toString());
                if (!rs.next()) {
                    Conexao.execute(Variaveis.filialPadrao, st, "create sequence codigolote_" + filial_destino + "_" + labExterno + "_sequence");
                }
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel criar o sequence " + e.getMessage(), e.getStackTrace());
            }
        }
    }

    public ArrayList<String> executaUpdatesRegistroDependencia(String[] valores_chaves, String[] nomes_campos_destino, String[] valores, String filial_destino, Statement st) throws SQLException {
        int i;
        ArrayList<String> tabelas = new ArrayList<String>();
        if (nomes_campos_destino.length != valores.length) {
            return tabelas;
        }
        for (Dependencia d : this.subdependencias) {
            Hashtable<String, String> pk_valor = new Hashtable<String, String>();
            String[] chaves = d.getCamposChaveOrigem();
            String[] values = new String[chaves.length];
            boolean chavePreenchida = false;
            block1: for (int i2 = 0; i2 < chaves.length; ++i2) {
                for (int j = 0; j < nomes_campos_destino.length; ++j) {
                    if (!chaves[i2].equals(nomes_campos_destino[j]) || valores[j] == null || valores[j].equalsIgnoreCase("null")) continue;
                    chavePreenchida = true;
                    values[i2] = valores[j];
                    pk_valor.put(chaves[i2], values[i2]);
                    continue block1;
                }
            }
            if (!chavePreenchida) continue;
            if (!d.existeRegistroDependencia(values, filial_destino, st)) {
                ArrayList<String> tabelas_novas = this.resolveDependencia(d, pk_valor, filial_destino, st);
                tabelas.addAll(tabelas_novas);
                continue;
            }
            d.executaUpdatesRegistroDependencia(valores_chaves, chaves, valores, filial_destino, st);
        }
        StringBuilder buf = new StringBuilder();
        buf.append(" update ").append(this.tabela);
        buf.append("    set ");
        int qtdeAtualizada = 0;
        for (i = 0; i < nomes_campos_destino.length - 1; ++i) {
            if (i >= nomes_campos_destino.length || nomes_campos_destino[i].equalsIgnoreCase("fil_codigo") || ArraysUtil.contem(this.chaves_destino, nomes_campos_destino[i])) continue;
            if (qtdeAtualizada > 0) {
                buf.append(", ");
            }
            buf.append(nomes_campos_destino[i]).append(" = ").append(valores[i]);
            ++qtdeAtualizada;
        }
        buf.append(" where fil_codigo = ").append(filial_destino);
        for (i = 0; i < valores_chaves.length; ++i) {
            buf.append(" and ").append(this.chaves_destino[i]).append(" = ").append(valores_chaves[i]);
        }
        if (qtdeAtualizada > 0) {
            buf.append(";");
            st.executeUpdate(buf.toString());
            st.getConnection().commit();
        }
        tabelas.add(this.tabela);
        return tabelas;
    }

    public String[] getCamposChaveOrigem() {
        return this.chaves_origem;
    }

    public String[] getCamposChaveDestino() {
        return this.chaves_destino;
    }

    private String bdValue(Object o) {
        if (o == null) {
            return "null";
        }
        if (o instanceof Number || o instanceof Boolean || o.toString().equals("null")) {
            return o.toString();
        }
        return StringUtil.textoDBEscape(o.toString());
    }

    private ArrayList<String> resolveDependencia(Dependencia subd, Hashtable<String, String> pk_valor, String filial_destino, Statement st) throws SQLException {
        ArrayList<String> tabelas = new ArrayList<String>();
        String[] chaves = subd.getCamposChaveOrigem();
        String[] valores = new String[chaves.length];
        for (int i = 0; i < chaves.length; ++i) {
            valores[i] = pk_valor.get(chaves[i]);
        }
        boolean jaExiste = subd.existeRegistroDependencia(valores, filial_destino, st);
        Hashtable<String, String> registro = subd.getRegistroFilialOrigem(subd.getCamposChaveDestino(), valores, st);
        ArrayList<String> colunas = new ArrayList<String>();
        ArrayList<String> dados = new ArrayList<String>();
        if (registro != null) {
            Enumeration<String> cols = registro.keys();
            while (cols.hasMoreElements()) {
                String coluna = cols.nextElement();
                colunas.add(coluna);
                dados.add(registro.get(coluna));
            }
            ArrayList<String> tabelas_subds = null;
            if (!jaExiste) {
                tabelas_subds = subd.executaInsertsRegistroDependencia(colunas.toArray(new String[colunas.size()]), dados.toArray(new String[dados.size()]), filial_destino, st);
            }
            tabelas.addAll(tabelas_subds);
        }
        System.gc();
        return tabelas;
    }
}

