/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.exportacao.filial.remover;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.laboratorio.exportacao.filial.remover.Dependencia;
import jalis.util.StringUtil;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class Agregada {
    private String tabela;
    private String[] chaves;
    private ArrayList<Dependencia> dependencias = new ArrayList();

    public Agregada(String tabela, String[] chaves) {
        this.tabela = tabela;
        this.chaves = chaves;
    }

    public void adicionarDependencia(String tabela, String[] chaves_origem, String[] chaves_destino) {
        Dependencia nova = new Dependencia(tabela, chaves_origem, chaves_destino);
        if (!this.dependencias.contains(nova)) {
            this.dependencias.add(nova);
        }
    }

    public void adicionarDependencia(Dependencia sub) {
        if (!this.dependencias.contains(sub)) {
            this.dependencias.add(sub);
        }
    }

    public ArrayList<Dependencia> getListaDependencias() {
        return this.dependencias;
    }

    public String[] getCamposChave() {
        return this.chaves;
    }

    public String getTabela() {
        return this.tabela;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Hashtable<String, String>> getRegistrosFilialOrigem(String[] chaves_tab_mae, String[] valores, Statement st) throws SQLException {
        ArrayList<Hashtable<String, String>> registros = new ArrayList<Hashtable<String, String>>();
        if (chaves_tab_mae.length != valores.length) {
            return null;
        }
        StringBuilder query = new StringBuilder("select count(1) as quantidadeRegistro from ");
        query.append(this.tabela);
        query.append(" where fil_codigo = ");
        query.append(Variaveis.filialPadrao);
        for (int i = 0; i < chaves_tab_mae.length; ++i) {
            query.append(" and ");
            query.append(chaves_tab_mae[i]);
            query.append(" = ");
            query.append(valores[i]);
        }
        query.append(" limit 1;");
        Long quantidadeRegistro = 0L;
        try (ResultSet rsQuantidadeRegistro = null;){
            rsQuantidadeRegistro = st.executeQuery(query.toString());
            if (rsQuantidadeRegistro.next()) {
                quantidadeRegistro = rsQuantidadeRegistro.getLong("quantidadeRegistro");
                int qtdOffSetPercorrer = (int)(quantidadeRegistro / 20L) + 1;
                int qtdOffSet = 0;
                for (int offset = 0; offset < qtdOffSetPercorrer; ++offset) {
                    query.setLength(0);
                    query.append("select * from ");
                    query.append(this.tabela);
                    query.append(" where fil_codigo = ");
                    query.append(Variaveis.filialPadrao);
                    for (int i = 0; i < chaves_tab_mae.length; ++i) {
                        query.append(" and ");
                        query.append(chaves_tab_mae[i]);
                        query.append(" = ");
                        query.append(valores[i]);
                    }
                    query.append(" limit 20 offset " + qtdOffSet);
                    ResultSet rs = Conexao.executeQuery(st, query.toString());
                    if (rs != null) {
                        ResultSetMetaData md = rs.getMetaData();
                        while (rs != null && rs.next()) {
                            Hashtable<String, String> registro = new Hashtable<String, String>();
                            for (int i = 1; i <= md.getColumnCount(); ++i) {
                                String col = md.getColumnName(i);
                                String val = this.bdValue(rs.getObject(col));
                                registro.put(col, val);
                            }
                            registros.add(registro);
                        }
                    }
                    qtdOffSet += 20;
                }
            }
        }
        return registros;
    }

    public boolean existeRegistroAgregada(String[] valores_chaves, String filial_destino) throws SQLException {
        if (valores_chaves.length != this.chaves.length) {
            return false;
        }
        Statement s = Conexao.getStatement();
        StringBuilder query = new StringBuilder("select  count(1) as qtd from ");
        query.append(this.tabela);
        query.append(" where fil_codigo = ");
        query.append(filial_destino);
        for (int i = 0; i < this.chaves.length; ++i) {
            query.append(" and ");
            String chave = this.chaves[i];
            String valor = valores_chaves[i];
            query.append(chave);
            query.append(" = ");
            query.append(valor);
        }
        query.append(" limit 1");
        ResultSet rs = Conexao.executeQuery(s, query.toString());
        return rs != null && rs.next() && rs.getInt("qtd") > 0;
    }

    public String executaInsert(Hashtable<String, String> registro, String filial_destino, Statement st) throws SQLException {
        Enumeration<String> colunas = registro.keys();
        StringBuilder query = new StringBuilder("insert into ");
        query.append(this.tabela);
        query.append(" (");
        while (colunas.hasMoreElements()) {
            query.append(colunas.nextElement());
            if (!colunas.hasMoreElements()) continue;
            query.append(", ");
        }
        query.append(") values (");
        colunas = registro.keys();
        while (colunas.hasMoreElements()) {
            String col = colunas.nextElement();
            query.append(col.equals("fil_codigo") ? filial_destino : registro.get(col));
            if (!colunas.hasMoreElements()) continue;
            query.append(", ");
        }
        query.append(");");
        Conexao.executeUpdate(filial_destino, st, query.toString(), true);
        st.getConnection().commit();
        return this.tabela;
    }

    public String executaUpdate(Hashtable<String, String> registro, String filial_destino, String[] valores_chaves, Statement st) throws SQLException {
        Enumeration<String> colunas = registro.keys();
        StringBuilder query = new StringBuilder();
        query.append(" update ").append(this.tabela);
        query.append(" set ");
        int pos = 0;
        while (colunas.hasMoreElements()) {
            String coluna = colunas.nextElement();
            if (coluna.equalsIgnoreCase("fil_codigo")) continue;
            if (pos++ > 0) {
                query.append(", ");
            }
            query.append(coluna);
            query.append(" = ");
            query.append(registro.get(coluna));
        }
        query.append(" where fil_codigo = ").append(filial_destino);
        for (int i = 0; i < this.chaves.length; ++i) {
            query.append(" and ");
            String chave = this.chaves[i];
            String valor = valores_chaves[i];
            query.append(chave);
            query.append(" = ");
            query.append(valor);
        }
        query.append(";");
        Conexao.executeUpdate(filial_destino, st, query.toString(), true);
        st.getConnection().commit();
        return this.tabela;
    }

    private String bdValue(Object o) {
        if (o == null) {
            return "null";
        }
        if (o instanceof Number || o instanceof Boolean || o.toString().equals("null")) {
            return o.toString();
        }
        return "'" + StringUtil.textoDB(o.toString()) + "'";
    }
}

