/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.exportacao.filial.exames;

import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmPadrao;
import jalis.laboratorio.exportacao.filial.exames.AvisaFinal;
import jalis.util.DBUtil;
import jalis.util.DialogUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.Tempo;
import jalis.util.componentes.BotaoNavegavel;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.TabelaModelada;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableCellRenderer;

public class ImportacaoExames
extends FrmPadrao
implements ActionListener {
    public static final String ADDRESS = "http://www.thread.com.br/exames/exames.xml";
    public static final String EXAMES = "http://www.thread.com.br/exames/";
    private JButton buttonNovo = new JButton("Novo");
    private JButton buttonFechar = new JButton("Fechar");
    private JPanel panelBotoes = new JPanel(new FlowLayout(2));
    private JProgressBar progresso = new JProgressBar();
    private JLabel labelTempo = new JLabel("00:00:00");
    private JPanel panelCentro = new JPanel(new GridBagLayout());
    private JTextArea texto = new JTextArea();
    private JScrollPane scroll = new JScrollPane(this.texto);

    public ImportacaoExames() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
        }
    }

    private void jbInit() throws Exception {
        this.buttonFechar.setMnemonic('F');
        this.buttonNovo.setMnemonic('N');
        this.setLayout(new BorderLayout());
        this.add((Component)this.panelBotoes, "South");
        this.add((Component)this.panelCentro, "Center");
        this.panelBotoes.add(this.buttonNovo);
        this.panelBotoes.add(this.buttonFechar);
        Funcoes.criaBarraDescricao(this, "Importar exames", "Importa um arquivo com informa\u00e7\u00f5es de cadastro de exame", "integracao/importar_exames_xml.jpg");
        this.montaCentro();
        this.buttonFechar.addActionListener(this);
        this.buttonNovo.addActionListener(this);
        this.buttonNovo.grabFocus();
        this.texto.setOpaque(false);
        this.texto.setEditable(false);
    }

    private void montaCentro() {
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridx = 0;
        cons.gridy = 0;
        cons.fill = 1;
        cons.anchor = 18;
        cons.weightx = 1.0;
        cons.weighty = 1.0;
        this.panelCentro.add((Component)this.scroll, cons);
        cons.gridy = 1;
        cons.fill = 2;
        cons.anchor = 13;
        cons.weighty = 0.0;
        this.labelTempo.setHorizontalAlignment(4);
        this.panelCentro.add((Component)this.labelTempo, cons);
        cons.gridy = 2;
        this.panelCentro.add((Component)this.progresso, cons);
    }

    public static Long getModuloAcesso() {
        return Long.parseLong("0902000400");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonFechar) {
            this.setVisible(false);
        } else if (e.getSource() == this.buttonNovo) {
            this.importaDados();
        }
    }

    private void importaDados() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            this.buttonFechar.setEnabled(false);
            ThreadImportar importar = new ThreadImportar(this.progresso, this.labelTempo, this.texto);
            importar.addAvisaFinal(new AvisaFinal(){

                @Override
                public void threadParada() {
                    ImportacaoExames.this.buttonFechar.setEnabled(true);
                }
            });
            importar.start();
            this.setCursor(Cursor.getDefaultCursor());
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    private class ThreadImportar
    extends Thread {
        private static final int ORIGEM_ARQUIVO = 0;
        private static final int ORIGEM_INTERNET = 0;
        private static final int UPDATE_ONE = 0;
        private static final int UPDATE_ALL = 1;
        private static final int IGNORE_ONE = 2;
        private static final int IGNORE_ALL = 3;
        private JProgressBar progresso;
        private Tempo timer;
        private JLabel labelTempo;
        private JTextArea texto;
        private String path;
        private ArrayList<AvisaFinal> listenerList;
        private boolean com_alerta;
        boolean fechou_ok;

        public ThreadImportar(JProgressBar barra, JLabel tempo, JTextArea texto) {
            super("Thread - Exportar exames");
            this.listenerList = new ArrayList();
            this.com_alerta = false;
            this.fechou_ok = false;
            this.progresso = barra;
            this.labelTempo = tempo;
            this.texto = texto;
        }

        public void limpaMensagem() {
            this.texto.setText("");
        }

        public void mostraMensagem(String str) {
            this.texto.append(str + "\n");
        }

        public void addAvisaFinal(AvisaFinal l) {
            this.listenerList.add(l);
        }

        public void removeAvisaFinal(AvisaFinal l) {
            this.listenerList.remove(l);
        }

        private void fireAvisaFinal() {
            for (AvisaFinal c : this.listenerList) {
                c.threadParada();
            }
        }

        @Override
        public void run() {
            try {
                this.limpaMensagem();
                ImportacaoExames.this.buttonNovo.setEnabled(false);
                this.progresso.setMaximum(6);
                this.progresso.setValue(0);
                this.com_alerta = false;
                int resposta = Funcoes.showPerguntaOpcoes(null, "Deseja importar de um arquivo ou Internet?", new String[]{"Arquivo", "Internet", "Cancelar"});
                if (resposta == 2) {
                    this.fireAvisaFinal();
                    return;
                }
                if (resposta == 0) {
                    this.lerArquivo();
                } else {
                    this.lerInternet();
                }
            }
            catch (Exception ex) {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            }
            ImportacaoExames.this.buttonNovo.setEnabled(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void lerArquivo() throws Exception {
            int opcao;
            JFileChooser file = ComponenteFactory.novoJFileChooser();
            file.setFileSelectionMode(0);
            file.setFileFilter(new FiltroXML());
            file.setApproveButtonText("Importar");
            file.setApproveButtonMnemonic('I');
            this.path = ParametrosLocais.getParametro("xmlExameImportacaoArquivo");
            if (this.path != null && !this.path.trim().equals("")) {
                file.setCurrentDirectory(new File(this.path));
            }
            if ((opcao = file.showOpenDialog(ImportacaoExames.this)) == 0) {
                this.timer = new Tempo(this.labelTempo);
                this.timer.start();
                File exame = new File(file.getSelectedFile().toString());
                String newpath = exame.getParent();
                if (this.path == null || !this.path.equals(newpath)) {
                    ParametrosLocais.setParametro("xmlExameImportacaoArquivo", newpath);
                }
                StringBuilder xml = new StringBuilder();
                try (FileReader leitor = null;){
                    leitor = new FileReader(exame);
                    while (leitor.ready()) {
                        xml.append((char)leitor.read());
                    }
                }
                this.progresso.setValue(this.progresso.getValue() + 1);
                if (this.parse(xml.toString())) {
                    this.timer.stop();
                    Conexao.arquivaSQL();
                    this.mostraMensagem(this.com_alerta ? "Importa\u00e7\u00e3o realizada, por\u00e9m alguns problemas foram encontrados" : "Arquivo importado com sucesso");
                    this.mostraMensagem("Fim da importa\u00e7\u00e3o");
                } else {
                    this.mostraMensagem("Importa\u00e7\u00e3o cancelada!");
                }
                this.timer.stop();
            }
            this.fireAvisaFinal();
        }

        public void lerInternet() throws Exception {
            TabelaModelada tabela = new TabelaModelada(new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o", ""});
            tabela.forceSize(0, 70);
            tabela.forceSize(2, 35);
            JScrollPane scroll = new JScrollPane(tabela);
            JPanel botoes = new JPanel(new FlowLayout(2));
            JDialog dlg = new JDialog();
            BotaoNavegavel ok = new BotaoNavegavel("OK", 'O');
            BotaoNavegavel cancel = new BotaoNavegavel("Cancelar", 'C');
            this.fechou_ok = false;
            ok.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((JButton)e.getSource()).getRootPane().getParent().setVisible(false);
                    ThreadImportar.this.fechou_ok = true;
                }
            });
            cancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ThreadImportar.this.fireAvisaFinal();
                    ((JButton)e.getSource()).getRootPane().getParent().setVisible(false);
                }
            });
            tabela.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    TabelaModelada tabela = (TabelaModelada)e.getSource();
                    Point p = e.getPoint();
                    int row = tabela.rowAtPoint(p);
                    int column = tabela.columnAtPoint(p);
                    if (column == 2) {
                        boolean valor_atual = (Boolean)tabela.getValueAt(row, column);
                        tabela.setValueAt(!valor_atual, row, column);
                    }
                }
            });
            try {
                HttpURLConnection lista;
                tabela.getColumnModel().getColumn(2).setCellRenderer(new CheckBoxRenderer());
                dlg.setLayout(new BorderLayout());
                dlg.add((Component)scroll, "Center");
                dlg.add((Component)botoes, "South");
                dlg.setSize(new Dimension(400, 300));
                dlg.setPreferredSize(new Dimension(400, 300));
                botoes.add(ok);
                botoes.add(cancel);
                URL url = new URL(ImportacaoExames.ADDRESS);
                try {
                    lista = (HttpURLConnection)url.openConnection();
                }
                catch (IOException ex) {
                    this.timer.stop();
                    this.fireAvisaFinal();
                    this.mostraMensagem("N\u00e3o foi poss\u00edvel conectar ao servidor de exames. Verifique sua conex\u00e3o com a Internet ou tente mais tarde.");
                    return;
                }
                BufferedInputStream in = new BufferedInputStream(lista.getInputStream());
                StringBuilder xml = new StringBuilder();
                while (in.available() > 0) {
                    xml.append((char)in.read());
                }
                if (xml.length() > 0) {
                    String conteudo = StringUtil.getValor(xml.toString(), "exames");
                    if (conteudo.length() > 0) {
                        String[] exames = StringUtil.getValores(conteudo, "exame");
                        if (exames.length > 0) {
                            for (String exame : exames) {
                                String codigo = StringUtil.getValor(exame, "codigo");
                                String descricao = StringUtil.getValor(exame, "descricao");
                                Boolean select = false;
                                String arquivo = StringUtil.getValor(exame, "arquivo");
                                tabela.addSortedRow(new Object[]{codigo, descricao, select, arquivo});
                            }
                            DialogUtil.centerAndShow(dlg, true, false);
                            if (!this.fechou_ok) {
                                this.fireAvisaFinal();
                                return;
                            }
                            ArrayList<String> arquivos = new ArrayList<String>();
                            for (int i = 0; i < tabela.getRowCount(); ++i) {
                                if (!((Boolean)tabela.getValueAt(i, 2)).booleanValue()) continue;
                                arquivos.add((String)tabela.getValueAt(i, 3));
                            }
                            if (arquivos.size() == 0) {
                                this.fireAvisaFinal();
                                return;
                            }
                            this.progresso.setValue(this.progresso.getValue() + 1);
                            this.progresso.setMaximum(this.progresso.getMaximum() + (arquivos.size() * 5 - 5));
                            this.timer = new Tempo(this.labelTempo);
                            this.timer.start();
                            for (String arquivo : arquivos) {
                                HttpURLConnection c;
                                url = new URL(ImportacaoExames.EXAMES.concat(arquivo));
                                try {
                                    c = (HttpURLConnection)url.openConnection();
                                }
                                catch (IOException ex) {
                                    this.mostraMensagem("Arquivo n\u00e3o encontrado (" + arquivo + ") - Importa\u00e7\u00e3o ignorada");
                                    continue;
                                }
                                in = new BufferedInputStream(c.getInputStream());
                                xml = new StringBuilder();
                                while (in.available() > 0) {
                                    xml.append((char)in.read());
                                }
                                if (xml.length() <= 0) {
                                    this.mostraMensagem("Arquivo n\u00e3o encontrado (" + arquivo + ") - Importa\u00e7\u00e3o ignorada");
                                    continue;
                                }
                                if (this.parse(xml.toString())) {
                                    this.mostraMensagem(this.com_alerta ? "Importa\u00e7\u00e3o realizada, por\u00e9m alguns problemas foram encontrados" : "Arquivo importado com sucesso");
                                    this.mostraMensagem("Arquivo (" + arquivo + ") importado...\n");
                                } else {
                                    this.progresso.setValue(this.progresso.getValue() + 5);
                                    this.mostraMensagem("Importa\u00e7\u00e3o cancelada (" + arquivo + ")!");
                                }
                                if (!arquivo.equals(arquivos.get(arquivos.size() - 1))) continue;
                                this.timer.stop();
                            }
                            Conexao.arquivaSQL();
                            this.timer.stop();
                            this.mostraMensagem("Fim da importa\u00e7\u00e3o");
                            this.fireAvisaFinal();
                        } else {
                            this.mostraMensagem("Alerta! N\u00e3o h\u00e1 exames dispon\u00edveis para download.");
                        }
                    } else {
                        this.mostraMensagem("Alerta! O arquivo importado est\u00e1 vazio.");
                    }
                } else {
                    this.mostraMensagem("Alerta! O arquivo importado est\u00e1 vazio.");
                }
                if (this.timer.isRunning()) {
                    this.timer.stop();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.timer.stop();
                this.fireAvisaFinal();
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
                this.mostraMensagem("Alerta! Erro encontrado, importa\u00e7\u00e3o abortada!");
            }
        }

        public boolean parse(String xml) throws Exception {
            String exame = StringUtil.getValor(xml, "metaexame");
            if (exame != null && !exame.trim().equals("")) {
                String exa_codigo = this.insereDadosExame(exame);
                if (exa_codigo == null) {
                    return false;
                }
                this.progresso.setValue(this.progresso.getValue() + 1);
                String materiais = StringUtil.getValor(exame, "materiais");
                this.insereDadosMateriais(exa_codigo, materiais);
                this.progresso.setValue(this.progresso.getValue() + 1);
                this.insereDadosHistoricos(exa_codigo, StringUtil.getValor(exame, "historicos"));
                this.progresso.setValue(this.progresso.getValue() + 1);
                this.insereDadosGrupos(exa_codigo, StringUtil.getValor(exame, "grupos"));
                this.progresso.setValue(this.progresso.getValue() + 1);
                this.insereDadosSetores(exa_codigo, StringUtil.getValor(exame, "setores"));
                this.progresso.setValue(this.progresso.getValue() + 1);
                this.insereDadosLayouts(exa_codigo, StringUtil.getValor(exame, "layouts"));
                this.progresso.setValue(this.progresso.getValue() + 1);
            }
            return true;
        }

        public String insereDadosExame(String exame) throws SQLException {
            System.gc();
            Statement s = Conexao.getStatement();
            String exa_codigo = StringUtil.getValor(exame, "codigoexame");
            String exa_sexo = StringUtil.getValor(exame, "sexoexame");
            String exa_descricao = StringUtil.getValor(exame, "descricaoexame");
            String exa_horaentrada = StringUtil.getValor(exame, "horaEntradaexame");
            String exa_horasaida = StringUtil.getValor(exame, "horasaidaexame");
            String exa_filtro = StringUtil.getValor(exame, "filtroexame");
            String exa_proibido = StringUtil.getValor(exame, "proibidoexame");
            String exa_diagnostico = StringUtil.getValor(exame, "diagnosticoexame");
            String exa_interferencia = StringUtil.getValor(exame, "interferenciaexame");
            String exa_sinonimo = StringUtil.getValor(exame, "sinonimoexame");
            String exa_salvaparcial = StringUtil.getValor(exame, "salvaparcialexame");
            String exa_idademax = StringUtil.getValor(exame, "idademaxexame");
            String exa_idademin = StringUtil.getValor(exame, "idademinexame");
            String exa_idademaxtipo = StringUtil.getValor(exame, "tipoidademaxexame");
            String exa_idademintipo = StringUtil.getValor(exame, "tipoIdademinexame");
            String exa_proibidoweb = StringUtil.getValor(exame, "proibidowebexame");
            String exa_qtdeamostras = StringUtil.getValor(exame, "quantidadeamostrasexame");
            String exa_autorizacao = StringUtil.getValor(exame, "autorizacaoexame");
            if (DBUtil.existeExame(s, Variaveis.filialPadrao, exa_codigo)) {
                int resposta = Funcoes.showPerguntaSimNao(null, "Filial cadastrado", "O exame " + exa_codigo + " j\u00e1 est\u00e1 cadastrado nesta filial.\nDeseja atualizar?");
                if (resposta == 1) {
                    return null;
                }
                this.mostraMensagem("Atualizando exame " + exa_codigo + "...");
                StringBuilder query = new StringBuilder();
                query.append("update exames set exa_sexo = ");
                query.append(DBUtil.bdText(exa_sexo));
                query.append(", exa_descricao = ");
                query.append(DBUtil.bdText(exa_descricao));
                query.append(", exa_horaentrada = ");
                query.append(DBUtil.bdText(exa_horaentrada));
                query.append(", exa_horasaida = ");
                query.append(DBUtil.bdText(exa_horasaida));
                query.append(", exa_filtro = ");
                query.append(DBUtil.bdText(exa_filtro));
                query.append(", exa_proibido = ");
                query.append(DBUtil.bdText(exa_proibido));
                query.append(",  exa_diagnostico = ");
                query.append(DBUtil.bdText(exa_diagnostico));
                query.append(", exa_interferencia = ");
                query.append(DBUtil.bdText(exa_interferencia));
                query.append(", exa_sinonimo = ");
                query.append(DBUtil.bdText(exa_sinonimo));
                query.append(", exa_salvaparcial = ");
                query.append(DBUtil.bdText(exa_salvaparcial));
                query.append(",  exa_idademax = ");
                query.append(exa_idademax);
                query.append(",  exa_idademin = ");
                query.append(exa_idademin);
                query.append(",  exa_idademaxtipo = ");
                query.append(DBUtil.bdText(exa_idademaxtipo));
                query.append(", exa_idademintipo = ");
                query.append(DBUtil.bdText(exa_idademintipo));
                query.append(", exa_proibidoweb = ");
                query.append(exa_proibidoweb);
                query.append(",  exa_qtdeamostras = ");
                query.append(exa_qtdeamostras);
                query.append(",  exa_autorizacao = ");
                query.append(DBUtil.bdText(exa_autorizacao));
                query.append(" where fil_codigo = ");
                query.append(Variaveis.filialPadrao);
                query.append(" and exa_codigo = '");
                query.append(exa_codigo);
                query.append("'");
                s.executeUpdate(query.toString());
            } else {
                this.mostraMensagem("Inserindo exame " + exa_codigo + "...");
                StringBuilder query = new StringBuilder();
                query.append("insert into exames (fil_codigo, exa_codigo, exa_sexo, exa_descricao, ");
                query.append("exa_horaentrada, exa_horasaida, exa_filtro, exa_proibido, ");
                query.append("exa_diagnostico, exa_interferencia, exa_sinonimo, exa_salvaparcial, ");
                query.append("exa_idademax, exa_idademin, exa_idademaxtipo, exa_idademintipo, ");
                query.append("exa_proibidoweb, exa_qtdeamostras, exa_autorizacao) values (");
                query.append(Variaveis.filialPadrao);
                query.append(", '");
                query.append(exa_codigo);
                query.append("', ");
                query.append(DBUtil.bdText(exa_sexo));
                query.append(", ");
                query.append(DBUtil.bdText(exa_descricao));
                query.append(", ");
                query.append(DBUtil.bdText(exa_horaentrada));
                query.append(", ");
                query.append(DBUtil.bdText(exa_horasaida));
                query.append(", ");
                query.append(DBUtil.bdText(exa_filtro));
                query.append(", ");
                query.append(DBUtil.bdText(exa_proibido));
                query.append(", ");
                query.append(DBUtil.bdText(exa_diagnostico));
                query.append(", ");
                query.append(DBUtil.bdText(exa_interferencia));
                query.append(", ");
                query.append(DBUtil.bdText(exa_sinonimo));
                query.append(", ");
                query.append(DBUtil.bdText(exa_salvaparcial));
                query.append(", ");
                query.append(exa_idademax);
                query.append(", ");
                query.append(exa_idademin);
                query.append(", ");
                query.append(DBUtil.bdText(exa_idademaxtipo));
                query.append(", ");
                query.append(DBUtil.bdText(exa_idademintipo));
                query.append(", ");
                query.append(exa_proibidoweb);
                query.append(", ");
                query.append(exa_qtdeamostras);
                query.append(", ");
                query.append(DBUtil.bdText(exa_autorizacao));
                query.append(")");
                s.executeUpdate(query.toString());
            }
            return exa_codigo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void insereDadosGrupos(String exa_codigo, String grupos) throws SQLException {
            String[] groups = StringUtil.getValores(grupos, "grupo");
            Statement s = Conexao.getStatement();
            for (String grupo : groups) {
                boolean ignoreone;
                boolean updateone;
                String mco_codigo;
                String grp_descricao;
                String grp_codigo;
                block21: {
                    block19: {
                        String old_descricao;
                        boolean ignoreall;
                        boolean updateall;
                        block20: {
                            updateall = false;
                            ignoreall = false;
                            grp_codigo = StringUtil.getValor(grupo, "codigogrupo");
                            grp_descricao = StringUtil.getValor(grupo, "descricaogrupo");
                            mco_codigo = StringUtil.getValor(grupo, "codigomaterial");
                            StringBuilder check = new StringBuilder("select grp_descricao from grupo where fil_codigo = ");
                            check.append(Variaveis.filialPadrao);
                            check.append(" and grp_codigo = '");
                            check.append(grp_codigo);
                            check.append("'");
                            old_descricao = null;
                            try (ResultSet rs = null;){
                                rs = s.executeQuery(check.toString());
                                if (rs != null && rs.next()) {
                                    old_descricao = rs.getString("grp_descricao");
                                }
                            }
                            if (old_descricao == null) {
                                this.mostraMensagem("ALERTA! O grupo de c\u00f3digo " + grp_codigo + " n\u00e3o existe nesta filial. Inser\u00e7\u00e3o ignorada...");
                                this.com_alerta = true;
                                continue;
                            }
                            updateone = false;
                            ignoreone = false;
                            if (grp_descricao.equals(old_descricao)) break block19;
                            if (ignoreall) continue;
                            if (!updateall) break block20;
                            updateone = true;
                            break block21;
                        }
                        int resposta = Funcoes.showPerguntaOpcoes(null, "O grupo de c\u00f3digo " + grp_codigo + " sendo importado \u00e9:\n" + grp_descricao + "\n" + "Entretanto, o grupo encontrado na base de dados desta filial \u00e9:\n" + old_descricao + "\n\nGostaria de atualizar para o grupo importado?", new String[]{"Atualizar", "Atualizar Todos", "Ignorar", "Ignorar Todos"});
                        switch (resposta) {
                            case 3: {
                                ignoreall = true;
                            }
                            case 2: {
                                ignoreone = true;
                                break block21;
                            }
                            case 1: {
                                updateall = true;
                            }
                            case 0: {
                                updateone = true;
                                break block21;
                            }
                        }
                        continue;
                    }
                    updateone = true;
                }
                if (ignoreone || !updateone) continue;
                StringBuilder query = new StringBuilder();
                query.append("update grupo set grp_descricao = '");
                query.append(grp_descricao);
                query.append("' where fil_codigo = ");
                query.append(Variaveis.filialPadrao);
                query.append(" and grp_codigo = '");
                query.append(grp_codigo);
                query.append("'");
                s.executeUpdate(query.toString());
                query = new StringBuilder();
                query.append("select grp_codigo from examematgrupo where fil_codigo = ");
                query.append(Variaveis.filialPadrao);
                query.append(" and exa_codigo = '");
                query.append(exa_codigo);
                query.append("' and grp_codigo = '");
                query.append(grp_codigo);
                query.append("' and mco_codigo = ").append(mco_codigo);
                try (ResultSet res = null;){
                    res = s.executeQuery(query.toString());
                    if (res != null && res.next()) continue;
                    query = new StringBuilder();
                    query.append("insert into examematgrupo (exa_codigo, fil_codigo, grp_codigo, mco_codigo) values ('");
                    query.append(exa_codigo);
                    query.append("', ");
                    query.append(Variaveis.filialPadrao);
                    query.append(", '");
                    query.append(grp_codigo).append("', ").append(mco_codigo);
                    query.append(") ");
                    s.executeUpdate(query.toString());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void insereDadosSetores(String exa_codigo, String setores) throws SQLException {
            String[] sets = StringUtil.getValores(setores, "setor");
            Statement s = Conexao.getStatement();
            String[] stringArray = sets;
            int n = stringArray.length;
            int n2 = 0;
            while (true) {
                block23: {
                    if (n2 >= n) {
                        return;
                    }
                    String setor = stringArray[n2];
                    boolean updateall = false;
                    boolean ignoreall = false;
                    String set_codigo = StringUtil.getValor(setor, "codigosetor");
                    String set_descricao = StringUtil.getValor(setor, "descricaosetor");
                    String ese_printmapa = StringUtil.getValor(setor, "imprimirmapasetor");
                    String ese_default = StringUtil.getValor(setor, "padraosetor");
                    String ese_printetqcoleta = StringUtil.getValor(setor, "imprimiretqcoletasetor");
                    String ese_printetqtriagem = StringUtil.getValor(setor, "imprimiretqtriagemsetor");
                    String set_cor = StringUtil.getValor(setor, "corsetor");
                    String set_sigla = StringUtil.getValor(setor, "siglasetor");
                    String set_responsavel = StringUtil.getValor(setor, "responsavelsetor");
                    StringBuilder check = new StringBuilder("select set_descricao from setores where fil_codigo = ");
                    check.append(Variaveis.filialPadrao);
                    check.append(" and set_codigo = ");
                    check.append(set_codigo);
                    try (ResultSet rs = null;){
                        rs = s.executeQuery(check.toString());
                        String old_descricao = null;
                        if (rs != null && rs.next()) {
                            old_descricao = rs.getString("set_descricao");
                        }
                        if (old_descricao == null) {
                            this.mostraMensagem("ALERTA! O setor de c\u00f3digo " + set_codigo + " n\u00e3o existe nesta filial. Inser\u00e7\u00e3o ignorada...");
                            this.com_alerta = true;
                            break block23;
                        }
                        boolean updateone = false;
                        boolean ignoreone = false;
                        if (!set_descricao.equals(old_descricao)) {
                            if (ignoreall) break block23;
                            if (updateall) {
                                updateone = true;
                            }
                            int resposta = Funcoes.showPerguntaOpcoes(null, "O setor de c\u00f3digo " + set_codigo + " sendo importado \u00e9:\n" + set_descricao + "\n" + "Entretanto, o setor encontrado na base de dados desta filial \u00e9:\n" + old_descricao + "\n\nGostaria de atualizar para o setor importado?", new String[]{"Atualizar", "Atualizar Todos", "Ignorar", "Ignorar Todos"});
                            switch (resposta) {
                                case 3: {
                                    ignoreall = true;
                                }
                                case 2: {
                                    ignoreone = true;
                                    break;
                                }
                                case 1: {
                                    updateall = true;
                                }
                                case 0: {
                                    updateone = true;
                                    break;
                                }
                                default: {
                                    break block23;
                                }
                            }
                        }
                        updateone = true;
                    }
                }
                ++n2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public void insereDadosMateriais(String exa_codigo, String materiais) throws SQLException {
            mats = StringUtil.getValores(materiais, "material");
            s = Conexao.getStatement();
            block26: for (String material : mats) {
                updateall = false;
                ignoreall = false;
                mco_codigo = StringUtil.getValor(material, "codigomatcoleta");
                mco_abreviatura = StringUtil.getValor(material, "abreviaturamatcoleta");
                mco_descricao = StringUtil.getValor(material, "descricaomatcoleta");
                check = new StringBuilder("select mco_descricao, mco_abreviatura from materialcoleta where fil_codigo = ");
                check.append(Variaveis.filialPadrao);
                check.append(" and mco_codigo = ");
                check.append(mco_codigo);
                rs = null;
                try {
                    rs = s.executeQuery(check.toString());
                    old_descricao = null;
                    old_abreviatura = null;
                    if (rs == null || !rs.next()) {
                        this.mostraMensagem("ALERTA! O material de c\u00f3digo " + mco_codigo + " (" + mco_abreviatura + ") n\u00e3o existe nesta filial. Inser\u00e7\u00e3o ignorada...");
                        this.com_alerta = true;
                        continue;
                    }
                    old_descricao = rs.getString("mco_descricao");
                    old_abreviatura = rs.getString("mco_abreviatura");
                    mco_solicitarmat = StringUtil.getValor(material, "solicitarmatcoleta");
                    emc_default = StringUtil.getValor(material, "materialpadraoexamematcoleta");
                    emc_pergunta = StringUtil.getValor(material, "perguntaexamematcoleta");
                    emc_preparo = StringUtil.getValor(material, "preparoexamematcoleta");
                    emc_prepamostra = StringUtil.getValor(material, "preparoamostraexamematcoleta");
                    emc_inadequada = StringUtil.getValor(material, "inadequadaexamematcoleta");
                    prz_codigo = StringUtil.getValor(material, "codigoprazoentrega");
                    prz_descricao = StringUtil.getValor(material, "descricaoprazoentrega");
                    met_codigo = StringUtil.getValor(material, "codigometodologia");
                    met_descricao = StringUtil.getValor(material, "descricaometodologia");
                    emc_ordem = StringUtil.getValor(material, "ordemexamematcoleta");
                    emc_pagina = StringUtil.getValor(material, "paginaexamematcoleta");
                    emc_codigocbhpm = StringUtil.getValor(material, "codigocbhpmexamematcoleta");
                    emc_codigoamb = StringUtil.getValor(material, "codigoambexamematcoleta");
                    emc_conservacao = StringUtil.getValor(material, "conservacaoexamematcoleta");
                    emc_diasconserva = StringUtil.getValor(material, "diasconservaexamematcoleta");
                    emc_temperaturainicial = StringUtil.getValor(material, "tempinicialexamematcoleta");
                    emc_temperaturafinal = StringUtil.getValor(material, "tempfinalexamematcoleta");
                    emc_referencia = StringUtil.getValor(material, "referenciaexamematcoleta");
                    emc_procedimento = StringUtil.getValor(material, "procedimentoexamematcoleta");
                    emc_instrucaocoleta = StringUtil.getValor(material, "instrucaoexamematcoleta");
                    emc_solicitarjejum = StringUtil.getValor(material, "solicitarjejumexamematcoleta");
                    emc_obrigamedicamento = StringUtil.getValor(material, "obrigamedicamentoexamematcoleta");
                    emc_instrcoleta = StringUtil.getValor(material, "instrucaocoletaexamematcoleta");
                    emc_marcarexterno = StringUtil.getValor(material, "marcarexternoexamematcoleta");
                    emc_obrigadum = StringUtil.getValor(material, "obrigadumexamematcoleta");
                    emc_obrigapeso = StringUtil.getValor(material, "obrigapesoexamematcoleta");
                    emc_obrigaaltura = StringUtil.getValor(material, "obrigaalturaexamematcoleta");
                    emc_obrigavolume = StringUtil.getValor(material, "obrigavolumeexamematcoleta");
                    emc_obrigatempodiurese = StringUtil.getValor(material, "obrigatempodiureseexamematcoleta");
                    check = new StringBuilder("select met_descricao from metodologia where fil_codigo = ");
                    check.append(Variaveis.filialPadrao);
                    check.append(" and met_codigo = ");
                    check.append(met_codigo);
                    ms = null;
                    oldmet_descricao = null;
                    try {
                        ms = s.executeQuery(check.toString());
                        if (ms != null && ms.next()) {
                            oldmet_descricao = ms.getString("met_descricao");
                        }
                    }
                    finally {
                        if (ms != null) {
                            ms.close();
                        }
                    }
                    if (oldmet_descricao == null) {
                        this.mostraMensagem("ALERTA! A metodologia de c\u00f3digo " + met_codigo + " n\u00e3o existe nesta filial. Inser\u00e7\u00e3o ignorada...");
                        this.com_alerta = true;
                        continue;
                    }
                    if (!oldmet_descricao.equals(met_descricao)) {
                        this.mostraMensagem("ALERTA! A metodologia de c\u00f3digo " + met_codigo + " importada difere da encontrada nesta filial. Inser\u00e7\u00e3o ignorada...");
                        this.com_alerta = true;
                        continue;
                    }
                    check = new StringBuilder("select prz_descricao from prazoentrega where fil_codigo = ");
                    check.append(Variaveis.filialPadrao);
                    check.append(" and prz_codigo = ");
                    check.append(prz_codigo);
                    ps = null;
                    oldprz_descricao = null;
                    try {
                        ps = s.executeQuery(check.toString());
                        if (ps != null && ps.next()) {
                            oldprz_descricao = ps.getString("prz_descricao");
                        }
                    }
                    finally {
                        if (ps != null) {
                            ps.close();
                        }
                    }
                    if (oldprz_descricao == null) {
                        this.mostraMensagem("ALERTA! O prazo de entrega de c\u00f3digo " + prz_codigo + " n\u00e3o existe nesta filial. Inser\u00e7\u00e3o ignorada...");
                        this.com_alerta = true;
                        continue;
                    }
                    if (!oldprz_descricao.equals(prz_descricao)) {
                        this.mostraMensagem("ALERTA! O prazo de entrega de c\u00f3digo " + prz_codigo + " importado difere do encontrado nesta filial. Inser\u00e7\u00e3o ignorada...");
                        this.com_alerta = true;
                        continue;
                    }
                    updateone = false;
                    ignoreone = false;
                    if (!mco_descricao.equals(old_descricao) || !mco_abreviatura.equals(old_abreviatura)) {
                        if (ignoreall) continue;
                        if (updateall) {
                            updateone = true;
                        }
                        resposta = Funcoes.showPerguntaOpcoes(null, "O material de c\u00f3digo " + mco_codigo + " (" + mco_abreviatura + ") sendo importado \u00e9:\n" + mco_descricao + "\n" + "Entretanto, o material encontrado na base de dados desta filial \u00e9:\n" + " (" + mco_abreviatura + ") " + old_descricao + "\n\nGostaria de atualizar para o material importado?", new String[]{"Atualizar", "Atualizar Todos", "Ignorar", "Ignorar Todos"});
                        switch (resposta) {
                            case 3: {
                                ignoreall = true;
                            }
                            case 2: {
                                ignoreone = true;
                                break;
                            }
                            case 1: {
                                updateall = true;
                            }
                            case 0: {
                                updateone = true;
                                break;
                            }
                            ** default:
lbl131:
                            // 1 sources

                            continue block26;
                        }
                    }
                    updateone = true;
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void insereDadosHistoricos(String exa_codigo, String historicos) throws SQLException {
            String[] hists = StringUtil.getValores(historicos, "historico");
            Statement s = Conexao.getStatement();
            String[] stringArray = hists;
            int n = stringArray.length;
            int n2 = 0;
            while (true) {
                block25: {
                    if (n2 >= n) {
                        return;
                    }
                    String historico = stringArray[n2];
                    boolean updateall = false;
                    boolean ignoreall = false;
                    String his_codigo = StringUtil.getValor(historico, "codigohistorico");
                    String his_descricao = StringUtil.getValor(historico, "descricaohistorico");
                    StringBuilder check = new StringBuilder("select his_descricao from historico where fil_codigo = ");
                    check.append(Variaveis.filialPadrao);
                    check.append(" and his_codigo = '");
                    check.append(his_codigo);
                    check.append("'");
                    try (ResultSet rs = null;){
                        rs = s.executeQuery(check.toString());
                        String old_descricao = null;
                        if (rs != null && rs.next()) {
                            old_descricao = rs.getString("his_descricao");
                        }
                        if (old_descricao == null) {
                            this.mostraMensagem("ALERTA! O grupo de c\u00f3digo " + his_codigo + " n\u00e3o existe nesta filial. Inser\u00e7\u00e3o ignorada...");
                            this.com_alerta = true;
                            break block25;
                        }
                        boolean updateone = false;
                        boolean ignoreone = false;
                        if (!his_descricao.equals(old_descricao)) {
                            if (ignoreall) break block25;
                            if (updateall) {
                                updateone = true;
                            }
                            int resposta = Funcoes.showPerguntaOpcoes(null, "O hist\u00f3rico de c\u00f3digo " + his_codigo + " sendo importado \u00e9:\n" + his_descricao + "\n" + "Entretanto, o hist\u00f3rico encontrado na base de dados desta filial \u00e9:\n" + old_descricao + "\n\nGostaria de atualizar para o hist\u00f3rico importado?", new String[]{"Atualizar", "Atualizar Todos", "Ignorar", "Ignorar Todos"});
                            switch (resposta) {
                                case 3: {
                                    ignoreall = true;
                                }
                                case 2: {
                                    ignoreone = true;
                                    break;
                                }
                                case 1: {
                                    updateall = true;
                                }
                                case 0: {
                                    updateone = true;
                                    break;
                                }
                                default: {
                                    break block25;
                                }
                            }
                        }
                        updateone = true;
                    }
                }
                ++n2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public void insereDadosLayouts(String exa_codigo, String materiais) throws SQLException {
            lays = StringUtil.getValores(materiais, "layout");
            s = Conexao.getStatement();
            block23: for (String layout : lays) {
                updateall = false;
                ignoreall = false;
                lay_codigo = StringUtil.getValor(layout, "codigolayout");
                lay_descricao = StringUtil.getValor(layout, "descricaolayout");
                check = new StringBuilder("select lay_descricao from layout where fil_codigo = ");
                check.append(Variaveis.filialPadrao);
                check.append(" and lay_codigo = ");
                check.append(lay_codigo);
                rs = null;
                try {
                    rs = s.executeQuery(check.toString());
                    old_descricao = null;
                    if (rs == null || !rs.next()) {
                        this.mostraMensagem("ALERTA! O layout de c\u00f3digo " + lay_codigo + " n\u00e3o existe nesta filial. Inser\u00e7\u00e3o ignorada...");
                        this.com_alerta = true;
                        continue;
                    }
                    old_descricao = rs.getString("lay_descricao");
                    mco_codigo = StringUtil.getValor(layout, "codigomatcoleta");
                    ela_idadefim = StringUtil.getValor(layout, "idadefimexamelayout");
                    ela_idadeini = StringUtil.getValor(layout, "idadeiniexamelayout");
                    ela_idadefimtipo = StringUtil.getValor(layout, "tipoidadefimexamelayout");
                    ela_idadeinitipo = StringUtil.getValor(layout, "tipoidadeiniexamelayout");
                    ela_padrao = StringUtil.getValor(layout, "padraoexamelayout");
                    lay_cabec = StringUtil.getValor(layout, "cabecalholayout");
                    lay_comprovante = StringUtil.getValor(layout, "comprovantelayout");
                    lay_tipolaudo = StringUtil.getValor(layout, "tipolaudolayout");
                    lay_tipomapa = StringUtil.getValor(layout, "tipomapalayout");
                    lay_tipocomprovante = StringUtil.getValor(layout, "tipocomprovantelayout");
                    lay_tipocarteira = StringUtil.getValor(layout, "tipocarteiralayout");
                    lay_carteira = StringUtil.getValor(layout, "carteiralayout");
                    lay_cabecmapa = StringUtil.getValor(layout, "mapacabecalholayout");
                    lay_tipoorcamento = StringUtil.getValor(layout, "tipoorcamentolayout");
                    lay_tiporecibo = StringUtil.getValor(layout, "tiporecibolayout");
                    lay_orcamento = StringUtil.getValor(layout, "orcamentolayout");
                    lay_recibo = StringUtil.getValor(layout, "recibolayout");
                    lay_etqcol = StringUtil.getValor(layout, "etiquetacoletalayout");
                    lay_etqtri = StringUtil.getValor(layout, "etiquetatriagemlayout");
                    lay_tipoetqcol = StringUtil.getValor(layout, "tipoetqcoletalayout");
                    lay_tipoetqtri = StringUtil.getValor(layout, "tipoetqtriagemlayout");
                    lay_capa = StringUtil.getValor(layout, "capalayout");
                    lay_tipocapa = StringUtil.getValor(layout, "tipocapalayout");
                    lay_tipogeral = StringUtil.getValor(layout, "tipogerallayout");
                    lay_geral = StringUtil.getValor(layout, "gerallayout");
                    lay_tipoanexo = StringUtil.getValor(layout, "tipoanexolayout");
                    lay_anexo = StringUtil.getValor(layout, "anexolayout");
                    lay_tipoatacompanha = StringUtil.getValor(layout, "tipoatacompanhalayout");
                    lay_tipoatpaciente = StringUtil.getValor(layout, "tipoatpacientelayout");
                    lay_tipoetqapoio = StringUtil.getValor(layout, "tipoetqapoiolayout");
                    lay_atacompanha = StringUtil.getValor(layout, "atacompanhalayout");
                    lay_atpaciente = StringUtil.getValor(layout, "atpacientelayout");
                    lay_etqapoio = StringUtil.getValor(layout, "etqapoiolayout");
                    metodos = StringUtil.getValores(layout, "layoutmetodo");
                    check = new StringBuilder("select mco_codigo from examematcoleta where fil_codigo = ");
                    check.append(Variaveis.filialPadrao);
                    check.append(" and mco_codigo = ");
                    check.append(mco_codigo);
                    check.append(" and exa_codigo = '");
                    check.append(exa_codigo);
                    check.append("'");
                    ms = null;
                    try {
                        ms = s.executeQuery(check.toString());
                        if (ms == null || !ms.next()) {
                            this.mostraMensagem("ALERTA! O material de exame para os c\u00f3digos " + mco_codigo + " e " + exa_codigo + " n\u00e3o existe nesta filial. Inser\u00e7\u00e3o ignorada...");
                            this.com_alerta = true;
                            continue;
                        }
                    }
                    finally {
                        if (ms != null) {
                            ms.close();
                        }
                    }
                    updateone = false;
                    ignoreone = false;
                    if (!lay_descricao.equals(old_descricao)) {
                        if (ignoreall) continue;
                        if (updateall) {
                            updateone = true;
                        }
                        resposta = Funcoes.showPerguntaOpcoes(null, "O layout de c\u00f3digo " + lay_codigo + " sendo importado \u00e9:\n" + lay_descricao + "\n" + "Entretanto, o layout encontrado na base de dados desta filial \u00e9:\n" + old_descricao + "\n\nGostaria de atualizar para o layout importado?", new String[]{"Atualizar", "Atualizar Todos", "Ignorar", "Ignorar Todos"});
                        switch (resposta) {
                            case 3: {
                                ignoreall = true;
                            }
                            case 2: {
                                ignoreone = true;
                                break;
                            }
                            case 1: {
                                updateall = true;
                            }
                            case 0: {
                                updateone = true;
                                break;
                            }
                            ** default:
lbl105:
                            // 1 sources

                            continue block23;
                        }
                    }
                    updateone = true;
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
        }
    }

    public class CheckBoxRenderer
    extends JCheckBox
    implements TableCellRenderer {
        CheckBoxRenderer() {
            this.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            this.setSelected(value != null && (Boolean)value != false);
            return this;
        }
    }

    private class FiltroXML
    extends FileFilter {
        private FiltroXML() {
        }

        @Override
        public boolean accept(File f) {
            return f.isDirectory() || f.getName().toLowerCase().endsWith(".xml");
        }

        @Override
        public String getDescription() {
            return ".xml files";
        }
    }
}

