/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.exportacao.filial.exames;

import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.laboratorio.exportacao.filial.exames.AvisaFinal;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.Tempo;
import jalis.util.logger.ErrorLogger;
import java.io.File;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;
import javax.swing.JTextField;

class Exportar
extends Thread {
    private JProgressBar progresso;
    private Tempo timer;
    private JLabel labelTempo;
    private String[] itemExame;
    private JTextArea texto;
    private JTextField textpath;
    private int qtdeExames = 0;
    private ArrayList<AvisaFinal> listenerList = new ArrayList();

    public Exportar(JProgressBar barra, JLabel tempo, JTextArea texto, JTextField textpath) {
        super("Thread - Exportar exames");
        this.progresso = barra;
        this.labelTempo = tempo;
        this.texto = texto;
        this.textpath = textpath;
    }

    public void limpaMensagem() {
        this.texto.setText("");
    }

    public void mostraMensagem(String str) {
        this.texto.append(str + "\n");
    }

    public void addAvisaFinal(AvisaFinal l) {
        this.listenerList.add(l);
    }

    public void removeAvisaFinal(AvisaFinal l) {
        this.listenerList.remove(l);
    }

    private void fireAvisaFinal() {
        for (AvisaFinal c : this.listenerList) {
            c.threadParada();
        }
    }

    public void setQtdeExames(int q) {
        this.qtdeExames = q;
    }

    public void setSelecaoExame(String[] s) {
        this.itemExame = s;
    }

    @Override
    public void start() {
        this.timer = new Tempo(this.labelTempo);
        this.timer.start();
        super.start();
    }

    @Override
    public void run() {
        this.limpaMensagem();
        int contaItens = 0;
        if (this.itemExame != null) {
            contaItens += this.itemExame.length;
        }
        if (this.textpath.getText().equals("")) {
            this.mostraMensagem("Por favor, especifique algum caminho para a exporta\u00e7\u00e3o");
            this.timer.stop();
            this.fireAvisaFinal();
            return;
        }
        if (!new File(this.textpath.getText()).isDirectory()) {
            this.mostraMensagem("O caminho digitado n\u00e3o \u00e9 um diret\u00f3rio v\u00e1lido.\nPor favor, especifique um caminho correto para a exporta\u00e7\u00e3o");
            this.timer.stop();
            this.fireAvisaFinal();
            return;
        }
        ParametrosLocais.setParametro("xmlExameExportacao", this.textpath.getText());
        ParametrosLocais.salvaParametros();
        if (contaItens == 0) {
            this.mostraMensagem("Por favor, selecione algum exame para exporta\u00e7\u00e3o");
            this.timer.stop();
            this.fireAvisaFinal();
            return;
        }
        this.mostraMensagem("Total de exames selecionados: " + contaItens);
        this.progresso.setMaximum(contaItens);
        this.progresso.setValue(0);
        Statement st = Conexao.getStatement();
        try {
            StringBuilder xml = new StringBuilder();
            StringBuilder buf = new StringBuilder();
            if (this.itemExame != null) {
                this.mostraMensagem("Buscando exames selecionados");
                buf.delete(0, buf.length());
                buf.append("select exa_codigo as codigoexame, ");
                buf.append("exa_sexo as sexoexame, ");
                buf.append("exa_descricao as descricaoexame, ");
                buf.append("exa_horaentrada as horaentradaexame, ");
                buf.append("exa_horasaida as horasaidaexame, ");
                buf.append("exa_filtro as filtroexame, ");
                buf.append("exa_proibido as proibidoexame, ");
                buf.append("exa_diagnostico as diagnosticoexame, ");
                buf.append("exa_interferencia as interferenciaexame, ");
                buf.append("exa_sinonimo as sinonimoexame, ");
                buf.append("exa_salvaparcial as salvaparcialexame, ");
                buf.append("exa_idademax as idademaxexame, ");
                buf.append("exa_idademin as idademinexame, ");
                buf.append("exa_idademaxtipo as tipoidademaxexame, ");
                buf.append("exa_idademintipo as tipoidademinexame, ");
                buf.append("exa_proibidoweb as proibidowebexame, ");
                buf.append("exa_qtdeamostras as quantidadeamostrasexame, ");
                buf.append("exa_autorizacao as autorizacaoexame ");
                buf.append("from exames where fil_codigo = ");
                buf.append(Variaveis.filialPadrao);
                if (this.itemExame.length != this.qtdeExames) {
                    buf.append(" and (");
                    for (int i = 0; i < this.itemExame.length; ++i) {
                        buf.append("exa_codigo = '");
                        buf.append(this.itemExame[i]);
                        buf.append("'");
                        if (i >= this.itemExame.length - 1) continue;
                        buf.append(" or ");
                    }
                    buf.append(") order by exa_codigo");
                }
                ResultSet rsexames = Conexao.executeQuery(st, buf.toString());
                while (rsexames != null && rsexames.next()) {
                    char barra;
                    xml.delete(0, xml.length());
                    xml.append("<metaexame>");
                    String exa_codigo = rsexames.getString("codigoexame");
                    this.mostraMensagem("Exportando exame " + exa_codigo);
                    ResultSetMetaData mdexames = rsexames.getMetaData();
                    for (int i = 1; i <= mdexames.getColumnCount(); ++i) {
                        String nomeColuna = mdexames.getColumnName(i);
                        String valor = rsexames.getString(nomeColuna);
                        xml.append(StringUtil.getTag(nomeColuna, valor));
                    }
                    xml.append(this.buscaDadosMaterialColetado(exa_codigo));
                    xml.append(this.buscaDadosHistorico(exa_codigo));
                    xml.append(this.buscaDadosSetores(exa_codigo));
                    xml.append(this.buscaDadosGrupo(exa_codigo));
                    xml.append(this.buscaDadosModelos(exa_codigo));
                    xml.append("</metaexame>");
                    StringBuilder caminho = new StringBuilder(this.textpath.getText());
                    char c = barra = Funcoes.isLinux() ? (char)'/' : '\\';
                    if (!caminho.toString().endsWith(String.valueOf(barra))) {
                        caminho.append(barra);
                    }
                    caminho.append(exa_codigo);
                    caminho.append(".xml");
                    StringUtil.escreverArquivoTexto(caminho.toString(), xml.toString());
                    this.progresso.setValue(this.progresso.getValue() + 1);
                }
            }
            Conexao.arquivaSQL();
            this.mostraMensagem("Arquivo(s) gerado(s) com sucesso em " + this.textpath.getText());
            this.mostraMensagem("Fim da exporta\u00e7\u00e3o");
        }
        catch (Exception ex) {
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
        }
        Conexao.fecharStatement(st);
        this.timer.stop();
        this.fireAvisaFinal();
    }

    public String buscaDadosMaterialColetado(String exa_codigo) throws SQLException {
        StringBuilder buf = new StringBuilder();
        StringBuilder xml = new StringBuilder("<materiais>");
        Statement st = Conexao.getStatement();
        buf.append("select a.mco_codigo as codigomatcoleta, ");
        buf.append("a.emc_default as materialpadraoexamematcoleta, ");
        buf.append("a.emc_pergunta as perguntaexamematcoleta, ");
        buf.append("a.emc_preparo as preparoexamematcoleta, ");
        buf.append("a.emc_prepamostra as preparoamostraexamematcoleta, ");
        buf.append("a.emc_inadequada as inadequadaexamematcoleta, ");
        buf.append("a.prz_codigo as codigoprazoentrega, ");
        buf.append("a.met_codigo as codigometodologia, ");
        buf.append("a.emc_ordem as ordemexamematcoleta, ");
        buf.append("a.emc_pagina as paginaexamematcoleta, ");
        buf.append("a.emc_codigocbhpm as codigocbhpmexamematcoleta, ");
        buf.append("a.emc_codigoamb as codigoambexamematcoleta, ");
        buf.append("a.emc_conservacao as conservacaoexamematcoleta, ");
        buf.append("a.emc_diasconserva as diasconservaexamematcoleta, ");
        buf.append("a.emc_temperaturainicial as tempinicialexamematcoleta, ");
        buf.append("a.emc_temperaturafinal as tempfinalexamematcoleta, ");
        buf.append("a.emc_referencia as referenciaexamematcoleta, ");
        buf.append("a.emc_procedimento as procedimentoexamematcoleta, ");
        buf.append("a.emc_instrucaocoleta as instruimpressacoletaexamematcoleta, ");
        buf.append("a.emc_solicitarjejum as solicitarjejumexamematcoleta, ");
        buf.append("a.emc_obrigamedicamento as obrigamedicamentoexamematcoleta, ");
        buf.append("a.emc_instrcoleta as instrucaocoletaexamematcoleta, ");
        buf.append("a.emc_marcarexterno as marcarexternoexamematcoleta, ");
        buf.append("a.emc_obrigadum as obrigadumexamematcoleta, ");
        buf.append("a.emc_obrigapeso as obrigapesoexamematcoleta, ");
        buf.append("a.emc_obrigaaltura as obrigaalturaexamematcoleta, ");
        buf.append("a.emc_obrigavolume as obrigavolumeexamematcoleta, ");
        buf.append("a.emc_obrigatempodiurese as obrigatempodiureseexamematcoleta, ");
        buf.append("b.mco_abreviatura as abreviaturamatcoleta, ");
        buf.append("b.mco_descricao as descricaomatcoleta, ");
        buf.append("b.mco_solicitarmat as solicitarmatcoleta, ");
        buf.append("c.prz_descricao as descricaoprazoentrega, ");
        buf.append("d.met_descricao as descricaometodologia ");
        buf.append("from examematcoleta a ");
        buf.append("left join materialcoleta b on a.fil_codigo = b.fil_codigo and a.mco_codigo = b.mco_codigo ");
        buf.append("left join prazoentrega c on a.fil_codigo = c.fil_codigo and a.prz_codigo = c.prz_codigo ");
        buf.append("left join metodologia d on a.fil_codigo = d.fil_codigo and a.met_codigo = d.met_codigo ");
        buf.append("where a.fil_codigo = ");
        buf.append(Variaveis.filialPadrao);
        buf.append(" and a.exa_codigo = '");
        buf.append(exa_codigo);
        buf.append("' order by a.mco_codigo");
        ResultSet rsmaterial = Conexao.executeQuery(st, buf.toString());
        while (rsmaterial != null && rsmaterial.next()) {
            StringBuilder temp = new StringBuilder();
            temp.append("<material>");
            ResultSetMetaData mdmaterial = rsmaterial.getMetaData();
            for (int i = 1; i <= mdmaterial.getColumnCount(); ++i) {
                String nomeColuna = mdmaterial.getColumnName(i);
                String valor = rsmaterial.getString(nomeColuna);
                temp.append(StringUtil.getTag(nomeColuna, valor));
            }
            temp.append("</material>");
            xml.append((CharSequence)temp);
        }
        xml.append("</materiais>");
        return xml.toString();
    }

    public String buscaDadosSetores(String exa_codigo) throws SQLException {
        StringBuilder buf = new StringBuilder();
        StringBuilder xml = new StringBuilder("<setores>");
        Statement st = Conexao.getStatement();
        buf.append("select a.set_codigo as codigosetor, ");
        buf.append("b.set_descricao as descricaosetor, ");
        buf.append("b.set_cor as corsetor, ");
        buf.append("b.set_sigla as siglasetor, ");
        buf.append("b.set_responsavel as responsavelsetor, ");
        buf.append("a.ese_printmapa as imprimirmapasetor, ");
        buf.append("a.ese_default as padraosetor, ");
        buf.append("a.ese_printetqcoleta as imprimiretqcoletasetor, ");
        buf.append("a.ese_printetqtriagem as imprimiretqtriagemsetor ");
        buf.append("from examesetor a ");
        buf.append("left join setores b on a.fil_codigo = b.fil_codigo and a.set_codigo = b.set_codigo ");
        buf.append("where a.fil_codigo = ");
        buf.append(Variaveis.filialPadrao);
        buf.append(" and a.exa_codigo = '");
        buf.append(exa_codigo);
        buf.append("' order by a.set_codigo");
        ResultSet rssetores = Conexao.executeQuery(st, buf.toString());
        while (rssetores != null && rssetores.next()) {
            xml.append("<setor>");
            ResultSetMetaData mdmaterial = rssetores.getMetaData();
            for (int i = 1; i <= mdmaterial.getColumnCount(); ++i) {
                String nomeColuna = mdmaterial.getColumnName(i);
                String valor = rssetores.getString(nomeColuna);
                xml.append(StringUtil.getTag(nomeColuna, valor));
            }
            xml.append("</setor>");
        }
        xml.append("</setores>");
        return xml.toString();
    }

    public String buscaDadosHistorico(String exa_codigo) throws SQLException {
        StringBuilder buf = new StringBuilder();
        StringBuilder xml = new StringBuilder("<historicos>");
        Statement st = Conexao.getStatement();
        buf.append("select a.his_codigo as codigohistorico, ");
        buf.append("b.his_descricao as descricaohistorico ");
        buf.append("from examehistorico a ");
        buf.append("left join historicos b on a.fil_codigo = b.fil_codigo and a.his_codigo = b.his_codigo ");
        buf.append("where a.fil_codigo = ");
        buf.append(Variaveis.filialPadrao);
        buf.append(" and a.exa_codigo = '");
        buf.append(exa_codigo);
        buf.append("' order by a.his_codigo");
        ResultSet rshistoricos = Conexao.executeQuery(st, buf.toString());
        while (rshistoricos != null && rshistoricos.next()) {
            xml.append("<historico>");
            ResultSetMetaData mdmaterial = rshistoricos.getMetaData();
            for (int i = 1; i <= mdmaterial.getColumnCount(); ++i) {
                String nomeColuna = mdmaterial.getColumnName(i);
                String valor = rshistoricos.getString(nomeColuna);
                xml.append(StringUtil.getTag(nomeColuna, valor));
            }
            xml.append("</historico>");
        }
        xml.append("</historicos>");
        return xml.toString();
    }

    public String buscaDadosGrupo(String exa_codigo) throws SQLException {
        StringBuilder buf = new StringBuilder();
        StringBuilder xml = new StringBuilder("<grupos>");
        Statement st = Conexao.getStatement();
        buf.append("select a.grp_codigo as codigogrupo, ");
        buf.append("b.grp_descricao as descricaogrupo, ");
        buf.append("a.mco_codigo as codigomaterial ");
        buf.append("from examematgrupo a ");
        buf.append("left join grupo b on a.fil_codigo = b.fil_codigo and a.grp_codigo = b.grp_codigo ");
        buf.append("where a.fil_codigo = ");
        buf.append(Variaveis.filialPadrao);
        buf.append(" and a.exa_codigo = '");
        buf.append(exa_codigo);
        buf.append("' order by a.grp_codigo");
        ResultSet rssetores = Conexao.executeQuery(st, buf.toString());
        while (rssetores != null && rssetores.next()) {
            xml.append("<grupo>");
            ResultSetMetaData mdmaterial = rssetores.getMetaData();
            for (int i = 1; i <= mdmaterial.getColumnCount(); ++i) {
                String nomeColuna = mdmaterial.getColumnName(i);
                String valor = rssetores.getString(nomeColuna);
                xml.append(StringUtil.getTag(nomeColuna, valor));
            }
            xml.append("</grupo>");
        }
        xml.append("</grupos>");
        return xml.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String buscaDadosModelos(String exa_codigo) throws SQLException {
        StringBuilder buf = new StringBuilder();
        StringBuilder xml = new StringBuilder("<layouts>");
        Statement st = Conexao.getStatement();
        buf.append("select a.lay_codigo as codigolayout, ");
        buf.append("a.mco_codigo as codigomatcoleta, ");
        buf.append("a.ela_idadefim as idadefimexamelayout, ");
        buf.append("a.ela_idadeini as idadeiniexamelayout, ");
        buf.append("a.ela_idadefimtipo as tipoidadefimexamelayout, ");
        buf.append("a.ela_idadeinitipo as tipoidadeiniexamelayout, ");
        buf.append("a.ela_padrao as padraoexamelayout, ");
        buf.append("b.lay_descricao as descricaolLayout, ");
        buf.append("b.lay_cabec as cabecalholayout, ");
        buf.append("b.lay_comprovante as comprovantelayout, ");
        buf.append("b.lay_tipolaudo as tipolaudolayout, ");
        buf.append("b.lay_tipomapa as tipomapalayout, ");
        buf.append("b.lay_tipocomprovante as tipocomprovantelayout, ");
        buf.append("b.lay_tipocarteira as tipocarteiralayout, ");
        buf.append("b.lay_carteira as carteiralayout, ");
        buf.append("b.lay_cabecmapa as mapacabecalholayout, ");
        buf.append("b.lay_tipoorcamento as tipoorcamentolayout, ");
        buf.append("b.lay_tiporecibo as tiporecibolayout, ");
        buf.append("b.lay_orcamento as orcamentolayout, ");
        buf.append("b.lay_recibo as recibolayout, ");
        buf.append("b.lay_etqcol as etiquetacoletalayout, ");
        buf.append("b.lay_etqtri as etiquetatriagemlayout, ");
        buf.append("b.lay_tipoetqcol as tipoetqcoletalayout, ");
        buf.append("b.lay_tipoetqtri as tipoetqtriagemlayout, ");
        buf.append("b.lay_capa as capalayout, ");
        buf.append("b.lay_tipocapa as tipocapalayout, ");
        buf.append("b.lay_tipogeral as tipogerallayout, ");
        buf.append("b.lay_geral as gerallayout, ");
        buf.append("b.lay_tipoanexo as tipoanexolayout, ");
        buf.append("b.lay_anexo as anexolayout, ");
        buf.append("b.lay_tipoatacompanha as tipoatacompanhalayout, ");
        buf.append("b.lay_tipoatpaciente as tipoatpacientelayout, ");
        buf.append("b.lay_tipoetqapoio as tipoetqapoiolayout, ");
        buf.append("b.lay_atacompanha as atacompanhalayout, ");
        buf.append("b.lay_atpaciente as atpacientelayout, ");
        buf.append("b.lay_etqapoio as etqapoiolayout ");
        buf.append("from examelayout a ");
        buf.append("left join layout b on a.fil_codigo = b.fil_codigo and a.lay_codigo = b.lay_codigo ");
        buf.append("where a.fil_codigo = ");
        buf.append(Variaveis.filialPadrao);
        buf.append(" and a.exa_codigo = '");
        buf.append(exa_codigo);
        buf.append("' order by a.lay_codigo");
        ResultSet rslayout = Conexao.executeQuery(st, buf.toString());
        while (rslayout != null && rslayout.next()) {
            StringBuilder temp = new StringBuilder();
            temp.append("<layout>");
            ResultSetMetaData mdlayout = rslayout.getMetaData();
            for (int i = 1; i <= mdlayout.getColumnCount(); ++i) {
                String nomeColuna = mdlayout.getColumnName(i);
                String valor = rslayout.getString(nomeColuna);
                temp.append(StringUtil.getTag(nomeColuna, valor));
            }
            String lay_codigo = rslayout.getString("codigolayout");
            String mco_codigo = rslayout.getString("codigomatcoleta");
            String ela_idadefim = rslayout.getString("idadefimexamelayout");
            String ela_idadeini = rslayout.getString("idadeiniexamelayout");
            String ela_idadefimtipo = rslayout.getString("tipoidadefimexamelayout");
            String ela_idadeinitipo = rslayout.getString("tipoidadeiniexamelayout");
            Statement t = Conexao.getStatement();
            StringBuilder met = new StringBuilder();
            met.append("select met_codigo as codigometodo, elm_formato as formatoexamelayoutmetodo, ");
            met.append("elm_mapa as mapaexamelayoutmetodo, elm_normal as normalexamelayoutmetodo ");
            met.append("from examelayoutmetodo where exa_codigo = '");
            met.append(exa_codigo);
            met.append("' and mco_codigo = ");
            met.append(mco_codigo);
            met.append(" and lay_codigo = ");
            met.append(lay_codigo);
            met.append(" and ela_idadefim = ");
            met.append(DBUtil.bdText(ela_idadefim));
            met.append(" and ela_idadeini = ");
            met.append(DBUtil.bdText(ela_idadeini));
            met.append(" and ela_idadefimtipo = ");
            met.append(DBUtil.bdText(ela_idadefimtipo));
            met.append(" and ela_idadeinitipo = ");
            met.append(DBUtil.bdText(ela_idadeinitipo));
            try (ResultSet elm = null;){
                elm = t.executeQuery(met.toString());
                while (elm != null && elm.next()) {
                    temp.append("<layoutmetodo>");
                    temp.append(StringUtil.getTag("codigometodo", elm.getString("codigometodo")));
                    temp.append(StringUtil.getTag("formatoexamelayoutmetodo", elm.getString("formatoexamelayoutmetodo")));
                    temp.append(StringUtil.getTag("mapaexamelayoutmetodo", elm.getString("mapaexamelayoutmetodo")));
                    temp.append(StringUtil.getTag("normalexamelayoutmetodo", elm.getString("normalexamelayoutmetodo")));
                    temp.append("</layoutmetodo>");
                }
            }
            temp.append("</layout>");
            xml.append((CharSequence)temp);
        }
        xml.append("</layouts>");
        return xml.toString();
    }
}

