/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.exportacao.filial.exames;

import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmPadrao;
import jalis.laboratorio.exportacao.filial.exames.AvisaFinal;
import jalis.laboratorio.exportacao.filial.exames.Exportar;
import jalis.util.CheckItemFiltro;
import jalis.util.Funcoes;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class ExportacaoExames
extends FrmPadrao
implements ActionListener {
    private CheckItemFiltro itemExame = new CheckItemFiltro("Exames", "Filtrar", "Filtrando exames", "fil_codigo = " + Variaveis.filialPadrao);
    private JButton buttonExportar = new JButton("Exportar");
    private JButton buttonNovo = new JButton("Novo");
    private JButton buttonFechar = new JButton("Fechar");
    private JPanel panelBotoes = new JPanel(new FlowLayout(2));
    private JPanel panelFiltro = new JPanel(new GridBagLayout());
    private GridBagConstraints constraints = new GridBagConstraints();
    private JProgressBar progresso = new JProgressBar();
    private JLabel labelTempo = new JLabel("00:00:00");
    private JPanel panelCentro = new JPanel(new GridBagLayout());
    private JTextArea texto = new JTextArea();
    private JScrollPane scroll = new JScrollPane(this.texto);
    private JLabel labelpath = new JLabel("Diret\u00f3rio de exporta\u00e7\u00e3o:");
    private JTextField textpath = new JTextField();
    private JButton pesquisa = new JButton();

    public ExportacaoExames() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
        }
    }

    private void jbInit() throws Exception {
        this.buttonExportar.setMnemonic('E');
        this.buttonFechar.setMnemonic('F');
        this.buttonNovo.setMnemonic('N');
        this.setLayout(new BorderLayout());
        this.add((Component)this.panelBotoes, "South");
        this.add((Component)this.panelFiltro, "West");
        this.add((Component)this.panelCentro, "Center");
        this.panelBotoes.add(this.buttonNovo);
        this.panelBotoes.add(this.buttonFechar);
        Funcoes.criaBarraDescricao(this, "Exportar exames", "Gera a exporta\u00e7\u00e3o dos exames selecionados", "integracao/exportar_exames_xml.jpg");
        this.panelFiltro.setBorder(new TitledBorder("Filtro"));
        this.panelFiltro.setPreferredSize(new Dimension(210, 100));
        this.montaFiltros();
        this.montaCentro();
        this.buttonFechar.addActionListener(this);
        this.buttonNovo.addActionListener(this);
        this.buttonExportar.addActionListener(this);
        this.pesquisa.addActionListener(this);
        Funcoes.imagemPesquisa(this.pesquisa);
        this.pesquisa.setPreferredSize(new Dimension(20, 20));
        this.textpath.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    ExportacaoExames.this.pesquisa.doClick();
                    e.consume();
                }
            }
        });
        this.habilitaFiltro(false);
        this.buttonNovo.grabFocus();
        this.texto.setOpaque(false);
        this.texto.setEditable(false);
        this.labelpath.setDisplayedMnemonic('D');
        this.labelpath.setLabelFor(this.textpath);
        String path = ParametrosLocais.getParametro("xmlExameExportacao");
        if (path != null && !path.trim().equals("")) {
            this.textpath.setText(path);
        }
    }

    private void habilitaFiltro(boolean b) {
        this.itemExame.setEnabled(b);
        this.buttonExportar.setEnabled(b);
        this.labelpath.setEnabled(b);
        this.textpath.setEnabled(b);
        this.pesquisa.setEnabled(b);
        this.buttonNovo.setEnabled(!b);
    }

    private void montaCentro() {
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridx = 0;
        cons.gridy = 0;
        cons.fill = 1;
        cons.anchor = 18;
        cons.weightx = 1.0;
        cons.weighty = 1.0;
        this.panelCentro.add((Component)this.scroll, cons);
        cons.gridy = 1;
        cons.fill = 2;
        cons.anchor = 13;
        cons.weighty = 0.0;
        this.labelTempo.setHorizontalAlignment(4);
        this.panelCentro.add((Component)this.labelTempo, cons);
        cons.gridy = 2;
        this.panelCentro.add((Component)this.progresso, cons);
    }

    private void montaFiltros() {
        this.itemExame.setDados("exames", new String[]{"exa_codigo", "exa_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemExame.setColunaHint(1);
        this.constraints.gridx = 0;
        this.constraints.gridy = 0;
        this.constraints.fill = 2;
        this.constraints.anchor = 17;
        this.constraints.gridwidth = 3;
        this.constraints.weightx = 1.0;
        this.panelFiltro.add((Component)this.itemExame, this.constraints);
        this.constraints.gridy = 1;
        this.constraints.insets = new Insets(5, 5, 2, 3);
        this.panelFiltro.add((Component)this.labelpath, this.constraints);
        this.constraints.gridy = 2;
        this.constraints.insets = new Insets(0, 5, 1, 0);
        this.constraints.gridwidth = 2;
        this.panelFiltro.add((Component)this.textpath, this.constraints);
        this.constraints.gridx = 2;
        this.constraints.insets = new Insets(0, 0, 1, 3);
        this.constraints.gridwidth = 1;
        this.constraints.weightx = 0.0;
        this.panelFiltro.add((Component)this.pesquisa, this.constraints);
        this.constraints.gridx = 0;
        this.constraints.gridy = 3;
        this.constraints.insets = new Insets(0, 5, 0, 3);
        this.constraints.fill = 0;
        this.constraints.anchor = 13;
        this.constraints.gridwidth = 3;
        this.constraints.weightx = 0.0;
        this.buttonExportar.setPreferredSize(new Dimension(100, 20));
        this.buttonExportar.setMinimumSize(new Dimension(100, 20));
        this.panelFiltro.add((Component)this.buttonExportar, this.constraints);
        this.constraints.gridy = 4;
        this.constraints.fill = 1;
        this.constraints.anchor = 17;
        this.constraints.gridwidth = 3;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 1.0;
        this.panelFiltro.add((Component)new JPanel(), this.constraints);
    }

    public static Long getModuloAcesso() {
        return Long.parseLong("0902000300");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonFechar) {
            this.setVisible(false);
        } else if (e.getSource() == this.buttonNovo) {
            this.habilitaFiltro(true);
            this.buttonExportar.grabFocus();
        } else if (e.getSource() == this.buttonExportar) {
            this.buttonExportar.setEnabled(false);
            this.exportaDados();
        } else if (e.getSource() == this.pesquisa) {
            JFileChooser file = ComponenteFactory.novoJFileChooser();
            file.setFileSelectionMode(1);
            int opcao = file.showOpenDialog(this);
            if (opcao == 0) {
                this.textpath.setText(file.getSelectedFile().toString());
            }
        }
    }

    private void exportaDados() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.buttonFechar.setEnabled(false);
        Exportar exportar = new Exportar(this.progresso, this.labelTempo, this.texto, this.textpath);
        if (this.itemExame.isSelected()) {
            exportar.setQtdeExames(this.itemExame.getQtdeRegistros());
            exportar.setSelecaoExame(this.itemExame.getSelecionados(0));
        } else {
            exportar.setQtdeExames(0);
        }
        exportar.addAvisaFinal(new AvisaFinal(){

            @Override
            public void threadParada() {
                ExportacaoExames.this.habilitaFiltro(false);
                ExportacaoExames.this.buttonFechar.setEnabled(true);
            }
        });
        exportar.start();
        this.setCursor(Cursor.getDefaultCursor());
    }
}

