/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.exportacao.filial;

import jalis.comum.Conexao;
import jalis.laboratorio.exportacao.filial.ListenerExportacao;
import jalis.laboratorio.exportacao.filial.TabelaExportacao;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;

class ThreadExportacao
extends Thread {
    ArrayList<ListenerExportacao> listenerExportacao = new ArrayList();
    ArrayList<TabelaExportacao> tabelas = null;
    int filialDestino = -1;
    JProgressBar progress = null;
    JTextArea textArea = null;

    public ThreadExportacao(ListenerExportacao listenerExportacao, ArrayList<TabelaExportacao> tabelas, int filialDestino, JProgressBar progress, JTextArea textArea) {
        super("Thread Exportacao");
        this.setPriority(1);
        this.listenerExportacao.add(listenerExportacao);
        this.tabelas = tabelas;
        this.filialDestino = filialDestino;
        this.progress = progress;
        this.textArea = textArea;
    }

    @Override
    public void run() {
        this.progress.setMaximum(this.tabelas.size());
        this.fireInicioExportacao();
        this.textArea.append("Exporta\u00e7\u00e3o iniciada......");
        for (TabelaExportacao t : this.tabelas) {
            this.fireInicioExportacaoTabela(t);
            this.textArea.append("\nExportando: ");
            this.textArea.append(t.getTitulo());
            this.textArea.append("....");
            try {
                t.exportar(this.filialDestino, this.textArea, this.progress);
                System.gc();
            }
            catch (Exception e) {
                this.fireErroExportacao(e.getMessage());
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                }
                if (e instanceof SQLException) {
                    e.printStackTrace();
                    if (((SQLException)e).getNextException() != null) {
                        ((SQLException)e).getNextException().printStackTrace();
                    }
                } else {
                    e.printStackTrace();
                }
                return;
            }
            this.fireTerminoExportacaoTabela(t);
            this.textArea.append("\nExporta\u00e7\u00e3o realizada com sucesso!");
            try {
                ThreadExportacao.sleep(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.fireTerminoExportacao();
        this.textArea.append("\n\nExporta\u00e7\u00e3o conclu\u00edda com sucesso......");
        try {
            Conexao.arquivaSQL();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void fireInicioExportacaoTabela(TabelaExportacao tabela) {
        for (ListenerExportacao l : this.listenerExportacao) {
            l.inicioExportacaoTabela(tabela);
        }
    }

    private void fireTerminoExportacaoTabela(TabelaExportacao tabela) {
        for (ListenerExportacao l : this.listenerExportacao) {
            l.terminoExportacaoTabela(tabela);
        }
    }

    private void fireInicioExportacao() {
        for (ListenerExportacao l : this.listenerExportacao) {
            l.inicioExportacao();
        }
    }

    private void fireTerminoExportacao() {
        for (ListenerExportacao l : this.listenerExportacao) {
            l.terminoExportacao();
        }
    }

    private void fireErroExportacao(String erro) {
        for (ListenerExportacao l : this.listenerExportacao) {
            l.erroExportacao(erro);
        }
    }
}

