/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.exportacao.filial;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.laboratorio.exportacao.filial.TabelaAgregadaExportacao;
import jalis.util.componentes.ComponenteFactory;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;

class TabelaExportacao {
    protected String tabelaPrincipal;
    protected String titulo;
    protected String[] chavesPrimarias;
    protected String[] camposSelect;
    protected String[] camposExibir;
    protected String[] nomesColunas;
    protected int[] tamanhoColunas;
    protected int colunaOrdenacao;
    protected String[] camposWhere;
    protected JCheckBox checkBox;
    protected boolean dependenciaSelecionada = false;
    protected boolean agregadaSelecionada = false;
    protected boolean exportada = false;
    private TabelaExportacao[] dependencias;
    private TabelaAgregadaExportacao[] agregadas;
    public ArrayList linhasSelecionadas = new ArrayList();
    public ArrayList linhasFiltradas = new ArrayList();
    public ArrayList linhasTemp = new ArrayList();

    public TabelaExportacao(String titulo, String tabelaPrincipal, String[] chavesPrimarias, String[] camposSelect, String[] camposExibir, String[] nomesColunas, int[] tamanhoColunas, int colunaToolTip, int colunaOrdenacao, TabelaExportacao[] dependencias, TabelaAgregadaExportacao[] agregadas) {
        this(titulo, tabelaPrincipal, chavesPrimarias, camposSelect, camposExibir, nomesColunas, tamanhoColunas, colunaToolTip, colunaOrdenacao, dependencias, agregadas, null);
    }

    public TabelaExportacao(String titulo, String tabelaPrincipal, String[] chavesPrimarias, String[] camposSelect, String[] camposExibir, String[] nomesColunas, int[] tamanhoColunas, int colunaToolTip, int colunaOrdenacao, TabelaExportacao[] dependencias, TabelaAgregadaExportacao[] agregadas, String[] camposWhere) {
        this.titulo = titulo;
        this.tabelaPrincipal = tabelaPrincipal;
        this.chavesPrimarias = chavesPrimarias;
        this.camposSelect = camposSelect;
        this.camposExibir = camposExibir;
        this.tamanhoColunas = tamanhoColunas;
        this.colunaOrdenacao = colunaOrdenacao;
        this.checkBox = ComponenteFactory.novoJCheckBox(titulo, null);
        this.dependencias = dependencias;
        this.agregadas = agregadas;
        this.camposWhere = camposWhere;
        if (camposExibir != null && nomesColunas != null) {
            String[] tmp = new String[camposExibir.length + 1];
            for (int i = 0; i < camposExibir.length; ++i) {
                tmp[i] = nomesColunas[i];
            }
            tmp[camposExibir.length] = "Sel.";
            this.nomesColunas = tmp;
        }
    }

    public String getTabelaPrincipal() {
        return this.tabelaPrincipal;
    }

    public String getTitulo() {
        return this.titulo;
    }

    public JCheckBox getCheckBox() {
        return this.checkBox;
    }

    public boolean equals(Object o) {
        TabelaExportacao tabela = (TabelaExportacao)o;
        return tabela.getTabelaPrincipal().equals(this.getTabelaPrincipal());
    }

    public void selecionaDependencias() {
        if (this.dependencias == null || this.dependencias.length == 0) {
            return;
        }
        for (TabelaExportacao t : this.dependencias) {
            if (this.isDependenciaSelecionada()) continue;
            t.selecionar(true);
            t.setDependenciaSelecionada(true);
            if (t.dependencias == null) continue;
            for (TabelaExportacao td : t.dependencias) {
                if (this.isDependenciaSelecionada()) continue;
                td.selecionar(true);
                td.setDependenciaSelecionada(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selecionaDependencias(Object linhaSelecionada) {
        if (this.dependencias == null || this.dependencias.length == 0) {
            return;
        }
        try {
            Object[] l = (Object[])linhaSelecionada;
            for (TabelaExportacao t : this.dependencias) {
                String sql = this.montaSQLDependencia(t);
                PreparedStatement ps = Conexao.getPreparedStatement(sql);
                block6: for (int j = 1; j <= this.chavesPrimarias.length; ++j) {
                    for (int i = 0; i < this.camposSelect.length; ++i) {
                        if (!this.chavesPrimarias[j - 1].equalsIgnoreCase(this.camposSelect[i])) continue;
                        ps.setObject(j, l[i]);
                        continue block6;
                    }
                }
                try (ResultSet rs = null;){
                    rs = ps.executeQuery();
                    System.out.print("->");
                    System.out.println(t.tabelaPrincipal);
                    while (rs.next()) {
                        for (String s : t.chavesPrimarias) {
                            System.out.println(rs.getString(s));
                        }
                    }
                    System.out.println("-----------------------");
                    if (t.dependencias == null) continue;
                    for (TabelaExportacao tabelaExportacao : t.dependencias) {
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void selecionaAgregadas() {
        if (this.agregadas == null || this.agregadas.length == 0) {
            return;
        }
        for (TabelaAgregadaExportacao t : this.agregadas) {
            if (this.isAgregadaSelecionada()) continue;
            t.selecionar(true);
            t.setAgregadaSelecionada(true);
            if (t.getDependencias() == null) continue;
            for (TabelaExportacao td : t.getDependencias()) {
                if (this.isDependenciaSelecionada()) continue;
                td.selecionar(true);
                td.setDependenciaSelecionada(true);
            }
        }
    }

    public TabelaAgregadaExportacao[] getAgregadas() {
        return this.agregadas;
    }

    public TabelaExportacao[] getDependencias() {
        return this.dependencias;
    }

    public void selecionar(boolean valor) {
        this.checkBox.setSelected(valor);
    }

    public boolean isSelecionada() {
        return this.checkBox.isSelected();
    }

    public void setDependenciaSelecionada(boolean valor) {
        this.dependenciaSelecionada = valor;
    }

    public boolean isDependenciaSelecionada() {
        return this.dependenciaSelecionada;
    }

    public void setAgregadaSelecionada(boolean valor) {
        this.agregadaSelecionada = valor;
    }

    public boolean isAgregadaSelecionada() {
        return this.agregadaSelecionada;
    }

    public void setExportada(boolean valor) {
        this.exportada = valor;
    }

    public boolean isExportada() {
        return this.exportada;
    }

    public String[] getNomesColunas() {
        return this.nomesColunas;
    }

    public int[] getTamanhoColunas() {
        return this.tamanhoColunas;
    }

    public String toString() {
        return this.isDependenciaSelecionada() ? this.titulo + " - Depend\u00eancia" : this.titulo;
    }

    public void marcarTodos() {
        this.linhasSelecionadas.clear();
        for (Object o : this.linhasFiltradas) {
            Object[] linhaFiltrada = (Object[])o;
            linhaFiltrada[linhaFiltrada.length - 1] = new Boolean(true);
            this.linhasSelecionadas.add(o);
        }
    }

    public void desmarcarTodos() {
        this.linhasSelecionadas.clear();
        for (Object o : this.linhasFiltradas) {
            Object[] linhaFiltrada = (Object[])o;
            linhaFiltrada[linhaFiltrada.length - 1] = new Boolean(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filtrar() throws Exception {
        String sql = this.montaSQL();
        Statement st = Conexao.getStatement();
        try (ResultSet rs = null;){
            rs = st.executeQuery(sql);
            if (this.linhasFiltradas != null) {
                this.linhasFiltradas.clear();
                while (rs.next()) {
                    Object[] linha = new Object[this.camposExibir.length + 1];
                    for (int i = 0; i < this.camposExibir.length; ++i) {
                        linha[i] = rs.getObject(this.camposExibir[i]);
                    }
                    linha[this.camposExibir.length] = new Boolean(false);
                    this.linhasFiltradas.add(linha);
                }
                for (Object o : this.linhasSelecionadas) {
                    Object[] linhaSelecionada = (Object[])o;
                    for (Object b : this.linhasFiltradas) {
                        Object[] linhaFiltrada = (Object[])b;
                        boolean aux = true;
                        for (int i = 0; i < linhaSelecionada.length - 1; ++i) {
                            if (linhaSelecionada[i] == null || linhaFiltrada[i] == null || !aux || linhaSelecionada[i].equals(linhaFiltrada[i])) continue;
                            aux = false;
                        }
                        if (!aux) continue;
                        linhaFiltrada[linhaFiltrada.length - 1] = new Boolean(true);
                    }
                }
            }
            if (this.agregadas != null && this.agregadas.length > 0) {
                for (TabelaAgregadaExportacao t : this.agregadas) {
                    t.filtrar();
                }
            }
        }
    }

    private String montaSQL() throws Exception {
        StringBuilder sql = new StringBuilder();
        sql.append("select ");
        if (this.camposSelect == null || this.camposSelect.length == 0) {
            throw new Exception("Campos select est\u00e1 vazio");
        }
        for (int i = 0; i < this.camposSelect.length; ++i) {
            if (i > 0) {
                sql.append(", ");
            }
            sql.append(this.camposSelect[i]);
        }
        sql.append(" from ").append(this.tabelaPrincipal);
        sql.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
        if (this.camposWhere != null && this.camposWhere.length > 0) {
            for (String s : this.camposWhere) {
                sql.append(" and ");
                sql.append(s);
            }
        }
        if (this.colunaOrdenacao >= 0) {
            sql.append(" order by ");
            sql.append(this.camposSelect[this.colunaOrdenacao]);
        }
        return sql.toString();
    }

    private String montaSQLDependencia(TabelaExportacao dependencia) throws Exception {
        StringBuilder sql = new StringBuilder();
        sql.append("select ");
        if (this.camposSelect == null || this.camposSelect.length == 0) {
            throw new Exception("Campos select est\u00e1 vazio");
        }
        if (dependencia.chavesPrimarias != null && dependencia.chavesPrimarias.length > 0) {
            for (String s : dependencia.chavesPrimarias) {
                sql.append(s);
            }
        }
        sql.append(" from ").append(this.tabelaPrincipal);
        sql.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
        if (this.camposWhere != null && this.camposWhere.length > 0) {
            for (String s : this.camposWhere) {
                sql.append(" and ");
                sql.append(s);
            }
        }
        if (this.chavesPrimarias != null && this.chavesPrimarias.length > 0) {
            for (String s : this.chavesPrimarias) {
                sql.append(" and ");
                sql.append(s);
                sql.append(" =  ?");
            }
        }
        if (this.colunaOrdenacao >= 0) {
            sql.append(" order by ");
            sql.append(this.camposSelect[this.colunaOrdenacao]);
        }
        return sql.toString();
    }

    protected boolean linhaJaSelecionada(Object[] linha) {
        boolean[] linhaRet = new boolean[this.chavesPrimarias.length];
        for (Object o : this.linhasTemp) {
            int i;
            Object[] linhaOld = (Object[])o;
            block1: for (int j = 1; j <= this.chavesPrimarias.length; ++j) {
                for (i = 0; i < this.camposSelect.length; ++i) {
                    if (!this.chavesPrimarias[j - 1].equalsIgnoreCase(this.camposSelect[i])) continue;
                    if (linhaOld[i] == null && linha[i] == null) {
                        linhaRet[j - 1] = true;
                        continue block1;
                    }
                    if (linhaOld[i] == null && linha[i] != null) {
                        linhaRet[j - 1] = false;
                        continue block1;
                    }
                    linhaRet[j - 1] = linhaOld[i].equals(linha[i]);
                    continue block1;
                }
            }
            boolean aux = true;
            for (i = 0; i < linhaRet.length; ++i) {
                if (linhaRet[i]) continue;
                aux = false;
            }
            if (!aux) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportar(int filialDestino, JTextArea textArea, JProgressBar progress) throws Exception {
        if (this.isExportada()) {
            progress.setValue(progress.getValue() + 1);
            return;
        }
        if (this.linhasFiltradas != null) {
            this.linhasFiltradas.clear();
        }
        this.linhasFiltradas = null;
        this.linhasTemp.clear();
        if (this.linhasSelecionadas == null || this.linhasSelecionadas.size() == 0) {
            return;
        }
        ResultSetMetaData rsmd = null;
        StringBuilder sqlSelect = new StringBuilder();
        sqlSelect.append("select * from ").append(this.tabelaPrincipal).append(" where fil_codigo = ? ");
        if (this.camposWhere != null && this.camposWhere.length > 0) {
            for (String s : this.camposWhere) {
                sqlSelect.append(" and ");
                sqlSelect.append(s);
            }
        }
        for (String s : this.chavesPrimarias) {
            sqlSelect.append(" and ").append(s).append(" = ? ");
        }
        PreparedStatement psSelectOrigem = Conexao.getPreparedStatement(sqlSelect.toString());
        PreparedStatement psSelectDestino = Conexao.getPreparedStatement(sqlSelect.toString());
        Statement ps1 = null;
        boolean temInsert = false;
        psSelectOrigem.setInt(1, Integer.parseInt(Variaveis.filialPadrao));
        psSelectDestino.setInt(1, filialDestino);
        int cont = 0;
        for (Object o : this.linhasSelecionadas) {
            Object[] linha = (Object[])o;
            if (this.linhaJaSelecionada(linha)) continue;
            block9: for (int j = 1; j <= this.chavesPrimarias.length; ++j) {
                for (int i = 0; i < this.camposSelect.length; ++i) {
                    if (!this.chavesPrimarias[j - 1].equalsIgnoreCase(this.camposSelect[i])) continue;
                    psSelectOrigem.setObject(j + 1, linha[i]);
                    psSelectDestino.setObject(j + 1, linha[i]);
                    continue block9;
                }
            }
            ResultSet rs = null;
            try {
                rs = psSelectDestino.executeQuery();
                if (rs.next()) {
                    continue;
                }
            }
            finally {
                if (rs == null) continue;
                rs.close();
                continue;
            }
            try {
                rs = psSelectOrigem.executeQuery();
                if (rsmd == null) {
                    rsmd = rs.getMetaData();
                    StringBuilder sqlInsert = new StringBuilder();
                    StringBuilder sqlValues = new StringBuilder();
                    sqlInsert.append("insert into ").append(this.tabelaPrincipal).append(" (");
                    sqlValues.append(" ) values (");
                    for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
                        if (i > 1) {
                            sqlInsert.append(", ");
                            sqlValues.append(", ");
                        }
                        sqlInsert.append(rsmd.getColumnName(i));
                        sqlValues.append(" ?");
                    }
                    sqlInsert.append(sqlValues.toString()).append(")");
                    ps1 = Conexao.getPreparedStatement(sqlInsert.toString());
                }
                while (rs.next()) {
                    for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
                        if (rsmd.getColumnName(i).equalsIgnoreCase("fil_codigo")) {
                            ps1.setObject(i, filialDestino);
                            continue;
                        }
                        if (rs.getObject(i) instanceof String) {
                            ps1.setString(i, rs.getString(i));
                            continue;
                        }
                        ps1.setObject(i, rs.getObject(i));
                    }
                    ps1.addBatch();
                    ps1.clearParameters();
                    temInsert = true;
                    ++cont;
                }
                if (cont >= 1000) {
                    if (temInsert) {
                        ps1.executeBatch();
                        ps1.clearBatch();
                    }
                    cont = 0;
                }
                this.linhasTemp.add(o);
            }
            finally {
                if (rs == null) continue;
                rs.close();
            }
        }
        if (temInsert) {
            ps1.executeBatch();
        }
        Conexao.arquivaSQL();
        if (this.agregadas != null && this.agregadas.length > 0) {
            for (TabelaAgregadaExportacao tab : this.agregadas) {
                textArea.append("\n\tExportando: ");
                textArea.append(tab.getTitulo());
                textArea.append("....");
                tab.exportarAgregada(this, filialDestino);
                textArea.append("Exporta\u00e7\u00e3o realizada com sucesso!");
            }
        }
        this.linhasTemp.clear();
        this.linhasTemp = null;
        this.linhasSelecionadas.clear();
        this.linhasSelecionadas = null;
        this.setExportada(true);
        progress.setValue(progress.getValue() + 1);
    }
}

