/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.exportacao.filial;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.laboratorio.exportacao.filial.TabelaExportacao;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;

class TabelaAgregadaExportacao
extends TabelaExportacao {
    private String[] chavesDestinos;

    public TabelaAgregadaExportacao(String titulo, String tabelaPrincipal, String[] chavesPrimarias, String[] chavesDestinos, String[] camposSelect, String[] camposWhere) {
        super(titulo, tabelaPrincipal, chavesPrimarias, camposSelect, camposSelect, null, null, -1, -1, null, null, camposWhere);
        this.chavesDestinos = chavesDestinos;
    }

    public TabelaAgregadaExportacao(String titulo, String tabelaPrincipal, String[] chavesPrimarias, String[] chavesDestinos, String[] camposSelect) {
        this(titulo, tabelaPrincipal, chavesPrimarias, chavesDestinos, camposSelect, null);
    }

    public void setChavesDestinos(String[] chavesDestinos) {
        this.chavesDestinos = chavesDestinos;
    }

    public String[] getChavesDestinos() {
        return this.chavesDestinos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportarAgregada(TabelaExportacao tabela, int filialDestino) throws Exception {
        if (this.isExportada()) {
            return;
        }
        this.linhasTemp.clear();
        ResultSetMetaData rsmd = null;
        StringBuilder sqlSelect = new StringBuilder();
        sqlSelect.append("select * from ").append(this.tabelaPrincipal).append(" where fil_codigo = ? ");
        if (this.camposWhere != null && this.camposWhere.length > 0) {
            for (String s : this.camposWhere) {
                sqlSelect.append(" and ");
                sqlSelect.append(s);
            }
        }
        for (String s : this.chavesDestinos) {
            sqlSelect.append(" and ").append(s).append(" = ? ");
        }
        PreparedStatement psSelectOrigem = Conexao.getPreparedStatement(sqlSelect.toString());
        PreparedStatement psSelectDestino = Conexao.getPreparedStatement(sqlSelect.toString());
        Statement ps1 = null;
        boolean temInsert = false;
        psSelectOrigem.setInt(1, Integer.parseInt(Variaveis.filialPadrao));
        psSelectDestino.setInt(1, filialDestino);
        int cont = 0;
        for (Object o : tabela.linhasSelecionadas) {
            Object[] linha = (Object[])o;
            for (String chaveDestino : this.chavesDestinos) {
                block10: for (int i = 0; i < tabela.chavesPrimarias.length; ++i) {
                    if (!chaveDestino.equalsIgnoreCase(tabela.chavesPrimarias[i])) continue;
                    for (int j = 0; j < tabela.camposSelect.length; ++j) {
                        if (!tabela.chavesPrimarias[i].equalsIgnoreCase(tabela.camposSelect[j])) continue;
                        psSelectOrigem.setObject(i + 2, linha[j]);
                        psSelectDestino.setObject(i + 2, linha[j]);
                        continue block10;
                    }
                }
            }
            ResultSet rs = null;
            try {
                rs = psSelectDestino.executeQuery();
                if (rs.next()) {
                    continue;
                }
            }
            finally {
                if (rs == null) continue;
                rs.close();
                continue;
            }
            try {
                rs = psSelectOrigem.executeQuery();
                if (rsmd == null) {
                    rsmd = rs.getMetaData();
                    StringBuilder sqlInsert = new StringBuilder();
                    StringBuilder sqlValues = new StringBuilder();
                    sqlInsert.append("insert into ").append(this.tabelaPrincipal).append(" (");
                    sqlValues.append(" ) values (");
                    for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
                        if (i > 1) {
                            sqlInsert.append(", ");
                            sqlValues.append(", ");
                        }
                        sqlInsert.append(rsmd.getColumnName(i));
                        sqlValues.append(" ?");
                    }
                    sqlInsert.append(sqlValues.toString()).append(")");
                    ps1 = Conexao.getPreparedStatement(sqlInsert.toString());
                }
                while (rs.next()) {
                    for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
                        if (rsmd.getColumnName(i).equalsIgnoreCase("fil_codigo")) {
                            ps1.setObject(i, filialDestino);
                            continue;
                        }
                        if (rs.getObject(i) instanceof String) {
                            ps1.setString(i, rs.getString(i));
                            continue;
                        }
                        ps1.setObject(i, rs.getObject(i));
                    }
                    ps1.addBatch();
                    ps1.clearParameters();
                    temInsert = true;
                    ++cont;
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
            if (cont >= 1000) {
                if (temInsert) {
                    ps1.executeBatch();
                    ps1.clearBatch();
                }
                cont = 0;
            }
            this.linhasTemp.add(o);
        }
        if (temInsert) {
            ps1.executeBatch();
        }
        Conexao.arquivaSQL();
        this.linhasTemp.clear();
        this.linhasTemp = null;
        this.setExportada(true);
    }
}

