/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.exportacao.filial;

import jalis.laboratorio.exportacao.filial.TabelaExportacao;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

class JCheckBoxList
extends JList {
    Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

    public JCheckBoxList() {
        this.setCellRenderer(new CheckBoxListCellRenderer());
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int index = JCheckBoxList.this.locationToIndex(e.getPoint());
                JCheckBoxList.this.marcarTabela(index);
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 32) {
                    JCheckBoxList.this.marcarTabela(JCheckBoxList.this.getSelectedIndex());
                }
            }
        });
    }

    public void marcarTabela(int index) {
        if (index != -1) {
            TabelaExportacao tabela;
            tabela.selecionar(!(tabela = (TabelaExportacao)this.getModel().getElementAt(index)).isSelecionada());
            if (tabela.isSelecionada()) {
                tabela.selecionaDependencias();
                tabela.selecionaAgregadas();
            }
            this.repaint();
        }
    }

    class CheckBoxListCellRenderer
    extends JCheckBox
    implements ListCellRenderer {
        public CheckBoxListCellRenderer() {
            this.setBackground(UIManager.getColor("List.textBackground"));
            this.setForeground(UIManager.getColor("List.textForeground"));
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            TabelaExportacao tabela = (TabelaExportacao)value;
            JCheckBox checkbox = tabela.getCheckBox();
            checkbox.setBackground(isSelected ? JCheckBoxList.this.getSelectionBackground() : this.getBackground());
            checkbox.setForeground(isSelected ? JCheckBoxList.this.getSelectionForeground() : this.getForeground());
            checkbox.setBorder(isSelected ? UIManager.getBorder("List.focusCellHighlightBorder") : JCheckBoxList.this.noFocusBorder);
            return checkbox;
        }
    }
}

