/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.exportacao.filial;

import jalis.comum.Pesquisas;
import jalis.comum.padroes.FrmPadrao;
import jalis.laboratorio.exportacao.filial.JCheckBoxList;
import jalis.laboratorio.exportacao.filial.ListenerExportacao;
import jalis.laboratorio.exportacao.filial.TabelaAgregadaExportacao;
import jalis.laboratorio.exportacao.filial.TabelaExportacao;
import jalis.laboratorio.exportacao.filial.ThreadExportacao;
import jalis.util.Funcoes;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableRowSorter;

public class ExportacaoFiliais_Remover
extends FrmPadrao
implements ActionListener,
ListSelectionListener,
ListenerExportacao {
    private JButton buttonFechar = ComponenteFactory.novoJButton("Fechar", 'F', this, null, null, true);
    private JButton buttonProximo = ComponenteFactory.novoJButton("Pr\u00f3ximo", 'P', this, null, null, true);
    private JButton buttonAnterior = ComponenteFactory.novoJButton("Anterior", 'A', this, null, null, true);
    private JButton buttonNovo = ComponenteFactory.novoJButton("Novo", 'N', this, null, null, true);
    private JPanel panelCentral = new JPanel(new CardLayout());
    private JPanel panelBotoes = new JPanel(new FlowLayout(2));
    private JPanel panelRodape = new JPanel(new BorderLayout());
    private JCheckBoxList listCheckBox = new JCheckBoxList();
    private JScrollPane scrollList = new JScrollPane(this.listCheckBox);
    private JPanel panelList = new JPanel(new BorderLayout());
    private JPanel panelListBotoes = new JPanel(new FlowLayout(0));
    private JButton buttonTodasTabelas = ComponenteFactory.novoJButton("Selecionar Todas", 'S', this, null, null, true);
    private JPanel panelCentralFiltro = new JPanel(new BorderLayout());
    private JPanel panelTabelas = new JPanel(new BorderLayout());
    private JList listTabelas = new JList();
    private JScrollPane scrollTabelas = new JScrollPane(this.listTabelas);
    private JPanel panelFiltro = new JPanel(new BorderLayout());
    private JTable tableFiltro = new JTable();
    private DefaultTableModel model = null;
    private JScrollPane scrollFiltro = new JScrollPane(this.tableFiltro);
    private JPanel panelFiltroBotoes = new JPanel(new FlowLayout(2));
    private JButton buttonFiltroTodos = new JButton("Todos");
    private JButton buttonFiltroNenhum = new JButton("Nenhum");
    private JPanel panelFiltroTabelasBotoes = new JPanel(new FlowLayout(0));
    private JButton buttonTodasTabelasFiltro = ComponenteFactory.novoJButton("Selecionar Todas", 'S', this, null, null, true);
    private ArrayList listaTabelas = new ArrayList();
    private ArrayList listaTabelasSelecionada = new ArrayList();
    private JPanel panelExportacao = new JPanel(new GridBagLayout());
    private JLabel labelFilial = new JLabel("Filial Destino");
    private TTextField textFilial = ComponenteFactory.novoTTextField(5, 1);
    private JButton buttonFilial = new JButton();
    private JButton buttonExportar = ComponenteFactory.novoJButton("Exportar", 'E', this, null, null, true);
    private JProgressBar progressExportacao = new JProgressBar();
    private JTextArea textExportacao = new JTextArea();
    private JScrollPane scrollExportacao = new JScrollPane(this.textExportacao);
    private int abaSelecionada = 0;
    TabelaExportacao tabCidade = new TabelaExportacao("Cidade", "cidades", new String[]{"cid_codigo"}, new String[]{"cid_codigo", "cid_nome", "cid_uf"}, new String[]{"cid_codigo", "cid_nome", "cid_uf"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o", "UF"}, new int[]{70, 0, 50}, 1, 1, null, null);
    TabelaExportacao tabBairro = new TabelaExportacao("Bairro", "bairro", new String[]{"bai_codigo"}, new String[]{"bai_codigo", "bai_descricao"}, new String[]{"bai_codigo", "bai_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0}, 1, 1, null, null);
    TabelaExportacao tabDestino = new TabelaExportacao("Destino", "destino", new String[]{"des_codigo"}, new String[]{"des_codigo", "des_descricao"}, new String[]{"des_codigo", "des_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0}, 1, 1, new TabelaExportacao[]{this.tabCidade, this.tabBairro}, null);
    TabelaExportacao tabColeta = new TabelaExportacao("Coleta", "coletas", new String[]{"col_codigo"}, new String[]{"col_codigo", "col_descricao"}, new String[]{"col_codigo", "col_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0}, 1, 1, new TabelaExportacao[]{this.tabCidade, this.tabBairro}, null);
    TabelaExportacao tabAla = new TabelaExportacao("Ala", "alahospital", new String[]{"ala_codigo"}, new String[]{"ala_codigo", "ala_descricao"}, new String[]{"ala_codigo", "ala_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0}, 1, 1, null, null);
    TabelaExportacao tabFeriado = new TabelaExportacao("Feriado", "feriados", new String[]{"fer_dia"}, new String[]{"fer_dia", "fer_motivo"}, new String[]{"fer_dia", "fer_motivo"}, new String[]{"Data", "Motivo"}, new int[]{100, 0}, 1, 1, null, null);
    TabelaExportacao tabSituacao = new TabelaExportacao("Situa\u00e7\u00e3o", "situacao", new String[]{"sit_codigo"}, new String[]{"sit_codigo", "sit_descricao"}, new String[]{"sit_codigo", "sit_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0}, 1, 1, null, null);
    TabelaExportacao tabSetor = new TabelaExportacao("Setor", "setores", new String[]{"set_codigo"}, new String[]{"set_codigo", "set_descricao"}, new String[]{"set_codigo", "set_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0}, 1, 1, null, null);
    TabelaExportacao tabMetodologia = new TabelaExportacao("Metodologia", "metodologia", new String[]{"met_codigo"}, new String[]{"met_codigo", "met_descricao"}, new String[]{"met_codigo", "met_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0}, 1, 1, null, null);
    TabelaExportacao tabMaterialColetado = new TabelaExportacao("Mat. Coletado", "materialcoleta", new String[]{"mco_codigo"}, new String[]{"mco_codigo", "mco_descricao"}, new String[]{"mco_codigo", "mco_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0}, 1, 1, null, null);
    TabelaExportacao tabHistorico = new TabelaExportacao("Hist\u00f3rico", "historicos", new String[]{"his_codigo"}, new String[]{"his_codigo", "his_descricao"}, new String[]{"his_codigo", "his_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0}, 1, 1, null, null);
    TabelaExportacao tabEspecialidade = new TabelaExportacao("Especialidade", "especialidades", new String[]{"esp_codigo"}, new String[]{"esp_codigo", "esp_descricao"}, new String[]{"esp_codigo", "esp_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0}, 1, 1, null, null);
    TabelaExportacao tabPrioridade = new TabelaExportacao("Prioridade", "prioridade", new String[]{"pri_codigo"}, new String[]{"pri_codigo", "pri_descricao"}, new String[]{"pri_codigo", "pri_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0}, 1, 1, null, null);
    TabelaAgregadaExportacao tabTabelaPrecoPorte = new TabelaAgregadaExportacao("Tabela Pre\u00e7o Exames -Porte", "tabelaprecoexamesporte", new String[]{"tpe_codigo", "tpp_porte"}, new String[]{"tpe_codigo"}, new String[]{"tpe_codigo", "tpp_porte"});
    TabelaExportacao tabTabelaPreco = new TabelaExportacao("Tabela de Pre\u00e7os", "tabelaprecoexames", new String[]{"tpe_codigo"}, new String[]{"tpe_codigo", "tpe_descricao"}, new String[]{"tpe_codigo", "tpe_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0}, 1, 1, null, new TabelaAgregadaExportacao[]{this.tabTabelaPrecoPorte});
    TabelaExportacao tabLayout = new TabelaExportacao("Layout", "layout", new String[]{"lay_codigo"}, new String[]{"lay_codigo", "lay_descricao"}, new String[]{"lay_codigo", "lay_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0}, 1, 1, null, null);
    TabelaAgregadaExportacao tabConvenioVencimento = new TabelaAgregadaExportacao("Conv\u00eanios - Vencimento", "conveniosvencimento", new String[]{"con_codigo", "cpv_diavenc"}, new String[]{"con_codigo"}, new String[]{"con_codigo", "cpv_diavenc"});
    TabelaAgregadaExportacao tabConvenioDesconto = new TabelaAgregadaExportacao("Conv\u00eanios - Desconto", "conveniodesconto", new String[]{"con_codigo", "cde_desconto", "tpu_codigo"}, new String[]{"con_codigo"}, new String[]{"con_codigo", "cde_desconto", "tpu_codigo"});
    TabelaAgregadaExportacao tabDespCobranca = new TabelaAgregadaExportacao("Conv\u00eanios - Despesas Cobran\u00e7a", "despcobranca", new String[]{"con_codigo", "dco_codigo"}, new String[]{"con_codigo"}, new String[]{"con_codigo", "dco_codigo"});
    TabelaAgregadaExportacao tabAdicionalFatura = new TabelaAgregadaExportacao("Conv\u00eanios - Adicional Fatura", "adicionalfatura", new String[]{"con_codigo", "adc_codigo"}, new String[]{"con_codigo"}, new String[]{"con_codigo", "adc_codigo"});
    TabelaAgregadaExportacao tabDestinoConvLayout = new TabelaAgregadaExportacao("Conv\u00eanios - Destino Layout", "destinoconvlayout", new String[]{"con_codigo", "lay_codigo", "des_codigo"}, new String[]{"con_codigo"}, new String[]{"con_codigo", "lay_codigo", "des_codigo"});
    TabelaExportacao tabConvenio = new TabelaExportacao("Conv\u00eanio", "convenios", new String[]{"con_codigo"}, new String[]{"con_codigo", "con_fantasia"}, new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0}, 1, 1, new TabelaExportacao[]{this.tabPrioridade, this.tabDestino, this.tabColeta, this.tabTabelaPreco, this.tabLayout, this.tabCidade, this.tabBairro}, new TabelaAgregadaExportacao[]{this.tabConvenioVencimento, this.tabConvenioDesconto, this.tabDespCobranca, this.tabAdicionalFatura, this.tabDestinoConvLayout});
    TabelaAgregadaExportacao tabMedicoConvenio = new TabelaAgregadaExportacao("M\u00e9dico - Conv\u00eanios", "medicoconvenio", new String[]{"med_conselho", "med_crm", "med_uf"}, new String[]{"med_conselho", "med_crm", "med_uf"}, new String[]{"med_conselho", "med_crm", "med_uf", "con_codigo"});
    TabelaAgregadaExportacao tabMedicoEspecialidades = new TabelaAgregadaExportacao("M\u00e9dico - Especialidades", "medicoespecialidades", new String[]{"med_conselho", "med_crm", "med_uf"}, new String[]{"med_conselho", "med_crm", "med_uf"}, new String[]{"med_conselho", "med_crm", "med_uf", "esp_codigo"});
    TabelaAgregadaExportacao tabMedicoConvenioTiss = new TabelaAgregadaExportacao("M\u00e9dico - Conv\u00eanio TISS", "medicoconveniotiss", new String[]{"med_conselho", "med_crm", "med_uf"}, new String[]{"med_conselho", "med_crm", "med_uf"}, new String[]{"med_conselho", "med_crm", "med_uf", "con_codigo"});
    TabelaAgregadaExportacao tabMedicoDestino = new TabelaAgregadaExportacao("M\u00e9dico - Destino", "medicodestino", new String[]{"med_conselho", "med_crm", "med_uf"}, new String[]{"med_conselho", "med_crm", "med_uf"}, new String[]{"med_conselho", "med_crm", "med_uf", "des_codigo"});
    TabelaAgregadaExportacao tabMedicoConvenioProibido = new TabelaAgregadaExportacao("M\u00e9dico - Conv\u00eanio Proibido", "medicoconvenioproibido", new String[]{"med_conselho", "med_crm", "med_uf", "con_codigo"}, new String[]{"med_conselho", "med_crm", "med_uf"}, new String[]{"med_conselho", "med_crm", "med_uf", "con_codigo"});
    TabelaAgregadaExportacao tabMedicoExameWeb = new TabelaAgregadaExportacao("M\u00e9dico - Exame WEB", "medicoexameweb", new String[]{"med_conselho", "med_crm", "med_uf", "exa_codigo"}, new String[]{"med_conselho", "med_crm", "med_uf"}, new String[]{"med_conselho", "med_crm", "med_uf", "exa_codigo"});
    TabelaExportacao tabMedico = new TabelaExportacao("M\u00e9dico", "medico", new String[]{"med_conselho", "med_crm", "med_uf"}, new String[]{"med_conselho", "med_crm", "med_uf", "med_nome"}, new String[]{"med_conselho", "med_crm", "med_uf", "med_nome"}, new String[]{"Cons.", "C\u00f3digo", "Estado", "Nome"}, new int[]{70, 70, 70, 0}, 1, 1, new TabelaExportacao[]{this.tabCidade, this.tabBairro, this.tabConvenio, this.tabEspecialidade}, new TabelaAgregadaExportacao[]{this.tabMedicoConvenio, this.tabMedicoEspecialidades, this.tabMedicoConvenioTiss, this.tabMedicoConvenioProibido, this.tabMedicoExameWeb});
    TabelaExportacao tabGrupo = new TabelaExportacao("Grupo", "grupo", new String[]{"grp_codigo"}, new String[]{"grp_codigo", "grp_descricao"}, new String[]{"grp_codigo", "grp_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0}, 1, 1, null, null);
    TabelaExportacao tabPrazoEntrega = new TabelaExportacao("Prazo de Entrega", "prazoentrega", new String[]{"prz_codigo"}, new String[]{"prz_codigo", "prz_descricao"}, new String[]{"prz_codigo", "prz_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0}, 1, 1, null, null);
    TabelaExportacao tabInterface = new TabelaExportacao("Interface", "interface", new String[]{"int_codigo"}, new String[]{"int_codigo", "int_descricao"}, new String[]{"int_codigo", "int_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0}, 1, 1, new TabelaExportacao[]{this.tabSetor}, null);
    TabelaExportacao tabTipoMaterial = new TabelaExportacao("Tipo de Material", "tipomaterial", new String[]{"tpm_codigo"}, new String[]{"tpm_codigo", "tpm_descricao"}, new String[]{"tpm_codigo", "tpm_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0}, 1, 1, null, null);
    TabelaAgregadaExportacao tabConversaoUnidade = new TabelaAgregadaExportacao("Unidade de Medida - Convers\u00e3o", "conversaounidade", new String[]{"unm_codigo", "unm_coddestino"}, new String[]{"unm_codigo"}, new String[]{"unm_codigo", "unm_coddestino"});
    TabelaExportacao tabUnidadeMedida = new TabelaExportacao("Unidade de Medida", "unidademedida", new String[]{"unm_codigo"}, new String[]{"unm_codigo", "unm_descricao"}, new String[]{"unm_codigo", "unm_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0}, 1, 1, null, new TabelaAgregadaExportacao[]{this.tabConversaoUnidade});
    TabelaExportacao tabMaterial = new TabelaExportacao("Material", "material", new String[]{"mat_codigo"}, new String[]{"mat_codigo", "mat_descricao"}, new String[]{"mat_codigo", "mat_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0}, 1, 1, new TabelaExportacao[]{this.tabTipoMaterial, this.tabUnidadeMedida}, null);
    TabelaExportacao tabPrincipioAtivo = new TabelaExportacao("Princ\u00edpio Ativo", "principios", new String[]{"prc_codigo"}, new String[]{"prc_codigo", "prc_descricao"}, new String[]{"prc_codigo", "prc_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0}, 1, 1, null, null);
    TabelaAgregadaExportacao tabRecipMaterial = new TabelaAgregadaExportacao("Recipiente - Material", "recipmaterial", new String[]{"rec_codigo", "mat_codigo"}, new String[]{"rec_codigo"}, new String[]{"rec_codigo", "mat_codigo"});
    TabelaExportacao tabRecipiente = new TabelaExportacao("Recipiente", "recipientes", new String[]{"rec_codigo"}, new String[]{"rec_codigo", "rec_descricao"}, new String[]{"rec_codigo", "rec_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0}, 1, 1, new TabelaExportacao[]{this.tabUnidadeMedida, this.tabMaterial}, new TabelaAgregadaExportacao[]{this.tabRecipMaterial});
    TabelaAgregadaExportacao tabExameSetor = new TabelaAgregadaExportacao("Exame - Setor", "examesetor", new String[]{"exa_codigo", "set_codigo"}, new String[]{"exa_codigo"}, new String[]{"exa_codigo", "set_codigo"});
    TabelaAgregadaExportacao tabExameHistorico = new TabelaAgregadaExportacao("Exame - Historico", "examehistorico", new String[]{"exa_codigo", "his_codigo"}, new String[]{"exa_codigo"}, new String[]{"exa_codigo", "his_codigo"});
    TabelaAgregadaExportacao tabExameGrupo = new TabelaAgregadaExportacao("Exame - Grupo", "examegrupo", new String[]{"exa_codigo", "grp_codigo"}, new String[]{"exa_codigo"}, new String[]{"exa_codigo", "grp_codigo"});
    TabelaAgregadaExportacao tabRecipColeta = new TabelaAgregadaExportacao("Exame - Recipiente Coleta", "recipcoleta", new String[]{"rec_codigo", "exa_codigo", "mco_codigo"}, new String[]{"exa_codigo"}, new String[]{"rec_codigo", "exa_codigo", "mco_codigo"});
    TabelaAgregadaExportacao tabRecipTriagem = new TabelaAgregadaExportacao("Exame - Recipiente Triagem", "reciptriagem", new String[]{"rec_codigo", "exa_codigo", "mco_codigo"}, new String[]{"exa_codigo"}, new String[]{"rec_codigo", "exa_codigo", "mco_codigo"});
    TabelaAgregadaExportacao tabMaterialExame = new TabelaAgregadaExportacao("Exame - Material Exame", "materialexame", new String[]{"exa_codigo", "mco_codigo", "mat_codigo"}, new String[]{"exa_codigo"}, new String[]{"exa_codigo", "mco_codigo", "mat_codigo"});
    TabelaAgregadaExportacao tabExameLayout = new TabelaAgregadaExportacao("Exame - Layout", "examelayout", new String[]{"exa_codigo", "lay_codigo", "mco_codigo", "ela_idadeini", "ela_idadefim", "ela_idadeinitipo", "ela_idadefimtipo"}, new String[]{"exa_codigo"}, new String[]{"exa_codigo", "lay_codigo", "mco_codigo", "ela_idadeini", "ela_idadefim", "ela_idadeinitipo", "ela_idadefimtipo"});
    TabelaAgregadaExportacao tabExamesPrincipios = new TabelaAgregadaExportacao("Exame - Princ\u00edpios", "examesprincipios", new String[]{"exa_codigo", "mco_codigo", "prc_codigo"}, new String[]{"exa_codigo"}, new String[]{"exa_codigo", "mco_codigo", "prc_codigo"});
    TabelaAgregadaExportacao tabExamesMatConvenio = new TabelaAgregadaExportacao("Exame - Material Conv\u00eanio", "examesmatconvenio", new String[]{"exa_codigo", "mco_codigo", "con_codigo"}, new String[]{"exa_codigo"}, new String[]{"exa_codigo", "mco_codigo", "con_codigo"});
    TabelaAgregadaExportacao tabExameMatInterface = new TabelaAgregadaExportacao("Exame - Material Interface", "examematinterface", new String[]{"exa_codigo", "mco_codigo", "int_codigo"}, new String[]{"exa_codigo"}, new String[]{"exa_codigo", "mco_codigo", "int_codigo"});
    TabelaAgregadaExportacao tabExameMatIntDesmembrar = new TabelaAgregadaExportacao("Exame - Material Interface Desmembrar", "examematintdesmembrar", new String[]{"exa_codigo", "mco_codigo", "int_codigo", "exa_kodigo", "mco_kodigo"}, new String[]{"exa_codigo"}, new String[]{"exa_codigo", "mco_codigo", "int_codigo", "exa_kodigo", "mco_kodigo"});
    TabelaAgregadaExportacao tabExameMatConvenioPrazo = new TabelaAgregadaExportacao("Exame - Conv\u00eanio Prazo", "examematconvenioprazo", new String[]{"exa_codigo", "mco_codigo", "con_codigo", "prz_codigo"}, new String[]{"exa_codigo"}, new String[]{"exa_codigo", "mco_codigo", "con_codigo", "prz_codigo"});
    TabelaAgregadaExportacao tabDetalheTabelaPreco = new TabelaAgregadaExportacao("Tabela Pre\u00e7o Exames - Detalhe", "detalhetabelapreco", new String[]{"exa_codigo", "mco_codigo", "tpe_codigo"}, new String[]{"exa_codigo"}, new String[]{"exa_codigo", "mco_codigo", "tpe_codigo"});
    TabelaAgregadaExportacao tabExameMatColeta = new TabelaAgregadaExportacao("Exame - Material Coleta", "examematcoleta", new String[]{"exa_codigo", "mco_codigo"}, new String[]{"exa_codigo"}, new String[]{"exa_codigo", "mco_codigo"});
    TabelaExportacao tabExame = new TabelaExportacao("Exame", "exames", new String[]{"exa_codigo"}, new String[]{"exa_codigo", "exa_descricao"}, new String[]{"exa_codigo", "exa_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0}, 1, 1, new TabelaExportacao[]{this.tabSetor, this.tabHistorico, this.tabGrupo, this.tabMaterialColetado, this.tabMaterial, this.tabLayout, this.tabPrincipioAtivo, this.tabInterface, this.tabPrazoEntrega, this.tabRecipiente, this.tabMetodologia, this.tabTabelaPreco}, new TabelaAgregadaExportacao[]{this.tabExameMatColeta, this.tabExameSetor, this.tabExameHistorico, this.tabExameGrupo, this.tabRecipColeta, this.tabRecipTriagem, this.tabDetalheTabelaPreco, this.tabExamesPrincipios, this.tabExamesMatConvenio, this.tabExameMatInterface, this.tabExameMatIntDesmembrar, this.tabExameMatConvenioPrazo});
    TabelaExportacao tabLaboratorioExterno = new TabelaExportacao("Lab. Externo", "labexterno", new String[]{"lae_codigo"}, new String[]{"lae_codigo", "lae_descricao"}, new String[]{"lae_codigo", "lae_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0}, 1, 1, null, null);
    TabelaExportacao tabBanco = new TabelaExportacao("Banco", "banco", new String[]{"bac_codigo"}, new String[]{"bac_codigo", "bac_descricao"}, new String[]{"bac_codigo", "bac_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0}, 1, 1, null, null);
    TabelaExportacao tabAgencia = new TabelaExportacao("Ag\u00eancia", "agencia", new String[]{"age_codigo", "bac_codigo"}, new String[]{"age_codigo", "bac_codigo", "age_descricao"}, new String[]{"age_codigo", "bac_codigo", "age_descricao"}, new String[]{"C\u00f3digo", "Banco", "Desc. Ag\u00eancia"}, new int[]{70, 70, 0}, 1, 1, new TabelaExportacao[]{this.tabBanco}, null);
    TabelaExportacao tabHistoricoPadrao = new TabelaExportacao("Hist\u00f3rico Padr\u00e3o", "historicopadrao", new String[]{"hpa_codigo"}, new String[]{"hpa_codigo", "hpa_descricao"}, new String[]{"hpa_codigo", "hpa_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0}, 1, 1, null, null);
    TabelaExportacao tabConta = new TabelaExportacao("Conta", "contacorrente", new String[]{"cco_reduzido"}, new String[]{"cco_reduzido", "cco_conta", "cco_titular"}, new String[]{"cco_reduzido", "cco_conta", "cco_titular"}, new String[]{"C\u00f3digo", "Conta", "Titular"}, new int[]{70, 100, 0}, 1, 1, new TabelaExportacao[]{this.tabAgencia, this.tabBanco, this.tabHistoricoPadrao}, null);
    TabelaExportacao tabPlanoConta = new TabelaExportacao("Plano de Conta", "planoconta", new String[]{"plc_reduzido"}, new String[]{"plc_reduzido", "plc_conta", "plc_descricao"}, new String[]{"plc_reduzido", "plc_conta", "plc_descricao"}, new String[]{"C\u00f3digo", "Conta", "Descri\u00e7\u00e3o"}, new int[]{70, 70, 0}, 1, 1, null, null);
    TabelaExportacao tabMedicamento = new TabelaExportacao("Medicamento", "medicamentos", new String[]{"mto_codigo"}, new String[]{"mto_codigo", "mto_descricao", "mto_fabricante"}, new String[]{"mto_codigo", "mto_descricao", "mto_fabricante"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o", "Fabricante"}, new int[]{70, 0, 150}, 1, 1, null, null);
    TabelaAgregadaExportacao tabExameAgrupaExameConvenioFaturamento = new TabelaAgregadaExportacao("Agrupa/Faturamento - Exames", "exameagrupaexameconvenio", new String[]{"exa_codigo", "mco_codigo", "con_codigo", "exa_kodigo", "mco_kodigo", "aec_tipo"}, new String[]{"exa_codigo", "mco_codigo", "con_codigo", "exa_kodigo", "mco_kodigo", "aec_tipo"}, new String[]{"aec_tipo = '" + "F" + "'"});
    TabelaExportacao tabExameFaturamento = new TabelaExportacao("Agrupa/Faturamento", "agrupaexameconvenio", new String[]{"exa_codigo", "mco_codigo", "con_codigo", "aec_tipo"}, new String[]{"exa_codigo", "mco_codigo", "con_codigo", "aec_tipo"}, new String[]{"exa_codigo", "mco_codigo", "con_codigo", "aec_tipo"}, new String[]{"Exame", "Mat.", "Conv.", "Tipo"}, new int[]{70, 30, 35, 35}, 0, 0, new TabelaExportacao[]{this.tabExame, this.tabMaterialColetado, this.tabConvenio}, new TabelaAgregadaExportacao[]{this.tabExameAgrupaExameConvenioFaturamento}, new String[]{"aec_tipo = '" + "F" + "'"});
    TabelaAgregadaExportacao tabExameAgrupaExameConvenioRequisicao = new TabelaAgregadaExportacao("Agrupa/Faturamento - Exames", "exameagrupaexameconvenio", new String[]{"exa_codigo", "mco_codigo", "con_codigo", "exa_kodigo", "mco_kodigo", "aec_tipo"}, new String[]{"exa_codigo", "mco_codigo", "con_codigo", "exa_kodigo", "mco_kodigo", "aec_tipo"}, new String[]{"aec_tipo = '" + "R" + "'"});
    TabelaExportacao tabExameRequisicao = new TabelaExportacao("Agrupa/Requisi\u00e7\u00e3o", "agrupaexameconvenio", new String[]{"exa_codigo", "mco_codigo", "con_codigo", "aec_tipo"}, new String[]{"exa_codigo", "mco_codigo", "con_codigo", "aec_tipo"}, new String[]{"exa_codigo", "mco_codigo", "con_codigo", "aec_tipo"}, new String[]{"Exame", "Mat.", "Conv.", "Tipo", "Descri\u00e7\u00e3o", "Material", "Conv\u00eanio"}, new int[]{70, 30, 35, 35}, 0, 0, new TabelaExportacao[]{this.tabExame, this.tabMaterialColetado, this.tabConvenio}, new TabelaAgregadaExportacao[]{this.tabExameAgrupaExameConvenioRequisicao}, new String[]{"aec_tipo = '" + "R" + "'"});
    TabelaExportacao tabExamesSituacao = new TabelaExportacao("Agrupa/Situa\u00e7\u00e3o", "agrupasituacao", new String[]{"con_codigo", "sit_codigo"}, new String[]{"con_codigo", "sit_codigo"}, new String[]{"con_codigo", "sit_codigo"}, new String[]{"C\u00f3digo", "Situa\u00e7\u00e3o"}, new int[]{70, 70}, 1, 1, new TabelaExportacao[]{this.tabConvenio, this.tabSituacao}, null);
    TabelaAgregadaExportacao tabPacienteMedicamento = new TabelaAgregadaExportacao("Paciente - Medicamento", "pacientemedicamento", new String[]{"pac_codigo", "mto_codigo"}, new String[]{"pac_codigo"}, new String[]{"pac_codigo", "mto_codigo"});
    TabelaExportacao tabPaciente = new TabelaExportacao("Paciente", "paciente", new String[]{"pac_codigo"}, new String[]{"pac_codigo", "pac_nome"}, new String[]{"pac_codigo", "pac_nome"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{70, 0}, 1, 1, new TabelaExportacao[]{this.tabBairro, this.tabCidade, this.tabConvenio, this.tabMedico, this.tabMedicamento}, new TabelaAgregadaExportacao[]{this.tabPacienteMedicamento});

    public ExportacaoFiliais_Remover() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        Funcoes.criaBarraDescricao(this, "Exporta\u00e7\u00e3o entre filiais", "Exporta os cadastros entre filiais", "export_filial.jpg");
        this.add((Component)this.panelCentral, "Center");
        this.add((Component)this.panelRodape, "South");
        this.panelRodape.add((Component)this.panelBotoes, "South");
        this.panelBotoes.add(this.buttonNovo);
        this.panelBotoes.add(this.buttonProximo);
        this.panelBotoes.add(this.buttonFechar);
        this.panelList.add((Component)this.scrollList, "Center");
        this.panelList.add((Component)this.panelListBotoes, "South");
        this.panelListBotoes.add(this.buttonTodasTabelas);
        Dimension d = new Dimension(250, 20);
        this.panelTabelas.setPreferredSize(d);
        this.panelTabelas.setMaximumSize(d);
        this.panelTabelas.setMinimumSize(d);
        this.panelTabelas.setSize(d);
        this.panelCentralFiltro.add((Component)this.panelTabelas, "West");
        this.panelTabelas.add((Component)this.scrollTabelas, "Center");
        this.panelTabelas.add((Component)this.panelFiltroTabelasBotoes, "South");
        this.panelTabelas.setBorder(BorderFactory.createTitledBorder("Tabelas Selecionadas"));
        this.panelFiltroTabelasBotoes.add(this.buttonTodasTabelasFiltro);
        this.panelCentralFiltro.add((Component)this.panelFiltro, "Center");
        this.panelFiltro.add((Component)this.scrollFiltro, "Center");
        this.panelFiltro.add((Component)this.panelFiltroBotoes, "South");
        this.panelFiltro.setBorder(BorderFactory.createTitledBorder("Filtro"));
        this.panelFiltroBotoes.add(this.buttonFiltroNenhum);
        this.panelFiltroBotoes.add(this.buttonFiltroTodos);
        this.buttonFiltroNenhum.addActionListener(this);
        this.buttonFiltroTodos.addActionListener(this);
        d = new Dimension(70, 21);
        this.textFilial.setPreferredSize(d);
        this.textFilial.setSize(d);
        this.textFilial.setMaximumSize(d);
        this.textFilial.setMinimumSize(d);
        this.buttonFilial.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Hashtable resultado = Pesquisas.filial(ExportacaoFiliais_Remover.this.getTopLevelAncestor(), true);
                if (resultado != null) {
                    ExportacaoFiliais_Remover.this.textFilial.setText(resultado.get("fil_codigo").toString());
                }
                ExportacaoFiliais_Remover.this.textFilial.grabFocus();
            }
        });
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        this.panelExportacao.add((Component)this.labelFilial, c);
        ++c.gridx;
        this.panelExportacao.add((Component)this.textFilial, c);
        ++c.gridx;
        this.panelExportacao.add((Component)this.buttonFilial, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 5;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.panelExportacao.add((Component)this.scrollExportacao, c);
        ++c.gridy;
        c.weighty = 0.0;
        this.panelExportacao.add((Component)this.progressExportacao, c);
        this.panelCentral.add((Component)this.panelList, "c1");
        this.panelCentral.add((Component)this.panelCentralFiltro, "c2");
        this.panelCentral.add((Component)this.panelExportacao, "c3");
        this.textExportacao.setEditable(false);
        this.textExportacao.setAutoscrolls(true);
        this.listTabelas.addListSelectionListener(this);
        this.listCheckBox.setLayoutOrientation(1);
        this.listCheckBox.setVisibleRowCount(-1);
        this.tableFiltro.setDefaultRenderer(Object.class, new DefaultTableCellRenderer());
        this.tableFiltro.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ExportacaoFiliais_Remover.this.adicionarLinha(ExportacaoFiliais_Remover.this.tableFiltro.getSelectedRow());
            }
        });
        this.tableFiltro.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 32) {
                    ExportacaoFiliais_Remover.this.adicionarLinha(ExportacaoFiliais_Remover.this.tableFiltro.getSelectedRow());
                }
            }
        });
        this.buttonFilial.setPreferredSize(new Dimension(20, 20));
        this.buttonFilial.setFocusable(false);
        Funcoes.imagemPesquisa(this.buttonFilial);
        this.novo();
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0902000100");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonFechar) {
            this.setVisible(false);
        } else if (e.getSource() == this.buttonProximo) {
            this.proximo();
        } else if (e.getSource() == this.buttonAnterior) {
            this.anterior();
        } else if (e.getSource() == this.buttonFiltroTodos) {
            this.marcarTodos();
        } else if (e.getSource() == this.buttonFiltroNenhum) {
            this.desmarcarTodos();
        } else if (e.getSource() == this.buttonExportar) {
            this.exportar();
        } else if (e.getSource() == this.buttonNovo) {
            this.novo();
        } else if (e.getSource() == this.buttonTodasTabelas) {
            this.selecionarTodasTabelas();
        } else if (e.getSource() == this.buttonTodasTabelasFiltro) {
            this.selecionarTodasTabelasFiltro();
        }
    }

    private void selecionarTodasTabelasFiltro() {
        for (int i = 0; i < this.listaTabelasSelecionada.size(); ++i) {
            TabelaExportacao tab = (TabelaExportacao)this.listaTabelasSelecionada.get(i);
            if (tab.isDependenciaSelecionada()) continue;
            try {
                tab.filtrar();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            tab.marcarTodos();
        }
    }

    private void selecionarTodasTabelas() {
        for (int i = 0; i < this.listaTabelas.size(); ++i) {
            TabelaExportacao tab = (TabelaExportacao)this.listCheckBox.getModel().getElementAt(i);
            if (tab.isSelecionada()) continue;
            this.listCheckBox.marcarTabela(i);
        }
    }

    private void novo() {
        Field[] campos;
        this.listCheckBox.setListData(new Object[0]);
        this.listTabelas.setListData(new Object[0]);
        this.listaTabelas.clear();
        this.listaTabelasSelecionada.clear();
        for (Field f : campos = this.getClass().getDeclaredFields()) {
            if (f.getType() != TabelaExportacao.class) continue;
            f.setAccessible(true);
            try {
                TabelaExportacao t = (TabelaExportacao)f.get(this);
                t.selecionar(false);
                t.setDependenciaSelecionada(false);
                this.listaTabelas.add(t);
            }
            catch (IllegalArgumentException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            }
            catch (IllegalAccessException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            }
        }
        this.listCheckBox.setListData(this.listaTabelas.toArray());
    }

    private void marcarTodos() {
        TabelaExportacao tab = (TabelaExportacao)this.listaTabelasSelecionada.get(this.listTabelas.getSelectedIndex());
        if (tab.isDependenciaSelecionada()) {
            return;
        }
        tab.marcarTodos();
        while (this.model.getRowCount() > 0) {
            this.model.removeRow(0);
        }
        for (Object o : tab.linhasFiltradas) {
            this.model.addRow((Object[])o);
        }
    }

    private void desmarcarTodos() {
        TabelaExportacao tab = (TabelaExportacao)this.listaTabelasSelecionada.get(this.listTabelas.getSelectedIndex());
        if (tab.isDependenciaSelecionada()) {
            return;
        }
        tab.desmarcarTodos();
        while (this.model.getRowCount() > 0) {
            this.model.removeRow(0);
        }
        for (Object o : tab.linhasFiltradas) {
            this.model.addRow((Object[])o);
        }
    }

    private void proximo() {
        this.tableFiltro.setModel(new DefaultTableModel((Object[][])null, new String[0]));
        ((CardLayout)this.panelCentral.getLayout()).next(this.panelCentral);
        ++this.abaSelecionada;
        this.arrumaBotoes();
        if (this.abaSelecionada == 1) {
            this.listTabelas.clearSelection();
            this.listaTabelasSelecionada.clear();
            for (Object o : this.listaTabelas) {
                if (!((TabelaExportacao)o).isSelecionada()) continue;
                this.listaTabelasSelecionada.add(o);
            }
            this.listTabelas.setListData(this.listaTabelasSelecionada.toArray());
        }
    }

    private void anterior() {
        ((CardLayout)this.panelCentral.getLayout()).previous(this.panelCentral);
        --this.abaSelecionada;
        this.arrumaBotoes();
    }

    private void arrumaBotoes() {
        this.panelBotoes.removeAll();
        if (this.abaSelecionada == 0) {
            this.panelBotoes.add(this.buttonNovo);
            this.panelBotoes.add(this.buttonProximo);
        } else if (this.abaSelecionada == 1) {
            this.panelBotoes.add(this.buttonAnterior);
            this.panelBotoes.add(this.buttonProximo);
        } else if (this.abaSelecionada == 2) {
            this.panelBotoes.add(this.buttonAnterior);
            this.panelBotoes.add(this.buttonExportar);
        }
        this.panelBotoes.add(this.buttonFechar);
        this.panelBotoes.revalidate();
        this.panelBotoes.repaint();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        if (this.listTabelas.getSelectedIndex() < 0) {
            return;
        }
        TabelaExportacao tab = (TabelaExportacao)this.listaTabelasSelecionada.get(this.listTabelas.getSelectedIndex());
        try {
            tab.filtrar();
            this.configModel(tab);
            for (Object o : tab.linhasFiltradas) {
                this.model.addRow((Object[])o);
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    private void configModel(final TabelaExportacao tab) {
        this.model = null;
        this.model = new DefaultTableModel(null, tab.getNomesColunas()){

            @Override
            public boolean isCellEditable(int row, int column) {
                if (tab.isDependenciaSelecionada()) {
                    return false;
                }
                return column == tab.getNomesColunas().length - 1;
            }

            public Class getColumnClass(int column) {
                Class returno = this.getRowCount() > 0 && column >= 0 && column < this.getColumnCount() && this.getValueAt(0, column) != null ? this.getValueAt(0, column).getClass() : Object.class;
                return returno;
            }
        };
        this.tableFiltro.setModel(this.model);
        TableRowSorter<DefaultTableModel> sorter = new TableRowSorter<DefaultTableModel>(this.model);
        this.tableFiltro.setRowSorter(sorter);
        for (int i = 0; i < tab.getTamanhoColunas().length; ++i) {
            if (tab.getTamanhoColunas()[i] == 0) continue;
            this.tableFiltro.getColumnModel().getColumn(i).setWidth(tab.getTamanhoColunas()[i]);
            this.tableFiltro.getColumnModel().getColumn(i).setMaxWidth(tab.getTamanhoColunas()[i]);
            this.tableFiltro.getColumnModel().getColumn(i).setPreferredWidth(tab.getTamanhoColunas()[i]);
        }
        this.tableFiltro.getColumnModel().getColumn(tab.getTamanhoColunas().length).setWidth(50);
        this.tableFiltro.getColumnModel().getColumn(tab.getTamanhoColunas().length).setMaxWidth(50);
        this.tableFiltro.getColumnModel().getColumn(tab.getTamanhoColunas().length).setMinWidth(50);
        this.tableFiltro.getColumnModel().getColumn(tab.getTamanhoColunas().length).setPreferredWidth(50);
    }

    private void adicionarLinha(int linha) {
        if (this.listTabelas.getSelectedIndex() < 0 || linha < 0) {
            return;
        }
        linha = this.tableFiltro.convertRowIndexToModel(linha);
        TabelaExportacao tab = (TabelaExportacao)this.listaTabelasSelecionada.get(this.listTabelas.getSelectedIndex());
        if (tab.isDependenciaSelecionada()) {
            return;
        }
        Object l = tab.linhasFiltradas.get(linha);
        Object[] lf = (Object[])l;
        boolean achou = false;
        for (Object o : tab.linhasSelecionadas) {
            Object[] ls = (Object[])o;
            boolean selecionada = true;
            for (int i = 0; i < lf.length - 1; ++i) {
                if (lf[i].equals(ls[i])) continue;
                selecionada = false;
                break;
            }
            if (!selecionada) continue;
            achou = true;
            l = o;
            break;
        }
        if (achou) {
            tab.linhasSelecionadas.remove(l);
        } else {
            tab.linhasSelecionadas.add(l);
            tab.selecionaDependencias(l);
        }
    }

    private void exportar() {
        String filial = this.textFilial.getText();
        if (Funcoes.textoVazio(filial)) {
            Funcoes.mensagem(this, "Filial de destino n\u00e3o esta selecionada!", 2);
            return;
        }
        if (this.listaTabelasSelecionada.size() == 0) {
            Funcoes.mensagem(this, "Filial de destino n\u00e3o esta selecionada!", 2);
            return;
        }
        ThreadExportacao exp = new ThreadExportacao(this, this.listaTabelasSelecionada, Integer.parseInt(filial), this.progressExportacao, this.textExportacao);
        exp.start();
    }

    @Override
    public void inicioExportacaoTabela(TabelaExportacao tabela) {
    }

    @Override
    public void terminoExportacaoTabela(TabelaExportacao tabela) {
    }

    @Override
    public void erroExportacao(String erro) {
        this.textExportacao.append(erro);
        this.buttonAnterior.setEnabled(true);
        this.buttonExportar.setEnabled(false);
        this.buttonFechar.setEnabled(true);
    }

    @Override
    public void inicioExportacao() {
        this.buttonAnterior.setEnabled(false);
        this.buttonExportar.setEnabled(false);
        this.buttonFechar.setEnabled(false);
    }

    @Override
    public void terminoExportacao() {
        this.buttonFechar.setEnabled(true);
    }
}

