/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.exportacao.filial;

import jalis.laboratorio.DisposeListener;
import jalis.laboratorio.Laboratorio;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.TableUtil;
import jalis.util.tabela.TabelaModelada;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableModel;

public class DialogoFiltroFilial
extends JDialog
implements ActionListener,
DisposeListener {
    JScrollPane scrollFiltro = new JScrollPane();
    JPanel painelLocalizar = new JPanel(null);
    JLabel lblLocalizar = new JLabel("Localizar:");
    JTextField txtLocalizar = new JTextField();
    JButton btnSelecionar = new JButton("Selecionar");
    TabelaModelada tabela;
    JButton buttonMarcarTodos = new JButton("Marcar todos");
    JButton buttonDesmarcarTodos = new JButton("Desmarcar todos");
    JButton buttonOk = new JButton("OK");
    JButton buttonCancelar = new JButton("Cancelar");
    boolean ok = false;

    public static DialogoFiltroFilial novaInstancia(Object pai, String titulo, String[] column_names, int[] column_sizes) {
        if (pai instanceof Frame) {
            return new DialogoFiltroFilial((Frame)pai, titulo, column_names, column_sizes, true);
        }
        if (pai instanceof Dialog) {
            return new DialogoFiltroFilial((Dialog)pai, titulo, column_names, column_sizes, true);
        }
        return null;
    }

    private DialogoFiltroFilial(Frame pai, String titulo, final String[] column_names, int[] column_sizes, boolean modal) {
        super(pai, titulo, modal);
        if (pai instanceof Laboratorio) {
            ((Laboratorio)pai).addDisposeListener(this);
        }
        this.tabela = new TabelaModelada(column_names){

            @Override
            public boolean isCellEditable(int row, int col) {
                return column_names.length == col + 1;
            }

            public Class getColumnClass(int col) {
                Object o = this.getValueAt(0, col);
                Class c = o != null ? o.getClass() : String.class;
                return c;
            }
        };
        this.setColumnSizes(column_sizes);
        this.iniciar();
        ScreenUtil.centralizar(this);
    }

    private DialogoFiltroFilial(Dialog pai, String titulo, final String[] column_names, int[] column_sizes, boolean modal) {
        super(pai, titulo, modal);
        this.tabela = new TabelaModelada(column_names){

            @Override
            public boolean isCellEditable(int row, int col) {
                return column_names.length == col + 1;
            }

            public Class getColumnClass(int col) {
                return this.getValueAt(0, col).getClass();
            }
        };
        this.setColumnSizes(column_sizes);
        this.iniciar();
        ScreenUtil.centralizar(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.buttonMarcarTodos) {
            this.marcarDesmarcarTodos(true);
        } else if (o == this.buttonDesmarcarTodos) {
            this.marcarDesmarcarTodos(false);
        } else if (o == this.buttonOk || o == this.buttonCancelar) {
            this.ok = o == this.buttonOk;
            this.setVisible(false);
        }
    }

    public boolean ok() {
        return this.ok;
    }

    public void setDados(ArrayList<Object[]> matriz, int colunaOrdenacao) {
        ArrayList<Object[]> nova = new ArrayList<Object[]>();
        for (Object[] linha : matriz) {
            Object[] full = new Object[linha.length + 1];
            int i = -1;
            for (Object elemento : linha) {
                full[++i] = elemento;
            }
            full[++i] = new Boolean(false);
            nova.add(full);
        }
        this.tabela.setSortedData(nova, colunaOrdenacao > this.tabela.getColumnCount() ? 0 : colunaOrdenacao);
        this.scrollFiltro.setViewportView(this.tabela);
    }

    public void setDados(ArrayList<Object[]> matriz) {
        this.setDados(matriz, 0);
    }

    public void setColumnSizes(int[] column_sizes) {
        if (column_sizes.length <= this.tabela.getColumnCount()) {
            for (int i = 0; i < column_sizes.length; ++i) {
                if (column_sizes[i] <= 0) continue;
                this.tabela.forceSize(i, column_sizes[i]);
            }
            this.tabela.forceSize(this.tabela.getColumnCount() - 1, 20);
        }
    }

    public ArrayList<Object[]> getSelecionados() {
        ArrayList<Object[]> selecionados = new ArrayList<Object[]>();
        for (int i = 0; i < this.tabela.getRowCount(); ++i) {
            if (!((Boolean)this.tabela.getValueAt(i, this.tabela.getColumnCount() - 1)).booleanValue()) continue;
            Object[] linha_completa = this.tabela.getRow(i);
            Object[] linha_corrigida = new Object[linha_completa.length - 1];
            for (int j = 0; j < linha_corrigida.length; ++j) {
                linha_corrigida[j] = linha_completa[j];
            }
            selecionados.add(linha_corrigida);
        }
        return selecionados;
    }

    public ArrayList<Object[]> selectAll(boolean selected) {
        ArrayList<Object[]> selecionados = new ArrayList<Object[]>();
        for (int i = 0; i < this.tabela.getRowCount(); ++i) {
            this.tabela.setValueAt(new Boolean(selected), i, this.tabela.getColumnCount() - 1);
            if (!selected) continue;
            Object[] linha = this.tabela.getRow(i);
            Object[] nova = new Object[linha.length - 1];
            for (int j = 0; j < nova.length; ++j) {
                nova[j] = linha[j];
            }
            selecionados.add(nova);
        }
        this.scrollFiltro.revalidate();
        return selecionados;
    }

    private void marcarDesmarcarTodos(boolean valor) {
        TableModel model = ((JTable)this.scrollFiltro.getViewport().getView()).getModel();
        for (int i = 0; i < model.getRowCount(); ++i) {
            model.setValueAt(new Boolean(valor), i, model.getColumnCount() - 1);
        }
    }

    public int getQtdeRegistros() {
        return this.tabela.getRowCount();
    }

    private void iniciar() {
        JPanel panelBarra = new JPanel(new BorderLayout());
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.scrollFiltro, "Center");
        this.getContentPane().add((Component)panelBarra, "South");
        panelBarra.setBorder(BorderFactory.createEtchedBorder());
        panelBarra.setPreferredSize(new Dimension(10, 65));
        panelBarra.setLayout(new BorderLayout());
        JPanel panelBarraSouth = new JPanel(new BorderLayout());
        panelBarra.add((Component)panelBarraSouth, "South");
        this.painelLocalizar = new JPanel(new GridBagLayout());
        this.painelLocalizar.setPreferredSize(new Dimension(50, 40));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 0;
        c.insets = new Insets(0, 5, 5, 0);
        c.weightx = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        this.painelLocalizar.add((Component)this.lblLocalizar, c);
        c.fill = 2;
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 1.0;
        this.painelLocalizar.add((Component)this.txtLocalizar, c);
        c.insets = new Insets(0, 5, 5, 5);
        c.weightx = 0.0;
        c.fill = 0;
        c.gridx = 2;
        c.gridy = 0;
        this.painelLocalizar.add((Component)this.btnSelecionar, c);
        panelBarra.add((Component)this.painelLocalizar, "North");
        JPanel panelTmp = new JPanel(new FlowLayout(0, 3, 3));
        panelBarraSouth.add((Component)panelTmp, "West");
        panelTmp.setPreferredSize(new Dimension(300, 30));
        panelTmp.add(this.buttonDesmarcarTodos);
        panelTmp.add(this.buttonMarcarTodos);
        panelTmp = new JPanel(new FlowLayout(2, 3, 3));
        panelBarraSouth.add((Component)panelTmp, "East");
        panelTmp.setPreferredSize(new Dimension(200, 10));
        panelTmp.add(this.buttonOk);
        panelTmp.add(this.buttonCancelar);
        this.buttonDesmarcarTodos.addActionListener(this);
        this.buttonMarcarTodos.addActionListener(this);
        this.buttonOk.addActionListener(this);
        this.buttonCancelar.addActionListener(this);
        this.btnSelecionar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = DialogoFiltroFilial.this.tabela.getSelectedRow();
                int lastcol = DialogoFiltroFilial.this.tabela.getColumnCount() - 1;
                if (row >= 0 && row < DialogoFiltroFilial.this.tabela.getRowCount() && DialogoFiltroFilial.this.tabela.getColumnClass(lastcol) == Boolean.class) {
                    Boolean valor = (Boolean)DialogoFiltroFilial.this.tabela.getValueAt(row, lastcol);
                    valor = new Boolean(valor == false);
                    DialogoFiltroFilial.this.tabela.setValueAt(valor, row, lastcol);
                }
                DialogoFiltroFilial.this.txtLocalizar.grabFocus();
            }
        });
        this.btnSelecionar.setMnemonic('S');
        this.btnSelecionar.setToolTipText("Bot\u00e3o que alterna a marca\u00e7\u00e3o da linha selecionada na tabela");
        this.setSize(new Dimension(500, 480));
        this.lblLocalizar.setDisplayedMnemonic('L');
        this.lblLocalizar.setLabelFor(this.txtLocalizar);
        Funcoes.montaEnter((JComponent)this.painelLocalizar);
        this.txtLocalizar.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                DialogoFiltroFilial.this.localizar(DialogoFiltroFilial.this.txtLocalizar.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                DialogoFiltroFilial.this.localizar(DialogoFiltroFilial.this.txtLocalizar.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.txtLocalizar.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                DialogoFiltroFilial.this.txtLocalizar.selectAll();
            }
        });
        this.buttonCancelar.setMnemonic('C');
        this.buttonDesmarcarTodos.setMnemonic('D');
        this.buttonMarcarTodos.setMnemonic('M');
        this.buttonOk.setMnemonic('O');
        this.txtLocalizar.grabFocus();
    }

    public void setSelecionados(ArrayList<Object[]> selecionados) {
        this.marcarDesmarcarTodos(false);
        ArrayList<Object[]> temp = new ArrayList<Object[]>();
        for (Object[] linha : selecionados) {
            Object[] novo = new Object[linha.length + 1];
            for (int i = 0; i < linha.length; ++i) {
                novo[i] = linha[i];
            }
            novo[novo.length - 1] = new Boolean(false);
            temp.add(novo);
        }
        block2: for (int i = 0; i < this.tabela.getRowCount() && temp.size() > 0; ++i) {
            for (Object[] corrigido : temp) {
                if (!Arrays.equals(corrigido, this.tabela.getRow(i))) continue;
                this.tabela.setValueAt(new Boolean(true), i, this.tabela.getColumnCount() - 1);
                temp.remove(corrigido);
                continue block2;
            }
        }
    }

    private void localizar(String valor) {
        Object cell;
        String prefix = valor.toLowerCase();
        int column = this.tabela.getColunaOrdenada();
        int rows = this.tabela.getRowCount();
        for (int i = 0; i < rows && ((cell = this.tabela.getValueAt(i, column)) instanceof String || cell instanceof Integer); ++i) {
            String value = cell.toString().toLowerCase();
            if (!value.startsWith(prefix)) continue;
            this.tabela.setRowSelectionInterval(i, i);
            TableUtil.scrollToCenter(this.tabela, i);
            break;
        }
    }
}

