/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.exportacao.externo;

import jalis.laboratorio.Laboratorio;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import jalis.util.xml.XMLUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ParserImportacaoAlvaro {
    public static final String TAG_SOLICITACOES = "solicitacoes";
    public static final String TAG_PACIENTES = "pacientes";
    public static final String TAG_ENTIDADE = "entidade";
    public static final String TAG_MEDICOS = "medicos";
    public static final String TAG_SOLICITACAO = "solicitacao";
    public static final String TAG_AMOSTRAS = "amostras";
    public static final String TAG_AMOSTRA = "amostra";
    public static final String TAG_EXAME = "exame";
    public static final String TAG_EXAMES = "exames";
    public static final String TAG_MATERIAIS = "materiais";
    public static final String TAG_MEDICO = "medicos";
    public static final String TAG_MEDICO_CRM = "crm";
    public static final String TAG_MEDICO_NOME = "nome";
    public static final String TAG_SOLICITACOES_VERSAO = "versao";
    public static final String TAG_SOLICITACOES_LIS = "lis";
    public static final String TAG_SOLICITACOES_OPERADOR = "operador";
    public static final String TAG_SOLICITACOES_DATAHORA = "datahora";
    public static final String TAG_ENTIDADE_CODIGO = "codigo";
    public static final String TAG_PACIENTE = "paciente";
    public static final String TAG_PACIENTE_CODIGO_LIS = "codigo_lis";
    public static final String TAG_PACIENTE_DATANASC = "datanasc";
    public static final String TAG_PACIENTE_NOME = "nome";
    public static final String TAG_PACIENTE_SEXO = "sexo";
    public static final String TAG_PACIENTE_PESO = "peso";
    public static final String TAG_PACIENTE_PESO_CONCENT = "peso do paciente";
    public static final String TAG_PACIENTE_ALTURA = "altura";
    public static final String TAG_SOLICITACAO_CODIGO_LIS = "codigo_lis";
    public static final String TAG_SOLICITACAO_CODIGO_PACIENTE = "codigo_paciente";
    public static final String TAG_SOLICITACAO_CRM = "crm";
    public static final String TAG_SOLICITACAO_DATA = "data";
    public static final String TAG_SOLICITACAO_DUM = "dum";
    public static final String TAG_SOLICITACAO_OBSERVACAO = "observacao";
    public static final String TAG_AMOSTRA_DESCRICAO = "descricao";
    public static final String TAG_AMOSTRA_MATERIAL = "material";
    public static final String TAG_AMOSTRA_IDENTIFICACAO = "identificacao";
    public static final String TAG_EXAME_CODIGO = "codigo";
    public static final String TAG_EXAME_DADOS_ADICIONAIS = "dados_adicionais";
    public static final String TAG_EXAME_ID_LIS = "id_lis";
    public static final String TAG_EXAME_VOLUME = "volume";
    public static final String TAG_EXAME_TEMPO_JEJUM = "tempojejum";
    public static final String TAG_EXAME_TEMPO_DIURESE = "tempodiurese";
    public static final String TAG_EXAME_DATA_MATERIAL = "exr_datamaterial";
    public static final String TAG_EXAME_JALIS = "exa_codigo";
    public static final String TAG_EXAME_MATERIAL_JALIS = "mco_codigo";

    public static Registro importarRemessa(File xmlReqAlvaro) throws Exception {
        return ParserImportacaoAlvaro.importarRemessa(new FileInputStream(xmlReqAlvaro));
    }

    public static Registro importarRemessa(InputStream xmlReqAlvaro) {
        Element raiz;
        Registro remessa = new Registro();
        Document doc = ParserImportacaoAlvaro.analisarXML(xmlReqAlvaro);
        if (doc != null && (raiz = doc.getDocumentElement()).getNodeName().equalsIgnoreCase(TAG_SOLICITACOES)) {
            remessa.setValor(TAG_SOLICITACOES_VERSAO, raiz.getAttribute(TAG_SOLICITACOES_VERSAO));
            remessa.setValor(TAG_SOLICITACOES_LIS, raiz.getAttribute(TAG_SOLICITACOES_LIS));
            remessa.setValor(TAG_SOLICITACOES_OPERADOR, raiz.getAttribute(TAG_SOLICITACOES_OPERADOR));
            remessa.setValor(TAG_SOLICITACOES_DATAHORA, raiz.getAttribute(TAG_SOLICITACOES_DATAHORA));
            List<Element> entidades = XMLUtil.getElementosFilhos(raiz);
            for (Element entidade : entidades) {
                if (!entidade.getNodeName().equalsIgnoreCase(TAG_ENTIDADE)) continue;
                remessa.setValor("codigo", entidade.getAttribute("codigo"));
                List<Element> filhos = XMLUtil.getElementosFilhos(entidade);
                ArrayList<Registro> solicitacoes = new ArrayList<Registro>();
                HashMap<String, Registro> pacientes = null;
                for (Element e : filhos) {
                    if (e.getNodeName().equalsIgnoreCase(TAG_PACIENTES)) {
                        pacientes = ParserImportacaoAlvaro.parsePacientes(XMLUtil.getElementosFilhos(e));
                        remessa.setValor(TAG_PACIENTES, pacientes);
                        continue;
                    }
                    if (e.getNodeName().equalsIgnoreCase("medicos")) {
                        remessa.setValor("medicos", ParserImportacaoAlvaro.parseMedicos(XMLUtil.getElementosFilhos(e)));
                        continue;
                    }
                    if (!e.getNodeName().equalsIgnoreCase(TAG_SOLICITACAO)) continue;
                    solicitacoes.add(ParserImportacaoAlvaro.parseSolicitacao(e, pacientes));
                }
                remessa.setValor(TAG_SOLICITACOES, solicitacoes);
            }
        }
        return remessa;
    }

    private static Document analisarXML(InputStream stream) {
        Document doc = null;
        try {
            doc = XMLUtil.analisarXML(stream);
            return doc;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel analisar o XML.\n" + e.getMessage(), e.getStackTrace());
        }
        finally {
            return doc;
        }
    }

    private static Registro parseSolicitacao(Element solicitacao, HashMap<String, Registro> pacientes) {
        Registro reg = new Registro();
        reg.setValor("codigo_lis", solicitacao.getAttribute("codigo_lis"));
        reg.setValor(TAG_SOLICITACAO_CODIGO_PACIENTE, solicitacao.getAttribute(TAG_SOLICITACAO_CODIGO_PACIENTE));
        reg.setValor("crm", solicitacao.getAttribute("crm"));
        reg.setValor(TAG_SOLICITACAO_DATA, Funcoes.stringToDate(solicitacao.getAttribute(TAG_SOLICITACAO_DATA)));
        reg.setValor(TAG_SOLICITACAO_OBSERVACAO, solicitacao.getAttribute(TAG_SOLICITACAO_OBSERVACAO));
        ArrayList<Registro> amostras = new ArrayList<Registro>();
        for (Element e : XMLUtil.getElementosFilhos(solicitacao)) {
            if (!e.getNodeName().equalsIgnoreCase(TAG_AMOSTRA)) continue;
            Registro amostra = new Registro();
            amostra.setValor(TAG_AMOSTRA_DESCRICAO, e.getAttribute(TAG_AMOSTRA_DESCRICAO));
            amostra.setValor(TAG_AMOSTRA_MATERIAL, e.getAttribute(TAG_AMOSTRA_MATERIAL));
            amostra.setValor(TAG_AMOSTRA_IDENTIFICACAO, e.getAttribute(TAG_AMOSTRA_IDENTIFICACAO));
            ArrayList<Registro> exames = new ArrayList<Registro>();
            for (Element eExame : XMLUtil.getElementosFilhos(e)) {
                Registro exame = new Registro();
                exame.setValor("codigo", eExame.getAttribute("codigo"));
                exame.setValor(TAG_EXAME_DADOS_ADICIONAIS, eExame.getAttribute(TAG_EXAME_DADOS_ADICIONAIS));
                exame.setValor(TAG_EXAME_ID_LIS, eExame.getAttribute(TAG_EXAME_ID_LIS));
                if (eExame.getAttribute("codigo").contains("|")) {
                    int index = eExame.getAttribute("codigo").indexOf("|");
                    if (index > 0) {
                        exame.setValor(TAG_EXAME_JALIS, eExame.getAttribute("codigo").substring(0, eExame.getAttribute("codigo").indexOf("|")));
                        exame.setValor(TAG_EXAME_MATERIAL_JALIS, Integer.parseInt(eExame.getAttribute("codigo").substring(eExame.getAttribute("codigo").indexOf("|") + 1)));
                    }
                } else {
                    exame.setValor(TAG_EXAME_JALIS, eExame.getAttribute("codigo"));
                    exame.setValor(TAG_EXAME_MATERIAL_JALIS, e.getAttribute(TAG_AMOSTRA_MATERIAL));
                }
                exame.setValor(TAG_EXAME_DATA_MATERIAL, Funcoes.stringToDate(solicitacao.getAttribute(TAG_SOLICITACAO_DATA)));
                ParserImportacaoAlvaro.setDadoAdicionalPac(solicitacao, pacientes, eExame, TAG_PACIENTE_PESO);
                ParserImportacaoAlvaro.setDadoAdicionalPac(solicitacao, pacientes, eExame, TAG_PACIENTE_PESO_CONCENT);
                ParserImportacaoAlvaro.setDadoAdicionalPac(solicitacao, pacientes, eExame, TAG_PACIENTE_ALTURA);
                ParserImportacaoAlvaro.setDadoAdicionalExame(solicitacao, exame, eExame, TAG_EXAME_VOLUME);
                ParserImportacaoAlvaro.setDadoAdicionalExame(solicitacao, exame, eExame, TAG_EXAME_TEMPO_JEJUM);
                ParserImportacaoAlvaro.setDadoAdicionalSolicitacao(reg, eExame, TAG_SOLICITACAO_DUM);
                exames.add(exame);
            }
            amostra.setValor(TAG_EXAMES, exames);
            amostras.add(amostra);
        }
        reg.setValor(TAG_AMOSTRAS, amostras);
        return reg;
    }

    private static void setDadoAdicionalPac(Element solicitacao, HashMap<String, Registro> pacientes, Element exame, String campo) throws NumberFormatException {
        if (exame.getAttribute(TAG_EXAME_DADOS_ADICIONAIS).contains(campo + "=")) {
            String[] dado;
            for (String str : dado = exame.getAttribute(TAG_EXAME_DADOS_ADICIONAIS).split("\n")) {
                String valor = str.substring(str.indexOf(61) + 1);
                if (!str.contains(campo + "=") || !Funcoes.isNumeric(valor)) continue;
                pacientes.get(solicitacao.getAttribute(TAG_SOLICITACAO_CODIGO_PACIENTE)).setValor(campo, Double.parseDouble(valor));
            }
        }
    }

    private static void setDadoAdicionalExame(Element solicitacao, Registro exame, Element eleExame, String campo) {
        if (eleExame.getAttribute(TAG_EXAME_DADOS_ADICIONAIS).contains(campo + "=")) {
            String[] dado;
            for (String str : dado = eleExame.getAttribute(TAG_EXAME_DADOS_ADICIONAIS).split("\n")) {
                String valor = str.substring(str.indexOf(61) + 1);
                if (!str.contains(campo + "=") || !Funcoes.isNumeric(valor)) continue;
                exame.setValor(campo, Double.parseDouble(valor));
            }
        }
    }

    private static void setDadoAdicionalSolicitacao(Registro reg, Element eleExame, String campo) {
        if (eleExame.getAttribute(TAG_EXAME_DADOS_ADICIONAIS).contains(campo + "=")) {
            String[] dado;
            for (String str : dado = eleExame.getAttribute(TAG_EXAME_DADOS_ADICIONAIS).split("\n")) {
                String valor = str.substring(str.indexOf(61) + 1);
                if (!str.contains(campo + "=")) continue;
                reg.setValor(campo, valor);
            }
        }
    }

    private static HashMap<String, Registro> parseMedicos(List<Element> elementosFilhos) {
        HashMap<String, Registro> medicos = new HashMap<String, Registro>();
        for (Element e : elementosFilhos) {
            if (!e.getNodeName().equalsIgnoreCase("medicos")) continue;
            Registro med = new Registro();
            med.setValor("crm", e.getAttribute("crm"));
            med.setValor("nome", e.getAttribute("nome"));
            medicos.put(e.getAttribute("crm"), med);
        }
        return medicos;
    }

    private static HashMap<String, Registro> parsePacientes(List<Element> elementosFilhos) {
        HashMap<String, Registro> pacientes = new HashMap<String, Registro>();
        for (Element e : elementosFilhos) {
            if (!e.getNodeName().equalsIgnoreCase(TAG_PACIENTE)) continue;
            Registro pac = new Registro();
            pac.setValor("codigo_lis", e.getAttribute("codigo_lis"));
            pac.setValor(TAG_PACIENTE_DATANASC, Funcoes.stringToDate(e.getAttribute(TAG_PACIENTE_DATANASC)));
            pac.setValor("nome", e.getAttribute("nome"));
            pac.setValor(TAG_PACIENTE_SEXO, e.getAttribute(TAG_PACIENTE_SEXO));
            pacientes.put(e.getAttribute("codigo_lis"), pac);
        }
        return pacientes;
    }
}

