/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.exportacao.externo;

import jalis.comum.Conexao;
import jalis.laboratorio.configurador.componente.Campo;
import jalis.laboratorio.configurador.componente.Componente;
import jalis.laboratorio.configurador.componente.Expressao;
import jalis.laboratorio.configurador.componente.Rotulo;
import jalis.laboratorio.configurador.componente.Texto;
import jalis.laboratorio.digitacao.Resultado;
import jalis.laboratorio.exportacao.externo.EscreverXML;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import jalis.util.xml.XMLStringBuilderException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JProgressBar;

public class ParserExportacaoAlvaro {
    private static final String TAG_DADOSOBRIGATORIOS = "dadosobrigatorios";
    public static final String MASCARA_EXAME = "%s|%s";
    public static final String MASCARA_DATA = "dd/MM/yyyy HH:mm:ss";
    private static final String TAG_VERSAO = "versao";
    private static final String TAG_DATAHORA = "datahora";
    public static final String TAG_MATERIAL_PADRAO = "materialpadrao";
    private static final String TAG_NORMAL = "normal";
    private static final String TAG_OBSERVACAO = "observacao";
    private static final String TAG_METODO = "metodo";
    private static final String TAG_DATARESULTADO = "dataresultado";
    private static final String TAG_PONTOS = "pontos";
    private static final String TAG_ID = "id";
    private static final String TAG_RESISTENCIA = "resistencia";
    private static final String TAG_HALO = "halo";
    private static final String TAG_ANTIBIOTICO = "antibiotico";
    private static final String TAG_LINHA_RESULTADO = "linharesultado";
    private static final String TAG_ID_LIS = "id_lis";
    private static final String TAG_IDENTIFICACAO = "identificacao";
    private static final String TAG_SEXO = "sexo";
    private static final String TAG_NOME = "nome";
    private static final String TAG_DATANASC = "datanasc";
    private static final String TAG_CODIGO_AOL = "codigo_aol";
    private static final String TAG_CODIGO_LIS = "codigo_lis";
    private static final String TAG_LISTALAUDO = "listalaudo";
    private static final String TAG_LABEL = "label";
    public static final String TAG_UNIDADE = "unidade";
    public static final String TAG_DATA_ALTERACAO = "dataalteracao";
    public static final String TAG_DESCRICAO = "descricao";
    public static final String TAG_CODIGO = "codigo";
    private static final String TAG_CURVA = "curva";
    private static final String TAG_CURVAS = "curvas";
    private static final String TAG_ANTIBIOGRAMA = "antibiograma";
    private static final String TAG_LINHA = "linha";
    private static final String TAG_CADASTROS = "cadastros";
    private static final String TAG_RESULTADOS = "resultados";
    private static final String TAG_RESULTADO = "resultado";
    private static final String TAG_VALOR_REFERENCIA = "valorreferencia";
    private static final String TAG_LINHAS_RESULTADO = "linhasresultado";
    private static final String TAG_CAMPO_COMPLEMENTAR = "campocomplementar";
    private static final String TAG_CAMPOS_COMPLEMENTARES = "camposcomplementares";
    private static final String TAG_MATERIAL = "material";

    public static String getSelectApoioDesktop() {
        StringBuilder sql = new StringBuilder();
        sql.append("select b.exa_codigo ");
        sql.append(" ,b.exa_descricao ");
        sql.append(" ,a.mco_codigo ");
        sql.append(" ,a.emc_obrigaaltura ");
        sql.append(" ,a.emc_obrigapeso ");
        sql.append(" ,a.emc_obrigavolume ");
        sql.append(" ,a.emc_obrigatempodiurese ");
        sql.append(" ,a.emc_solicitarjejum ");
        sql.append(" ,a.emc_obrigadum");
        sql.append(" ,e.met_descricao ");
        sql.append(" ,d.elm_formato ");
        sql.append(" ,d.met_codigo ");
        sql.append(" ,d.lay_codigo ");
        sql.append(" ,a.emc_default ");
        sql.append(" ,d.elm_exportatexto ");
        sql.append(" from examematcoleta a ");
        sql.append(" join exames b on a.exa_codigo = b.exa_codigo");
        sql.append(" join materialcoleta c on a.mco_codigo = c.mco_codigo");
        sql.append(" join examelayoutmetodo d on a.exa_codigo = d.exa_codigo and c.mco_codigo = d.mco_codigo and a.met_codigo = d.met_codigo ");
        sql.append(" join metodologia e on d.met_codigo = e.met_codigo");
        sql.append(" where d.elm_formato is not null  and d.elm_formato <> '' and b.exa_proibido <> ?");
        sql.append(" order by a.exa_codigo ");
        return sql.toString();
    }

    public static String exportaExames(Registro[] materiaisParaEnviar, Registro[] examesParaEnviar, Statement st, JProgressBar progresso, Map<String, List<Registro>> dadosObrigatorios, boolean ignorarRotulo) throws SQLException {
        String retorno = "";
        EscreverXML xml = new EscreverXML();
        xml.abreTag(TAG_CADASTROS);
        ParserExportacaoAlvaro.geraMateriais(materiaisParaEnviar, xml, progresso);
        xml.abreTag("exames");
        String dataAlteracao = Funcoes.formataData(MASCARA_DATA, Calendar.getInstance().getTime());
        for (Registro exame : examesParaEnviar) {
            exame.setValor(TAG_CODIGO, String.format(MASCARA_EXAME, exame.getString("exa_codigo"), exame.getString("mco_codigo")));
            exame.setValor(TAG_DESCRICAO, exame.getString("exa_descricao"));
            exame.setValor(TAG_DATA_ALTERACAO, Funcoes.textoVazio(StringUtil.getValor(exame.getString("elm_formato"), TAG_DATA_ALTERACAO)) ? dataAlteracao : StringUtil.getValor(exame.getString("elm_formato"), TAG_DATA_ALTERACAO));
            exame.setValor(TAG_MATERIAL_PADRAO, String.valueOf(exame.getInt("mco_codigo")));
            xml.escreveTag("exame", false, exame, TAG_CODIGO, TAG_DESCRICAO, TAG_DATA_ALTERACAO, TAG_MATERIAL_PADRAO);
            xml.abreTag(TAG_LINHAS_RESULTADO);
            if (!Funcoes.textoVazio(exame.getString("elm_formato"))) {
                try {
                    ParserExportacaoAlvaro.escreveLinhasResultado(xml, exame.getString("elm_formato"), ignorarRotulo);
                }
                catch (XMLStringBuilderException e) {
                    ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "exportaExames");
                }
            }
            xml.fechaTag(TAG_LINHAS_RESULTADO);
            List<Registro> dados = ParserExportacaoAlvaro.obtemDadosObrigatorios(exame);
            if (dados.size() > 0) {
                dadosObrigatorios.put(exame.getValor(TAG_CODIGO.toUpperCase()).toString(), dados);
            }
            xml.fechaTag("exame");
            if (progresso == null) continue;
            progresso.setValue(progresso.getValue() + 1);
        }
        xml.fechaTag("exames");
        xml.fechaTag(TAG_CADASTROS);
        retorno = xml.fecharXML();
        return retorno;
    }

    private static List<Registro> obtemDadosObrigatorios(Registro regExame) throws SQLException {
        Registro reg;
        LinkedList<Registro> dados = new LinkedList<Registro>();
        if (regExame.getString("emc_obrigaaltura").equalsIgnoreCase("Y")) {
            reg = new Registro();
            reg.setValor(TAG_CODIGO, "");
            reg.setValor(TAG_DESCRICAO, "altura");
            reg.setValor(TAG_UNIDADE, "cm");
            dados.add(reg);
        }
        if (regExame.getString("emc_obrigapeso").equalsIgnoreCase("Y")) {
            reg = new Registro();
            reg.setValor(TAG_CODIGO, "");
            reg.setValor(TAG_DESCRICAO, "peso");
            reg.setValor(TAG_UNIDADE, "kg");
            dados.add(reg);
        }
        if (regExame.getString("emc_obrigavolume").equalsIgnoreCase("Y")) {
            reg = new Registro();
            reg.setValor(TAG_CODIGO, "");
            reg.setValor(TAG_DESCRICAO, "volume");
            reg.setValor(TAG_UNIDADE, "mL");
            dados.add(reg);
        }
        if (regExame.getString("emc_obrigadum").equalsIgnoreCase("Y")) {
            reg = new Registro();
            reg.setValor(TAG_CODIGO, "");
            reg.setValor(TAG_DESCRICAO, "dum");
            reg.setValor(TAG_UNIDADE, "Data dd/MM/yyyy");
            dados.add(reg);
        }
        if (regExame.getString("emc_obrigatempodiurese").equalsIgnoreCase("Y")) {
            reg = new Registro();
            reg.setValor(TAG_CODIGO, "");
            reg.setValor(TAG_DESCRICAO, "tempodiurese");
            reg.setValor(TAG_UNIDADE, "Horas");
            dados.add(reg);
        }
        return dados;
    }

    private static void geraMateriais(Registro[] rs, EscreverXML xml, JProgressBar progresso) throws SQLException {
        xml.abreTag("materiais");
        for (Registro reg : rs) {
            xml.escreveTag(TAG_MATERIAL, true, reg, TAG_CODIGO, TAG_DESCRICAO);
            if (progresso == null) continue;
            progresso.setValue(progresso.getValue() + 1);
        }
        xml.fechaTag("materiais");
    }

    private static void escreveLinhasResultado(EscreverXML xml, String xmlCampos, boolean ignorarRotulo) throws XMLStringBuilderException {
        String[] campos;
        for (String campo : campos = StringUtil.getValores(xmlCampos, "componente")) {
            Componente c = null;
            try {
                c = (Componente)Class.forName(StringUtil.getValor(campo, "tipo")).newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (c == null) {
                ParserExportacaoAlvaro.escreveLinhaResultado(xml, campo, ignorarRotulo);
                continue;
            }
            if (c instanceof Rotulo && ignorarRotulo) continue;
            if (c instanceof Campo || c instanceof Expressao) {
                Registro reg = new Registro();
                reg.setValor(TAG_CODIGO, StringUtil.getValor(campo, TAG_NOME));
                reg.setValor(TAG_DESCRICAO, StringUtil.getValor(campo, TAG_NOME));
                reg.setValor(TAG_UNIDADE, StringUtil.getValor(campo, TAG_UNIDADE));
                xml.escreveTag(TAG_LINHA, true, reg, TAG_CODIGO, TAG_DESCRICAO, TAG_UNIDADE);
                continue;
            }
            if (!(c instanceof Texto) || Funcoes.textoVazio(StringUtil.getValor(campo, "texto"))) continue;
            String valor = StringUtil.getValor(campo, "texto");
            String texto = "";
            if (valor.toLowerCase().indexOf("<![cdata[") >= 0 && valor.toLowerCase().indexOf("]]>") >= 0) {
                texto = valor.substring(valor.toLowerCase().indexOf("<![cdata[") + 9, valor.toLowerCase().indexOf("]]>"));
            }
            Registro reg = new Registro();
            reg.setValor(TAG_CODIGO, StringUtil.getValor(campo, TAG_NOME));
            reg.setValor(TAG_DESCRICAO, texto);
            reg.setValor(TAG_UNIDADE, StringUtil.getValor(campo, TAG_UNIDADE));
            xml.escreveTag(TAG_LINHA, true, reg, TAG_CODIGO, TAG_DESCRICAO, TAG_UNIDADE);
        }
    }

    private static void escreveLinhaResultado(EscreverXML xml, String campo, boolean ignorarRotulo) {
        if (StringUtil.getValor(campo, "tipo").toUpperCase().equalsIgnoreCase("CAMPO") || StringUtil.getValor(campo, "tipo").toUpperCase().equalsIgnoreCase("EXPRESSAO")) {
            Registro reg = new Registro();
            reg.setValor(TAG_CODIGO, StringUtil.getValor(campo, TAG_NOME).toLowerCase());
            reg.setValor(TAG_DESCRICAO, StringUtil.getValor(campo, TAG_NOME).toLowerCase());
            reg.setValor(TAG_UNIDADE, StringUtil.getValor(campo, TAG_UNIDADE));
            xml.escreveTag(TAG_LINHA, true, reg, TAG_CODIGO, TAG_DESCRICAO, TAG_UNIDADE);
        } else if (StringUtil.getValor(campo, "tipo").equalsIgnoreCase("TEXTO") && !Funcoes.textoVazio(StringUtil.getValor(campo, "texto")) && !ignorarRotulo) {
            String valor = StringUtil.getValor(campo, "texto");
            String texto = "";
            if (valor.toLowerCase().indexOf("<![cdata[") >= 0 && valor.toLowerCase().indexOf("]]>") >= 0) {
                texto = valor.substring(valor.toLowerCase().indexOf("<![cdata[") + 9, valor.toLowerCase().indexOf("]]>"));
            }
            Registro reg = new Registro();
            reg.setValor(TAG_CODIGO, StringUtil.getValor(campo, TAG_NOME));
            reg.setValor(TAG_DESCRICAO, texto);
            reg.setValor(TAG_UNIDADE, StringUtil.getValor(campo, TAG_UNIDADE));
            xml.escreveTag(TAG_LINHA, true, reg, TAG_CODIGO, TAG_DESCRICAO, TAG_UNIDADE);
        }
    }

    private static void escrevesSolicitacoes(EscreverXML xml, List<Registro> solicitacoes) {
        for (Registro solicitacao : solicitacoes) {
            xml.escreveTag("solicitacao", false, solicitacao, TAG_CODIGO, TAG_CODIGO_AOL, TAG_CODIGO_LIS, "paciente");
            List amostras = solicitacao.getValor("amostras", List.class);
            xml.abreTag("amostras");
            for (Registro amostra : amostras) {
                xml.escreveTag("amostra", true, amostra, TAG_CODIGO, TAG_IDENTIFICACAO, TAG_DESCRICAO, TAG_MATERIAL);
            }
            xml.fechaTag("amostras");
            Map exames = solicitacao.getValor("exames", Map.class);
            for (String key : exames.keySet()) {
                Registro exame = (Registro)exames.get(key);
                xml.escreveTag("exame", false, exame, TAG_CODIGO, TAG_DATARESULTADO, TAG_METODO, TAG_OBSERVACAO, TAG_NORMAL);
                List resultados = exame.getValor(TAG_RESULTADOS, List.class);
                for (Registro resultado : resultados) {
                    xml.escreveTag(TAG_RESULTADO, !resultado.possuiCampo(TAG_CAMPOS_COMPLEMENTARES), resultado, "amostra", TAG_LINHA_RESULTADO, TAG_RESULTADO, TAG_ID_LIS);
                    if (!resultado.possuiCampo(TAG_CAMPOS_COMPLEMENTARES)) continue;
                    List camposcomplementares = resultado.getValor(TAG_CAMPOS_COMPLEMENTARES, List.class);
                    xml.abreTag(TAG_CAMPOS_COMPLEMENTARES);
                    Iterator iterator = camposcomplementares.iterator();
                    while (iterator.hasNext()) {
                        Registro campo = (Registro)iterator.next();
                        xml.escreveTag(TAG_CAMPO_COMPLEMENTAR, true, campo, TAG_CODIGO, TAG_RESULTADO);
                    }
                    xml.fechaTag(TAG_CAMPOS_COMPLEMENTARES);
                    xml.fechaTag(TAG_RESULTADO);
                }
                if (exame.possuiCampo(TAG_ANTIBIOGRAMA)) {
                    Registro antibiograma = exame.getValor(TAG_ANTIBIOGRAMA, Registro.class);
                    xml.escreveTag(TAG_ANTIBIOGRAMA, false, antibiograma, TAG_ID_LIS);
                    List resultadosAntiBiograma = antibiograma.getValor(TAG_RESULTADOS, List.class);
                    for (Registro res : resultadosAntiBiograma) {
                        xml.escreveTag(TAG_RESULTADO, true, res, TAG_ANTIBIOTICO, TAG_HALO, TAG_RESISTENCIA);
                    }
                    xml.fechaTag(TAG_ANTIBIOGRAMA);
                }
                if (exame.possuiCampo(TAG_CURVAS)) {
                    List curvas = exame.getValor(TAG_CURVAS, List.class);
                    xml.abreTag(TAG_CURVAS);
                    for (Registro reg : curvas) {
                        xml.escreveTag(TAG_CURVA, true, reg, TAG_ID, TAG_PONTOS);
                    }
                    xml.fechaTag(TAG_CURVAS);
                }
                xml.fechaTag("exame");
            }
            xml.fechaTag("solicitacao");
        }
    }

    private static void escrevePacientes(EscreverXML xml, Map<String, Registro> map, String tag) {
        xml.abreTag(tag);
        for (String key : map.keySet()) {
            xml.escreveTag("paciente", true, map.get(key), TAG_CODIGO, TAG_CODIGO_LIS, TAG_CODIGO_AOL, TAG_DATANASC, TAG_NOME, TAG_SEXO);
        }
        xml.fechaTag(tag);
    }

    private static void escreveMateriais(EscreverXML xml, Map<String, Registro> map, String tag) {
        xml.abreTag(tag);
        for (String key : map.keySet()) {
            xml.escreveTag(TAG_MATERIAL, true, map.get(key), TAG_CODIGO, TAG_DESCRICAO);
        }
        xml.fechaTag(tag);
    }

    @Deprecated
    private static Registro geraRegistro(List<String> requisicoes, boolean ignorarRotulo) throws SQLException {
        Statement st = Conexao.getStatement();
        StringBuilder resultados = new StringBuilder("Select ");
        resultados.append(" a.exa_codigo, ");
        resultados.append(" a.mco_codigo, ");
        resultados.append(" a.exr_obs, ");
        resultados.append(" pegaResultadoExame(a.fil_codigo, a.req_codigo, a.exa_codigo, a.mco_codigo) as exr_resultado, ");
        resultados.append(" a.exr_dataassina, ");
        resultados.append(" a.exr_codigoexterno, ");
        resultados.append(" b.req_codigo, ");
        resultados.append(" b.req_codigoexterno, ");
        resultados.append(" d.elm_formato, ");
        resultados.append(" e.mco_descricao, ");
        resultados.append(" f.met_codigo, ");
        resultados.append(" f.met_descricao, ");
        resultados.append(" g.pac_codigo, ");
        resultados.append(" g.pac_datanasc, ");
        resultados.append(" g.pac_nome, ");
        resultados.append(" g.pac_sexo, ");
        resultados.append(" g.pac_codigoexterno, ");
        resultados.append(" h.exa_codigo, ");
        resultados.append(" h.exa_descricao ");
        boolean codigoapoiado = DBUtil.campoExiste(st, "examerequisicao", "exr_codigoapoiado");
        if (codigoapoiado) {
            resultados.append(", a.exr_codigoapoioado ");
        }
        resultados.append(" from examerequisicao a ");
        resultados.append(" join requisicao b on a.req_codigo = b.req_codigo ");
        resultados.append(" join examematcoleta c on a.exa_codigo = c.exa_codigo and a.mco_codigo = c.mco_codigo ");
        resultados.append(" join examelayoutmetodo d on a.exa_codigo = d.exa_codigo and a.mco_codigo = d.mco_codigo and a.met_codigo = d.met_codigo ");
        resultados.append(" join materialcoleta e on a.mco_codigo = e.mco_codigo ");
        resultados.append(" join metodologia f on a.met_codigo = f.met_codigo ");
        resultados.append(" join paciente g on b.pac_codigo = g.pac_codigo ");
        resultados.append(" join exames h on a.exa_codigo = h.exa_codigo ");
        resultados.append(" order by g.pac_codigo, b.req_codigo, ");
        if (codigoapoiado) {
            resultados.append(", a.exr_codigoapoioado ");
        }
        resultados.append(" a.exa_codigo, a.mco_codigo ");
        ResultSet rs = Conexao.executeQuery(st, resultados.toString());
        Registro lote = new Registro();
        Registro solicitacao = null;
        List<Registro> amostras = new LinkedList<Registro>();
        HashMap<String, Registro> pacientes = new HashMap<String, Registro>();
        HashMap<String, String> amostrasId = new HashMap<String, String>();
        HashMap<String, Registro> exames = new HashMap<String, Registro>();
        HashMap<String, Registro> materiais = new HashMap<String, Registro>();
        Map<String, Registro> resultadoExame = new HashMap();
        LinkedList<Registro> solicitacoes = new LinkedList<Registro>();
        while (rs.next()) {
            String codigoExame;
            if (rs.getString("exr_resultado") == null || Funcoes.textoVazio(rs.getString("exr_resultado"))) continue;
            if (solicitacao == null || !solicitacao.getString(TAG_CODIGO).equals(rs.getString("req_codigo"))) {
                solicitacao = ParserExportacaoAlvaro.geraRegistroSolicitacao(rs.getInt("req_codigo"), "", rs.getString("req_codigoexterno"), rs.getString("pac_codigo"));
                solicitacao.setValor("exames", new LinkedHashMap());
                solicitacao.setValor("amostras", new LinkedList());
                resultadoExame = solicitacao.getValor("exames", Map.class);
                amostras = solicitacao.getValor("amostras", List.class);
                solicitacoes.add(solicitacao);
                amostrasId = new HashMap();
            }
            if (codigoapoiado && !Funcoes.textoVazio(rs.getString("exr_codigoapoiado")) && !amostrasId.containsKey(rs.getString("exr_codigoapoiado"))) {
                amostrasId.put(rs.getString("exr_codigoapoiado"), String.valueOf(amostrasId.size()));
                amostras.add(ParserExportacaoAlvaro.geraRegistroAmostra(amostrasId.size() - 1, rs.getString("exr_codigoapoiado"), "basal", rs.getString("mco_codigo")));
                solicitacao.setValor("amostras", amostras);
            }
            if (!pacientes.containsKey(rs.getString("pac_codigo"))) {
                pacientes.put(rs.getString("pac_codigo"), ParserExportacaoAlvaro.geraRegistroPaciente(rs.getInt("pac_codigo"), rs.getString("pac_codigoexterno"), "", rs.getDate("pac_datanasc"), rs.getString("pac_nome"), rs.getString("pac_sexo")));
            }
            if (!materiais.containsKey(rs.getString("mco_codigo"))) {
                materiais.put(rs.getString("mco_codigo"), ParserExportacaoAlvaro.geraRegistroMaterial(rs.getInt("mco_codigo"), rs.getString("mco_descricao")));
            }
            if (!exames.containsKey(codigoExame = String.format(MASCARA_EXAME, rs.getString("exa_codigo"), rs.getString("mco_codigo")))) {
                exames.put(codigoExame, ParserExportacaoAlvaro.geraRegistroExame(codigoExame, rs, ignorarRotulo));
            }
            if (!resultadoExame.containsKey(codigoExame)) {
                resultadoExame.put(codigoExame, ParserExportacaoAlvaro.geraRegistroResultadoExame(codigoExame, rs.getDate("exr_dataassina"), rs.getString("met_descricao"), rs.getString("exr_obs"), "", rs, amostrasId, codigoapoiado, ignorarRotulo));
            }
            lote.setValor("solicitacoes", solicitacoes);
        }
        lote.setValor("pacientes", pacientes);
        lote.setValor("materiais", materiais);
        lote.setValor("exames", exames);
        return lote;
    }

    public static Registro geraRegistroSolicitacao(Integer codigo, String codigoAol, String codigoLis, String codigoPaciente) {
        Registro solicitacao = new Registro();
        solicitacao.setValor(TAG_CODIGO, codigo);
        solicitacao.setValor(TAG_CODIGO_AOL, codigoAol);
        solicitacao.setValor(TAG_CODIGO_LIS, codigoLis);
        solicitacao.setValor("paciente", codigoPaciente);
        return solicitacao;
    }

    public static Registro geraRegistroResultadoExame(String codigoExame, Date dataResultado, String metodo, String observacao, String normal, ResultSet rs, Map<String, String> amostrasId, boolean codigoapoiado, boolean ignorarRotulo) throws SQLException {
        Registro exame = new Registro();
        exame.setValor(TAG_CODIGO, codigoExame);
        exame.setValor(TAG_DATARESULTADO, dataResultado);
        exame.setValor(TAG_METODO, metodo);
        exame.setValor(TAG_OBSERVACAO, observacao != null ? observacao : "");
        exame.setValor(TAG_NORMAL, normal);
        exame.setValor(TAG_RESULTADOS, ParserExportacaoAlvaro.geraRegistroLinhasResultados(rs, amostrasId, codigoapoiado, ignorarRotulo));
        return exame;
    }

    private static List<Registro> geraRegistroCurvas(ResultSet rs) {
        LinkedList<Registro> curvas = new LinkedList<Registro>();
        Registro reg = new Registro();
        reg.setValor(TAG_ID, 1);
        reg.setValor(TAG_PONTOS, "B00190;00012C;00012C;000064;000064;000064;000000");
        curvas.add(reg);
        return curvas;
    }

    private static Registro geraRegistroAntibiograma(ResultSet rs) {
        Registro antibiograma = new Registro();
        antibiograma.setValor(TAG_ID_LIS, "");
        LinkedList<Registro> resultadosAntiBiograma = new LinkedList<Registro>();
        Registro res = new Registro();
        res.setValor(TAG_ANTIBIOTICO, "CIPROFLOXACINA");
        res.setValor(TAG_HALO, 26);
        res.setValor(TAG_RESISTENCIA, "R");
        resultadosAntiBiograma.add(res);
        resultadosAntiBiograma.add(res);
        antibiograma.setValor(TAG_RESULTADOS, resultadosAntiBiograma);
        return antibiograma;
    }

    private static List<Registro> geraRegistroLinhasResultados(ResultSet rs, Map<String, String> amostrasId, boolean codigoapoiado, boolean ignorarRotulo) throws SQLException {
        LinkedList<Registro> resultados = new LinkedList<Registro>();
        Map<String, Object> campos = Resultado.getCamposResultado(rs.getString("exr_resultado"));
        for (String key : campos.keySet()) {
            Registro resultado = new Registro();
            if (codigoapoiado && !Funcoes.textoVazio(rs.getString("exr_codigoapoiado")) && amostrasId.containsKey(rs.getString("exr_codigoapoiado"))) {
                resultado.setValor("amostra", amostrasId.get(rs.getString("exr_codigoapoiado")));
            } else {
                resultado.setValor("amostra", 0);
            }
            if (key.toLowerCase().startsWith("rotulo") && ignorarRotulo) continue;
            resultado.setValor(TAG_LINHA_RESULTADO, key);
            resultado.setValor(TAG_RESULTADO, campos.get(key));
            resultado.setValor(TAG_ID_LIS, rs.getString("exr_codigoexterno"));
            resultados.add(resultado);
        }
        return resultados;
    }

    private static Registro geraRegistroAmostra(Integer codigo, String identificacao, String descricao, String material) {
        Registro amostra = new Registro();
        amostra.setValor(TAG_CODIGO, codigo);
        amostra.setValor(TAG_IDENTIFICACAO, identificacao);
        amostra.setValor(TAG_DESCRICAO, descricao);
        amostra.setValor(TAG_MATERIAL, material);
        return amostra;
    }

    public static Registro geraRegistroMaterial(Integer codigo, String descricao) {
        Registro r = new Registro();
        r.setValor(TAG_CODIGO, codigo);
        r.setValor(TAG_DESCRICAO, descricao);
        return r;
    }

    public static Registro geraRegistroPaciente(Integer codigo, String codigoLis, String codigoAol, Date datanasc, String nome, String sexo) {
        Registro r = new Registro();
        r.setValor(TAG_CODIGO, codigo);
        r.setValor(TAG_CODIGO_LIS, codigoLis);
        r.setValor(TAG_CODIGO_AOL, codigoAol);
        r.setValor(TAG_DATANASC, datanasc != null ? datanasc : "");
        r.setValor(TAG_NOME, nome);
        r.setValor(TAG_SEXO, sexo);
        return r;
    }

    public static Registro geraRegistroExame(String codigoExame, ResultSet rs, boolean ignorarRotulo) throws SQLException {
        String[] campos;
        Registro r = new Registro();
        String dataAlteracao = null;
        if (Funcoes.textoVazio(StringUtil.getValor(rs.getString("elm_formato"), TAG_DATA_ALTERACAO))) {
            dataAlteracao = Funcoes.formataData(MASCARA_DATA, Calendar.getInstance().getTime());
        } else {
            Funcoes.formataData(MASCARA_DATA, StringUtil.getValor(rs.getString("elm_formato"), TAG_DATA_ALTERACAO));
        }
        r.setValor(TAG_CODIGO, codigoExame);
        r.setValor(TAG_DESCRICAO, rs.getString("exa_descricao"));
        r.setValor(TAG_DATA_ALTERACAO, dataAlteracao);
        String[] linhas = StringUtil.getValores(rs.getString("elm_formato"), "componente");
        HashMap<String, Registro> linhasResultado = new HashMap<String, Registro>();
        for (String linha : linhas) {
            if (ignorarRotulo && StringUtil.getValor(linha, "tipo").equalsIgnoreCase("texto")) continue;
            linhasResultado.put(StringUtil.getValor(linha, TAG_NOME), ParserExportacaoAlvaro.geraLinhaResultado(StringUtil.getValor(linha, TAG_NOME), StringUtil.getValor(linha, TAG_NOME), StringUtil.getValor(linha, TAG_UNIDADE)));
        }
        r.setValor(TAG_LINHAS_RESULTADO, linhasResultado);
        if (!Funcoes.textoVazio(StringUtil.getValor(rs.getString("elm_formato"), TAG_VALOR_REFERENCIA))) {
            r.setValor(TAG_VALOR_REFERENCIA, StringUtil.getValor(rs.getString("elm_formato"), TAG_VALOR_REFERENCIA));
        }
        HashMap<String, Registro> camposComplementares = new HashMap<String, Registro>();
        for (String campo : campos = StringUtil.getValores(rs.getString("elm_formato"), TAG_CAMPO_COMPLEMENTAR)) {
            camposComplementares.put(StringUtil.getValor(campo, TAG_CODIGO), ParserExportacaoAlvaro.geraRegistroComplementar(StringUtil.getInt(campo, TAG_CODIGO), StringUtil.getValor(campo, TAG_LABEL), StringUtil.getValor(campo, TAG_LISTALAUDO)));
        }
        r.setValor(TAG_CAMPOS_COMPLEMENTARES, camposComplementares);
        return r;
    }

    private static Registro geraRegistroComplementar(Integer codigo, String label, String listaLaudo) {
        Registro campoComplementar = new Registro();
        campoComplementar.setValor(TAG_CODIGO, codigo);
        campoComplementar.setValor(TAG_LABEL, label);
        campoComplementar.setValor(TAG_LISTALAUDO, listaLaudo);
        return campoComplementar;
    }

    private static Registro geraLinhaResultado(String codigo, String descricao, String unidade) {
        Registro linha = new Registro();
        linha.setValor(TAG_CODIGO, codigo.toLowerCase());
        linha.setValor(TAG_DESCRICAO, descricao.toLowerCase());
        linha.setValor(TAG_UNIDADE, unidade);
        return linha;
    }

    private static void escreveExames(EscreverXML xml, Map<String, Registro> map) {
        for (String key : map.keySet()) {
            xml.escreveTag("exame", false, map.get(key), TAG_CODIGO, TAG_DESCRICAO, TAG_DATA_ALTERACAO);
            Map linhasResultado = map.get(key).getValor(TAG_LINHAS_RESULTADO, HashMap.class);
            xml.abreTag(TAG_LINHAS_RESULTADO);
            for (String keyLinha : linhasResultado.keySet()) {
                xml.escreveTag(TAG_LINHA, true, (Registro)linhasResultado.get(keyLinha), TAG_CODIGO, TAG_DESCRICAO, TAG_UNIDADE);
            }
            xml.fechaTag(TAG_LINHAS_RESULTADO);
            xml.escreveCDATA(TAG_VALOR_REFERENCIA, map.get(key).getString(TAG_VALOR_REFERENCIA));
            xml.abreTag(TAG_CAMPOS_COMPLEMENTARES);
            Map camposComplementares = map.get(key).getValor(TAG_CAMPOS_COMPLEMENTARES, HashMap.class);
            for (String keyComplementar : camposComplementares.keySet()) {
                xml.escreveTag(TAG_CAMPO_COMPLEMENTAR, true, (Registro)camposComplementares.get(keyComplementar), TAG_CODIGO, TAG_LABEL, TAG_LISTALAUDO);
            }
            xml.fechaTag(TAG_CAMPOS_COMPLEMENTARES);
            xml.fechaTag("exame");
        }
    }
}

