/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.exportacao.externo;

import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.Map;

class EscreverXML {
    private StringBuilder writer;

    public EscreverXML(String nomeArquivo) {
        try {
            this.writer = new StringBuilder();
            this.cabecalhoXML(this.writer);
        }
        catch (IOException e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
        }
    }

    public EscreverXML() {
        try {
            this.writer = new StringBuilder();
            this.cabecalhoXML(this.writer);
        }
        catch (IOException e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
        }
    }

    private void cabecalhoXML(StringBuilder buffer) throws IOException {
        buffer.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n");
    }

    private void escrever(String texto, boolean quebra) {
        if (this.writer == null) {
            ErrorLogger.mostraMensagem(null, "O arquivo n\u00e3o pode ser escrito, pois n\u00e3o foi aberto", null, "ParserExportacaoAlvaro");
        } else {
            this.writer.append(texto);
            if (quebra) {
                this.writer.append('\n');
            }
        }
    }

    protected void escrever(String texto) {
        this.escrever(texto, true);
    }

    protected void abreTag(String texto) {
        this.escrever(String.format("<%s>", texto), true);
    }

    protected void escreveCDATA(String tag, String texto) {
        this.escrever(String.format("<%s><![CDATA[\n%s\n]]></%s>", tag, texto, tag), true);
    }

    protected void escreveTag(String tag, boolean fecha, Map<String, String> atributos) {
        StringBuilder sb = new StringBuilder();
        sb.append("<").append(tag).append(" ");
        for (String key : atributos.keySet()) {
            if (Funcoes.textoVazio(atributos.get(key).trim())) continue;
            sb.append(key).append("=\"").append(this.setAtributo(atributos.get(key).toUpperCase())).append("\" ");
        }
        if (fecha) {
            sb.append("/");
        }
        sb.append(">");
        this.escrever(sb.toString(), true);
    }

    protected void escreveTag(String tag, boolean fecha, Registro reg, String ... atributos) {
        StringBuilder sb = new StringBuilder();
        sb.append("<").append(tag).append(" ");
        for (String atributo : atributos) {
            Object valor = reg.getValor(atributo.toUpperCase());
            if (valor == null) {
                valor = reg.getValor(atributo);
            }
            if (valor == null) continue;
            sb.append(atributo).append("=\"").append(this.setAtributo(valor)).append("\" ");
        }
        if (fecha) {
            sb.append("/");
        }
        sb.append(">");
        this.escrever(sb.toString(), true);
    }

    protected void escreveTag(String tag, boolean fecha, ResultSet res, String ... atributos) throws SQLException {
        StringBuilder sb = new StringBuilder();
        sb.append("<").append(tag).append(" ");
        for (String atributo : atributos) {
            if (res.getObject(atributo) == null) continue;
            sb.append(atributo).append("=\"").append(this.setAtributo(res.getObject(atributo))).append("\" ");
        }
        if (fecha) {
            sb.append("/");
        }
        sb.append(">");
        this.escrever(sb.toString(), true);
    }

    private String setAtributo(Object valor) {
        String valorAtt = valor instanceof Date ? Funcoes.formataData("dd/MM/yyyy HH:mm:ss", (Date)valor) : (valor instanceof Integer ? String.valueOf((Integer)valor) : (valor instanceof Double ? String.valueOf((Double)valor) : (String)valor));
        return EscreverXML.textoXML(valorAtt.replace('\"', ' '));
    }

    private static String textoXML(String texto) {
        StringBuilder bui = new StringBuilder();
        if (texto != null) {
            block7: for (int i = 0; i < texto.length(); ++i) {
                switch (texto.charAt(i)) {
                    case '<': {
                        bui.append("&lt;");
                        continue block7;
                    }
                    case '>': {
                        bui.append("&gt;");
                        continue block7;
                    }
                    case '\"': {
                        bui.append("&quot;");
                        continue block7;
                    }
                    case '\'': {
                        bui.append("&apos;");
                        continue block7;
                    }
                    case '&': {
                        bui.append("&amp;");
                        continue block7;
                    }
                    default: {
                        bui.append(texto.charAt(i));
                    }
                }
            }
        }
        return bui.toString();
    }

    protected void fechaTag(String texto) {
        this.escrever(String.format("</%s>", texto), true);
    }

    public void fecharArquivo() {
        if (this.writer == null) {
            ErrorLogger.mostraMensagem(null, "N\u00e3o \u00e9 possivel fechar o arquivo, pois n\u00e3o est\u00e1 aberto", null, "ParserExportacaoAlvaro (935)");
        }
    }

    public String fecharXML() {
        String retorno = "";
        if (this.writer == null) {
            ErrorLogger.mostraMensagem(null, "N\u00e3o \u00e9 possivel fechar o xml, pois n\u00e3o est\u00e1 aberto", null, "ParserExportacaoAlvaro (954)");
        } else {
            retorno = this.writer.toString();
            this.writer = null;
        }
        return retorno;
    }

    public void cancelar() {
        if (this.writer != null) {
            this.writer.setLength(0);
        }
    }
}

