/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.exportacao.dialsist;

import jalis.comum.ParametrosUsuarios;
import jalis.comum.Variaveis;
import jalis.laboratorio.digitacao.Resultado;
import jalis.laboratorio.exportacao.dialsist.ConfiguracaoDialSist;
import jalis.laboratorio.exportacao.dialsist.DialSistService;
import jalis.laboratorio.exportacao.dialsist.TipoDados;
import jalis.util.CheckItemFiltro;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.SplashMensagem;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;

public class ExportarResultadoDialSist
extends JPanel
implements ActionListener,
ListSelectionListener {
    private static final long ACESSO = Long.parseLong("0910001500");
    private final int COLUNA_EXAMES = 2;
    private static String tagConfiguracao = "configuracao";
    private CheckItemFiltro itemColeta;
    private CheckItemFiltro itemConvenio;
    private CheckItemFiltro itemDestino;
    private CheckItemFiltro itemExame;
    private TTextField textDataIni = new TTextField(0, 4);
    private TTextField textDataFin = new TTextField(0, 4);
    private JLabel labelDataIni = new JLabel("Data Inicial:");
    private JLabel labelDataFin = new JLabel("Data Final:");
    private JButton buttonDataIni = ComponenteFactory.novoJButton(this, null, new Dimension(20, 20), true);
    private JButton buttonDataFin = ComponenteFactory.novoJButton(this, null, new Dimension(20, 20), true);
    private JButton buttonConsultar = ComponenteFactory.novoJButton("Consultar", 'C', this, null, null);
    private JButton buttonNovo = ComponenteFactory.novoJButton("Novo", 'N', this, null, null);
    private JButton buttonExportar = ComponenteFactory.novoJButton("Exportar", 'E', this, null, null);
    private JButton buttonFechar = ComponenteFactory.novoJButton("Fechar", 'F', this, null, null);
    private JButton buttonConfigurar = ComponenteFactory.novoJButton("Configurar", 'F', this, null, null);
    private JPanel panelRequisicoes = new JPanel(new BorderLayout());
    private JPanel panelExames = new JPanel(new BorderLayout());
    private JSplitPane splitCentral = new JSplitPane(1, this.panelRequisicoes, this.panelExames);
    private ModeloGridTable modeloRequisicoes = new ModeloGridTable(new String[]{"Requisi\u00e7\u00e3o", "Paciente"});
    private DefaultTableCellRenderer rendererRequisicoes = null;
    private DefaultTableCellRenderer rendererExames = null;
    private DefaultTableCellRenderer rendererOutrosExames = null;
    private JTable tableRequisicoes = ComponenteFactory.novoJTable((TableModel)this.modeloRequisicoes, (ListSelectionListener)this, 70, 0);
    private JScrollPane scrollRequisicoes = new JScrollPane(this.tableRequisicoes);
    private ModeloGridTable modeloExames = new ModeloGridTable(new String[]{"C\u00f3d.", "Mat.", "Exame", "Sit."});
    private ModeloGridTable modeloOutrosExames = new ModeloGridTable(new String[]{"C\u00f3d.", "Mat.", "Exame", "Sit."});
    private JTable tableExames = ComponenteFactory.novoJTable((TableModel)this.modeloExames, null, 50, 30, 0, 20);
    private JTable tableOutrosExames = ComponenteFactory.novoJTable((TableModel)this.modeloOutrosExames, null, 50, 30, 0, 20);
    private JScrollPane scrollExames = new JScrollPane(this.tableExames);
    private JScrollPane scrollOutrosExames = new JScrollPane(this.tableOutrosExames);
    private int posicaoDivisor = 350;
    private JLabel labelPacienteSemCPF = new JLabel("Paciente sem N\u00ba do CPF informado");
    private JLabel labelExportado = new JLabel("Exportado");
    private JLabel labelSemConfiguracao = new JLabel("Sem Configura\u00e7\u00e3o");
    private static final String EXIBIR_EXAMES = "ExportarResultadoTexto.exibirExames";
    private static final String POSICAO_DIVISOR = "ExportarResultadoTexto.posicaoDivisor";
    private static final String ULTIMO_FILTRO = "ExportarResultadoTexto.ultimoFiltro";
    private String configuracao = new String();
    private final int COLUNA_REQ_CODIGO = 0;
    private final int COLUNA_REQ_NOME = 1;
    private final int COLUNA_REQ_EXAMES = 2;
    private final int COLUNA_REQ_OUTROSEXAMES = 3;
    private final int COLUNA_PAC_CPF = 4;
    private boolean codigoSelecionado;

    public ExportarResultadoDialSist() {
        this.montaTela();
        this.tableRequisicoes.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127 && ExportarResultadoDialSist.this.tableRequisicoes.getSelectedRow() > -1) {
                    ExportarResultadoDialSist.this.excluirRequisicao();
                }
            }
        });
    }

    private void montaTela() {
        this.setLayout(new BorderLayout());
        Funcoes.criaBarraDescricao(this, "Exportar resultados DialSist", "Exporta\u00e7\u00e3o de resultados em arquivos txt para o sistema DialSist", "integracao/export_result_dialsist.jpg");
        Funcoes.montaEnter((JComponent)this);
        Dimension dimensionFiltro = new Dimension(180, 20);
        Dimension dimensionText = new Dimension(90, 20);
        Dimension dimensionButton = new Dimension(20, 20);
        JPanel panelAux = new JPanel();
        panelAux.setLayout(new BorderLayout());
        this.add((Component)panelAux, "Center");
        JPanel panel = new JPanel();
        panelAux.add((Component)panel, "North");
        panel.setBorder(BorderFactory.createTitledBorder("Filtro"));
        panel.setLayout(new GridBagLayout());
        this.itemColeta = new CheckItemFiltro("Coleta", "Filtrar", "Filtrando coletas", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemColeta.setDados("coletas", new String[]{"col_codigo", "col_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemColeta.setColunaHint(1);
        this.itemColeta.setPreferredSize(dimensionFiltro);
        this.itemColeta.setMinimumSize(dimensionFiltro);
        this.itemConvenio = new CheckItemFiltro("Conv\u00eanio", "Filtrar", "Filtrando conv\u00eanios", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemConvenio.setDados("convenios", new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Fantasia"}, new int[]{70, 0});
        this.itemConvenio.setColunaHint(1);
        this.itemConvenio.setPreferredSize(dimensionFiltro);
        this.itemConvenio.setMinimumSize(dimensionFiltro);
        this.itemExame = new CheckItemFiltro("Exame", "Filtrar", "Filtrando exames", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemExame.setDados("exames", new String[]{"exa_codigo", "exa_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemExame.setColunaHint(1);
        this.itemExame.setPreferredSize(dimensionFiltro);
        this.itemExame.setMinimumSize(dimensionFiltro);
        this.itemDestino = new CheckItemFiltro("Destino", "Filtrar", "Filtrando destinos", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemDestino.setDados("destino", new String[]{"des_codigo", "des_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemDestino.setColunaHint(1);
        this.itemDestino.setPreferredSize(dimensionFiltro);
        this.itemDestino.setMinimumSize(dimensionFiltro);
        Insets insetsNormal = new Insets(0, 0, 0, 0);
        Insets insetsEsquerda = new Insets(0, 20, 0, 0);
        GridBagConstraints cons = new GridBagConstraints();
        cons.anchor = 17;
        cons.fill = 0;
        cons.gridheight = 1;
        cons.gridwidth = 1;
        cons.gridx = 0;
        cons.gridy = 0;
        cons.insets = insetsNormal;
        cons.weightx = 0.0;
        cons.weighty = 0.0;
        panel.add((Component)this.itemColeta, cons);
        ++cons.gridx;
        cons.insets = insetsEsquerda;
        panel.add((Component)this.itemDestino, cons);
        ++cons.gridx;
        panel.add((Component)this.labelDataIni, cons);
        ++cons.gridx;
        cons.insets = insetsNormal;
        this.textDataIni.setPreferredSize(dimensionText);
        this.textDataIni.setMinimumSize(dimensionText);
        panel.add((Component)this.textDataIni, cons);
        ++cons.gridx;
        this.buttonDataIni.setPreferredSize(dimensionButton);
        this.buttonDataFin.setPreferredSize(dimensionButton);
        panel.add((Component)this.buttonDataIni, cons);
        ++cons.gridy;
        cons.gridx = 0;
        panel.add((Component)this.itemConvenio, cons);
        ++cons.gridx;
        cons.insets = insetsEsquerda;
        panel.add((Component)this.itemExame, cons);
        ++cons.gridx;
        panel.add((Component)this.labelDataFin, cons);
        ++cons.gridx;
        cons.insets = insetsNormal;
        this.textDataFin.setPreferredSize(dimensionText);
        this.textDataFin.setMinimumSize(dimensionText);
        panel.add((Component)this.textDataFin, cons);
        ++cons.gridx;
        this.buttonDataIni.setPreferredSize(dimensionButton);
        this.buttonDataFin.setPreferredSize(dimensionButton);
        panel.add((Component)this.buttonDataFin, cons);
        cons.gridx += 3;
        cons.gridwidth = 3;
        cons.anchor = 13;
        cons.fill = 0;
        cons.weightx = 1.0;
        panel.add((Component)this.buttonConsultar, cons);
        panelAux.add((Component)this.splitCentral, "Center");
        this.splitCentral.setBorder(null);
        this.splitCentral.setDividerSize(3);
        this.splitCentral.setDividerLocation(this.posicaoDivisor);
        panelAux = new JPanel(new FlowLayout(2, 3, 3));
        JPanel panelConfigurar = new JPanel(new FlowLayout(2, 3, 3));
        JPanel panelBotao = new JPanel(new BorderLayout());
        panelAux.add(this.buttonNovo);
        panelAux.add(this.buttonExportar);
        panelAux.add(this.buttonFechar);
        panelConfigurar.add(this.buttonConfigurar);
        panelBotao.add((Component)panelConfigurar, "West");
        panelBotao.add((Component)panelAux, "Center");
        this.add((Component)panelBotao, "South");
        Font font = new Font(this.labelExportado.getFont().getName(), 0, 10);
        this.panelRequisicoes.setBorder(BorderFactory.createTitledBorder("Requisi\u00e7\u00f5es"));
        JPanel pnlCorLegendaSemCpf = new JPanel();
        pnlCorLegendaSemCpf.setPreferredSize(new Dimension(10, 10));
        pnlCorLegendaSemCpf.setBackground(Color.orange);
        this.labelPacienteSemCPF.setFont(font);
        this.panelRequisicoes.add((Component)this.scrollRequisicoes, "Center");
        JPanel panelSemCpf = new JPanel(new FlowLayout(0, 3, 3));
        panelSemCpf.add(pnlCorLegendaSemCpf);
        panelSemCpf.add(this.labelPacienteSemCPF);
        this.panelRequisicoes.add((Component)panelSemCpf, "South");
        this.panelExames.setBorder(BorderFactory.createTitledBorder("Exames"));
        this.panelExames.add((Component)this.scrollExames, "Center");
        JPanel panelOutrosExames = new JPanel(new BorderLayout());
        JPanel panelLabel = new JPanel(new FlowLayout(0, 3, 3));
        JPanel pnlCorLegenda = new JPanel();
        pnlCorLegenda.setPreferredSize(new Dimension(10, 10));
        pnlCorLegenda.setBackground(Color.green);
        this.labelExportado.setFont(font);
        this.labelSemConfiguracao.setFont(font);
        panelOutrosExames.setPreferredSize(new Dimension(300, 200));
        panelOutrosExames.add((Component)this.scrollOutrosExames, "Center");
        panelLabel.add(pnlCorLegenda);
        panelLabel.add(this.labelExportado);
        JPanel pnlCorLegendaConf = new JPanel();
        pnlCorLegendaConf.setPreferredSize(new Dimension(10, 10));
        pnlCorLegendaConf.setBackground(Color.green);
        pnlCorLegendaConf.setBackground(Color.red);
        panelLabel.add(pnlCorLegendaConf);
        panelLabel.add(this.labelSemConfiguracao);
        panelOutrosExames.add((Component)panelLabel, "South");
        this.panelExames.add((Component)panelOutrosExames, "South");
        this.tableRequisicoes.getColumnModel().getColumn(0).setMinWidth(70);
        this.montaRendereres();
        this.tableExames.setDefaultRenderer(Object.class, this.rendererExames);
        this.tableOutrosExames.setDefaultRenderer(Object.class, this.rendererOutrosExames);
        this.tableRequisicoes.setDefaultRenderer(Object.class, this.rendererRequisicoes);
        this.montaListener();
        this.carregarParametros();
    }

    private void montaRendereres() {
        this.rendererRequisicoes = new DefaultTableCellRenderer(){

            @Override
            public synchronized Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focused, int row, int column) {
                Component c = super.getTableCellRendererComponent(table, value, selected, focused, row, column);
                this.setValue(value);
                if (selected) {
                    this.setForeground(table.getSelectionForeground());
                    this.setBackground(table.getSelectionBackground());
                } else {
                    this.setForeground(table.getForeground());
                    this.setBackground(table.getBackground());
                }
                if (!Funcoes.temNumero(ExportarResultadoDialSist.this.modeloRequisicoes.getValueAt(row, 4).toString())) {
                    c.setBackground(Color.ORANGE);
                }
                if (focused) {
                    Border border = selected ? UIManager.getBorder("Table.focusSelectedCellHighlightBorder") : UIManager.getBorder("Table.focusCellHighlightBorder");
                    ((JComponent)c).setBorder(border);
                    if (!selected && table.isCellEditable(row, column)) {
                        Color col = UIManager.getColor("Table.focusCellForeground");
                        if (col != null) {
                            c.setForeground(col);
                        }
                        if ((col = UIManager.getColor("Table.focusCellBackground")) != null) {
                            c.setBackground(col);
                        }
                    }
                } else {
                    ((JComponent)c).setBorder(noFocusBorder);
                }
                return c;
            }
        };
        this.rendererExames = new DefaultTableCellRenderer(){

            @Override
            public synchronized Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focused, int row, int column) {
                Component c = super.getTableCellRendererComponent(table, value, selected, focused, row, column);
                this.setValue(value);
                if (selected) {
                    this.setForeground(table.getSelectionForeground());
                    this.setBackground(table.getSelectionBackground());
                } else {
                    this.setForeground(table.getForeground());
                    this.setBackground(table.getBackground());
                }
                ArrayList configuracao = (ArrayList)ExportarResultadoDialSist.this.modeloRequisicoes.getValueAt(ExportarResultadoDialSist.this.tableRequisicoes.getSelectedRow(), 3);
                if (configuracao.size() > 0) {
                    for (Registro registro : configuracao) {
                        if (!ExportarResultadoDialSist.this.modeloExames.getLine(row).get("C\u00f3d.").equals(registro.getString("exa_codigo")) || !Funcoes.textoVazio(StringUtil.getValor(registro.getString("xml"), "exportardialsist"))) continue;
                        c.setBackground(Color.RED);
                    }
                }
                return c;
            }
        };
        this.rendererOutrosExames = new DefaultTableCellRenderer(){

            @Override
            public synchronized Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focused, int row, int column) {
                Component c = super.getTableCellRendererComponent(table, value, selected, focused, row, column);
                this.setValue(value);
                if (selected) {
                    this.setForeground(table.getSelectionForeground());
                    this.setBackground(table.getSelectionBackground());
                } else {
                    this.setForeground(table.getForeground());
                    this.setBackground(table.getBackground());
                }
                ArrayList configuracao = (ArrayList)ExportarResultadoDialSist.this.modeloRequisicoes.getValueAt(ExportarResultadoDialSist.this.tableRequisicoes.getSelectedRow(), 3);
                if (configuracao.size() > 0) {
                    for (Registro registro : configuracao) {
                        if (!ExportarResultadoDialSist.this.modeloOutrosExames.getLine(row).get("C\u00f3d.").equals(registro.getString("exa_codigo"))) continue;
                        if (Funcoes.textoVazio(StringUtil.getValor(registro.getString("xml"), "exportardialsist"))) {
                            c.setBackground(Color.RED);
                            continue;
                        }
                        if (Funcoes.textoVazio(registro.getString("exr_datadialsist"))) continue;
                        c.setBackground(Color.GREEN);
                    }
                }
                return c;
            }
        };
    }

    private void montaListener() {
        this.textDataIni.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    ExportarResultadoDialSist.this.buttonDataIni.doClick();
                }
            }
        });
        this.textDataFin.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    ExportarResultadoDialSist.this.buttonDataFin.doClick();
                }
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.buttonFechar) {
            this.setVisible(false);
            if (this.getParent() != null) {
                this.getParent().removeAll();
            }
        } else if (o == this.buttonNovo) {
            this.modeloRequisicoes.clear();
            this.modeloExames.clear();
            this.textDataIni.setText("");
            this.textDataFin.setText("");
            this.itemColeta.clear();
            this.itemConvenio.clear();
            this.itemDestino.clear();
            this.itemExame.clear();
        } else if (o == this.buttonConsultar) {
            this.consultarRequisicoes();
            this.gravarParametros();
        } else if (o == this.buttonExportar) {
            try {
                this.exportar();
            }
            catch (ParseException e1) {
                ErrorLogger.mostraMensagem(this, e1.getMessage(), e1.getStackTrace(), "ExportarResultadoTexto: 278");
            }
        } else if (o == this.buttonDataIni) {
            Funcoes.mostraData(this.textDataIni, this.buttonDataIni, (JPanel)this.buttonDataIni.getParent(), false);
        } else if (o == this.buttonDataFin) {
            Funcoes.mostraData(this.textDataFin, this.buttonDataFin, (JPanel)this.buttonDataFin.getParent(), false);
        } else if (o == this.buttonConfigurar) {
            this.configurarLaboratorio();
        }
    }

    private void configurarLaboratorio() {
        ConfiguracaoDialSist config = ConfiguracaoDialSist.novaInstancia(this.getTopLevelAncestor());
        if (!Funcoes.textoVazio(this.configuracao)) {
            config.setCodigoLaboratorio(StringUtil.getValor(this.configuracao, "codigo"));
            config.setNomeLaboratorio(StringUtil.getValor(this.configuracao, "nome"));
        }
        config.setVisible(true);
        if (config.getOK()) {
            try {
                XMLStringBuilder xml = new XMLStringBuilder();
                xml.abrir(tagConfiguracao);
                xml.escrever("codigo", config.getCodigoLaboratorio());
                xml.escrever("nome", config.getNomeLaboratorio());
                xml.fechar(tagConfiguracao);
                this.configuracao = xml.getXML();
            }
            catch (XMLStringBuilderException e1) {
                ErrorLogger.mostraMensagem(this, e1.getMessage(), e1.getStackTrace(), "ExportarResultadoTexto: 332");
            }
        }
    }

    public static long getModuloAcesso() {
        return ACESSO;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        try {
            this.modeloExames.clear();
            this.modeloOutrosExames.clear();
            if (this.tableRequisicoes.getSelectedRow() > -1 && this.modeloRequisicoes.getValueAt(this.tableRequisicoes.getSelectedRow(), 2) != null && this.modeloRequisicoes.getValueAt(this.tableRequisicoes.getSelectedRow(), 2) instanceof ArrayList) {
                ArrayList exames = (ArrayList)this.modeloRequisicoes.getValueAt(this.tableRequisicoes.getSelectedRow(), 2);
                int i = 0;
                for (Registro r : exames) {
                    ++i;
                    this.modeloExames.addLine(new Object[]{r.getString("exa_codigo"), r.getString("mco_abreviatura"), r.getString("exa_descricao"), r.getString("exr_situacao"), r.getBoolean("enviado")});
                }
                ArrayList outrosExames = (ArrayList)this.modeloRequisicoes.getValueAt(this.tableRequisicoes.getSelectedRow(), 3);
                for (Registro registro : outrosExames) {
                    this.rendererExames.setBackground(Color.RED);
                    this.modeloOutrosExames.addLine(new Object[]{registro.getString("exa_codigo"), registro.getString("mco_abreviatura"), registro.getString("exa_descricao"), registro.getString("exr_situacao"), registro.getBoolean("enviado")});
                }
            }
        }
        catch (Exception e1) {
            ErrorLogger.mostraMensagem(this, e1.getMessage(), e1.getStackTrace(), "ExportarResultadoTexto: 315");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void consultarRequisicoes() {
        SplashMensagem spl = SplashMensagem.getInstancia(this);
        if (!Funcoes.verificaData(this.textDataIni.getText()) || !Funcoes.verificaData(this.textDataFin.getText())) {
            Funcoes.mensagem(this, "Os filtros Data Inicial e Data Final devem ser informados!", 1);
            ScreenUtil.requisitarFoco(this.textDataIni);
            return;
        }
        try {
            this.modeloRequisicoes.clear();
            this.habilitarDesabilitar(false);
            DialSistService dialService = new DialSistService();
            ArrayList<Registro> listaRegistro = dialService.consultaRequisicoes(this.itemColeta.getSelecionados(0), this.itemConvenio.getSelecionados(0), this.itemDestino.getSelecionados(0), this.itemExame.getSelecionados(0), this.textDataIni.getText(), this.textDataFin.getText());
            for (Registro registro : listaRegistro) {
                ArrayList<Registro> exames = dialService.pegaExamesRequisicao(registro.getString("req_codigo"), this.itemExame.getSelecionados());
                ArrayList<Registro> examesRel = new ArrayList<Registro>();
                ArrayList<Registro> examesOutrosRel = new ArrayList<Registro>();
                for (Registro re : exames) {
                    String xmlResultado = dialService.getXmlResultado(registro.getString("req_codigo"), re.getString("exa_codigo"), re.getInt("mco_codigo"));
                    String xml = ExameUtil.pegaRelacionamentoExportaTextoIdade(Variaveis.filialPadrao, registro.getInt("req_idade"), registro.getString("req_anomes"), ExameUtil.getCodigoLayout(Variaveis.filialPadrao, registro.getString("con_codigo"), registro.getString("des_codigo")), re.getString("exa_codigo"), re.getInt("mco_codigo"), re.getString("met_codigo"));
                    re.setValor("xmlResultado", xmlResultado);
                    re.setValor("xml", xml);
                    if (xml.contains("exportardialsist") && (re.getString("exr_situacao").equals("C") || re.getString("exr_situacao").equals("E")) && Funcoes.textoVazio(re.getString("exr_datadialsist"))) {
                        examesRel.add(re);
                        continue;
                    }
                    examesOutrosRel.add(re);
                }
                this.modeloRequisicoes.addLine(new Object[]{registro.getString("req_codigo"), registro.getString("pac_nome"), examesRel, examesOutrosRel, registro.getString("pac_cpf")});
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage() + "\nSQL: ", e.getStackTrace(), "ExportarResultadoTexto: 333");
        }
        finally {
            this.habilitarDesabilitar(true);
            spl.apagar();
        }
    }

    private void carregarParametros() {
        if (ParametrosUsuarios.contemParametro(ULTIMO_FILTRO)) {
            String str = StringUtil.getValor(ParametrosUsuarios.getValor(ULTIMO_FILTRO), "filtro");
            this.setAtributosFiltro(this.itemColeta, StringUtil.getValor(str, "coleta"));
            this.setAtributosFiltro(this.itemConvenio, StringUtil.getValor(str, "convenio"));
            this.setAtributosFiltro(this.itemDestino, StringUtil.getValor(str, "destino"));
            this.setAtributosFiltro(this.itemExame, StringUtil.getValor(str, "exame"));
            this.textDataIni.setText(StringUtil.getValor(str, "dataInicial"));
            this.textDataFin.setText(StringUtil.getValor(str, "dataFinal"));
            this.configuracao = StringUtil.getValor(str, tagConfiguracao);
        }
        if (ParametrosUsuarios.contemParametro(POSICAO_DIVISOR)) {
            this.posicaoDivisor = Integer.parseInt(ParametrosUsuarios.getValor(POSICAO_DIVISOR));
        }
    }

    private void gravarParametros() {
        StringBuilder bui = new StringBuilder();
        bui.append(this.getAtributosFiltro(this.itemColeta, "coleta"));
        bui.append(this.getAtributosFiltro(this.itemConvenio, "convenio"));
        bui.append(this.getAtributosFiltro(this.itemDestino, "destino"));
        bui.append(this.getAtributosFiltro(this.itemExame, "exame"));
        bui.append(StringUtil.getTag("dataInicial", this.textDataIni.getText()));
        bui.append(StringUtil.getTag("dataFinal", this.textDataFin.getText()));
        bui.append(StringUtil.getTag("configuracao", this.configuracao));
        ParametrosUsuarios.setValor(ULTIMO_FILTRO, StringUtil.getTag("filtro", bui.toString()));
        ParametrosUsuarios.setValor(POSICAO_DIVISOR, String.valueOf(this.splitCentral.getDividerLocation()));
    }

    private void habilitarDesabilitar(boolean valor) {
        this.tableRequisicoes.setEnabled(valor);
        if (this.tableExames != null) {
            this.tableExames.setEnabled(valor);
        }
        this.itemColeta.setEnabled(valor);
        this.itemConvenio.setEnabled(valor);
        this.itemDestino.setEnabled(valor);
        this.itemExame.setEnabled(valor);
        this.buttonConsultar.setEnabled(valor);
        this.buttonDataFin.setEnabled(valor);
        this.buttonDataIni.setEnabled(valor);
        this.buttonNovo.setEnabled(valor);
        this.buttonExportar.setEnabled(valor);
        this.buttonFechar.setEnabled(valor);
        this.labelDataIni.setEnabled(valor);
        this.labelDataFin.setEnabled(valor);
        this.textDataFin.setEnabled(valor);
        this.textDataIni.setEnabled(valor);
    }

    private String getAtributosFiltro(CheckItemFiltro item, String nome) {
        StringBuilder bui = new StringBuilder();
        bui.append(StringUtil.getTag("sel", String.valueOf(item.isSelected())));
        bui.append(StringUtil.getTag("item", item.getSelecionados(0)));
        return StringUtil.getTag(nome, bui.toString());
    }

    private void setAtributosFiltro(CheckItemFiltro item, String atributos) {
        if (StringUtil.getBoolean(atributos, "sel")) {
            item.setSelected(true);
            item.setSelecionados(StringUtil.getValores(atributos, "item"));
        }
    }

    private void excluirRequisicao() {
        if (Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.modeloRequisicoes.removeLine(this.tableRequisicoes.getSelectedRow());
        }
    }

    private void exportar() throws ParseException {
        if (Funcoes.textoVazio(this.configuracao)) {
            Funcoes.mensagem(this, "Devem ser informados o C\u00f3digo e o Nome da Cl\u00ednica, nas configura\u00e7\u00f5es da tela", 1);
            return;
        }
        String codigoLaboratorio = StringUtil.getValor(this.configuracao, "codigo");
        String nomeLaboratorio = StringUtil.getValor(this.configuracao, "nome");
        StringBuilder file = new StringBuilder();
        boolean semCpf = false;
        if (this.modeloRequisicoes != null && this.modeloRequisicoes.getRowCount() > 0) {
            int i;
            for (i = 0; i < this.modeloRequisicoes.getRowCount(); ++i) {
                String cpf = (String)this.modeloRequisicoes.getValueAt(i, 4);
                if (Funcoes.temNumero(cpf)) continue;
                semCpf = true;
                break;
            }
            for (i = 0; i < this.modeloRequisicoes.getRowCount(); ++i) {
                String MENSAGEM = "Exportando requisi\u00e7\u00f5es... Aguarde...";
                ArrayList<String> requisicoesSemResultado = new ArrayList<String>();
                boolean semXml = false;
                boolean excluiRequisicao = true;
                try {
                    excluiRequisicao = true;
                    ArrayList exames = (ArrayList)this.modeloRequisicoes.getValueAt(i, 2);
                    String requisicao = (String)this.modeloRequisicoes.getValueAt(i, 0);
                    for (Registro re : exames) {
                        String[] exportar;
                        String xmlResultado = re.getString("xmlResultado");
                        String xml = re.getString("xml");
                        String cpfRequisicao = (String)this.modeloRequisicoes.getValueAt(i, 4);
                        String nomePaciente = (String)this.modeloRequisicoes.getValueAt(i, 1);
                        if (!Funcoes.temNumero(cpfRequisicao)) continue;
                        if (!semXml && Funcoes.textoVazio(xml) && !(semXml = Funcoes.mensagem(this, "A exporta\u00e7\u00e3o possui exames sem relacionamento!\nDeseja continuar mesmo assim?", 4) == 0)) {
                            return;
                        }
                        if (Funcoes.textoVazio(xmlResultado)) {
                            requisicoesSemResultado.add(Funcoes.preencheVazio(requisicao, 8, 1) + "\t" + re.getString("exa_codigo") + "-" + re.getString("exa_descricao"));
                            continue;
                        }
                        Map<String, Object> h = Resultado.getCamposResultado(xmlResultado, false);
                        for (String export : exportar = StringUtil.getValores(xml.toLowerCase(), "campo")) {
                            for (String s : h.keySet()) {
                                try {
                                    if (h.get(s.toLowerCase()) == null) {
                                        requisicoesSemResultado.add("Campo: " + s.toLowerCase() + " n\u00e3o localizado na requisi\u00e7\u00e3o: " + Funcoes.preencheVazio(requisicao, 8, 1) + "\t" + re.getString("exa_codigo") + "-" + re.getString("exa_descricao"));
                                        continue;
                                    }
                                    String nome = StringUtil.getValor(export.toLowerCase(), "nome");
                                    if (Funcoes.textoVazio(nome) || !nome.equalsIgnoreCase(s)) continue;
                                    String valorExame = h.get(s.toLowerCase()).toString();
                                    String codigoExameDialSist = StringUtil.getValor(export.toLowerCase(), "codigoexame");
                                    String nomeExameDialSist = StringUtil.getValor(export.toLowerCase(), "nomeexame");
                                    String unidadeMedida = "";
                                    if (!Funcoes.textoVazio(unidadeMedida)) {
                                        unidadeMedida = h.get(StringUtil.getValor(export.toLowerCase(), "unidademedida")).toString().trim();
                                    }
                                    String tipoResultado = StringUtil.getValor(xml.toLowerCase(), "tipo").toString();
                                    String dataConferencia = Funcoes.formataData("dd/MM/yyyy", re.getDate("exr_datadigita"));
                                    valorExame = valorExame.replace('.', ',');
                                    if (file.length() > 0) {
                                        file.append("\n");
                                    }
                                    file.append(StringUtil.removerAcentos(nomeLaboratorio)).append("|");
                                    file.append(codigoLaboratorio).append("|");
                                    file.append(cpfRequisicao).append("|");
                                    file.append(nomePaciente).append("|");
                                    file.append(codigoExameDialSist).append("|");
                                    file.append(StringUtil.removerAcentos(nomeExameDialSist)).append("|");
                                    file.append(StringUtil.removerAcentos(unidadeMedida)).append("|");
                                    file.append(dataConferencia).append("|");
                                    if (tipoResultado.equalsIgnoreCase(TipoDados.RESULTADO_NUMERICO.codigo)) {
                                        file.append(valorExame).append("|").append("||");
                                    } else if (tipoResultado.equalsIgnoreCase(TipoDados.RESULTADO_LOGICO.codigo)) {
                                        file.append("|");
                                        file.append(valorExame).append("||");
                                    } else if (tipoResultado.equalsIgnoreCase(TipoDados.RESULTADO_TEXTO.codigo)) {
                                        file.append("||");
                                        file.append(StringUtil.removerAcentos(valorExame).replaceAll(" ", "&&")).append("|");
                                    }
                                    file.append("|");
                                    if (semCpf && Funcoes.mensagem(this, "N\u00e3o ser\u00e3o enviados no arquivo de integra\u00e7\u00e3o, os exames do(s) Paciente(s) que n\u00e3o possuem CPF informado. Deseja continuar?", 4) == 1) {
                                        return;
                                    }
                                    semCpf = false;
                                    DialSistService dialService = new DialSistService();
                                    dialService.atualizaExportacaoDialSist(re, requisicao);
                                }
                                catch (Exception e) {
                                    excluiRequisicao = false;
                                }
                            }
                        }
                    }
                    continue;
                }
                catch (NullPointerException e) {
                    ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ExportarResultadoTexto (641)");
                }
            }
            if (!Funcoes.textoVazio(file.toString())) {
                JFileChooser f = ComponenteFactory.novoJFileChooser("", "teste");
                FileFilter flt = ComponenteFactory.novoFileFilter("(*.txt)", "txt");
                f.setSelectedFile(new File(nomeLaboratorio + " " + this.getMesAno() + ".txt"));
                f.setFileFilter(flt);
                if (f.showSaveDialog(this) == 0) {
                    String arquivo = f.getSelectedFile().getAbsolutePath();
                    try {
                        StringUtil.escreverArquivoTexto(arquivo, file.toString());
                        Funcoes.mensagem(this, "Exporta\u00e7\u00e3o realizada com sucesso!\nArquivo: " + arquivo, 5);
                    }
                    catch (Exception e) {
                        Funcoes.mensagem(null, "N\u00e3o foi poss\u00edvel finalizar a exporta\u00e7\u00e3o.\nMensagem: " + e.getMessage(), 1);
                    }
                    this.consultarRequisicoes();
                }
            } else {
                Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel realizar a exporta\u00e7\u00e3o", 5);
            }
        }
    }

    private String getMesAno() {
        String mes = Funcoes.formataData("MM", new Date());
        String ano = Funcoes.formataData("yyyy", new Date());
        String arquivo = "";
        switch (mes) {
            case "01": {
                arquivo = "Jan";
                break;
            }
            case "02": {
                arquivo = "Fev";
                break;
            }
            case "03": {
                arquivo = "Mar";
                break;
            }
            case "04": {
                arquivo = "Abr";
                break;
            }
            case "05": {
                arquivo = "Mai";
                break;
            }
            case "06": {
                arquivo = "Jun";
                break;
            }
            case "07": {
                arquivo = "Jul";
                break;
            }
            case "08": {
                arquivo = "Ago";
                break;
            }
            case "09": {
                arquivo = "Set";
                break;
            }
            case "10": {
                arquivo = "Out";
                break;
            }
            case "11": {
                arquivo = "Nov";
                break;
            }
            case "12": {
                arquivo = "Dez";
                break;
            }
            default: {
                arquivo = null;
            }
        }
        return arquivo + ano;
    }

    private Object gerarArquivo(Registro re) {
        return null;
    }

    public void pressioneiF2() {
        if (this.textDataIni.hasFocus()) {
            Funcoes.mostraData(this.textDataIni, this.buttonDataIni, this, true);
        } else if (this.textDataFin.hasFocus()) {
            Funcoes.mostraData(this.textDataFin, this.buttonDataFin, this, true);
        }
    }
}

