/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.exportacao.dialsist;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;

public class DialSistDao {
    private String getSelectRequisicao(String[] itemColeta, String[] itemConvenio, String[] itemDestino, String[] itemExame, String dataInicial, String dataFinal) {
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
        StringBuilder bui = new StringBuilder("select distinct ");
        try {
            bui.append("  a.req_codigo, a.req_data, g.pac_codigo, g.pac_nome, a.con_codigo, a.req_idade, a.req_anomes, a.des_codigo, g.pac_cpf, g.pac_tipopessoa, ");
            bui.append("  a.req_matricula ");
            bui.append("from requisicao a ");
            bui.append("left join examerequisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo ");
            bui.append("left join paciente g on a.fil_codigo = g.fil_codigo and a.pac_codigo = g.pac_codigo ");
            bui.append("where a.fil_codigo = ").append(Variaveis.filialPadrao);
            bui.append(" and a.req_excluida = false ");
            if (Funcoes.verificaData(dataInicial)) {
                if (bui.length() > 0) {
                    bui.append(" and ");
                }
                bui.append(" a.req_data >= '");
                bui.append(Funcoes.formataData("MM/dd/yyyy", sdf.parse(dataInicial)));
                bui.append("' ");
            }
            if (Funcoes.verificaData(dataFinal)) {
                if (bui.length() > 0) {
                    bui.append(" and ");
                }
                bui.append("a.req_data <= '");
                bui.append(Funcoes.formataData("MM/dd/yyyy", sdf.parse(dataFinal)));
                bui.append("' ");
            }
            if (itemColeta != null && itemColeta.length > 0) {
                this.addExpressao(bui, DialSistDao.getExpressao("a.col_codigo", itemColeta, true));
            }
            if (itemConvenio != null && itemConvenio.length > 0) {
                this.addExpressao(bui, DialSistDao.getExpressao("a.con_codigo", itemConvenio, false));
            }
            if (itemDestino != null && itemDestino.length > 0) {
                this.addExpressao(bui, DialSistDao.getExpressao("a.des_codigo", itemDestino, true));
            }
            if (itemExame != null && itemExame.length > 0) {
                this.addExpressao(bui, DialSistDao.getExpressao("b.exa_codigo", itemExame, true));
            }
            bui.append(" order by g.pac_nome ");
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace(), "ExportarResultadoTexto: 455");
        }
        return bui.toString();
    }

    private void addExpressao(StringBuilder bui, String exp) {
        if (exp != null && exp.length() > 0) {
            if (bui.length() > 0) {
                bui.append("and ");
            }
            bui.append(exp);
            bui.append(' ');
        }
    }

    public static String getExpressao(String campo, String[] valores, boolean aspas) {
        if (campo != null && valores != null && valores.length > 0) {
            StringBuilder buf = new StringBuilder("(");
            for (int i = 0; i < valores.length; ++i) {
                if (i > 0) {
                    buf.append(" or ");
                }
                buf.append(campo);
                buf.append(" = ");
                buf.append(StringUtil.textoDBEscape(valores[i]));
            }
            return buf.append(")").toString();
        }
        return "";
    }

    public ArrayList<Registro> consultaRequisicoes(String[] itemColeta, String[] itemConvenio, String[] itemDestino, String[] itemExame, String dataInicial, String dataFinal) throws SQLException {
        String sql = this.getSelectRequisicao(itemColeta, itemConvenio, itemDestino, itemExame, dataInicial, dataFinal);
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        ResultSet rs = Conexao.executeQuery(st, this.getSelectRequisicao(itemColeta, itemConvenio, itemDestino, itemExame, dataInicial, dataFinal));
        ArrayList<Registro> listaRegistro = new ArrayList<Registro>();
        while (rs.next()) {
            listaRegistro.add(new Registro(rs));
        }
        return listaRegistro;
    }

    public ArrayList<Registro> pegaExamesRequisicao(String requisicao, String[] itemExame) throws Exception {
        Statement st = Conexao.getStatement();
        ArrayList<Registro> retorno = new ArrayList<Registro>();
        StringBuilder buf = new StringBuilder("select a.exa_codigo, a.mco_codigo, b.mco_abreviatura, ");
        buf.append(" a.met_codigo, c.exa_descricao, a.met_codigo, a.exr_datadigita, a.exr_situacao, a.exr_datamaterial ");
        buf.append(" ,a.usr_coddialsist, a.exr_datadialsist ");
        buf.append("from examerequisicao a ");
        buf.append("left join materialcoleta b on a.fil_codigo = b.fil_codigo and a.mco_codigo = b.mco_codigo ");
        buf.append("left join exames c on a.fil_codigo = c.fil_codigo and a.exa_codigo = c.exa_codigo ");
        buf.append("where a.fil_codigo = ").append(Variaveis.filialPadrao);
        buf.append(" and a.req_codigo = ").append(requisicao);
        buf.append(" and a.exr_excluido = false ");
        if (itemExame != null && itemExame.length > 0) {
            this.addExpressao(buf, DialSistDao.getExpressao("a.exa_codigo", itemExame, true));
        }
        ResultSet rs = Conexao.executeQuery(st, buf);
        while (rs.next()) {
            retorno.add(new Registro(rs));
        }
        return retorno;
    }

    public String getXmlResultado(String requisicao, String exame, int materialColetado) {
        try {
            StringBuilder buf = new StringBuilder("select pegaResultadoExame(fil_codigo, req_codigo, exa_codigo, mco_codigo) as exr_resultado ");
            buf.append("from examerequisicao ");
            buf.append("where fil_codigo = ").append(Variaveis.filialPadrao);
            buf.append(" and req_codigo = ").append(requisicao);
            buf.append(" and exa_codigo = '").append(exame).append("'");
            buf.append(" and mco_codigo = ").append(materialColetado);
            buf.append(" and exr_excluido = false ");
            ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), buf);
            if (rs.next()) {
                return rs.getString("exr_resultado");
            }
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace(), "ExportarResultadoTexto: 581");
        }
        return "";
    }

    public void atualizaExportacaoDialSist(Registro re, String requisicao) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append("update examerequisicao set ");
        buf.append(" usr_coddialsist = '").append(Variaveis.login).append("', ");
        buf.append(" exr_datadialsist = '").append(Funcoes.formataData("yyyy-MM-dd HH:mm:ss", Funcoes.getDataHoraServidor())).append("' ");
        buf.append("where fil_codigo = ").append(Variaveis.filialPadrao);
        buf.append(" and req_codigo = ").append(requisicao);
        buf.append(" and exa_codigo = '").append(re.getString("exa_codigo")).append("'");
        buf.append(" and mco_codigo = ").append(re.getString("mco_codigo"));
        Conexao.executeUpdate(Variaveis.filialPadrao, Conexao.getStatement(), buf.toString());
        Conexao.arquivaSQL();
    }
}

