/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.exportacao.dialsist;

import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.cadastro.ExameMatCol;
import jalis.laboratorio.exportacao.dialsist.CamposResultado;
import jalis.laboratorio.exportacao.dialsist.TipoDados;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;

public class ConfiguradorExportacaoDialSist
extends AbstractDialogoOKCancelar
implements ActionListener {
    public static final String TAG_EXAME_INTEGRACOES_INTEGRACAODIALSIST = "exportardialsist";
    public static final String TAG_EXAME_INTEGRACOES_LINHA_RESULTADO = "campo";
    private static final String tituloJanela = "Configurando resultados DialSist";
    private String[] rotuloColuna = new String[]{"Campo", "Exame"};
    private int[] tamanhoColuna = new int[]{275, 0};
    private int editandoLinha = -1;
    private JComboBox comboCampos = new JComboBox();
    private JComboBox comboTipoDados = new JComboBox();
    private JComboBox comboUnidadeMedida = new JComboBox();
    private JTextField txtCodigoExame = new JTextField();
    private JTextField txtNomeExame = new JTextField();
    private JLabel labelCampos = new JLabel("Campos:");
    private JLabel labelTipoDados = new JLabel("Tipo:");
    private JLabel labelCodigoExame = new JLabel("C\u00f3digo exame");
    private JLabel labelUnidadeMedida = new JLabel("Unidade de medida:");
    private JLabel labelNomeExame = new JLabel("Nome exame:");
    private ModeloGridTable modelo;
    private JTable table;
    private JScrollPane scroll;
    private JButton buttonOK;
    private JButton buttonBuscaUnidadeMedida;
    private JButton buttonBuscaCampos;
    private int linhaEdicao;
    private static final int COLUNA_CAMPO = 0;
    private static final int COLUNA_TIPODADOS = 1;
    private static final int COLUNA_UNIDADEMEDIDA = 2;
    private static final int COLUNA_CODIGOEXAME = 3;
    private static final int COLUNA_NOMEEXAME = 4;
    private String[] camposLaudo;
    private static ExameMatCol exame;

    public static ConfiguradorExportacaoDialSist novaInstancia(Object pai, ExameMatCol ex, String[] campos) {
        exame = ex;
        if (pai instanceof Dialog) {
            return new ConfiguradorExportacaoDialSist((Dialog)pai, campos);
        }
        return new ConfiguradorExportacaoDialSist((Frame)pai, campos);
    }

    public ConfiguradorExportacaoDialSist(Dialog pai, String[] campos) {
        super(pai, tituloJanela);
        this.modelo = new ModeloGridTable(new String[]{CamposResultado.CAMPO.descricao, CamposResultado.TIPO_DADOS.descricao, CamposResultado.UNID_MEDIDA.descricao, CamposResultado.CODIGOEXAME.descricao, CamposResultado.NOMEEXAME.descricao});
        this.table = new JTable(this.modelo);
        this.scroll = new JScrollPane(this.table);
        this.buttonOK = new JButton("OK");
        this.buttonBuscaUnidadeMedida = new JButton();
        this.buttonBuscaCampos = new JButton();
        this.linhaEdicao = -1;
        this.camposLaudo = null;
        this.camposLaudo = campos;
        this.montaTela();
    }

    public ConfiguradorExportacaoDialSist(Frame pai, String[] campos) {
        super(pai, tituloJanela);
        this.modelo = new ModeloGridTable(new String[]{CamposResultado.CAMPO.descricao, CamposResultado.TIPO_DADOS.descricao, CamposResultado.UNID_MEDIDA.descricao, CamposResultado.CODIGOEXAME.descricao, CamposResultado.NOMEEXAME.descricao});
        this.table = new JTable(this.modelo);
        this.scroll = new JScrollPane(this.table);
        this.buttonOK = new JButton("OK");
        this.buttonBuscaUnidadeMedida = new JButton();
        this.buttonBuscaCampos = new JButton();
        this.linhaEdicao = -1;
        this.camposLaudo = null;
        this.camposLaudo = campos;
        this.montaTela();
    }

    public void montaTela() {
        this.getPanelCentral().setLayout(new GridBagLayout());
        this.setSize(new Dimension(800, 400));
        this.setResizable(false);
        ScreenUtil.centralizar(this);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 0, 1);
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.labelCampos.setLabelFor(this.comboCampos);
        this.labelCampos.setDisplayedMnemonic('D');
        this.getPanelCentral().add((Component)this.labelCampos, c);
        c.gridx += 2;
        this.labelTipoDados.setLabelFor(this.comboTipoDados);
        this.labelTipoDados.setDisplayedMnemonic('T');
        this.getPanelCentral().add((Component)this.labelTipoDados, c);
        ++c.gridx;
        this.labelUnidadeMedida.setLabelFor(this.comboUnidadeMedida);
        this.labelUnidadeMedida.setDisplayedMnemonic('U');
        this.getPanelCentral().add((Component)this.labelUnidadeMedida, c);
        c.gridx += 2;
        this.labelCodigoExame.setLabelFor(this.txtCodigoExame);
        this.labelCodigoExame.setDisplayedMnemonic('V');
        this.getPanelCentral().add((Component)this.labelCodigoExame, c);
        ++c.gridx;
        this.labelNomeExame.setLabelFor(this.txtNomeExame);
        this.labelNomeExame.setDisplayedMnemonic('R');
        this.getPanelCentral().add((Component)this.labelNomeExame, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 1.0;
        c.fill = 2;
        this.comboCampos.setPreferredSize(new Dimension(200, 20));
        this.comboCampos.setMinimumSize(new Dimension(200, 20));
        this.getPanelCentral().add((Component)this.comboCampos, c);
        ++c.gridx;
        this.buttonBuscaCampos.setPreferredSize(new Dimension(20, 20));
        this.buttonBuscaCampos.setMaximumSize(new Dimension(20, 20));
        this.buttonBuscaCampos.setMinimumSize(new Dimension(20, 20));
        this.buttonBuscaCampos.setSize(new Dimension(20, 20));
        this.buttonBuscaCampos.setText("");
        this.buttonBuscaCampos.setFocusable(false);
        Funcoes.imagemPesquisa(this.buttonBuscaCampos);
        this.getPanelCentral().add((Component)this.buttonBuscaCampos, c);
        ++c.gridx;
        c.weightx = 0.0;
        c.fill = 0;
        this.comboTipoDados.setPreferredSize(new Dimension(140, 20));
        this.comboTipoDados.setMinimumSize(new Dimension(140, 20));
        this.getPanelCentral().add((Component)this.comboTipoDados, c);
        ++c.gridx;
        this.comboUnidadeMedida.setPreferredSize(new Dimension(120, 20));
        this.comboUnidadeMedida.setMinimumSize(new Dimension(120, 20));
        this.getPanelCentral().add((Component)this.comboUnidadeMedida, c);
        ++c.gridx;
        this.buttonBuscaUnidadeMedida.setPreferredSize(new Dimension(20, 20));
        this.buttonBuscaUnidadeMedida.setMaximumSize(new Dimension(20, 20));
        this.buttonBuscaUnidadeMedida.setMinimumSize(new Dimension(20, 20));
        this.buttonBuscaUnidadeMedida.setSize(new Dimension(20, 20));
        this.buttonBuscaUnidadeMedida.setText("");
        this.buttonBuscaUnidadeMedida.setFocusable(false);
        Funcoes.imagemPesquisa(this.buttonBuscaUnidadeMedida);
        this.getPanelCentral().add((Component)this.buttonBuscaUnidadeMedida, c);
        ++c.gridx;
        this.txtCodigoExame.setPreferredSize(new Dimension(120, 20));
        this.txtCodigoExame.setMinimumSize(new Dimension(120, 20));
        this.getPanelCentral().add((Component)this.txtCodigoExame, c);
        ++c.gridx;
        this.txtNomeExame.setPreferredSize(new Dimension(120, 20));
        this.txtNomeExame.setMinimumSize(new Dimension(120, 20));
        this.getPanelCentral().add((Component)this.txtNomeExame, c);
        ++c.gridx;
        this.buttonOK.setPreferredSize(new Dimension(30, 20));
        this.buttonOK.setMinimumSize(new Dimension(30, 20));
        this.buttonOK.setMargin(new Insets(1, 1, 1, 1));
        this.buttonOK.setMnemonic('K');
        this.getPanelCentral().add((Component)this.buttonOK, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 9;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.getPanelCentral().add((Component)this.scroll, c);
        this.modelo.setColumnSize(new int[]{0, 100, 150, 150, 150}, this.table);
        this.montaListener();
        this.preencheCombosCamposLaudo();
        ScreenUtil.requisitarFoco(this.txtNomeExame);
    }

    private void montaListener() {
        this.table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int linha = ConfiguradorExportacaoDialSist.this.table.getSelectedRow();
                if (linha > -1) {
                    if (e.getKeyCode() == 32) {
                        ConfiguradorExportacaoDialSist.this.modificaLinha(linha);
                    } else if (e.getKeyCode() == 127) {
                        ConfiguradorExportacaoDialSist.this.removeLinha(linha);
                    }
                }
            }
        });
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfiguradorExportacaoDialSist.this.adicionaAssociacao();
            }
        });
        this.buttonBuscaUnidadeMedida.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfiguradorExportacaoDialSist.this.configuraCampoUnidadeMedida();
            }
        });
        this.buttonBuscaCampos.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfiguradorExportacaoDialSist.this.configuraCampoResultado();
            }
        });
        this.comboCampos.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    ConfiguradorExportacaoDialSist.this.buttonBuscaCampos.doClick();
                }
            }
        });
        this.comboUnidadeMedida.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    ConfiguradorExportacaoDialSist.this.buttonBuscaUnidadeMedida.doClick();
                }
            }
        });
    }

    private void removeLinha(int linha) {
        int resposta = Funcoes.mensagem(this, "Deseja remover a linha de associa\u00e7\u00e3o?", 4, true);
        if (resposta == 0) {
            this.modelo.removeLine(linha);
        }
        this.linhaEdicao = -1;
    }

    private void modificaLinha(int linha) {
        this.linhaEdicao = linha;
        this.comboCampos.setSelectedItem(this.modelo.getValueAt(linha, 0).toString());
        this.comboTipoDados.setSelectedItem(this.modelo.getValueAt(linha, 1));
        this.txtCodigoExame.setText(this.modelo.getValueAt(linha, 3).toString());
        this.comboUnidadeMedida.setSelectedItem(this.modelo.getValueAt(linha, 2));
        this.txtNomeExame.setText(this.modelo.getValueAt(linha, 4).toString());
        ScreenUtil.requisitarFoco(this.comboCampos);
    }

    private void configuraCampoResultado() {
        String propriedadeCampoNomeResultado = exame.configuraAssociaCamposDeResultado();
        if (!Funcoes.textoVazio(propriedadeCampoNomeResultado)) {
            for (String campo : this.camposLaudo) {
                if (!campo.equalsIgnoreCase(propriedadeCampoNomeResultado)) continue;
                this.comboCampos.setSelectedItem(campo);
            }
        }
    }

    private void adicionaAssociacao() {
        if (this.validaCamposAdicao()) {
            for (int i = 0; i < this.modelo.getRowCount(); ++i) {
                if (this.linhaEdicao == i || !this.modelo.getValueAt(i, 3).toString().equalsIgnoreCase(this.txtCodigoExame.getText())) continue;
                Funcoes.mensagem(this, "A descri\u00e7\u00e3o j\u00e1 existe.\nUtilize outra descri\u00e7\u00e3o.", 2);
                ScreenUtil.requisitarFoco(this.txtCodigoExame);
                return;
            }
            if (this.linhaEdicao > -1) {
                this.modelo.setValueAt(this.comboCampos.getSelectedItem().toString(), this.linhaEdicao, 0);
                this.modelo.setValueAt(this.txtCodigoExame.getText(), this.linhaEdicao, 3);
                this.modelo.setValueAt(this.txtNomeExame.getText().toString(), this.linhaEdicao, 4);
                this.modelo.setValueAt(this.comboTipoDados.getSelectedItem().toString(), this.linhaEdicao, 1);
                this.modelo.setValueAt(this.comboUnidadeMedida.getSelectedItem().toString(), this.linhaEdicao, 2);
                this.limpaCampos();
                return;
            }
            this.modelo.addLine(new Object[]{this.comboCampos.getSelectedItem().toString(), this.comboTipoDados.getSelectedItem().toString(), this.comboUnidadeMedida.getSelectedItem().toString(), this.txtCodigoExame.getText(), this.txtNomeExame.getText()});
            this.limpaCampos();
        }
    }

    private void limpaCampos() {
        this.txtCodigoExame.setText("");
        this.txtNomeExame.setText("");
        this.comboUnidadeMedida.setSelectedItem("");
        this.comboTipoDados.setSelectedItem("");
        this.comboCampos.setSelectedItem("");
        this.linhaEdicao = -1;
        ScreenUtil.requisitarFoco(this.comboCampos);
    }

    private void preencheCombosCamposLaudo() {
        if (this.camposLaudo == null) {
            return;
        }
        this.comboUnidadeMedida.addItem("");
        this.comboCampos.addItem("");
        this.comboTipoDados.addItem(TipoDados.RESULTADO_NUMERICO.descricao);
        this.comboTipoDados.addItem(TipoDados.RESULTADO_LOGICO.descricao);
        this.comboTipoDados.addItem(TipoDados.RESULTADO_TEXTO.descricao);
        for (String campo : this.camposLaudo) {
            this.comboUnidadeMedida.addItem(campo);
            this.comboCampos.addItem(campo);
        }
    }

    private boolean validaCamposAdicao() {
        if (Funcoes.textoVazio(this.comboCampos.getSelectedItem().toString())) {
            Funcoes.mensagem(this, "O campo deve ser selecionado.", 2);
            ScreenUtil.requisitarFoco(this.comboCampos);
            return false;
        }
        if (Funcoes.textoVazio(this.txtCodigoExame)) {
            Funcoes.mensagem(this, "O c\u00f3digo do exame deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.txtCodigoExame);
            return false;
        }
        if (Funcoes.textoVazio(this.txtNomeExame.getText())) {
            Funcoes.mensagem(this, "O nome do exame deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.txtNomeExame);
            return false;
        }
        return true;
    }

    private void configuraCampoUnidadeMedida() {
        String propriedadeCampoNomeUnidade = exame.configuraAssociaCamposDeResultado();
        for (String campo : this.camposLaudo) {
            if (!campo.equalsIgnoreCase(propriedadeCampoNomeUnidade)) continue;
            this.comboUnidadeMedida.setSelectedItem(campo);
        }
    }

    public String getXML() throws XMLStringBuilderException {
        XMLStringBuilder xml = new XMLStringBuilder();
        xml.abrir(TAG_EXAME_INTEGRACOES_INTEGRACAODIALSIST);
        for (int i = 0; i < this.modelo.getRowCount(); ++i) {
            xml.abrir(TAG_EXAME_INTEGRACOES_LINHA_RESULTADO);
            xml.escrever(CamposResultado.CAMPO.getTag(), this.modelo.getValueAt(i, 0).toString());
            xml.escrever(CamposResultado.TIPO_DADOS.getTag(), TipoDados.retornaCodigo(this.modelo.getValueAt(i, 1).toString()));
            Object aux = this.modelo.getValueAt(i, 2);
            if (aux != null) {
                xml.escrever(CamposResultado.UNID_MEDIDA.getTag(), aux.toString());
            }
            if ((aux = this.modelo.getValueAt(i, 3)) != null) {
                xml.escrever(CamposResultado.CODIGOEXAME.getTag(), aux.toString());
            }
            if ((aux = this.modelo.getValueAt(i, 4)) != null) {
                xml.escrever(CamposResultado.NOMEEXAME.getTag(), aux.toString());
            }
            xml.fechar(TAG_EXAME_INTEGRACOES_LINHA_RESULTADO);
        }
        xml.fechar(TAG_EXAME_INTEGRACOES_INTEGRACAODIALSIST);
        return xml.getXML();
    }

    public void setXml(String xml) {
        if (Funcoes.textoVazio(xml)) {
            return;
        }
        String[] linhas = StringUtil.getValores(xml, TAG_EXAME_INTEGRACOES_LINHA_RESULTADO);
        if (linhas != null) {
            for (String linha : linhas) {
                String campo = StringUtil.getValor(linha, CamposResultado.CAMPO.getTag());
                String tipoDado = StringUtil.getValor(linha, CamposResultado.TIPO_DADOS.getTag());
                String codigoExame = StringUtil.getValor(linha, CamposResultado.CODIGOEXAME.getTag());
                String nomeExame = StringUtil.getValor(linha, CamposResultado.NOMEEXAME.getTag());
                String unidadeMedida = StringUtil.getValor(linha, CamposResultado.UNID_MEDIDA.getTag());
                tipoDado = TipoDados.getDescricao(tipoDado);
                this.modelo.addLine(new Object[]{campo, tipoDado, unidadeMedida, codigoExame, nomeExame});
            }
        }
    }
}

