/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.exportacao.dialsist;

import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.JLabel;

public class ConfiguracaoDialSist
extends AbstractDialogoOKCancelar {
    private static String titulo = "Configura\u00e7\u00f5es";
    private JLabel labelCodigo = new JLabel("C\u00f3digo do Laborat\u00f3rio:");
    private JLabel labelNome = new JLabel("Nome do Laborat\u00f3rio:");
    private TTextField textCodigo = new TTextField(100, 3);
    private TTextField textNome = new TTextField(100, 3);
    private String codigoLaboratorio;
    private String nomeLaboratorio;

    public static ConfiguracaoDialSist novaInstancia(Object tela) {
        if (tela instanceof Dialog) {
            return new ConfiguracaoDialSist((Dialog)tela);
        }
        return new ConfiguracaoDialSist((Frame)tela);
    }

    public ConfiguracaoDialSist(Dialog pai) {
        super(pai, titulo);
        this.montaTela();
    }

    public ConfiguracaoDialSist(Frame pai) {
        super(pai, titulo);
        this.montaTela();
    }

    private void montaTela() {
        this.setSize(new Dimension(380, 120));
        ScreenUtil.centralizar(this);
        this.getPanelCentral().setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 2;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 1, 1);
        this.getPanelCentral().add((Component)this.labelCodigo, c);
        ++c.gridx;
        Dimension d = new Dimension(50, 20);
        this.textCodigo.setPreferredSize(d);
        this.textCodigo.setMinimumSize(d);
        this.textCodigo.setMaximumSize(d);
        this.textCodigo.setSize(d);
        this.getPanelCentral().add((Component)this.textCodigo, c);
        c.gridx = 0;
        ++c.gridy;
        this.getPanelCentral().add((Component)this.labelNome, c);
        ++c.gridx;
        c.gridwidth = 2;
        Dimension d2 = new Dimension(230, 20);
        this.textNome.setPreferredSize(d2);
        this.textNome.setMinimumSize(d2);
        this.textNome.setMaximumSize(d2);
        this.textNome.setSize(d2);
        this.getPanelCentral().add((Component)this.textNome, c);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.ok = false;
        if (e.getSource() == this.buttonOK) {
            if (this.validarCampos()) {
                this.codigoLaboratorio = this.textCodigo.getText();
                this.nomeLaboratorio = this.textNome.getText();
                this.dispose();
                this.ok = true;
            }
        } else if (e.getSource() == this.buttonCancelar) {
            this.dispose();
        }
    }

    private boolean validarCampos() {
        if (Funcoes.textoVazio(this.textCodigo)) {
            Funcoes.mensagem(this, "C\u00f3digo do usu\u00e1rio deve ser informado.", 1);
            ScreenUtil.requisitarFoco(this.textCodigo);
            return false;
        }
        if (Funcoes.textoVazio(this.textNome)) {
            Funcoes.mensagem(this, "Nome do Laborat\u00f3rio deve ser informado.", 1);
            ScreenUtil.requisitarFoco(this.textNome);
            return false;
        }
        return true;
    }

    public String getCodigoLaboratorio() {
        return this.codigoLaboratorio;
    }

    public void setCodigoLaboratorio(String codigoLaboratorio) {
        this.codigoLaboratorio = codigoLaboratorio;
        this.textCodigo.setText(codigoLaboratorio);
    }

    public String getNomeLaboratorio() {
        return this.nomeLaboratorio;
    }

    public void setNomeLaboratorio(String nomeLaboratorio) {
        this.nomeLaboratorio = nomeLaboratorio;
        this.textNome.setText(nomeLaboratorio);
    }
}

