/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.exportacao.consultaIntegracaoHospital;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.integracaohospitais.util.ProtocoloIntegracaoHospital;
import jalis.laboratorio.exportacao.consultaIntegracaoHospital.RendererRequisicoes;
import jalis.util.CheckItemFiltro;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.TableUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionListener;

public class PanelLogs
extends JPanel {
    private JPanel panelLog;
    private JPanel panelLogPesquisa;
    protected ModeloGridTable modeloLogs;
    protected JTable tableLogs;
    private JScrollPane scrollPaneLog;
    private JLabel labelLocalizar = new JLabel("Localizar:");
    private JComboBox comboLocalizar = new JComboBox<String>(new String[]{"Requisi\u00e7\u00e3o", "Logs"});
    private TTextField fieldLocalizar = new TTextField(0, 3);
    private JLabel labelLogsParaEnviar = new JLabel("Logs para enviar:");
    private JLabel labelValorLogsParaEnviar = new JLabel("0");
    private Component parent;

    public PanelLogs(Component parent) {
        this.parent = parent;
        this.montaPanelLogs();
    }

    private void montaPanelLogs() {
        this.setLayout(new BorderLayout());
        this.panelLog = new JPanel(new BorderLayout());
        this.panelLog.setPreferredSize(new Dimension(285, 360));
        this.montaTableLog();
        this.scrollPaneLog = new JScrollPane(this.tableLogs);
        this.panelLog.add((Component)this.scrollPaneLog, "Center");
        this.setBorder(BorderFactory.createTitledBorder("Logs"));
        this.panelLogPesquisa = this.instancePanelLogPesquisa();
        this.add((Component)this.panelLog, "Before");
        this.add((Component)this.panelLogPesquisa, "Last");
    }

    private void montaTableLog() {
        int[] size = new int[]{55, 57, 115, 60};
        this.modeloLogs = new ModeloGridTable(new String[]{"Filial", "Log", "Req", "Exp"});
        this.tableLogs = ComponenteFactory.novoJTable(this.modeloLogs);
        this.modeloLogs.setColumnSize(size, this.tableLogs);
        this.tableLogs.getColumnModel().getColumn(0).setMinWidth(50);
        this.tableLogs.getTableHeader().addMouseListener(this.modeloLogs);
        this.tableLogs.setDefaultRenderer(Object.class, new RendererRequisicoes());
        this.tableLogs.addMouseListener(this.modeloLogs);
    }

    private JPanel instancePanelLogPesquisa() {
        JPanel panelLogPesquisa = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 1;
        c.anchor = 17;
        c.insets = new Insets(0, 0, 2, 0);
        JPanel panelLocalizar = this.getPanelLocalizar();
        panelLogPesquisa.add((Component)panelLocalizar, c);
        ++c.gridy;
        c.fill = 2;
        this.fieldLocalizar.setHorizontalAlignment(4);
        this.fieldLocalizar.setPreferredSize(new Dimension(100, 20));
        panelLogPesquisa.add((Component)this.fieldLocalizar, c);
        ++c.gridy;
        c.fill = 2;
        c.insets = new Insets(0, 0, 2, 150);
        JPanel panelLogsParaEnviar = this.getPanelLogsParaEnviar();
        panelLogPesquisa.add((Component)panelLogsParaEnviar, c);
        ScreenUtil.addDocumentListener(this.fieldLocalizar.getDocument(), new Runnable(){

            @Override
            public void run() {
                PanelLogs.this.localizar(PanelLogs.this.fieldLocalizar.getText());
            }
        });
        this.fieldLocalizar.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                PanelLogs.this.fieldLocalizar.selectAll();
            }
        });
        this.fieldLocalizar.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if ((e.getKeyCode() == 38 || e.getKeyCode() == 40) && PanelLogs.this.tableLogs.getRowCount() > 0) {
                    PanelLogs.this.tableLogs.grabFocus();
                }
            }
        });
        return panelLogPesquisa;
    }

    protected void localizar(String valor) {
        Object cell;
        String prefix = valor.toLowerCase();
        int column = this.comboLocalizar.getSelectedItem().toString().equals("Requisi\u00e7\u00e3o") ? 2 : 1;
        int rows = this.tableLogs.getRowCount();
        for (int i = 0; i < rows && ((cell = this.tableLogs.getValueAt(i, column)) instanceof String || cell instanceof Integer); ++i) {
            String value = cell.toString().toLowerCase();
            if (!value.startsWith(prefix)) continue;
            this.tableLogs.setRowSelectionInterval(i, i);
            TableUtil.scrollToCenter(this.tableLogs, i);
            break;
        }
    }

    private JPanel getPanelLocalizar() {
        JPanel panelLocalizar = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 1;
        panelLocalizar.add((Component)this.labelLocalizar, c);
        ++c.gridx;
        c.insets = new Insets(0, 5, 0, 0);
        this.comboLocalizar.setPreferredSize(new Dimension(225, 23));
        panelLocalizar.add((Component)this.comboLocalizar, c);
        return panelLocalizar;
    }

    private JPanel getPanelLogsParaEnviar() {
        JPanel panelLogsParaEnviar = new JPanel(new BorderLayout());
        panelLogsParaEnviar.add((Component)this.labelLogsParaEnviar, "West");
        panelLogsParaEnviar.add((Component)this.labelValorLogsParaEnviar, "East");
        return panelLogsParaEnviar;
    }

    protected void consultarLogs(String dataInicio, String dataFinal, CheckItemFiltro checkBoxRequisicao, CheckItemFiltro checkBoxPaciente, CheckItemFiltro checkBoxFiliais, CheckItemFiltro checkBoxConvenio, CheckItemFiltro checkBoxSituacaoLog, CheckItemFiltro checkBoxExames, JComboBox comboExportacao) {
        Statement st = Conexao.getStatement();
        try {
            this.modeloLogs.clear();
            if (st != null) {
                ResultSet rs = Conexao.executeQuery(st, this.getSqlConsulta(dataInicio, dataFinal, checkBoxRequisicao, checkBoxPaciente, checkBoxFiliais, checkBoxConvenio, checkBoxSituacaoLog, checkBoxExames, comboExportacao));
                while (rs.next()) {
                    Registro registro = null;
                    registro = this.montaDados(rs);
                    if (registro == null) continue;
                    this.modeloLogs.addLine(new Object[]{registro.getValor("filial"), registro.getValor("log"), registro.getValor("Requisi\u00e7\u00e3o"), registro.getValor("exportado"), registro});
                }
                if (this.modeloLogs.getColunaOrdenacao() != -1) {
                    this.modeloLogs.ordenarColunaSemTrocarSentido(this.modeloLogs.getColunaOrdenacao());
                } else {
                    this.modeloLogs.ordenarColunaSemTrocarSentido(2);
                }
                this.atualizaLabelLogsParaEnviar(dataInicio, dataFinal, checkBoxRequisicao, checkBoxPaciente, checkBoxFiliais, checkBoxConvenio, checkBoxSituacaoLog, checkBoxExames, comboExportacao);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this.parent, e.getMessage(), e.getStackTrace());
        }
    }

    protected void habilitarDesabilitar(boolean valor) {
        if (this.tableLogs != null) {
            this.tableLogs.setEnabled(valor);
        }
    }

    private String getSqlConsulta(String dataInicio, String dataFinal, CheckItemFiltro checkBoxRequisicao, CheckItemFiltro checkBoxPaciente, CheckItemFiltro checkBoxFiliais, CheckItemFiltro checkBoxConvenio, CheckItemFiltro checkBoxSituacaoLog, CheckItemFiltro checkBoxExames, JComboBox comboExportacao) {
        StringBuilder bui = new StringBuilder();
        try {
            bui.append("select distinct log.fil_codigo as filial, eih.req_codigo as requisicao, log.eih_codigo as codigoEih, ");
            bui.append("case log.lei_situacao when 'I' then 'Sim' else 'N\u00e3o' end as exportado ");
            bui.append("from logexportaintegracaohospital log ");
            bui.append("left join exportaintegracaohospital eih on log.eih_codigo = eih.eih_codigo ");
            bui.append("left join requisicao req on req.fil_codigo = eih.fil_codigo and req.req_codigo = eih.req_codigo ");
            bui.append("left join examerequisicao exr on eih.fil_codigo = exr.fil_codigo and exr.req_codigo = req.req_codigo and eih.exa_codigo = exr.exa_codigo ");
            bui.append("where (req.req_excluida is null or req.req_excluida = false) ");
            bui.append(" and eih.eih_operacao like '%<NomeIntegracaoHospital>").append((Object)ParametrosGerais.getProtocoloIntegracaoHospital()).append("</NomeIntegracaoHospital>%'");
            if (Funcoes.verificaData(dataInicio)) {
                bui.append(" and eih.eih_datahora >= '").append(Funcoes.formataData("yyyy-MM-dd HH:mm:ss", dataInicio)).append("' ");
            }
            if (Funcoes.verificaData(dataFinal)) {
                bui.append(" and eih.eih_datahora <= ' ").append(Funcoes.formataData("yyyy-MM-dd 23:59:59", dataFinal)).append("' ");
            }
            bui.append(ParametrosGerais.getProtocoloIntegracaoHospital().equals((Object)ProtocoloIntegracaoHospital.SALUX) ? " and log.eih_codigo is not null  " : "");
            if (checkBoxRequisicao.isSelected()) {
                this.addExpressao(bui, this.getExpressao("req.req_codigo", checkBoxRequisicao.getSelecionadosAvancado(0), true));
            }
            if (checkBoxConvenio.isSelected()) {
                this.addExpressao(bui, this.getExpressao("req.con_codigo", checkBoxConvenio.getSelecionados(0), false));
            }
            if (checkBoxPaciente.isSelected()) {
                this.addExpressao(bui, this.getExpressao("req.pac_codigo", checkBoxPaciente.getSelecionados(0), true));
            }
            if (checkBoxExames.isSelected()) {
                this.addExpressao(bui, this.getExpressao("exr.exa_codigo", checkBoxExames.getSelecionados(0), true));
            }
            if (checkBoxFiliais.isSelected()) {
                this.addExpressao(bui, this.getExpressao("eih.fil_codigo", checkBoxFiliais.getSelecionados(0), true));
            }
            if (checkBoxSituacaoLog.isSelected()) {
                this.addExpressao(bui, this.getExpressao("log.lei_situacao", checkBoxSituacaoLog.getSelecionados(0), true));
            }
            if (comboExportacao.getSelectedItem().equals("Enviados")) {
                bui.append(" and eih.eih_exportado in (true)");
            } else if (comboExportacao.getSelectedItem().equals("N\u00e3o Enviados")) {
                bui.append(" and eih.eih_exportado in (false)");
            } else {
                bui.append(" and eih.eih_exportado in (true, false)");
            }
            bui.append(" order by log.eih_codigo");
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this.parent, e.getMessage(), e.getStackTrace());
        }
        return bui.toString();
    }

    private String getExpressao(String campo, String[] valores, boolean aspas) {
        if (campo != null && valores != null && valores.length > 0) {
            StringBuilder buf = new StringBuilder("(");
            for (int i = 0; i < valores.length; ++i) {
                if (i > 0) {
                    buf.append(" or ");
                }
                buf.append(campo);
                buf.append(" = ");
                if (aspas) {
                    buf.append('\'');
                }
                buf.append(valores[i]);
                if (!aspas) continue;
                buf.append('\'');
            }
            return buf.append(")").toString();
        }
        return "";
    }

    private void addExpressao(StringBuilder bui, String exp) {
        if (exp != null && exp.length() > 0) {
            if (bui.length() > 0) {
                bui.append("and ");
            }
            bui.append(exp);
            bui.append(' ');
        }
    }

    private Registro montaDados(ResultSet rs) {
        Registro registro = new Registro();
        try {
            registro.setValor("filial", rs.getString("filial"));
            registro.setValor("Requisi\u00e7\u00e3o", rs.getString("requisicao"));
            registro.setValor("log", rs.getString("codigoEih"));
            registro.setValor("exportado", rs.getString("exportado"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return registro;
    }

    private void atualizaLabelLogsParaEnviar(String dataInicio, String dataFinal, CheckItemFiltro checkBoxRequisicao, CheckItemFiltro checkBoxPaciente, CheckItemFiltro checkBoxFiliais, CheckItemFiltro checkBoxConvenio, CheckItemFiltro checkBoxSituacaoLog, CheckItemFiltro checkBoxExames, JComboBox comboExportacao) {
        Statement st = Conexao.getStatement();
        StringBuilder buf = new StringBuilder("");
        buf.append("select count(1) as logs ");
        buf.append("from logexportaintegracaohospital log ");
        buf.append("left join exportaintegracaohospital eih on log.eih_codigo = eih.eih_codigo ");
        buf.append("where eih.eih_operacao like '%<NomeIntegracaoHospital>");
        buf.append(ParametrosGerais.getProtocoloIntegracaoHospital().getNome());
        buf.append("</NomeIntegracaoHospital>%' ");
        if (comboExportacao.getSelectedItem().equals("Enviados")) {
            buf.append(" and eih.eih_exportado in (true)");
            buf.append(" and log.lei_situacao = 'I' ");
        } else if (comboExportacao.getSelectedItem().equals("N\u00e3o Enviados")) {
            buf.append(" and eih.eih_exportado in (false)");
            buf.append(" and (log.lei_situacao = 'P' or log.lei_situacao = 'R')");
        } else {
            buf.append(" and eih.eih_exportado in (true, false)");
        }
        try {
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                this.labelValorLogsParaEnviar.setText(rs.getString("logs"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void addSelectionListenerToModel(ListSelectionListener listener) {
        this.tableLogs.getSelectionModel().addListSelectionListener(listener);
    }

    public void limpar() {
        this.modeloLogs.clear();
        this.fieldLocalizar.clear();
        this.labelValorLogsParaEnviar.setText("0");
    }

    public void selecionanarLog() {
        if (this.tableLogs.getRowCount() > 0) {
            this.tableLogs.getSelectionModel().setSelectionInterval(0, 0);
        }
    }
}

