/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.exportacao.consultaIntegracaoHospital;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.integracaohospitais.sistemas.sigh.IntegracaoHospitalSigh;
import jalis.integracaohospitais.util.DadosErrosIntegracaoHospital;
import jalis.integracaohospitais.util.FabricaIntegracaoHospital;
import jalis.integracaohospitais.util.ProtocoloIntegracaoHospital;
import jalis.laboratorio.exportacao.consultaIntegracaoHospital.PanelRetorno;
import jalis.laboratorio.exportacao.externo.LogExportaIntegracaoHospital;
import jalis.service.recepcao.RequisicaoService;
import jalis.util.Funcoes;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Calendar;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class PanelInformacoes
extends JPanel {
    private static final String NAO_ENVIADO = "N\u00e3o Enviado";
    private static final String REJEITADO = "Rejeitado";
    private static final String ENVIADO = "Enviado";
    private static final String NAO_CONFIGURADO = "N\u00e3o Configurado";
    JLabel labelFilial = new JLabel("Filial");
    TTextField fieldCodigoFilial = new TTextField(0, 3);
    TTextField fieldDescricaoFilial = new TTextField(0, 3);
    JLabel labelRequisicao = new JLabel("Requisi\u00e7\u00e3o");
    TTextField fieldCodigoRequisicao = new TTextField(0, 3);
    JLabel labelDataRequisicao = new JLabel("Data requisi\u00e7\u00e3o");
    TTextField fieldDataRequisicao = new TTextField(0, 4);
    JLabel labelHoraRequisicao = new JLabel("Hora requisi\u00e7\u00e3o");
    TTextField fieldHoraRequisicao = new TTextField(0, 6);
    JLabel labelDataLog = new JLabel("Data log");
    TTextField fieldDataLog = new TTextField(0, 4);
    JLabel labelSituacaoLog = new JLabel("Situa\u00e7\u00e3o Log");
    TTextField fieldSituacaoLog = new TTextField(0, 3);
    JLabel labelPaciente = new JLabel("Paciente");
    TTextField fieldCodigoPaciente = new TTextField(0, 3);
    TTextField fieldDescricaoPaciente = new TTextField(0, 3);
    JLabel labelCartaoSus = new JLabel("Cart\u00e3o SUS");
    TTextField fieldCartaoSus = new TTextField(0, 3);
    JLabel labelConvenio = new JLabel("Conv\u00eanio");
    TTextField fieldCodigoConvenio = new TTextField(0, 3);
    TTextField fieldDescricaoConvenio = new TTextField(0, 3);
    JLabel labelMatricula = new JLabel("Matricula");
    TTextField fieldMatricula = new TTextField(0, 3);
    JLabel labelExame = new JLabel("Exame");
    TTextField fieldCodigoExame = new TTextField(0, 3);
    JLabel labelMaterial = new JLabel("Material");
    TTextField fieldDescricaoMaterial = new TTextField(0, 3);
    JLabel labelSituacaoExame = new JLabel("Situa\u00e7\u00e3o Exame");
    TTextField fieldSituacaoExame = new TTextField(0, 3);
    JLabel labelGuia = new JLabel("Guia");
    TTextField fieldGuia = new TTextField(20, 3);
    JLabel labelDataGuia = new JLabel("Data Guia");
    TTextField fieldDataGuia = new TTextField(0, 4);
    JLabel labelAmb = new JLabel("AMB");
    TTextField fieldAmb = new TTextField(0, 3);
    JLabel labelConferencia = new JLabel("Conferencia");
    TTextField fieldConferencia = new TTextField(0, 3);
    JButton buttonCorrigir = ComponenteFactory.novoJButton("Corrigir", 'G', null, null, null);
    JButton buttonReenviar = ComponenteFactory.novoJButton("Reenviar", 'R', null, null, null);
    private Component parent;
    PanelRetorno panelRetorno;
    private RequisicaoService requisicaoService = new RequisicaoService();
    protected Registro registroSelecionado = null;

    public PanelInformacoes(Component parent) {
        this.parent = parent;
        this.panelRetorno = new PanelRetorno(parent);
        this.montaPanelInformacoes();
    }

    public void addActionListenerToReeviar(ActionListener listener) {
        this.buttonReenviar.addActionListener(listener);
    }

    public void addActionListenerToCorrigir(ActionListener listener) {
        this.buttonCorrigir.addActionListener(listener);
    }

    private void montaPanelInformacoes() {
        this.setLayout(new BorderLayout());
        JPanel panelInformacoes = this.getPanelInformacoes();
        this.add((Component)panelInformacoes, "First");
        this.add((Component)this.panelRetorno, "Center");
        this.defineListeners();
    }

    private void defineListeners() {
        Funcoes.montaEnter((JComponent)this.fieldMatricula);
        Funcoes.montaEnter((JComponent)this.fieldGuia);
        Funcoes.montaEnter((JComponent)this.fieldDataGuia);
    }

    private JPanel getPanelInformacoes() {
        JPanel panelInformacoesPai = new JPanel(new BorderLayout());
        panelInformacoesPai.setBorder(new TitledBorder("Informa\u00e7\u00f5es"));
        JPanel panelInformacoesDados = new JPanel(new GridBagLayout());
        GridBagConstraints cons = new GridBagConstraints();
        cons.fill = 2;
        cons.anchor = 18;
        cons.gridx = 0;
        cons.gridy = 0;
        cons.weightx = 5.0;
        cons.weighty = 1.0;
        cons.insets = new Insets(0, 2, 0, 0);
        JPanel panelAux = new JPanel(new GridBagLayout());
        panelInformacoesDados.add((Component)panelAux, cons);
        Dimension d = new Dimension(80, 20);
        cons.fill = 0;
        cons.anchor = 17;
        cons.gridx = 0;
        cons.gridy = 0;
        cons.weightx = 0.0;
        this.labelFilial.setPreferredSize(d);
        this.labelFilial.setMaximumSize(d);
        this.labelFilial.setMinimumSize(d);
        panelAux.add((Component)this.labelFilial, cons);
        ++cons.gridy;
        this.fieldCodigoFilial.setPreferredSize(d);
        this.fieldCodigoFilial.setMaximumSize(d);
        this.fieldCodigoFilial.setMinimumSize(d);
        panelAux.add((Component)this.fieldCodigoFilial, cons);
        ++cons.gridx;
        cons.weightx = 5.0;
        cons.gridwidth = 4;
        Dimension d6 = new Dimension(472, 20);
        this.fieldDescricaoFilial.setPreferredSize(d6);
        this.fieldDescricaoFilial.setMaximumSize(d6);
        this.fieldDescricaoFilial.setMinimumSize(d6);
        panelAux.add((Component)this.fieldDescricaoFilial, cons);
        cons.fill = 0;
        cons.gridx = 0;
        ++cons.gridy;
        cons.gridwidth = 1;
        cons.weightx = 0.0;
        this.labelRequisicao.setPreferredSize(d);
        this.labelRequisicao.setMaximumSize(d);
        this.labelRequisicao.setMinimumSize(d);
        panelAux.add((Component)this.labelRequisicao, cons);
        cons.fill = 2;
        ++cons.gridx;
        panelAux.add((Component)this.labelDataRequisicao, cons);
        ++cons.gridx;
        panelAux.add((Component)this.labelHoraRequisicao, cons);
        ++cons.gridx;
        panelAux.add((Component)this.labelDataLog, cons);
        ++cons.gridx;
        panelAux.add((Component)this.labelSituacaoLog, cons);
        cons.fill = 0;
        ++cons.gridy;
        cons.gridx = 0;
        cons.weightx = 0.0;
        this.fieldCodigoRequisicao.setMaximumSize(d);
        this.fieldCodigoRequisicao.setMinimumSize(d);
        this.fieldCodigoRequisicao.setPreferredSize(d);
        panelAux.add((Component)this.fieldCodigoRequisicao, cons);
        ++cons.gridx;
        Dimension d2 = new Dimension(101, 20);
        this.fieldDataRequisicao.setMaximumSize(d2);
        this.fieldDataRequisicao.setMinimumSize(d2);
        this.fieldDataRequisicao.setPreferredSize(d2);
        panelAux.add((Component)this.fieldDataRequisicao, cons);
        ++cons.gridx;
        d2 = new Dimension(100, 20);
        this.fieldHoraRequisicao.setMaximumSize(d2);
        this.fieldHoraRequisicao.setMinimumSize(d2);
        this.fieldHoraRequisicao.setPreferredSize(d2);
        panelAux.add((Component)this.fieldHoraRequisicao, cons);
        ++cons.gridx;
        this.fieldDataLog.setMaximumSize(d2);
        this.fieldDataLog.setMinimumSize(d2);
        this.fieldDataLog.setPreferredSize(d2);
        panelAux.add((Component)this.fieldDataLog, cons);
        ++cons.gridx;
        Dimension d5 = new Dimension(165, 20);
        this.fieldSituacaoLog.setMaximumSize(d5);
        this.fieldSituacaoLog.setMinimumSize(d5);
        this.fieldSituacaoLog.setPreferredSize(d5);
        panelAux.add((Component)this.fieldSituacaoLog, cons);
        cons.fill = 0;
        cons.weightx = 0.0;
        cons.gridx = 0;
        ++cons.gridy;
        cons.weightx = 0.0;
        this.labelPaciente.setMaximumSize(d);
        this.labelPaciente.setMinimumSize(d);
        this.labelPaciente.setPreferredSize(d);
        panelAux.add((Component)this.labelPaciente, cons);
        cons.fill = 2;
        cons.gridx += 4;
        panelAux.add((Component)this.labelCartaoSus, cons);
        cons.fill = 0;
        cons.weightx = 0.0;
        cons.gridx = 0;
        ++cons.gridy;
        cons.weightx = 0.0;
        this.fieldCodigoPaciente.setMaximumSize(d);
        this.fieldCodigoPaciente.setMinimumSize(d);
        this.fieldCodigoPaciente.setPreferredSize(d);
        panelAux.add((Component)this.fieldCodigoPaciente, cons);
        Dimension d7 = new Dimension(305, 20);
        ++cons.gridx;
        cons.gridwidth = 3;
        this.fieldDescricaoPaciente.setMaximumSize(d7);
        this.fieldDescricaoPaciente.setMinimumSize(d7);
        this.fieldDescricaoPaciente.setPreferredSize(d7);
        panelAux.add((Component)this.fieldDescricaoPaciente, cons);
        cons.fill = 0;
        cons.weightx = 0.0;
        cons.gridx = 0;
        cons.weightx = 0.0;
        cons.gridx += 4;
        cons.gridwidth = 1;
        this.fieldCartaoSus.setMaximumSize(d5);
        this.fieldCartaoSus.setMinimumSize(d5);
        this.fieldCartaoSus.setPreferredSize(d5);
        panelAux.add((Component)this.fieldCartaoSus, cons);
        cons.fill = 0;
        cons.weightx = 0.0;
        cons.gridx = 0;
        cons.weightx = 0.0;
        ++cons.gridy;
        this.labelConvenio.setMaximumSize(d);
        this.labelConvenio.setMinimumSize(d);
        this.labelConvenio.setPreferredSize(d);
        panelAux.add((Component)this.labelConvenio, cons);
        cons.fill = 2;
        cons.gridx += 4;
        panelAux.add((Component)this.labelMatricula, cons);
        cons.fill = 0;
        cons.weightx = 0.0;
        cons.gridx = 0;
        cons.weightx = 0.0;
        ++cons.gridy;
        this.fieldCodigoConvenio.setMaximumSize(d);
        this.fieldCodigoConvenio.setMinimumSize(d);
        this.fieldCodigoConvenio.setPreferredSize(d);
        panelAux.add((Component)this.fieldCodigoConvenio, cons);
        cons.fill = 0;
        ++cons.gridx;
        cons.gridwidth = 3;
        this.fieldDescricaoConvenio.setMaximumSize(d7);
        this.fieldDescricaoConvenio.setMinimumSize(d7);
        this.fieldDescricaoConvenio.setPreferredSize(d7);
        panelAux.add((Component)this.fieldDescricaoConvenio, cons);
        cons.fill = 0;
        cons.gridwidth = 1;
        cons.gridx += 3;
        this.fieldMatricula.setMaximumSize(d5);
        this.fieldMatricula.setMinimumSize(d5);
        this.fieldMatricula.setPreferredSize(d5);
        panelAux.add((Component)this.fieldMatricula, cons);
        cons.fill = 0;
        cons.weightx = 0.0;
        cons.gridx = 0;
        cons.weightx = 0.0;
        ++cons.gridy;
        this.labelExame.setMaximumSize(d);
        this.labelExame.setMinimumSize(d);
        this.labelExame.setPreferredSize(d);
        panelAux.add((Component)this.labelExame, cons);
        ++cons.gridx;
        this.labelMaterial.setPreferredSize(d);
        panelAux.add((Component)this.labelMaterial, cons);
        cons.fill = 2;
        cons.gridx += 3;
        panelAux.add((Component)this.labelSituacaoExame, cons);
        cons.fill = 0;
        cons.gridx = 0;
        ++cons.gridy;
        this.fieldCodigoExame.setMaximumSize(d);
        this.fieldCodigoExame.setMinimumSize(d);
        this.fieldCodigoExame.setPreferredSize(d);
        panelAux.add((Component)this.fieldCodigoExame, cons);
        cons.fill = 0;
        ++cons.gridx;
        cons.gridwidth = 3;
        this.fieldDescricaoMaterial.setMaximumSize(d7);
        this.fieldDescricaoMaterial.setMinimumSize(d7);
        this.fieldDescricaoMaterial.setPreferredSize(d7);
        panelAux.add((Component)this.fieldDescricaoMaterial, cons);
        cons.fill = 0;
        cons.gridwidth = 1;
        cons.gridx += 3;
        this.fieldSituacaoExame.setMaximumSize(d5);
        this.fieldSituacaoExame.setMinimumSize(d5);
        this.fieldSituacaoExame.setPreferredSize(d5);
        panelAux.add((Component)this.fieldSituacaoExame, cons);
        cons.fill = 0;
        cons.gridx = 0;
        cons.weightx = 0.0;
        ++cons.gridy;
        this.labelGuia.setMaximumSize(d);
        this.labelGuia.setMinimumSize(d);
        this.labelGuia.setPreferredSize(d);
        panelAux.add((Component)this.labelGuia, cons);
        cons.fill = 2;
        cons.gridx += 2;
        panelAux.add((Component)this.labelDataGuia, cons);
        ++cons.gridx;
        panelAux.add((Component)this.labelAmb, cons);
        ++cons.gridx;
        panelAux.add((Component)this.labelConferencia, cons);
        cons.fill = 0;
        cons.gridx = 0;
        cons.weightx = 0.0;
        ++cons.gridy;
        cons.gridwidth = 2;
        Dimension d3 = new Dimension(183, 20);
        this.fieldGuia.setMaximumSize(d3);
        this.fieldGuia.setMinimumSize(d3);
        this.fieldGuia.setPreferredSize(d3);
        panelAux.add((Component)this.fieldGuia, cons);
        cons.gridx += 2;
        this.fieldDataGuia.setMaximumSize(d2);
        this.fieldDataGuia.setMinimumSize(d2);
        this.fieldDataGuia.setPreferredSize(d2);
        panelAux.add((Component)this.fieldDataGuia, cons);
        Dimension d4 = new Dimension(100, 20);
        cons.fill = 0;
        ++cons.gridx;
        this.fieldAmb.setMaximumSize(d4);
        this.fieldAmb.setMinimumSize(d4);
        this.fieldAmb.setPreferredSize(d4);
        panelAux.add((Component)this.fieldAmb, cons);
        ++cons.gridx;
        this.fieldConferencia.setMaximumSize(d5);
        this.fieldConferencia.setMinimumSize(d5);
        this.fieldConferencia.setPreferredSize(d5);
        panelAux.add((Component)this.fieldConferencia, cons);
        JPanel panelBotoes = new JPanel(new FlowLayout(2));
        this.buttonCorrigir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelInformacoes.this.corrigir();
            }
        });
        if (!this.isProtocoloGhosp()) {
            panelBotoes.add(this.buttonCorrigir);
            panelBotoes.add(this.buttonReenviar);
        }
        this.buttonReenviar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelInformacoes.this.reenviar();
            }
        });
        panelInformacoesPai.add((Component)panelInformacoesDados, "First");
        panelInformacoesPai.add((Component)panelBotoes, "After");
        return panelInformacoesPai;
    }

    private boolean isProtocoloGhosp() {
        return ParametrosGerais.getProtocoloIntegracaoHospital() == ProtocoloIntegracaoHospital.G_HOSP;
    }

    private boolean isProtocoloSIGH() {
        return ParametrosGerais.getProtocoloIntegracaoHospital() == ProtocoloIntegracaoHospital.SIGH;
    }

    protected void habilitarDesabilitar(boolean valor) {
        this.fieldCodigoFilial.setEnabled(valor);
        this.fieldDescricaoFilial.setEnabled(valor);
        this.fieldCodigoRequisicao.setEnabled(valor);
        this.fieldDataRequisicao.setEnabled(valor);
        this.fieldHoraRequisicao.setEnabled(valor);
        this.fieldDataLog.setEnabled(valor);
        this.fieldSituacaoLog.setEnabled(valor);
        this.fieldCodigoPaciente.setEnabled(valor);
        this.fieldDescricaoPaciente.setEnabled(valor);
        this.fieldCartaoSus.setEditable(valor);
        this.fieldCodigoConvenio.setEnabled(valor);
        this.fieldDescricaoConvenio.setEnabled(valor);
        this.fieldMatricula.setEnabled(valor);
        this.fieldCodigoExame.setEnabled(valor);
        this.fieldDescricaoMaterial.setEnabled(valor);
        this.fieldSituacaoExame.setEnabled(valor);
        this.fieldGuia.setEnabled(valor);
        this.fieldDataGuia.setEnabled(valor);
        this.fieldAmb.setEnabled(valor);
        this.fieldConferencia.setEnabled(valor);
    }

    public Registro montaDados(ResultSet rs) {
        Registro registro = new Registro();
        try {
            registro.setValor("filial", rs.getString("filial"));
            registro.setValor("descricaofilial", rs.getString("descricaoFilial"));
            registro.setValor("Requisi\u00e7\u00e3o", rs.getString("requisicao"));
            registro.setValor("log", rs.getString("codigoEih"));
            registro.setValor("exportado", rs.getBoolean("exportado"));
            registro.setValor("xmlLog", rs.getString("xmlIntegracao"));
            registro.setValor("dataLog", rs.getString("dataLog"));
            registro.setValor("tipoOperacao", rs.getString("tipoOperacao"));
            registro.setValor("retorno", rs.getString("retorno"));
            registro.setValor("situacaoexame", rs.getString("situacaoExame"));
            registro.setValor("codigoPaciente", rs.getString("codigoPaciente"));
            registro.setValor("nomePaciente", rs.getString("nomePaciente"));
            registro.setValor("codigoConvenio", rs.getString("codigoConvenio"));
            registro.setValor("descricaoConvenio", rs.getString("razaoConvenio"));
            registro.setValor("idade", rs.getInt("idadePaciente"));
            registro.setValor("matricula", rs.getString("matricula"));
            registro.setValor("exame", rs.getString("codigoExame"));
            registro.setValor("codigoMaterial", rs.getString("codigoMaterial"));
            registro.setValor("descricaoMaterial", rs.getString("descricaoMaterial"));
            registro.setValor("descricaoExame", rs.getString("descricaoExame"));
            registro.setValor("guia", rs.getString("guia"));
            registro.setValor("dataGuia", rs.getString("dataGuia"));
            registro.setValor("amb", rs.getString("amb"));
            registro.setValor("conferencia", rs.getString("conferencia"));
            registro.setValor("usrconferencia", rs.getString("codigoAssinatura"));
            registro.setValor("dataRequisicao", rs.getString("dataRequisicao"));
            registro.setValor("horaRequisicao", rs.getString("horaRequisicao"));
            registro.setValor("cartaosus", rs.getString("cartaoSus"));
            registro.setValor("situacaoLog", rs.getString("situacaoLog"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return registro;
    }

    private void preencheCampos(Registro registro) {
        String dataRequisicao = this.getFormatData(registro.getString("dataRequisicao"), true, "dd/MM/yyyy");
        String horaRequisicao = this.getFormatHora(registro.getString("horaRequisicao"), true, "HH:MM");
        String dataLog = this.getFormatData(registro.getString("dataLog"), true, "dd/MM/yyyy");
        String situacaoExame = Tipos.tipoSituacaoExame(registro.getString("situacaoexame"));
        String situacaoLog = registro.getString("situacaoLog").equalsIgnoreCase("I") ? "Integrado" : "Erro";
        String dataGuia = this.getFormatData(registro.getString("dataGuia"), true, "dd/MM/yyyy");
        String retorno = registro.getString("retorno");
        String xml = registro.getString("xmlLog");
        String convenio = registro.getString("codigoConvenio");
        String guia = registro.getString("guia");
        String requisicao = registro.getString("Requisi\u00e7\u00e3o");
        String exame = registro.getString("exame");
        this.fieldCodigoFilial.setText(registro.getString("filial"));
        this.fieldDescricaoFilial.setText(registro.getString("descricaofilial"));
        this.fieldCodigoRequisicao.setText(registro.getString("Requisi\u00e7\u00e3o"));
        this.fieldDataRequisicao.setText(dataRequisicao);
        this.fieldHoraRequisicao.setText(horaRequisicao);
        this.fieldDataLog.setText(dataLog);
        this.fieldSituacaoLog.setText(situacaoLog);
        this.fieldCodigoPaciente.setText(registro.getString("codigoPaciente"));
        this.fieldDescricaoPaciente.setText(registro.getString("nomePaciente"));
        this.fieldCartaoSus.setText(registro.getString("cartaosus"));
        this.fieldCodigoConvenio.setText(registro.getString("codigoConvenio"));
        this.fieldDescricaoConvenio.setText(registro.getString("descricaoConvenio"));
        this.fieldMatricula.setText(registro.getString("matricula"));
        this.fieldCodigoExame.setText(registro.getString("exame"));
        this.fieldDescricaoMaterial.setText(registro.getString("descricaoMaterial"));
        this.fieldSituacaoExame.setText(situacaoExame);
        this.fieldGuia.setText(registro.getString("guia"));
        this.fieldDataGuia.setText(dataGuia);
        this.fieldAmb.setText(registro.getString("amb"));
        this.fieldConferencia.setText(registro.getString("conferencia"));
        this.panelRetorno.preencherCampos(retorno, exame, requisicao, convenio, guia);
        this.trataLogRetorno();
    }

    private void trataLogRetorno() {
        Color color = this.fieldSituacaoExame.getDisabledTextColor();
        color = this.fieldSituacaoExame.getText().equalsIgnoreCase(ENVIADO) ? new Color(0, 100, 0) : (this.fieldSituacaoExame.getText().equalsIgnoreCase(REJEITADO) ? Color.RED : (this.fieldSituacaoExame.getText().equalsIgnoreCase(NAO_CONFIGURADO) ? new Color(218, 165, 32) : new Color(184, 207, 229)));
        this.fieldSituacaoExame.setForeground(color);
        this.fieldSituacaoExame.setDisabledTextColor(color);
        Color[] cores = Tipos.getCorSituacaoExame(Tipos.getCodigoSituacaoExame(this.fieldSituacaoExame.getText()));
        this.fieldSituacaoExame.setDisabledTextColor(cores[0]);
        this.fieldSituacaoExame.setForeground(cores[0]);
    }

    private String getFormatData(String data, boolean formatoGravacao, String formato) {
        Calendar ca = Calendar.getInstance();
        if (!Funcoes.textoVazio(data)) {
            if (formatoGravacao) {
                if (data.contains(" ")) {
                    data = data.substring(0, data.indexOf(" "));
                }
                String[] dataTotal = data.split("-");
                ca.set(Integer.parseInt(dataTotal[0]), Integer.parseInt(dataTotal[1]) - 1, Integer.parseInt(dataTotal[2]));
                data = Funcoes.formataData(formato, ca.getTime());
            } else {
                String[] dataTotal = data.split("/");
                ca.set(Integer.parseInt(dataTotal[2]), Integer.parseInt(dataTotal[1]) - 1, Integer.parseInt(dataTotal[0]));
                data = Funcoes.formataData(formato, ca.getTime());
            }
            return data;
        }
        return "";
    }

    private String getFormatHora(String data, boolean formatoGravacao, String formato) {
        Calendar ca = Calendar.getInstance();
        if (!Funcoes.textoVazio(data)) {
            if (formatoGravacao) {
                if (data.contains(" ")) {
                    data = data.substring(0, data.indexOf(" "));
                }
                String[] dataTotal = data.split(":");
                ca.set(Integer.parseInt(dataTotal[0]), Integer.parseInt(dataTotal[1]) - 1, Integer.parseInt(dataTotal[2]));
                data = Funcoes.formataData(formato, ca.getTime());
            } else {
                String[] dataTotal = data.split("/");
                ca.set(Integer.parseInt(dataTotal[2]), Integer.parseInt(dataTotal[1]) - 1, Integer.parseInt(dataTotal[0]));
                data = Funcoes.formataData(formato, ca.getTime());
            }
            return data;
        }
        return "";
    }

    private String getSqlConsulta(String codigoDaFilial, String codigoDoLog) {
        StringBuilder bui = new StringBuilder();
        try {
            bui.append("select log.lei_codigo as codigo, log.fil_codigo as filial, fil.fil_descricao as descricaoFilial, eih.req_codigo as requisicao, exa.exa_descricao as descricaoExame, eih_tipooperacao as tipoOperacao, ");
            bui.append("req.req_data as dataRequisicao, req.req_hora as horaRequisicao, log.lei_datahora as dataLog, log.lei_situacao as situacaoLog, usr_codassina as codigoAssinatura, ");
            bui.append("pa.pac_codigo as codigoPaciente, pa.pac_nome as nomePaciente, req.req_cartaosus as cartaoSus, con.con_codigo as codigoConvenio, log.eih_codigo as codigoEih, ");
            bui.append("con.con_razao as razaoConvenio, req.req_matricula as matricula, eih.exa_codigo as codigoExame, mco.mco_descricao as descricaoMaterial, ");
            bui.append("exr.exr_situacao as situacaoExame, COALESCE(NULLIF(TRIM(exr.exr_guia), ''), req.req_guia) as guia, req.req_dataguia as dataGuia, dtp.dtp_codamb as amb, ");
            bui.append("exr_dataassina as conferencia, log.lei_retorno as retorno, case log.lei_situacao when 'I' then 'Sim' else 'N\u00e3o' end as exportado, eih.eih_operacao as xmlIntegracao, ");
            bui.append("pa.pac_idade as idadePaciente,exr.mco_codigo as codigoMaterial, mco.mco_abreviatura as abreviaturaMaterial ");
            bui.append("from logexportaintegracaohospital log ");
            bui.append("left join exportaintegracaohospital eih on log.eih_codigo = eih.eih_codigo ");
            bui.append("left join filiais_postocoleta fil on eih.fil_codigo = fil.fil_codigo ");
            bui.append("left join requisicao req on req.fil_codigo = eih.fil_codigo and req.req_codigo = eih.req_codigo ");
            bui.append("left join examerequisicao exr on eih.fil_codigo = exr.fil_codigo and exr.req_codigo = req.req_codigo and eih.exa_codigo = exr.exa_codigo ");
            bui.append("left join exames exa on fil.fil_codigo = exa.fil_codigo and exr.exa_codigo = exa.exa_codigo ");
            bui.append("left join materialcoleta mco on eih.fil_codigo = mco.fil_codigo and exr.mco_codigo = mco.mco_codigo ");
            bui.append("left join paciente pa on pa.fil_codigo = eih.fil_codigo and pa.pac_codigo = req.pac_codigo ");
            bui.append("left join convenios con on con.fil_codigo = eih.fil_codigo and con.con_codigo = req.con_codigo ");
            bui.append("left join detalhetabelapreco dtp  on exr.fil_codigo = dtp.fil_codigo  and exr.exa_codigo = dtp.exa_codigo ");
            bui.append("and exr.mco_codigo = dtp.mco_codigo and con.tpe_codigo = dtp.tpe_codigo ");
            bui.append("left join exames e on exr.fil_codigo = e.fil_codigo  and exr.exa_codigo = e.exa_codigo ");
            bui.append("where (req.req_excluida is null or req.req_excluida = false) ");
            bui.append("and log.eih_codigo = ").append(codigoDoLog);
            bui.append(" and log.fil_codigo = ").append(codigoDaFilial);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this.parent, e.getMessage(), e.getStackTrace());
        }
        return bui.toString();
    }

    protected void preencherInformacoes(String codigoDaFilial, String codigoDoLog) {
        Statement st = Conexao.getStatement();
        try {
            this.habilitarDesabilitar(false);
            if (st != null) {
                ResultSet rs = Conexao.executeQuery(st, this.getSqlConsulta(codigoDaFilial, codigoDoLog));
                while (rs.next()) {
                    Registro registro = null;
                    this.registroSelecionado = registro = this.montaDados(rs);
                    if (registro == null) continue;
                    this.preencheCampos(registro);
                }
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this.parent, e.getMessage(), e.getStackTrace());
        }
    }

    private String getExpressao(String campo, String[] valores, boolean aspas) {
        if (campo != null && valores != null && valores.length > 0) {
            StringBuilder buf = new StringBuilder("(");
            for (int i = 0; i < valores.length; ++i) {
                if (i > 0) {
                    buf.append(" or ");
                }
                buf.append(campo);
                buf.append(" = ");
                if (aspas) {
                    buf.append('\'');
                }
                buf.append(valores[i]);
                if (!aspas) continue;
                buf.append('\'');
            }
            return buf.append(")").toString();
        }
        return "";
    }

    private void addExpressao(StringBuilder bui, String exp) {
        if (exp != null && exp.length() > 0) {
            if (bui.length() > 0) {
                bui.append("and ");
            }
            bui.append(exp);
            bui.append(' ');
        }
    }

    protected void corrigir() {
        if (this.registroSelecionado != null) {
            if (this.buttonCorrigir.getText().equalsIgnoreCase("Corrigir")) {
                this.fieldCartaoSus.setEnabled(true);
                this.fieldMatricula.setEnabled(true);
                this.fieldGuia.setEnabled(true);
                this.fieldDataGuia.setEnabled(true);
                this.buttonCorrigir.setText("Salvar");
            } else {
                try {
                    if (!this.salvarCorrecao()) {
                        return;
                    }
                    this.fieldCartaoSus.setEnabled(false);
                    this.fieldMatricula.setEnabled(false);
                    this.fieldGuia.setEnabled(false);
                    this.fieldDataGuia.setEnabled(false);
                    this.buttonCorrigir.setText("Corrigir");
                }
                catch (Exception e) {
                    Funcoes.mensagem(this.parent, e.getMessage(), 1);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean salvarCorrecao() throws Exception {
        String dataGuia;
        String string = dataGuia = this.fieldDataGuia.getText() == null ? "" : this.fieldDataGuia.getText();
        if (Funcoes.textoVazio(dataGuia)) {
            throw new Exception("Campo Data Guia deve ser informado.");
        }
        if (!Funcoes.verificaData(dataGuia)) {
            return false;
        }
        dataGuia = this.getFormatData(this.fieldDataGuia.getText(), false, "yyyy-MM-dd");
        String guia = this.fieldGuia.getText();
        String matricula = this.fieldMatricula.getText() == null ? "" : this.fieldMatricula.getText();
        String codigoRequisicao = this.fieldCodigoRequisicao.getText() == null ? "" : this.fieldCodigoRequisicao.getText();
        String codigoFilial = this.fieldCodigoFilial.getText() == null ? "" : this.fieldCodigoFilial.getText();
        try {
            this.requisicaoService.corrigirInformacoesDaIntegracaoHospital(codigoFilial, dataGuia, guia, matricula, codigoRequisicao);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this.parent, e.getMessage(), e.getStackTrace());
        }
        finally {
            return true;
        }
    }

    private LogExportaIntegracaoHospital getLogIntegracaoHospital(Registro reg) {
        String codigoFilial = (String)reg.getValor("filial");
        String codigoLog = (String)reg.getValor("log");
        String codigoRequisicao = (String)reg.getValor("Requisi\u00e7\u00e3o");
        String codigoExame = (String)reg.getValor("exame");
        String codigoMaterial = (String)reg.getValor("codigoMaterial");
        boolean exportado = (Boolean)reg.getValor("exportado");
        LogExportaIntegracaoHospital log = new LogExportaIntegracaoHospital();
        log.setCodigo(Long.parseLong(codigoLog));
        log.setExame(codigoExame);
        log.setExportado(exportado);
        log.setFilial(codigoFilial);
        log.setMaterial(codigoMaterial);
        log.setRequisicao(codigoRequisicao);
        return log;
    }

    protected void reenviar() {
        if (this.registroSelecionado != null) {
            DadosErrosIntegracaoHospital erros = null;
            LogExportaIntegracaoHospital log = this.getLogIntegracaoHospital(this.registroSelecionado);
            try {
                this.reenviarHospital(log, erros);
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
            }
        }
    }

    private void reenviarHospital(LogExportaIntegracaoHospital log, DadosErrosIntegracaoHospital erros) {
        try {
            if (this.isProtocoloSIGH()) {
                IntegracaoHospitalSigh.atualizarLogHospital(String.valueOf(log.getFilial()), String.valueOf(log.getCodigo()), null, "P");
            } else {
                this.desfazerCorrecao();
                IntegracaoHospitalSigh.insereIntegracaoHospital(ParametrosGerais.getProtocoloIntegracaoHospital(), this.fieldCodigoFilial.getText(), "R", "filial", this.fieldCodigoFilial.getText(), "codReq", this.fieldCodigoRequisicao.getText(), "codExa", String.valueOf(this.fieldCodigoExame.getText()), "codMat", String.valueOf(log.getMaterial()));
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this.parent, e.getMessage(), e.getStackTrace());
        }
    }

    protected void desfazerCorrecao() {
        if (this.buttonCorrigir.getText().equalsIgnoreCase("Salvar")) {
            this.fieldCartaoSus.setEnabled(false);
            this.fieldMatricula.setEnabled(false);
            this.fieldGuia.setEnabled(false);
            this.fieldDataGuia.setEnabled(false);
            this.buttonCorrigir.setText("Corrigir");
            this.preencheCampos(this.registroSelecionado);
        }
    }

    private boolean isCobrancaPacienteSigh(String fil_codigo, String con_codigo) {
        IntegracaoHospitalSigh integracaoSig = (IntegracaoHospitalSigh)FabricaIntegracaoHospital.novaIntegracaoHospital(ParametrosGerais.getProtocoloIntegracaoHospital(), ParametrosLocais.getParametro("xmlHospital"));
        return integracaoSig.getCobrancaContaPaciente(fil_codigo, con_codigo);
    }

    public void limpar() {
        this.fieldCodigoFilial.clear();
        this.fieldDescricaoFilial.clear();
        this.fieldCodigoRequisicao.clear();
        this.fieldDataRequisicao.clear();
        this.fieldHoraRequisicao.clear();
        this.fieldDataLog.clear();
        this.fieldSituacaoLog.clear();
        this.fieldCodigoPaciente.clear();
        this.fieldDescricaoPaciente.clear();
        this.fieldCartaoSus.clear();
        this.fieldCodigoConvenio.clear();
        this.fieldDescricaoConvenio.clear();
        this.fieldMatricula.clear();
        this.fieldCodigoExame.clear();
        this.fieldDescricaoMaterial.clear();
        this.fieldSituacaoExame.clear();
        this.fieldGuia.clear();
        this.fieldDataGuia.clear();
        this.fieldAmb.clear();
        this.fieldConferencia.clear();
        this.desfazerCorrecao();
        this.panelRetorno.limpar();
        this.registroSelecionado = null;
    }
}

