/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.exportacao.consultaIntegracaoHospital;

import jalis.comum.Conexao;
import jalis.laboratorio.exportacao.consultaIntegracaoHospital.PanelFiltros;
import jalis.laboratorio.exportacao.consultaIntegracaoHospital.PanelInformacoes;
import jalis.laboratorio.exportacao.consultaIntegracaoHospital.PanelLogs;
import jalis.util.Funcoes;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Statement;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ConsultaIntegracaoHospital
extends JPanel {
    PanelFiltros panelFiltros = new PanelFiltros(this);
    PanelInformacoes panelInformacoes = new PanelInformacoes(this);
    PanelLogs panelLogs = new PanelLogs(this);
    private JButton buttonOpcoes = ComponenteFactory.novoJButton("Op\u00e7\u00f5es \u25bc", 'O', null, null, null);
    private final JPopupMenu menuOpcoes = new JPopupMenu();
    private JMenuItem buttonMarcarExportado = ComponenteFactory.novoJMenuItem("Marcar exportado", 'M', null);
    private JButton buttonNovo = ComponenteFactory.novoJButton("Novo", 'N', null, null, null);
    private JButton buttonFechar = ComponenteFactory.novoJButton("Fechar", 'F', null, null, null);
    private ArrayList<Registro> logs = new ArrayList();

    public ConsultaIntegracaoHospital() {
        this.montaTela();
    }

    private void montaTela() {
        this.menuOpcoes.add(this.buttonMarcarExportado);
        Funcoes.montaEnter((JComponent)this.panelFiltros);
        Funcoes.montaEnter((JComponent)this.panelLogs);
        Funcoes.montaEnter((JComponent)this.panelInformacoes);
        this.buttonMarcarExportado.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConsultaIntegracaoHospital.this.marcarLogExportado();
                ConsultaIntegracaoHospital.this.panelLogs.consultarLogs(ConsultaIntegracaoHospital.this.panelFiltros.getDataInicio(), ConsultaIntegracaoHospital.this.panelFiltros.getDataFinal(), ConsultaIntegracaoHospital.this.panelFiltros.checkBoxRequisicao, ConsultaIntegracaoHospital.this.panelFiltros.checkBoxPaciente, ConsultaIntegracaoHospital.this.panelFiltros.checkBoxFiliais, ConsultaIntegracaoHospital.this.panelFiltros.checkBoxConvenio, ConsultaIntegracaoHospital.this.panelFiltros.checkBoxSituacaoLog, ConsultaIntegracaoHospital.this.panelFiltros.checkBoxExames, ConsultaIntegracaoHospital.this.panelFiltros.comboExportacao);
            }
        });
        this.panelFiltros.addActionListenerToConsultar(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConsultaIntegracaoHospital.this.panelInformacoes.desfazerCorrecao();
                ConsultaIntegracaoHospital.this.panelInformacoes.limpar();
                ConsultaIntegracaoHospital.this.panelLogs.consultarLogs(ConsultaIntegracaoHospital.this.panelFiltros.getDataInicio(), ConsultaIntegracaoHospital.this.panelFiltros.getDataFinal(), ConsultaIntegracaoHospital.this.panelFiltros.checkBoxRequisicao, ConsultaIntegracaoHospital.this.panelFiltros.checkBoxPaciente, ConsultaIntegracaoHospital.this.panelFiltros.checkBoxFiliais, ConsultaIntegracaoHospital.this.panelFiltros.checkBoxConvenio, ConsultaIntegracaoHospital.this.panelFiltros.checkBoxSituacaoLog, ConsultaIntegracaoHospital.this.panelFiltros.checkBoxExames, ConsultaIntegracaoHospital.this.panelFiltros.comboExportacao);
                ConsultaIntegracaoHospital.this.panelLogs.selecionanarLog();
                ConsultaIntegracaoHospital.this.buttonOpcoes.setEnabled(true);
            }
        });
        this.panelLogs.addSelectionListenerToModel(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (ConsultaIntegracaoHospital.this.panelLogs.tableLogs.getSelectedRow() > -1) {
                    String filial = (String)ConsultaIntegracaoHospital.this.panelLogs.modeloLogs.getValueAt(ConsultaIntegracaoHospital.this.panelLogs.tableLogs.getSelectedRow(), 0);
                    String log = (String)ConsultaIntegracaoHospital.this.panelLogs.modeloLogs.getValueAt(ConsultaIntegracaoHospital.this.panelLogs.tableLogs.getSelectedRow(), 1);
                    this.carregaInformacoes(filial, log);
                }
            }

            private void carregaInformacoes(String filial, String log) {
                ConsultaIntegracaoHospital.this.panelInformacoes.desfazerCorrecao();
                ConsultaIntegracaoHospital.this.panelInformacoes.preencherInformacoes(filial, log);
            }
        });
        this.setLayout(new BorderLayout());
        this.montaPanelNorth();
        this.add(this.getSouthPanel(), "South");
        this.add((Component)this.panelInformacoes, "Center");
        this.add((Component)this.panelLogs, "West");
        this.habilitarDesabilitar(false);
    }

    private Component getSouthPanel() {
        JPanel panelSouth = new JPanel(new GridBagLayout());
        this.buttonOpcoes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConsultaIntegracaoHospital.this.menuOpcoes.show(ConsultaIntegracaoHospital.this.buttonOpcoes, ConsultaIntegracaoHospital.this.buttonOpcoes.getY(), ConsultaIntegracaoHospital.this.buttonOpcoes.getX() + ConsultaIntegracaoHospital.this.buttonOpcoes.getHeight());
            }
        });
        this.buttonNovo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConsultaIntegracaoHospital.this.panelFiltros.limpar();
                ConsultaIntegracaoHospital.this.panelLogs.limpar();
                ConsultaIntegracaoHospital.this.panelInformacoes.limpar();
            }
        });
        this.buttonFechar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConsultaIntegracaoHospital.this.setVisible(false);
                if (ConsultaIntegracaoHospital.this.getParent() != null) {
                    ConsultaIntegracaoHospital.this.getParent().removeAll();
                }
            }
        });
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 1;
        c.anchor = 17;
        c.insets = new Insets(5, 5, 5, 5);
        panelSouth.add((Component)this.buttonOpcoes, c);
        c.weightx = 1.0;
        c.anchor = 13;
        c.weightx = 1.0;
        ++c.gridx;
        panelSouth.add((Component)this.buttonNovo, c);
        c.weightx = 0.0;
        ++c.gridx;
        panelSouth.add((Component)this.buttonFechar, c);
        return panelSouth;
    }

    private void montaPanelNorth() {
        JPanel northPanel = new JPanel(new BorderLayout());
        Funcoes.criaBarraDescricao(northPanel, "Consulta Integra\u00e7\u00e3o Hospital", "Consulta logs de integra\u00e7\u00e3o hospitalar", "integracao/consulta_hospital.jpg");
        northPanel.add((Component)this.panelFiltros, "South");
        this.add((Component)northPanel, "North");
    }

    public static Long getModuloAcesso() {
        return Long.parseLong("0909000302");
    }

    private void habilitarDesabilitar(boolean valor) {
        this.buttonOpcoes.setEnabled(valor);
        this.panelInformacoes.habilitarDesabilitar(valor);
    }

    public void marcarLogExportado() {
        try {
            this.marcarIntegrado();
            this.marcarExportado();
            Conexao.arquivaSQL();
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
        }
    }

    private void marcarExportado() throws Exception {
        Statement st = Conexao.getStatement();
        Conexao.executeUpdate(this.panelInformacoes.fieldCodigoFilial.getText(), st, this.sqlMarcaExportado());
        st.close();
    }

    private void marcarIntegrado() throws Exception {
        Statement st = Conexao.getStatement();
        Conexao.executeUpdate(this.panelInformacoes.fieldCodigoFilial.getText(), st, this.sqlMarcarIntegrado());
        st.close();
    }

    private String sqlMarcaExportado() {
        Registro registroSelecionado = this.panelInformacoes.registroSelecionado;
        StringBuilder buf = new StringBuilder();
        buf.append(" update exportaintegracaohospital ");
        buf.append(" set eih_exportado = true ");
        buf.append(" where fil_codigo = ").append(this.panelInformacoes.fieldCodigoFilial.getText());
        buf.append(" and eih_codigo = ").append(registroSelecionado.getString("log"));
        return buf.toString();
    }

    private String sqlMarcarIntegrado() {
        Registro registroSelecionado = this.panelInformacoes.registroSelecionado;
        StringBuilder buf = new StringBuilder();
        buf.append(" update logexportaintegracaohospital ");
        buf.append(" set lei_situacao = 'I' ");
        buf.append(" ,lei_retorno = ").append("'Situa\u00e7\u00e3o alterado para exportado manualmente' ");
        buf.append(" where fil_codigo = ").append(this.panelInformacoes.fieldCodigoFilial.getText());
        buf.append(" and eih_codigo = ").append(registroSelecionado.getString("log"));
        return buf.toString();
    }
}

