/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.exportacao;

import jalis.util.Funcoes;
import java.util.Date;

public class TipoIdade {
    public static final String TIPO_ANO = "A";
    public static final String TIPO_MES = "M";
    public static final String TIPO_DIA = "D";
    private String tipoIdade = null;
    private Integer quantidade = null;

    public TipoIdade(String dataNascimento, Date dataBase) {
        Date dataNascimentoAux;
        if (dataNascimento.length() > 0 && dataBase != null && (dataNascimentoAux = Funcoes.getData("dd/MM/yyyy", dataNascimento)) != null) {
            int difAno = Funcoes.yearsBetween(dataNascimentoAux, dataBase);
            int difMes = Funcoes.monthBetween(dataNascimentoAux, dataBase);
            int difDia = Funcoes.daysBetween(dataNascimentoAux, dataBase);
            if (difAno > 0) {
                this.quantidade = difAno;
                this.tipoIdade = TIPO_ANO;
            } else if (difMes > 0) {
                this.quantidade = difMes;
                this.tipoIdade = TIPO_MES;
            } else {
                this.quantidade = difDia;
                this.tipoIdade = TIPO_DIA;
            }
        }
    }

    public TipoIdade(String dataNascimento, Date dataBase, String masc) {
        Date dataNascimentoAux;
        if (dataNascimento.length() > 0 && dataBase != null && (dataNascimentoAux = Funcoes.getData(masc, dataNascimento)) != null) {
            int difAno = Funcoes.yearsBetween(dataNascimentoAux, dataBase);
            int difMes = Funcoes.monthBetween(dataNascimentoAux, dataBase);
            int difDia = Funcoes.daysBetween(dataNascimentoAux, dataBase);
            if (difAno > 0) {
                this.quantidade = difAno;
                this.tipoIdade = TIPO_ANO;
            } else if (difMes > 0) {
                this.quantidade = difMes;
                this.tipoIdade = TIPO_MES;
            } else {
                this.quantidade = difDia;
                this.tipoIdade = TIPO_DIA;
            }
        }
    }

    public String getTipoIdade() {
        return this.tipoIdade;
    }

    public Integer getQuantidade() {
        return this.quantidade;
    }
}

