/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.exportacao;

import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmPadrao;
import jalis.laboratorio.exportacao.AvisaFinal;
import jalis.laboratorio.exportacao.Exportar;
import jalis.util.CheckItemFiltro;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.border.TitledBorder;

public class SelecionarWeb
extends FrmPadrao
implements ActionListener {
    private CheckItemFiltro itemDestino = new CheckItemFiltro("Destinos", "Filtrar", "Filtrando destinos", "fil_codigo = " + Variaveis.filialPadrao);
    private CheckItemFiltro itemMedico = new CheckItemFiltro("M\u00e9dicos", "Filtrar", "Filtrando m\u00e9dicos", "fil_codigo = " + Variaveis.filialPadrao, new int[]{0, 1, 2}, false);
    private CheckItemFiltro itemConvenio = new CheckItemFiltro("Conv\u00eanios", "Filtrar", "Filtrando conv\u00eanios", "fil_codigo = " + Variaveis.filialPadrao);
    private CheckItemFiltro itemExame = new CheckItemFiltro("Exames", "Filtrar", "Filtrando exames", "fil_codigo = " + Variaveis.filialPadrao);
    private CheckItemFiltro itemPaciente = new CheckItemFiltro("Pacientes", "Filtrar", "Filtrando pacientes", "fil_codigo = " + Variaveis.filialPadrao);
    private CheckItemFiltro itemFiscal = new CheckItemFiltro("Fiscais", "Filtrar", "Filtrando fiscais", "fil_codigo = " + Variaveis.filialPadrao + " and ent_tipo = '" + "I" + "'");
    private CheckItemFiltro itemResponsavel = new CheckItemFiltro("Respons\u00e1veis", "Filtrar", "Filtrando respons\u00e1veis", "fil_codigo = " + Variaveis.filialPadrao + " and ent_tipo = '" + "P" + "'");
    private CheckItemFiltro itemUsuario = new CheckItemFiltro("Usu\u00e1rio", "Filtrar", "Filtrando usu\u00e1rios", "");
    private JButton buttonExportar = new JButton("Exportar");
    private JButton buttonNovo = new JButton("Novo");
    private JButton buttonFechar = new JButton("Fechar");
    private JPanel panelBotoes = new JPanel(new FlowLayout(2));
    private JPanel panelFiltro = new JPanel(new GridBagLayout());
    private GridBagConstraints constraints = new GridBagConstraints();
    private JProgressBar progresso = new JProgressBar();
    private JLabel labelTempo = new JLabel("00:00:00");
    private JPanel panelCentro = new JPanel(new GridBagLayout());
    private JLabel labelCentro = new JLabel();

    public SelecionarWeb() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
        }
    }

    private void jbInit() throws Exception {
        this.buttonExportar.setMnemonic('E');
        this.buttonFechar.setMnemonic('F');
        this.buttonNovo.setMnemonic('N');
        this.setLayout(new BorderLayout());
        this.add((Component)this.panelBotoes, "South");
        this.add((Component)this.panelFiltro, "West");
        this.add((Component)this.panelCentro, "Center");
        this.panelBotoes.add(this.buttonNovo);
        this.panelBotoes.add(this.buttonFechar);
        Funcoes.criaBarraDescricao(this, "Selecionar para web", "Gera a exporta\u00e7\u00e3o para exames, conv\u00eanios, m\u00e9dicos selecionados", "integracao/sel_exp_web.jpg");
        this.panelFiltro.setBorder(new TitledBorder("Filtro"));
        this.panelFiltro.setPreferredSize(new Dimension(210, 100));
        this.montaFiltros();
        this.montaCentro();
        this.buttonFechar.addActionListener(this);
        this.buttonNovo.addActionListener(this);
        this.buttonExportar.addActionListener(this);
        this.habilitaFiltro(false);
        this.buttonNovo.grabFocus();
    }

    private void habilitaFiltro(boolean b) {
        this.itemDestino.setEnabled(b);
        this.itemMedico.setEnabled(b);
        this.itemConvenio.setEnabled(b);
        this.itemExame.setEnabled(b);
        this.itemPaciente.setEnabled(b);
        this.itemFiscal.setEnabled(b);
        this.itemResponsavel.setEnabled(b);
        this.itemUsuario.setEnabled(b);
        this.buttonExportar.setEnabled(b);
        this.buttonNovo.setEnabled(!b);
    }

    private void montaCentro() {
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridx = 0;
        cons.gridy = 0;
        cons.fill = 1;
        cons.anchor = 18;
        cons.weightx = 1.0;
        cons.weighty = 1.0;
        this.panelCentro.add((Component)this.labelCentro, cons);
        cons.gridy = 1;
        cons.fill = 2;
        cons.anchor = 13;
        cons.weighty = 0.0;
        this.labelTempo.setHorizontalAlignment(4);
        this.panelCentro.add((Component)this.labelTempo, cons);
        cons.gridy = 2;
        this.panelCentro.add((Component)this.progresso, cons);
    }

    private void montaFiltros() {
        this.itemDestino.setDados("destino", new String[]{"des_codigo", "des_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemDestino.setColunaHint(1);
        this.itemMedico.setDados("medico", new String[]{"med_conselho", "med_crm", "med_uf", "med_nome"}, new String[]{"Cons.", "C\u00f3digo", "UF", "Nome"}, new int[]{30, 70, 30, 0});
        this.itemMedico.setColunaHint(3);
        this.itemConvenio.setDados("convenios", new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Fantasia"}, new int[]{70, 0});
        this.itemConvenio.setColunaHint(1);
        this.itemExame.setDados("exames", new String[]{"exa_codigo", "exa_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemExame.setColunaHint(1);
        this.itemUsuario.setDados("usuario", new String[]{"usr_codigo", "usr_nome"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{70, 0});
        this.itemUsuario.setColunaHint(1);
        this.itemPaciente.setDados("paciente", new String[]{"pac_codigo", "pac_nome"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{70, 0});
        this.itemPaciente.setColunaHint(1);
        this.itemFiscal.setDados("entidade", new String[]{"ent_codigo", "ent_fantasia"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{70, 0});
        this.itemFiscal.setColunaHint(1);
        this.itemResponsavel.setDados("entidade", new String[]{"ent_codigo", "ent_fantasia"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{70, 0});
        this.itemResponsavel.setColunaHint(1);
        this.constraints.gridx = 0;
        this.constraints.gridy = 0;
        this.constraints.fill = 2;
        this.constraints.anchor = 17;
        this.constraints.gridwidth = 3;
        this.constraints.weightx = 1.0;
        this.panelFiltro.add((Component)this.itemDestino, this.constraints);
        this.constraints.gridy = 1;
        this.panelFiltro.add((Component)this.itemMedico, this.constraints);
        this.constraints.gridy = 2;
        this.panelFiltro.add((Component)this.itemConvenio, this.constraints);
        this.constraints.gridy = 3;
        this.panelFiltro.add((Component)this.itemExame, this.constraints);
        this.constraints.gridy = 4;
        this.panelFiltro.add((Component)this.itemPaciente, this.constraints);
        this.constraints.gridy = 5;
        this.panelFiltro.add((Component)this.itemFiscal, this.constraints);
        this.constraints.gridy = 6;
        this.panelFiltro.add((Component)this.itemResponsavel, this.constraints);
        this.constraints.gridy = 7;
        this.panelFiltro.add((Component)this.itemUsuario, this.constraints);
        this.constraints.gridy = 8;
        this.constraints.fill = 0;
        this.constraints.anchor = 13;
        this.constraints.gridwidth = 3;
        this.constraints.weightx = 0.0;
        this.buttonExportar.setPreferredSize(new Dimension(100, 20));
        this.buttonExportar.setMinimumSize(new Dimension(100, 20));
        this.panelFiltro.add((Component)this.buttonExportar, this.constraints);
        this.constraints.gridy = 9;
        this.constraints.fill = 1;
        this.constraints.anchor = 17;
        this.constraints.gridwidth = 3;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 1.0;
        this.panelFiltro.add((Component)new JPanel(), this.constraints);
    }

    public static Long getModuloAcesso() {
        return Long.parseLong("0900200000");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonFechar) {
            this.setVisible(false);
        } else if (e.getSource() == this.buttonNovo) {
            this.habilitaFiltro(true);
            this.buttonExportar.grabFocus();
        } else if (e.getSource() == this.buttonExportar) {
            this.buttonExportar.setEnabled(false);
            this.exportaDados();
        }
    }

    private void exportaDados() {
        if (!Variaveis.exportarWebFilial) {
            Funcoes.mensagem(this, "A filial n\u00e3o tem permiss\u00e3o para exportar dados para web", 1);
            this.habilitaFiltro(false);
            this.buttonNovo.grabFocus();
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.buttonFechar.setEnabled(false);
        Exportar exportar = new Exportar(this.progresso, this.labelTempo);
        exportar.setQtdeDestinos(this.itemDestino.isSelected() ? this.itemDestino.getQtdeRegistros() : 0);
        exportar.setQtdeMedicos(this.itemMedico.isSelected() ? this.itemMedico.getQtdeRegistros() : 0);
        exportar.setQtdeConvenios(this.itemConvenio.isSelected() ? this.itemConvenio.getQtdeRegistros() : 0);
        exportar.setQtdeExames(this.itemExame.isSelected() ? this.itemExame.getQtdeRegistros() : 0);
        exportar.setQtdePacientes(this.itemPaciente.isSelected() ? this.itemPaciente.getQtdeRegistros() : 0);
        exportar.setQtdeFiscais(this.itemFiscal.isSelected() ? this.itemFiscal.getQtdeRegistros() : 0);
        exportar.setQtdeResponsaveis(this.itemResponsavel.isSelected() ? this.itemResponsavel.getQtdeRegistros() : 0);
        if (this.itemDestino.isSelected()) {
            exportar.setSelecaoDestino(this.itemDestino.getSelecionados(0));
        }
        if (this.itemMedico.isSelected()) {
            exportar.setSelecaoMedicos(this.itemMedico.getSelecionadosAvancado(0), this.itemMedico.getSelecionadosAvancado(1), this.itemMedico.getSelecionadosAvancado(2));
        }
        if (this.itemConvenio.isSelected()) {
            exportar.setSelecaoConvenio(this.itemConvenio.getSelecionados(0));
        }
        if (this.itemExame.isSelected()) {
            exportar.setSelecaoExame(this.itemExame.getSelecionados(0));
        }
        if (this.itemPaciente.isSelected()) {
            exportar.setSelecaoPaciente(this.itemPaciente.getSelecionados(0));
        }
        if (this.itemFiscal.isSelected()) {
            exportar.setSelecaoFiscal(this.itemFiscal.getSelecionados(0));
        }
        if (this.itemResponsavel.isSelected()) {
            exportar.setSelecaoResponsavel(this.itemResponsavel.getSelecionados(0));
        }
        if (this.itemUsuario.isSelected()) {
            exportar.setSelecaoUsuario(this.itemUsuario.getSelecionados(0));
        }
        exportar.addAvisaFinal(new AvisaFinal(){

            @Override
            public void threadParada() {
                SelecionarWeb.this.habilitaFiltro(false);
                SelecionarWeb.this.buttonFechar.setEnabled(true);
            }
        });
        exportar.start();
        this.setCursor(Cursor.getDefaultCursor());
    }
}

