/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.exportacao;

import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SalvarPdf
extends AbstractDialogoOKCancelar {
    private JLabel labelCaminho = new JLabel("Caminho do documento:");
    private TTextField textCaminho = new TTextField();
    private JButton buttonCaminho = ComponenteFactory.novoJButton(this, true);
    private static final String titulo = "Salvar PDF";

    public static SalvarPdf novaInstancia(Object pai) {
        if (pai instanceof Dialog) {
            return new SalvarPdf((Dialog)pai, titulo);
        }
        return new SalvarPdf((Frame)pai, titulo);
    }

    public SalvarPdf(Dialog pai, String titulo) {
        super(pai, titulo);
        this.montaTela();
    }

    public SalvarPdf(Frame pai, String titulo) {
        super(pai, titulo);
        this.montaTela();
    }

    private void montaTela() {
        this.setSize(new Dimension(370, 95));
        this.setResizable(false);
        this.setModal(true);
        this.setLocationRelativeTo(this.getOwner());
        this.setIconImage(ImagemUtils.carregaImagemJalis("icone64x64.png").getImage());
        this.getBotaoOK().setText("Salvar");
        this.getBotaoOK().setMnemonic('S');
        this.labelCaminho.setMinimumSize(this.labelCaminho.getPreferredSize());
        this.labelCaminho.setMaximumSize(this.labelCaminho.getPreferredSize());
        this.textCaminho.setPreferredSize(new Dimension(1, 20));
        this.buttonCaminho.setPreferredSize(new Dimension(20, 20));
        this.buttonCaminho.setMinimumSize(this.buttonCaminho.getPreferredSize());
        this.buttonCaminho.setMaximumSize(this.buttonCaminho.getPreferredSize());
        this.buttonCaminho.setFocusable(true);
        this.montaListeners();
        JPanel panelCentral = this.getPanelCentral();
        panelCentral.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.getPanelCentral().add((Component)this.labelCaminho, c);
        c.fill = 2;
        ++c.gridx;
        c.weightx = 1.0;
        c.insets = new Insets(0, 10, 0, 0);
        this.getPanelCentral().add((Component)this.textCaminho, c);
        c.fill = 0;
        ++c.gridx;
        c.weightx = 0.0;
        c.insets = new Insets(0, 0, 0, 0);
        this.getPanelCentral().add((Component)this.buttonCaminho, c);
    }

    public void setCaminho(String caminho) {
        caminho = caminho.replace("\\\\", "\\");
        this.textCaminho.setText(caminho);
    }

    public String getCaminho() {
        return this.textCaminho.getText();
    }

    private void montaListeners() {
        this.buttonCaminho.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser file = ComponenteFactory.novoJFileChooser("Diret\u00f3rio de integra\u00e7\u00e3o");
                file.setFileSelectionMode(1);
                if (!SalvarPdf.this.textCaminho.getText().isEmpty() && Funcoes.diretorioExiste(SalvarPdf.this.textCaminho.getText())) {
                    file.setCurrentDirectory(new File(SalvarPdf.this.textCaminho.getText()));
                }
                if (file.showSaveDialog(SalvarPdf.this.getParent()) != 0) {
                    return;
                }
                SalvarPdf.this.textCaminho.setText(file.getSelectedFile().getAbsolutePath());
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                super.windowOpened(e);
                ScreenUtil.requisitarFoco(SalvarPdf.this.buttonCaminho);
            }
        });
    }

    @Override
    protected boolean acaoOk() {
        if (!Funcoes.diretorioExiste(this.textCaminho.getText())) {
            Funcoes.mensagem(this.getOwner(), "Caminho informado n\u00e3o foi encontrado.", 2);
            return false;
        }
        return true;
    }
}

