/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.exportacao;

import jalis.comum.Conexao;
import jalis.comum.Pesquisas;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.dados.DadosMaterial;
import jalis.laboratorio.exportacao.DialogoFiltro;
import jalis.laboratorio.exportacao.Exames;
import jalis.laboratorio.exportacao.ExamesRender;
import jalis.laboratorio.exportacao.integracao.IntegracaoUtil;
import jalis.laboratorio.exportacao.thread.ExportaWeb;
import jalis.laboratorio.resultados.ImpressaoResultados;
import jalis.laboratorio.resultados.ResultadosUtil;
import jalis.laboratorio.resultados.RetornoImpressaoResultados;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.util.DBUtil;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.codec.binary.Base64;

public class RequisicaoWeb
extends JPanel
implements ActionListener {
    private JButton buttonNovo = ComponenteFactory.novoJButton("Novo", 'N', this, null, null, true);
    private JButton buttonFechar = ComponenteFactory.novoJButton("Fechar", 'F', this, null, null, true);
    private JButton buttonFiltro = ComponenteFactory.novoJButton("Filtro", 'i', this, null, null, true);
    private JPanel panelBotoes = new JPanel(new BorderLayout());
    private JPanel panelBotoesA = new JPanel(new FlowLayout(0));
    private JPanel panelBotoesB = new JPanel(new FlowLayout(2));
    private JPanel panelRequisicoes = new JPanel(new GridBagLayout());
    private TTextField txtRequisicao = new TTextField(16, 1);
    private JLabel labelRequisicao = ComponenteFactory.novoJLabel("Requisi\u00e7\u00e3o:", 'R', null, null, this.txtRequisicao);
    private ModeloGridTable modeloRequisicao = new ModeloGridTable(new String[]{"Requisi\u00e7\u00e3o", "Paciente"});
    private ModeloGridTable modeloExames = new ModeloGridTable(new String[]{"C\u00f3digo", "Mat.", "Exame", "S"});
    private JTable tableRequisicao = new JTable(this.modeloRequisicao);
    private JTable tableExames = new JTable(this.modeloExames);
    private JScrollPane scrollRequisicao = new JScrollPane(this.tableRequisicao);
    private JScrollPane scrollExames = new JScrollPane(this.tableExames);
    private JButton buttonExportarTodos = ComponenteFactory.novoJButton("Exportar todos", 'E', this, null, null, false);
    private JButton buttonExportar = ComponenteFactory.novoJButton("Exportar", 'm', this, null, null, false);
    private JButton buttonExportarExame = ComponenteFactory.novoJButton("Exportar", 'p', this, null, null, false);
    private JButton buttonBuscaRequisicao = ComponenteFactory.novoJButton((ActionListener)this, null, new Dimension(20, 20), true, false);
    private JPanel panelRequisicao = ComponenteFactory.novoJPanel(new GridBagLayout(), new TitledBorder("Requisi\u00e7\u00f5es"));
    private JPanel panelExames = ComponenteFactory.novoJPanel(new GridBagLayout(), new TitledBorder("Exames"));
    private int status = 1;
    private int COLUNA_REQUISICAO = 0;
    private int COLUNA_PACIENTE = 1;
    private int COLUNA_EXAMES = 2;
    private int COLUNA_EXAME_CODIGO = 0;
    private int COLUNA_EXAME_MATERIAL = 1;
    private int COLUNA_EXAME_DESCRICAO = 2;
    private int COLUNA_EXAME_SITUACAO = 3;
    private final int PROIBIDO_DESTINO = 1;
    private final int REQUISICAO_OK = 2;
    private final int REQUISICAO_REPETIDA = 3;
    private final int FILIAL_NAO_CONFIGURADA = 4;
    private final int REQUISICAO_NAO_INFORMADA = 5;

    public RequisicaoWeb() {
        this.montaTela();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RequisicaoWeb.this.novo();
            }
        });
    }

    private void montaTela() {
        this.setLayout(new BorderLayout());
        Funcoes.criaBarraDescricao(this, "Selecionar requisi\u00e7\u00e3o", "Exporta\u00e7\u00e3o de requisi\u00e7\u00f5es para web", "integracao/sel_exp_req_web.jpg");
        this.add((Component)this.panelBotoes, "South");
        this.add((Component)this.panelRequisicoes, "Center");
        this.panelRequisicoes.setBorder(ScreenUtil.criarBordaVazia());
        this.txtRequisicao.addActionListener(this);
        this.buttonBuscaRequisicao.setFocusable(false);
        this.tableExames.setDefaultRenderer(Object.class, new ExamesRender());
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                if (RequisicaoWeb.this.getParent() != null) {
                    RequisicaoWeb.this.getParent().removeAll();
                }
            }
        });
        this.txtRequisicao.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113 && Funcoes.processarFuncaoNumeroTubo(null, RequisicaoWeb.this.txtRequisicao)) {
                    RequisicaoWeb.this.pesquisaRequisicao();
                } else if (e.getKeyCode() == 10 && Funcoes.processarFuncaoNumeroTubo(null, RequisicaoWeb.this.txtRequisicao)) {
                    RequisicaoWeb.this.processarNumeroTubo();
                }
            }
        });
        Funcoes.montaEnter((JComponent)this.panelBotoes);
        this.panelBotoes.add((Component)this.panelBotoesA, "West");
        this.panelBotoes.add((Component)this.panelBotoesB, "East");
        this.panelBotoesA.add(this.buttonFiltro);
        this.panelBotoesB.add(this.buttonNovo);
        this.panelBotoesB.add(this.buttonFechar);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.panelRequisicao.add((Component)this.scrollRequisicao, c);
        JPanel panelB = new JPanel(new FlowLayout(2));
        c.gridy = 1;
        c.weighty = 0.0;
        this.panelRequisicao.add((Component)panelB, c);
        panelB.add(this.buttonExportarTodos);
        panelB.add(this.buttonExportar);
        c.gridx = 0;
        c.gridy = 0;
        c.weighty = 1.0;
        this.panelExames.add((Component)this.scrollExames, c);
        JPanel panelE = new JPanel(new FlowLayout(2));
        c.gridy = 1;
        c.weighty = 0.0;
        this.panelExames.add((Component)panelE, c);
        panelE.add(this.buttonExportarExame);
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridx = 0;
        cons.gridy = 0;
        cons.fill = 0;
        cons.anchor = 17;
        this.panelRequisicoes.add((Component)this.labelRequisicao, cons);
        cons.gridx = 1;
        this.txtRequisicao.setPreferredSize(new Dimension(100, 20));
        this.txtRequisicao.setMinimumSize(new Dimension(100, 20));
        this.panelRequisicoes.add((Component)this.txtRequisicao, cons);
        cons.gridx = 2;
        this.buttonBuscaRequisicao.setMinimumSize(new Dimension(20, 20));
        this.panelRequisicoes.add((Component)this.buttonBuscaRequisicao, cons);
        cons.gridx = 3;
        cons.fill = 2;
        cons.weightx = 1.0;
        this.panelRequisicoes.add((Component)new JPanel(), cons);
        cons.gridy = 1;
        cons.gridx = 0;
        cons.fill = 1;
        cons.weighty = 1.0;
        cons.gridwidth = 3;
        this.panelRequisicoes.add((Component)this.panelRequisicao, cons);
        cons.gridx = 3;
        cons.gridwidth = 1;
        this.panelRequisicoes.add((Component)this.panelExames, cons);
        this.modeloRequisicao.setColumnSize(new int[]{80, 0}, this.tableRequisicao);
        this.modeloExames.setColumnSize(new int[]{60, 50, 0, 15}, this.tableExames);
        this.tableRequisicao.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                RequisicaoWeb.this.modeloExames.clear();
                if (RequisicaoWeb.this.tableRequisicao.getSelectedRow() < 0 || RequisicaoWeb.this.modeloRequisicao.getValueAt(RequisicaoWeb.this.tableRequisicao.getSelectedRow(), RequisicaoWeb.this.COLUNA_EXAMES) == null) {
                    return;
                }
                ArrayList exames = (ArrayList)RequisicaoWeb.this.modeloRequisicao.getValueAt(RequisicaoWeb.this.tableRequisicao.getSelectedRow(), RequisicaoWeb.this.COLUNA_EXAMES);
                for (Exames exm : exames) {
                    RequisicaoWeb.this.modeloExames.addLine(new Object[]{exm.getCodigo(), exm.getMaterial(), exm.getDescricao(), exm.getSituacao()});
                }
                RequisicaoWeb.this.controlaCampos();
            }
        });
        this.tableExames.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                RequisicaoWeb.this.controlaCampos();
            }
        });
        this.tableRequisicao.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127 && RequisicaoWeb.this.tableRequisicao.getSelectedRow() > -1) {
                    int linha = RequisicaoWeb.this.tableRequisicao.getSelectedRow();
                    RequisicaoWeb.this.modeloRequisicao.removeLine(linha);
                    if (linha < RequisicaoWeb.this.modeloRequisicao.getRowCount()) {
                        RequisicaoWeb.this.tableRequisicao.setRowSelectionInterval(linha, linha);
                    } else {
                        RequisicaoWeb.this.txtRequisicao.grabFocus();
                    }
                }
            }
        });
    }

    private void processarNumeroTubo() {
        if (Funcoes.processarFuncaoNumeroTubo(null, this.txtRequisicao)) {
            int r = this.dadosRequisicao(Variaveis.filialPadrao, this.txtRequisicao.getText());
            switch (r) {
                case 4: {
                    Funcoes.mensagem(this, "A filial n\u00e3o est\u00e1 configurada para enviar exames para internet", 2);
                    this.txtRequisicao.selectAll();
                    this.txtRequisicao.grabFocus();
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    this.txtRequisicao.selectAll();
                    this.txtRequisicao.grabFocus();
                    break;
                }
                case 1: {
                    Funcoes.mensagem(this, "O destino n\u00e3o permite o envio para web", 2);
                    this.txtRequisicao.selectAll();
                    this.txtRequisicao.grabFocus();
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        block19: {
            block23: {
                block22: {
                    block21: {
                        block20: {
                            block18: {
                                if (e.getSource() != this.buttonFechar) break block18;
                                this.setVisible(false);
                                break block19;
                            }
                            if (e.getSource() != this.buttonNovo) break block20;
                            this.novo();
                            break block19;
                        }
                        if (e.getSource() != this.buttonBuscaRequisicao) break block21;
                        this.pesquisaRequisicao();
                        break block19;
                    }
                    if (e.getSource() != this.buttonFiltro) break block22;
                    this.filtrarRequisicoes();
                    break block19;
                }
                if (e.getSource() != this.buttonExportarTodos) break block23;
                this.setCursor(Cursor.getPredefinedCursor(3));
                Statement st = Conexao.getStatement();
                try {
                    boolean exportandoPDF = ExportaWeb.isGerarPdfResultado(st, Variaveis.filialPadrao);
                    Conexao.arquivaSQL();
                    for (int i = 0; i < this.modeloRequisicao.getRowCount(); ++i) {
                        this.exportar(Variaveis.filialPadrao, this.modeloRequisicao.getValueAt(i, this.COLUNA_REQUISICAO).toString(), null, null);
                        if (!exportandoPDF) continue;
                        Thread.sleep(100L);
                    }
                    Conexao.arquivaSQL();
                    Funcoes.mensagem(this, "Exporta\u00e7\u00e3o finalizada", 5);
                }
                catch (Exception ex) {
                    try {
                        try {
                            Conexao.anulaSQL();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
                    }
                    catch (Throwable throwable) {
                        Conexao.fecharStatement(st);
                        throw throwable;
                    }
                    Conexao.fecharStatement(st);
                }
                Conexao.fecharStatement(st);
                this.setCursor(Cursor.getDefaultCursor());
                this.novo();
                break block19;
            }
            if (e.getSource() == this.buttonExportar) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    Conexao.arquivaSQL();
                    this.exportar(Variaveis.filialPadrao, this.modeloRequisicao.getValueAt(this.tableRequisicao.getSelectedRow(), this.COLUNA_REQUISICAO).toString(), null, null);
                    Conexao.arquivaSQL();
                }
                catch (Exception ex) {
                    try {
                        Conexao.anulaSQL();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
                }
                this.setCursor(Cursor.getDefaultCursor());
                Funcoes.mensagem(this, "Exporta\u00e7\u00e3o finalizada", 5);
            } else if (e.getSource() == this.buttonExportarExame) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    Conexao.arquivaSQL();
                    this.exportar(Variaveis.filialPadrao, this.modeloRequisicao.getValueAt(this.tableRequisicao.getSelectedRow(), this.COLUNA_REQUISICAO).toString(), new String[]{this.modeloExames.getValueAt(this.tableExames.getSelectedRow(), this.COLUNA_EXAME_CODIGO).toString()}, new String[]{String.valueOf(((DadosMaterial)this.modeloExames.getValueAt(this.tableExames.getSelectedRow(), this.COLUNA_EXAME_MATERIAL)).getCodigo())});
                    Conexao.arquivaSQL();
                }
                catch (Exception ex) {
                    try {
                        Conexao.anulaSQL();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
                }
                this.setCursor(Cursor.getDefaultCursor());
                Funcoes.mensagem(this, "Exporta\u00e7\u00e3o finalizada", 5);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private int dadosRequisicao(String filial, String codigo) {
        block11: {
            block10: {
                block9: {
                    if (!Variaveis.exportarWebFilial) {
                        return 4;
                    }
                    if (Funcoes.textoVazio(codigo)) {
                        return 5;
                    }
                    st = Conexao.getStatement();
                    exames = new ArrayList<Exames>();
                    buf = new StringBuilder("select a.req_codigo, b.pac_nome, c.des_enviarweb from requisicao a ");
                    buf.append("left join paciente b on a.fil_codigo = b.fil_codigo and a.pac_codigo = b.pac_codigo ");
                    buf.append("left join destino c on a.fil_codigo = c.fil_codigo and a.des_codigo = c.des_codigo ");
                    buf.append("where a.fil_codigo = ");
                    buf.append(filial);
                    buf.append(" and a.req_codigo = ");
                    buf.append(codigo);
                    buf.append(" and a.req_excluida = false ");
                    rs = Conexao.executeQuery(st, buf.toString());
                    if (!rs.next()) ** GOTO lbl67
                    if (this.modeloRequisicao.localizar(0, rs.getString("req_codigo")) <= -1) break block9;
                    var7_8 = 3;
                    Conexao.fecharStatement(new Statement[]{st});
                    return var7_8;
                }
                if (rs.getBoolean("des_enviarweb")) break block10;
                var7_9 = 1;
                Conexao.fecharStatement(new Statement[]{st});
                return var7_9;
            }
            try {
                paciente = rs.getString("pac_nome");
                buf.delete(0, buf.length());
                buf.append("select a.exa_codigo, b.exa_descricao, a.exr_situacao, a.mco_codigo ");
                buf.append("from examerequisicao a ");
                buf.append("left join exames b on a.fil_codigo = b.fil_codigo and a.exa_codigo = b.exa_codigo ");
                buf.append("where a.fil_codigo = ");
                buf.append(filial);
                buf.append(" and a.req_codigo = ");
                buf.append(codigo);
                buf.append(" and a.exr_excluido = false ");
                rs = Conexao.executeQuery(st, buf.toString());
                this.modeloExames.clear();
                while (rs.next()) {
                    mat = ExameUtil.getDadosMaterial(filial, rs.getInt("mco_codigo"));
                    exames.add(new Exames(rs.getString("exa_codigo"), mat, rs.getString("exa_descricao"), rs.getString("exr_situacao")));
                    this.modeloExames.addLine(new Object[]{rs.getString("exa_codigo"), mat, rs.getString("exa_descricao"), rs.getString("exr_situacao")});
                }
                this.modeloRequisicao.addLine(new Object[]{codigo, paciente, exames});
                this.tableRequisicao.setRowSelectionInterval(this.tableRequisicao.getRowCount() - 1, this.tableRequisicao.getRowCount() - 1);
                break block11;
lbl67:
                // 1 sources

                Funcoes.mensagem(this, "Requisi\u00e7\u00e3o n\u00e3o localizada", 2);
            }
            catch (Exception ex) {
                try {
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "RequisicaoWeb (372)");
                }
                catch (Throwable var9_12) {
                    Conexao.fecharStatement(new Statement[]{st});
                    throw var9_12;
                }
                Conexao.fecharStatement(new Statement[]{st});
            }
        }
        Conexao.fecharStatement(new Statement[]{st});
        this.controlaCampos();
        return 2;
    }

    private void filtrarRequisicoes() {
        DialogoFiltro filtro = DialogoFiltro.novaInstancia(this.getTopLevelAncestor());
        filtro.setVisible(true);
        if (filtro.getOk()) {
            for (Registro reg : filtro.getRequisicoesSelecionados()) {
                int r = this.dadosRequisicao(Variaveis.filialPadrao, reg.getString("req_codigo"));
                if (r == 4) {
                    Funcoes.mensagem(this, "A filial n\u00e3o est\u00e1 configurada para enviar exames para internet", 2);
                    this.txtRequisicao.selectAll();
                    this.txtRequisicao.grabFocus();
                    return;
                }
                if (r != 1) continue;
                Funcoes.mensagem(this, "A requisi\u00e7\u00e3o " + reg.getString("req_codigo") + " n\u00e3o pode ser enviada pois o destino n\u00e3o permite", 2);
            }
        }
    }

    private void pesquisaRequisicao() {
        this.txtRequisicao.setFocusable(false);
        Hashtable resultado = Pesquisas.requisicao(this.getTopLevelAncestor(), Variaveis.filialPadrao, false, false, false);
        if (resultado != null) {
            this.txtRequisicao.setText(resultado.get("req_codigo").toString());
        }
        this.txtRequisicao.setFocusable(true);
        this.txtRequisicao.requestFocus();
    }

    private void novo() {
        this.txtRequisicao.clear();
        this.modeloRequisicao.clear();
        this.modeloExames.clear();
        this.status = 2;
        this.controlaCampos();
        this.txtRequisicao.grabFocus();
    }

    private void controlaCampos() {
        this.txtRequisicao.setEnabled(this.status == 2);
        this.buttonBuscaRequisicao.setEnabled(this.status == 2);
        this.buttonExportarTodos.setEnabled(this.status == 2 && this.modeloRequisicao.getRowCount() > 0);
        this.buttonExportar.setEnabled(this.status == 2 && this.modeloRequisicao.getRowCount() > 0 && this.tableRequisicao.getSelectedRow() > -1);
        this.buttonExportarExame.setEnabled(this.status == 2 && this.modeloExames.getRowCount() > 0 && this.tableExames.getSelectedRow() > -1);
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0900300000");
    }

    public void pressioneiF2() {
        if (this.txtRequisicao.hasFocus()) {
            this.pesquisaRequisicao();
        }
    }

    private void exportar(String filial, String requisicao, String[] exames, String[] materiais) throws Exception {
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        Statement st3 = Conexao.getStatement();
        StringBuilder buf = new StringBuilder();
        String codigoBaseWeb = ExportaWeb.getCodigoBaseWeb(st, filial);
        boolean resultadoPdf = ExportaWeb.isGerarPdfResultado(st, filial);
        buf.append("select a.pac_codigo, b.pac_nome, b.pac_senhaweb, b.pac_nome, b.pac_cpf, b.pac_sif, b.pac_datanasc, ");
        buf.append("a.req_data,  a.req_hora, c.des_descricao, d.col_descricao, a.con_codigo, ");
        buf.append("a.req_idade, a.req_anomes, b.pac_datanasc, a.req_senhaweb, a.med_conselho, a.med_crm, ");
        buf.append("a.med_uf, a.req_totpago, a.req_total, a.req_deveguia, a.des_codigo, ");
        buf.append("a.req_datarecebimentoproduto, a.req_horarecebimentoproduto, a.req_datacoletaproduto, a.req_horacoletaproduto, ");
        buf.append("a.req_descricaoproduto, a.req_numeroloteproduto, a.ent_codigo, a.req_lacreproduto ");
        buf.append("from requisicao a ");
        buf.append("left join paciente b on a.fil_codigo = b.fil_codigo and a.pac_codigo = b.pac_codigo ");
        buf.append("left join destino c on a.fil_codigo = c.fil_codigo and a.des_codigo = c.des_codigo ");
        buf.append("left join coletas d on a.fil_codigo = d.fil_codigo and a.col_codigo = d.col_codigo ");
        buf.append("where a.fil_codigo = ");
        buf.append(filial);
        buf.append(" and a.req_codigo = ");
        buf.append(requisicao);
        buf.append(" and a.req_excluida = false ");
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        if (rs.next()) {
            String[] paciente = new String[]{"codigoBase", codigoBaseWeb, "codigoPaciente", rs.getString("pac_codigo"), "nomePaciente", rs.getString("pac_nome"), "senhaPaciente", rs.getString("pac_senhaweb"), "cpfPaciente", rs.getString("pac_cpf"), "sifPaciente", rs.getString("pac_sif")};
            DBUtil.insereExportaWeb(st2, "paciente", "I", paciente);
            String[] comandoRequisicao = new String[54];
            comandoRequisicao[0] = "codigoBase";
            comandoRequisicao[1] = codigoBaseWeb;
            comandoRequisicao[2] = "codigoRequisicao";
            comandoRequisicao[3] = IntegracaoUtil.formataCodigoRequisicao(filial, requisicao, st2);
            comandoRequisicao[4] = "dataRequisicao";
            comandoRequisicao[5] = Funcoes.formataData(rs.getDate("req_data"));
            comandoRequisicao[6] = "horaRequisicao";
            comandoRequisicao[7] = rs.getString("req_hora");
            comandoRequisicao[8] = "destinoRequisicao";
            comandoRequisicao[9] = rs.getString("des_descricao");
            comandoRequisicao[10] = "coletaRequisicao";
            comandoRequisicao[11] = rs.getString("col_descricao");
            comandoRequisicao[12] = "codigoConvenioRequisicao";
            comandoRequisicao[13] = rs.getString("con_codigo");
            comandoRequisicao[14] = "idadeRequisicao";
            comandoRequisicao[15] = rs.getString("req_idade") + " " + Tipos.tipoIdade(rs.getString("req_anomes"));
            comandoRequisicao[16] = "dataNascimentoRequisicao";
            comandoRequisicao[17] = !DBUtil.campoNull(rs.getString("pac_datanasc")) ? Funcoes.formataData(rs.getDate("pac_datanasc")) : "";
            comandoRequisicao[18] = "senhaRequisicao";
            comandoRequisicao[19] = rs.getString("req_senhaweb");
            comandoRequisicao[20] = "conselhoMedicoRequisicao";
            comandoRequisicao[21] = rs.getString("med_conselho");
            comandoRequisicao[22] = "crmMedicoRequisicao";
            comandoRequisicao[23] = rs.getString("med_crm");
            comandoRequisicao[24] = "ufMedicoRequisicao";
            comandoRequisicao[25] = rs.getString("med_uf");
            comandoRequisicao[26] = "valorPagoRequisicao";
            comandoRequisicao[27] = Funcoes.limpaDecimal(rs.getString("req_totpago"));
            comandoRequisicao[28] = "valorRequisicao";
            comandoRequisicao[29] = Funcoes.limpaDecimal(rs.getString("req_total"));
            comandoRequisicao[30] = "codigoPacienteRequisicao";
            comandoRequisicao[31] = rs.getString("pac_codigo");
            comandoRequisicao[32] = "dadosCabecalhoRequisicao";
            HashMap<String, Object> cabec = RecepcaoUtil.getHashDadosCabecalho(filial, requisicao);
            comandoRequisicao[33] = RecepcaoUtil.mapToStringPHP(cabec);
            comandoRequisicao[34] = "codigoDestinoRequisicao";
            comandoRequisicao[35] = rs.getString("des_codigo");
            comandoRequisicao[36] = "entidadeRequisicao";
            comandoRequisicao[37] = DBUtil.campoNull(rs.getString("ent_codigo")) ? "null" : rs.getString("ent_codigo");
            comandoRequisicao[38] = "resultadoPdfRequisicao";
            String tmp = "";
            if (ExportaWeb.isGerarPdfResultado(st2, filial)) {
                RetornoImpressaoResultados retorno = ImpressaoResultados.imprimirExamesPdfWeb(filial, requisicao, false);
                tmp = retorno.getResultadoPdfWeb() != null ? new Base64().encodeAsString(retorno.getResultadoPdfWeb()) : "";
            }
            comandoRequisicao[39] = tmp;
            comandoRequisicao[40] = "dataRecebimentoProdutoRequisicao";
            comandoRequisicao[41] = DBUtil.campoNull(rs.getString("req_datarecebimentoproduto")) ? "null" : Funcoes.formataData(rs.getDate("req_datarecebimentoproduto"));
            comandoRequisicao[42] = "dataColetaProdutoRequisicao";
            comandoRequisicao[43] = DBUtil.campoNull(rs.getString("req_datacoletaproduto")) ? "null" : Funcoes.formataData(rs.getDate("req_datacoletaproduto"));
            comandoRequisicao[44] = "horaRecebimentoProdutoRequisicao";
            comandoRequisicao[45] = DBUtil.campoNull(rs.getString("req_horarecebimentoproduto")) ? "null" : Funcoes.formataData("HH:mm", rs.getTimestamp("req_horarecebimentoproduto"));
            comandoRequisicao[46] = "horaColetaProdutoRequisicao";
            comandoRequisicao[47] = DBUtil.campoNull(rs.getString("req_horacoletaproduto")) ? "null" : Funcoes.formataData("HH:mm", rs.getTimestamp("req_horacoletaproduto"));
            comandoRequisicao[48] = "descricaoProdutoRequisicao";
            comandoRequisicao[49] = rs.getString("req_descricaoproduto");
            comandoRequisicao[50] = "numeroLoteProdutoRequisicao";
            comandoRequisicao[51] = rs.getString("req_numeroloteproduto");
            comandoRequisicao[52] = "lacreProdutoRequisicao";
            comandoRequisicao[53] = rs.getString("req_lacreproduto");
            boolean deveGuia = rs.getBoolean("req_deveguia");
            DBUtil.insereExportaWeb(st2, "requisicao", deveGuia ? "D" : "I", comandoRequisicao);
            buf.delete(0, buf.length());
            buf.append("select a.fil_codigo, a.exa_codigo, a.mco_codigo, b.mco_descricao, a.exr_situacao, a.exr_dataassina, a.usr_codassina, ");
            buf.append("c.usr_nome, pegaResultadoExame(a.fil_codigo, a.req_codigo, a.exa_codigo, a.mco_codigo) as exr_resultado, a.exr_datamaterial, a.met_codigo ");
            buf.append("from examerequisicao a ");
            buf.append("left join materialcoleta b on a.fil_codigo = b.fil_codigo and a.mco_codigo = b.mco_codigo ");
            buf.append("left join usuario c on a.usr_codassina = c.usr_codigo ");
            buf.append("where a.fil_codigo = ");
            buf.append(filial);
            buf.append(" and a.req_codigo = ");
            buf.append(requisicao);
            buf.append(" and a.exr_excluido = false ");
            if (exames != null && exames.length == materiais.length) {
                buf.append(" and (");
                for (int j = 0; j < exames.length; ++j) {
                    buf.append("(a.exa_codigo = '");
                    buf.append(exames[j]);
                    buf.append("' and a.mco_codigo = ");
                    buf.append(materiais[j]);
                    buf.append(")");
                    if (j >= exames.length - 1) continue;
                    buf.append(" or ");
                }
                buf.append(") ");
            }
            ResultSet rs2 = Conexao.executeQuery(st3, buf.toString());
            while (rs2.next()) {
                String[] comandoExameRequisicao = new String[36];
                comandoExameRequisicao[0] = "codigoBase";
                comandoExameRequisicao[1] = codigoBaseWeb;
                comandoExameRequisicao[2] = "codigoRequisicao";
                comandoExameRequisicao[3] = IntegracaoUtil.formataCodigoRequisicao(filial, requisicao, st2);
                comandoExameRequisicao[4] = "codigoExameRequisicao";
                comandoExameRequisicao[5] = rs2.getString("exa_codigo");
                comandoExameRequisicao[6] = "materialExameRequisicao";
                comandoExameRequisicao[7] = rs2.getString("mco_codigo");
                comandoExameRequisicao[8] = "descricaoMaterialExameRequisicao";
                comandoExameRequisicao[9] = rs2.getString("mco_descricao");
                comandoExameRequisicao[10] = "dataColetaExameRequisicao";
                comandoExameRequisicao[11] = !DBUtil.campoNull(rs2.getString("exr_datamaterial")) ? Funcoes.formataData("dd/MM/yyyy", rs2.getDate("exr_datamaterial")) : "";
                comandoExameRequisicao[12] = "horaColetaExameRequisicao";
                comandoExameRequisicao[13] = !DBUtil.campoNull(rs2.getString("exr_datamaterial")) ? Funcoes.formataHora(rs2.getDate("exr_datamaterial"), false) : "";
                comandoExameRequisicao[14] = "paginaExameRequisicao";
                comandoExameRequisicao[15] = "null";
                comandoExameRequisicao[16] = "ordemExameRequisicao";
                comandoExameRequisicao[17] = "null";
                comandoExameRequisicao[18] = "situacaoExameRequisicao";
                comandoExameRequisicao[19] = rs2.getString("exr_situacao");
                comandoExameRequisicao[20] = "assinaturaExameRequisicao";
                comandoExameRequisicao[21] = !DBUtil.campoNull(rs2.getString("exr_dataassina")) ? rs2.getString("usr_codassina") : "";
                comandoExameRequisicao[22] = "nomeAssinaturaExameRequisicao";
                comandoExameRequisicao[23] = !DBUtil.campoNull(rs2.getString("exr_dataassina")) ? rs2.getString("usr_nome") : "";
                comandoExameRequisicao[24] = "resultadoExameRequisicao";
                Map<String, Object> map = null;
                if (resultadoPdf) {
                    comandoExameRequisicao[25] = "";
                    comandoExameRequisicao[29] = "";
                } else {
                    String resultadoTexto;
                    String resultadoXML = rs2.getString("exr_resultado");
                    String resultado = "";
                    if (!Funcoes.textoVazio(resultadoXML)) {
                        map = ResultadosUtil.geraResultadoParaWeb(st2, filial, requisicao, rs2.getString("exa_codigo"), rs2.getString("mco_codigo"), resultadoXML, false, -1, true);
                        resultado = map != null && map.get("laudo") != null ? (String)map.get("laudo") : "";
                    }
                    comandoExameRequisicao[25] = resultado;
                    comandoExameRequisicao[29] = resultadoTexto = ResultadosUtil.geraResultadoTextoParaWeb(st2, filial, rs.getString("con_codigo"), rs.getString("des_codigo"), rs.getInt("req_idade"), rs.getString("req_anomes"), rs2.getString("exa_codigo"), rs2.getInt("mco_codigo"), rs2.getString("met_codigo"), resultadoXML);
                }
                comandoExameRequisicao[26] = "dataEnvioExameRequisicao";
                comandoExameRequisicao[27] = "current_timestamp";
                comandoExameRequisicao[28] = "resultadoTextoExameRequisicao";
                comandoExameRequisicao[30] = "codigoUsuarioConferenciaExameRequisicao";
                comandoExameRequisicao[31] = rs2.getString("usr_codassina");
                DBUtil.insereExportaWeb(filial, st2, "requisicaoexame", "I", true, comandoExameRequisicao);
                if (!resultadoPdf && null != map) {
                    this.inserirRequisicaoExameImagemWeb(st3, rs2.getString("exa_codigo"), rs2.getString("mco_codigo"), (Map)map.get("imagens"), rs2.getString("fil_codigo"), IntegracaoUtil.formataCodigoRequisicao(filial, requisicao, st2));
                }
                ExportaWeb.atualizaPaginaOrdemExameWeb(st2, filial, requisicao, Variaveis.codigoBaseWeb);
            }
        }
        Conexao.fecharStatement(st);
        Conexao.fecharStatement(st2);
        Conexao.fecharStatement(st3);
    }

    private void inserirRequisicaoExameImagemWeb(Statement st, String exame, String material, Map<Integer, String> imagens, String filial, String requisicao) throws Exception {
        if (imagens != null && !imagens.isEmpty()) {
            this.removerRequisicaoExameImagemWeb(st, exame, material, filial, requisicao);
            ArrayList<String> tmp = new ArrayList<String>();
            tmp.add("codigoRequisicao");
            tmp.add(IntegracaoUtil.formataCodigoRequisicao(filial, requisicao, st));
            tmp.add("codigoBase");
            tmp.add(ExportaWeb.getCodigoBaseWeb(st, filial));
            tmp.add("codigoExameRequisicao");
            tmp.add(exame);
            tmp.add("materialExameRequisicao");
            tmp.add(material);
            ArrayList<String> aux = new ArrayList<String>();
            for (Integer indice : imagens.keySet()) {
                aux.addAll(tmp);
                aux.add("codigoImagemExame");
                aux.add(indice.toString());
                aux.add("imagemExame");
                aux.add(imagens.get(indice));
                DBUtil.insereExportaWeb(filial, st, "requisicaoexameimagem", "I", true, aux.toArray(new String[aux.size()]));
                aux.clear();
            }
        }
    }

    private void removerRequisicaoExameImagemWeb(Statement st, String exame, String material, String filial, String requisicao) throws SQLException {
        String req = IntegracaoUtil.formataCodigoRequisicao(filial, requisicao, st);
        DBUtil.insereExportaWeb(filial, st, "requisicaoexameimagem", "D", true, "codigoRequisicao", req, "codigoBase", ExportaWeb.getCodigoBaseWeb(st, filial), "codigoExameRequisicao", exame, "materialExameRequisicao", material);
    }
}

