/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.exportacao;

import jalis.util.Funcoes;

public class ObjetoDados {
    private String prontuario = null;
    private String nomePaciente = null;
    private String dataColeta = null;
    private String codigoExame = null;
    private String cpfPaciente = null;
    private String dataNascimento = null;
    private String sexoPaciente = null;
    private String linha = null;
    private int numeroLinha = -1;

    public ObjetoDados(String linha, int numeroLinha) {
        this.linha = linha;
        this.prontuario = linha.substring(0, 10).trim();
        this.nomePaciente = linha.substring(10, 50).trim();
        this.dataColeta = linha.substring(50, 60).trim();
        this.codigoExame = linha.substring(60, 80).trim();
        this.cpfPaciente = linha.substring(80, 91).trim();
        this.dataNascimento = linha.substring(91, 101).trim();
        this.sexoPaciente = linha.substring(101, 102).trim();
        this.numeroLinha = numeroLinha;
        if (!Funcoes.textoVazio(this.dataNascimento)) {
            String ano = this.dataNascimento.substring(6, 10);
            String mes = this.dataNascimento.substring(3, 5);
            String dia = this.dataNascimento.substring(0, 2);
            this.dataNascimento = ano + "-" + mes + "-" + dia;
        }
    }

    public int getTamanhoLinha() {
        return Funcoes.textoVazio(this.linha) ? 0 : this.linha.length();
    }

    public String getProntuario() {
        return this.prontuario;
    }

    public String getNomePaciente() {
        return this.nomePaciente;
    }

    public String getDataColeta() {
        return this.dataColeta;
    }

    public String getCodigoExame() {
        return this.codigoExame;
    }

    public String getCpfPaciente() {
        return this.cpfPaciente;
    }

    public String getDataNascimento() {
        return this.dataNascimento;
    }

    public String getSexoPaciente() {
        return this.sexoPaciente;
    }
}

