/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.exportacao;

import jalis.comum.ConstantesGerais;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

class JanelaConfiguracoes
extends AbstractDialogoOKCancelar {
    private TTextField textAno = new TTextField(4, 1);
    private JComboBox comboMes = new JComboBox<String>(ConstantesGerais.MESES_ANO);
    private JLabel labelAno = new JLabel("Ano refer\u00eancia:");
    private JLabel labelMes = new JLabel("M\u00eas refer\u00eancia:");
    private String mes = null;
    private String ano = null;

    public static JanelaConfiguracoes novaInstancia(Window pai, String ano, String mes) {
        if (pai instanceof Frame) {
            return new JanelaConfiguracoes((Frame)pai, ano, mes);
        }
        if (pai instanceof Dialog) {
            return new JanelaConfiguracoes((Dialog)pai, ano, mes);
        }
        return null;
    }

    private JanelaConfiguracoes(Dialog pai, String ano, String mes) {
        super(pai, "Configura\u00e7\u00f5es");
        this.mes = mes;
        this.ano = ano;
        this.montaTela();
    }

    private JanelaConfiguracoes(Frame pai, String ano, String mes) {
        super(pai, "Configura\u00e7\u00f5es");
        this.mes = mes;
        this.ano = ano;
        this.montaTela();
    }

    private void montaTela() {
        JPanel panelCentral = this.getPanelCentral();
        panelCentral.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 0, 0);
        c.weightx = 0.0;
        c.weighty = 0.0;
        panelCentral.add((Component)this.labelAno, c);
        ++c.gridx;
        this.textAno.setMinimumSize(new Dimension(90, 20));
        this.textAno.setPreferredSize(new Dimension(90, 20));
        panelCentral.add((Component)this.textAno, c);
        ++c.gridy;
        c.gridx = 0;
        panelCentral.add((Component)this.labelMes, c);
        ++c.gridx;
        panelCentral.add((Component)this.comboMes, c);
        ++c.gridx;
        c.weightx = 1.0;
        panelCentral.add((Component)new JLabel(), c);
        this.setSize(200, 120);
        this.setResizable(false);
        ScreenUtil.centralizar(this);
        this.carregaDados();
        ScreenUtil.requisitarFoco(this.textAno);
    }

    private void carregaDados() {
        if (!Funcoes.textoVazio(this.mes)) {
            int mesAux = Integer.parseInt(this.mes);
            this.comboMes.setSelectedItem(ConstantesGerais.MESES_ANO[--mesAux]);
        } else {
            this.comboMes.setSelectedIndex(0);
        }
        if (!Funcoes.textoVazio(this.ano)) {
            this.textAno.setText(this.ano);
        }
    }

    public String getAnoReferencia() {
        if (Funcoes.textoVazio(this.textAno)) {
            return null;
        }
        return this.textAno.getText();
    }

    public String getMesReferencia() {
        int mesAux = this.comboMes.getSelectedIndex();
        return Funcoes.preencheZero(++mesAux, 2);
    }

    private boolean validaCampos() {
        if (Funcoes.textoVazio(this.textAno)) {
            return false;
        }
        return this.comboMes.getSelectedIndex() != -1;
    }

    @Override
    protected boolean acaoOk() {
        return this.validaCampos();
    }
}

